<?php $__env->startSection('content'); ?>
<?php 
use App\Models\Shipping\ShippmentProducts;
?> 
    <title><?php echo e(trans('admin.ShipmentSechdule')); ?></title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> <?php echo e(trans('admin.Shipping')); ?></a></li>
            <li class="breadcrumb-item active"><?php echo e(trans('admin.ShipmentSechdule')); ?></li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        
        
        
        <div class="row">
            
                      <!-- Filter -->
        <form action="<?php echo e(url('FilterShipmentSechdule')); ?>" method="get">
        <div class="row">
            

            <div class="col-md-3">
                <label><?php echo e(trans('admin.From')); ?></label>
                <input class="form-control" name="From" type="date" value="<?php echo e(date('Y-m-d')); ?>">
            </div>
            
            <div class="col-md-3">
                <label><?php echo e(trans('admin.To')); ?></label>
                <input class="form-control" name="To" type="date" value="<?php echo e(date('Y-m-d')); ?>">
            </div>
            
            
            <div class="col-md-3">
                <label><?php echo e(trans('admin.Sender')); ?></label>
            <select class="select2 form-control" name="Sender" id="Sender" >
                <option value=""><?php echo e(trans('admin.Sender')); ?></option>
                
                
                </select>
            </div>
                

            <div class="col-md-3">
                <label><?php echo e(trans('admin.Receiver')); ?></label>
                <select class="select2 form-control" name="Receiver" id="Receiver">
                    <option value=""><?php echo e(trans('admin.Receiver')); ?></option>


                </select>
            </div>

         
            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Shipment_Class')); ?></label>
                <select class="select2 form-control" name="Shipment_Class" id="Shipment_Class" >
                    <option value=""><?php echo e(trans('admin.Shipment_Class')); ?></option>
                    <option value="Hub"><?php echo e(trans('admin.Hub_to_Hub')); ?></option>
                    <option value="Door"><?php echo e(trans('admin.Door_to_Door')); ?></option>
                    <option value="Stored"><?php echo e(trans('admin.Stored_Shipping')); ?></option>
                    <option value="HubToDoor"><?php echo e(trans('admin.Hub_to_Door')); ?></option>
                    <option value="DoorToHub"><?php echo e(trans('admin.Door_to_Hub')); ?></option>
                </select>
            </div>

            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Payment_Method')); ?></label>
                <select class="select2 form-control" name="Payment_Method" id="Payment_Method" >
                    <option value=""><?php echo e(trans('admin.Payment_Method')); ?></option>
                    <option value="Cash"><?php echo e(trans('admin.Cash')); ?></option>
                    <option value="Later"><?php echo e(trans('admin.Later')); ?></option>
                    <option value="Visa"><?php echo e(trans('admin.Visa')); ?></option>
                    <option value="Electronic_Wallet"><?php echo e(trans('admin.Electronic_Wallet')); ?></option>
                </select>
            </div>


            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Shipment_Type')); ?></label>
                <select class="select2 form-control" name="Shipment_Type" id="Shipment_Type" >
                    <option value=""><?php echo e(trans('admin.Shipment_Type')); ?></option>
                    <option value="Shipping"><?php echo e(trans('admin.Shipping')); ?></option>
                    <option value="CollectionShippingDeposit"><?php echo e(trans('admin.CollectionShippingDeposit')); ?></option>
                    <option value="CollectionShipping"><?php echo e(trans('admin.CollectionShipping')); ?></option>
                    <option value="ReturnShipping"><?php echo e(trans('admin.ReturnShipping')); ?></option>
                </select>
            </div>
            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Shipment_Category')); ?></label>
                <select class="select2 form-control" name="Shipment_Category" id="Shipment_Category" >
                    <option value=""><?php echo e(trans('admin.Shipment_Category')); ?></option>
                    <?php $__currentLoopData = $Categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($cat->id); ?>">
                        <?php echo e(app()->getLocale() == 'ar' ?$cat->Arabic_Name :$cat->English_Name); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            
            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Shipment_Rqst_Type')); ?></label>
                <select class="select2 form-control" name="Shipment_Rqst_Type" id="Shipment_Rqst_Type">
                    <option value=""><?php echo e(trans('admin.Shipment_Rqst_Type')); ?></option>
                    <?php $__currentLoopData = $RqstTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Rtype): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($Rtype->id); ?>">
                        <?php echo e(app()->getLocale() == 'ar' ?$Rtype->Arabic_Name :$Rtype->English_Name); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>



            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Delegate')); ?></label>
                <select class="select2 form-control" name="Delegate" id="Delegate">
                    <option value=""><?php echo e(trans('admin.Delegate')); ?></option>
                </select>
            </div>
            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Driver')); ?></label>
                <select class="select2 form-control" name="Driver" id="Driver">
                    <option value=""><?php echo e(trans('admin.Driver')); ?></option>
                </select>
            </div>


            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput"><?php echo e(trans('admin.FromStore')); ?></label>
                <select class="select2 form-control" name="FromStore" id="FromStore">
                    <option value=""><?php echo e(trans('admin.FromStore')); ?></option>
                </select>
            </div>


            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput"><?php echo e(trans('admin.ToStore')); ?></label>
                <select class="select2 form-control" name="ToStore" id="ToStore">
                    <option value=""><?php echo e(trans('admin.ToStore')); ?></option>
                </select>
            </div>
            
            
             <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Status')); ?></label>
                <select class="select2 form-control" name="Status" id="Status" >
                    <option value=""><?php echo e(trans('admin.Status')); ?></option>
                    <option value="0"><?php echo e(trans('admin.Pending')); ?></option>
                    <option value="1"><?php echo e(trans('admin.Distrbuted')); ?></option>
                    <option value="2"><?php echo e(trans('admin.Moved')); ?></option>
                    <option value="3"><?php echo e(trans('admin.Delivered')); ?></option>
                    <option value="4"><?php echo e(trans('admin.Unloading')); ?></option>
                    <option value="5"><?php echo e(trans('admin.CarBack')); ?></option>
                    <option value="6"><?php echo e(trans('admin.DelegateProcessing')); ?></option>
                    <option value="7"><?php echo e(trans('admin.ClientDelivered')); ?></option>
                </select>
            </div>

            
            
            
                     <div class="col-md-4">
                <label><?php echo e(trans('admin.Barcode')); ?></label>
                <input class="form-control" name="Barcode" type="text">
            </div>

            
            
              <div class="col-md-2">
            <button type="submit" class="btn btn-primary"><i class="fal fa-search"></i></button>      
            </div>
            
            
        </div>
            </form>
        
            
            
            
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i><?php echo e(trans('admin.ShipmentSechdule')); ?></i></span>
                        </h2>

                        <div class="panel-toolbar">

                            <a href="<?php echo e(url('Shipment')); ?>" class="btn btn-default" ><?php echo e(trans('admin.AddNew')); ?></a>
                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                            <?php echo $__env->make('admin.layouts.toolbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> <?php echo $__env->make('admin.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <table 
                                   class="table table-bordered table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                <tr>

                                
                                    <th><?php echo e(trans('admin.Barcode')); ?></th>
                                    <th><?php echo e(trans('admin.Date')); ?></th>
                                    <th><?php echo e(trans('admin.Sender_Name')); ?></th>
                                    <th><?php echo e(trans('admin.Receiver_Name')); ?></th>
                                    <th><?php echo e(trans('admin.Payment_Method')); ?></th>
                                    <th><?php echo e(trans('admin.FromStore')); ?></th>
                                    <th><?php echo e(trans('admin.ToStore')); ?></th>
                                    <th><?php echo e(trans('admin.Total')); ?></th>
                                    <th><?php echo e(trans('admin.Status')); ?></th>
                                    <th><?php echo e(trans('admin.Details')); ?></th>
                                    <th><?php echo e(trans('admin.Sender')); ?></th>
                                    <th><?php echo e(trans('admin.Received')); ?></th>
                                    <th><?php echo e(trans('admin.Cost')); ?></th>
                                    <th><?php echo e(trans('admin.Products')); ?></th>
                                    <th><?php echo e(trans('admin.Actions')); ?></th>

                                </tr>
                                </thead>
                                <tbody>

                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                      
                                        <td><?php echo e($item->Barcode); ?></td>
                                        <td><?php echo e($item->Date); ?></td>
                                     
                                        <td><?php echo e($item->Sender_Name); ?></td>
                                        <td><?php echo e($item->Receiver_Name); ?></td>


                                    
                                        <td>

                                            <?php if($item->Payment_Method == 'Cash'): ?>
                                                <?php echo e(trans('admin.Cash')); ?>

                                            <?php elseif($item->Payment_Method == 'Later'): ?>
                                                <?php echo e(trans('admin.Later')); ?>

                                            <?php elseif($item->Payment_Method == 'Visa'): ?>
                                                <?php echo e(trans('admin.Visa')); ?>

                                            <?php elseif($item->Payment_Method == 'Electronic_Wallet'): ?>
                                                <?php echo e(trans('admin.Electronic_Wallet')); ?>

                                            <?php endif; ?>




                                        </td>

            
                                        <td>

                                            <?php if(!empty($item->Store()->first()->Name)): ?>

                                                <?php echo e($item->Store()->first()->Name); ?>


                                            <?php endif; ?>


                                        </td>
                                        
                                        
                                        <td>

                                            <?php if(!empty($item->ToStore()->first()->Name)): ?>

                                                <?php echo e($item->ToStore()->first()->Name); ?>


                                            <?php endif; ?>


                                        </td>



                                        <td><?php echo e($item->Total); ?></td>
                                        <td>


                                          
                                         <?php echo e($item->Status->desc()); ?>

                                            

                                        </td>

                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Details<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.Details')); ?></button>
                                        </td>


                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Sender<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.Sender')); ?></button>
                                        </td>


                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Received<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.Received')); ?></button>
                                        </td>


                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Cost<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.Cost')); ?></button>
                                        </td>

                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Products<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.Products')); ?></button>
                                        </td>


                                        <td class="text-center">

                                             <?php if($item->Status == 0): ?>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center<?php echo e($item->id); ?>"><i class="fal fa-trash"></i></button>


                                    
                                            <a href="<?php echo e(url('EditShipment/'.$item->id)); ?>" class="btn btn-default" ><i class="fal fa-edit"></i></a>
                                            <?php endif; ?>
                                            
          <div class="dropdown d-inline-block">

    <button class="btn btn-outline-secondary dropdown-toggle" type="button" id="printMenuButton<?php echo e($item->id); ?>" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        <i class="fal fa-print"></i>
    </button>
    
    <div class="dropdown-menu" aria-labelledby="printMenuButton<?php echo e($item->id); ?>">
        <a class="dropdown-item" href="<?php echo e(url('PrintShipment/'.$item->id.'?type=A4')); ?>">
            <i class="fal fa-print"></i> A4
        </a>
        <a class="dropdown-item" href="<?php echo e(url('PrintShipment/'.$item->id.'?type=A5')); ?>">
            <i class="fal fa-print"></i> A5
        </a>
        <a class="dropdown-item" href="<?php echo e(url('PrintShipment8/'.$item->id)); ?>">
            <i class="fal fa-print"></i> 8CM
        </a>
        <a class="dropdown-item" href="<?php echo e(url('PrintShipment/'.$item->id.'?type=Barcode')); ?>">
            <i class="fal fa-print"></i> Barcode
        </a>
    </div>
</div>                                        
                                                

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                </tbody>
                                <tfoot>
                                <tr>
                                       <th><?php echo e(trans('admin.Barcode')); ?></th>
                                    <th><?php echo e(trans('admin.Date')); ?></th>
                                    <th><?php echo e(trans('admin.Sender_Name')); ?></th>
                                    <th><?php echo e(trans('admin.Receiver_Name')); ?></th>
                                    <th><?php echo e(trans('admin.Payment_Method')); ?></th>
                                    <th><?php echo e(trans('admin.FromStore')); ?></th>
                                    <th><?php echo e(trans('admin.ToStore')); ?></th>
                                    <th><?php echo e(trans('admin.Total')); ?></th>
                                    <th><?php echo e(trans('admin.Status')); ?></th>
                                    <th><?php echo e(trans('admin.Details')); ?></th>
                                    <th><?php echo e(trans('admin.Sender')); ?></th>
                                    <th><?php echo e(trans('admin.Received')); ?></th>
                                    <th><?php echo e(trans('admin.Cost')); ?></th>
                                    <th><?php echo e(trans('admin.Products')); ?></th>
                                    <th><?php echo e(trans('admin.Actions')); ?></th>

                                </tr>
                                </tfoot>
                            </table>
                            <?php echo e($items->Links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>


        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <!-- Modal Delete -->
            <div class="modal fade" id="default-example-modal-center<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                <?php echo e(trans('admin.RUSWDT')); ?>

                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?php echo e(trans('admin.No')); ?></button>
                            <a href="<?php echo e(url('DeleteShipment/'.$item->id)); ?>"  class="btn btn-primary"> <?php echo e(trans('admin.Yes')); ?></a>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Details -->
            <div class="modal fade" id="Details<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                <?php echo e(trans('admin.Details')); ?>

                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                    
                                        <th><?php echo e(trans('admin.Desc')); ?> </th>
                                        <th><?php echo e(trans('admin.Delegate')); ?> </th>
                                        <th><?php echo e(trans('admin.Driver')); ?> </th>
                                        <th><?php echo e(trans('admin.Note')); ?> </th>
                                        <th><?php echo e(trans('admin.Breakable')); ?> </th>
                                        <th><?php echo e(trans('admin.Delivery_To_Others')); ?> </th>
                                        <th><?php echo e(trans('admin.Shipping_Costs_Included')); ?> </th>
                                        <th><?php echo e(trans('admin.Opening_Package')); ?> </th>
                                        <th><?php echo e(trans('admin.Insurance')); ?> </th>
                                        <th><?php echo e(trans('admin.Safe')); ?> </th>
                                        <th><?php echo e(trans('admin.Coin')); ?> </th>
                                        <th><?php echo e(trans('admin.Draw')); ?> </th>
                                        <th><?php echo e(trans('admin.User')); ?> </th>

                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                         
                                            <td><?php echo e($item->Desc); ?></td>
                                       
                             

                                            <td>
                                                <?php if(!empty($item->Delegate()->first()->Name)): ?>

                                                    <?php echo e($item->Delegate()->first()->Name); ?>


                                                <?php endif; ?>


                                            </td>
                                            <td>

                                                <?php if(!empty($item->Driver()->first()->Name)): ?>

                                                    <?php echo e($item->Driver()->first()->Name); ?>


                                                <?php endif; ?>


                                            </td>

                                            <td><?php echo e($item->Note); ?></td>

                                            <td>

                                                <?php if($item->Breakable == 'Yes'): ?>
                                                    <?php echo e(trans('admin.Yes')); ?>

                                                <?php elseif($item->Breakable == 'No'): ?>
                                                    <?php echo e(trans('admin.No')); ?>

                                                <?php endif; ?>



                                            </td>
                                            <td>

                                                 <?php if($item->Delivery_To_Others == 'Yes'): ?>
                                                    <?php echo e(trans('admin.Yes')); ?>

                                                <?php elseif($item->Delivery_To_Others == 'No'): ?>
                                                    <?php echo e(trans('admin.No')); ?>

                                                <?php endif; ?>

                                            </td>
                                            <td>

                                                 <?php if($item->Shipping_Costs_Included == 'Yes'): ?>
                                                    <?php echo e(trans('admin.Yes')); ?>

                                                <?php elseif($item->Shipping_Costs_Included == 'No'): ?>
                                                    <?php echo e(trans('admin.No')); ?>

                                                <?php endif; ?>

                                            </td>
                                            <td>

                                                 <?php if($item->Opening_Package == 'Yes'): ?>
                                                    <?php echo e(trans('admin.Yes')); ?>

                                                <?php elseif($item->Opening_Package == 'No'): ?>
                                                    <?php echo e(trans('admin.No')); ?>

                                                <?php endif; ?>

                                            </td>
                                             <td>

                                                 <?php if($item->Insurance == 'Yes'): ?>
                                                    <?php echo e(trans('admin.Yes')); ?>

                                                <?php elseif($item->Insurance == 'No'): ?>
                                                    <?php echo e(trans('admin.No')); ?>

                                                <?php endif; ?>

                                            </td>
                                            
                                                      <td>

                                                <?php if(!empty($item->Safe()->first()->Name)): ?>

                                                    <?php echo e($item->Safe()->first()->Name); ?>


                                                <?php endif; ?>


                                            </td>
                                            
                                                       
                                                      <td>

                                                <?php if(!empty($item->Coin()->first()->Arabic_Name)): ?>

                                                    <?php echo e($item->Coin()->first()->Arabic_Name); ?>


                                                <?php endif; ?>


                                            </td>
                                            
                                            
                                                    <td><?php echo e($item->Draw); ?></td>
                                            
                                            




                                            <td>

                                                <?php if(!empty($item->User()->first()->name)): ?>

                                                    <?php echo e($item->User()->first()->name); ?>


                                                <?php endif; ?>


                                            </td>



                                        </tr>

                                    </tbody>
                                </table>
                            </div>


                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                    <th><?php echo e(trans('admin.Code')); ?></th>
                                    <th><?php echo e(trans('admin.Time')); ?></th>
                                    <th><?php echo e(trans('admin.Shipment_Class')); ?></th>
                                    <th><?php echo e(trans('admin.Shipment_Type')); ?></th>
                                    <th><?php echo e(trans('admin.Shipment_Rqst_Type')); ?></th>
                                    <th><?php echo e(trans('admin.Shipment_Category')); ?></th>
                                        
                                        <th><?php echo e(trans('admin.Pieces_Num')); ?> </th>
                                        <th><?php echo e(trans('admin.Reference_Num')); ?> </th>
                                        <th><?php echo e(trans('admin.Weight')); ?> </th>
                                        <th><?php echo e(trans('admin.Length')); ?> </th>
                                        <th><?php echo e(trans('admin.Width')); ?> </th>
                                        <th><?php echo e(trans('admin.Height')); ?> </th>
                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>


                                            <td><?php echo e($item->Code); ?></td>
                                            <td><?php echo e($item->Time); ?></td>
                                            <td>

                                                <?php if($item->Shipment_Class == 'Hub'): ?>
                                                <?php echo e(trans('admin.Hub_to_Hub')); ?>

                                                <?php elseif($item->Shipment_Class == 'Door'): ?>
                                                <?php echo e(trans('admin.Door_to_Door')); ?>

                                                <?php elseif($item->Shipment_Class == 'Stored'): ?>
                                                <?php echo e(trans('admin.Stored_Shipping')); ?>

                                                <?php elseif($item->Shipment_Class == 'HubToDoor'): ?>
                                                <?php echo e(trans('admin.Hub_to_Door')); ?>

                                                <?php elseif($item->Shipment_Class == 'DoorToHub'): ?>
                                                <?php echo e(trans('admin.Door_to_Hub')); ?>

                                                <?php endif; ?>


                                            </td>
                                            <td>

                                                <?php if($item->Shipment_Type == 'Shipping'): ?>
                                                <?php echo e(trans('admin.Shipping')); ?>

                                                <?php elseif($item->Shipment_Type == 'CollectionShippingDeposit'): ?>
                                                <?php echo e(trans('admin.CollectionShippingDeposit')); ?>

                                                <?php elseif($item->Shipment_Type == 'CollectionShipping'): ?>
                                                <?php echo e(trans('admin.CollectionShipping')); ?>

                                                <?php elseif($item->Shipment_Type == 'ReturnShipping'): ?>
                                                <?php echo e(trans('admin.ReturnShipping')); ?>


                                                <?php endif; ?>

                                            </td>
                                            <td>

                                                <?php if(!empty($item->Shipment_Rqst_Type()->first()->Arabic_Name)): ?>

                                                <?php echo e($item->Shipment_Rqst_Type()->first()->Arabic_Name); ?>


                                                <?php endif; ?>


                                            </td>
                                            <td>

                                                <?php if(!empty($item->Shipment_Category()->first()->Arabic_Name)): ?>

                                                <?php echo e($item->Shipment_Category()->first()->Arabic_Name); ?>


                                                <?php endif; ?>


                                            </td>
                                            
                                               <td><?php echo e($item->Pieces_Num); ?></td>
                                               <td><?php echo e($item->Reference_Num); ?></td>
                                               <td><?php echo e($item->Weight); ?></td>
                                               <td><?php echo e($item->Length); ?></td>
                                               <td><?php echo e($item->Width); ?></td>
                                               <td><?php echo e($item->Height); ?></td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?php echo e(trans('admin.Close')); ?></button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Sender -->
            <div class="modal fade" id="Sender<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                <?php echo e(trans('admin.Sender')); ?>

                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th><?php echo e(trans('admin.Name')); ?> </th>
                                        <th><?php echo e(trans('admin.Governorate')); ?> </th>
                                        <th><?php echo e(trans('admin.City')); ?> </th>
                                        <th><?php echo e(trans('admin.Place')); ?> </th>
                                        <th><?php echo e(trans('admin.Address')); ?> </th>
                                        <th><?php echo e(trans('admin.Phone1')); ?> </th>
                                        <th><?php echo e(trans('admin.Phone2')); ?> </th>
                                        <th><?php echo e(trans('admin.Location')); ?> </th>
                                        <th><?php echo e(trans('admin.Sender')); ?> </th>

                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                            <td><?php echo e($item->Sender_Name); ?></td>
                                            <td>

                                                <?php if(!empty($item->Sender_Governorate()->first()->Arabic_Name)): ?>

                                                    <?php echo e($item->Sender_Governorate()->first()->Arabic_Name); ?>


                                                <?php endif; ?>


                                            </td>
                                            <td>

                                                <?php if(!empty($item->Sender_City()->first()->Arabic_Name)): ?>

                                                    <?php echo e($item->Sender_City()->first()->Arabic_Name); ?>


                                                <?php endif; ?>


                                            </td>
                                            <td>

                                                <?php if(!empty($item->Sender_Place()->first()->Arabic_Name)): ?>

                                                    <?php echo e($item->Sender_Place()->first()->Arabic_Name); ?>


                                                <?php endif; ?>


                                            </td>

                                            <td><?php echo e($item->Sender_Address); ?></td>
                                            <td><?php echo e($item->Sender_Phone1); ?></td>
                                            <td><?php echo e($item->Sender_Phone2); ?></td>
                                            <td><?php echo e($item->Sender_Location); ?></td>

                                            <td>

                                                <?php if(!empty($item->Sender()->first()->Name)): ?>

                                                    <?php echo e($item->Sender()->first()->Name); ?>


                                                <?php endif; ?>


                                            </td>






                                        </tr>

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?php echo e(trans('admin.Close')); ?></button>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Received -->
            <div class="modal fade" id="Received<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                <?php echo e(trans('admin.Received')); ?>

                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th><?php echo e(trans('admin.Name')); ?> </th>
                                        <th><?php echo e(trans('admin.Governorate')); ?> </th>
                                        <th><?php echo e(trans('admin.City')); ?> </th>
                                        <th><?php echo e(trans('admin.Place')); ?> </th>
                                        <th><?php echo e(trans('admin.Address')); ?> </th>
                                        <th><?php echo e(trans('admin.Phone1')); ?> </th>
                                        <th><?php echo e(trans('admin.Phone2')); ?> </th>
                                        <th><?php echo e(trans('admin.Location')); ?> </th>
                                        <th><?php echo e(trans('admin.Received')); ?> </th>


                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                            <td><?php echo e($item->Receiver_Name); ?></td>
                                            <td>

                                                <?php if(!empty($item->Receiver_Governorate()->first()->Arabic_Name)): ?>

                                                    <?php echo e($item->Receiver_Governorate()->first()->Arabic_Name); ?>


                                                <?php endif; ?>


                                            </td>
                                            <td>

                                                <?php if(!empty($item->Receiver_City()->first()->Arabic_Name)): ?>

                                                    <?php echo e($item->Receiver_City()->first()->Arabic_Name); ?>


                                                <?php endif; ?>


                                            </td>
                                            <td>

                                                <?php if(!empty($item->Receiver_Place()->first()->Arabic_Name)): ?>

                                                    <?php echo e($item->Receiver_Place()->first()->Arabic_Name); ?>


                                                <?php endif; ?>


                                            </td>

                                            <td><?php echo e($item->Receiver_Address); ?></td>
                                            <td><?php echo e($item->Receiver_Phone1); ?></td>
                                            <td><?php echo e($item->Receiver_Phone2); ?></td>
                                            <td><?php echo e($item->Receiver_Location); ?></td>

                                            <td>

                                                <?php if(!empty($item->Received()->first()->Name)): ?>

                                                    <?php echo e($item->Received()->first()->Name); ?>


                                                <?php endif; ?>


                                            </td>






                                        </tr>

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?php echo e(trans('admin.Close')); ?></button>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Cost -->
            <div class="modal fade" id="Cost<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                <?php echo e(trans('admin.Cost')); ?>

                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th><?php echo e(trans('admin.Shipment_Cost')); ?> </th>
                                        <th><?php echo e(trans('admin.Goods_Cost')); ?> </th>
                                        <th><?php echo e(trans('admin.Delivery_Cost')); ?> </th>
                                        <th><?php echo e(trans('admin.Overload_Weight_Cost')); ?> </th>
                                        <th><?php echo e(trans('admin.Collection_Commission')); ?> </th>
                                        <th><?php echo e(trans('admin.Delivery_Commission')); ?> </th>
                                        <th><?php echo e(trans('admin.Return_Cost')); ?> </th>
                                        <th><?php echo e(trans('admin.Total')); ?> </th>
                                        <th><?php echo e(trans('admin.Pay')); ?> </th>



                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                            <td><?php echo e($item->Shipment_Cost); ?></td>
                                            <td><?php echo e($item->Goods_Cost); ?></td>
                                            <td><?php echo e($item->Delivery_Cost); ?></td>
                                            <td><?php echo e($item->Overload_Weight_Cost); ?></td>
                                            <td><?php echo e($item->Collection_Commission); ?></td>
                                            <td><?php echo e($item->Delivery_Commission); ?></td>
                                            <td><?php echo e($item->Return_Cost); ?></td>
                                            <td><?php echo e($item->Total); ?></td>
                                            <td><?php echo e($item->Pay); ?></td>





                                        </tr>

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?php echo e(trans('admin.Close')); ?></button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Products -->
            <div class="modal fade" id="Products<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                <?php echo e(trans('admin.Cost')); ?>

                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
  <?php $details=ShippmentProducts::where('Shipment',$item->id)->get(); ?> 
                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th><?php echo e(trans('admin.Name')); ?> </th>
                                        <th><?php echo e(trans('admin.P_Code')); ?> </th>
                                        <th><?php echo e(trans('admin.Unit')); ?> </th>
                                        <th><?php echo e(trans('admin.AvQty')); ?> </th>
                                        <th><?php echo e(trans('admin.Qty')); ?> </th>
                                        <th><?php echo e(trans('admin.Price')); ?> </th>
                                        <th><?php echo e(trans('admin.Total')); ?> </th>
                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $det): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($det->P_Ar_Name); ?> (<?php echo e($det->V_Name); ?>) (<?php echo e($det->VV_Name); ?>)</td>
                                            <td><?php echo e($det->P_Code); ?></td>
                                            <td>
                                                
                                            <?php if(!empty($det->Unit()->first()->Name)): ?>    
                                                <?php echo e($det->Unit()->first()->Name); ?>

                                            <?php endif; ?>
                                            
                                            </td>
                                            <td><?php echo e($det->AvQty); ?></td>
                                            <td><?php echo e($det->Qty); ?></td>
                                            <td><?php echo e($det->Price); ?></td>
                                            <td><?php echo e($det->Total); ?></td>
                            
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        
                                        



                                        
                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?php echo e(trans('admin.Close')); ?></button>
                        </div>
                    </div>
                </div>
            </div>


        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </main>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
 <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/summernote/summernote.css')); ?>">
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/select2/select2.bundle.css')); ?>">

    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/formplugins/summernote/summernote.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/formplugins/select2/select2.bundle.js')); ?>"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


    <!-- Search Select -->
    <script>
        
           
        $(document).ready(function () {
            $(function () {
                $(".select2").select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State",
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0,
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items",
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true,
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm;
                    },
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
                }

                         
     $('#Sender').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllCli',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                
                            
     $('#Receiver').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllCli',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                
                      
                            
     $('#Delegate').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllEmps',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                
                               
     $('#Driver').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllEmps',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                  
          
         $('#FromStore').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllStores',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                 
         $('#ToStore').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllStores',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                  
                  
          

            });
        });
    </script>

           








<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demorabiherp/public_html/resources/views/admin/Shipping/ShipmentSechdule.blade.php ENDPATH**/ ?>