<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title> <?php echo e($title); ?></title>

<style>
@import  url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap');

body {
  font-family: 'Cairo', sans-serif;
  background: #f6f8fa;
  margin: 0;
  padding: 0;
  color: #333;
}

@page  {
  size: A4;
  margin: 10mm;
}

.invoice-container {
  width: 210mm;
  min-height: 297mm;
  margin: auto;
  background: #fff;
  border-radius: 8px;
  box-shadow: 0 0 10px rgba(0,0,0,0.08);
  padding: 15mm;
  border-top: 6px solid #0069d9;
  box-sizing: border-box;
}

/* ======= الهيدر ======= */
.invoice-header {
  display: flex;
  justify-content: space-between;
  align-items: flex-start;
  margin-bottom: 15px;
  gap: 15px;
}

/* اللوجو */
.logo img {
  width: 120px;
  height: auto;
  object-fit: contain;
}

/* بيانات الشركة */
.company-info {
  flex: 2;
  text-align: right;
  font-size: 12px;
}

.company-info h1 {
  margin: 0 0 5px 0;
  color: #0069d9;
}

.invoice-info {
  flex: 1;
  border: 1px solid #ddd;
  border-radius: 6px;
  background: #f9fbfc;
  padding: 6px;
  font-size: 12px;
}

.invoice-info table {
  width: 100%;
  border-collapse: collapse;
  font-size: 12px;
}

.invoice-info td {
  padding: 2px 3px; /* 🔹 تقليل ارتفاع السطور */
  border: 1px solid #eee;
}


/* ======= جدول الأصناف ======= */
.items-table {
  margin-top: 8px; /* 🔹 مسافة بسيطة بين الجدولين */
}

.items-table table {
  width: 100%;
  border-collapse: collapse;
  text-align: center;
  font-size: 12px;
}

.items-table th, .items-table td {
  border: 1px solid #ddd;
  padding: 2px 3px; /* 🔹 تقليل المسافة بين السطور */
}

.items-table th {
  background-color: #e8f1ff;
}

/* ======= الملخص ======= */
.financial-summary {
  margin-top: 12px;
  font-size: 12px;
}

.financial-summary table {
  width: 48%;
  border-collapse: collapse;
  text-align: center;
}

.financial-summary td {
  padding: 3px;
  border: 1px solid #ccc;
}

.financial-summary tr:nth-child(even) {
  background-color: #f9f9f9;
}

.financial-summary tr:nth-child(3) {
  background-color: #f3f3f3;
  font-weight: bold;
}

/* ======= الطباعة ======= */
@media  print {
  body {
    background: #fff;
    margin: 0;
    padding: 0;
  }

  .invoice-container {
    box-shadow: none;
    border: none;
    margin: 0;
    width: 100%;
    padding: 10mm;
  }

  /* 🔹 إخفاء العناصر الغير مطبوعة */
  .no-print {
    display: none !important;
  }
}
</style>




</head>
<body>


<div class="invoice-container">

<!-- ======= الرو الأول: الهيدر ======= -->
<div class="invoice-header" style="display:flex; justify-content:space-between; align-items:center; gap:15px; flex-wrap:wrap;">
  
  <!-- بيانات الشركة + عنوان الفاتورة -->
  <div class="company-info" style="flex:1; text-align:right;">
    <h1 style="margin:0 0 5px 0; color:#0069d9;">   
           <?php if(!empty($Def->Name)): ?>
                                                    <?php echo e(app()->getLocale() == 'ar' ?$Def->Name :$Def->NameEn); ?>

                                                <?php else: ?>
                                                    <?php echo e(trans('admin.Klar')); ?>

                                                <?php endif; ?>  
      
      </h1>
    <strong> <?php echo e(app()->getLocale() == 'ar' ?$Def->Address :$Def->AddressEn); ?>       </strong>
    
    <!-- الجدول لاصق بدون مسافة -->
    <div class="invoice-contact" style="border:1px solid #ddd; border-radius:6px; background:#f9fbfc; padding:6px; font-size:12px; margin-top:0; width:100%; max-width:400px;">
      <table style="width:100%; border-collapse: collapse; font-size:12px; text-align:right;">
        <tr><td><?php echo e(trans('admin.Phone')); ?> :</td><td><?php echo e($Def->Phone1); ?></td></tr>
        <tr><td><?php echo e(trans('admin.Phone')); ?> :</td><td><?php echo e($Def->Phone2); ?></td></tr>
        <tr><td> <?php echo e(trans('admin.Email')); ?> :</td> <td><?php echo e($Def->Email); ?></td></tr>
        <tr><td>  <?php echo e(trans('admin.Tax_Num')); ?>:</td><td><?php echo e($Def->Organaziation_Tax_ID); ?></td></tr>
     
      </table>
    </div>
  </div>

     
  <!-- اللوغو في منتصف العمود عمودياً -->
  <div class="logo" style="flex:0 0 120px; display:flex; justify-content:center; align-items:center;">
    <img src="<?php echo e(URL::to($Def->Logo)); ?>" alt="شعار الشركة" style="max-width:120px; max-height:120px; object-fit:contain;">
  </div>

</div>




<div style="display:flex; justify-content:space-between; gap:10px; width:100%; margin-top:1px;">

  <!-- الجدول الأول: عربي + قيمة + إنجليزي -->
  <div style="flex:1; border:1px solid #ddd; border-radius:6px; padding:5px; box-sizing:border-box; margin-top:-10px;"">
    <table style="width:100%; border-collapse: collapse; font-size:12px; text-align:center;">
         <tr>
        <td style="text-align:right;">التاريخ:</td>
        <td style="text-align:center;"><?php echo e($item->Date); ?></td>
        <td style="text-align:left;">: Date</td>
      </tr>
      <tr>
        <td style="text-align:right;">رقم الفاتورة:</td>
        <td style="text-align:center;"><?php echo e($item->Code); ?></td>
        <td style="text-align:left;"> : Invoice No</td>
      </tr>
      <tr>
        <td style="text-align:right;">طريقة الدفع:</td>
        <td style="text-align:center;">
          
            <?php if($item->Payment_Method == 'Cash'): ?>
                                                    <?php echo e(trans('admin.Cash')); ?>

                                                <?php elseif($item->Payment_Method == 'Later'): ?>
                                                    <?php echo e(trans('admin.Later')); ?>

                                                <?php elseif($item->Payment_Method == 'Delivery'): ?>
                                                    <?php echo e(trans('admin.Delivery')); ?>

                                                <?php elseif($item->Payment_Method == 'Cash_Visa'): ?>
                                                    <?php echo e(trans('admin.Cash_Visa')); ?>

                                                <?php elseif($item->Payment_Method == 'Visa'): ?>
                                                    <?php echo e(trans('admin.Visa')); ?>

                                                <?php elseif($item->Payment_Method == 'Cash_Collection'): ?>
                                                    <?php echo e(trans('admin.Cash_Collection')); ?>


                                                <?php elseif($item->Payment_Method == 'Check'): ?>

                                                   <?php echo e(trans('admin.Check')); ?>

                                                <?php elseif($item->Payment_Method == 'Installment'): ?>

                                                    <?php echo e(trans('admin.Installment')); ?>

                                                <?php elseif($item->Payment_Method == 'InstallmentCompanies'): ?>
                                                    <?php echo e(trans('admin.InstallmentCompanies')); ?>

                                                <?php endif; ?>
      
          
          
          </td>
        <td style="text-align:left;"> : Payment Status</td>
      </tr>
       <tr>
        <td style="text-align:right;">تاريخ الإستحقاق :</td>
        <td style="text-align:center;"><?php echo e($item->Later_Due); ?></td>
        <td style="text-align:left;"> : Due Date </td>
      </tr>
    </table>
  </div>

  <!-- الجدول الثاني: عربي + قيمة + إنجليزي -->
  <div style="flex:1; border:1px solid #ddd; border-radius:6px; padding:5px; box-sizing:border-box; margin-top:-10px;">
      <table style="width:100%; border-collapse: collapse; font-size:12px; text-align:center;">
         <tr>
        <td style="text-align:right;">العميل:</td>
        <td style="text-align:center;">       <?php echo e(app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn); ?></td>
        <td style="text-align:left;">: Customer</td>
      </tr>
          <?php if(!empty($cust)): ?>
      <tr>
        <td style="text-align:right;">رقم الحساب:</td>
        <td style="text-align:center;"><?php echo e($item->Client()->first()->Code); ?></td>
        <td style="text-align:left;"> : Account No</td>
      </tr>
      <tr>
        <td style="text-align:right;">رقم الهاتف :</td>
        <td style="text-align:center;"><?php echo e($cust->Phone); ?></td>
        <td style="text-align:left;"> : Phone No</td>
      </tr>
       <tr>
        <td style="text-align:right;"> العنوان :</td>
        <td style="text-align:center;">  <?php echo e($cust->Address); ?> </td>
        <td style="text-align:left;"> : Address</td>
      </tr>
       <tr>
        <td style="text-align:right;"> الرقم الضريبي :</td>
        <td style="text-align:center;"><?php echo e($cust->Tax_Card_No); ?></td>
        <td style="text-align:left;"> : Tax No</td>
      </tr>
          <?php endif; ?>
    </table>
     

  </div>

</div>


  <!-- ======= جدول رقم الفاتورة تحت الهيدر ======= -->
  
  <!-- ======= الرو الثاني: جدول الأصناف ======= -->
  <div class="items-table">


<div class="items-table">
  <table style="width:100%; border-collapse: collapse; text-align:center; font-size:12px;">
    <thead>
      <tr>
        <th>المسلسل<br>Serial</th>
        <th>الباركود<br>Barcode</th>
        <th>الصنف<br>Item</th>
        <th>الوحدة<br>Unit</th>
        <th>الكمية<br>Qty</th>
        <th>السعر<br>Price</th>
        <th>الضريبة<br>Tax</th>
        <th>الإجمالي<br>Total</th>
      </tr>
    </thead>
    <tbody>
        
        <?php  $i=1; ?> 
             <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <tr>
          <td><?php echo e($i); ?></td>
          <td>   <?php echo e($detail->Product_Code); ?></td>
           <td>
                   <?php echo e(app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name); ?>


                   <?php if(!empty($detail->V1)): ?>
                   (<?php echo e(app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn); ?>)
                   <?php endif; ?>
                   <?php if(!empty($detail->V2)): ?>
            ((<?php echo e(app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn); ?>))
                   <?php endif; ?>
          </td>
        <td>
                   <?php echo e(app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn); ?>

          </td>
        <td>
          <?php echo e($detail->Qty); ?>

          </td>
        <td>
          <?php echo e($detail->Price); ?>

          </td>
        <td>
          <?php echo e($detail->Total_Tax); ?>

          </td>
        <td>
          <?php echo e($detail->Total_Net); ?>

          </td>
        </tr>
         <?php  $i++; ?> 
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
        
  
      <!-- صف الإجماليات الكبير المدمج -->
   <tr>
  <!-- 5 أعمدة للشمال للصورة والجملة تحتها -->
  <td colspan="4" style="border:1px solid #ccc; padding:10px; text-align:center; vertical-align:top;">

      
          <?php if(null !== session('file_url')): ?>
                                                <?php echo session('file_url'); ?>

                                            <?php endif; ?>
    <div style="margin-top:8px; font-weight:bold;">
   <?php if(app()->getLocale() == 'ar' ): ?>
                                            <?php
                                                $xx=($item->Total_Net);
                                              $f = new NumberFormatter("ar", NumberFormatter::SPELLOUT);
                                   echo $f->format(round($xx));
                                            ?>
                                        <?php else: ?>
                                            <?php
                                                $xx=($item->Total_Net);
                                              $f = new NumberFormatter("en", NumberFormatter::SPELLOUT);
                                   echo $f->format(round($xx));
                                            ?>
                                        <?php endif; ?>
      
      
      <?php echo e(app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name); ?>    </div>
  </td>

  <!-- 3 أعمدة على اليمين للإجماليات -->
  <td colspan="4" style="border:1px solid #ccc; padding:10px; text-align:right; vertical-align:top;">
    <table style="width:100%; border-collapse: collapse; text-align:right; font-size:12px;">
      <tr>
        <td>الإجمالي قبل الخصم<br>Total Before Discount</td><td><?php echo e($item->Total_Price); ?></td>
      </tr>
      <tr>
        <td>إجمالي الخصم<br>Discount Total</td><td><?php echo e($item->Total_Discount); ?></td>
      </tr>
      <tr>
        <td>الصافي بدون الضريبة<br>Net Before Tax</td><td><?php echo e($item->Total_BF_Taxes); ?></td>
      </tr>
      <tr>
       <td>ضريبة القيمة المضافة<br>VAT (15%)</td><td><?php echo e($item->Total_Taxes); ?></td>
      </tr>
      <tr>
        <td>الصافي شامل الضريبة<br>Net Including Tax</td><td><?php echo e($item->Total_Net); ?></td>
      </tr>
    </table>
  </td>
</tr>

    </tbody>
  </table>
</div>

   <div class="no-print">
  <div class="notes">
    <?php if(!empty($Def->Print_Text_Footer_Sales)): ?>             
      <?php echo app()->getLocale() == 'ar' ?$Def->Print_Text_Footer_Sales :$Def->Print_Text_Footer_Sales_En; ?>

    <?php endif; ?>
  </div>

  <div class="btn-group btn-group-justified row" role="group" aria-label="...">
    <div class="btn-group col-md-6" role="group">
      <button onclick="window.print();" class="btn btn-block btn-primary"><?php echo e(trans('admin.Print')); ?></button>
    </div>
    <div class="btn-group col-md-6" role="group">
      <a href="<?php echo e(url()->previous()); ?>" class="btn btn-default" data-dismiss="modal"><?php echo e(trans('admin.Back')); ?></a>
    </div>
  </div>
</div>
   
      
        
      
      

  </div>
    

  </div>


</div>
</body>
</html>

<?php /**PATH /home/demorabiherp/public_html/resources/views/admin/Sales/SalesPrint/Temp2.blade.php ENDPATH**/ ?>