<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>أكثر 10 عملاء مبيعًا</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background-color: #f4f4f4; color: #333; }
        h1 { color: #0056b3; text-align: center; margin-bottom: 30px; }
        table { width: 90%; border-collapse: collapse; margin: 0 auto 30px auto; box-shadow: 0 2px 8px rgba(0,0,0,0.1); background-color: #fff; }
        th, td { border: 1px solid #ddd; padding: 12px; text-align: right; }
        th { background-color: #007bff; color: white; font-weight: bold; }
        tr:nth-child(even) { background-color: #f9f9f9; }
        tr:hover { background-color: #f1f1f1; }
        p { text-align: center; font-size: 1.1em; color: #666; }
    </style>
</head>
<body>
<h1>تقرير: أكثر 10 عملاء تحقيقاً للمبيعات</h1>

<?php if($topSellingCustomers->isEmpty()): ?>
    <p>لا توجد بيانات عن العملاء الأكثر تحقيقاً للمبيعات.</p>
<?php else: ?>
    <table>
        <thead>
        <tr>
            <th>الترتيب</th>
            <th>اسم العميل</th>
            <th>إجمالي الإيرادات المحققة</th>
            <th>**عدد مرات البيع**</th> </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $topSellingCustomers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($index + 1); ?></td>
                <td><?php echo e($customer->app_name); ?></td>
                <td><?php echo e(number_format($customer->total_revenue, 2)); ?></td>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
<?php endif; ?>
</body>
</html>
<?php /**PATH /Applications/MAMP/htdocs/laravel/ERP/resources/views/admin/top_selling_customers.blade.php ENDPATH**/ ?>