<?php use App\Models\PaymentVoucherDetails; ?>

<?php $__env->startSection('content'); ?>

    <title><?php echo e(trans('admin.Expenses_Voucher')); ?></title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"><?php echo e(trans('admin.RealStates')); ?> </a></li>
            <li class="breadcrumb-item active"><?php echo e(trans('admin.Expenses_Voucher')); ?>  </li>
            <li class="breadcrumb-item active"><?php echo e($data->Name); ?>  </li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>


        <div class="row hide-table">
            <div class="col-xl-12">
                <div id="panel-1" class="panel second-color">
                    <div class="panel-hdr">
                        <h2>
                            <?php echo e(trans('admin.Expenses_Voucher')); ?> =>  <?php echo e($data->Name); ?>

                        </h2>

                        <div class="panel-toolbar">

                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg"><?php echo e(trans('admin.AddNew')); ?></button>
                            <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                                Style
                            </button>
                            <?php echo $__env->make('admin.layouts.toolbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> <?php echo $__env->make('admin.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        <div class="panel-content">

                            <!-- datatable start -->
                            <div style="overflow:auto;">
                                <table  class="table table-bordered table-hover table-striped ">
                                    <thead class="bg-highlight">


                                    <tr>
                                        <th><?php echo e(trans('admin.Date')); ?></th>
                                        <th><?php echo e(trans('admin.Code')); ?></th>
                                        <th> <?php echo e(trans('admin.Safe')); ?> </th>
                                        <th><?php echo e(trans('admin.Details')); ?></th>
                                        <th><?php echo e(trans('admin.Data')); ?></th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr <?php if($item->Edit == 1): ?> class="edited" <?php elseif($item->Delete == 1): ?> class="deleted" <?php endif; ?>>
                                            <td><?php echo e($item->Date); ?></td>
                                            <td><?php echo e($item->Code); ?></td>

                                            <td>
                                                <?php if(!empty($item->Safe()->first()->Name)): ?>
                                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Safe()->first()->Name :$item->Safe()->first()->NameEn); ?>

                                                <?php endif; ?>

                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center-open<?php echo e($item->id); ?>">
                                                    <?php echo e(trans('admin.Details')); ?>

                                                </button>
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#show-data<?php echo e($item->id); ?>">
                                                    <?php echo e(trans('admin.Data')); ?>

                                                </button>
                                            </td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th><?php echo e(trans('admin.Date')); ?></th>
                                        <th><?php echo e(trans('admin.Code')); ?></th>
                                        <th> <?php echo e(trans('admin.Safe')); ?> </th>
                                        <th><?php echo e(trans('admin.Details')); ?></th>
                                        <th><?php echo e(trans('admin.Data')); ?></th>


                                    </tr>
                                    </tfoot>

                                </table>

                                <?php echo e($items->Links()); ?>

                            </div>
                            <!-- datatable end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Add-->
        <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(trans('admin.AddNew')); ?>  </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <form action="<?php echo e(url('PostExpensesVoucher')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <?php echo view('honeypot::honeypotFormFields'); ?>
                    <div class="modal-body">

                        <div class="row">





                            <div class="col-md-4">
                                <lable><?php echo e(trans('admin.Debitor')); ?></lable>
                                <input type="number" step="any" name="Debaitor" value="<?php echo e(old('Debaitor')); ?>" class="form-control" required>
                            </div>

                            <div class="col-md-4">
                                <lable><?php echo e(trans('admin.Account')); ?></lable>
                                <select class="select2 form-control" name="Account" id="Account" required>
                                    <option value=""><?php echo e(trans('admin.Account')); ?></option>
                                    <?php $__currentLoopData = $Accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <option value="<?php echo e($account->id); ?>"><?php echo e($account->Name); ?></option>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                            </div>

                            <div class="col-md-4">
                                <lable><?php echo e(trans('admin.Statement')); ?></lable>
                                <input type="text"  name="Statement" value="<?php echo e(old('Statement')); ?>" class="form-control">
                            </div>


                            <div class="col-md-4">
                                <lable><?php echo e(trans('admin.Safe')); ?></lable>
                                <select class="select2 form-control" name="Safe"  required>
                                    <option value=""><?php echo e(trans('admin.Safe')); ?></option>
                                    <?php $__currentLoopData = $Safes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $safe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <option value="<?php echo e($safe->id); ?>"><?php echo e($safe->Name); ?></option>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                            </div>


                            <div class="col-md-4">
                                <lable><?php echo e(trans('admin.Coin')); ?></lable>
                                <select class="select2 form-control" name="Coin"  required>
                                    <option value=""><?php echo e(trans('admin.Coin')); ?></option>
                                    <?php $__currentLoopData = $Coins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <option value="<?php echo e($coin->id); ?>"><?php echo e($coin->Arabic_Name); ?></option>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                            </div>


                            <div class="col-md-4">
                                <lable><?php echo e(trans('admin.Draw')); ?></lable>
                                <input type="number" step="any"  name="Draw" value="1" class="form-control">
                            </div>


                            <input type="hidden" name="Project" id="Project" value="<?php echo e($data->id); ?>">









                        </div>


                    </div>


                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                            <button type="submit" class="btn btn-primary">
                                <?php echo e(trans('admin.Save')); ?>

                            </button>
                        </div>

                    </form>
                </div>
                </div>
            </div>





    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


            <!--modal show data-->
            <div class="modal fade" id="show-data<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                <?php echo e(trans('admin.Data')); ?>

                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div style="overflow:auto;">
                                <table id="" class="table table-bordered table-hover table-striped " style="width:100%;">
                                    <thead class="bg-highlight">
                                    <tr>

                                        <th> <?php echo e(trans('admin.Coin')); ?></th>
                                        <th><?php echo e(trans('admin.Draw')); ?> </th>
                                        <th> <?php echo e(trans('admin.Cost_Center')); ?> </th>
                                        <th> <?php echo e(trans('admin.File')); ?> </th>

                                    </tr>
                                    </thead>
                                    <tbody>

                                    <tr>

                                        <td>
                                            <?php if(!empty($item->Coin()->first()->Arabic_Name)): ?>
                                                <?php echo e(app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($item->Draw); ?></td>
                                        <td>

                                            <?php if(!empty($item->Cost_Center()->first()->Arabic_Name)): ?>

                                                <?php echo e(app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name); ?>


                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if(!empty($item->File)): ?>
                                                <a href="<?php echo e(URL::to($item->File)); ?>" class="btn btn-primary" dowmload><i class="fal fa-download"></i></a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>

                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th> <?php echo e(trans('admin.Coin')); ?></th>
                                        <th><?php echo e(trans('admin.Draw')); ?> </th>
                                        <th> <?php echo e(trans('admin.Cost_Center')); ?> </th>
                                        <th> <?php echo e(trans('admin.File')); ?> </th>

                                    </tr>
                                    </tfoot>

                                </table>
                                <?php echo e($items->Links()); ?>

                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>

                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Details -->
            <div class="modal fade" id="default-example-modal-center-open<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                <?php echo e(trans('admin.Details')); ?>

                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-row">

                                <div class="form-group col-lg-12">
                                    <label class="form-label" for=""><?php echo e(trans('admin.Notes')); ?> </label>
                                    <input type="text" value="<?php echo e($item->Note); ?>" id="simpleinput" class="form-control" disabled>
                                </div>
                            </div>

                            <?php
                                $details=PaymentVoucherDetails::where('PV_ID',$item->id)->get();
                                $count=PaymentVoucherDetails::where('PV_ID',$item->id)->get()->count();

                            ?>
                            <div class="mt-3">
                                <table id="" class="table table-bordered table-hover table-striped w-100">





                                    <thead>
                                    <tr>
                                        <th><?php echo e(trans('admin.Debitor')); ?> </th>
                                        <th><?php echo e(trans('admin.Account_Code')); ?> </th>
                                        <th><?php echo e(trans('admin.Account_Name')); ?> </th>
                                        <th><?php echo e(trans('admin.Bill_Num')); ?> </th>
                                        <th><?php echo e(trans('admin.Statement')); ?> </th>


                                    </tr>
                                    </thead>
                                    <tbody id="">
                                    <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($detail->Debitor); ?></td>
                                            <td>

                                                <?php if(!empty($detail->Account()->first()->Code)): ?>
                                                    <?php echo e($detail->Account()->first()->Code); ?>


                                                <?php endif; ?>

                                            </td>
                                            <td>

                                                <?php if(!empty($detail->Account()->first()->Name)): ?>
                                                    <?php echo e(app()->getLocale() == 'ar' ?$detail->Account()->first()->Name :$detail->Account()->first()->NameEn); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($detail->Bill_Num); ?></td>
                                            <td><?php echo e($detail->Statement); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th><?php echo e(trans('admin.Debitor')); ?> </th>
                                        <th><?php echo e(trans('admin.Account_Code')); ?> </th>
                                        <th><?php echo e(trans('admin.Account_Name')); ?> </th>
                                        <th><?php echo e(trans('admin.Statement')); ?> </th>

                                    </tr>
                                    </tfoot>
                                </table>
                                <table class="table table-bordered table-hover table-striped w-100 mt-4">
                                    <tbody>
                                    <tr>
                                        <td><?php echo e(trans('admin.Numbers')); ?></td>
                                        <td><?php echo e($count); ?></td>
                                        <td><?php echo e(trans('admin.Total_Debitor')); ?></td>
                                        <td><?php echo e($item->Total_Debaitor); ?></td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                                <a class="btn btn-primary" href="#" onclick="window.print()"> <i class="fal fa-print"></i> <?php echo e(trans('admin.Print')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>

            </div>


        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



    </main>
    <input type="hidden" id="TakeSalary" value="0">
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/select2/select2.bundle.css')); ?>">
    <script src="<?php echo e(asset('Admin/js/formplugins/select2/select2.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>

    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


    <!-- Period -->
    <script>


        function PeriodFun(){

            var Start_Date=$('#Start_Date').val();
            var End_Date=$('#End_Date').val();


            let date1 = new Date(Start_Date);
            let date2 = new Date(End_Date);


// Calculating the time difference
// of two dates
            let Difference_In_Time =
                date2.getTime() - date1.getTime();

// Calculating the no. of days between
// two dates
            let Difference_In_Days =Math.round(Difference_In_Time / (1000 * 3600 * 24));

            $('#Period').val(Difference_In_Days);

        }

    </script>


    <!-- Search Selecet -->
    <script>
        $(document).ready(function () {
            $(function () {
                $(".select2").select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State",
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0,
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items",
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true,
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm;
                    },
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
                }

                $("#Client").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllCli",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {


                            $.ajax({
                                url: 'AllClientsJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#Client').empty();
                                    $.each(data, function(key, value){

                                        $('#Client').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $("#Emp").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });
            });
        });
    </script>

    <!-- Filter Governrate and City !-->
    <script>
        $(document).ready(function() {

            $('#Governrate').on('change', function() {
                var countryId = $(this).val();

                if (countryId) {
                    $.ajax({
                        url: 'GovernrateFilter/' + countryId,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function() {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function(data) {

                            $('#City').empty();

                            $.each(data, function(key, value) {

                                $('#City').append('<option value="' + key + '">' + value + '</option>');

                            });

                            var CIITY = $('#City').val();
                            $.ajax({
                                url: 'CityFilter/' + CIITY,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function() {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function(data) {

                                    $('#Place').empty();

                                    $.each(data, function(key, value) {

                                        $('#Place').append('<option value="' + key + '">' + value + '</option>');

                                    });


                                },
                                complete: function() {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        },
                        complete: function() {
                            $('#loader').css("visibility", "hidden");
                        }
                    });
                } else {

                    $('select[name="states"]').empty();
                }

            });

        });

        $(document).ready(function() {


            var countryId = $('#Governrate').val();
            if (countryId) {
                $.ajax({
                    url: 'GovernrateFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {

                        $('#City').empty();

                        $.each(data, function(key, value) {

                            $('#City').append('<option value="' + key + '">' + value + '</option>');

                        });

                        var CIITY = $('#City').val();
                        $.ajax({
                            url: 'CityFilter/' + CIITY,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {

                                $('#Place').empty();

                                $.each(data, function(key, value) {

                                    $('#Place').append('<option value="' + key + '">' + value + '</option>');

                                });


                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });




                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="states"]').empty();
            }


        });


        $('#City').on('change', function() {
            var CIITY = $('#City').val();
            $.ajax({
                url: 'CityFilter/' + CIITY,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {

                    $('#Place').empty();

                    $.each(data, function(key, value) {

                        $('#Place').append('<option value="' + key + '">' + value + '</option>');

                    });


                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });


        });



        $(document).ready(function() {

            $('.Governrate').on('change', function() {
                var countryId = $(this).val();

                if (countryId) {
                    $.ajax({
                        url: 'GovernrateFilter/' + countryId,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function() {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function(data) {

                            $('.City').empty();

                            $.each(data, function(key, value) {

                                $('.City').append('<option value="' + key + '">' + value + '</option>');

                            });

                            var CIITY = $('.City').val();
                            $.ajax({
                                url: 'CityFilter/' + CIITY,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function() {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function(data) {

                                    $('.Place').empty();

                                    $.each(data, function(key, value) {

                                        $('.Place').append('<option value="' + key + '">' + value + '</option>');

                                    });


                                },
                                complete: function() {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        },
                        complete: function() {
                            $('#loader').css("visibility", "hidden");
                        }
                    });
                } else {

                    $('select[name="states"]').empty();
                }

            });

        });

        $(document).ready(function() {


            var countryId = $('.Governrate').val();
            if (countryId) {
                $.ajax({
                    url: 'GovernrateFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {

                        $('.City').empty();

                        $.each(data, function(key, value) {

                            $('.City').append('<option value="' + key + '">' + value + '</option>');

                        });

                        var CIITY = $('.City').val();
                        $.ajax({
                            url: 'CityFilter/' + CIITY,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {

                                $('.Place').empty();

                                $.each(data, function(key, value) {

                                    $('.Place').append('<option value="' + key + '">' + value + '</option>');

                                });


                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });




                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="states"]').empty();
            }


        });


        $('.City').on('change', function() {
            var CIITY = $('.City').val();
            $.ajax({
                url: 'CityFilter/' + CIITY,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {

                    $('.Place').empty();

                    $.each(data, function(key, value) {

                        $('.Place').append('<option value="' + key + '">' + value + '</option>');

                    });


                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });


        });

    </script>

    <!-- New Client Ajax -->
    <script>


        function NewClients() {

            var co = $('#CODE').val();
            var Name = $('#Name').val();
            var PriceLevel = $('#PriceLevel').val();
            var Phone = $('#Phone').val();
            var NameEn = $('#NameEn').val();
            var LANG = $('#LANG').val();
            if (NameEn == '') {

                NameEn = Name;
            }
            if (Name) {
                $.ajax({
                    url: 'AddNewClient',
                    type: "GET",
                    data: {
                        co: co,
                        Name: Name,
                        PriceLevel: PriceLevel,
                        Phone: Phone,
                        NameEn: NameEn
                    },
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {
                        $.each(data, function(key, value) {

                            if (LANG == 'ar') {
                                alert('تم الاضافه بنجاح');
                            } else {
                                alert('Added Successfully');
                            }

                            $('#Name').val('');
                            $('#Phone').val('');


                        });
                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                if (LANG == 'ar') {
                    alert('حقل الاسم مطلوب');
                } else {

                    alert('Name Input is Required');
                }

            }



        }

    </script>


    <!-- Insert To Table -->
    <script>
        function AddToTable() {



            var Date = document.getElementById("Date").value;
            var Value_Payment = document.getElementById("Value_Payment").value;

            var table = ` <tr>
                            <td>
                            ${Date}
                                </td>

                                <td>
                                ${Value_Payment}

 <input type="hidden" name="Date[]" value="${Date}">
 <input type="hidden" name="Value_Payment[]" value="${Value_Payment}">

                               </td>

                                <td>
                    <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>`;

            document.getElementById("data-dt").innerHTML += table;



            $("#data-dt").on("click", "#Del", function(e) {
                $(this).closest("tr").remove();

            });
        }

    </script>



<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/laravel/ERP/resources/views/admin/RealStates/ExpensesVoucherProject.blade.php ENDPATH**/ ?>