
<?php $__env->startSection('content'); ?>

<title><?php echo e(trans('admin.ItemsCostsReportGroup')); ?></title>

<style>
/* ===========================
   🎨 نسخ نفس الستايل من الصفحة الأولى بالكامل
=========================== */

/* شكل الأزرار */
.btn.btn-primary {
  display: inline-block;
  width: 230px !important;
  height: 70px;
  line-height: 55px;
  font-size: 20px;
  font-weight: 600;
  border-radius: 15px;
   background: linear-gradient(135deg, #155a4b, #3f7d5f, #cc9b27);
  border: none;
  color: #fff;
  text-align: center;
  text-transform: none;
  letter-spacing: 0.5px;
  transition: all 0.3s ease;
  box-shadow: 0 6px 15px rgba(0, 91, 255, 0.3);
  position: relative;
  overflow: hidden;
}

.btn.btn-primary::before {
  content: "";
  position: absolute;
  top: 0;
  left: -100%;
  width: 100%;
  height: 100%;
  background: linear-gradient(
    120deg,
    rgba(255, 255, 255, 0.3) 0%,
    rgba(255, 255, 255, 0.1) 50%,
    transparent 100%
  );
  transition: all 0.6s ease;
}

.btn.btn-primary:hover::before {
  left: 100%;
}

.btn.btn-primary:hover {
  transform: translateY(-4px) scale(1.03);
  background: linear-gradient(135deg, #155a4b, #0b8a6a, #cc9b27);
  box-shadow: 0 10px 25px rgba(0, 91, 255, 0.4);
}

.btn.btn-primary:active {
  transform: translateY(0);
  box-shadow: 0 4px 10px rgba(0, 91, 255, 0.2);
}

/* ترتيب الأزرار */
.col-md-4.mt-2, .col-md-3.mt-2 {
  display: flex;
  justify-content: center;
  align-items: center;
  margin-bottom: 25px;
}

/* حركة الظهور */
.btn.btn-primary {
  animation: fadeInUp 0.6s ease both;
}

@keyframes  fadeInUp {
  from {
    opacity: 0;
    transform: translateY(25px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}

/* خلفية الصفحة */
body {
  background: linear-gradient(135deg, #e9f0ff 0%, #f9fbff 100%);
  font-family: 'Cairo', sans-serif;
  transition: background 0.5s ease-in-out;
  min-height: 100vh;
}

/* شكل البانيل */
.panel {
  background: #fff;
  border-radius: 15px;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.07);
  padding: 25px;
  transition: all 0.3s ease;
}

.panel:hover {
  box-shadow: 0 12px 35px rgba(0, 0, 0, 0.12);
}

/* تأثير خفيف في الخلفية */
body::before {
  content: "";
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-image: radial-gradient(circle at 20% 20%, rgba(0, 120, 255, 0.08), transparent 70%),
                    radial-gradient(circle at 80% 80%, rgba(0, 150, 255, 0.08), transparent 70%);
  z-index: -1;
  pointer-events: none;
}

/* تنسيق العناوين */
.panel-hdr h2 {
  font-size: 24px;
  font-weight: 700;
  color: #155a4b;
  letter-spacing: 0.5px;
  text-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
}
</style>

<main id="js-page-content" role="main" class="page-content">
  <ol class="breadcrumb page-breadcrumb no-print">
    <li class="breadcrumb-item"><a href="javascript:void(0);"> <?php echo e(trans('admin.Reports')); ?> </a></li>
    <li class="breadcrumb-item active"><?php echo e(trans('admin.ItemsCostsReportGroup')); ?></li>
    <li class="position-absolute pos-top pos-right d-none d-sm-block">
      <span class="js-get-date"></span>
    </li>
  </ol>

  <div class="subheader"></div>

  <div class="row">
    <div class="col-xl-12">
      <div id="panel-1" class="panel">
        <div class="panel-hdr">
          <h2><span class="fw-300"><i><?php echo e(trans('admin.ItemsCostsReportGroup')); ?></i></span></h2>
        </div>

        <div class="panel-container show">
          <div class="panel-content">
            <div class="row">

              <div class="col-md-4 mt-2">
                <?php if($ReportsSettings->Products == 1): ?>
                  <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تقرير المنتجات')): ?>
                    <a href="<?php echo e(url('ProductsReports')); ?>" class="btn btn-primary" title="<?php echo e(trans('admin.Products')); ?>">
                      <?php echo e(trans('admin.Products')); ?>

                    </a>
                  <?php endif; ?>
                <?php endif; ?>
              </div>

              <div class="col-md-4 mt-2">
                <?php if($ReportsSettings->StoresCost == 1): ?>
                  <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تكلفه المخزون')): ?>
                    <a href="<?php echo e(url('StoresCost')); ?>" class="btn btn-primary" title="<?php echo e(trans('admin.StoresCost')); ?>">
                      <?php echo e(trans('admin.StoresCost')); ?>

                    </a>
                  <?php endif; ?>
                <?php endif; ?>
              </div>

              <div class="col-md-4 mt-2">
                <?php if($ReportsSettings->StoresCosts == 1): ?>
                  <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تكلفه المخازن')): ?>
                    <a href="<?php echo e(url('StoresCosts')); ?>" class="btn btn-primary" title="<?php echo e(trans('admin.StoresCosts')); ?>">
                      <?php echo e(trans('admin.StoresCosts')); ?>

                    </a>
                  <?php endif; ?>
                <?php endif; ?>
              </div>

              <div class="col-md-4 mt-2">
                <?php if($ReportsSettings->ItemCost == 1): ?>
                  <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('جرد المخازن')): ?>
                    <a href="<?php echo e(url('ItemCost')); ?>" class="btn btn-primary" title="<?php echo e(trans('admin.ItemCost')); ?>">
                      <?php echo e(trans('admin.ItemCost')); ?>

                    </a>
                  <?php endif; ?>
                <?php endif; ?>
              </div>

              <div class="col-md-4 mt-2">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('كميات المخزون')): ?>
                  <a href="<?php echo e(url('StoresQtiesReport')); ?>" class="btn btn-primary" title="<?php echo e(trans('admin.StoresQtiesReport')); ?>">
                    <?php echo e(trans('admin.StoresQtiesReport')); ?>

                  </a>
                <?php endif; ?>
              </div>

            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</main>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demorabiherp/public_html/resources/views/admin/Reports/Pages/ItemsCosts.blade.php ENDPATH**/ ?>