
<?php $__env->startSection('content'); ?>

<title><?php echo e(trans('admin.DelegatesReportGroup')); ?></title>

<style>
/* ===========================
   ستايل البوتونز ثابت + hover
=========================== */
.btn.btn-primary {
  display: inline-block;
  width: 100%;
  max-width: 260px;
  height: 65px;             /* ارتفاع ثابت زي المبيعات */
  line-height: 1.2;         /* لضبط النص عموديًا */
  font-size: 18px;           /* الحجم الأساسي للنص */
  font-weight: 600;
  border-radius: 15px;
  background: linear-gradient(135deg, #155a4b, #3f7d5f, #cc9b27);
  border: none;
  color: #fff;
  text-align: center;
  padding: 0 10px;           /* مسافة داخلية */
  transition: all 0.3s ease;
  box-shadow: 0 6px 15px rgba(0, 91, 255, 0.3);
  position: relative;
  overflow: hidden;
  text-decoration: none;
  display: flex;
  justify-content: center;
  align-items: center;
  text-align: center;
}

/* نصوص طويلة تصغر تلقائيًا */
.btn.btn-primary span {
  display: block;
  white-space: normal;
  text-align: center;
  font-size: clamp(12px, 1.1vw, 18px); /* يتغير تلقائي حسب طول النص */
  line-height: 1.2;
}

/* تأثير hover */
.btn.btn-primary::before {
  content: "";
  position: absolute;
  top: 0;
  left: -100%;
  width: 100%;
  height: 100%;
  background: linear-gradient(
  120deg,
  rgba(255, 255, 255, 0.25) 0%,
  rgba(255, 255, 255, 0.1) 50%,
  rgba(204, 155, 39, 0.15) 100%
);
  transition: all 0.6s ease;
}

.btn.btn-primary:hover::before {
  left: 100%;
}

.btn.btn-primary:hover {
  transform: translateY(-4px) scale(1.03);
  background: linear-gradient(135deg, #155a4b, #0b8a6a, #cc9b27);
  box-shadow: 0 10px 25px rgba(0, 91, 255, 0.4);
}

.btn.btn-primary:active {
  transform: translateY(0);
  box-shadow: 0 4px 10px rgba(0, 91, 255, 0.2);
}

/* ===========================
   خلفية الصفحة
=========================== */
body {
  background: linear-gradient(135deg, #e9f0ff 0%, #f9fbff 100%);
  font-family: 'Cairo', sans-serif;
  transition: background 0.5s ease-in-out;
  min-height: 100vh;
}

body::before {
  content: "";
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-image:
    radial-gradient(circle at 20% 20%, rgba(0, 120, 255, 0.08), transparent 70%),
    radial-gradient(circle at 80% 80%, rgba(0, 150, 255, 0.08), transparent 70%);
  z-index: -1;
  pointer-events: none;
}

/* ===========================
   تنسيق الـ Panels
=========================== */
.panel {
  background: #fff;
  border-radius: 15px;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.07);
  padding: 25px;
  transition: all 0.3s ease;
}

.panel:hover {
  box-shadow: 0 12px 35px rgba(0, 0, 0, 0.12);
}

/* ===========================
   العناوين
=========================== */
.panel-hdr h2 {
  font-size: 24px;
  font-weight: 700;
  color: #155a4b;
  letter-spacing: 0.5px;
  text-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
  margin-bottom: 0;
  text-align: center;
  width: 100%;
}

/* تباعد بين الأعمدة */
.mt-2 {
    margin-top: 1rem !important;
}
</style>

<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb no-print">
        <li class="breadcrumb-item"><a href="javascript:void(0);"><?php echo e(trans('admin.Reports')); ?></a></li>
        <li class="breadcrumb-item active"><?php echo e(trans('admin.DelegatesReportGroup')); ?></li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>

    <div class="row">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                    <h2><span class="fw-300"><i><?php echo e(trans('admin.DelegatesReportGroup')); ?></i></span></h2>
                </div>
                <div class="panel-container show">
                    <div class="panel-content">
                        <div class="row">

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تقرير نسب الموظفين من الماركات و المجموعات')): ?>
                            <div class="col-md-4 mt-2">
                                <a href="<?php echo e(url('EmpPrecentsBrandsGroupsReport')); ?>" class="btn btn-primary">
                                    <span><?php echo e(trans('admin.EmpPrecentsBrandsGroupsReport')); ?></span>
                                </a>
                            </div>
                            <?php endif; ?>

                            <?php if($ReportsSettings->DailyClosing == 1): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تقفيل اليوميه')): ?>
                            <div class="col-md-4 mt-2">
                                <a href="<?php echo e(url('DailyClosing')); ?>" class="btn btn-primary">
                                    <span><?php echo e(trans('admin.DailyClosing')); ?></span>
                                </a>
                            </div>
                            <?php endif; ?>
                            <?php endif; ?>

                            <?php if($ReportsSettings->DailyClosingDetails == 1): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تقفيل اليوميه بتفاصيل')): ?>
                            <div class="col-md-4 mt-2">
                                <a href="<?php echo e(url('DailyClosingDetails')); ?>" class="btn btn-primary">
                                    <span><?php echo e(trans('admin.DailyClosingDetails')); ?></span>
                                </a>
                            </div>
                            <?php endif; ?>
                            <?php endif; ?>

                            <?php if($ReportsSettings->Sales_Delegates == 1): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('مبيعات مناديب')): ?>
                            <div class="col-md-4 mt-2">
                                <a href="<?php echo e(url('Sales_Delegates')); ?>" class="btn btn-primary">
                                    <span><?php echo e(trans('admin.Sales_Delegates')); ?></span>
                                </a>
                            </div>
                            <?php endif; ?>
                            <?php endif; ?>

                            <?php if($ReportsSettings->DelegateSalesDetailss == 1): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('مبيعات مناديب تفصيلي')): ?>
                            <div class="col-md-4 mt-2">
                                <a href="<?php echo e(url('DelegateSalesDetailss')); ?>" class="btn btn-primary">
                                    <span><?php echo e(trans('admin.DelegateSalesDetails')); ?></span>
                                </a>
                            </div>
                            <?php endif; ?>
                            <?php endif; ?>

                            <?php if($ReportsSettings->DelegateSalesDetails == 1): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('مبيعات مناديب تفصيلي جديد')): ?>
                            <div class="col-md-4 mt-2">
                                <a href="<?php echo e(url('DelegateSalesDetails')); ?>" class="btn btn-primary">
                                    <span><?php echo e(trans('admin.DelegateSalesDetails')); ?></span>
                                </a>
                            </div>
                            <?php endif; ?>
                            <?php endif; ?>

                            <?php if($ReportsSettings->ProfitDelegateSalesDetails == 1): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ارباح مبيعات مناديب تفصيلي')): ?>
                            <div class="col-md-4 mt-2">
                                <a href="<?php echo e(url('ProfitDelegateSalesDetails')); ?>" class="btn btn-primary">
                                    <span><?php echo e(trans('admin.ProfitDelegateSalesDetails')); ?></span>
                                </a>
                            </div>
                            <?php endif; ?>
                            <?php endif; ?>

                            <?php if($ReportsSettings->Collection_Delegates == 1): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تحصيل مناديب')): ?>
                            <div class="col-md-4 mt-2">
                                <a href="<?php echo e(url('Collection_Delegates')); ?>" class="btn btn-primary">
                                    <span><?php echo e(trans('admin.Collection_Delegates')); ?></span>
                                </a>
                            </div>
                            <?php endif; ?>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demorabiherp/public_html/resources/views/admin/Reports/Pages/Delegates.blade.php ENDPATH**/ ?>