<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تقرير إجمالي المبيعات لكل ساعتين</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: right;
        }
        th {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
<h1>تقرير إجمالي المبيعات لكل ساعتين (كل التواريخ)</h1>

<?php if($formattedSales->isEmpty()): ?>
    <p>لا توجد مبيعات لعرضها.</p>
<?php else: ?>
    <table>
        <thead>
        <tr>
             <th>الفترة الزمنية</th>
            <th>إجمالي المبيعات</th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $formattedSales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                 <td><?php echo e($sale['time_interval']); ?></td>
                <td><?php echo e(number_format($sale['total_sales'], 2)); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
<?php endif; ?>
</body>
</html>
<?php /**PATH /Applications/MAMP/htdocs/laravel/ERP/resources/views/admin/two_hour_report.blade.php ENDPATH**/ ?>