<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title> <?php echo e($title); ?></title>
  <link rel="stylesheet" href="style.css">
</head>
<style>

@import  url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap');

@media  print {
  .btn-group {
    display: none !important;
  }
}


body {
  font-family: 'Cairo', sans-serif;
  direction: rtl;
  background: #fff;
  margin: 0;
  padding: 30px;
  color: #333;
  line-height: 1.3;
}

.container {
  border: 1px solid #ddd;
  padding: 20px;
  max-width: 900px;
  margin: auto;
  background: #fff;
}

/* ===== Grid الرأس ===== */
.header-grid {
  display: grid;
  grid-template-columns: repeat(12, 1fr);
  align-items: start;
  margin-bottom: 0;
  gap: 10px;
}

.logo {
  grid-column: span 4;
  display: flex;
  justify-content: center;
  align-items: center;
  text-align: center;
}

.logo img {
  width: 120px;
  height: 120px;
  object-fit: contain;
}

/* القسم الأيسر (العنوان + التفاصيل) */
.title-section {
  grid-column: span 8;
}

/* ===== العنوان ===== */
.title-box {
  background: #d9edf7;
  text-align: center;
  padding: 6px 0;
  border-radius: 3px;
  margin-bottom: 6px;
  display: inline-block;
  width: 100%;
}

.title-box h1 {
  margin: 0;
  font-size: 22px;
  font-weight: 700;
  color: #000;
}

/* ===== بيانات عرض السعر ===== */
.quote-info {
  display: flex;
  flex-wrap: wrap;
  gap: 3px 15px;
  border-bottom: 2px solid #bcd;
  padding-bottom: 8px;
  font-size: 13px;
}

.quote-info p {
  width: calc(50% - 8px);
  margin: 0;
  text-align: right;
  line-height: 1.2; /* تقليل المسافة بين السطور */
}

/* ===== بيانات الأطراف بتقسيم Grid ===== */
.parties-grid {
  display: grid;
  grid-template-columns: repeat(12, 1fr);
  gap: 10px;
  border-bottom: 1px solid #eee;
  padding-bottom: 10px;
  margin-top: 5px;
}

/* العناوين */
.from-title { grid-column: span 2; }
.to-title { grid-column: span 2; }

/* بيانات الأطراف */
.from-data { grid-column: span 4; }
.to-data { grid-column: span 4; }

/* ستايل العناوين */
.from-title h3,
.to-title h3 {
  background: #e6f0fa;
  padding: 3px 8px;
  font-size: 14px;
  border-radius: 3px;
  margin: 0 0 4px 0; /* مسافة صغيرة تحت العنوان */
}

/* ستايل البيانات */
.from-data p,
.to-data p {
  margin: 2px 0;
  font-size: 13px;
  line-height: 1.2; /* تقليل المسافة بين السطور */
}

/* ===== إعدادات الطباعة ===== */
@media  print {
  body { background: #fff; }
  .container { border: none; margin: 0; padding: 0; }
  .title-box { background: #d9edf7 !important; -webkit-print-color-adjust: exact; print-color-adjust: exact; }
  .from-title h3, .to-title h3 { background: #e6f0fa !important; -webkit-print-color-adjust: exact; print-color-adjust: exact; }
}

.items-table {
  margin-top: 20px;
  overflow-x: auto;
}

.items-table table {
  width: 100%;
  border-collapse: collapse;
  font-size: 13px;
}

.items-table th,
.items-table td {
  border: 1px solid #ddd;
  padding: 8px;
  text-align: right; /* لأن الصفحة RTL */
}

.items-table th {
  background: #e6f0fa;
  font-weight: 700;
}

.items-table tr:nth-child(even) {
  background: #f9f9f9;
}

/* إعدادات الطباعة */
@media  print {
  .items-table th {
    background: #e6f0fa !important;
    -webkit-print-color-adjust: exact;
    print-color-adjust: exact;
  }
}

.summary-table table {
  width: 100%;
  border-collapse: collapse;
  font-size: 13px;
  text-align: right; /* RTL */
}

.summary-table td {
  border: 1px solid #ddd;
  padding: 8px;
}

.summary-table tr:nth-child(even) {
  background: #f9f9f9;
}
.notes-section p {
  margin: 5px 0 0 0;
  font-size: 13px;
  line-height: 1.3;
}

</style>
<body>

<div class="container">

  <!-- ====== الرأس (اللوجو + عنوان عرض السعر + بياناته) ====== -->
  <div class="header-grid">

    <!-- اللوجو -->
    <div class="logo">
      <img src="<?php echo e(URL::to($Def->Logo)); ?>" alt="شعار المؤسسة">
    </div>

    <!-- العنوان + بيانات عرض السعر -->
    <div class="title-section">
      <div class="title-box">
        <h1> <?php echo e($title); ?></h1>
      </div>

      <div class="quote-info">
        <p><strong><?php echo e(trans('admin.Code')); ?>:</strong> <?php echo e($item->Code); ?></p>
        <p><strong><?php echo e(trans('admin.Desc')); ?> :</strong>  <?php echo e($item->Desc); ?></p>
        <p><strong><?php echo e(trans('admin.Date')); ?>:</strong> <?php echo e($item->Date); ?></p>
        <p><strong> <?php echo e(trans('admin.Expire_Date')); ?>:</strong> <?php echo e($item->Expire_Date); ?></p>
        <p><strong><?php echo e(trans('admin.Location')); ?>:</strong>  <?php echo e($item->Location); ?></p> 
        <p><strong><?php echo e(trans('admin.Care')); ?> :</strong>   <?php echo e($item->Care); ?></p> 
        <p><strong> <?php echo e(trans('admin.Phone')); ?> :</strong> <?php echo e($item->Phone); ?> </p> 
        <p><strong><?php echo e(trans('admin.Email')); ?>  :</strong> <?php echo e($item->Email); ?> </p> 
      </div>
    </div>

  </div>

  <!-- ====== بيانات المصدر والوجهة بتقسيم Grid ====== -->
  <div class="parties-grid">
    <div class="from-title">
      <h3> <?php echo e(trans('admin.Export_From')); ?>:</h3>
    </div>
    <div class="from-data">
      <p><strong>
               <?php if(!empty($Def->Name)): ?>
                                                    <?php echo e(app()->getLocale() == 'ar' ?$Def->Name :$Def->NameEn); ?>

                                                <?php else: ?>
                                                    <?php echo e(trans('admin.Klar')); ?>

                                                <?php endif; ?>
          
          </strong></p>
        
      <p><?php echo e($Def->Organaziation_Tax_ID); ?></p>
      <p><?php echo e(app()->getLocale() == 'ar' ?$Def->Address :$Def->AddressEn); ?> </p>
      <p><?php echo e($Def->Phone1); ?></p>
      <p><?php echo e($Def->Email); ?></p>
    </div>

      

  
    <div class="to-title">
      <h3> <?php echo e(trans('admin.Export_To')); ?>:</h3>
    </div>
    <div class="to-data">
      <p><strong> <?php echo e(app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn); ?></strong></p>
        
          <?php if(!empty($cust)): ?>
      <p><?php echo e($cust->Tax_Card_No); ?></p>
      <p><?php echo e($cust->Address); ?></p>
      <p><?php echo e($cust->Phone); ?></p>
      <p><?php echo e($cust->Email); ?></p>
        <?php endif; ?>
      



    </div>
  </div>
<!-- ====== جدول الأصناف ====== -->
<div class="items-table">
  <table>
    <thead>
      <tr>
        <th>#</th>
        <th><?php echo e(trans('admin.Name')); ?></th>
        <th><?php echo e(trans('admin.Desc')); ?></th>
        <th><?php echo e(trans('admin.Unit')); ?></th>
        <th><?php echo e(trans('admin.Qty')); ?></th>
        <th><?php echo e(trans('admin.Price')); ?></th>
        <th><?php echo e(trans('admin.Total')); ?></th>
      </tr>
    </thead>
    <tbody>
        
           <?php $i=1; ?>
         <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>    
      <tr>
        <td><?php echo e($i); ?></td>
        <td> 
                    <?php echo e(app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name); ?>


                   <?php if(!empty($detail->V1)): ?>
                   (<?php echo e(app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn); ?>)
                   <?php endif; ?>
                   <?php if(!empty($detail->V2)): ?>
            ((<?php echo e(app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn); ?>))
                   <?php endif; ?>  
          
          </td>
        <td><?php echo e($detail->SalesProDesc); ?></td>
        <td>  <?php echo e(app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn); ?></td>
        <td> <?php echo e($detail->Qty); ?></td>
        <td>  <?php echo e($detail->Price); ?></td>
        <td> <?php echo e($detail->Total_Net); ?></td>
      </tr>
        <?php $i++; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </tbody>
  </table>
</div>
<!-- ====== جدول الملخص المالي ====== -->
<!-- ====== الملخص والملاحظات ====== -->
<div class="footer-grid" style="display: grid; grid-template-columns: repeat(12, 1fr); gap: 10px; margin-top: 20px;">


  <!-- قسم الملاحظات (8 أعمدة) -->
  <div class="notes-section" style="grid-column: span 8; border: 1px solid #ddd; padding: 10px; min-height: 80px;">
    <strong><?php echo e(trans('admin.Notes')); ?>:</strong>
    <p><?php echo e($item->Note); ?></p>
  </div>

    <!-- جدول الملخص المالي (4 أعمدة) -->
  <div class="summary-table" style="grid-column: span 4; overflow-x: auto;">
    <table>
      <tbody>
        <tr>
          <td><strong> <?php echo e(trans('admin.Total_Price')); ?></strong></td>
          <td><span><?php echo e($item->Total_Price); ?></span>
        <?php if(!empty($item->Coin()->first()->Image)): ?>    
    <img src="<?php echo e(URL::to($item->Coin()->first()->Image)); ?>" alt="رمز" style="width: 18px; height: 18px; object-fit: contain; margin-right: 10px;">
              <?php endif; ?> 
      
            
            </td>
        </tr>
        <tr>
          <td><strong> <?php echo e(trans('admin.Total_Tax')); ?></strong></td>
          <td><span><?php echo e($item->Total_Taxes); ?></span>
         <?php if(!empty($item->Coin()->first()->Image)): ?>    
    <img src="<?php echo e(URL::to($item->Coin()->first()->Image)); ?>" alt="رمز" style="width: 18px; height: 18px; object-fit: contain; margin-right: 10px;">
              <?php endif; ?> 
        
            
            </td>
        </tr>
        <tr>
          <td><strong> <?php echo e(trans('admin.Total_Net')); ?></strong></td>
          <td><span><?php echo e($item->Total_Net); ?></span>
       <?php if(!empty($item->Coin()->first()->Image)): ?>    
    <img src="<?php echo e(URL::to($item->Coin()->first()->Image)); ?>" alt="رمز" style="width: 18px; height: 18px; object-fit: contain; margin-right: 10px;">
              <?php endif; ?> 
        
            
            </td>
        </tr>
      </tbody>
    </table>
  </div>

   <div class="notes-section" style="grid-column: span 6; border: 1px solid #ddd; padding: 10px; min-height: 80px; position: relative; display: flex; justify-content: center; align-items: center;"> 

  <!-- الشعار في منتصف الصندوق -->
  <img src="<?php echo e(URL::to($Def->Seal)); ?>" alt="ختم المؤسسة" style="width: 80px; height: 80px; object-fit: contain;"> 

  <!-- جملة ختم وتوقيع فوق يمين البوكس -->
  <strong style="position: absolute; top: 5px; right: 0px;"> <?php echo e(trans('admin.PresentQuote')); ?> </strong> 

</div>

   <div class="notes-section" style="grid-column: span 6; border: 1px solid #ddd; padding: 10px; min-height: 80px;">
     <strong>   <?php echo e(trans('admin.ApprovalQuote')); ?> </strong>
   
  </div>
    
    
    
    
    
       <div class="notes" style="grid-column: span 12; white-space: nowrap;">
 
    <?php if(!empty($Def->Print_Text_Footer_Quote)): ?>             
        <?php echo app()->getLocale() == 'ar' ? $Def->Print_Text_Footer_Quote : $Def->Print_Text_Footer_Quote; ?>

    <?php endif; ?>

</div>

      
      
      
            <div class="btn-group btn-group-justified row" role="group" aria-label="...">
                  <div class="btn-group col-md-6" role="group">
                     <button onclick="window.print();" class="btn btn-block btn-primary"><?php echo e(trans('admin.Print')); ?></button>
                  </div>
                  <div class="btn-group col-md-6" role="group">
                     <a href="<?php echo e(url()->previous()); ?>" class="btn btn-default" data-dismiss="modal"><?php echo e(trans('admin.Back')); ?></a>
                  </div>
       
               </div>
    
    
</div>

    
    
    
    
    

</div>



</body>
</html>
<?php /**PATH /home/demorabiherp/public_html/resources/views/admin/Sales/QuotePrint/Temp1.blade.php ENDPATH**/ ?>