<?php $__env->startSection('content'); ?>

    <title><?php echo e(trans('admin.CapitalReport')); ?></title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> <?php echo e(trans('admin.Accounts')); ?></a></li>
            <li class="breadcrumb-item active"><?php echo e(trans('admin.CapitalReport')); ?></li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i><?php echo e(trans('admin.CapitalReport')); ?></i></span>
                        </h2>

                        <div class="panel-toolbar">

                            <?php echo $__env->make('admin.layouts.toolbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> <?php echo $__env->make('admin.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        <div class="panel-content">

                            <div class="row">

                                <div class="col-md-4 text-center">
                                    <button type="button" class="btn btn-primary text-center m-1" data-toggle="collapse" data-target="#jan"><?php echo e(trans('admin.January')); ?></button>

                                    <div id="jan" class="collapse m-3">
                                        <?php
                                            $newCapital=$item->Source_Capital + $Capital_IncreaseJan;
                                            $newShares=$newCapital / $item->Nominal_Value_of_Shares;
                                        ?>
                                        <table id="dt-basic-example"
                                               class="table table-bordered table-hover table-striped w-100">
                                            <thead class="bg-highlight">

                                            <tr>
                                                <th><?php echo e(trans('admin.Source_Capital')); ?>   (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Source_Capital); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Capital_Increase')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($Capital_IncreaseJan,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>

                                                <th><?php echo e(trans('admin.Source_Capital')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($newCapital,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Working_Capital')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($CapitalJan,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Total_Investment')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($InvestJan,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Working_Capital')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($CapitalJan -  $newCapital / $newCapital ) * 100),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Total_Investment')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($InvestJan -  $newCapital / $newCapital ) * 100 ),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Shares_Number')); ?> (<?php echo e(trans('admin.New')); ?>)</th>
                                                <td>
                                                    <?php echo e(number_format($newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Nominal_Value_of_Shares')); ?>  (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Nominal_Value_of_Shares); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Actual_Share_Value')); ?> </th>
                                                <td>
                                                    <?php echo e(number_format($CapitalJan /  $newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            </thead>

                                        </table>
                                    </div>
                                </div>

                                <div class="col-md-4 text-center">
                                    <button type="button" class="btn btn-primary text-center m-1" data-toggle="collapse" data-target="#feb"><?php echo e(trans('admin.February')); ?></button>

                                    <div id="feb" class="collapse m-3">
                                        <?php
                                            $newCapital=$item->Source_Capital + $Capital_IncreaseFeb;
                                            $newShares=$newCapital / $item->Nominal_Value_of_Shares;
                                        ?>
                                        <table id="dt-basic-example"
                                               class="table table-bordered table-hover table-striped w-100">
                                            <thead class="bg-highlight">

                                            <tr>
                                                <th><?php echo e(trans('admin.Source_Capital')); ?>   (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Source_Capital); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Capital_Increase')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($Capital_IncreaseFeb,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>

                                                <th><?php echo e(trans('admin.Source_Capital')); ?></th>
                                                <td>              <?php echo e(number_format($newCapital,2,".",",")); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Working_Capital')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($CapitalFeb,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Total_Investment')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($InvestFeb,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Working_Capital')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($CapitalFeb -  $newCapital / $newCapital ) * 100),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Total_Investment')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($InvestFeb -  $newCapital / $newCapital ) * 100 ),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Shares_Number')); ?> (<?php echo e(trans('admin.New')); ?>)</th>
                                                <td>

                                                    <?php echo e(number_format($newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Nominal_Value_of_Shares')); ?>  (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Nominal_Value_of_Shares); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Actual_Share_Value')); ?> </th>
                                                <td>
                                                    <?php echo e(number_format($CapitalFeb /  $newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            </thead>

                                        </table>
                                    </div>
                                </div>

                                <div class="col-md-4 text-center">
                                    <button type="button" class="btn btn-primary text-center m-1" data-toggle="collapse" data-target="#mar"><?php echo e(trans('admin.March')); ?></button>

                                    <div id="mar" class="collapse m-3">
                                        <?php
                                            $newCapital=$item->Source_Capital + $Capital_IncreaseMar;
                                            $newShares=$newCapital / $item->Nominal_Value_of_Shares;
                                        ?>
                                        <table id="dt-basic-example"
                                               class="table table-bordered table-hover table-striped w-100">
                                            <thead class="bg-highlight">

                                            <tr>
                                                <th><?php echo e(trans('admin.Source_Capital')); ?>   (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Source_Capital); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Capital_Increase')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($Capital_IncreaseMar,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>

                                                <th><?php echo e(trans('admin.Source_Capital')); ?></th>
                                                <td>   <?php echo e(number_format($newCapital,2,".",",")); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Working_Capital')); ?></th>
                                                <td>
                                                   <?php echo e(number_format($CapitalMar,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Total_Investment')); ?></th>
                                                <td>
                                                   <?php echo e(number_format($InvestMar,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Working_Capital')); ?></th>
                                                <td>
                                                       <?php echo e(number_format((($CapitalMar -  $newCapital / $newCapital ) * 100),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Total_Investment')); ?></th>
                                                <td>
                                                       <?php echo e(number_format((($InvestMar -  $newCapital / $newCapital ) * 100 ),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Shares_Number')); ?> (<?php echo e(trans('admin.New')); ?>)</th>
                                                <td>
                                                   <?php echo e(number_format($newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Nominal_Value_of_Shares')); ?>  (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Nominal_Value_of_Shares); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Actual_Share_Value')); ?> </th>
                                                <td>
                                                   <?php echo e(number_format($CapitalMar /  $newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            </thead>

                                        </table>
                                    </div>
                                </div>

                                <div class="col-md-4 text-center">
                                    <button type="button" class="btn btn-primary text-center m-1" data-toggle="collapse" data-target="#apr"><?php echo e(trans('admin.April')); ?></button>

                                    <div id="apr" class="collapse m-3">
                                        <?php
                                            $newCapital=$item->Source_Capital + $Capital_IncreaseApril;
                                            $newShares=$newCapital / $item->Nominal_Value_of_Shares;
                                        ?>
                                        <table id="dt-basic-example"
                                               class="table table-bordered table-hover table-striped w-100">
                                            <thead class="bg-highlight">

                                            <tr>
                                                <th><?php echo e(trans('admin.Source_Capital')); ?>   (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Source_Capital); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Capital_Increase')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($Capital_IncreaseApril,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>

                                                <th><?php echo e(trans('admin.Source_Capital')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($newCapital,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Working_Capital')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($CapitalApril,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Total_Investment')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($InvestApril,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Working_Capital')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($CapitalApril -  $newCapital / $newCapital ) * 100),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Total_Investment')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($InvestApril -  $newCapital / $newCapital ) * 100 ),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Shares_Number')); ?> (<?php echo e(trans('admin.New')); ?>)</th>
                                                <td>
                                                    <?php echo e(number_format($newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Nominal_Value_of_Shares')); ?>  (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Nominal_Value_of_Shares); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Actual_Share_Value')); ?> </th>
                                                <td>
                                                    <?php echo e(number_format($CapitalApril /  $newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            </thead>

                                        </table>
                                    </div>
                                </div>

                                <div class="col-md-4 text-center">
                                    <button type="button" class="btn btn-primary text-center m-1" data-toggle="collapse" data-target="#may"><?php echo e(trans('admin.May')); ?></button>

                                    <div id="may" class="collapse m-3">
                                        <?php
                                            $newCapital=$item->Source_Capital + $Capital_IncreaseMay;
                                            $newShares=$newCapital / $item->Nominal_Value_of_Shares;
                                        ?>
                                        <table id="dt-basic-example"
                                               class="table table-bordered table-hover table-striped w-100">
                                            <thead class="bg-highlight">

                                            <tr>
                                                <th><?php echo e(trans('admin.Source_Capital')); ?>   (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Source_Capital); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Capital_Increase')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($Capital_IncreaseMay,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>

                                                <th><?php echo e(trans('admin.Source_Capital')); ?></th>
                                                <td>              <?php echo e(number_format($newCapital,2,".",",")); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Working_Capital')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($CapitalMay,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Total_Investment')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($InvestMay,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Working_Capital')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($CapitalMay -  $newCapital / $newCapital ) * 100),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Total_Investment')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($InvestMay -  $newCapital / $newCapital ) * 100 ),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Shares_Number')); ?> (<?php echo e(trans('admin.New')); ?>)</th>
                                                <td>

                                                    <?php echo e(number_format($newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Nominal_Value_of_Shares')); ?>  (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Nominal_Value_of_Shares); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Actual_Share_Value')); ?> </th>
                                                <td>
                                                    <?php echo e(number_format($CapitalMay /  $newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            </thead>

                                        </table>
                                    </div>
                                </div>

                                <div class="col-md-4 text-center">
                                    <button type="button" class="btn btn-primary text-center m-1" data-toggle="collapse" data-target="#jun"><?php echo e(trans('admin.June')); ?></button>

                                    <div id="jun" class="collapse m-3">
                                        <?php
                                            $newCapital=$item->Source_Capital + $Capital_IncreaseJun;
                                            $newShares=$newCapital / $item->Nominal_Value_of_Shares;
                                        ?>
                                        <table id="dt-basic-example"
                                               class="table table-bordered table-hover table-striped w-100">
                                            <thead class="bg-highlight">

                                            <tr>
                                                <th><?php echo e(trans('admin.Source_Capital')); ?>   (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Source_Capital); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Capital_Increase')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($Capital_IncreaseJun,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>

                                                <th><?php echo e(trans('admin.Source_Capital')); ?></th>
                                                <td>   <?php echo e(number_format($newCapital,2,".",",")); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Working_Capital')); ?></th>
                                                <td>
                                                   <?php echo e(number_format($CapitalJun,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Total_Investment')); ?></th>
                                                <td>
                                                   <?php echo e(number_format($InvestJun,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Working_Capital')); ?></th>
                                                <td>
                                                       <?php echo e(number_format((($CapitalJun -  $newCapital / $newCapital ) * 100),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Total_Investment')); ?></th>
                                                <td>
                                                       <?php echo e(number_format((($InvestJun -  $newCapital / $newCapital ) * 100 ),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Shares_Number')); ?> (<?php echo e(trans('admin.New')); ?>)</th>
                                                <td>
                                                   <?php echo e(number_format($newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Nominal_Value_of_Shares')); ?>  (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Nominal_Value_of_Shares); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Actual_Share_Value')); ?> </th>
                                                <td>
                                                   <?php echo e(number_format($CapitalJun /  $newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            </thead>

                                        </table>
                                    </div>
                                </div>

                                <div class="col-md-4 text-center">
                                    <button type="button" class="btn btn-primary text-center m-1" data-toggle="collapse" data-target="#jul"><?php echo e(trans('admin.July')); ?></button>

                                    <div id="jul" class="collapse m-3">
                                        <?php
                                            $newCapital=$item->Source_Capital + $Capital_IncreaseJul;
                                            $newShares=$newCapital / $item->Nominal_Value_of_Shares;
                                        ?>
                                        <table id="dt-basic-example"
                                               class="table table-bordered table-hover table-striped w-100">
                                            <thead class="bg-highlight">

                                            <tr>
                                                <th><?php echo e(trans('admin.Source_Capital')); ?>   (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Source_Capital); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Capital_Increase')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($Capital_IncreaseJul,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>

                                                <th><?php echo e(trans('admin.Source_Capital')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($newCapital,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Working_Capital')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($CapitalJul,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Total_Investment')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($InvestJul,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Working_Capital')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($CapitalJul -  $newCapital / $newCapital ) * 100),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Total_Investment')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($InvestJul -  $newCapital / $newCapital ) * 100 ),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Shares_Number')); ?> (<?php echo e(trans('admin.New')); ?>)</th>
                                                <td>
                                                    <?php echo e(number_format($newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Nominal_Value_of_Shares')); ?>  (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Nominal_Value_of_Shares); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Actual_Share_Value')); ?> </th>
                                                <td>
                                                    <?php echo e(number_format($CapitalJul /  $newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            </thead>

                                        </table>
                                    </div>
                                </div>

                                <div class="col-md-4 text-center">
                                    <button type="button" class="btn btn-primary text-center m-1" data-toggle="collapse" data-target="#aug"><?php echo e(trans('admin.August')); ?></button>

                                    <div id="aug" class="collapse m-3">
                                        <?php
                                            $newCapital=$item->Source_Capital + $Capital_IncreaseAug;
                                            $newShares=$newCapital / $item->Nominal_Value_of_Shares;
                                        ?>
                                        <table id="dt-basic-example"
                                               class="table table-bordered table-hover table-striped w-100">
                                            <thead class="bg-highlight">

                                            <tr>
                                                <th><?php echo e(trans('admin.Source_Capital')); ?>   (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Source_Capital); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Capital_Increase')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($Capital_IncreaseAug,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>

                                                <th><?php echo e(trans('admin.Source_Capital')); ?></th>
                                                <td>              <?php echo e(number_format($newCapital,2,".",",")); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Working_Capital')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($CapitalAug,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Total_Investment')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($InvestAug,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Working_Capital')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($CapitalAug -  $newCapital / $newCapital ) * 100),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Total_Investment')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($InvestAug -  $newCapital / $newCapital ) * 100 ),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Shares_Number')); ?> (<?php echo e(trans('admin.New')); ?>)</th>
                                                <td>

                                                    <?php echo e(number_format($newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Nominal_Value_of_Shares')); ?>  (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Nominal_Value_of_Shares); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Actual_Share_Value')); ?> </th>
                                                <td>
                                                    <?php echo e(number_format($CapitalAug /  $newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            </thead>

                                        </table>
                                    </div>
                                </div>

                                <div class="col-md-4 text-center">
                                    <button type="button" class="btn btn-primary text-center m-1" data-toggle="collapse" data-target="#sep"><?php echo e(trans('admin.September')); ?></button>

                                    <div id="sep" class="collapse m-3">
                                        <?php
                                            $newCapital=$item->Source_Capital + $Capital_IncreaseSep;
                                            $newShares=$newCapital / $item->Nominal_Value_of_Shares;
                                        ?>
                                        <table id="dt-basic-example"
                                               class="table table-bordered table-hover table-striped w-100">
                                            <thead class="bg-highlight">

                                            <tr>
                                                <th><?php echo e(trans('admin.Source_Capital')); ?>   (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Source_Capital); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Capital_Increase')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($Capital_IncreaseSep,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>

                                                <th><?php echo e(trans('admin.Source_Capital')); ?></th>
                                                <td>   <?php echo e(number_format($newCapital,2,".",",")); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Working_Capital')); ?></th>
                                                <td>
                                                   <?php echo e(number_format($CapitalSep,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Total_Investment')); ?></th>
                                                <td>
                                                   <?php echo e(number_format($InvestSep,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Working_Capital')); ?></th>
                                                <td>
                                                       <?php echo e(number_format((($CapitalSep -  $newCapital / $newCapital ) * 100),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Total_Investment')); ?></th>
                                                <td>
                                                       <?php echo e(number_format((($InvestSep -  $newCapital / $newCapital ) * 100 ),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Shares_Number')); ?> (<?php echo e(trans('admin.New')); ?>)</th>
                                                <td>
                                                   <?php echo e(number_format($newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Nominal_Value_of_Shares')); ?>  (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Nominal_Value_of_Shares); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Actual_Share_Value')); ?> </th>
                                                <td>
                                                   <?php echo e(number_format($CapitalSep /  $newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            </thead>

                                        </table>
                                    </div>
                                </div>

                                <div class="col-md-4 text-center">
                                    <button type="button" class="btn btn-primary text-center m-1" data-toggle="collapse" data-target="#oct"><?php echo e(trans('admin.October')); ?></button>

                                    <div id="oct" class="collapse m-3">
                                        <?php
                                            $newCapital=$item->Source_Capital + $Capital_IncreaseOct;
                                            $newShares=$newCapital / $item->Nominal_Value_of_Shares;
                                        ?>
                                        <table id="dt-basic-example"
                                               class="table table-bordered table-hover table-striped w-100">
                                            <thead class="bg-highlight">

                                            <tr>
                                                <th><?php echo e(trans('admin.Source_Capital')); ?>   (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Source_Capital); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Capital_Increase')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($Capital_IncreaseOct,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>

                                                <th><?php echo e(trans('admin.Source_Capital')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($newCapital,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Working_Capital')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($CapitalOct,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Total_Investment')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($InvestOct,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Working_Capital')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($CapitalOct -  $newCapital / $newCapital ) * 100),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Total_Investment')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($InvestOct -  $newCapital / $newCapital ) * 100 ),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Shares_Number')); ?> (<?php echo e(trans('admin.New')); ?>)</th>
                                                <td>
                                                    <?php echo e(number_format($newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Nominal_Value_of_Shares')); ?>  (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Nominal_Value_of_Shares); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Actual_Share_Value')); ?> </th>
                                                <td>
                                                    <?php echo e(number_format($CapitalOct /  $newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            </thead>

                                        </table>
                                    </div>
                                </div>

                                <div class="col-md-4 text-center">
                                    <button type="button" class="btn btn-primary text-center m-1" data-toggle="collapse" data-target="#nov"><?php echo e(trans('admin.November')); ?></button>

                                    <div id="nov" class="collapse m-3">
                                        <?php
                                            $newCapital=$item->Source_Capital + $Capital_IncreaseNov;
                                            $newShares=$newCapital / $item->Nominal_Value_of_Shares;
                                        ?>
                                        <table id="dt-basic-example"
                                               class="table table-bordered table-hover table-striped w-100">
                                            <thead class="bg-highlight">

                                            <tr>
                                                <th><?php echo e(trans('admin.Source_Capital')); ?>   (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Source_Capital); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Capital_Increase')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($Capital_IncreaseNov,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>

                                                <th><?php echo e(trans('admin.Source_Capital')); ?></th>
                                                <td>              <?php echo e(number_format($newCapital,2,".",",")); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Working_Capital')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($CapitalNov,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Total_Investment')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($InvestNov,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Working_Capital')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($CapitalNov -  $newCapital / $newCapital ) * 100),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Total_Investment')); ?></th>
                                                <td>

                                                    <?php echo e(number_format((($InvestNov -  $newCapital / $newCapital ) * 100 ),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Shares_Number')); ?> (<?php echo e(trans('admin.New')); ?>)</th>
                                                <td>

                                                    <?php echo e(number_format($newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Nominal_Value_of_Shares')); ?>  (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Nominal_Value_of_Shares); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Actual_Share_Value')); ?> </th>
                                                <td>
                                                    <?php echo e(number_format($CapitalNov /  $newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            </thead>

                                        </table>
                                    </div>
                                </div>

                                <div class="col-md-4 text-center">
                                    <button type="button" class="btn btn-primary text-center m-1" data-toggle="collapse" data-target="#dec"><?php echo e(trans('admin.December')); ?></button>

                                    <div id="dec" class="collapse m-3">
                                        <?php
                                            $newCapital=$item->Source_Capital + $Capital_IncreaseDec;
                                            $newShares=$newCapital / $item->Nominal_Value_of_Shares;
                                        ?>
                                        <table id="dt-basic-example"
                                               class="table table-bordered table-hover table-striped w-100">
                                            <thead class="bg-highlight">

                                            <tr>
                                                <th><?php echo e(trans('admin.Source_Capital')); ?>   (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Source_Capital); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Capital_Increase')); ?></th>
                                                <td>
                                                    <?php echo e(number_format($Capital_IncreaseDec,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>

                                                <th><?php echo e(trans('admin.Source_Capital')); ?></th>
                                                <td>   <?php echo e(number_format($newCapital,2,".",",")); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Working_Capital')); ?></th>
                                                <td>
                                                   <?php echo e(number_format($CapitalDec,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Total_Investment')); ?></th>
                                                <td>
                                                   <?php echo e(number_format($InvestDec,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Working_Capital')); ?></th>
                                                <td>
                                                       <?php echo e(number_format((($CapitalDec -  $newCapital / $newCapital ) * 100),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Increase_Precent_Total_Investment')); ?></th>
                                                <td>
                                                       <?php echo e(number_format((($InvestDec -  $newCapital / $newCapital ) * 100 ),2,".",",")); ?>

                                                    %</td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Shares_Number')); ?> (<?php echo e(trans('admin.New')); ?>)</th>
                                                <td>
                                                   <?php echo e(number_format($newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Nominal_Value_of_Shares')); ?>  (<?php echo e(trans('admin.First')); ?>)</th>
                                                <td><?php echo e($item->Nominal_Value_of_Shares); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(trans('admin.Actual_Share_Value')); ?> </th>
                                                <td>
                                                   <?php echo e(number_format($CapitalDec /  $newShares,2,".",",")); ?>

                                                </td>
                                            </tr>
                                            </thead>

                                        </table>
                                    </div>
                                </div>

                            </div>

                        </div>
                        <!-- datatable end -->
                    </div>
                </div>
            </div>
        </div>
        </div>


    </main>





<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/summernote/summernote.css')); ?>">
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/select2/select2.bundle.css')); ?>">
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/formplugins/summernote/summernote.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/formplugins/select2/select2.bundle.js')); ?>"></script>

    <!-- Search Selecet -->
    <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                    {
                        placeholder: "Select State"
                    });
                $(".js-hide-search").select2(
                    {
                        minimumResultsForSearch: 1 / 0
                    });
                $(".js-max-length").select2(
                    {
                        maximumSelectionLength: 2,
                        placeholder: "Select maximum 2 items"
                    });
                $(".select2-placeholder").select2(
                    {
                        placeholder: "Select a state",
                        allowClear: true
                    });

                $(".js-select2-icons").select2(
                    {
                        minimumResultsForSearch: 1 / 0,
                        templateResult: icon,
                        templateSelection: icon,
                        escapeMarkup: function(elm)
                        {
                            return elm
                        }
                    });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }


                $('.Client').select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllCli',
                        processResults: function (data) {
                            return {
                                results: $.map(data, function(obj, index) {
                                    return { id: index, text: obj };
                                })
                            };

                            console.log(data);

                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllCliJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('.Client').empty();
                                    $.each(data, function(key, value){

                                        $('.Client').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    }
                });


                $('.Client').on('select2:select', function (e) {
                    console.log("select done", e.params.data);
                });



                $('#Client').select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllCli',
                        processResults: function (data) {
                            return {
                                results: $.map(data, function(obj, index) {
                                    return { id: index, text: obj };
                                })
                            };

                            console.log(data);

                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllCliJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#Client').empty();
                                    $.each(data, function(key, value){

                                        $('#Client').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    }
                });


                $('#Client').on('select2:select', function (e) {
                    console.log("select done", e.params.data);
                });



            });
        });



    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demorabiherp/public_html/resources/views/admin/Accounts/CapitalReport.blade.php ENDPATH**/ ?>