<?php $__env->startSection('content'); ?>
    <title><?php echo e(trans('admin.EmpMail')); ?></title>
    <style>

        @media  only screen and (max-width: 300px){
            .table-responsive{
                display:block;
                width:100%;
            }}
        @media  only screen and (min-width: 992px){
            .table-responsive{
                display:table;
                width:100%;
            }}
    </style>
    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> <?php echo e(trans('admin.Settings')); ?></a></li>
            <li class="breadcrumb-item active"><?php echo e(trans('admin.EmpMail')); ?></li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>
        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i><?php echo e(trans('admin.EmpMail')); ?></i></span>
                        </h2>
                        <div class="panel-toolbar">

                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg"><?php echo e(trans('admin.AddNew')); ?></button>


                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>
                           <?php echo $__env->make('admin.layouts.toolbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                    <div class="panel-container show">
                        <span id="ex"> <?php echo $__env->make('admin.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <table id="dt-basic-example"
                                   class="table table-bordered table-responsive table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                <tr>
                                    <th><?php echo e(trans('admin.Emp')); ?></th>
                                    <th><?php echo e(trans('admin.Message')); ?></th>

                                    <th><?php echo e(trans('admin.Actions')); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>

                                        <td><?php if(!empty($item->Emp()->first()->Name)): ?> <?php echo e($item->Emp()->first()->Name); ?> <?php endif; ?></td>
                                        <td><?php echo e($item->Message); ?></td>

                                        <td class="text-center">

                                         <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center<?php echo e($item->id); ?>"><i class="fal fa-trash"></i></button>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <th><?php echo e(trans('admin.Emp')); ?></th>
                                    <th><?php echo e(trans('admin.Message')); ?></th>
                                    <th><?php echo e(trans('admin.Actions')); ?></th>
                                </tr>
                                </tfoot>
                            </table>
                            <!-- datatable end -->
                            <?php echo e($items->Links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>



        <!-- Modal Add-->
        <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(trans('admin.AddNew')); ?>  </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form action="<?php echo e(url('AddEmpMail')); ?>" method="post">
                            <?php echo csrf_field(); ?>

                            <?php echo view('honeypot::honeypotFormFields'); ?>
                            <div class="form-row">

                                <div class="form-group col-lg-12">
                                    <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Emp')); ?></label>
                                    <span style="color: red" id="select_all_emps"><i class="fal fa-sliders-h"></i></span>
                                    <span style="color: red" id="remove_all_emps"><i class="fal fa-trash"></i></span>
                                    <select class="select2 form-control" id="Emp" name="Emp[]" multiple required>
                                        <option value=""><?php echo e(trans('admin.Emp')); ?></option>
                                        <?php $__currentLoopData = $Emps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $emp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($emp->id); ?>"><?php echo e($emp->Name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group col-lg-12">
                                    <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Message')); ?></label>
                                    <textarea class="form-control" name="Message" required><?php echo e(old('Message')); ?></textarea>
                                </div>



                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                                <button type="submit" class="btn btn-primary"> <?php echo e(trans('admin.Save')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <!-- Modal Delete -->
            <div class="modal fade" id="default-example-modal-center<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                <?php echo e(trans('admin.RUSWDT')); ?> <strong><?php echo e($item->Arabic_Name); ?></strong>
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?php echo e(trans('admin.No')); ?></button>
                            <a href="<?php echo e(url('DeleteEmpMail/'.$item->id)); ?>"  class="btn btn-primary"> <?php echo e(trans('admin.Yes')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </main>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/summernote/summernote.css')); ?>">
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/select2/select2.bundle.css')); ?>">

    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/formplugins/summernote/summernote.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/formplugins/select2/select2.bundle.js')); ?>"></script>
    <script>
        var autoSave = $('#autoSave');
        var interval;
        var timer = function()
        {
            interval = setInterval(function()
            {
                //start slide...
                if (autoSave.prop('checked'))
                    saveToLocal();

                clearInterval(interval);
            }, 3000);
        };

        //save
        var saveToLocal = function()
        {
            localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
            console.log("saved");
        }

        //delete
        var removeFromLocal = function()
        {
            localStorage.removeItem("summernoteData");
            $('#saveToLocal').summernote('reset');
        }

        $(document).ready(function()
        {
            //init default
            $('.js-summernote').summernote(
                {
                    height: 200,
                    tabsize: 2,
                    placeholder: "Type here...",
                    dialogsFade: true,
                    toolbar: [
                        ['style', ['style']],
                        ['font', ['strikethrough', 'superscript', 'subscript']],
                        ['font', ['bold', 'italic', 'underline', 'clear']],
                        ['fontsize', ['fontsize']],
                        ['fontname', ['fontname']],
                        ['color', ['color']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['height', ['height']]
                            ['table', ['table']],
                        ['insert', ['link', 'picture', 'video']],
                        ['view', ['fullscreen', 'codeview', 'help']]
                    ],
                    callbacks:
                        {
                            //restore from localStorage
                            onInit: function(e)
                            {
                                $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                            },
                            onChange: function(contents, $editable)
                            {
                                clearInterval(interval);
                                timer();
                            }
                        }
                });

            //load emojis
            $.ajax(
                {
                    url: 'https://api.github.com/emojis',
                    async: false
                }).then(function(data)
            {
                window.emojis = Object.keys(data);
                window.emojiUrls = data;
            });

            //init emoji example
            $(".js-hint2emoji").summernote(
                {
                    height: 100,
                    toolbar: false,
                    placeholder: 'type starting with : and any alphabet',
                    hint:
                        {
                            match: /:([\-+\w]+)$/,
                            search: function(keyword, callback)
                            {
                                callback($.grep(emojis, function(item)
                                {
                                    return item.indexOf(keyword) === 0;
                                }));
                            },
                            template: function(item)
                            {
                                var content = emojiUrls[item];
                                return '<img src="' + content + '" width="20" /> :' + item + ':';
                            },
                            content: function(item)
                            {
                                var url = emojiUrls[item];
                                if (url)
                                {
                                    return $('<img />').attr('src', url).css('width', 20)[0];
                                }
                                return '';
                            }
                        }
                });

            //init mentions example
            $(".js-hint2mention").summernote(
                {
                    height: 100,
                    toolbar: false,
                    placeholder: "type starting with @",
                    hint:
                        {
                            mentions: ['jayden', 'sam', 'alvin', 'david'],
                            match: /\B@(\w*)$/,
                            search: function(keyword, callback)
                            {
                                callback($.grep(this.mentions, function(item)
                                {
                                    return item.indexOf(keyword) == 0;
                                }));
                            },
                            content: function(item)
                            {
                                return '@' + item;
                            }
                        }
                });

        });

    </script>

    <!-- Search Selecet -->
    <script>
        $(document).ready(function () {
            $(function () {
                $(".select2").select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State",
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0,
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items",
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true,
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm;
                    },
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
                }

                $("#Emp").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllEmps",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllEmpsJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#Emp').empty();
                                    $.each(data, function(key, value){

                                        $('#Emp').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $("#Emp").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });

                $("#client").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllClientsFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {

                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllClientsFilterJS/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#client').empty();
                                    $.each(data, function(key, value){

                                        $('#client').append('<option value="'+ key +'">' + value + '</option>');

                                    });

                                    var countryId = $('#client').val();
                                    if(countryId) {
                                        $.ajax({
                                            url: 'AccountBalanceSOFilter/'+countryId,
                                            type:"GET",
                                            dataType:"json",
                                            beforeSend: function(){
                                                $('#loader').css("visibility", "visible");
                                            },

                                            success:function(data) {
                                                $.each(data, function(key, value){


                                                    $('#AccountCredit').val(key);
                                                    $('#AccountCredit').val(value);
                                                });
                                            },
                                            complete: function(){
                                                $('#loader').css("visibility", "hidden");
                                            }
                                        });
                                    } else {

                                        $('select[name="state"]').empty();
                                    }



                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $("#client").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });


                $('#AccountCodeF').select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllClientsFilter',
                        processResults: function (data) {
                            return {
                                results: $.map(data, function(obj, index) {
                                    return { id: index, text: obj };
                                })
                            };

                            console.log(data);

                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllClientsFilterJS/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#AccountCodeF').empty();
                                    $.each(data, function(key, value){

                                        $('#AccountCodeF').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    }
                });


                $('#AccountCodeF').on('select2:select', function (e) {
                    console.log("select done", e.params.data);
                });




                $('#AccountCodee').select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllClientsFilter',
                        processResults: function (data) {
                            return {
                                results: $.map(data, function(obj, index) {
                                    return { id: index, text: obj };
                                })
                            };

                            console.log(data);

                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllClientsFilterJS/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#AccountCodee').empty();
                                    $.each(data, function(key, value){

                                        $('#AccountCodee').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    }
                });


                $('#AccountCodee').on('select2:select', function (e) {
                    console.log("select done", e.params.data);
                });







            });
        });
    </script>

    <script>
        $('#select_all_emps').click(function() {

            $("#Emp").select2("destroy");
            $("#Emp").find('option').attr('selected',true);
            $("#Emp").select2();

        });


        $('#remove_all_emps').click(function() {
            $("#Emp").select2("destroy");
            $("#Emp").find('option').attr('selected',false);
            $("#Emp").select2();
        });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demorabiherp/public_html/resources/views/admin/Settings/EmpMail.blade.php ENDPATH**/ ?>