<?php
    use App\Models\CompanyData;
    $def=CompanyData::latest('id')->first();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <!-- Tailwind CSS is loaded for modern, responsive styling -->
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        /* Define a clean, modern font */
        @import  url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #014b2a; /* The exact color you requested */
            background-image: linear-gradient(135deg, rgba(0, 0, 0, 0.4) 0%, rgba(0, 0, 0, 0.1) 100%);
        }
    </style>
</head>
<body class="flex items-center justify-center min-h-screen text-gray-100 p-4">

    <div class="p-12 rounded-3xl shadow-2xl max-w-lg w-full text-center bg-white bg-opacity-10 backdrop-filter backdrop-blur-lg border border-white border-opacity-20 transition-all duration-300 transform hover:scale-105">
        
        <!-- Animated 404 text -->
        <h1 class="text-7xl md:text-8xl font-extrabold text-white mb-4 animate-bounce-in" style="color: #cd9b27">
         <?php echo $__env->yieldContent('code'); ?>
        </h1>
        
        <!-- Error icon -->
        <div class="text-5xl text-red-400 mb-6 mx-auto w-16 h-16 flex items-center justify-center rounded-full bg-red-400 bg-opacity-20">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" class="w-10 h-10">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.47-1.668 1.49-2.903L13.493 3.903c-.98-1.235-2.671-1.235-3.651 0L3.012 16.097c-.98 1.235-.05 2.903 1.49 2.903z" />
            </svg>
        </div>

        <!-- Heading and message -->
        <h2 class="text-3xl md:text-4xl font-bold text-white mb-3" style="color: #cd9b27">
        <?php echo $__env->yieldContent('message'); ?>
        </h2>

        <!-- Placeholder for the logo -->
        <div class="mb-8">
            <img src="<?php echo e(URL::to($def->Logo_Store)); ?>" alt="Placeholder Logo" class="mx-auto rounded-xl shadow-lg">
        </div>

        <!-- Back button -->
        <a href="<?php echo e(url('/')); ?>" class="inline-block px-8 py-3 bg-white text-gray-800 font-bold rounded-full transition-colors duration-300 hover:bg-gray-200 hover:shadow-lg transform hover:-translate-y-1" style="color: #cd9b27; background: #054023">
<?php echo e(trans('admin.Back')); ?>

        
        </a>
    </div>

</body>
    
    
    <style>
    .text-red-400 {
    --tw-text-opacity: 1;
    color: rgb(205 155 39) !important;
}
    </style>
</html>


<?php /**PATH /home/demorabiherp/public_html/resources/views/errors/minimal.blade.php ENDPATH**/ ?>