
<?php $__env->startSection('content'); ?>

<title><?php echo e(trans('admin.ProfitsReportGroup')); ?></title>

<style>
/* ===========================
   تنسيق الأزرار
=========================== */
.btn.btn-primary {
  display: inline-block;
  width: 100%;
  max-width: 260px;
  height: 65px;
  line-height: 60px;
  font-size: 18px;
  font-weight: 600;
  border-radius: 15px;
  background: linear-gradient(135deg, #155a4b, #3f7d5f, #cc9b27);
  border: none;
  color: #fff;
  text-align: center;
  transition: all 0.3s ease;
  box-shadow: 0 6px 15px rgba(0, 91, 255, 0.3);
  position: relative;
  overflow: hidden;
  text-decoration: none;
}

.btn.btn-primary::before {
  content: "";
  position: absolute;
  top: 0;
  left: -100%;
  width: 100%;
  height: 100%;
  background: linear-gradient(120deg,
    rgba(255, 255, 255, 0.3) 0%,
    rgba(255, 255, 255, 0.1) 50%,
    transparent 100%);
  transition: all 0.6s ease;
}

.btn.btn-primary:hover::before {
  left: 100%;
}

.btn.btn-primary:hover {
  transform: translateY(-4px) scale(1.03);
background: linear-gradient(135deg, #155a4b, #0b8a6a, #cc9b27);
  box-shadow: 0 10px 25px rgba(0, 91, 255, 0.4);
}

.btn.btn-primary:active {
  transform: translateY(0);
  box-shadow: 0 4px 10px rgba(0, 91, 255, 0.2);
}

/* ===========================
   خلفية الصفحة
=========================== */
body {
  background: linear-gradient(135deg, #e9f0ff 0%, #f9fbff 100%);
  font-family: 'Cairo', sans-serif;
  transition: background 0.5s ease-in-out;
  min-height: 100vh;
}

body::before {
  content: "";
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-image:
    radial-gradient(circle at 20% 20%, rgba(0, 120, 255, 0.08), transparent 70%),
    radial-gradient(circle at 80% 80%, rgba(0, 150, 255, 0.08), transparent 70%);
  z-index: -1;
  pointer-events: none;
}

/* ===========================
   تنسيق الـ Panels
=========================== */
.panel {
  background: #fff;
  border-radius: 15px;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.07);
  padding: 25px;
  transition: all 0.3s ease;
}

.panel:hover {
  box-shadow: 0 12px 35px rgba(0, 0, 0, 0.12);
}

/* ===========================
   العناوين
=========================== */
.panel-hdr h2 {
  font-size: 24px;
  font-weight: 700;
  color: #155a4b;
  letter-spacing: 0.5px;
  text-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
  margin-bottom: 0;
  text-align: center;
  width: 100%;
}
</style>

<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb no-print">
        <li class="breadcrumb-item"><a href="javascript:void(0);"> <?php echo e(trans('admin.Reports')); ?> </a></li>
        <li class="breadcrumb-item active"><?php echo e(trans('admin.ProfitsReportGroup')); ?> </li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>

    <div class="row">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                    <h2>
                        <span class="fw-300"><i>  <?php echo e(trans('admin.ProfitsReportGroup')); ?></i></span>
                    </h2>
                </div>
                <div class="panel-container show">
                    <div class="panel-content">
                        <div class="row">

                            <?php if($ReportsSettings->ProductProfits == 1): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تقرير ارباح اصناف')): ?>
                                <div class="col-md-3 mt-2">
                                    <a href="<?php echo e(url('ProductProfitsNew')); ?>" class="btn btn-primary">
                                        <?php echo e(trans('admin.ProductProfits')); ?>

                                    </a>
                                </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if($ReportsSettings->ExceptProductProfits == 1): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تقرير ارباح اصناف متوقعه')): ?>
                                <div class="col-md-3 mt-2">
                                    <a href="<?php echo e(url('ProductProfits')); ?>" class="btn btn-primary">
                                        <?php echo e(trans('admin.ExceptProductProfits')); ?>

                                    </a>
                                </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if($ReportsSettings->ExceptProfits == 1): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('الارباح المتوقعه')): ?>
                                <div class="col-md-3 mt-2">
                                    <a href="<?php echo e(url('ExceptProfits')); ?>" class="btn btn-primary">
                                        <?php echo e(trans('admin.ExceptProfits')); ?>

                                    </a>
                                </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if($ReportsSettings->ProfitSalesProduct == 1): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تقرير ربحيه اصناف مباعه')): ?>
                                <div class="col-md-3 mt-2">
                                    <a href="<?php echo e(url('ProfitSalesProduct')); ?>" class="btn btn-primary">
                                        <?php echo e(trans('admin.ProfitSalesProduct')); ?>

                                    </a>
                                </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if($ReportsSettings->ProfitGroupsReport == 1): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تقرير ربح مجموعات')): ?>
                                <div class="col-md-3 mt-2">
                                    <a href="<?php echo e(url('ProfitGroupsReport')); ?>" class="btn btn-primary">
                                        <?php echo e(trans('admin.ProfitGroupsReport')); ?>

                                    </a>
                                </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if($ReportsSettings->CompareSalesPrice == 1): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تقرير مقارنه اسعار بيع')): ?>
                                <div class="col-md-3 mt-2">
                                    <a href="<?php echo e(url('CompareSalesPrice')); ?>" class="btn btn-primary">
                                        <?php echo e(trans('admin.CompareSalesPrice')); ?>

                                    </a>
                                </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if($ReportsSettings->Profits == 1): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('الارباح')): ?>
                                <div class="col-md-3 mt-2">
                                    <a href="<?php echo e(url('Profits')); ?>" class="btn btn-primary">
                                        <?php echo e(trans('admin.Profits')); ?>

                                    </a>
                                </div>
                                <?php endif; ?>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demorabiherp/public_html/resources/views/admin/Reports/Pages/Profits.blade.php ENDPATH**/ ?>