<?php
use App\Models\CompanyData;
use App\Models\LoginSlider;
$Def=CompanyData::orderBy('id','desc')->first();
$Sliders=LoginSlider::all();
?>


<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <title> <?php echo e(isset($Def->NameEn) ? $Def->NameEn : 'RABIH'); ?> - <?php echo e(trans('admin.Welcome')); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
     
    <?php if(isset($Def->Icon)): ?>
        <link rel="icon" type="image/png" href="<?php echo e(URL::to($Def->Icon)); ?>">
    <?php endif; ?>

    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Cairo', sans-serif;
            background: linear-gradient(135deg, #205952 0%, #cd9b27 100%);
            color: #fff;
            overflow-x: hidden;
            direction: rtl;
            text-align: right;
        }

        .container-fluid {
            min-height: 100vh;
        }

        .branch-info {
            background-color: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
            border-radius: 1rem;
            transition: transform 0.3s ease;
        }
        
        .branch-info:hover {
            transform: translateY(-5px);
        }

        .play-btn {
            animation: pulse 2s infinite;
        }
        
        @keyframes  pulse {
            0% { transform: scale(1); box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.4); }
            70% { transform: scale(1.1); box-shadow: 0 0 0 10px rgba(255, 255, 255, 0); }
            100% { transform: scale(1); box-shadow: 0 0 0 0 rgba(255, 255, 255, 0); }
        }

        .modal {
            display: none;
            position: fixed;
            z-index: 100;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.8);
            justify-content: center;
            align-items: center;
        }
        
        .modal-content {
            position: relative;
            background: #000;
            padding: 1rem;
            border-radius: 0.5rem;
            max-width: 90%;
            max-height: 90%;
        }
        
            .video-container {
            width: 80vw; /* 80% of the viewport width */
            height: 45vw; /* This maintains a 16:9 aspect ratio (9 / 16 = 0.5625, 80 * 0.5625 = 45) */
            max-width: 1280px; /* Optional: limit the maximum size on very large screens */
            max-height: 720px;
        }

        /*
         * The iframe itself is set to fill 100% of its parent container.
         * This makes it fully responsive to the size of .video-container.
         */
        .video-container iframe {
            width: 100%;
            height: 100%;
        }

        .close-btn {
            position: absolute;
            top: 10px;
            right: 20px;
            font-size: 2rem;
            font-weight: bold;
            cursor: pointer;
            color: #fff;
        }

        iframe {
            width: 100%;
            height: 100%;
            aspect-ratio: 16 / 9;
        }
        
        .module-card {
            background-color: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
            transition: transform 0.3s ease, background-color 0.3s ease;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            gap: 0.5rem;
            padding: 1rem; /* Reduced padding slightly */
            text-align: center;
            width: 140px; /* Reduced width */
            height: 140px; /* Reduced height */
        }

        .module-card:hover {
            transform: translateY(-5px) scale(1.05);
            background-color: rgba(255, 255, 255, 0.2);
        }
        
        .module-card i {
            font-size: 1.75rem; /* Reduced icon size */
        }
        
    </style>
</head>

<body class="flex items-center justify-center min-h-screen">
    <div class="container-fluid flex flex-col md:flex-row items-center justify-center p-8">

        <!-- Left Section - Main Content & Video -->
        <div class="flex-1 flex flex-col items-center justify-center p-8 md:p-12 text-center md:text-right">
        
            <h1 class="text-4xl md:text-6xl font-bold mb-4"> رابح ERP</h1>
            
        
            <p class="text-lg md:text-xl max-w-lg mb-8">
                نظام تخطيط موارد المؤسسات الشامل الذي يربط جميع أقسام شركتك في منصة واحدة لزيادة الإنتاجية وتحقيق النجاح.
            </p>
            <div class="flex flex-col md:flex-row items-center justify-center md:justify-start space-y-4 md:space-y-0 md:space-x-4">
                <a href="<?php echo e(url('KlarAdmin')); ?>" class="px-8 py-3 bg-[#cd9b27] text-white font-bold rounded-full transition-all duration-300 hover:bg-white hover:text-[#205952] shadow-lg">
                    Start Now / ابدأ الآن
                </a>
                <button id="open-video-modal" class="w-12 h-12 rounded-full bg-white flex items-center justify-center shadow-lg transition-transform duration-300 transform hover:scale-110 play-btn">
                    <svg class="w-6 h-6 text-[#cd9b27]" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM9.555 7.168A1 1 0 008 8v4a1 1 0 001.555.832l3-2a1 1 0 000-1.664l-3-2z" clip-rule="evenodd"></path>
                    </svg>
                </button>
            </div>

            <!-- New Section for ERP Modules -->
            <div class="mt-12 w-full max-w-xl text-center md:text-center">
            
           <img src="<?php echo e(asset('Admin/BG2.png')); ?>" alt="وحدات نظام رابح ERP" class="w-full rounded-2xl shadow-xl mb-6 mx-auto md:mx-0">
                
                
                
                <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-4 text-sm justify-items-center">
                     
                    <div class="module-card p-4 rounded-xl flex flex-col items-center gap-2">
                        <i class="fas fa-dollar text-3xl mb-2 text-[#145a4b]"></i>
                        <span class="text-white font-bold">المبيعات والمشتريات</span>
                        <span class="text-gray-300 text-xs">(Sales & Purchases)</span>     
                    </div>
                     
                    <div class="module-card p-4 rounded-xl flex flex-col items-center gap-2">
                        <i class="fas fa-box text-3xl mb-2 text-[#145a4b]"></i>
                        <span class="text-white font-bold">المخزون</span>
                        <span class="text-gray-300 text-xs">(Inventory)</span>
                    </div>
                    <div class="module-card p-4 rounded-xl flex flex-col items-center gap-2">
                        <i class="fas fa-chart-line text-3xl mb-2 text-[#145a4b]"></i>
                        <span class="text-white font-bold">المالية</span>
                        <span class="text-gray-300 text-xs">(Finance)</span>
                    </div>
                    <div class="module-card p-4 rounded-xl flex flex-col items-center gap-2">
                        <i class="fas fa-store text-3xl mb-2 text-[#145a4b]"></i>
                        <span class="text-white font-bold">التجارة الإلكترونية</span>
                        <span class="text-gray-300 text-xs">(E-commerce)</span>
                    </div>
                    <div class="module-card p-4 rounded-xl flex flex-col items-center gap-2">
                        <i class="fas fa-industry text-3xl mb-2 text-[#145a4b]"></i>
                        <span class="text-white font-bold">الإنتاج</span>
                        <span class="text-gray-300 text-xs">(Production)</span>
                    </div>
                    <div class="module-card p-4 rounded-xl flex flex-col items-center gap-2">
                        <i class="fas fa-users text-3xl mb-2 text-[#145a4b]"></i>
                        <span class="text-white font-bold">الموارد البشرية</span>
                        <span class="text-gray-300 text-xs">(Human Resources)</span>
                    </div>
                    <div class="module-card p-4 rounded-xl flex flex-col items-center gap-2">
                        <i class="fas fa-handshake text-3xl mb-2 text-[#145a4b]"></i>
                        <span class="text-white font-bold">إدارة علاقات العملاء</span>
                        <span class="text-gray-300 text-xs">(CRM)</span>
                    </div>
                    <div class="module-card p-4 rounded-xl flex flex-col items-center gap-2">
                        <i class="fas fa-truck text-3xl mb-2 text-[#145a4b]"></i>
                        <span class="text-white font-bold">الشحن</span>
                        <span class="text-gray-300 text-xs">(Shipping)</span>
                    </div>
                    <div class="module-card p-4 rounded-xl flex flex-col items-center gap-2">
                        <i class="fas fa-utensils text-3xl mb-2 text-[#145a4b]"></i>
                        <span class="text-white font-bold">المطاعم</span>
                        <span class="text-gray-300 text-xs">(Restaurants)</span>
                    </div>
                    <div class="module-card p-4 rounded-xl flex flex-col items-center gap-2">
                        <i class="fas fa-file-invoice-dollar text-3xl mb-2 text-[#145a4b]"></i>
                        <span class="text-white font-bold">الفواتير الاكترونيه</span>
                        <span class="text-gray-300 text-xs">(E-Invoicing)</span>
                    </div>
                    <div class="module-card p-4 rounded-xl flex flex-col items-center gap-2">
                        <i class="fas fa-building text-3xl mb-2 text-[#145a4b]"></i>
                        <span class="text-white font-bold">العقارات</span>
                        <span class="text-gray-300 text-xs">(Real Estate)</span>
                    </div>
                    <div class="module-card p-4 rounded-xl flex flex-col items-center gap-2">
                        <i class="fas fa-lock text-3xl mb-2 text-[#145a4b]"></i>
                        <span class="text-white font-bold">الامانات</span>
                        <span class="text-gray-300 text-xs">(Deposits)</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Section - Image & Branches -->
        <div class="flex-1 flex flex-col items-center p-8 md:p-12 mt-8 md:mt-0">
    
        <img src="<?php echo e(asset('Admin/LOGO.png')); ?>" alt="RABIH ERP System" class="w-full max-w-xl rounded-2xl">
        
            <!-- Branch Info Section -->
            <div class="mt-8 flex flex-col gap-4 w-full max-w-xl">
                <div class="branch-info p-4 text-center">
                    <img src="https://flagcdn.com/eg.svg" alt="علم مصر" class="w-10 h-auto rounded-md mx-auto mb-2">
                    <h3 class="font-bold">المكتب الرئيسي (مصر)</h3>
                    <p class="text-sm">+2 01062201060</p>
                </div>
                <div class="branch-info p-4 text-center">
                    <img src="https://flagcdn.com/sa.svg" alt="علم السعودية" class="w-10 h-auto rounded-md mx-auto mb-2">
                    <h3 class="font-bold">المملكة العربية السعودية</h3>
                    <p class="text-sm">+966 533260412</p>
                </div>
                <div class="branch-info p-4 text-center">
                    <img src="https://flagcdn.com/qa.svg" alt="علم قطر" class="w-10 h-auto rounded-md mx-auto mb-2">
                    <h3 class="font-bold">قطر</h3>
                    <p class="text-sm">+2 01062201060</p>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Video Modal -->
    <div id="video-modal" class="modal">
        <span class="close-btn">&times;</span>
        <div class="modal-content">
                <div class="video-container rounded-lg overflow-hidden">
           <video id="myVideo" controls autoplay style="width:70vw; height:auto; max-height:70vh; display:block;">
      <source src="<?php echo e(asset('Admin/video.mp4')); ?>" type="video/mp4">
      متصفحك لا يدعم تشغيل الفيديو.
    </video>
        </div>

        </div>
    </div>

    <!-- JavaScript for Modal Functionality -->
    <script>
        const videoModal = document.getElementById('video-modal');
        const openModalBtn = document.getElementById('open-video-modal');
        const closeModalBtn = document.querySelector('.close-btn');
        const videoPlayer = document.getElementById('video-player');

        openModalBtn.onclick = function() {
            videoModal.style.display = 'flex';
            const src = videoPlayer.src;
            videoPlayer.src = src + "?autoplay=1";
        }
        
        closeModalBtn.onclick = function() {
            videoModal.style.display = 'none';
            videoPlayer.src = videoPlayer.src.split("?")[0];
        }
        
        window.onclick = function(event) {
            if (event.target == videoModal) {
                videoModal.style.display = 'none';
                videoPlayer.src = videoPlayer.src.split("?")[0];
            }
        }
    </script>
</body>
</html>
<?php /**PATH /home/demorabiherp/public_html/resources/views/welcome.blade.php ENDPATH**/ ?>