<?php
use App\Models\ProductSales;
use App\Models\CompanyData;
use App\Models\Addressses;
$Def=CompanyData::orderBy('id','desc')->first();
?>
<!doctype html>
<html>
   <head>
      <meta charset="utf-8">
      <title><?php echo e(trans('admin.Sales')); ?></title>
      <meta http-equiv="cache-control" content="max-age=0"/>
      <meta http-equiv="cache-control" content="no-cache"/>
      <meta http-equiv="expires" content="0"/>
      <meta http-equiv="pragma" content="no-cache"/>
      <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/styles.css')); ?>">
      <style type="text/css" media="all">
         body {
         color: #000;
         text-align:right;
         direction:rtl!important;
         }
         .well{
         background-color:white;
         }
         td ,th{
         background: white!important;
         }
         .table{
         margin-bottom:7px;
         }
         .th-td-width th,.th-td-width td{
         padding:0!important;
         }
         .alert{
         padding-bottom:0;
         margin-bottom:0;
         padding-top:0;
         margin-top:0;
         }
         .alert h1{
         margin:0;
         }
         #wrapper { max-width: 600px; margin: 0 auto; padding-top: 20px; }
         .btn { margin-bottom: 5px; }
         .table { border-radius: 3px; }
         .table th { background: #f5f5f5; }
         .table th, .table td { vertical-align: middle !important; }
         h3 { margin: 5px 0; }
         .table-bordered{
         border: 1px solid #746f6f;
         }
         .table-bordered>thead>tr>th ,.table-bordered>tbody>tr>td {
         border: 1px solid #746f6f;
         }
         .col-lg-6,.col-lg-12, .col-xs-6{
         float:right;
         }
         @media  print {
         .no-print { display: none; }
         #buttons { display: none; }
         #wrapper { max-width: 480px; width: 100%; min-width: 250px; margin: 0 auto; }
         }
         .text-right { text-align: left; }
         .text-left { text-align: right; }
         tfoot tr th:first-child { text-align: left; }
      </style>
      <!--English style-->
      <!--<style>-->
      <!--    body{-->
      <!--        direction:ltr;-->
      <!--        text-align:left;-->
      <!--    }-->
      <!--    .col-lg-6,.col-lg-12, .col-xs-6{-->
      <!--        float:left;-->
      <!--    }-->
      <!--</style>-->
   </head>

   <body>


      <div>
         <div id="receiptData" style="width: auto; max-width: 600px; min-width: 250px; margin: 0 auto;overflow: hidden;">
            <div class="no-print" >
               <div style="text-align:center;" class="alert">
                  <button data-dismiss="alert" class="close" type="button"></button>
                  <?php if(!empty($Def->Name_Sales_Bill)): ?>
                  <h1 style="font-weight: 900;color: black">    <?php echo e(app()->getLocale() == 'ar' ?$Def->Name_Sales_Bill :$Def->Name_Sales_Bill_En); ?>     </h1>
                  <?php else: ?>
                  <h1><?php echo e(trans('admin.Sales')); ?></h1>
                  <?php endif; ?>
               </div>
            </div>
            <div id="receipt-data">
               <div>
                  <div style="text-align:center;margin-bottom:10px;">
                     <?php if(!empty($Def->Logo)): ?>
                     <img style="text-align:center;  height: 60px;"  src="<?php echo e(URL::to($Def->Logo)); ?>" alt="Logo" />
                     <?php else: ?>
                     <img style="text-align:center; height: 60px;"  src="<?php echo e(asset('Admin/img/theme/logo.png')); ?>" alt="Logo" />
                     <?php endif; ?>
                  </div>
                   <table style="border-style: solid;" class="table table-bordered table-striped table-condensed text-center">
                       <tr>
                           <td style="padding: 0;"><?php echo e($Def->Phone1); ?></td>
                           <td style="padding: 0;"><?php echo e($Def->Phone2); ?></td>
                       </tr>
                       <tr>
                           <td style="padding: 0;"><?php echo e($Def->Phone3); ?></td>
                           <td style="padding: 0;"><?php echo e($Def->Phone4); ?></td>
                       </tr>
                       </table>
                  <div class="row">
              <div style="font-weight: 500;color: black;font-size: 11px;" class="col-lg-2 col-xs-3 text-center">
                        <!--<?php echo e(trans('admin.Code')); ?>  :- <?php echo e($item->Code); ?>   -->
                       <span style="border: 1px solid black;border-radius: 4px;padding:3px;"> <?php echo e($item->Code); ?> </span>
                     </div>

                     <div style="font-weight: 500;color: black;font-size: 11px;" class="col-lg-4 col-xs-4">
                         <?php echo e($item->Date); ?>

                     </div>
                     <div style="font-weight: 900;color: black;font-size: 11px;" class="col-lg-6 col-xs-5">
                         <?php echo e(trans('admin.Client')); ?>  :- <?php echo e(app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn); ?>


                     </div>
                  </div>
                   <div class="row">
              <div style="font-weight: 500;color: black;font-size: 11px; display: none" class="col-lg-2 col-xs-3 text-center">
                       <?php echo e(trans('admin.Saler')); ?>  :-  <?php if(!empty($item->Sale_User)): ?>

                   <?php echo e(app()->getLocale() == 'ar' ?$item->Sale_User()->first()->name :$item->Sale_User()->first()->nameEn); ?>

                                         <?php endif; ?>

                     </div>

                     <div style="font-weight: 500;color: black;font-size: 11px;" class="col-lg-4 col-xs-4">
                         <?php echo e(date('h:m')); ?>

                     </div>
                     <div style="font-weight: 900;color: black;font-size: 11px;" class="col-lg-6 col-xs-5">
                        <?php echo e(trans('admin.Casher')); ?>  :- <?php echo e(app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn); ?>

                     </div>
                  </div>
                    <?php if($item->Payment_Method == 'Delivery'): ?>
<?php  $Address=Addressses::find($item->Client_Address);   ?>

                                        <?php if(!empty($Address)): ?>
                   <div class="row">
                       <div class="col-lg-4">
                           <?php echo e(trans('admin.Place')); ?> :-    <?php if(!empty($Address)): ?>

                            <?php echo e(app()->getLocale() == 'ar' ?$Address->Place()->first()->Arabic_Name :$Address->Place()->first()->English_Name); ?>

                           <?php endif; ?>
                       </div>
                       <div class="col-lg-4">
                           <?php echo e(trans('admin.City')); ?> :-    <?php if(!empty($Address)): ?>

                                <?php echo e(app()->getLocale() == 'ar' ?$Address->City()->first()->Arabic_Name :$Address->City()->first()->English_Name); ?>

                           <?php endif; ?>
                       </div>
                       <div class="col-lg-4">
                           <?php echo e(trans('admin.Governrate')); ?> :-    <?php if(!empty($Address)): ?>

                            <?php echo e(app()->getLocale() == 'ar' ?$Address->Governrate()->first()->Arabic_Name :$Address->Governrate()->first()->English_Name); ?>

                           <?php endif; ?>
                       </div>

                       <div class="col-lg-4">
                           <?php echo e(trans('admin.Floor')); ?> :- <?php echo e($Address->Floor); ?>

                       </div>
                       <div class="col-lg-4">
                           <?php echo e(trans('admin.Buliding')); ?> :- <?php echo e($Address->Buliding); ?>

                       </div>
                       <div class="col-lg-4">
                           <?php echo e(trans('admin.Street')); ?> :- <?php echo e($Address->Street); ?>

                           </div>
                       <div class="col-lg-4"><?php echo e(trans('admin.Details')); ?> :- <?php echo e($Address->Details); ?></div>
                       <div class="col-lg-4"><?php echo e(trans('admin.Special_Mark')); ?> :- <?php echo e($Address->Special_Mark); ?></div>
                       <div class="col-lg-4"><?php echo e(trans('admin.Flat')); ?> :- <?php echo e($Address->Flat); ?></div>

                                        <?php endif; ?>
                                                <?php endif; ?>
                   </div>
                  <div style="clear:both;margin-top:8px;"></div>
                  <table  class="table table-bordered table-striped table-condensed th-td-width">
                     <thead>
                        <tr>
                           <th style="width: 60%;"><?php echo e(trans('admin.Name')); ?></th>
                           <th style="width: 12%; "><?php echo e(trans('admin.Qty')); ?></th>
                           <th style="width: 14%;"><?php echo e(trans('admin.Price')); ?></th>
                           <th style="width: 14%;"><?php echo e(trans('admin.Total')); ?></th>
                        </tr>
                     </thead>
                     <tbody style="font-weight: bold;">
                        <?php
                        $details=ProductSales::where('Sales',$item->id)->get();
                        ?>
                        <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                           <td class="text-center">
                            <?php echo e(app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name); ?>


     <?php if(!empty($detail->V1)): ?>   (<?php echo e(app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn); ?>  )  <?php endif; ?>
                                  <?php if(!empty($detail->V2)): ?>    ((<?php echo e(app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn); ?>  ))  <?php endif; ?>
                           </td>
                           <td class="text-center">
                              <?php echo e($detail->Qty); ?>

                           </td>
                           <td class="text-center">
                       <?php echo e(number_format((float)abs($detail->Price), 2, '.', '')); ?>

                           </td>
                           <td class="text-center">
                         <?php echo e(number_format((float)abs($detail->Total), 2, '.', '')); ?>

                           </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     </tbody>
                  </table>
                  <table  style="border-style: solid;" class="table table-bordered table-striped table-condensed">
                     <thead>
                        <tr>
                           <th class="text-center" style="width: 35%; border-bottom: 2px solid #ddd;"><?php echo e(trans('admin.Product_Numbers')); ?></th>
                           <th class="text-center" style="width: 15%; border-bottom: 2px solid #ddd;"><?php echo e($item->Product_Numbers); ?></th>
                           <th class="text-center" style="width: 35%; border-bottom: 2px solid #ddd;"><?php echo e(trans('admin.Total_Qty')); ?></th>
                           <th class="text-center" style="width: 15%; border-bottom: 2px solid #ddd;">
                               <?php echo e(number_format((float)$item->Total_Qty, 2, '.', '')); ?>

                            </th>
                        </tr>
                        <tr>
                           <th class="text-center" style="width: 30%; border-bottom: 2px solid #ddd;"><?php echo e(trans('admin.Total_Discount')); ?></th>
                           <th class="text-center" style="width: 20%; border-bottom: 2px solid #ddd;">
                        <?php echo e(number_format((float)$item->Total_Discount, 2, '.', '')); ?>

                            </th>
                           <th class="text-center" style="width: 30%; border-bottom: 2px solid #ddd;"><?php echo e(trans('admin.Total_Taxes')); ?></th>
                           <th class="text-center" style="width: 20%; border-bottom: 2px solid #ddd;">
                               <?php echo e(number_format((float)$item->Total_Taxes, 2, '.', '')); ?>

                           </th>
                        </tr>
                     </thead>
                  </table>
                  <table style="border-style: double;font-size: 20px;font-weight: bold;"class="table table-bordered table-striped table-condensed">
                     <tbody>
                        <?php if($item->Payment_Method == 'Delivery'): ?>

                           <td class="text-center"> <?php echo e(trans('admin.Total_Bf_Delivery')); ?> </td>
                           <td class="text-center"> <?php echo e(number_format((float)$item->Total_Price, 2, '.', '')); ?> </td>
                          <td class="text-center"> <?php echo e(trans('admin.Delivery_Amount')); ?> </td>
                          <td class="text-center"><?php echo e(number_format((float)$Address->Place()->first()->Ship_Price, 2, '.', '')); ?> </td>
                          <td class="text-center"> <?php echo e(trans('admin.The_Net')); ?> </td>
                           <td class="text-center"><?php echo e(number_format((float)$item->Pay, 2, '.', '')); ?> </td>
                           </tbody>
                  </table>
                  <table style="border-style: double;font-size: 20px;font-weight: bold;"class="table table-bordered  table-striped table-condensed">
                     <tbody>
                          <td class="text-center"> <?php echo e(trans('admin.Total_Af_Delivery')); ?> </td>
                          <td class="text-center"><?php echo e(number_format((float)$item->Total_Price + $Address->Place()->first()->Ship_Price, 2, '.', '')); ?>  </td>
                         <td class="text-center">    <?php echo e(trans('admin.Total_Pay_With_Delivery')); ?> </td>
                        <td class="text-center"><?php echo e(number_format((float)$item->Pay + $Address->Place()->first()->Ship_Price, 2, '.', '')); ?>  </td>
                         <?php else: ?>
                        <tr>
                           <td class="text-center"> <?php echo e(trans('admin.Total_Price')); ?> </td>
                           <td class="text-center"><?php echo e(number_format((float)$item->Total_Price, 2, '.', '')); ?> </td>

                            <td class="text-center"> <?php echo e(trans('admin.The_Net')); ?> </td>
                           <td class="text-center"><?php echo e(number_format((float)$item->Pay, 2, '.', '')); ?> </td>
                        </tr>
                         <?php endif; ?>
                     </tbody>
                  </table>
                  <div class="well well-sm"  style="margin:7px 0;">
                     <div style="text-align: center;font-weight: 900;font-size: 12px;">    <?php if(!empty($Def->Print_Text)): ?>
                        <?php echo e($Def->Print_Text); ?>

                        <?php endif; ?>
                     </div>
                  </div>
                  <div >
                     <div style="text-align: center;">
                        <?php
                        $x=$item->Code;
                        $y=DNS1D::getBarcodePNG($x, 'C39');
                        ?>
                        <img src="data:image/png;base64,<?php echo e($y); ?>" id="barcode"  class="height-3 mt-1" />
                     </div>
                  </div>
               </div>
               <div style="clear:both;"></div>
            </div>
            <div class="row" style="display:none">
               <?php if(!empty($Def->Print_Text_Footer)): ?>
               <?php echo html_entity_decode($Def->Print_Text_Footer)  ?>
               <?php endif; ?>
            </div>
            <div class="row" style="display:none">
               <?php if(!empty($Def->Seal)): ?>
               <img src="<?php echo e(URL::to($Def->Seal)); ?>" class="img-fluid"  />
               <?php endif; ?>
            </div>

             <div class="row">

                 <div class="col-md-3">
                     <?php if(!empty($item->Edit)): ?>
                         <?php if($item->Edit == 1): ?>

                             <img src="<?php echo e(asset('Admin/Edit.png')); ?>" class="img-fluid" style="width: 50%" />
                         <?php endif; ?>
                     <?php endif; ?>
                     <?php if(!empty($item->Delete)): ?>
                         <?php if($item->Delete == 1): ?>

                             <img src="<?php echo e(asset('Admin/Cancel.png')); ?>" class="img-fluid" style="width: 50%" />
                         <?php endif; ?>
                     <?php endif; ?>
                     <?php if(!empty($item->Transfer)): ?>
                         <?php if($item->Transfer == 1): ?>

                             <img src="<?php echo e(asset('Admin/Tarnsfer.png')); ?>" class="img-fluid" style="width: 50%" />
                         <?php endif; ?>
                     <?php endif; ?>
                 </div>

             </div>
            <!-- start -->
            <div id="buttons" style=" text-transform:uppercase;" class="no-print">
               <hr>
               <div class="btn-group btn-group-justified" role="group" aria-label="...">
                  <div class="btn-group" role="group">
                     <button onclick="window.print();" class="btn btn-block btn-primary"><?php echo e(trans('admin.Print')); ?></button>
                  </div>
                  <div class="btn-group" role="group">
                     <a href="<?php echo e(url()->previous()); ?>" class="btn btn-default" data-dismiss="modal"><?php echo e(trans('admin.Back')); ?></a>
                  </div>
                      <div class="btn-group" role="group">
                        <a href="<?php echo e(url('api/SalesPrintApi/'.$item->id)); ?>" class="btn btn-block btn-success">Mobile Print </a>
                  </div>
                           <div class="btn-group" role="group">
                         <button type="button" onclick="PRINTT(<?php echo e($item->id); ?>)" class="btn btn-block btn-danger">Print Api</button>
                  </div>


               </div>


               <div style="clear:both;"></div>
            </div>
            <!-- end -->
         </div>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.5.3/jspdf.debug.js" integrity="sha384-NaWTHo/8YCBYJ59830LTz/P4aQZK1sS0SneOgAvhsIl3zBu8r9RevNg5lHCHAuQ/" crossorigin="anonymous"></script>

<script src="https://unpkg.com/jspdf@latest/dist/jspdf.min.js"></script>


              <script>

             function x(){
             var doc = new jsPDF();
var elementhtml = document.querySelector("#wrapper").innerHTML;

var specialElementHandlers = {
    '#editor': function (element, renderer) {
        return true;
    }
};

    doc.fromHTML(
        elementhtml,
            15,
            15,
            {
            'width':170,
            'elementHandlers':specialElementHandlers
        }
               );


    doc.save('Bill.pdf');


             }
          </script>

           <script>
 function PRINTT(r){
window.POST_ID.postMessage(r);

 }
  </script>
            <script>window.print()</script>

                   <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
        <script src="<?php echo e(asset('Admin/js/vendors.bundle.js')); ?>"></script>
        <script src="<?php echo e(asset('Admin/js/app.bundle.js')); ?>"></script>
        <script src="<?php echo e(asset('Admin/js/formplugins/select2/select2.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/formplugins/summernote/summernote.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/formplugins/select2/select2.bundle.js')); ?>"></script>

      <script type="text/javascript">
        function disableBack() { window.history.forward(); }
        setTimeout("disableBack()", 0);
        window.onunload = function () { null };
    </script>

      </div>
      <!-- start -->
      <!-- end -->

   </body>
</html>
<?php /**PATH /home/demorabiherp/public_html/resources/views/admin/Sales/SalesPrint8.blade.php ENDPATH**/ ?>