<?php use App\Models\CommentsClients;use App\Models\Customers;use App\Models\Sales; ?>

<?php $__env->startSection('content'); ?>

    <title><?php echo e(trans('admin.CommentsReports')); ?></title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> <?php echo e(trans('admin.CRM')); ?></a></li>
            <li class="breadcrumb-item active"><?php echo e(trans('admin.CommentsReports')); ?></li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i><?php echo e(trans('admin.CommentsReports')); ?></i></span>
                        </h2>

                        <div class="panel-toolbar">

                        </div>
                        <?php echo $__env->make('admin.layouts.toolbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="panel-container show">
                        <span id="ex"> <?php echo $__env->make('admin.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <table
                                   class="table table-bordered table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                <tr>

                                    <th><?php echo e(trans('admin.Client')); ?></th>
                                    <th><?php echo e(trans('admin.Governrate')); ?></th>
                                    <th><?php echo e(trans('admin.City')); ?></th>
                                    <th><?php echo e(trans('admin.Activity')); ?></th>
                                    <th><?php echo e(trans('admin.Phone')); ?></th>
                                    <th><?php echo e(trans('admin.Code')); ?></th>
                                    <th><?php echo e(trans('admin.Date')); ?></th>
                                    <th><?php echo e(trans('admin.Time')); ?></th>
                                    <th><?php echo e(trans('admin.Comment')); ?></th>
                                    <th><?php echo e(trans('admin.Responsible')); ?></th>
                                    <th><?php echo e(trans('admin.Rate_Interview')); ?></th>
                                    <th><?php echo e(trans('admin.Visit_Cost')); ?></th>
                                    <th><?php echo e(trans('admin.Note')); ?></th>
                                    <th><?php echo e(trans('admin.Interview_Type')); ?></th>
                                    <th><?php echo e(trans('admin.Location')); ?></th>

                                </tr>
                                </thead>
                                <tbody>

                                        <?php $__currentLoopData = $Comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                        <td> <?php if(!empty($comment->Customer()->first()->Name)): ?>
                                                <?php echo e(app()->getLocale() == 'ar' ?$comment->Customer()->first()->Name :$comment->Customer()->first()->NameEn); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                           <?php if(!empty($comment->Customer()->first()->Governrate)): ?>
                                            <?php echo e(app()->getLocale() == 'ar' ?$comment->Customer()->first()->Governrate()->first()->Arabic_Name :$comment->Customer()->first()->Governrate()->first()->English_Name); ?>

                                            <?php endif; ?>
                                        </td>
                                                <td>
                                           <?php if(!empty($comment->Customer()->first()->City)): ?>
                                            <?php echo e(app()->getLocale() == 'ar' ?$comment->Customer()->first()->City()->first()->Arabic_Name :$comment->Customer()->first()->City()->first()->English_Name); ?>

                                            <?php endif; ?>
                                        </td>
                                                <td>
                                           <?php if(!empty($comment->Customer()->first()->Activity)): ?>
                                            <?php echo e(app()->getLocale() == 'ar' ?$comment->Customer()->first()->Activity()->first()->Arabic_Name :$comment->Customer()->first()->Activity()->first()->English_Name); ?>

                                            <?php endif; ?>
                                        </td>
                                                <td>

                                                    <?php if(!empty($comment->Customer()->first()->Phone)): ?>
                                            <?php echo e($comment->Customer()->first()->Phone); ?>

                                                    <?php endif; ?>

                                        </td>


                                                <td><?php echo e($comment->Code); ?></td>
                                                <td><?php echo e($comment->Date); ?></td>
                                                <td><?php echo e($comment->Time); ?></td>
                                                <td>   <?php echo e(app()->getLocale() == 'ar' ?$comment->Comment :$comment->CommentEn); ?></td>
                                                <td>
                                                    <?php if(!empty($comment->Responsible()->first()->Name)): ?>
                                                        <?php echo e(app()->getLocale() == 'ar' ?$comment->Responsible()->first()->Name :$comment->Responsible()->first()->NameEn); ?>

                                                    <?php endif; ?>

                                                </td>
                                                <td>

                                                    <?php if(!empty($comment->Rate()->first()->Arabic_Name)): ?>
                                                        <?php echo e(app()->getLocale() == 'ar' ?$comment->Rate()->first()->Arabic_Name :$comment->Rate()->first()->English_Name); ?>

                                                    <?php endif; ?>


                                                </td>
                                                <td><?php echo e($comment->Visit_Cost); ?></td>
                                                <td><?php echo e($comment->Note); ?></td>
                                                <td>
                                                    <?php if(!empty($comment->Type()->first()->Arabic_Name)): ?>
                                                        <?php echo e(app()->getLocale() == 'ar' ?$comment->Type()->first()->Arabic_Name :$comment->Type()->first()->English_Name); ?>

                                                    <?php endif; ?>
                                                </td>

                                                <td>
                                                    <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Loc<?php echo e($comment->id); ?>"><?php echo e(trans('admin.Location')); ?></button>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <!-- datatable end -->
<?php echo e($Comments->Links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>


    </main>

<?php $__currentLoopData = $Comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <!-- Modal Location -->
    <div class="modal fade" id="Loc<?php echo e($comment->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">



                    <iframe src="https://maps.google.com/maps?q=<?php echo e($comment->lat); ?>,<?php echo e($comment->lng); ?>&hl=en&z=14&amp;output=embed" width="100%" height="400" frameborder="0" style="border:0" allowfullscreen></iframe>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?php echo e(trans('admin.Close')); ?></button>

                </div>
            </div>
        </div>
    </div>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <link rel="stylesheet" media="screen, print"
          href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            exportOptions: {
                                format: {
                                    body: function ( inner, rowidx, colidx, node ) {
                                        if ($(node).children("select").length > 0) {
                                            // we are in a cell containing a "select" drop-down - so, get it:
                                            var selectNode = node.firstElementChild;
                                            var txt = selectNode.options[selectNode.selectedIndex].text;
                                            //var txt = selectNode.options[selectNode.selectedIndex].text;
                                            return txt;
                                        } else {

                                            if ($(node).children("input").length > 0) {
                                                return $(node).children("input").first().val();
                                            } else {
                                                return inner;
                                            }


                                        }
                                    }
                                }
                            },
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demorabiherp/public_html/resources/views/admin/CRM/CommentsReportsFilter.blade.php ENDPATH**/ ?>