<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>أكثر 10 أصناف مبيعًا (السنة الحالية)</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: right;
        }
        th {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
<h1>أكثر 10 أصناف مبيعًا (السنة الحالية: <?php echo e(\Carbon\Carbon::now()->year); ?>)</h1>

<?php if($topSellingProducts->isEmpty()): ?>
    <p>لا توجد بيانات عن الأصناف الأكثر مبيعًا للسنة الحالية.</p>
<?php else: ?>
    <table>
        <thead>
        <tr>
            <th>الترتيب</th>
            <th>اسم الصنف</th>
            <th>إجمالي الكمية المباعة</th>
            <th>إجمالي الإيرادات</th> 
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $topSellingProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($index + 1); ?></td>
                <td><?php echo e($product->product_name); ?></td>
                <td><?php echo e(number_format($product->total_quantity_sold, 0)); ?></td>
                <td><?php echo e(number_format($product->total_revenue, 2)); ?></td> 
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
<?php endif; ?>
</body>
</html>
<?php /**PATH /Applications/MAMP/htdocs/laravel/ERP/resources/views/admin/top_selling_products.blade.php ENDPATH**/ ?>