<?php $__env->startSection('content'); ?>
    <title><?php echo e(trans('admin.EditGeneralDaily')); ?></title>

    <style>
        @media  print {
            .no-print {
                display: none;
            }

            @page  {
                /*size: landscape;*/
                overflow: visible;

            }

            body {
                width: 100%;
                height: auto;
                overflow: visible;
            }

            table {
                width: 100%;
                overflow: visible;
            }

            .col-4-print {
                max-width: 33.33333%;
            }
        }

    </style>
    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb no-print">
            <li class="breadcrumb-item"><a href="javascript:void(0);"><?php echo e(trans('admin.Settings')); ?> </a></li>
            <li class="breadcrumb-item active"><?php echo e(trans('admin.EditGeneralDaily')); ?></li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
        </ol>

        <!-- data entry -->
        <div class="row ">
            <div class="col-lg-12">
                <div id="panel-2" class="panel">
                    <div class="panel-hdr no-print">
                        <h2>
                            <span class="fw-300"><i> <?php echo e(trans('admin.EditGeneralDaily')); ?></i></span>
                        </h2>
                    </div>
                    <div class="panel-container show">
                        <div class="panel-content">


                            <form action="<?php echo e(url('AdminEditGeneralDailyFilter')); ?>" method="get">

                                <div class="form-row">
                                    <div class="form-group col-md-3 col-4-print">
                                        <label class="form-label" for="simpleinput"><?php echo e(trans('admin.From')); ?></label>
                                        <input type="date" id="from" value="<?php echo e(date('Y-m-d')); ?>" name="From" class="form-control">
                                    </div>
                                    <div class="form-group col-md-3 col-4-print">
                                        <label class="form-label" for="simpleinput"><?php echo e(trans('admin.To')); ?></label>
                                        <input type="date" id="to" value="<?php echo e(date('Y-m-d')); ?>" name="To" class="form-control">
                                    </div>

                                    <div class="form-group col-md-3 no-print">
                                        <label class="form-label" for=""> <?php echo e(trans('admin.Coin')); ?></label>

                                        <select id="coin" name="Coin" data-placeholder="<?php echo e(trans('admin.Coin')); ?>" class="js-data-example-ajax form-control">
                                            <option value="" selected><?php echo e(trans('admin.Coin')); ?></option>
                                        </select>

                                    </div>
                                    <div class="form-group col-md-3 col-4-print">
                                        <label class="form-label" for=""> <?php echo e(trans('admin.Account')); ?></label>

                                        <select id="account" name="Account" data-placeholder="<?php echo e(trans('admin.Account')); ?>" class="js-data-example-ajax form-control">
                                            <option value="" selected><?php echo e(trans('admin.Account')); ?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-3 no-print">
                                        <label class="form-label" for=""> <?php echo e(trans('admin.Bond_Type')); ?> </label>
                                        <select class="select2 form-control w-100" id="type" name="Type">
                                            <option value=""> <?php echo e(trans('admin.Bond_Type')); ?></option>
                                            <?php $__currentLoopData = $Types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($type->Type); ?>">
                                                    <?php echo e(app()->getLocale() == 'ar' ?$type->Type :$type->TypeEn); ?>

                                                </option>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group col-md-3  no-print">
                                        <label class="form-label" for=""> <?php echo e(trans('admin.Cost_Center')); ?></label>
                                        <select id="cost" name="Cost_Center" data-placeholder="<?php echo e(trans('admin.Cost_Center')); ?>" class="js-data-example-ajax form-control">
                                            <option value="" selected><?php echo e(trans('admin.Cost_Center')); ?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-3 no-print">
                                        <label class="form-label" for=""> <?php echo e(trans('admin.User')); ?></label>
                                        <select id="user" name="User" data-placeholder="<?php echo e(trans('admin.User')); ?>" class="js-data-example-ajax form-control">
                                            <option value="" selected><?php echo e(trans('admin.User')); ?></option>
                                        </select>
                                    </div>

                                    <div class="form-group col-md-2 no-print row m-2" style="padding-top:9px;">


                                        <div class="buttons m-2">
                                            <button type="submit" class="btn btn-primary"><i class="fal fa-search"></i></button>
                                        </div>

                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>



    </main>



<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/formplugins/summernote/summernote.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/formplugins/select2/select2.bundle.js')); ?>"></script>

    <!-- Search Selecet -->
    <script>
        $(document).ready(function() {
            $(function() {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State"
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items"
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function(elm) {
                        return elm
                    }
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }


                $('#coin').select2({
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllCoins',
                        processResults: function(data) {
                            return {
                                results: $.map(data, function(obj, index) {
                                    return {
                                        id: index,
                                        text: obj
                                    };
                                })
                            };
                        },
                        data: function(params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllCoinsJ/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function() {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function(data) {
                                    $('#coin').empty();
                                    $.each(data, function(key, value) {

                                        $('#coin').append('<option value="' + key + '">' + value + '</option>');

                                    });






                                },
                                complete: function() {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    }
                });



                $('#coin').on('select2:select', function(e) {
                    console.log("select done", e.params.data);
                });


                $('#account').select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllSubAccounts',
                        processResults: function(data) {
                            return {
                                results: $.map(data, function(obj, index) {
                                    return {
                                        id: index,
                                        text: obj
                                    };
                                })
                            };

                            console.log(data);

                        },
                        data: function(params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllSubAccountsJ/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function() {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function(data) {
                                    $('#account').empty();
                                    $.each(data, function(key, value) {

                                        $('#account').append('<option value="' + key + '">' + value + '</option>');

                                    });



                                },
                                complete: function() {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    }
                });


                $('#account').on('select2:select', function(e) {
                    console.log("select done", e.params.data);
                });


                $('#cost').select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllCostss',
                        processResults: function(data) {
                            return {
                                results: $.map(data, function(obj, index) {
                                    return {
                                        id: index,
                                        text: obj
                                    };
                                })
                            };

                            console.log(data);

                        },

                        data: function(params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllCostssJ/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function() {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function(data) {
                                    $('#cost').empty();
                                    $.each(data, function(key, value) {

                                        $('#cost').append('<option value="' + key + '">' + value + '</option>');

                                    });





                                },
                                complete: function() {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }

                    }
                });


                $('#cost').on('select2:select', function(e) {
                    console.log("select done", e.params.data);
                });



                $('#user').select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllUsers',
                        processResults: function(data) {
                            return {
                                results: $.map(data, function(obj, index) {
                                    return {
                                        id: index,
                                        text: obj
                                    };
                                })
                            };

                            console.log(data);

                        },
                        data: function(params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllUsersJ/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function() {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function(data) {
                                    $('#user').empty();
                                    $.each(data, function(key, value) {

                                        $('#user').append('<option value="' + key + '">' + value + '</option>');

                                    });



                                },
                                complete: function() {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    }
                });


                $('#user').on('select2:select', function(e) {
                    console.log("select done", e.params.data);
                });



            });
        });

    </script>

    <script>
        var autoSave = $('#autoSave');
        var interval;
        var timer = function() {
            interval = setInterval(function() {
                //start slide...
                if (autoSave.prop('checked'))
                    saveToLocal();

                clearInterval(interval);
            }, 3000);
        };

        //save
        var saveToLocal = function() {
            localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
            console.log("saved");
        }

        //delete
        var removeFromLocal = function() {
            localStorage.removeItem("summernoteData");
            $('#saveToLocal').summernote('reset');
        }

        $(document).ready(function() {
            //init default
            $('.js-summernote').summernote({
                height: 200,
                tabsize: 2,
                placeholder: "Type here...",
                dialogsFade: true,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['strikethrough', 'superscript', 'subscript']],
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['fontname', ['fontname']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['height', ['height']]
                        ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ],
                callbacks: {
                    //restore from localStorage
                    onInit: function(e) {
                        $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                    },
                    onChange: function(contents, $editable) {
                        clearInterval(interval);
                        timer();
                    }
                }
            });

            //load emojis
            $.ajax({
                url: 'https://api.github.com/emojis',
                async: false
            }).then(function(data) {
                window.emojis = Object.keys(data);
                window.emojiUrls = data;
            });

            //init emoji example
            $(".js-hint2emoji").summernote({
                height: 100,
                toolbar: false,
                placeholder: 'type starting with : and any alphabet',
                hint: {
                    match: /:([\-+\w]+)$/,
                    search: function(keyword, callback) {
                        callback($.grep(emojis, function(item) {
                            return item.indexOf(keyword) === 0;
                        }));
                    },
                    template: function(item) {
                        var content = emojiUrls[item];
                        return '<img src="' + content + '" width="20" /> :' + item + ':';
                    },
                    content: function(item) {
                        var url = emojiUrls[item];
                        if (url) {
                            return $('<img />').attr('src', url).css('width', 20)[0];
                        }
                        return '';
                    }
                }
            });

            //init mentions example
            $(".js-hint2mention").summernote({
                height: 100,
                toolbar: false,
                placeholder: "type starting with @",
                hint: {
                    mentions: ['jayden', 'sam', 'alvin', 'david'],
                    match: /\B@(\w*)$/,
                    search: function(keyword, callback) {
                        callback($.grep(this.mentions, function(item) {
                            return item.indexOf(keyword) == 0;
                        }));
                    },
                    content: function(item) {
                        return '@' + item;
                    }
                }
            });

        });

    </script>
    <script type="text/javascript">
        $(".show-table").click(function() {
            $(".hide-table").show();
        });

    </script>



<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demorabiherp/public_html/resources/views/admin/Settings/AdminEditGeneralDaily.blade.php ENDPATH**/ ?>