<?php $__env->startSection('content'); ?>

    <title><?php echo e(trans('admin.Goods')); ?></title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> <?php echo e(trans('admin.RealStates')); ?></a></li>
            <li class="breadcrumb-item active"><?php echo e(trans('admin.Goods')); ?></li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i><?php echo e(trans('admin.Goods')); ?> => <?php echo e($data->Name); ?></i></span>
                        </h2>

                        <div class="panel-toolbar">

                            <a href="<?php echo e(url('AddGoodsProject/'.$data->id)); ?>" class="btn btn-default"><?php echo e(trans('admin.AddNew')); ?></a>
                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                            <?php echo $__env->make('admin.layouts.toolbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> <?php echo $__env->make('admin.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <table id="dt-basic-example"
                                   class="table table-bordered table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                <tr>
                                    <th><?php echo e(trans('admin.Code')); ?></th>
                                    <th><?php echo e(trans('admin.Date')); ?></th>
                                    <th><?php echo e(trans('admin.Store')); ?></th>
                                    <th><?php echo e(trans('admin.Cost_Center')); ?></th>
                                    <th><?php echo e(trans('admin.Responsible')); ?></th>
                                    <th><?php echo e(trans('admin.Coin')); ?></th>
                                    <th><?php echo e(trans('admin.Draw')); ?></th>
                                    <th><?php echo e(trans('admin.Note')); ?></th>
                                    <th><?php echo e(trans('admin.Details')); ?></th>
                                    <th><?php echo e(trans('admin.Actions')); ?></th>

                                </tr>
                                </thead>
                                <tbody>

                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($item->Code); ?></td>
                                        <td><?php echo e($item->Date); ?></td>
                                        <td>

                                            <?php if(!empty($item->Store()->first()->Name)): ?>
                                                <?php echo e(app()->getLocale() == 'ar' ?$item->Store()->first()->Name :$item->Store()->first()->NameEn); ?>


                                            <?php endif; ?>


                                        </td>
                                        <td>

                                            <?php if(!empty($item->Cost_Center()->first()->Arabic_Name)): ?>
                                                <?php echo e(app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name); ?>


                                            <?php endif; ?>


                                        </td>

                                        <td>

                                            <?php if(!empty($item->Responsible()->first()->Name)): ?>
                                                <?php echo e(app()->getLocale() == 'ar' ?$item->Responsible()->first()->Name :$item->Responsible()->first()->NameEn); ?>


                                            <?php endif; ?>


                                        </td>



                                        <td>

                                            <?php if(!empty($item->Coin()->first()->Arabic_Name)): ?>
                                                <?php echo e(app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name); ?>


                                            <?php endif; ?>


                                        </td>

                                        <td><?php echo e($item->Draw); ?></td>
                                        <td><?php echo e($item->Note); ?></td>
                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#details<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.Details')); ?></button>
                                        </td>

                                        <td class="text-center">

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center<?php echo e($item->id); ?>"><i class="fal fa-trash"></i></button>

                                            <a href="<?php echo e(url('EditGoodsProject/'.$item->id)); ?>" class="btn btn-default"><i class="fal fa-edit"></i></a>
                                            <a href="<?php echo e(url('GoodsProjectPrint/'.$item->id)); ?>" class="btn btn-default"><i class="fal fa-print"></i></a>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                </tbody>
                                <tfoot>
                                <tr>
                                    <th><?php echo e(trans('admin.Code')); ?></th>
                                    <th><?php echo e(trans('admin.Date')); ?></th>
                                    <th><?php echo e(trans('admin.Store')); ?></th>
                                    <th><?php echo e(trans('admin.Cost_Center')); ?></th>
                                    <th><?php echo e(trans('admin.Responsible')); ?></th>
                                    <th><?php echo e(trans('admin.Coin')); ?></th>
                                    <th><?php echo e(trans('admin.Draw')); ?></th>
                                    <th><?php echo e(trans('admin.Note')); ?></th>
                                    <th><?php echo e(trans('admin.Details')); ?></th>
                                    <th><?php echo e(trans('admin.Actions')); ?></th>
                                </tr>
                                </tfoot>
                            </table>
                            <!-- datatable end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


            <!-- Modal Delete -->
            <div class="modal fade" id="default-example-modal-center<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                <?php echo e(trans('admin.RUSWDT')); ?> <strong>
                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Arabic_Name :$item->English_Name); ?>

                                </strong>
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?php echo e(trans('admin.No')); ?></button>
                            <a href="<?php echo e(url('DeleteGoodsProject/'.$item->id)); ?>"  class="btn btn-primary"> <?php echo e(trans('admin.Yes')); ?></a>
                        </div>
                    </div>
                </div>
            </div>



            <!-- Modal Details -->
            <div class="modal fade" id="details<?php echo e($item->id); ?>" tabindex="-1" role="dialog"
                 aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                <?php echo e(trans('admin.Details')); ?>

                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">


                            <?php
                                $details=\App\Models\RealStates\GoodsProductProject::where('Goods',$item->id)->get();
                            ?>
                            <div class="mt-3">
                                <div style="overflow:auto">
                                    <table id="details" class="table table-bordered table-hover table-striped ">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(trans('admin.Code')); ?> </th>
                                            <th><?php echo e(trans('admin.Name')); ?> </th>
                                            <th><?php echo e(trans('admin.Unit')); ?> </th>
                                            <th><?php echo e(trans('admin.AvQty')); ?> </th>
                                            <th><?php echo e(trans('admin.Qty')); ?> </th>
                                            <th><?php echo e(trans('admin.Price')); ?> </th>
                                            <th><?php echo e(trans('admin.Total')); ?> </th>
                                        </tr>
                                        </thead>
                                        <tbody id="">
                                        <?php  $bonus=0; ?>
                                        <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                            <tr>

                                                <td><?php echo e($detail->P_Code); ?> </td>

                                                <td>

                                                    <?php if(!empty($detail->Product()->first()->P_Ar_Name)): ?>
                                                        <?php echo e(app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name); ?>

                                                    <?php endif; ?>

                                                </td>

                                                <td>
                                                    <?php if(!empty($detail->Unit()->first()->Name )): ?>
                                                        <?php echo e(app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($detail->AvQty); ?></td>
                                                <td><?php echo e($detail->Qty); ?> (<?php echo e($detail->Original_Qty - $detail->Qty); ?>)</td>
                                                <td><?php echo e($detail->Price); ?></td>
                                                <td><?php echo e($detail->Total); ?>

                                                </td>




                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>

                                    </table>
                                </div>
                                <div style="overflow:auto">
                                    <table class="table table-bordered table-hover table-striped mt-4">
                                        <tbody>
                                        <tr>
                                            <td><?php echo e(trans('admin.Product_Numbers')); ?></td>
                                            <td><?php echo e($item->Product_Numbers); ?></td>

                                            <td><?php echo e(trans('admin.Total_Qty')); ?></td>
                                            <td><?php echo e($item->Total_Qty); ?></td>

                                            <td><?php echo e(trans('admin.Total_Price')); ?></td>
                                            <td><?php echo e(number_format((float)$item->Total_Price , 2, '.', '')); ?></td>

                                        </tr>





                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary"
                                        data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>




        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </main>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demorabiherp/public_html/resources/views/admin/RealStates/GoodsProject.blade.php ENDPATH**/ ?>