
<?php $__env->startSection('content'); ?>
    <?php
        use App\Models\CompanyData;
        $DefC=CompanyData::orderBy('id','desc')->first();
        $title=trans('admin.Product_Info');
    ?>

  <title><?php echo e(trans('admin.Product_Info')); ?></title>
<style>
/* ===========================
   جدول المنتجات الأزرق الاحترافي مع لمعة مستمرة
=========================== */
#X {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0;
    font-family: 'Cairo', sans-serif;
    color: #004aad;
    background: #e9f2ff;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 6px 25px rgba(0,123,255,0.25);
    position: relative;
    font-size: 16px;
}

/* لمعة مستمرة على الجدول بالكامل */
#X::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 50%;
    height: 100%;
    background: linear-gradient(120deg, rgba(255,255,255,0.15) 0%, rgba(255,255,255,0.05) 50%, rgba(255,255,255,0) 100%);
    transform: skewX(-20deg);
    animation: shimmer 2s linear infinite;
    pointer-events: none; /* لتجنب التأثير على التفاعل */
    z-index: 2;
}

/* حركة اللمعة */
@keyframes  shimmer {
    0% { left: -50%; }
    100% { left: 100%; }
}

/* رؤوس الجدول */
#X thead th {
    background: linear-gradient(135deg, #007bff, #0056d8);
    color: #fff;
    font-weight: 600;
    font-size: 16px;
    padding: 14px;
    text-align: center;
    position: relative;
    border-right: 1px solid rgba(255,255,255,0.3);
    z-index: 3; /* فوق اللمعة */
}

/* الجسم */
#X tbody td {
    padding: 12px 15px;
    text-align: center;
    border-bottom: 1px solid rgba(0,91,255,0.2);
    transition: all 0.3s ease;
    position: relative;
    font-size: 15px;
    z-index: 2;
}

/* تأثير هور على الصف */
#X tbody tr:hover {
    background: linear-gradient(90deg, rgba(0,123,255,0.15), rgba(0,91,255,0.08));
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0,123,255,0.2);
}

/* صفوف بديلة */
#X tbody tr:nth-child(even) {
    background: rgba(0,123,255,0.05);
}

/* تمرير أفقي في الموبايل */
#mobile-overflow {
    overflow-x: auto;
}

/* ===========================
   استايل البحث الأزرق الاحترافي
=========================== */
.input-items {
    position: relative;
    width: 100%;
    margin-bottom: 20px;
}

#search {
    width: 100%;
    padding: 14px 50px 14px 18px; 
    font-size: 16px;
    border-radius: 15px;
    border: 2px solid #007bff;
    box-shadow: 0 5px 18px rgba(0, 123, 255,0.25);
    outline: none;
    transition: all 0.3s ease;
}

#search:focus {
    border-color: #0056d8;
    box-shadow: 0 6px 22px rgba(0, 91, 255,0.4);
}

/* أيقونة البحث */
.input-items i {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    font-size: 18px;
    color: #007bff;
}

[dir="rtl"] .input-items i {
    left: 15px;
}

[dir="ltr"] .input-items i {
    right: 15px;
}

#search:focus::placeholder {
    color: rgba(0, 123, 255,0.5);
    transition: color 0.3s ease;
}

#search:hover {
    box-shadow: 0 6px 20px rgba(0,123,255,0.3);
}
</style>




<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb no-print">
        <li class="breadcrumb-item"><a href="javascript:void(0);"> <?php echo e(trans('admin.Reports')); ?> </a></li>
        <li class="breadcrumb-item active"><?php echo e(trans('admin.Product_Info')); ?> </li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>
    <div class="subheader"></div>

    <!-- Head Of Print -->
    <?php echo $__env->make('admin.layouts.PrintHeader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="row">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                    <h2>
                        <span class="fw-300"><i>  <?php echo e(trans('admin.Product_Info')); ?></i></span>
                    </h2>

                    <div class="panel-toolbar">
                        <button class="btn btn-sm btn-primary waves-effect waves-themed" onclick="window.print()" ><i class="fal fa-print"></i> <?php echo e(trans('admin.Print')); ?></button>
                        <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>
                        <?php echo $__env->make('admin.layouts.toolbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>

                <div class="panel-container show">
                    <div class="panel-content">
                        <div class="form-row">
                            <div class="form-group col-lg-12 no-print">
                                <div class="input-items">
                                    <input type="text" id="search" class="form-control" placeholder="<?php echo e(trans('admin.Search_For_Products')); ?>">
                                    <?php if(app()->getLocale() == 'ar'): ?>
                                        <i class="fal fa-barcode-alt"></i>
                                    <?php else: ?>
                                        <i class="fal fa-barcode-alt"></i>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- datatable start -->
                        <div id="mobile-overflow">
                            <table id="X" class="table table-bordered table-hover table-striped w-100 mobile-width">
                                <thead class="bg-highlight">
                                    <tr>
                                        <th><?php echo e(trans('admin.Name')); ?> </th>
                                        <th><?php echo e(trans('admin.Unit')); ?> </th>
                                        <th><?php echo e(trans('admin.Code')); ?> </th>
                                        <th><?php echo e(trans('admin.Price_One')); ?> </th>
                                        <th><?php echo e(trans('admin.Price_Two')); ?> </th>
                                        <th><?php echo e(trans('admin.Price_Three')); ?> </th>
                                    </tr>
                                </thead>
                                <tbody class="Data"></tbody>
                            </table>
                        </div>
                        <!-- datatable end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
<link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/select2/select2.bundle.css')); ?>">

<script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
<script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('Admin/js/formplugins/select2/select2.bundle.js')); ?>"></script>

<script>
   $(document).ready(function(){
       fetch_customer_data();

       function fetch_customer_data(search = '') {
           $.ajax({
               url:'ProductInfoFilter',
               method:'GET',
               data:{search:search},
               dataType:'json',
               success:function(data) {
                   $('.Data').html(data.table_data);
               }
           });
       }

       $(document).on('keyup', '#search', function(){
           var search = $(this).val();
           fetch_customer_data(search);
       });
   });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demorabiherp/public_html/resources/views/admin/Reports/Product_Info.blade.php ENDPATH**/ ?>