<?php
use App\Models\CompanyData;
use App\Models\LoginSlider;
$Def=CompanyData::orderBy('id','desc')->first();
$Sliders=LoginSlider::all();
?>
<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e((app()->getLocale() == 'ar') ? 'rtl' : 'ltr'); ?>">
<head>
    <meta charset="utf-8">
    <title>
        <?php echo e(trans('admin.ForgotPassword')); ?> - <?php echo e(isset($Def->Name) ? (app()->getLocale() == 'ar' ? $Def->Name : $Def->NameEn) : trans('admin.Klar')); ?>

    </title>
    
    <!-- Tailwind CSS for modern styling and layout -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Bootstrap CSS and JS for the slider functionality -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet" xintegrity="sha384-GLhlTQ8iRABdZLl6O3oVMWSktQOp6b7In1Zl3/Jr59b6EGGoI1aFkw7cmDA6j6gD" crossorigin="anonymous">
    
    <style>
        /* Define a clean, professional font */
        @import  url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap');
        body {
            font-family: 'Cairo', sans-serif;
            <?php if(app()->getLocale() == 'ar'): ?>
            direction: rtl;
            <?php else: ?>
            direction: ltr;
            <?php endif; ?>
        }
        
        /* Define the gradient background with green and gold */
        .gradient-bg {
            background: linear-gradient(135deg, #014b2a 0%, #B8860B 100%);
        }
        
        /* Custom styles for the login card */
        .login-card {
            background-color: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border-radius: 1.5rem;
        }
        
        /* Style for the form inputs */
        .form-input {
            background-color: rgba(255, 255, 255, 0.15);
            border: 1px solid rgba(255, 255, 255, 0.3);
            color: #fff;
            padding-left: 1.25rem;
            padding-right: 1.25rem;
            border-radius: 9999px;
            text-align: center;
        }
        .form-input::placeholder {
            color: rgba(255, 255, 255, 0.7);
        }
    </style>
    
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no, user-scalable=no, minimal-ui">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    
    <?php if(isset($Def->Icon)): ?>
        <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(URL::to($Def->Icon)); ?>">
        <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(URL::to($Def->Icon)); ?>">
    <?php endif; ?>
    
         <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/notifications/toastr/toastr.css')); ?>">
       

</head>

<body class="gradient-bg flex items-center justify-center min-h-screen text-white p-4">

    <!-- Main Container -->
    <div class="container flex flex-col lg:flex-row items-center justify-center">

 
        <!-- Right side: Login Card -->
        <div class="w-full lg:w-1/2 p-8 md:p-12 login-card shadow-2xl transition-transform transform hover:scale-105">

            <!-- Logo and App Name -->
            <div class="flex flex-col items-center mb-10">
                <?php if(isset($Def->Logo)): ?>
                    <img src="<?php echo e(URL::to($Def->Logo)); ?>" alt="<?php echo e(isset($Def->NameEn) ? $Def->NameEn : 'SmartAdmin'); ?> Logo" class="w-24 h-24 mb-4 rounded-full border-2 border-gold-400 shadow-lg">
                <?php else: ?>
                    <!-- Placeholder image for the logo -->
                    <img src="https://placehold.co/100x100/014b2a/B8860B?text=ERP" alt="ERP Logo" class="w-24 h-24 mb-4 rounded-full border-2 border-gold-400 shadow-lg">
                <?php endif; ?>
                <h1 class="text-3xl font-bold text-gold-500 animate-pulse-slow">
                    <?php echo e(isset($Def->Name) ? (app()->getLocale() == 'ar' ? $Def->Name : $Def->NameEn) : trans('admin.Klar')); ?>

                </h1>
                <p class="text-gray-300 mt-2 text-sm">نظام الإدارة المتكامل - ERP</p>
            </div>
            
            <!-- Error Messages (from Blade) -->
            <span id="ex" class="block mb-6 text-center"> <?php echo $__env->make('admin.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>

            <!-- Login Form -->
            <form action="<?php echo e(url('PostForgotPassword')); ?>" method="post" enctype="multipart/form-data" class="space-y-6">
                <?php echo csrf_field(); ?>

                <?php echo view('honeypot::honeypotFormFields'); ?>
                
                <!-- Email Input -->
                <div class="relative">
                    <input type="email" name="email" id="email" class="w-full py-3 form-input placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-gold-500" placeholder="<?php echo e(trans('admin.Email')); ?>" value="<?php echo e(old('email')); ?>" required>
                </div>
                
     
                <!-- Remember Me & Forgot Password -->
                <div class="flex items-center justify-between text-sm">
                    <a href="<?php echo e(url('AdminLogin')); ?>" class="text-gray-300 hover:text-gold-300 transition-colors duration-200">
                        <?php echo e(trans('admin.Login')); ?>

                    </a>
                </div>
                
                <!-- Submit Button -->
                <button type="submit" class="w-full py-3 bg-white text-[#014b2a] font-bold rounded-full transition-all duration-300 hover:bg-gold-500 hover:text-white transform hover:scale-105 shadow-md">
                    <?php echo e(trans('admin.Reset')); ?>

                </button>
            </form>
        </div>
    </div>
    
    <!-- Bootstrap JS for carousel functionality -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js" xintegrity="sha384-w76AqPfDkMBDXo30jS1Sgez6pr3x5MlQ1ZAGC+nuZB+EYdgRZgiwxhTBTkF7CXvN" crossorigin="anonymous"></script>
    
    
    
   <script src="<?php echo e(asset('Admin/js/vendors.bundle.js')); ?>"></script>
      <script src="<?php echo e(asset('Admin/js/app.bundle.js')); ?>"></script>
      <script src="<?php echo e(asset('Admin/js/notifications/toastr/toastr.js')); ?>"></script>
    <!-- Script to hide messages after a delay -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const messageElement = document.getElementById('ex');
            if (messageElement) {
                setTimeout(() => {
                    messageElement.style.display = 'none';
                }, 6000); // 6 seconds
            }
        });
    </script>
</body>
</html>










<?php /**PATH /home/demorabiherp/public_html/resources/views/admin/forgotpassword.blade.php ENDPATH**/ ?>