<?php

use App\Http\Controllers\ResturantAppController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ApiDelegateAppController;
use App\Http\Controllers\OwnerReportApiController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\ApiController;


//Chat Api
Route::controller(SettingsController:: class)->group( function () {

    Route:: post('AdminSolveIssueApi', 'AdminSolveIssueApi');
    Route:: post('GetTextChat', 'GetTextChat');
    Route:: post('GetTextChatImage', 'GetTextChatImage');

});

//if Not Auth

 Route::controller(ApiDelegateAppController:: class)->group( function () {

          //Login
          Route:: post('LoginApi', 'LoginApi');

          //Forget Password
          Route:: post('forgotpasswordapi', 'forgotpasswordApi');

          //Verify Code
          Route:: post('VerifyCode', 'VerifyCode');

          //Reset Password
          Route:: post('ResetPasswordApi', 'ResetPasswordApi');

 });

 Route::controller(OwnerReportApiController:: class)->group( function () {

          //Login
          Route:: post('OwnerLoginApi', 'OwnerLoginApi');

          //Forget Password
          Route:: post('Ownerforgotpasswordapi', 'Ownerforgotpasswordapi');

          //Verify Code
          Route:: post('OwnerVerifyCode', 'OwnerVerifyCode');

          //Reset Password
          Route:: post('OwnerResetPasswordApi', 'OwnerResetPasswordApi');

 });


//If Auth
    Route::group(['middleware' =>'AdminAuthApi:api'], function () {



      Route::controller(ApiDelegateAppController:: class)->group( function () {

         //Token Check
         Route:: post('TokenCheck', 'TokenCheck');

         //Logout
         Route:: post('LogoutApi', 'LogoutApi');


         //Update Profile
         Route:: post('UpdateAdminProfile', 'UpdateAdminProfile');

         //Location
         Route:: post('LocationTwo', 'LocationTwo');

         //Mdounyat and Target
         Route:: post('indebtedness', 'indebtedness');

    //======================== Default Data ================================

          //Rabih Education
          Route:: get('RabihEducation', 'RabihEducation');

          //Rabih Intro and Terms
          Route:: get('IntroView', 'IntroView');
          Route:: get('TermsView', 'TermsView');
          Route:: get('PrivacyView', 'PrivacyView');

          //Default Data
           Route:: get('DefaultCompany', 'DefaultCompany');
           Route:: get('DefaultAccount', 'DefaultAccount');
           Route:: get('DefaultStore', 'DefaultStore');
           Route:: get('DefaultCrm', 'DefaultCrm');
           Route:: get('DefaultPurchases', 'DefaultPurchases');
           Route:: get('DefaultSales', 'DefaultSales');
           Route:: get('DefaultShowHide', 'DefaultShowHide');
           Route:: get('Modules_SettingsApi', 'Modules_SettingsApi');
           Route:: get('DefaultReportSettings', 'DefaultReportSettings');
           Route:: get('CustomPrintApi', 'CustomPrintApi');

         //Notifications
          Route:: get('Notifications', 'Notifications');
          Route:: post('ReadNotifications', 'ReadNotifications');
          Route:: post('DeleteNotifications', 'DeleteNotifications');


          //EmpMail
          Route:: get('EmpMailApi', 'EmpMailApi');
          Route:: post('ReadEmpMailApi', 'ReadEmpMailApi');


     //=======================================================




          //==========================  Additions Data ========================


          //MeetingsTypes
             Route:: get('MeetingsTypes', 'MeetingsTypes');

             //RatesTypes
             Route:: get('RatesTypes', 'RatesTypes');

          //Activites
             Route:: get('Activites', 'Activites');

             //Platforms
             Route:: get('Platforms', 'Platforms');

             //Campaigns
             Route:: get('Campaigns', 'Campaigns');

             //ClientsStatus
             Route:: get('ClientsStatus', 'ClientsStatus');

             //Holidays Type
             Route:: get('HolidayTypesApi', 'HolidayTypesApi');

             //TaxesApi
             Route:: get('TaxesApi', 'TaxesApi');

             //Groups
             Route:: get('AllGroups', 'AllGroups');

             //Brands
             Route:: get('AllBrands', 'AllBrands');


          //Employes
          Route:: get('Employes', 'Employes');

          //Deliveries
          Route:: get('Deliveries', 'Deliveries');

          //Executors
          Route:: get('AllExecutors', 'AllExecutors');

          //Delegates
          Route:: get('AllDelegates', 'AllDelegates');

          //Installment Companies
          Route:: get('Installment_Companies', 'Installment_Companies');

          //Install Company Filter
          Route:: post('InstallCompanyFilter', 'InstallCompanyFilter');

          //Expenses Accounts
          Route:: get('ExpensesAccounts', 'ExpensesAccounts');

          //Coins
          Route:: get('AllCoins', 'AllCoins');

          //Stores
          Route:: get('AllStores', 'AllStores');

          //Safes
          Route:: get('AllSafes', 'AllSafes');

          //Banks
          Route:: get('AllBanks', 'AllBanks');

          //Check Types
          Route:: get('AllCheckTypes', 'AllCheckTypes');

          //Customers Group
          Route:: get('AllCustomersGroup', 'AllCustomersGroup');

          //CostCenter
          Route:: get('AllCostCenter', 'AllCostCenter');

          //Vendors
          Route:: get('AllVendors', 'AllVendors');

          //Shipping Companies
          Route:: get('AllShippingCompanies', 'AllShippingCompanies');

          //Credit Account
          Route:: post('CreditAccount', 'CreditAccount');

          //Credit Safes
          Route:: post('CreditSafes', 'CreditSafes');

          //Users
          Route:: get('AllUsers', 'AllUsers');

          //Clients
          Route:: get('AllClients', 'AllClients');

          //Branches
          Route:: get('AllBranches', 'AllBranches');

          //Expenses Main Accounts
          Route:: get('AllExpensesMainAccounts', 'AllExpensesMainAccounts');

          //Expenses Sub Accounts
          Route:: get('AllExpensesSubAccounts', 'AllExpensesSubAccounts');


          //Governrates
          Route:: get('Governrates', 'Governrates');

          //Cities
          Route:: get('Cities', 'Cities');
          Route:: post('CitiesFilter', 'CitiesFilter');

          //Places
          Route:: get('Places', 'Places');
          Route:: post('PlacesFilter', 'PlacesFilter');

          //Groups Childs
          Route:: post('GroupSingleFilterApi', 'GroupSingleFilterApi');

          //Bonds Type
          Route:: get('BondsTypeApi', 'BondsTypeApi');


          //Moves Type
          Route:: get('MovesTypeApi', 'MovesTypeApi');

          //ScreensApi
          Route:: get('ScreensApi', 'ScreensApi');


          //==========================  End Additions Data ========================




          //========================== Delegate App =====================================================================================================================================================


         //=======
           //Clients
          Route:: get('Clients', 'Clients');
          Route:: post('ClientsSechduleFilter', 'ClientsSechduleFilter');
          Route:: post('AddClient', 'AddClient');
          Route:: post('EditClient', 'EditClient');

          //Client Addresses
          Route:: post('CustomerAddAddresses', 'CustomerAddAddresses');
          Route:: post('CustomerEditAddresses', 'CustomerEditAddresses');
          Route:: post('CustomerDeleteAddresses', 'CustomerDeleteAddresses');
          Route:: post('CustomerAddAddressLocation', 'CustomerAddAddressLocation');


          //Client  Ticket
          Route:: post('AddTicket', 'AddTicket');
          Route:: post('SolveTicketsClient', 'SolveTicketsClient');

          //Client Comments
           Route:: post('AddComment', 'AddComment');

          //Meetings
          Route:: post('MyMeetings', 'MyMeetings');
          Route:: post('PervMeetings', 'PervMeetings');
          Route:: post('AddNewMeetApi', 'AddNewMeetApi');
          Route:: post('EndMeet', 'EndMeet');

          //Missions
          Route:: get('MyMission', 'MyMission');
          Route:: post('SureMyMission', 'SureMyMission');

          //Hoilday Request
          Route:: get('MyHoildayRequests', 'MyHoildayRequests');
          Route:: post('AddHoildayRequest', 'AddHoildayRequest');



           //=====  Reports  =====================
          //Stores Cost
          Route:: post('StoresCost', 'StoresCost');
          //Credit Stores
          Route:: post('CreditStores', 'CreditStores');
          //Product Info
          Route:: post('ProductInfo', 'ProductInfo');
          //Delegate Collection
          Route:: post('DelegateCollectionReport', 'DelegateCollectionReport');

          //Total Delegate Collection
          Route:: post('TotalDelegateCollectionReport', 'TotalDelegateCollectionReport');

          //Shifts Report
          Route:: post('ShiftsReport', 'ShiftsReport');

          //SEmployee Commission
          Route:: get('EmpCommission', 'EmpCommission');


          //Customer Account Statement
          Route:: post('CustomerAccountStatement', 'CustomerAccountStatement');



          //Shifts Code

          Route:: get('ShiftsCodeApi', 'ShiftsCodeApi');

          //Shifts Details
          Route:: post('ShiftsDetailsApi', 'ShiftsDetailsApi');


          //=========================================


          //==   Stores and Safes Transfer  ==================


          //Safes Transfer
          Route:: post('NewAdd', 'NewAdd');
          Route:: post('AddSafeTransfersApi', 'AddSafeTransfersApi');
          Route:: post('SureSafeTransfersApi', 'SureSafeTransfersApi');
          Route:: get('SafeTransfersSechduleApi', 'SafeTransfersSechduleApi');
          Route:: get('SafeTransfersCode', 'SafeTransfersCode');
          Route:: post('SafeTransfersDetails', 'SafeTransfersDetails');
          Route:: post('EditSafeTransfers', 'EditSafeTransfers');
          Route:: post('RefuseSafeTransfers', 'RefuseSafeTransfers');

          //Stores Transfer
          Route:: post('TarnsferStoresFilter', 'TarnsferStoresFilter');
          Route:: post('AddStoreTransfersApi', 'AddStoreTransfersApi');
          Route:: post('SureStoreTransfersApi', 'SureStoreTransfersApi');
          Route:: get('StoreTransfersSechduleApi', 'StoreTransfersSechduleApi');
          Route:: get('StoreTransfersCode', 'StoreTransfersCode');
          Route:: post('StoreTransfersDetails', 'StoreTransfersDetails');
          Route:: post('EditStoreTransfers', 'EditStoreTransfers');
          Route:: post('RefusedStoreTransfer', 'RefusedStoreTransfer');


          // ==================   Shifts ==================
          Route:: get('CheckShift', 'CheckShift');
          Route:: get('OpenShift', 'OpenShift');
          Route:: post('PostOpenShift', 'PostOpenShift');
          Route:: post('PostCloseShift', 'PostCloseShift');

                //Shift Details
          Route:: post('DetailsShiftPass', 'DetailsShiftPass');
          Route:: get('DetailsShift', 'DetailsShift');

            //Get Shift Code
          Route:: get('GetShiftCode', 'GetShiftCode');
          Route:: get('GetNextShiftCode', 'GetNextShiftCode');

          //===========  Sales ===================================================


                //============ Quote (Sales Order) ===================

                      Route:: get('SalesOrderNewCode', 'SalesOrderNewCode');
                      Route:: get('SalesOrderSechdule', 'SalesOrderSechdule');
                      Route:: post('SalesOrderDetails', 'SalesOrderDetails');
                      Route:: post('AddSalesOrder', 'AddSalesOrder');
                      Route:: post('EditSalesOrder', 'EditSalesOrder');
                      Route:: post('DeleteSalesOrder', 'DeleteSalesOrder');
                      Route:: post('TransferToSales', 'TransferToSales');

          //============ MyRequestsDelivery ===================

                        Route:: get('MyRequestsDelivery', 'MyRequestsDelivery');
                        Route:: post('RecivedDeliveryApi', 'RecivedDeliveryApi');
                        Route:: post('ReturnDeliveryApi', 'ReturnDeliveryApi');


          //============ Sales ===================

          Route:: get('SalesSechdule', 'SalesSechdule');
          Route:: post('FilterSalesSechdule', 'FilterSalesSechdule');
          Route:: post('SalesBillDetailsApi', 'SalesBillDetailsApi');
          Route:: post('DeleteSalesApi', 'DeleteSalesApi');
          Route:: post('EditSalesApi', 'EditSalesApi');
          Route:: post('AddSalesBill', 'AddSalesBill');


          //============ Return Sales ===================

          Route:: get('ReturnSalesNewCodeApi', 'ReturnSalesNewCodeApi');
          Route:: get('ReturnSalesSechdule', 'ReturnSalesSechdule');
          Route:: post('ReturnSalesApi', 'ReturnSalesApi');


          //===========  POS ===========================

          //Return Code
          Route:: get('POSPage', 'POSPage');

          //Add Client POS
          Route:: post('AddClientPos', 'AddClientPos');

          //Client Voucher
          Route:: get('ClientVoucherCode', 'ClientVoucherCode');
          Route:: post('ClientVoucher', 'ClientVoucher');

          //Expenses Voucher
          Route:: post('ExpensesVoucher', 'ExpensesVoucher');
          Route:: get('ExpensesVoucherCode', 'ExpensesVoucherCode');

          //POS Clients
          Route:: get('POSClients', 'POSClients');

          //POS Stores
          Route:: get('POSStores', 'POSStores');

          //POS Safes
          Route:: get('POSSafes', 'POSSafes');

          //Change Unit
          Route:: post('ChangeUnit', 'ChangeUnit');
          Route:: post('ProUnits', 'ProUnits');

          //ClientAddresses
          Route:: post('ClientAddresses', 'ClientAddresses');

            // ==========  Serach Product Filter =========
            Route:: post('SerachProductFilter', 'SerachProductFilter');
            Route:: post('SerachProductGroupFilter', 'SerachProductGroupFilter');
            Route:: post('SerachProductBrandFilter', 'SerachProductBrandFilter');
            Route:: post('SerachAllProductFilter', 'SerachAllProductFilter');


            //================ Hold Bills ==========================

              Route:: get('HoldBills', 'HoldBills');
              Route:: post('FilterHoldBills', 'FilterHoldBills');
              Route:: post('HoldBillDetails', 'HoldBillDetails');
              Route:: post('DeleteHoldBill', 'DeleteHoldBill');
              Route:: post('AddHoldBill', 'AddHoldBill');
              Route:: post('HoldPostPOS', 'HoldPostPOS');


          //=========== End  Sales ===================================================



          //Itinerary
          Route:: post('MyItinerary', 'MyItinerary');
          Route:: get('MyItineraryClients', 'MyItineraryClients');
          Route:: post('AcceptVisitItinerary', 'AcceptVisitItinerary');
          Route:: post('NegativeVisitItinerary', 'NegativeVisitItinerary');

          
          
          
          
             //======================== Attendence HR  ================================
          
             Route:: post('NewEmpAttend', 'NewEmpAttend');
             Route:: post('NewEmpDeparture', 'NewEmpDeparture');
             Route:: post('EmpMovementStatus', 'EmpMovementStatus');
             Route:: post('EmpAttendStatus', 'EmpAttendStatus');
          
          


          //========================== End Delegate App =====================================================================================================================================================




          //ProductSechduleApi
          Route:: get('ProductSechduleApi', 'ProductSechduleApi');



          //Accounting Manual
          Route:: get('AccountManualSechduleApi', 'AccountManualSechduleApi');

          //Paymen Voucher Sechdule
          Route:: get('PaymentVouchersSechduleApi', 'PaymentVouchersSechduleApi');

          //Recipt Voucher Sechdule
          Route:: get('ReciptVouchersSechduleApi', 'ReciptVouchersSechduleApi');


          //BrandsSechduleApi
          Route:: get('BrandsSechduleApi', 'BrandsSechduleApi');


          //GroupsSechduleApi
          Route:: get('GroupsSechduleApi', 'GroupsSechduleApi');


          //UnitsSechduleApi
          Route:: get('UnitsSechduleApi', 'UnitsSechduleApi');





      });


        Route::controller(OwnerReportApiController:: class)->group( function () {

            //Token Check
            Route:: post('OwnerTokenCheck', 'OwnerTokenCheck');

            //Logout
            Route:: post('OwnerLogoutApi', 'OwnerLogoutApi');


            //Update Profile
            Route:: post('OwnerUpdateAdminProfile', 'OwnerUpdateAdminProfile');


            //Backup DB
            Route:: get('BackUpDB', 'BackUpDB');

            //Calendar Event
            Route:: get('CalendarEventApi', 'CalendarEventApi');

            //Emp Locations
            Route:: get('EmpLocationsApi', 'EmpLocationsApi');

            // ======================= Reports ==========================

            //Totals
            Route:: get('TotalsReportApi', 'TotalsReportApi');



            //================  HR ===================

            Route:: post('AttendenceAndDepartureReportApi', 'AttendenceAndDepartureReportApi');
            Route:: post('AttendenceValueReportApi', 'AttendenceValueReportApi');
            Route:: post('PaySalaryReportApi', 'PaySalaryReportApi');
            Route:: post('SalaryPayedApi', 'SalaryPayedApi');
            Route:: post('EmpGoalsApi', 'EmpGoalsApi');
            Route:: post('EmpSalariesApi', 'EmpSalariesApi');
            Route:: post('EmployeeCommissionDiscountsApi', 'EmployeeCommissionDiscountsApi');


            //================  CRM ===================

            Route:: post('Customerـfollowـup_ReportsApi', 'Customerـfollowـup_ReportsApi');
            Route:: post('CustomerPeriodReportsApi', 'CustomerPeriodReportsApi');
            Route:: post('CommentsReportsApi', 'CommentsReportsApi');
            Route:: post('DelegateVistsReportApi', 'DelegateVistsReportApi');


            //================  Accounting ===================

            //General Daily
            Route:: post('GeneralDailyApi', 'GeneralDailyApi');

            //Ledger
            Route:: post('LedgerFilterApi', 'LedgerFilterApi');

            //Safe Bank Statement
            Route:: post('SafeBankStatementFilterApi', 'SafeBankStatementFilterApi');


            //Vendor Account Statement Filter
            Route:: post('VendorAccountStatementFilterApi', 'VendorAccountStatementFilterApi');

            //Customer Account Statement Filter
            Route:: post('CustomerAccountStatementFilterApi', 'CustomerAccountStatementFilterApi');

            //Client Account Statement Details Filter
            Route:: post('ClientAccountStatementDetailsFilterApi', 'ClientAccountStatementDetailsFilterApi');

            //Clients Statement
            Route:: post('ClientsStatementApi', 'ClientsStatementApi');

            //Clients Balances
            Route:: post('CustomerBalancesApi', 'CustomerBalancesApi');

            //Clients Debts
            Route:: post('CustomerDebtsApi', 'CustomerDebtsApi');

            //Clients Debts Age
            Route:: post('CustomerDebtRestructuringFilterApi', 'CustomerDebtRestructuringFilterApi');

            //Vendor Statement
            Route:: post('VendorsStatementApi', 'VendorsStatementApi');


            //Vendor Account Statement Details Filter
            Route:: post('VendorAccountStatementDetailsFilterApi', 'VendorAccountStatementDetailsFilterApi');


            //Vendor Balances
            Route:: post('VendorBalancesApi', 'VendorBalancesApi');

                //Vendor Debts
            Route:: post('VendorDebtsApi', 'VendorDebtsApi');

            //Vendor Debts Age
            Route:: post('VendorDebtRestructuringFilterApi', 'VendorDebtRestructuringFilterApi');


            //Cost Center Filter
            Route:: post('Cost_Centers_ReportFilterApi', 'Cost_Centers_ReportFilterApi');



            //InstallmentReportApi
            Route:: post('InstallmentReportApi', 'InstallmentReportApi');



            //SafesBalancesApi
            Route:: post('SafesBalancesApi', 'SafesBalancesApi');


            //SafesTransferReportFilterApi
            Route:: post('SafesTransferReportFilterApi', 'SafesTransferReportFilterApi');


            //TotalExpensesSafesFilterApi
            Route:: post('TotalExpensesSafesFilterApi', 'TotalExpensesSafesFilterApi');

            //ExpensesListFilterApi
            Route:: post('ExpensesListFilterApi', 'ExpensesListFilterApi');

            //ExpensesReportFilterApi
            Route:: post('ExpensesReportFilterApi', 'ExpensesReportFilterApi');

            //IncomListReportFilterApi
            Route:: post('IncomListReportFilterApi', 'IncomListReportFilterApi');


            //ChecksReportsApi
            Route:: post('ChecksReportsApi', 'ChecksReportsApi');


            //InsurancePaperReportFilterApi
            Route:: post('InsurancePaperReportFilterApi', 'InsurancePaperReportFilterApi');

            //Fixed_Assets_ReportFilterApi
            Route:: post('Fixed_Assets_ReportFilterApi', 'Fixed_Assets_ReportFilterApi');

            //TrialBalanceFilterApi
            Route:: post('TrialBalanceFilterApix', 'TrialBalanceFilterApix');

            //AccountBalancesFilterApi
            Route:: post('AccountBalancesFilterApi', 'AccountBalancesFilterApi');

            //SubIncomListFilterApi
            Route:: post('SubIncomListFilterApi', 'SubIncomListFilterApi');


            //FilterFinancial_CenterNew=====================

            Route:: post('FilterFinancial_CenterNew', 'FilterFinancial_CenterNew');
            Route:: post('FilterFinancial_CenterAsoul', 'FilterFinancial_CenterAsoul');
            Route:: post('FilterFinancial_CenterKhsoum', 'FilterFinancial_CenterKhsoum');
            Route:: post('FilterFinancial_CenterHkook', 'FilterFinancial_CenterHkook');

            //FilterIncom_ListNew =======================

            Route:: post('FilterIncom_ListNew', 'FilterIncom_ListNew');
            Route:: post('FilterIncom_ListErydat', 'FilterIncom_ListErydat');
            Route:: post('FilterIncom_ListTaklfa', 'FilterIncom_ListTaklfa');
            Route:: post('FilterIncom_ListMasrofat', 'FilterIncom_ListMasrofat');


            //=====================================================================


            //================  Supply Chain ===================


            //تكلفة المخزون
            Route:: post('StoresCostApi', 'StoresCostApi');

            //المنتجات
            Route:: post('ProductsReportsApi', 'ProductsReportsApi');


            //تكلفة المخازن
            Route:: post('AllStoresCostApi', 'AllStoresCostApi');

            //تكلفة الاصناف
            Route:: post('ItemCostApi', 'ItemCostApi');

            // تقرير كميات المخزون
            Route:: post('StoresQtiesReportApi', 'StoresQtiesReportApi');


            //=====

            // رصيد الاصنافن
            Route:: post('StoresInventoryApi', 'StoresInventoryApi');


            // جرد المخزون
            Route:: post('StoresInventoryNewApi', 'StoresInventoryNewApi');


            // رصيد المخزون
            Route:: post('CreditStoresNewApi', 'CreditStoresNewApi');


            // ارصدة المخزون
            Route:: post('StoresBalancesNewApi', 'StoresBalancesNewApi');


            //كميات الاصناف التجمعية
            Route:: post('AssemblyProQtiesFilterApi', 'AssemblyProQtiesFilterApi');


            //جرد السيريال
            Route:: post('InventorySerialApi', 'InventorySerialApi');


            //الكميات الحجوزة
            Route:: post('HoldQtiesReportApi', 'HoldQtiesReportApi');

//======

            //حركات الاصناف
            Route:: post('ItemsMovesApi', 'ItemsMovesApi');

            // حركة صنف تفصيلي
            Route:: post('ProductMoveDetailsFilterNewwApi', 'ProductMoveDetailsFilterNewwApi');

            //حركات ارصدة مخزون
            Route:: post('StoresBalancesApi', 'StoresBalancesApi');

            //حركة المخازن
            Route::post('StoresMovesReportApi','StoresMovesReportApi');

//========

            // ارباح الاصناف
            Route::post('ProductProfitsNewApi','ProductProfitsNewApi');


            //  المتوقعة ارباح الاصناف
            Route::post('ExceptProductProfitsFilterApi','ExceptProductProfitsFilterApi');


            //  الارباح المتوقعه
            Route::post('ExceptProfitsApi','ExceptProfitsApi');

            //   ربحية الاصناف المباعة
            Route::post('ProfitSalesProductFilterApi','ProfitSalesProductFilterApi');


            //تقرير ربح مجموعات
            Route::post('ProfitGroupsReportFilterApi','ProfitGroupsReportFilterApi');

            //  مقارنة اسعار بيع
            Route::post('CompareSalesPriceApi','CompareSalesPriceApi');

           //تقرير الارباح
            Route::post('ProfitsFilterTwoApi','ProfitsFilterTwoApi');

 //======

        // نسب الموظفين من المجموعات و الماركات
            Route::post('EmpPrecentsBrandsGroupsReportApi','EmpPrecentsBrandsGroupsReportApi');

            //مبيعات مناديب
            Route::post('Sales_DelegatesApi','Sales_DelegatesApi');

            //مبيعات مناديب تفصيلي
            Route::post('DelegateSalesDetailssApi','DelegateSalesDetailssApi');

            //مديونية مناديب
            Route::post('Collection_DelegatesApi','Collection_DelegatesApi');

            //مبيعات مناديب تفصيلي
            Route::post('DelegateSalesDetailsApi','DelegateSalesDetailsApi');

          //ارباح مبيعات مناديب تفصيلي
            Route::post('ProfitDelegateSalesDetailsApi','ProfitDelegateSalesDetailsApi');



//تقفيل يومية
            Route::post('DailyClosing','DailyClosing');
            Route::post('FilterSalesDetailsDailyClosing','FilterSalesDetailsDailyClosing');
            Route::post('FilterRSalesDetailsDailyClosing','FilterRSalesDetailsDailyClosing');
            Route::post('FilterReciptDetailsDailyClosing','FilterReciptDetailsDailyClosing');
            Route::post('FilterTransferTotDetailsDailyClosing','FilterTransferTotDetailsDailyClosing');
            Route::post('FilterPaymenttDetailsDailyClosing','FilterPaymenttDetailsDailyClosing');
            Route::post('FilterPurchasesDetailsDailyClosing','FilterPurchasesDetailsDailyClosing');
            Route::post('FilterRPurchasesDetailsDailyClosing','FilterRPurchasesDetailsDailyClosing');
            Route::post('FilterTransferFromDetailsDailyClosing','FilterTransferFromDetailsDailyClosing');
            Route::post('FilterImportChecksDetailsDailyClosing','FilterImportChecksDetailsDailyClosing');
            Route::post('FilterSettlement3agzDetailsDailyClosing','FilterSettlement3agzDetailsDailyClosing');
            Route::post('FilterWaslDetailsDailyClosing','FilterWaslDetailsDailyClosing');
            Route::post('FilterPetrolDetailsDailyClosing','FilterPetrolDetailsDailyClosing');
            Route::post('FilterShippingDetailsDailyClosing','FilterShippingDetailsDailyClosing');
            Route::post('FilterMaintainceDetailsDailyClosing','FilterMaintainceDetailsDailyClosing');
            Route::post('FilterExportChecksDetailsDailyClosing','FilterExportChecksDetailsDailyClosing');
            Route::post('FilterSettlementZyadaDetailsDailyClosing','FilterSettlementZyadaDetailsDailyClosing');
            Route::post('FilterRMaintainceDetailsDailyClosing','FilterRMaintainceDetailsDailyClosing');
            Route::post('FilterSalaryDetailsDailyClosing','FilterSalaryDetailsDailyClosing');
            Route::post('FilterBorrowDetailsDailyClosing','FilterBorrowDetailsDailyClosing');
            Route::post('FilterLoanDetailsDailyClosing','FilterLoanDetailsDailyClosing');
            Route::post('FilterExchangeDetailsDailyClosing','FilterExchangeDetailsDailyClosing');


//تقفيل يومية بتفصيل
            Route::post('DailyClosingDetails','DailyClosingDetails');
            Route::post('FilterSalesDailyClosingDetails','FilterSalesDailyClosingDetails');
            Route::post('FilterRSalesDailyClosingDetails','FilterRSalesDailyClosingDetails');
            Route::post('FilterPurchasesDailyClosingDetails','FilterPurchasesDailyClosingDetails');
            Route::post('FilterRPurchasesDailyClosingDetails','FilterRPurchasesDailyClosingDetails');
            Route::post('FilterSettlement3agzDailyClosingDetails','FilterSettlement3agzDailyClosingDetails');
            Route::post('FilterPetrolDailyClosingDetails','FilterPetrolDailyClosingDetails');
            Route::post('FilterShippingDailyClosingDetails','FilterShippingDailyClosingDetails');
            Route::post('FilterMaintainceDailyClosingDetails','FilterMaintainceDailyClosingDetails');
            Route::post('FilterSettlementZyadaDailyClosingDetails','FilterSettlementZyadaDailyClosingDetails');
            Route::post('FilterRMaintainceDailyClosingDetails','FilterRMaintainceDailyClosingDetails');

            //=========

         //صافي مشتريات الاصناف
            Route::post('NetPurchasesFilterApi','NetPurchasesFilterApi');
      // اجمالي صافي مشتريات الاصناف
            Route::post('TotalNetPurchasesApi','TotalNetPurchasesApi');
            //مشتريات موردين
            Route::post('VendorPurchasesApi','VendorPurchasesApi');
            //اسعار موردين
            Route::post('VendorPricesReportApi','VendorPricesReportApi');
            // فواتير المشتريات
            Route::post('PurchasesBillsApi','PurchasesBillsApi');

//====

            //الاصناف اليوميه
            Route::post('DailyProductsApi','DailyProductsApi');
            //الورديات
            Route::post('ShiftsReportApi','ShiftsReportApi');
            //تفاصيل الورديات
            Route::post('ShiftsDetailsReportApi','ShiftsDetailsReportApi');
            //الورديات اليومية
            Route::post('DailyShiftsApi','DailyShiftsApi');

//=======


//اصناف بداية فترة
               Route::post('ReportStartPeriodApi','ReportStartPeriodApi');
//التسويات
               Route::post('SettlementsReportsApi','SettlementsReportsApi');
//صلاحيات الاصناف
               Route::post('ExpiredProuctsApi','ExpiredProuctsApi');
//اصناف وصلت حد الطلب
               Route::post('ProductOrderLimitApi','ProductOrderLimitApi');
//تحويلات المخازن
               Route::post('StoresTransferReportApi','StoresTransferReportApi');
//مرتجع بدون فاتورة
               Route::post('ReturnWithoutBillReportApi','ReturnWithoutBillReportApi');


//=====

            //اصناف راكدةر
            Route::post('StagnantItemsTwoFilterApi','StagnantItemsTwoFilterApi');

            // الاصناف الاكثر مبيعا
            Route::post('MostSalesProductsApi','MostSalesProductsApi');

            //   فواتير المبيعات
            Route::post('SalesBillsApi','SalesBillsApi');


            //    مبيعات مجموعات
            Route::post('GroupsSalesApi','GroupsSalesApi');

            //    مبيعات برندات
            Route::post('BrandsSalesApi','BrandsSalesApi');

            //    مبيعات مجموعات عملاء تفصيلي
            Route::post('SalesCustomersGroupsFilterApi','SalesCustomersGroupsFilterApi');

     //صافي مبيعات الاصناف
            Route::post('NetSalesApi','NetSalesApi');

     //اجمالي صافي مبيعات الاصناف
            Route::post('TotalNetSalesApi','TotalNetSalesApi');

     //مبيعات مخازن تفصيلي
            Route::post('StoresSalesDetailsApi','StoresSalesDetailsApi');

     //مبيعات شركات التقسيط
            Route::post('InstallmentCompaniesSalesApi','InstallmentCompaniesSalesApi');


            //مبيعات مجموعات مفصلة
                 Route::post('SalesProsGroupMoreDetailsApi','SalesProsGroupMoreDetailsApi');
            //مبيعات برندات مفصلة
                 Route::post('SalesProsBrandsMoreDetailsApi','SalesProsBrandsMoreDetailsApi');
            //مبيعات عملاء
                 Route::post('ClientSalesApi','ClientSalesApi');
            //مبيعات منفذ
                 Route::post('ExecutorSalesApi','ExecutorSalesApi');

        //مبيعات الاصناف بالمجموعات
                 Route::post('ProductSalesGroupsReportApi','ProductSalesGroupsReportApi');

        //مبيعات الاصناف بالماركات
                 Route::post('ProductSalesBrandsReportApi','ProductSalesBrandsReportApi');

//=======


//EditDeleteBillReport
            Route::post('EditDeleteBillReportApi','EditDeleteBillReportApi');
//UserLog
            Route::post('UserLogApi','UserLogApi');


        });

    });


// ======================= E-Commerce  ===================================================================================================================================================



Route::controller(ApiController:: class)->group( function () {


//Auth  =======================================

//UserLogin
    Route:: post('UserLogin', 'UserLogin');

//User Token Check
    Route:: get('UserTokenCheck', 'UserTokenCheck');

//User Forget Password
    Route:: post('Userforgotpasswordapi', 'Userforgotpasswordapi');


//User Verify Code
    Route:: post('UserVerifyCode', 'UserVerifyCode');


//User Reset Password
    Route:: post('UserResetPasswordApi', 'UserResetPasswordApi');


//User Logout
    Route:: post('UserLogoutApi', 'UserLogoutApi');


//UserRegister
    Route:: post('UserRegister', 'UserRegister');


    //  View  =======================================

    //Webslider
    Route:: get('Webslider', 'Webslider');

    //About
    Route:: get('About', 'About');

    //Social Media
    Route:: get('Social', 'Social');

    //ContactUS
    Route:: get('ContactUS', 'ContactUS');

    //Articles
    Route:: get('Articles', 'Articles');
    Route:: post('Articles_Details', 'Articles_Details');

    //Terms
    Route:: get('Terms', 'Terms');

    //Polices
    Route:: get('Polices', 'Polices');

    //FAQ
    Route:: get('FAQ', 'FAQ');

    //Countries
    Route:: get('Countries', 'Countries');

    //Categories
    Route:: get('Categories', 'Categories');

    //BrandsE
    Route:: get('BrandsE', 'BrandsE');


    //  Products   =======================================

    //Show
    Route:: post('ProductsE', 'ProductsE');
    Route:: post('ProductDetails', 'ProductDetails');
    Route:: post('LastProductsE', 'LastProductsE');



    //  Filters   =======================================

    //Governrate , City , Place
    Route:: post('GovernrateE', 'GovernrateE');
    Route:: post('CiteiesE', 'CiteiesE');
    Route:: post('PlacesE', 'PlacesE');


    //Avalible Qty
    Route:: post('AvQtyCompleted', 'AvQtyCompleted');
    Route:: post('AvQtyV', 'AvQtyV');
    Route:: post('AvQtyVV', 'AvQtyVV');

    //TestCuponCode
    Route:: post('TestCuponCode', 'TestCuponCode');

    //Filter Products
    Route:: post('FilterProductGroup', 'FilterProductGroup');
    Route:: post('FilterProductBrand', 'FilterProductBrand');
    Route:: post('FilterProductName', 'FilterProductName');


    //PlaceOrder
    Route:: post('PlaceOrder', 'PlaceOrder');
    
    
    //Backup Database
     Route:: post('BackupDBSpecificApi', 'BackupDBSpecificApi');
     Route:: get('AllBackupDB', 'AllBackupDB');
    
    //Renew Subscribe
     Route:: post('RenewSubscribeApi', 'RenewSubscribeApi');
    
    
    //======  CRM  ==================
    
    
    //AddClientCRM
         Route:: post('AddClientCRM', 'AddClientCRM');
    
        //EditClientCRM
         Route:: post('EditClientCRM', 'EditClientCRM');
    
    
        //InquiryStatus
         Route:: post('InquiryStatus', 'InquiryStatus');
    
        
        //AddTicketCRM
         Route:: post('AddTicketCRM', 'AddTicketCRM');
         Route:: post('EditTicketCRM', 'EditTicketCRM');
         Route:: post('DeleteTicketCRM', 'DeleteTicketCRM');
         Route:: post('SolveTicketsClientCRM', 'SolveTicketsClientCRM');
    

        //AddCommentCRM
         Route:: post('AddCommentCRM', 'AddCommentCRM');
         Route:: post('EditCommentCRM', 'EditCommentCRM');
         Route:: post('DeleteCommentCRM', 'DeleteCommentCRM');
    
    //TicektIssuesCRM
             Route:: get('TicektIssuesCRM', 'TicektIssuesCRM');
    //InterviewsTypesCRM
     Route:: get('InterviewsTypesCRM', 'InterviewsTypesCRM');
    //CustomersRateTypesCRM
           Route:: get('CustomersRateTypesCRM', 'CustomersRateTypesCRM');

        
    //ProductsSelectCRM
         Route:: post('ProductsSelectCRM', 'ProductsSelectCRM');
    
    
    //BillNumbersApi
         Route:: post('BillNumbersApi', 'BillNumbersApi');
    
    
    //CustomersCRMApi
         Route:: post('CustomersCRMApi', 'CustomersCRMApi');
    
     
    //ClientRequests
         Route:: post('AddClientRequestsApi', 'AddClientRequestsApi');
         Route:: post('EditClientRequestsApi', 'EditClientRequestsApi');
         Route:: post('DeleteClientRequestsApi', 'DeleteClientRequestsApi');
         Route:: get('ClientRequestsApi', 'ClientRequestsApi');
         Route:: post('ClientRequestsFilterApi', 'ClientRequestsFilterApi');
    
  
    
    
    
    






});


Route::group(['middleware' =>'CustomerAuthApi:api'], function () {




        Route::controller(ApiController:: class)->group( function () {



            //  Profile  =======================================


            Route:: post('Profile', 'Profile');
            Route:: post('UpdateMyAccount', 'UpdateMyAccount');
            Route:: post('UpdateMyPassword', 'UpdateMyPassword');

            //Address
            Route:: post('MyAddresses', 'MyAddresses');
            Route:: post('AddAddress', 'AddAddress');
            Route:: post('EditAddressClient', 'EditAddressClient');
            Route:: post('DeleteAddress', 'DeleteAddress');

            //MyOrder
            Route:: get('MyOrder', 'MyOrder');




            //  Products   =======================================



            //Comments
            Route:: post('AddCommentApi', 'AddCommentApi');
            Route:: post('DeleteCommentApi', 'DeleteCommentApi');
            Route:: post('EditCommentApi', 'EditCommentApi');

            //Rate
            Route:: post('AddRateApi', 'AddRateApi');
            Route:: post('EditRateApi', 'EditRateApi');


            //Wishlist
            Route:: post('Wishlist', 'Wishlist');
            Route:: post('AddWish', 'AddWish');
            Route:: post('DeleteWish', 'DeleteWish');

            //ComparePage
            Route:: post('ComparePage', 'ComparePage');
            Route:: post('AddCompare', 'AddCompare');
            Route:: post('DeleteCompare', 'DeleteCompare');


            //  Cart and Checkout   =======================================

            //Cart
            Route:: post('CartPage', 'CartPage');
            Route:: post('AddCart', 'AddCart');
            Route:: post('DeleteCart', 'DeleteCart');
            Route:: post('UpdateCart', 'UpdateCart');



        });




    });

// ======================= End  E-Commerce  ==============================================================================================================================================



// ======================= Resturant  ==============================================================================================================================================


Route::controller(ResturantAppController:: class)->group( function () {

    //=======================  Client View App ==========================
    //Slider
    Route:: get('ResturantSlider', 'ResturantSlider');

    //Home 2
    Route:: get('ResturantHomeTwo', 'ResturantHomeTwo');

    //About
    Route:: get('ResturantAbout', 'ResturantAbout');

    //Video
    Route:: get('ResturantVideo', 'ResturantVideo');

    //Gallery
    Route:: get('ResturantGallery', 'ResturantGallery');

    //Reviews
    Route:: get('ResturantReviews', 'ResturantReviews');

    //Social
    Route:: get('ResturantSocial', 'ResturantSocial');

    //Terms
    Route:: get('ResturantTerms', 'ResturantTerms');

    //Privacy
    Route:: get('ResturantPrivacy', 'ResturantPrivacy');

    //Groups
    Route:: get('ResturantGroups', 'ResturantGroups');

    //Barnds
    Route:: get('ResturantBrands', 'ResturantBrands');

    //Branches
    Route:: get('ResturantBranches', 'ResturantBranches');

    //Tables
    Route:: get('ResturantTables', 'ResturantTables');

    //Style Use
    Route:: get('ResturantUse', 'ResturantUse');

    //Reservations
    Route:: get('ResturantReservations', 'ResturantReservations');
    Route:: post('ResturantAddReservations', 'ResturantAddReservations');

    //Blogs
    Route:: get('ResturantBlogs', 'ResturantBlogs');
    Route:: post('ResturantBlogsDet', 'ResturantBlogsDet');

    //Apps
    Route:: get('ResturantAppsApi', 'ResturantAppsApi');
    Route:: post('ResturantAppsProPricesApi', 'ResturantAppsProPricesApi');


    // =================   Products  =====================

    Route:: get('ResturantProducts', 'ResturantProducts');
    Route:: get('ResturantFilterProductGroup', 'ResturantFilterProductGroup');
    Route:: get('ResturantFilterProductBrand', 'ResturantFilterProductBrand');
    Route:: get('ResturantFilterProductName', 'ResturantFilterProductName');

    //Test Cupons
    Route:: post('ResturantCuponsCheck', 'ResturantCuponsCheck');



    //  Cart and Checkout   =======================================

    //Cart
    Route:: post('ResturantCartPage', 'ResturantCartPage');
    Route:: post('ResturantAddCart', 'ResturantAddCart');
    Route:: post('ResturantUpdateCart', 'ResturantUpdateCart');
    Route:: post('ResturantDeleteCart', 'ResturantDeleteCart');



    //Place Order
    Route:: post('ResturantPlaceOrder', 'ResturantPlaceOrder');



    //MyOrder
    Route:: post('ResturantMyOrder', 'ResturantMyOrder');


    //=======================  End Client View App ==========================


    //=======================  POS Resturant App ==========================

    
    //Notes
     Route:: get('ResturantProdsNotes', 'ResturantProdsNotes');
     Route:: post('AddNewResturantProdsNote', 'AddNewResturantProdsNote');
    
    

    //Filters

    //Serach Product Filter
    Route:: post('SerachResturantProductFilter', 'SerachResturantProductFilter');
    Route:: post('SerachResturantProductGroupFilter', 'SerachResturantProductGroupFilter');
    Route:: post('SerachResturantProductBrandFilter', 'SerachResturantProductBrandFilter');
    Route:: post('SerachResturantAllProductFilter', 'SerachResturantAllProductFilter');
    Route:: post('FaveProductFilter', 'FaveProductFilter');

    //Filter of Vairables Assembly Qties
    Route:: post('ResturantVAssemblyQtyFilter', 'ResturantVAssemblyQtyFilter');

    //Filter of Additions of Products
    Route:: post('ResturantAdditionsProducts', 'ResturantAdditionsProducts');

    //Waiters
    Route:: get('ResturantWaiters', 'ResturantWaiters');


    //  ======== Tables ===============

    //Avalaible Tables
    Route:: get('ResturantAVTables', 'ResturantAVTables');


  //Add New Table
    Route:: post('ResturantAddNewTable', 'ResturantAddNewTable');


//Resreved Tables
    Route:: get('ResturantReservedTables', 'ResturantReservedTables');


//AllTablesReservedHall
    Route:: get('AllTablesReservedHall', 'AllTablesReservedHall');

//SeparatingDataTables
    Route:: get('SeparatingDataTablesApi', 'SeparatingDataTablesApi');


//Merg Tables
    Route:: post('PostMergTablesApi', 'PostMergTablesApi');


//Moving Tables
    Route:: post('PostMovingApi', 'PostMovingApi');


//Sperating Tables
    Route:: post('PostSeparatingApi', 'PostSeparatingApi');


    //  ======== Sales Resturant ===============


    //============ Sales ===================

    Route:: get('ResturantSalesSechdule', 'ResturantSalesSechdule');
    Route:: post('FilterResturantSalesSechdule', 'FilterResturantSalesSechdule');
    Route:: post('DeleteResturantSalesApi', 'DeleteResturantSalesApi');
    Route:: post('EditResturantSalesApi', 'EditResturantSalesApi');
    Route:: post('AddSalesBillResturant', 'AddSalesBillResturant');

    //================ Hold Bills ==========================

    Route:: get('ResturantHoldBills', 'ResturantHoldBills');
    Route:: post('FilterResturantHoldBills', 'FilterResturantHoldBills');
    Route:: post('HoldResturantBillDetails', 'HoldResturantBillDetails');
    Route:: post('DeleteResturantHoldBill', 'DeleteResturantHoldBill');
    Route:: post('AddResturantHoldBill', 'AddResturantHoldBill');
    Route:: post('HoldPostResturantPOS', 'HoldPostResturantPOS');


    //================ Hold Hall Bills ==========================

    Route:: post('AddProHallOrder', 'AddProHallOrder');

    Route:: post('DeleteProHallOrder', 'DeleteProHallOrder');


    //================ Kitchen ==========================

    Route:: get('KitchenHallBills', 'KitchenHallBills');
    Route:: get('KitchenDeliveryBills', 'KitchenDeliveryBills');
    Route:: get('KitchenTakeawayBills', 'KitchenTakeawayBills');
    Route:: get('KitchenHallMoreBills', 'KitchenHallMoreBills');
    Route:: get('KitchenHallRemoveBills', 'KitchenHallRemoveBills');

    //Ended
    Route:: post('EndKitchenOrderTakeDeliv', 'EndKitchenOrderTakeDeliv');
    Route:: post('EndKitchenOrderHallApi', 'EndKitchenOrderHallApi');
    Route:: post('EndKitchenOrderHallMoreApi', 'EndKitchenOrderHallMoreApi');
    Route:: post('EndKitchenOrderHallRemoveApi', 'EndKitchenOrderHallRemoveApi');


    //================ Recived ==========================

    Route:: get('RecivedHallBills', 'RecivedHallBills');
    Route:: get('RecivedDeliveryBills', 'RecivedDeliveryBills');
    Route:: get('RecivedTakeawayBills', 'RecivedTakeawayBills');

    //Ended
    Route:: post('EndRecivedOrderTakeDeliv', 'EndRecivedOrderTakeDeliv');
    Route:: post('PostEndRecivedOrderHallApi', 'PostEndRecivedOrderHallApi');


    //=======================  End POS Resturant App ==========================


});



// ======================= End Resturant  ==============================================================================================================================================

