@php
use App\Models\Event;
use App\Models\Products;
use App\Models\CompanyData;
use App\Models\StorsTransfers;
use App\Models\SafeTransfers;
use App\Models\ReciptMaintaince;
use App\Models\Modules;
use App\Models\ModuleSettingsNum;
use App\Models\ReportsSettings;
use App\Models\Notifications;
use App\Models\ManufacturingDefaultData;
$DefManu=ManufacturingDefaultData::orderBy('id','desc')->first();
$Def=CompanyData::orderBy('id','desc')->first();
$NumTransSafes=SafeTransfers::where('Status',0)->count();
$NumTransStroes=StorsTransfers::where('Status',0)->count();
$CountRecipt=ReciptMaintaince::orderBy('id','desc')
->whereIn('Status',[2,7])
->where('Eng',auth()->guard('admin')->user()->emp)
->count();
$Modules=Modules::orderBy('id','desc')->first();
$ModulesSett=ModuleSettingsNum::orderBy('id','desc')->first();
$ReportsSettings=ReportsSettings::orderBy('id','desc')->first();
if(auth()->guard('admin')->user()->emp == 0){
$NotificationsCount=Notifications::where('Status',0)->count();
$Notifications=Notifications::orderBy('id','desc')->where('Status',0)->take(20)->get();
}else{
$NotificationsCount=Notifications::where('Status',0)->where('Emp',auth()->guard('admin')->user()->emp)->count();
$Notifications=Notifications::orderBy('id','desc')->where('Status',0)->where('Emp',auth()->guard('admin')->user()->emp)->take(20)->get();
}
@endphp
@if(app()->getLocale() == 'ar')
<!--Arabic style-->
<style>
   /* مسافة واضحة بين الأيقونة والنص */
   .nav-link-text i {
   margin-right: 10px; /* مسافة أكبر */
   }
   /* ===== Main menu item ===== */
   li > a {
   display: flex;
   align-items: center;
   padding: 12px 20px;
   border-radius: 14px;
   color: #fff;
   font-weight: 600;
   text-decoration: none;
   transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
   background: #2A7F7A; /* اللون الأساسي لكل ثيم */
   box-shadow: 0 4px 12px rgba(0,0,0,0.1);
   position: relative;
   }
   /* Hover effect for main item */
   li > a:hover {
   background: #dcdcdc; /* رمادي فاتح عند hover */
   color: #333; /* نص داكن مناسب للرمادي */
   transform: translateY(-3px) scale(1.03);
   box-shadow: 0 10px 25px rgba(0,0,0,0.15);
   }
   /* Icon animation */
   li > a i {
   margin-right: 12px;
   transition: transform 0.4s ease, color 0.4s ease, text-shadow 0.4s ease;
   }
   li > a:hover i {
   transform: rotate(25deg) scale(1.3);
   color: #333;
   text-shadow: 0 0 6px #999;
   }
   /* Glow effect on text */
   li > a:hover .nav-link-text {
   text-shadow: 0 0 4px #999;
   transform: translateX(2px) scale(1.02);
   }
   /* ===== Submenu container ===== */
   ul#menu24 {
   max-height: 0;
   overflow: hidden;
   transition: max-height 0.5s ease, opacity 0.5s ease;
   padding-left: 15px;
   }
   /* Show submenu with staggered fade + slide */
   li:hover > ul#menu24 {
   max-height: 600px;
   opacity: 1;
   }
   /* Submenu items */
   ul#menu24 li a {
   display: block;
   padding: 10px 18px;
   border-radius: 12px;
   color: #fff; /* اللون الأساسي للنص */
   font-weight: 500;
   transition: all 0.35s ease;
   background: #2A7F7A; /* الخلفية الأساسية لكل ثيم */
   margin-bottom: 5px;
   }
   /* Submenu hover */
   ul#menu24 li a:hover {
   background: #dcdcdc; /* رمادي فاتح عند hover */
   color: #333;
   transform: translateX(8px) scale(1.05);
   box-shadow: 0 6px 20px rgba(0,0,0,0.15);
   text-shadow: 0 0 4px #999;
   }
   /* Animate submenu items staggered */
   ul#menu24 li {
   opacity: 0;
   transform: translateY(20px);
   transition: all 0.4s ease;
   }
   li:hover > ul#menu24 li {
   opacity: 1;
   transform: translateY(0);
   }
   /* Stagger delay لكل عنصر فرعي */
   ul#menu24 li:nth-child(1) { transition-delay: 0.05s; }
   ul#menu24 li:nth-child(2) { transition-delay: 0.1s; }
   ul#menu24 li:nth-child(3) { transition-delay: 0.15s; }
   ul#menu24 li:nth-child(4) { transition-delay: 0.2s; }
   /* Cursor pointer */
   ul#menu24 li a, li > a {
   cursor: pointer;
   }
   .nav-menu li>ul {
   background-color: rgb(71 63 99);
   position: absolute;
   right: 270px;
   top: 217px;
   z-index: 1015;
   width: 384px;
   padding-inline-start: 0px;
   }
   .nav-menu li {
   position: unset;
   }
   .nav-menu li>ul li a:before {
   content: "";
   width: 5px;
   height: 5px;
   position: absolute;
   right: 10px;
   top: 18px;
   border: 1px solid #bfb9c9;
   border-radius: 50%;
   }
   .mod-nav-link:not(.nav-function-top):not(.nav-function-minify):not(.mod-hide-nav-icons) ul.nav-menu:not(.nav-menu-compact)>li>ul:before {
   display: none;
   }
   .nav-menu li>ul li a {
   padding: 10px 23px;
   }
   .mod-nav-link:not(.nav-function-top):not(.nav-function-minify):not(.mod-hide-nav-icons) ul.nav-menu:not(.nav-menu-compact)>li>ul>li a:after {
   right: 10px;
   left: unset;
   top: 18px;
   display: none;
   }
   .nav-function-top .page-sidebar .primary-nav .nav-menu>li>ul {
   right: unset;
   width: unset;
   }
   .nav-function-top .page-sidebar .primary-nav .nav-menu>li>ul:before {
   left: unset;
   right: 0;
   }
   #js-nav-menu-wrapper {
   overflow-x: auto !important;
   }
   #js-nav-menu-wrapper-left-btn,
   #js-nav-menu-wrapper-right-btn {
   display: none !important;
   }
   ::-webkit-scrollbar {
   height: 6px;
   width: 2px;
   }
   *::-webkit-scrollbar-track {
   background: transparent;
   }
   *::-webkit-scrollbar-thumb {
   background-color: #886ab5;
   border-radius: 50px;
   border: 1px solid #8361b6;
   }
   @media (max-width:600px) {
   .nav-menu li>ul {
   background-color: rgb(71 63 99);
   position: unset;
   right: unset;
   top: unset;
   z-index: 1015;
   width: unset;
   padding-inline-start: 0px;
   }
   }
</style>
@else
<!--English style-->
<style>
   .nav-menu li>ul {
   background-color: rgb(71 63 99);
   position: absolute;
   left: 270px;
   top: 217px;
   z-index: 1015;
   width: 384px;
   padding-inline-start: 0px;
   }
   .nav-menu li {
   position: unset;
   }
   .nav-menu li>ul li a:before {
   content: "";
   width: 5px;
   height: 5px;
   position: absolute;
   left: 10px;
   top: 18px;
   border: 1px solid #bfb9c9;
   border-radius: 50%;
   }
   .mod-nav-link:not(.nav-function-top):not(.nav-function-minify):not(.mod-hide-nav-icons) ul.nav-menu:not(.nav-menu-compact)>li>ul:before {
   display: none;
   }
   .nav-menu li>ul li a {
   padding: 10px 23px;
   }
   .mod-nav-link:not(.nav-function-top):not(.nav-function-minify):not(.mod-hide-nav-icons) ul.nav-menu:not(.nav-menu-compact)>li>ul>li a:after {
   right: 10px;
   left: unset;
   top: 18px;
   display: none;
   }
   .nav-function-top .page-sidebar .primary-nav .nav-menu>li>ul {
   right: unset;
   width: unset;
   }
   .nav-function-top .page-sidebar .primary-nav .nav-menu>li>ul:before {
   left: unset;
   right: 0;
   }
   #js-nav-menu-wrapper {
   overflow-x: auto !important;
   }
   #js-nav-menu-wrapper-left-btn,
   #js-nav-menu-wrapper-right-btn {
   display: none !important;
   }
   ::-webkit-scrollbar {
   height: 6px;
   width: 2px;
   }
   *::-webkit-scrollbar-track {
   background: transparent;
   }
   *::-webkit-scrollbar-thumb {
   background-color: #886ab5;
   border-radius: 50px;
   border: 1px solid #8361b6;
   }
   @media (max-width:600px) {
   .nav-menu li>ul {
   background-color: rgb(71 63 99);
   position: unset;
   right: unset;
   top: unset;
   z-index: 1015;
   width: unset;
   padding-inline-start: 0px;
   }
   }
</style>
@endif
<body class="mod-bg-1 mod-nav-link ">
   <script>
      /**
       *	This script should be placed right after the body tag for fast execution
       *	Note: the script is written in pure javascript and does not depend on thirdparty library
       **/
      'use strict';
      
      var classHolder = document.getElementsByTagName("BODY")[0],
          /**
           * Load from localstorage
           **/
          themeSettings = (localStorage.getItem('themeSettings')) ? JSON.parse(localStorage.getItem('themeSettings')) : {},
          themeURL = themeSettings.themeURL || '',
          themeOptions = themeSettings.themeOptions || '';
      /**
       * Load theme options
       **/
      if (themeSettings.themeOptions) {
          classHolder.className = themeSettings.themeOptions;
          console.log("%c✔ Theme settings loaded", "color: #148f32");
      } else {
          console.log("%c✔ Heads up! Theme settings is empty or does not exist, loading default settings...", "color: #ed1c24");
      }
      if (themeSettings.themeURL && !document.getElementById('mytheme')) {
          var cssfile = document.createElement('link');
          cssfile.id = 'mytheme';
          cssfile.rel = 'stylesheet';
          cssfile.href = themeURL;
          document.getElementsByTagName('head')[0].appendChild(cssfile);
      
      } else if (themeSettings.themeURL && document.getElementById('mytheme')) {
          document.getElementById('mytheme').href = themeSettings.themeURL;
      }
      /**
       * Save to localstorage
       **/
      var saveSettings = function() {
          themeSettings.themeOptions = String(classHolder.className).split(/[^\w-]+/).filter(function(item) {
              return /^(nav|header|footer|mod|display)-/i.test(item);
          }).join(' ');
          if (document.getElementById('mytheme')) {
              themeSettings.themeURL = document.getElementById('mytheme').getAttribute("href");
          };
          localStorage.setItem('themeSettings', JSON.stringify(themeSettings));
      }
      /**
       * Reset settings
       **/
      var resetSettings = function() {
          localStorage.setItem("themeSettings", "");
      }
      
   </script>
   <div class="page-wrapper">
   <div class="page-inner">
   <!-- BEGIN Left Aside -->
   <aside class="page-sidebar">
      <div class="page-logo">
         <a href="{{url('KlarAdmin')}}" class="page-logo-link press-scale-down d-flex align-items-center position-relative" data-toggle="modal" data-target="#modal-shortcut">
            <!--Logo-->
            @if(!empty($Def->Logo))
            <img src="{{URL::to($Def->Logo)}}" alt="SmartAdmin WebApp" aria-roledescription="logo">
            @else
            <img src="{{asset('Admin/img/logo.png')}}" alt="SmartAdmin WebApp" aria-roledescription="logo">
            @endif
            <span class="page-logo-text mr-1">
            @if(!empty($Def->Name))
            {{app()->getLocale() == 'ar' ?$Def->Name :$Def->NameEn}}
            @else
            {{trans('admin.Klar')}}
            @endif
            </span>
            <span class="position-absolute text-white opacity-50 small pos-top pos-right mr-2 mt-n2"></span>
            <i class="fal fa-angle-down d-inline-block ml-1 fs-lg color-primary-300"></i>
         </a>
      </div>
      <!-- BEGIN PRIMARY NAVIGATION -->
      <nav id="js-primary-nav" class="primary-nav" role="navigation">
         <div class="nav-filter">
            <div class="position-relative">
               <input type="text" id="nav_filter_input" placeholder="Filter menu" class="form-control" tabindex="0">
               <a href="#" onclick="return false;" class="btn-primary btn-search-close js-waves-off" data-action="toggle" data-class="list-filter-active" data-target=".page-sidebar">
               <i class="fal fa-chevron-up"></i>
               </a>
            </div>
         </div>
         <div class="info-card">
            @if(!empty(auth()->guard('admin')->user()->image))
            <img src="{{auth()->guard('admin')->user()->image}}" class="profile-image rounded-circle" alt="Dr. Codex Lantern">
            @else
            <img src="{{asset('Admin/img/default.jpeg')}}" class="profile-image rounded-circle" alt="Dr. Codex Lantern">
            @endif
            <div class="info-card-text">
               <a href="{{url('Profile')}}" class="d-flex align-items-center text-white">
               <span class="text-truncate text-truncate-sm d-inline-block">
               {{app()->getLocale() == 'ar' ?auth()->guard('admin')->user()->name :auth()->guard('admin')->user()->nameEn}}
               </span>
               </a>
            </div>
            <img src="{{asset('Admin/img/card-backgrounds/cover-2-lg.png')}}" class="cover" alt="cover">
            <a href="#" onclick="return false;" class="pull-trigger-btn" data-action="toggle" data-class="list-filter-active" data-target=".page-sidebar" data-focus="nav_filter_input">
            <i class="fal fa-angle-down"></i>
            </a>
         </div>
         <ul id="js-nav-menu" class="nav-menu">
            @if(auth()->guard('admin')->user()->emp == 0)
            <li>
               <a href="#" title="{{trans('admin.Accounts_Reports')}}" data-filter-tags="{{trans('admin.Accounts_Reports')}}">
               <i class="fal fa-cog"></i>
               <span class="nav-link-text" data-i18n="nav.theme_settings">R A B I H / رابح</span>
               <input type="hidden" id="inpu24" value="1">
               </a>
               <ul style="width:600px;" id="menu24">
                  <div class="row">
                     <div class="col-sm-6">
                        <li>
                           <a href="{{url('IntroView')}}" title="{{trans('admin.Intro')}}" data-filter-tags="{{trans('admin.Intro')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.Intro')}}
                           </span>
                           </a>
                        </li>
                        <li>
                           <a href="{{url('TermsView')}}" title="{{trans('admin.Terms')}}" data-filter-tags="{{trans('admin.Terms')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.Terms')}}
                           </span>
                           </a>
                        </li>
                        <li>
                           <a href="{{url('ReportIssue')}}" title="{{trans('admin.ReportIssue')}}" data-filter-tags="{{trans('admin.ReportIssue')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.ReportIssue')}}
                           </span>
                           </a>
                        </li>
                        <li>
                           <a href="{{url('RabihEducation')}}" title="{{trans('admin.Education')}}" data-filter-tags="{{trans('admin.Education')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.Education')}}
                           </span>
                           </a>
                        </li>
                        <li>
                           <a href="{{url('EmpMail')}}" title="{{trans('admin.EmpMail')}}" data-filter-tags="{{trans('admin.EmpMail')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.EmpMail')}}
                           </span>
                           </a>
                        </li>
                     </div>
                  </div>
               </ul>
            </li>
            @endif
            @if(auth()->guard('admin')->user()->vend != 0)
            @can('تقارير الحسابات')
            <li>
               <a href="#" title="{{trans('admin.Accounts_Reports')}}" data-filter-tags="{{trans('admin.Accounts_Reports')}}">
               <i class="fal fa-cog"></i>
               <span class="nav-link-text" data-i18n="nav.theme_settings">{{trans('admin.Accounts_Reports')}}</span>
               <input type="hidden" id="inpu21" value="1">
               </a>
               <ul style="width:600px;" id="menu21">
                  <div class="row">
                     <div class="col-sm-6">
                        @can('كشف حساب موردين')
                        <li>
                           <a href="{{url('Vendor_Account_Statement')}}" title="{{trans('admin.Vendor_Account_Statement')}}" data-filter-tags="{{trans('admin.Vendor_Account_Statement')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.Vendor_Account_Statement')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                     </div>
                  </div>
               </ul>
            </li>
            @endcan
            @can('التقارير')
            <li>
               <a href="#" title="{{trans('admin.Reports')}}" data-filter-tags="{{trans('admin.Reports')}}">
               <i class="fal fa-edit"></i>
               <span class="nav-link-text" data-i18n="nav.form_stuff">{{trans('admin.Reports')}}</span>
               <input type="hidden" id="inpu20" value="1">
               </a>
               <ul style="width: 1200px;" id="menu20">
                  <div class="row">
                     <div class="col-sm-3">
                        @can('مبيعات المجموعات')
                        <li>
                           <a href="{{url('GroupsSales')}}" title="{{trans('admin.GroupsSales')}}" data-filter-tags="{{trans('admin.GroupsSales')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.GroupsSales')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('مبيعات البرندات')
                        <li>
                           <a href="{{url('BrandsSales')}}" title="{{trans('admin.BrandsSales')}}" data-filter-tags="{{trans('admin.BrandsSales')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.BrandsSales')}}</span>
                           </a>
                        </li>
                        @endcan
                     </div>
                  </div>
               </ul>
            </li>
            @endcan
            @elseif(auth()->guard('admin')->user()->cli != 0)
            @can('تقارير الحسابات')
            <li>
               <a href="#" title="{{trans('admin.Accounts_Reports')}}" data-filter-tags="{{trans('admin.Accounts_Reports')}}">
               <i class="fal fa-cog"></i>
               <span class="nav-link-text" data-i18n="nav.theme_settings">{{trans('admin.Accounts_Reports')}}</span>
               <input type="hidden" id="inpu19" value="1">
               </a>
               <ul style="width:600px;" id="menu19">
                  <div class="row">
                     <div class="col-sm-6">
                        @can('كشف حساب عملاء')
                        <li>
                           <a href="{{url('Customer_Account_Statement')}}" title="{{trans('admin.Customer_Account_Statement')}}" data-filter-tags="{{trans('admin.Customer_Account_Statement')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.Customer_Account_Statement')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                     </div>
                  </div>
               </ul>
            </li>
            @endcan
            @else
            @if($Modules->Accounts == 1)
            @can('الحسابات')
            <li>
               <a href="#" title="{{trans('admin.Accounts')}}" data-filter-tags="{{trans('admin.Accounts')}}">
               <i class="fal fa-info-circle"></i>
               <span class="nav-link-text" data-i18n="nav.application_intel">{{trans('admin.Accounts')}}</span>
               <input type="hidden" id="inpu" value="1">
               </a>
               <ul style="width:600px" id="menu">
                  <div class="row">
                     <div class="col-sm-6">
                        @can('الدليل المحاسبي')
                        <li>
                           <a href="{{url('AccountingManual')}}" title="{{trans('admin.Accounting_Manual')}}" data-filter-tags="{{trans('admin.Accounting_Manual')}}">
                           <span class="nav-link-text" data-i18n="nav.application_intel_introduction">
                           {{trans('admin.Accounting_Manual')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('تحويلات الخزائن')
                        <li>
                           <a href="{{url('SafesTransfer')}}" title="{{trans('admin.Safes_Transfer')}}" data-filter-tags="{{trans('admin.Safes_Transfer')}}">
                           <span class="nav-link-text" data-i18n="nav.form_stuff_basic_inputs"> {{trans('admin.Safes_Transfer')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('مصاريف اصول')
                        <!--      <li>
                           <a href="{{url('AssetExpenses')}}" title="{{trans('admin.AssetExpenses')}}" data-filter-tags="{{trans('admin.AssetExpenses')}}">
                                           <span class="nav-link-text" data-i18n="nav.application_intel_introduction">
                           
                                             {{trans('admin.AssetExpenses')}}
                                                    </span>
                                                    </a>
                                                 </li>  -->
                        @endcan
                        @can('جدول تحويلات الخزائن')
                        <li>
                           <a href="{{url('SafesTransferSechdule')}}" title="{{trans('admin.Safes_Transfer_Sechdule')}}" data-filter-tags="{{trans('admin.Safes_Transfer_Sechdule')}}">
                              <span style="
                                 display:inline-block;
                                 background-color:#3ba7ff;
                                 color:#fff;
                                 padding:2px 8px;
                                 border-radius:6px;
                                 font-weight:bold;
                                 box-shadow:0 0 5px rgba(59,167,255,0.8);
                                 animation: fadeFlash 1.5s infinite;
                                 ">
                              {{$NumTransSafes}}
                              </span>
                              <style>
                                 @keyframes fadeFlash {
                                 0%   { opacity: 1; }
                                 50%  { opacity: 0.3; }
                                 100% { opacity: 1; }
                                 }
                              </style>
                              <span class="nav-link-text" data-i18n="nav.form_stuff_basic_inputs"> {{trans('admin.Safes_Transfer_Sechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه قيد يومي')
                        <li>
                           <a href="{{url('Journalizing')}}" title="{{trans('admin.Journalizing')}}" data-filter-tags="{{trans('admin.Journalizing')}}">
                           <span class="nav-link-text" data-i18n="nav.application_intel_privacy"> {{trans('admin.Journalizing')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه سند قبض')
                        <li>
                           <a href="{{url('Receipt_Voucher')}}" title="{{trans('admin.Receipt_Voucher')}}" data-filter-tags="{{trans('admin.Receipt_Voucher')}}">
                           <span class="nav-link-text" data-i18n="nav.application_intel_privacy">
                           {{trans('admin.Receipt_Voucher')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه سند صرف')
                        <li>
                           <a href="{{url('Payment_Voucher')}}" title="{{trans('admin.Payment_Voucher')}}" data-filter-tags="{{trans('admin.Payment_Voucher')}}">
                           <span class="nav-link-text" data-i18n="nav.application_intel_privacy">
                           {{trans('admin.Payment_Voucher')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه قيد افتتاحي')
                        <li>
                           <a href="{{url('OpeningEntries')}}" title="{{trans('admin.Opening_Entries')}}" data-filter-tags="{{trans('admin.Opening_Entries')}}">
                           <span class="nav-link-text" data-i18n="nav.application_intel_privacy">
                           {{trans('admin.Opening_Entries')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('الشيكات الصادره')
                        <li>
                           <a href="{{url('Exporting_Checks')}}" title="{{trans('admin.Exporting_Checks')}}" data-filter-tags="{{trans('admin.Exporting_Checks')}}">
                           <span class="nav-link-text" data-i18n="nav.application_intel_privacy">
                           {{trans('admin.Exporting_Checks')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('الشيكات الوارده')
                        <li>
                           <a href="{{url('Incoming_checks')}}" title="{{trans('admin.Incoming_checks')}}" data-filter-tags="{{trans('admin.Incoming_checks')}}">
                           <span class="nav-link-text" data-i18n="nav.application_intel_privacy">
                           {{trans('admin.Incoming_checks')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('وصل امانه')
                        <li>
                           <a href="{{url('Insurance_Paper')}}" title="{{trans('admin.Insurance_Paper')}}" data-filter-tags="{{trans('admin.Insurance_Paper')}}">
                           <span class="nav-link-text" data-i18n="nav.application_intel_privacy">
                           {{trans('admin.Insurance_Paper')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('الضرائب')
                        <li>
                           <a href="{{url('Taxes')}}" title="{{trans('admin.Taxes')}}" data-filter-tags="{{trans('admin.Taxes')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_community_support">
                           {{trans('admin.Taxes')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه راس المال')
                        <li>
                           <a href="{{url('Capital')}}" title="{{trans('admin.Capital')}}" data-filter-tags="{{trans('admin.Capital')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.Capital')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('صرف ارباح')
                        <li>
                           <a href="{{url('Spend_Profits')}}" title="{{trans('admin.Spend_Profits')}}" data-filter-tags="{{trans('admin.Spend_Profits')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.Spend_Profits')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('امر دفع')
                        <li>
                           <a href="{{url('Order_Pay')}}" title="{{trans('admin.Order_Pay')}}" data-filter-tags="{{trans('admin.Order_Pay')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.Order_Pay')}} </span>
                           </a>
                        </li>
                        @endcan
                     </div>
                     <div class="col-sm-6">
                        @can('الاصول')
                        <li>
                           <a href="{{url('Assets')}}" title="{{trans('admin.Assets')}}" data-filter-tags="{{trans('admin.Assets')}}">
                           <span class="nav-link-text" data-i18n="nav.application_intel_introduction">
                           {{trans('admin.Assets')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('الخزائن و البنوك')
                        <li>
                           <a href="{{url('Safes_Banks')}}" title="{{trans('admin.Safes_Banks')}}" data-filter-tags="{{trans('admin.Safes_Banks')}}">
                           <span class="nav-link-text" data-i18n="nav.application_intel_privacy">
                           {{trans('admin.Safes_Banks')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('الفروع')
                        <li>
                           <a href="{{url('Branches')}}" title="{{trans('admin.Branches')}}" data-filter-tags="{{trans('admin.Branches')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.Branches')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول القيود اليوميه')
                        <li>
                           <a href="{{url('JournalizingSechdule')}}" title="{{trans('admin.Journalizing_Sechdule')}}" data-filter-tags="{{trans('admin.Journalizing_Sechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.form_stuff_basic_inputs"> {{trans('admin.Journalizing_Sechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول القيود الافتتاحيه')
                        <li>
                           <a href="{{url('Opening_EntriesSechdule')}}" title="{{trans('admin.Opening_Entries_Sechdule')}}" data-filter-tags="{{trans('admin.Opening_Entries_Sechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.form_stuff_basic_inputs"> {{trans('admin.Opening_Entries_Sechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول سند القبض')
                        <li>
                           <a href="{{url('Receipt_VoucherSechdule')}}" title="{{trans('admin.Receipt_Voucher_Sechdule')}}" data-filter-tags="{{trans('admin.Receipt_Voucher_Sechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.form_stuff_basic_inputs"> {{trans('admin.Receipt_Voucher_Sechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول سند الصرف')
                        <li>
                           <a href="{{url('Payment_VoucherSechdule')}}" title="{{trans('admin.Payment_Voucher_Sechdule')}}" data-filter-tags="{{trans('admin.Payment_Voucher_Sechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.form_stuff_basic_inputs"> {{trans('admin.Payment_Voucher_Sechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('العملات')
                        <li>
                           <a href="{{url('Coins')}}" title="{{trans('admin.Coins')}}" data-filter-tags="{{trans('admin.Coins')}}">
                           <span class="nav-link-text" data-i18n="nav.application_intel_marketing_dashboard">
                           {{trans('admin.Coins')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('مراكز التكلفه')
                        <li>
                           <a href="{{url('CostCenters')}}" title="{{trans('admin.Cost_Centers')}}" data-filter-tags="{{trans('admin.Cost_Centers')}}">
                           <span class="nav-link-text" data-i18n="nav.application_intel_marketing_dashboard">
                           {{trans('admin.Cost_Centers')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('انواع الشيكات')
                        <li>
                           <a href="{{url('Checks_Type')}}" title="{{trans('admin.Checks_Type')}}" data-filter-tags="{{trans('admin.Checks_Type')}}">
                           <span class="nav-link-text" data-i18n="nav.application_intel_marketing_dashboard">
                           {{trans('admin.Checks_Type')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('الشركاء')
                        <li>
                           <a href="{{url('Partners')}}" title="{{trans('admin.Partners')}}" data-filter-tags="{{trans('admin.Partners')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.Partners')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('المستثمرين')
                        <li>
                           <a href="{{url('Investors')}}" title="{{trans('admin.Investors')}}" data-filter-tags="{{trans('admin.Investors')}}">
                           <span class="nav-link-text" data-i18n="nav.Investors"> {{trans('admin.Investors')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('تقرير راس المال')
                        <li>
                           <a href="{{url('CapitalReport')}}" title="{{trans('admin.CapitalReport')}}" data-filter-tags="{{trans('admin.CapitalReport')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.CapitalReport')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول اوامر الدفع')
                        <li>
                           <a href="{{url('Order_PaySechdule')}}" title="{{trans('admin.Order_PaySechdule')}}" data-filter-tags="{{trans('admin.Order_PaySechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.Order_PaySechdule')}} </span>
                           </a>
                        </li>
                        @endcan
                     </div>
                  </div>
               </ul>
            </li>
            @endcan
            @can('تقارير الحسابات')
            <li>
               <a href="#" title="{{trans('admin.Accounts_Reports')}}" data-filter-tags="{{trans('admin.Accounts_Reports')}}">
               <i class="fal fa-cog"></i>
               <span class="nav-link-text" data-i18n="nav.theme_settings">{{trans('admin.Accounts_Reports')}}</span>
               <input type="hidden" id="inpu1" value="1">
               </a>
               <ul style="width:600px;" id="menu1">
                  <div class="row">
                     <div class="col-sm-6">
                        @can('كشف حساب عملاء')
                        <li>
                           <a href="{{url('Customer_Account_Statement')}}" title="{{trans('admin.Customer_Account_Statement_One')}}" data-filter-tags="{{trans('admin.Customer_Account_Statement_One')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.Customer_Account_Statement_One')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @if($ReportsSettings->ClientAccountStatement == 1)
                        @can('تقرير كشف حساب عميل مفصل')
                        <li>
                           <a href="{{url('ClientAccountStatement')}}" title="{{trans('admin.ClientAccountStatement')}}" data-filter-tags="{{trans('admin.ClientAccountStatement')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ClientAccountStatement')}}</span>
                           </a>
                        </li>
                        @endcan
                        @endif
                        @if($ReportsSettings->ClientsStatement == 1)
                        @can('تقرير كشف حساب عملاء')
                        <li>
                           <a href="{{url('ClientsStatement')}}" title="{{trans('admin.ClientsStatement')}}" data-filter-tags="{{trans('admin.ClientsStatement')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ClientsStatement')}}</span>
                           </a>
                        </li>
                        @endcan
                        @endif
                        @can('ارصده العملاء')
                        <li>
                           <a href="{{url('Customer_Balances')}}" title="{{trans('admin.Customer_Balances')}}" data-filter-tags="{{trans('admin.Customer_Balances')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.Customer_Balances')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @if($ReportsSettings->Customer_Debts == 1)
                        @can('اعمار ديون العملاء')
                        <li>
                           <a href="{{url('Customer_Debts')}}" title="{{trans('admin.Customer_Debts')}}" data-filter-tags="{{trans('admin.Customer_Debts')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Customer_Debts')}}</span>
                           </a>
                        </li>
                        @endcan
                        @endif
                        @if($ReportsSettings->InstallmentReport == 1)
                        @can('الاقساط الغير مدفوعه')
                        <li style="width: 100%">
                           <a href="{{url('InstallmentReport')}}" title="{{trans('admin.InstallmentReport')}}" data-filter-tags="{{trans('admin.InstallmentReport')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.InstallmentReport')}}</span>
                           </a>
                        </li>
                        @endcan
                        @endif
                        @can('كشف حساب موردين')
                        <li>
                           <a href="{{url('Vendor_Account_Statement')}}" title="{{trans('admin.Vendor_Account_Statement_One')}}" data-filter-tags="{{trans('admin.Vendor_Account_Statement_One')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.Vendor_Account_Statement_One')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @if($ReportsSettings->VendorAccountStatement == 1)
                        @can('تقرير كشف حساب مورد مفصل')
                        <li>
                           <a href="{{url('VendorAccountStatement')}}" title="{{trans('admin.VendorAccountStatement')}}" data-filter-tags="{{trans('admin.VendorAccountStatement')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.VendorAccountStatement')}}</span>
                           </a>
                        </li>
                        @endcan
                        @endif
                        @if($ReportsSettings->VendorsStatement == 1)
                        @can('تقرير كشف حساب موردين')
                        <li>
                           <a href="{{url('VendorsStatement')}}" title="{{trans('admin.VendorsStatement')}}" data-filter-tags="{{trans('admin.VendorsStatement')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.VendorsStatement')}}</span>
                           </a>
                        </li>
                        @endcan
                        @endif
                        @if($ReportsSettings->Vendor_Debts == 1)
                        @can('اعمار ديون الموردين')
                        <li>
                           <a href="{{url('Vendor_Debts')}}" title="{{trans('admin.Vendor_Debts')}}" data-filter-tags="{{trans('admin.Vendor_Debts')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Vendor_Debts')}}</span>
                           </a>
                        </li>
                        @endcan
                        @endif
                        @can('قائمه الدخل')
                        <li>
                           <a href="{{url('Incom_List')}}" title="{{trans('admin.Incom_List')}}" data-filter-tags="{{trans('admin.Incom_List')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.Incom_List')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('قائمه المركز المالي')
                        <li>
                           <a href="{{url('Financial_Center')}}" title="{{trans('admin.Financial_Center')}}" data-filter-tags="{{trans('admin.Financial_Center')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.Financial_Center')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @if($ReportsSettings->SubIncomList == 1)
                        @can('تقرير قائمه الدخل الفرعي')
                        <li>
                           <a href="{{url('SubIncomList')}}" title="{{trans('admin.SubIncomList')}}" data-filter-tags="{{trans('admin.SubIncomList')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.SubIncomList')}}</span>
                           </a>
                        </li>
                        @endcan
                        @endif
                        @can('تقرير اعمار ديون العملاء')
                        <li>
                           <a href="{{url('CustomerDebtRestructuring')}}" title="{{trans('admin.CustomerDebtRestructuring')}}" data-filter-tags="{{trans('admin.CustomerDebtRestructuring')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.CustomerDebtRestructuring')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('تقرير اعمار ديون الموردين')
                        <li>
                           <a href="{{url('VendorDebtRestructuring')}}" title="{{trans('admin.VendorDebtRestructuring')}}" data-filter-tags="{{trans('admin.VendorDebtRestructuring')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.VendorDebtRestructuring')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('ارصدة الموردين')
                        <li>
                           <a href="{{url('VendorsBalancesReport')}}" title="{{trans('admin.VendorsBalancesReport')}}" data-filter-tags="{{trans('admin.VendorsBalancesReport')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.VendorsBalancesReport')}}</span>
                           </a>
                        </li>
                        @endcan
                     </div>
                     <div class="col-sm-6">
                        @can('كشف حساب خزنه، بنك')
                        <li>
                           <a href="{{url('Safe_Bank_Statement')}}" title="{{trans('admin.Safe_Bank_Statement')}}" data-filter-tags="{{trans('admin.Safe_Bank_Statement')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">{{trans('admin.Safe_Bank_Statement')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('ارصده الخزائن و البنوك')
                        <li>
                           <a href="{{url('Safes_Balances')}}" title="{{trans('admin.Safes_Balances')}}" data-filter-tags="{{trans('admin.Safes_Balances')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.Safes_Balances')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @if($ReportsSettings->SafesTransferReport == 1)
                        @can('تقرير تحويلات خزائن')
                        <li>
                           <a href="{{url('SafesTransferReport')}}" title="{{trans('admin.SafesTransferReport')}}" data-filter-tags="{{trans('admin.SafesTransferReport')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.SafesTransferReport')}}</span>
                           </a>
                        </li>
                        @endcan
                        @endif
                        @can('اجمالي مصاريف الخزائن')
                        @if($ReportsSettings->TotalExpensesSafes == 1)
                        <li>
                           <a href="{{url('TotalExpensesSafes')}}" title=" {{trans('admin.TotalExpensesSafes')}}" data-filter-tags="{{trans('admin.TotalExpensesSafes')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.TotalExpensesSafes')}} </span>
                           </a>
                        </li>
                        @endif
                        @endcan
                        @if($ReportsSettings->ExpensesList == 1)
                        @can('تقرير قائمه المصاريف')
                        <li>
                           <a href="{{url('ExpensesList')}}" title="{{trans('admin.ExpensesList')}}" data-filter-tags="{{trans('admin.ExpensesList')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ExpensesList')}}</span>
                           </a>
                        </li>
                        @endcan
                        @endif
                        @if($ReportsSettings->ExpensesReport == 1)
                        @can('تقرير المصاريف')
                        <li>
                           <a href="{{url('ExpensesReport')}}" title="{{trans('admin.ExpensesReport')}}" data-filter-tags="{{trans('admin.ExpensesReport')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ExpensesReport')}}</span>
                           </a>
                        </li>
                        @endcan
                        @endif
                        @if($ReportsSettings->IncomListReport == 1)
                        @can('تقرير قائمه المقبوضات')
                        <li>
                           <a href="{{url('IncomListReport')}}" title="{{trans('admin.IncomListReport')}}" data-filter-tags="{{trans('admin.IncomListReport')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.IncomListReport')}}</span>
                           </a>
                        </li>
                        @endcan
                        @endif
                        @can('اجمالي تحصيل المناديب')
                        <li>
                           <a href="{{url('TotalCollectorDepaitor')}}" title="{{trans('admin.TotalCollectorDepaitor')}}" data-filter-tags="{{trans('admin.TotalCollectorDepaitor')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.TotalCollectorDepaitor')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('تقارير الشيكات')
                        <li>
                           <a href="{{url('Checks_Reports')}}" title="{{trans('admin.Checks_Reports')}}" data-filter-tags="{{trans('admin.Checks_Reports')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.Checks_Reports')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('تقرير وصلات الامانه')
                        <li>
                           <a href="{{url('InsurancePaperReport')}}" title="{{trans('admin.InsurancePaperReport')}}" data-filter-tags="{{trans('admin.InsurancePaperReport')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.InsurancePaperReport')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('تقارير مركز التكلفه')
                        <li>
                           <a href="{{url('Cost_Centers_Report')}}" title="{{trans('admin.Cost_Centers_Report')}}" data-filter-tags="{{trans('admin.Cost_Centers_Report')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.Cost_Centers_Report')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('تقرير الاصول الثابته')
                        <li>
                           <a href="{{url('Fixed_Assets_Report')}}" title="{{trans('admin.Fixed_Assets_Report')}}" data-filter-tags="{{trans('admin.Fixed_Assets_Report')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_saving_to_database">
                           {{trans('admin.Fixed_Assets_Report')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('اليوميه العامه')
                        <li>
                           <a href="{{url('General_Daily')}}" title="{{trans('admin.General_Daily')}}" data-filter-tags="{{trans('admin.General_Daily')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_how_it_works">
                           {{trans('admin.General_Daily')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('ميزان المراجعه')
                        <li>
                           <a href="{{url('Trial_Balance')}}" title="{{trans('admin.Trial_Balance')}}" data-filter-tags="{{trans('admin.Trial_Balance')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_layout_options">
                           {{trans('admin.Trial_Balance')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('ارصده الحسابات')
                        <li>
                           <a href="{{url('Account_Balances')}}" title="{{trans('admin.Account_Balances')}}" data-filter-tags="{{trans('admin.Account_Balances')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_skin_options"> {{trans('admin.Account_Balances')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('دفتر الاستاذ')
                        <li>
                           <a href="{{url('Ledger')}}" title="{{trans('admin.Ledger')}}" data-filter-tags="{{trans('admin.Ledger')}}">
                           <span class="nav-link-text" data-i18n="nav.theme_settings_theme_modes_(beta)">{{trans('admin.Ledger')}} </span>
                           </a>
                        </li>
                        @endcan
                     </div>
                  </div>
               </ul>
            </li>
            @endcan
            @endif
            @if($Modules->Stores == 1)
            @can('المخازن')
            <li>
               <a href="#" title="{{trans('admin.Supply_Chain')}}" data-filter-tags="{{trans('admin.Supply_Chain')}}">
               <i class="fal fa-book"></i>
               <span class="nav-link-text" data-i18n="nav.documentation">{{trans('admin.Supply_Chain')}} </span>
               <input type="hidden" id="inpu2" value="1">
               </a>
               <ul style="width:600px;" id="menu2">
                  <div class="row">
                     <div class="col-sm-6">
                        @can('عرض المخازن')
                        <li>
                           <a href="{{url('Stores')}}" title="{{trans('admin.Stores')}}" data-filter-tags="{{trans('admin.Stores')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_general_docs"> {{trans('admin.Stores')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('دليل الاصناف')
                        <li>
                           <a href="{{url('ItemsGuide')}}" title="{{trans('admin.Items_Guide')}}" data-filter-tags="{{trans('admin.Items_Guide')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_premium_support"> {{trans('admin.Items_Guide')}} </span>
                           </a>
                        </li>
                        <li>
                           <a href="{{url('ItemsGuide2')}}" title="{{trans('admin.Items_Guide')}}" data-filter-tags="{{trans('admin.Items_Guide')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_premium_support"> {{trans('admin.New_Items_Guide')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه صنف')
                        <li>
                           <a href="{{url('Add_Items')}}" title="{{trans('admin.Add_Items')}}" data-filter-tags="{{trans('admin.Add_Items')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_licensing">
                           {{trans('admin.Add_Items')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول الاصناف')
                        <li>
                           <a href="{{url('Products_Sechdule')}}" title="{{trans('admin.Products_Sechdule')}}" data-filter-tags="{{trans('admin.Products_Sechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_licensing">
                           {{trans('admin.Products_Sechdule')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه تحويلات المخازن')
                        <li>
                           <a href="{{url('StoresTransfers')}}" title="{{trans('admin.Stores_Transfers')}}" data-filter-tags="{{trans('admin.Stores_Transfers')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_build_notes">
                           {{trans('admin.Stores_Transfers')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول تحويلات المخازن')
                        <li>
                           <a href="{{url('StoresTransfersSechdule')}}" title="{{trans('admin.Stores_Transfers_Sechdule')}}" data-filter-tags="{{trans('admin.Stores_Transfers_Sechdule')}}">
                          <span style="
    display:inline-block;
    background: linear-gradient(90deg, #6bc1ff, #a38bff);
    color:#fff;
    padding:2px 8px;
    border-radius:6px;
    font-weight:bold;
    box-shadow:0 0 6px rgba(107,193,255,0.7);
    animation:fadeFlash 1.5s infinite;
">
    {{$NumTransStroes}}
</span>

<style>
@keyframes fadeFlash {
    0%   { opacity: 1; }
    50%  { opacity: 0.3; }
    100% { opacity: 1; }
}
</style>
                           <span class="nav-link-text" data-i18n="nav.documentation_licensing">
                           {{trans('admin.Stores_Transfers_Sechdule')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('اذن استلام بضاعه')
                        <li>
                           <a href="{{url('Permission_to_receive_goods')}}" title="{{trans('admin.Permission_to_receive_goods')}}" data-filter-tags="{{trans('admin.Permission_to_receive_goods')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_flavors_&_editions">
                           {{trans('admin.Permission_to_receive_goods')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول استلام بضاعه')
                        <li>
                           <a href="{{url('ReceiveGoodsSechdule')}}" title="{{trans('admin.ReceiveGoodsSechdule')}}" data-filter-tags="{{trans('admin.ReceiveGoodsSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_flavors_&_editions">
                           {{trans('admin.ReceiveGoodsSechdule')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('اذن صرف بضاعه')
                        <li>
                           <a href="{{url('Permission_to_exchange_goods')}}" title="{{trans('admin.Permission_to_exchange_goods')}}" data-filter-tags="{{trans('admin.Permission_to_exchange_goods')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_flavors_&_editions">
                           {{trans('admin.Permission_to_exchange_goods')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول صرف بضاعه')
                        <li>
                           <a href="{{url('ExchangeGoodsSechdule')}}" title="{{trans('admin.ExchangeGoodsSechdule')}}" data-filter-tags="{{trans('admin.ExchangeGoodsSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_flavors_&_editions">
                           {{trans('admin.ExchangeGoodsSechdule')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('تالف')
                        <li>
                           <a href="{{url('Consists')}}" title="{{trans('admin.Consists')}}" data-filter-tags="{{trans('admin.Consists')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.Consists')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول التوالف')
                        <li>
                           <a href="{{url('ConsistsSechdule')}}" title="{{trans('admin.ConsistsSechdule')}}" data-filter-tags="{{trans('admin.ConsistsSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.ConsistsSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه اصناف بدايه فتره')
                        <li>
                           <a href="{{url('StartPeriodProducts')}}" title="{{trans('admin.Start_Period_Products')}}" data-filter-tags="{{trans('admin.Start_Period_Products')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_licensing">
                           {{trans('admin.Start_Period_Products')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول اصناف بدايه فتره')
                        <li>
                           <a href="{{url('StartPeriodSechdule')}}" title="{{trans('admin.Start_Period_Sechdule')}}" data-filter-tags="{{trans('admin.Start_Period_Sechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_licensing">
                           {{trans('admin.Start_Period_Sechdule')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('تغيير الاسعار')
                        <li>
                           <a href="{{url('NewChangePrice')}}" title="{{trans('admin.ChangePrices')}}" data-filter-tags="{{trans('admin.ChangePrices')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_premium_support"> {{trans('admin.ChangePrices')}} </span>
                           </a>
                        </li>
                        @endcan
                     </div>
                     <div class="col-sm-6">
                        @can('وحدات القياس')
                        <li>
                           <a href="{{url('Measurement_Units')}}" title="{{trans('admin.Measurement_Units')}}" data-filter-tags="{{trans('admin.Measurement_Units')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_project_structure">
                           {{trans('admin.Measurement_Units')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('مجموعه الاصناف')
                        <li>
                           <a href="{{url('Items_Groups')}}" title="{{trans('admin.Items_Groups')}}" data-filter-tags="{{trans('admin.Items_Groups')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_flavors_&_editions">
                           {{trans('admin.Items_Groups')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('الصناعه و الماركات')
                        <li>
                           <a href="{{url('Manufacture')}}" title="{{trans('admin.Manufacture')}}" data-filter-tags="{{trans('admin.Manufacture')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_community_support">
                           {{trans('admin.Manufacture')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('المتغيرات')
                        <li>
                           <a href="{{url('Virables')}}" title="{{trans('admin.Virables')}}" data-filter-tags="{{trans('admin.Virables')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_community_support">
                           {{trans('admin.Virables')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه جرد')
                        <li>
                           <a href="{{url('Inventory')}}" title="{{trans('admin.Inventory')}}" data-filter-tags="{{trans('admin.Inventory')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_licensing">
                           {{trans('admin.Inventory')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول الجرد')
                        <li>
                           <a href="{{url('Inventory_Sechdule')}}" title="{{trans('admin.Inventory_Sechdule')}}" data-filter-tags="{{trans('admin.Inventory_Sechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_licensing">
                           {{trans('admin.Inventory_Sechdule')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول التسويه')
                        <li>
                           <a href="{{url('Settlement_Sechdule')}}" title="{{trans('admin.Settlement_Sechdule')}}" data-filter-tags="{{trans('admin.Settlement_Sechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_licensing">
                           {{trans('admin.Settlement_Sechdule')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('اعدادات طباعه الباركود')
                        <li>
                           <a href="{{url('BarcodeـPrinting_Settings')}}" title="{{trans('admin.BarcodeـPrinting_Settings')}}" data-filter-tags="{{trans('admin.BarcodeـPrinting_Settings')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_licensing">
                           {{trans('admin.BarcodeـPrinting_Settings')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('طباعه الباركود')
                        <li>
                           <a href="{{url('BarcodeـPrinting')}}" title="{{trans('admin.BarcodeـPrinting')}}" data-filter-tags="{{trans('admin.BarcodeـPrinting')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_licensing">
                           {{trans('admin.BarcodeـPrinting')}}
                           </span>
                           </a>
                        </li>
                        <li>
                           <a href="{{url('QRـPrinting')}}" title="{{trans('admin.QRـPrinting')}}" data-filter-tags="{{trans('admin.QRـPrinting')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_licensing">
                           {{trans('admin.QRـPrinting')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('شركات الشحن')
                        <li>
                           <a href="{{url('ShippingCompany')}}" title="{{trans('admin.Shipping_Compaines')}}" data-filter-tags="{{trans('admin.Shipping_Compaines')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_general_docs"> {{trans('admin.Shipping_Compaines')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('انواع الاشتراكات')
                        <li>
                           <a href="{{url('SubscribeTypes')}}" title="{{trans('admin.SubscribeTypes')}}" data-filter-tags="{{trans('admin.SubscribeTypes')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_community_support">
                           {{trans('admin.SubscribeTypes')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول مبيعات تحويلات المخازن')
                        <li>
                           <a href="{{url('Stores_Sales_Transfers_Sechdule')}}" title="{{trans('admin.Stores_Sales_Transfers_Sechdule')}}" data-filter-tags="{{trans('admin.Stores_Sales_Transfers_Sechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_licensing">
                           {{trans('admin.Stores_Sales_Transfers_Sechdule')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول مرتجع مبيعات تحويلات المخازن')
                        <li>
                           <a href="{{url('ReturnStoresTransfersSechdule')}}" title="{{trans('admin.ReturnStoresTransfersSechdule')}}" data-filter-tags="{{trans('admin.ReturnStoresTransfersSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.documentation_licensing">
                           {{trans('admin.ReturnStoresTransfersSechdule')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                     </div>
                  </div>
               </ul>
            </li>
            @endcan
            @can('المشتريات')
            <li>
               <a href="#" title="{{trans('admin.Purchases_P')}}" data-filter-tags="{{trans('admin.Purchases_P')}}">
               <i class="fal fa-window"></i>
               <span class="nav-link-text" data-i18n="nav.ui_components">{{trans('admin.Purchases_P')}}</span>
               <input type="hidden" id="inpu3" value="1">
               </a>
               <ul style="width:600px" id="menu3">
                  <div class="row">
                     <div class="col-sm-6">
                        @can('اضافه امر شراء')
                        <li>
                           <a href="{{url('PurchasesOrder')}}" title="{{trans('admin.PurchasesOrder')}}" data-filter-tags="{{trans('admin.PurchasesOrder')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_alerts">{{trans('admin.PurchasesOrder')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول آوامر الشراء')
                        <li>
                           <a href="{{url('PurchasesOrderSechdule')}}" title="{{trans('admin.PurchasesOrderSechdule')}}" data-filter-tags="{{trans('admin.PurchasesOrderSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_breadcrumbs">{{trans('admin.PurchasesOrderSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('الفواتير المعلقه مشتريات')
                        <li>
                           <a href="{{url('PurchasesHold')}}" title="{{trans('admin.PurchasesHold')}}" data-filter-tags="{{trans('admin.PurchasesHold')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.PurchasesHold')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('المنتجات المستلمه مشتريات')
                        <li>
                           <a href="{{url('Recived_Products')}}" title="{{trans('admin.Recived_Products')}}" data-filter-tags="{{trans('admin.Recived_Products')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.Recived_Products')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('النواقص')
                        <li>
                           <a href="{{url('Shortcomings')}}" title="{{trans('admin.Shortcomings')}}" data-filter-tags="{{trans('admin.Shortcomings')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.Shortcomings')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول النواقص')
                        <li>
                           <a href="{{url('ShortcomingsSechdule')}}" title="{{trans('admin.ShortcomingsSechdule')}}" data-filter-tags="{{trans('admin.ShortcomingsSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.ShortcomingsSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                     </div>
                     <div class="col-sm-6">
                        @can('الموردين')
                        <li>
                           <a href="{{url('Vendors')}}" title="{{trans('admin.Vendors')}}" data-filter-tags="{{trans('admin.Vendors')}}">
                           <span class="nav-link-text" data-i18n="nav.tables_generate_table_style"> {{trans('admin.Vendors')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه مشتريات')
                        <li>
                           <a href="{{url('Purchases')}}" title="{{trans('admin.Purchases')}}" data-filter-tags="{{trans('admin.Purchases')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_accordions">{{trans('admin.Purchases')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول المشتريات')
                        <li>
                           <a href="{{url('PurchasesSechdule')}}" title="{{trans('admin.PurchasesSechdule')}}" data-filter-tags="{{trans('admin.PurchasesSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.PurchasesSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول مرتجع المشتريات')
                        <li>
                           <a href="{{url('ReturnPurchasesSechdule')}}" title="{{trans('admin.ReturnPurchasesSechdule')}}" data-filter-tags="{{trans('admin.ReturnPurchasesSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_badges">
                           {{trans('admin.ReturnPurchasesSechdule')}}
                           </span>
                           </a>
                        </li>
                        @endcan        
                         @can('انواع مصاريف الاستيراد')
                        <li>
                           <a href="{{url('ImportExpensesTypes')}}" title="{{trans('admin.ImportExpensesTypes')}}" data-filter-tags="{{trans('admin.ImportExpensesTypes')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_badges">
                           {{trans('admin.ImportExpensesTypes')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                     </div>
                  </div>
               </ul>
            </li>
            @endcan
            @can('المبيعات')
            <li>
               <a href="#" title="{{trans('admin.Sales')}}" data-filter-tags="{{trans('admin.Sales')}}">
               <i class="fal fa-bolt"></i>
               <span class="nav-link-text" data-i18n="nav.utilities">{{trans('admin.Sales')}} </span>
               <input type="hidden" id="inpu4" value="1">
               </a>
               <ul style="width:600px" id="menu4">
                  <div class="row">
                     <div class="col-sm-6">
                        @can('نقاط البيع')
                        @if(auth()->guard('admin')->user()->emp != 0)
                        <li>
                           <a href="{{url('POS')}}" title="{{trans('admin.POS')}}" data-filter-tags="{{trans('admin.POS')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_clearfix"> {{trans('admin.POS')}}</span>
                           </a>
                        </li>
                        @endif
                        @endcan
                        @can('اضافه مبيعات')
                        <li>
                           <a href="{{url('Sales')}}" title="{{trans('admin.Sales')}}" data-filter-tags="{{trans('admin.Sales')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_clearfix"> {{trans('admin.Sales')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول المبيعات')
                        <li>
                           <a href="{{url('SalesSechdule')}}" title="{{trans('admin.SalesSechdule')}}" data-filter-tags="{{trans('admin.SalesSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_fonts"> {{trans('admin.SalesSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول المبيعات الضريبية')
                        <li>
                           <a href="{{url('SalesSechduleTax')}}" title="{{trans('admin.SalesSechduleTax')}}" data-filter-tags="{{trans('admin.SalesSechduleTax')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_fonts"> {{trans('admin.SalesSechduleTax')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه امر بيع')
                        <li>
                           <a href="{{url('SalesOrder')}}" title="{{trans('admin.SalesOrder')}}" data-filter-tags="{{trans('admin.SalesOrder')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.SalesOrder')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول امر البيع')
                        <li>
                           <a href="{{url('SalesOrderSechdule')}}" title="{{trans('admin.SalesOrderSechdule')}}" data-filter-tags="{{trans('admin.SalesOrderSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_flexbox">{{trans('admin.SalesOrderSechdule')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه عرض سعر')
                        <li>
                           <a href="{{url('Quote')}}" title="{{trans('admin.Quote')}}" data-filter-tags="{{trans('admin.Quote')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Quote')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('عرض سعر مصور')
                        <li>
                           <a href="{{url('QuoteImages')}}" title="{{trans('admin.QuoteImages')}}" data-filter-tags="{{trans('admin.QuoteImages')}}">
                           <span class="nav-link-text" data-i18n="nav.form_stuff_checkbox_&_radio">{{trans('admin.QuoteImages')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول عرض سعر')
                        <li>
                           <a href="{{url('Quote_Sechdule')}}" title="{{trans('admin.Quote_Sechdule')}}" data-filter-tags="{{trans('admin.Quote_Sechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_display_property"> {{trans('admin.Quote_Sechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول عرض سعر مصور')
                        <li>
                           <a href="{{url('QuoteImagesSechdule')}}" title="{{trans('admin.QuoteImagesSechdules')}}" data-filter-tags="{{trans('admin.QuoteImagesSechdules')}}">
                           <span class="nav-link-text" data-i18n="nav.form_stuff_checkbox_&_radio">{{trans('admin.QuoteImagesSechdules')}}</span>
                           </a>
                        </li>
                        <li>
                           <a href="{{url('QuoteImagesSechduleAccepted')}}" title="{{trans('admin.QuoteImagesSechduleAccepted')}}" data-filter-tags="{{trans('admin.QuoteImagesSechduleAccepted')}}">
                           <span class="nav-link-text" data-i18n="nav.form_stuff_checkbox_&_radio">{{trans('admin.QuoteImagesSechduleAccepted')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول مبيعات الدليفري')
                        <li>
                           <a href="{{url('SalesDeliverySechdule')}}" title="{{trans('admin.SalesDeliverySechdule')}}" data-filter-tags="{{trans('admin.SalesDeliverySechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_fonts"> {{trans('admin.SalesDeliverySechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @if(auth()->guard('admin')->user()->emp != 0)
                        <li>
                           <a href="{{url('MyRequestDelivery')}}" title="{{trans('admin.MyRequestDelivery')}}" data-filter-tags="{{trans('admin.MyRequestDelivery')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_fonts"> {{trans('admin.MyRequestDelivery')}}</span>
                           </a>
                        </li>
                        @endif
                        @can('جدول مرتجع المبيعات')
                        <li>
                           <a href="{{url('ReturnSalesSechdule')}}" title="{{trans('admin.Return_Sales_Sechdule')}}" data-filter-tags="{{trans('admin.Return_Sales_Sechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_flexbox"> {{trans('admin.Return_Sales_Sechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول مرتجع المبيعات الضريبية')
                        <li>
                           <a href="{{url('ReturnSalesSechduleTaxPage')}}" title="{trans('admin.Return_Sales_TaxSechdule')}}" data-filter-tags="{trans('admin.Return_Sales_TaxSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_flexbox"> {{trans('admin.Return_Sales_TaxSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('عينات')
                        <li>
                           <a href="{{url('Samples')}}" title="{{trans('admin.Samples')}}" data-filter-tags="{{trans('admin.Samples')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.Samples')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول العينات')
                        <li>
                           <a href="{{url('SamplesSechdule')}}" title="{{trans('admin.SamplesSechdule')}}" data-filter-tags="{{trans('admin.SamplesSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.SamplesSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('الهدايا')
                        <li>
                           <a href="{{url('SalesGifts')}}" title="{{trans('admin.SalesGifts')}}" data-filter-tags="{{trans('admin.SalesGifts')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.SalesGifts')}}</span>
                           </a>
                        </li>
                        @endcan
                     </div>
                     <div class="col-sm-6">
                        @can('العملاء')
                        <li>
                           <a href="{{url('Clients')}}" title="{{trans('admin.Clients')}}" data-filter-tags="{{trans('admin.Clients')}}">
                           <span class="nav-link-text" data-i18n="nav.form_stuff_checkbox_&_radio">{{trans('admin.Clients')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('مجموعه العملاء')
                        <li>
                           <a href="{{url('Clients_Group')}}" title="{{trans('admin.Clients_Group')}}" data-filter-tags="{{trans('admin.Clients_Group')}}">
                           <span class="nav-link-text" data-i18n="nav.form_stuff_checkbox_&_radio">{{trans('admin.Clients_Group')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه عملاء')
                        <li>
                           <a href="{{url('AddClients')}}" title="{{trans('admin.Add_Clients')}}" data-filter-tags="{{trans('admin.Add_Clients')}}">
                           <span class="nav-link-text" data-i18n="nav.form_stuff_checkbox_&_radio">{{trans('admin.Add_Clients')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('مبيعات اشتراكات')
                        <li>
                           <a href="{{url('SalesSubscribes')}}" title="{{trans('admin.SalesSubscribes')}}" data-filter-tags="{{trans('admin.SalesSubscribes')}}">
                           <span class="nav-link-text" data-i18n="nav.form_stuff_checkbox_&_radio">{{trans('admin.SalesSubscribes')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول مبيعات اشتراكات')
                        <li>
                           <a href="{{url('SalesSubscribesSechdule')}}" title="{{trans('admin.SalesSubscribesSechdule')}}" data-filter-tags="{{trans('admin.SalesSubscribesSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.form_stuff_checkbox_&_radio">{{trans('admin.SalesSubscribesSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('الفواتير المعلقه مبيعات')
                        <li>
                           <a href="{{url('SalesHoldSechdule')}}" title="{{trans('admin.SalesHoldSechdule')}}" data-filter-tags="{{trans('admin.SalesHoldSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_fonts"> {{trans('admin.SalesHoldSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('الفواتير المعلقة نقاط البيع')
                        @if(auth()->guard('admin')->user()->emp != 0)
                        <li>
                           <a href="{{url('SalesOrderHoldSechdule')}}" title="{{trans('admin.SalesOrderHoldSechdule')}}" data-filter-tags="{{trans('admin.SalesOrderHoldSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_fonts"> {{trans('admin.SalesOrderHoldSechdule')}}</span>
                           </a>
                        </li>
                        @endif
                        @endcan
                        @can('المنتجات المستلمه مبيعات')
                        <li>
                           <a href="{{url('RecivedProductsSales')}}" title="{{trans('admin.Recived_Products')}}" data-filter-tags="{{trans('admin.Recived_Products')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_fonts"> {{trans('admin.Recived_Products')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول الاقساط مبيعات')
                        <li>
                           <a href="{{url('InstallmentSechdule')}}" title="{{trans('admin.InstallmentSechdule')}}" data-filter-tags="{{trans('admin.InstallmentSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_clearfix"> {{trans('admin.InstallmentSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('شركات التقسيط')
                        <li>
                           <a href="{{url('InstallmentCompanies')}}" title="{{trans('admin.InstallmentCompanies')}}" data-filter-tags="{{trans('admin.InstallmentCompanies')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.InstallmentCompanies')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول مرتجع بدون فاتورة')
                        <li>
                           <a href="{{url('SechduleReturnWithoutBill')}}" title="{{trans('admin.SechduleReturnWithoutBill')}}" data-filter-tags="{{trans('admin.SechduleReturnWithoutBill')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.SechduleReturnWithoutBill')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('مرتجع بدون فاتوره')
                        <li>
                           <a href="{{url('ReturnWithoutBill')}}" title="{{trans('admin.ReturnWithoutBill')}}" data-filter-tags="{{trans('admin.ReturnWithoutBill')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.ReturnWithoutBill')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('اوامر الشغل')
                        <li>
                           <a href="{{url('JobOrder')}}" title="{{trans('admin.JobOrder')}}" data-filter-tags="{{trans('admin.JobOrder')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.JobOrder')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول اوامر الشغل')
                        <li>
                           <a href="{{url('JobOrderSechdule')}}" title="{{trans('admin.JobOrderSechdule')}}" data-filter-tags="{{trans('admin.JobOrderSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.JobOrderSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول تنفيذ اوامر الشغل')
                        <li>
                           <a href="{{url('ExecuteJobOrderSechdule')}}" title="{{trans('admin.ExecuteJobOrderSechdule')}}" data-filter-tags="{{trans('admin.ExecuteJobOrderSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.ExecuteJobOrderSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول الهدابا')
                        <li>
                           <a href="{{url('SalesGiftsSechdule')}}" title="{{trans('admin.SalesGiftsSechdule')}}" data-filter-tags="{{trans('admin.SalesGiftsSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.SalesGiftsSechdule')}}</span>
                           </a>
                        </li>
                        @endcan       
                         
                         @can('طلبات العملاء')
                        <li>
                           <a href="{{url('ClientRequests')}}" title="{{trans('admin.ClientRequests')}}" data-filter-tags="{{trans('admin.ClientRequests')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.ClientRequests')}}</span>
                           </a>
                        </li>
                        @endcan            
                         @can('جدول طلبات العملاء')
                        <li>
                 <a href="{{url('ClientRequestsSechdule')}}" title="{{trans('admin.ClientRequestsSechdule')}}" data-filter-tags="{{trans('admin.ClientRequestsSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.ClientRequestsSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                     </div>
                  </div>
               </ul>
            </li>
            @endcan
            @endif
            @if($Modules->Stores == 1)
            @can('التقارير')
            <li>
               <a href="#" title="{{trans('admin.SupplyChainReports')}}" data-filter-tags="{{trans('admin.SupplyChainReports')}}">
               <i class="fal fa-edit"></i>
               <span class="nav-link-text" data-i18n="nav.form_stuff">{{trans('admin.SupplyChainReports')}}</span>
               <input type="hidden" id="inpu5" value="1">
               </a>
               <ul style="width: 600px;" id="menu5">
                  <div class="row">
                     <div class="col-sm-6">
                        @if($ReportsSettings->Product_Info == 1)
                        @can('استعلام عن منتج')
                        <li>
                           <a href="{{url('Product_Info')}}" title="{{trans('admin.Product_Info')}}" data-filter-tags="{{trans('admin.Product_Info')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders">
                           <i class="fal fa-box-open"></i>  &nbsp; {{trans('admin.Product_Info')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @endif
                     </div>
                     <div class="col-sm-6">
                        <li>
                           <a href="{{url('ItemBalances')}}" title="{{trans('admin.ItemBalances')}}" data-filter-tags="{{trans('admin.ItemBalances')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders">
                           <i class="fal fa-balance-scale"></i> &nbsp;{{trans('admin.ItemBalances')}}
                           </span>
                           </a>
                        </li>
                     </div>
                     <div class="col-sm-6">
                        <li>
                           <a href="{{url('ItemsCostsReportGroup')}}" title="{{trans('admin.ItemsCostsReportGroup')}}" data-filter-tags="{{trans('admin.ItemsCostsReportGroup')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders">
                           <i class="fal fa-dollar-sign"></i> &nbsp;{{trans('admin.ItemsCostsReportGroup')}}
                           </span>
                           </a>
                        </li>
                     </div>
                     <div class="col-sm-6">
                        <li>
                           <a href="{{url('ItemsMovesReportGroup')}}" title="{{trans('admin.ItemsMovesReportGroup')}}" data-filter-tags="{{trans('admin.ItemsMovesReportGroup')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders">
                           <i class="fal fa-exchange-alt"></i> &nbsp;{{trans('admin.ItemsMovesReportGroup')}}
                           </span>
                           </a>
                        </li>
                     </div>
                     <div class="col-sm-6">
                        <li>
                           <a href="{{url('ProfitsReportGroup')}}" title="{{trans('admin.ProfitsReportGroup')}}" data-filter-tags="{{trans('admin.ProfitsReportGroup')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders">
                           <i class="fal fa-chart-line"></i> &nbsp;{{trans('admin.ProfitsReportGroup')}}
                           </span>
                           </a>
                        </li>
                     </div>
                     <div class="col-sm-6">
                        <li>
                           <a href="{{url('SalesReportGroup')}}" title="{{trans('admin.SalesReportGroup')}}" data-filter-tags="{{trans('admin.SalesReportGroup')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders">
                           <i class="fal fa-shopping-cart"></i>&nbsp; {{trans('admin.SalesReportGroup')}}
                           </span>
                           </a>
                        </li>
                     </div>
                     <div class="col-sm-6">
                        <li>
                           <a href="{{url('PurchasesReportGroup')}}" title="{{trans('admin.PurchasesReportGroup')}}" data-filter-tags="{{trans('admin.PurchasesReportGroup')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders">
                           <i class="fal fa-receipt"></i> &nbsp;{{trans('admin.PurchasesReportGroup')}}
                           </span>
                           </a>
                        </li>
                     </div>
                     <div class="col-sm-6">
                        <li>
                           <a href="{{url('ShiftsReportGroup')}}" title="{{trans('admin.ShiftsReportGroup')}}" data-filter-tags="{{trans('admin.ShiftsReportGroup')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders">
                           <i class="fal fa-user-clock"></i>&nbsp; {{trans('admin.ShiftsReportGroup')}}
                           </span>
                           </a>
                        </li>
                     </div>
                     <div class="col-sm-6">
                        <li>
                           <a href="{{url('StoresReportGroup')}}" title="{{trans('admin.StoresReportGroup')}}" data-filter-tags="{{trans('admin.StoresReportGroup')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders">
                           <i class="fal fa-store-alt"></i>&nbsp; {{trans('admin.StoresReportGroup')}}
                           </span>
                           </a>
                        </li>
                     </div>
                     <div class="col-sm-6">
                        <li>
                           <a href="{{url('DelegatesReportGroup')}}" title="{{trans('admin.DelegatesReportGroup')}}" data-filter-tags="{{trans('admin.DelegatesReportGroup')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders">
                           <i class="fal fa-user-tie"></i>&nbsp; {{trans('admin.DelegatesReportGroup')}}
                           </span>
                           </a>
                        </li>
                     </div>
                     <div class="col-sm-6">
                        <li>
                           <a href="{{url('ReviewReportGroup')}}" title="{{trans('admin.ReviewReportGroup')}}" data-filter-tags="{{trans('admin.ReviewReportGroup')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders">
                           <i class="fal fa-clipboard-check"></i> &nbsp;{{trans('admin.ReviewReportGroup')}}
                           </span>
                           </a>
                        </li>
                     </div>
                  </div>
               </ul>
            </li>
            @endcan
            @endif
            @if($Modules->HR == 1)
            @can('HR')
            <li>
               <a href="#" title="{{trans('admin.HR')}}" data-filter-tags="{{trans('admin.HR')}}">
               <i class="fal fa-people-arrows"></i>
               <span class="nav-link-text" data-i18n="nav.plugins">{{trans('admin.HR')}}</span>
               <input type="hidden" id="inpu9" value="1">
               </a>
               <ul style="width:600px" id="menu9">
                  <div class="row">
                     <div class="col-sm-6">
                        @can('اقسام العمل')
                        <li>
                           <a href="{{url('WorkDepartments')}}" title=" {{trans('admin.Work_Departments')}}" data-filter-tags="{{trans('admin.Work_Departments')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_plugins_faq">
                           {{trans('admin.Work_Departments')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('مستويات التوظيف')
                        <li>
                           <a href="{{url('Employment_levels')}}" title=" {{trans('admin.Employment_levels')}}" data-filter-tags="{{trans('admin.Employment_levels')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_plugins_faq">
                           {{trans('admin.Employment_levels')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('شركات التأمين')
                        <li>
                           <a href="{{url('Insurance_companies')}}" title=" {{trans('admin.Insurance_companies')}}" data-filter-tags="{{trans('admin.Insurance_companies')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_plugins_faq">
                           {{trans('admin.Insurance_companies')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('انواع الوظائف')
                        <li>
                           <a href="{{url('Jobs_Type')}}" title="{{trans('admin.Jobs_Type')}}" data-filter-tags="{{trans('admin.Jobs_Type')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_waves"> {{trans('admin.Jobs_Type')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه موظف')
                        <li>
                           <a href="{{url('AddEmp')}}" title="{{trans('admin.Add_Emp')}}" data-filter-tags="{{trans('admin.Add_Emp')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_pacejs"> {{trans('admin.Add_Emp')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('نقاط الانتاج')
                        <li>
                           <a href="{{url('ProducationPoints')}}" title="{{trans('admin.ProducationPoints')}}" data-filter-tags="{{trans('admin.ProducationPoints')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_pacejs"> {{trans('admin.ProducationPoints')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول الموظفين')
                        <li>
                           <a href="{{url('EmpSechdule')}}" title="{{trans('admin.Emp_Sechdule')}}" data-filter-tags="{{trans('admin.Emp_Sechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_smartpanels">
                           {{trans('admin.Emp_Sechdule')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول طلبات توظيف')
                        <li>
                           <a href="{{url('JobRequestsSechdule')}}" title="{{trans('admin.JobRequestsSechdule')}}" data-filter-tags="{{trans('admin.JobRequestsSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_smartpanels">
                           {{trans('admin.JobRequestsSechdule')}}
                           </span>
                           </a>
                        </li>
                        @endcan
                        @can('انواع الاجازات')
                        <li>
                           <a href="{{url('Holidays_Types')}}" title="{{trans('admin.Holidays_Types')}}" data-filter-tags="{{trans('admin.Holidays_Types')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_bootbox">{{trans('admin.Holidays_Types')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('انواع الاستحقاقات')
                        <li>
                           <a href="{{url('Benefits_Types')}}" title="{{trans('admin.Benefits_Types')}}" data-filter-tags="{{trans('admin.Benefits_Types')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_slimscroll">{{trans('admin.Benefits_Types')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('انواع الاستقطاعات')
                        <li>
                           <a href="{{url('Deductions_Types')}}" title="{{trans('admin.Deductions_Types')}}" data-filter-tags="{{trans('admin.Deductions_Types')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_throttle"> {{trans('admin.Deductions_Types')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('الساعات الاضافيه')
                        <li>
                           <a href="{{url('Overtime')}}" title="{{trans('admin.Overtime')}}" data-filter-tags="{{trans('admin.Overtime')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_navigation">{{trans('admin.Overtime')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('انواع القروض')
                        <li>
                           <a href="{{url('Loan_Types')}}" title="{{trans('admin.Loan_Types')}}" data-filter-tags="{{trans('admin.Loan_Types')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_navigation">{{trans('admin.Loan_Types')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه سلفه')
                        <li>
                           <a href="{{url('AddBorrow')}}" title="{{trans('admin.AddBorrow')}}" data-filter-tags="{{trans('admin.AddBorrow')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_navigation">{{trans('admin.AddBorrow')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('السلف')
                        <li>
                           <a href="{{url('Borrow')}}" title="{{trans('admin.Borrow')}}" data-filter-tags="{{trans('admin.Borrow')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_navigation">{{trans('admin.Borrow')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('طلب اجازه')
                        <li>
                           <a href="{{url('HolidaysOrder')}}" title="{{trans('admin.HolidaysOrder')}}" data-filter-tags="{{trans('admin.HolidaysOrder')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_i18next">{{trans('admin.HolidaysOrder')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('الاجازات')
                        <li>
                           <a href="{{url('Holidays')}}" title="{{trans('admin.Holidays')}}" data-filter-tags="{{trans('admin.Holidays')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_i18next">{{trans('admin.Holidays')}} </span>
                           </a>
                        </li>
                        @endcan
                     </div>
                     <div class="col-sm-6">
                        @can('الاستحقاقات')
                        <li>
                           <a href="{{url('Entitlements')}}" title="{{trans('admin.Entitlements')}}" data-filter-tags="{{trans('admin.Entitlements')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_navigation">{{trans('admin.Entitlements')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('الاستقطاعات')
                        <li>
                           <a href="{{url('Deducation')}}" title="{{trans('admin.Deducation')}}" data-filter-tags="{{trans('admin.Deducation')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_navigation">{{trans('admin.Deducation')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can(' الحضور')
                        <li>
                           <a href="{{url('Attendance')}}" title="{{trans('admin.Attendance')}}" data-filter-tags="{{trans('admin.Attendance')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_i18next"> {{trans('admin.Attendance')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول الحضور')
                        <li>
                           <a href="{{url('AttendanceSechdule')}}" title="{{trans('admin.AttendanceSechdule')}}" data-filter-tags="{{trans('admin.AttendanceSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_i18next"> {{trans('admin.AttendanceSechdule')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول الانصراف')
                        <li>
                           <a href="{{url('DepartureSechdule')}}" title="{{trans('admin.DepartureSechdule')}}" data-filter-tags="{{trans('admin.DepartureSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_i18next"> {{trans('admin.DepartureSechdule')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('تسجيل الساعات الاضافيه')
                        <li>
                           <a href="{{url('RegOverTime')}}" title="{{trans('admin.Reg_OverTime')}}" data-filter-tags="{{trans('admin.Reg_OverTime')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_i18next"> {{trans('admin.Reg_OverTime')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('اضافه قرض')
                        <li>
                           <a href="{{url('AddLoan')}}" title="{{trans('admin.AddLoan')}}" data-filter-tags="{{trans('admin.AddLoan')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_i18next"> {{trans('admin.AddLoan')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('القروض')
                        <li>
                           <a href="{{url('Loan')}}" title="{{trans('admin.Loan')}} " data-filter-tags="{{trans('admin.Loan')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_i18next"> {{trans('admin.Loan')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('اقساط الموظفين')
                        <li>
                           <a href="{{url('EmpInstallment')}}" title="{{trans('admin.EmpInstallment')}}" data-filter-tags="{{trans('admin.EmpInstallment')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_i18next"> {{trans('admin.EmpInstallment')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('صرف راتب')
                        <li>
                           <a href="{{url('AddSalary')}}" title="{{trans('admin.AddSalary')}}" data-filter-tags="{{trans('admin.AddSalary')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_app.core"> {{trans('admin.AddSalary')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول الرواتب')
                        <li>
                           <a href="{{url('SalarySechdules')}}" title="{{trans('admin.SalarySechdules')}}" data-filter-tags="{{trans('admin.SalarySechdules')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_app.core"> {{trans('admin.SalarySechdules')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('صرف عمولات')
                        <li>
                           <a href="{{url('ExchangeCommissions')}}" title="{{trans('admin.ExchangeCommissions')}}" data-filter-tags="{{trans('admin.ExchangeCommissions')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_app.core"> {{trans('admin.ExchangeCommissions')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جدول صرف العمولات')
                        <li>
                           <a href="{{url('ExchangeCommissionsSechdule')}}" title="{{trans('admin.ExchangeCommissionsSechdule')}}" data-filter-tags="{{trans('admin.ExchangeCommissionsSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_app.core"> {{trans('admin.ExchangeCommissionsSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @if(auth()->guard('admin')->user()->emp != 0)
                        @can('اهدافي')
                        <li>
                           <a href="{{url('MyGoals')}}" title="{{trans('admin.MyGoals')}}" data-filter-tags="{{trans('admin.MyGoals')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_app.core"> {{trans('admin.MyGoals')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('طلب استقاله')
                        <li>
                           <a href="{{url('ResignationRequest')}}" title="{{trans('admin.ResignationRequest')}}" data-filter-tags="{{trans('admin.ResignationRequest')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_app.core"> {{trans('admin.ResignationRequest')}}</span>
                           </a>
                        </li>
                        @endcan
                        @endif
                        @can('طلبات استقاله')
                        <li>
                           <a href="{{url('ResignationRequestSechdule')}}" title="{{trans('admin.ResignationRequestSechdule')}}" data-filter-tags="{{trans('admin.ResignationRequestSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_app.core"> {{trans('admin.ResignationRequestSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('اخلاء طرف')
                        <li>
                           <a href="{{url('Disclaimer')}}" title="{{trans('admin.Disclaimer')}}" data-filter-tags="{{trans('admin.Disclaimer')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_app.core"> {{trans('admin.Disclaimer')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('عهد الموظفين')
                        <li>
                           <a href="{{url('EmpCovenant')}}" title="{{trans('admin.EmpCovenant')}}" data-filter-tags="{{trans('admin.EmpCovenant')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_app.core"> {{trans('admin.EmpCovenant')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('جهاز البصمة')
                        <li>
                           <a href="{{url('Fingerprint')}}" title="{{trans('admin.Fingerprint')}}" data-filter-tags="{{trans('admin.Fingerprint')}}">
                           <span class="nav-link-text" data-i18n="nav.plugins_app.core"> {{trans('admin.Fingerprint')}}</span>
                           </a>
                        </li>
                        @endcan
                     </div>
                  </div>
               </ul>
            </li>
            @endcan
            @can('تقارير الموارد البشريه')
            <li>
               <a href="#" title="{{trans('admin.HR_Reports')}}" data-filter-tags="{{trans('admin.HR_Reports')}}">
               <i class="fal fa-home"></i>
               <span class="nav-link-text" data-i18n="nav.form_stuff">{{trans('admin.HR_Reports')}}</span>
               <input type="hidden" id="inpu10" value="1">
               </a>
               <ul style="width:600px" id="menu10">
                  @can('تقرير الحضور و الانصراف')
                  <li>
                     <a href="{{url('AttendenceAndDepartureReport')}}" title="{{trans('admin.AttendenceAndDepartureReport')}}" data-filter-tags="{{trans('admin.AttendenceAndDepartureReport')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.AttendenceAndDepartureReport')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('تقرير قيمة الحضور')
                  <li>
                     <a href="{{url('AttendenceValueReport')}}" title="{{trans('admin.AttendenceValueReport')}}" data-filter-tags="{{trans('admin.AttendenceValueReport')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.AttendenceValueReport')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('تقرير صرف الرواتب')
                  <li>
                     <a href="{{url('PaySalaryReport')}}" title="{{trans('admin.PaySalaryReport')}}" data-filter-tags="{{trans('admin.PaySalaryReport')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.PaySalaryReport')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('تقرير الرواتب المسدده')
                  <li>
                     <a href="{{url('SalaryPayed')}}" title="{{trans('admin.SalaryPayed')}}" data-filter-tags="{{trans('admin.SalaryPayed')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.SalaryPayed')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('تقرير رواتب الموظفين')
                  <li>
                     <a href="{{url('EmpSalaries')}}" title="{{trans('admin.EmpSalaries')}}" data-filter-tags="{{trans('admin.EmpSalaries')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.EmpSalaries')}}</span>
                     </a>
                  </li>
                  @endcan
                  @if($ReportsSettings->EmployeeCommissionDiscounts == 1)
                  @can('عمولات و خصومات الموظفين')
                  <li>
                     <a href="{{url('EmployeeCommissionDiscounts')}}" title="{{trans('admin.EmployeeCommissionDiscounts')}}" data-filter-tags="{{trans('admin.EmployeeCommissionDiscounts')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.EmployeeCommissionDiscounts')}}</span>
                     </a>
                  </li>
                  @endcan
                  @endif
                  @if($ReportsSettings->EmpGoals == 1)
                  @can('تقرير اهداف الموظفين')
                  <li>
                     <a href="{{url('EmpGoals')}}" title="{{trans('admin.EmpGoals')}}" data-filter-tags="{{trans('admin.EmpGoals')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.EmpGoals')}}</span>
                     </a>
                  </li>
                  @endcan
                  @endif
               </ul>
            </li>
            @endcan
            @endif
            @if($Modules->CRM == 1)
            @can('اداره علاقه العملاء')
            <li>
               <a href="#" title="{{trans('admin.CRM')}}" data-filter-tags="{{trans('admin.CRM')}}">
               <i class="fal fa-people-carry"></i>
               <span class="nav-link-text" data-i18n="nav.form_stuff">{{trans('admin.CRM')}}</span>
               <input type="hidden" id="inpu6" value="1">
               </a>
               <ul style="width:600px" id="menu6">
                  <div class="row">
                     <div class="col-sm-6">
                        @can('الدول')
                        <li>
                           <a href="{{url('Countris')}}" title="{{trans('admin.Countris')}}" data-filter-tags="{{trans('admin.Countris')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Countris')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('المحافظه')
                        <li>
                           <a href="{{url('Governrate')}}" title="{{trans('admin.Governrate')}}" data-filter-tags="{{trans('admin.Governrate')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Governrate')}}</span>
                           </a>
                        </li>
                        @endcan
                 
                         @can('النشاطات')
                        <li>
                           <a href="{{url('Activites')}}" title="{{trans('admin.Activites')}}" data-filter-tags="{{trans('admin.Activites')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Activites')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('حالات العملاء')
                        <li>
                           <a href="{{url('Clients_Status')}}" title="{{trans('admin.Clients_Status')}}" data-filter-tags="{{trans('admin.Clients_Status')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Clients_Status')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('انواع تقيمات العملاء')
                        <li>
                           <a href="{{url('CustomersRateTypes')}}" title="{{trans('admin.CustomersRateTypes')}}" data-filter-tags="{{trans('admin.CustomersRateTypes')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.CustomersRateTypes')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('المنصات')
                        <li>
                           <a href="{{url('Platforms')}}" title="{{trans('admin.Platforms')}}" data-filter-tags="{{trans('admin.Platforms')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Platforms')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('انواع المقابلات')
                        <li>
                           <a href="{{url('Interviews_Types')}}" title="{{trans('admin.Interviews_Types')}}" data-filter-tags="{{trans('admin.Interviews_Types')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Interviews_Types')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('المقابلات')
                        <li>
                           <a href="{{url('Interviews')}}" title="{{trans('admin.Interviews')}}" data-filter-tags="{{trans('admin.Interviews')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Interviews')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('المشاريع')
                        <li>
                           <a href="{{url('Projects')}}" title="{{trans('admin.Projects')}}" data-filter-tags="{{trans('admin.Projects')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Projects')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('المهام')
                        <li>
                           <a href="{{url('Missions')}}" title="{{trans('admin.Missions')}}" data-filter-tags="{{trans('admin.Missions')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Missions')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('المنافسين')
                        <li>
                           <a href="{{url('Competitors')}}" title="{{trans('admin.Competitors')}}" data-filter-tags="{{trans('admin.Competitors')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Competitors')}}</span>
                           </a>
                        </li>
                        @endcan
                     </div>
                     <div class="col-sm-6">
                        @can('خط السير')
                        <li>
                           <a href="{{url('Itinerary')}}" title="{{trans('admin.Itinerary')}}" data-filter-tags="{{trans('admin.Itinerary')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Itinerary')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('قائمة المتابعات')
                        <li>
                           <a href="{{url('FollowList')}}" title="{{trans('admin.FollowList')}}" data-filter-tags="{{trans('admin.FollowList')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.FollowList')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('متابعه العملاء')
                        <li>
                           <a href="{{url('Customerـfollowـup_Reports')}}" title="{{trans('admin.Customerـfollowـup_Reports')}}" data-filter-tags="{{trans('admin.Customerـfollowـup_Reports')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Customerـfollowـup_Reports')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('تقرير قياس العملاء')
                        <li>
                           <a href="{{url('CustomerPeriodReports')}}" title="{{trans('admin.CustomerPeriodReports')}}" data-filter-tags="{{trans('admin.CustomerPeriodReports')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.CustomerPeriodReports')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('تقرير التعليقات')
                        <li>
                           <a href="{{url('CommentsReports')}}" title="{{trans('admin.CommentsReports')}}" data-filter-tags="{{trans('admin.CommentsReports')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.CommentsReports')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('تقرير زيارات المندوب')
                        <li>
                           <a href="{{url('DelegateVistsReport')}}" title="{{trans('admin.DelegateVistsReport')}}" data-filter-tags="{{trans('admin.DelegateVistsReport')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.DelegateVistsReport')}}</span>
                           </a>
                        </li>
                        @endcan
                                        @can('مشاكل التذاكر')
                        <li>
                           <a href="{{url('TicektIssues')}}" title="{{trans('admin.TicektIssues')}}" data-filter-tags="{{trans('admin.TicektIssues')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.TicektIssues')}}</span>
                           </a>
                        </li>
                        @endcan    
                         
                         
                       @can('تحليل الصفقات')
                        <li>
                           <a href="{{url('DealsAnalysis')}}" title="{{trans('admin.DealsAnalysis')}}" data-filter-tags="{{trans('admin.DealsAnalysis')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.DealsAnalysis')}}</span>
                           </a>
                        </li>
                        @endcan    
                         
                                    
                         
                         @can('تقرير التذاكر')
                        <li>
                           <a href="{{url('TicketReport')}}" title="{{trans('admin.TicketReport')}}" data-filter-tags="{{trans('admin.TicketReport')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.TicketReport')}}</span>
                           </a>
                        </li>
                        @endcan    
                                       
                         
                         @can('تقرير تعليقات العملاء')
                        <li>
                           <a href="{{url('CommentCustomersReport')}}" title="{{trans('admin.CommentCustomersReport')}}" data-filter-tags="{{trans('admin.CommentCustomersReport')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.CommentCustomersReport')}}</span>
                           </a>
                        </li>
                        @endcan    
                         
 
                        @can('مهامي')
                        @if(auth()->guard('admin')->user()->emp != 0)
                        <li>
                           <a href="{{url('MyMissions')}}" title="{{trans('admin.MyMissions')}}" data-filter-tags="{{trans('admin.MyMissions')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.MyMissions')}}</span>
                           </a>
                        </li>
                        @endif
                        @endcan
                        @can('اضافة تعليق عميل')
                        @if(auth()->guard('admin')->user()->emp != 0)
                        <li>
                           <a href="{{url('AddCommentCustomer')}}" title="{{trans('admin.AddCommentCustomer')}}" data-filter-tags="{{trans('admin.AddCommentCustomer')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.AddCommentCustomer')}}</span>
                           </a>
                        </li>
                        @endif
                        @endcan
                        @can('مقابلاتي')
                        @if(auth()->guard('admin')->user()->emp != 0)
                        <li>
                           <a href="{{url('MyMettings')}}" title="{{trans('admin.MyMettings')}}" data-filter-tags="{{trans('admin.MyMettings')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.MyMettings')}}</span>
                           </a>
                        </li>
                        <li>
                           <a href="{{url('PerivousMettings')}}" title="{{trans('admin.PerivousMettings')}}" data-filter-tags="{{trans('admin.PerivousMettings')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.PerivousMettings')}}</span>
                           </a>
                        </li>
                        @endif
                        @endcan
                        @can('خط سيري')
                        @if(auth()->guard('admin')->user()->emp != 0)
                        <li>
                           <a href="{{url('MyItinerary')}}" title="{{trans('admin.MyItinerary')}}" data-filter-tags="{{trans('admin.MyItinerary')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.MyItinerary')}}</span>
                           </a>
                        </li>
                        @endif
                        @endcan
                        @can('متابعاتي')
                        @if(auth()->guard('admin')->user()->emp != 0)
                        <li>
                           <a href="{{url('MyFollowList')}}" title="{{trans('admin.MyFollowList')}}" data-filter-tags="{{trans('admin.MyFollowList')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.MyFollowList')}}</span>
                           </a>
                        </li>
                        @endif
                        @endcan
                     </div>
                  </div>
               </ul>
            </li>
            @endcan
            @endif
            @if($Modules->Bill_Electronic == 1)
            @can('الفاتوره الالكترونيه')
            <li>
               <a href="#" title="{{trans('admin.Bill_Electronic')}}" data-filter-tags="{{trans('admin.Bill_Electronic')}}">
               <i class="fal fa-scroll"></i>
               <span class="nav-link-text" data-i18n="nav.form_stuff">{{trans('admin.Bill_Electronic')}}</span>
               <input type="hidden" id="inpu7" value="1">
               </a>
               <ul style="width:600px" id="menu7">
                  @can('ارسال فواتير مبيعات')
                  <li>
                     <a href="{{url('Send_Bill_Sales')}}" title="{{trans('admin.Send_Bill_Sales')}}" data-filter-tags="{{trans('admin.Send_Bill_Sales')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Send_Bill_Sales')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('ارسال فواتير مرتجعات مبيعات')
                  <li>
                     <a href="{{url('Send_Bill_ReturnSales')}}" title="{{trans('admin.Send_Bill_ReturnSales')}}" data-filter-tags="{{trans('admin.Send_Bill_ReturnSales')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Send_Bill_ReturnSales')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('فواتير مرتجعات مرسله')
                  <!-- <li>
                     <a href="{{url('Bill_Purchases_Sent')}}" title="{{trans('admin.Bill_Purchases_Sent')}}" data-filter-tags="utilities borders">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Bill_Purchases_Sent')}}</span>
                     </a>
                     </li> -->
                  <li>
                     <a href="{{url('Bill_ReturnSales_Sent')}}" title="{{trans('admin.Bill_ReturnSales_Sent')}}" data-filter-tags="{{trans('admin.Bill_ReturnSales_Sent')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Bill_ReturnSales_Sent')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('فواتير مبيعات مرسله')
                  <li>
                     <a href="{{url('Bill_Sales_Sent')}}" title="{{trans('admin.Bill_Sales_Sent')}}" data-filter-tags="{{trans('admin.Bill_Sales_Sent')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Bill_Sales_Sent')}}</span>
                     </a>
                  </li>
                  <li>
                     <a href="{{url('Bill_Sales_Sent_Web')}}" title="{{trans('admin.Bill_Sales_Sent_Web')}}" data-filter-tags="{{trans('admin.Bill_Sales_Sent_Web')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Bill_Sales_Sent_Web')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('ارسال ايصال الكتروني')
                  <li>
                     <a href="{{url('Send_Recipt_Sales')}}" title="{{trans('admin.Send_Recipt_Sales')}}" data-filter-tags="{{trans('admin.Send_Recipt_Sales')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Send_Recipt_Sales')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('ارسال مرتجع ايصال الكتروني')
                  <li>
                     <a href="{{url('ReturnSend_Recipt_Sales')}}" title="{{trans('admin.ReturnSend_Recipt_Sales')}}" data-filter-tags="{{trans('admin.ReturnSend_Recipt_Sales')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ReturnSend_Recipt_Sales')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('ايصالات مرسله')
                  <li>
                     <a href="{{url('Recipt_Sales_Sent')}}" title="{{trans('admin.Recipt_Sales_Sent')}}" data-filter-tags="{{trans('admin.Recipt_Sales_Sent')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Recipt_Sales_Sent')}}</span>
                     </a>
                  </li>
                  @endcan
               </ul>
            </li>
            @endcan
            @endif
            @if($Modules->Resturant == 1)
            @can('المطاعم')
            <li>
               <a href="#" title="{{trans('admin.Resturant')}}" data-filter-tags="{{trans('admin.Resturant')}}">
              <i class="fal fa-hamburger"></i>
               <span class="nav-link-text" data-i18n="nav.form_stuff">{{trans('admin.Resturant')}}</span>
               <input type="hidden" id="inpu22" value="1">
               </a>
               <ul style="width:600px" id="menu22">
                  <div class="row">
                     <div class="col-sm-6">
                        @can('مبيعات المطعم')
                        @if(auth()->guard('admin')->user()->emp != 0)
                        <li>
                           <a href="{{url('ResturantSales')}}" title="{{trans('admin.ResturantSales')}}" data-filter-tags="{{trans('admin.ResturantSales')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ResturantSales')}}</span>
                           </a>
                        </li>
                        @endif
                        @endcan
                        @can('جدول مبيعات المطاعم')
                        <li>
                           <a href="{{url('ResturantSalesSechdule')}}" title="{{trans('admin.ResturantSalesSechdule')}}" data-filter-tags="{{trans('admin.ResturantSalesSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ResturantSalesSechdule')}}</span>
                           </a>
                        </li>
                        @endcan  
                        @can('جدول مبيعات المطاعم المعلقة')
                        <li>
                           <a href="{{url('ResturantSalesHoldSechdule')}}" title="{{trans('admin.ResturantSalesHoldSechdule')}}" data-filter-tags="{{trans('admin.ResturantSalesHoldSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ResturantSalesHoldSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('الطاولات')
                        <li>
                           <a href="{{url('Tables')}}" title="{{trans('admin.Tables')}}" data-filter-tags="{{trans('admin.Tables')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Tables')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('تطبيقات التوصيل')
                        <li>
                           <a href="{{url('DeliveryApps')}}" title="{{trans('admin.DeliveryApps')}}" data-filter-tags="{{trans('admin.DeliveryApps')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.DeliveryApps')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('تغير اسعار تطبيقات التوصيل')
                        <li>
                           <a href="{{url('DeliveryChangePrices')}}" title="{{trans('admin.DeliveryChangePrices')}}" data-filter-tags="{{trans('admin.DeliveryChangePrices')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.DeliveryChangePrices')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('شاشة المطبخ')
                        <li>
                           <a href="{{url('KitchenScreen')}}" title="{{trans('admin.KitchenScreen')}}" data-filter-tags="{{trans('admin.KitchenScreen')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.KitchenScreen')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('شاشة التسليمات')
                        <li>
                           <a href="{{url('RecivedScreen')}}" title="{{trans('admin.RecivedScreen')}}" data-filter-tags="{{trans('admin.RecivedScreen')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.RecivedScreen')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('حجوزات المطاعم')
                        <li>
                           <a href="{{url('RReservations')}}" title="{{trans('admin.Reservations')}}" data-filter-tags="{{trans('admin.Reservations')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Reservations')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('طلبات المطعم')
                        <li>
                           <a href="{{url('ResturantOrders')}}" title="{{trans('admin.Orders')}}" data-filter-tags="{{trans('admin.Orders')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Orders')}}</span>
                           </a>
                        </li>
                        @endcan              
                         
                                @can('جدول مبيعات الدليفري')

                        <li>
                           <a href="{{url('ResturantSalesDeliverySechdule')}}" title="{{trans('admin.SalesDeliverySechdule')}}" data-filter-tags="{{trans('admin.SalesDeliverySechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.SalesDeliverySechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                     </div>
                     <div class="col-sm-6">
                        @can('سلايدر المطاعم')
                        <li>
                           <a href="{{url('RWebSlider')}}" title="{{trans('admin.WebSlider')}}" data-filter-tags="{{trans('admin.WebSlider')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.WebSlider')}} (Home 1)</span>
                           </a>
                        </li>
                        @endcan
                        @can('هوم ٢ المطاعم')
                        <li>
                           <a href="{{url('ResturantHome')}}" title="{{trans('admin.Images')}}" data-filter-tags="{{trans('admin.Images')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders">{{trans('admin.Images')}} (Home 2) </span>
                           </a>
                        </li>
                        @endcan
                        @can('من نحن المطاعم')
                        <li>
                           <a href="{{url('RAbout')}}" title="{{trans('admin.About')}}" data-filter-tags="{{trans('admin.About')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.About')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('قسم الفيديو المطاعم')
                        <li>
                           <a href="{{url('VideoSection')}}" title="{{trans('admin.VideoSection')}}" data-filter-tags="{{trans('admin.VideoSection')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.VideoSection')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('تواصل اجتماعي المطاعم')
                        <li>
                           <a href="{{url('RSocialMedia')}}" title="{{trans('admin.SocialMedia')}}" data-filter-tags="{{trans('admin.SocialMedia')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.SocialMedia')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('المقالات المطاعم')
                        <li>
                           <a href="{{url('RArticles')}}" title="{{trans('admin.Articles')}}" data-filter-tags="{{trans('admin.Articles')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Articles')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('سياسه الخصوصيه المطاعم')
                        <li>
                           <a href="{{url('RPolices')}}" title="{{trans('admin.Polices')}}" data-filter-tags="{{trans('admin.Polices')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Polices')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('شروط و احكام المطاعم')
                        <li>
                           <a href="{{url('RTerms')}}" title="{{trans('admin.Terms')}}" data-filter-tags="{{trans('admin.Terms')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Terms')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('كود خصم المطاعم')
                        <li>
                           <a href="{{url('RCouponCode')}}" title="{{trans('admin.CouponCode')}}" data-filter-tags="{{trans('admin.CouponCode')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.CouponCode')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('الاستوديو المطاعم')
                        <li>
                           <a href="{{url('RGallery')}}" title="{{trans('admin.Gallery')}}" data-filter-tags="{{trans('admin.Gallery')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Gallery')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('مراجعات المطاعم')
                        <li>
                           <a href="{{url('RReviews')}}" title="{{trans('admin.Reviews')}}" data-filter-tags="{{trans('admin.Reviews')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Reviews')}}</span>
                           </a>
                        </li>
                        @endcan
                        @if(auth()->guard('admin')->user()->email == 'Klar@test.com')
                        <li>
                           <a href="{{url('ResturantStyle')}}" title="{{trans('admin.ResturantStyle')}}" data-filter-tags="{{trans('admin.ResturantStyle')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ResturantStyle')}}</span>
                           </a>
                        </li>
                        @endif
                     </div>
                  </div>
               </ul>
            </li>
            @endcan
            @endif
            @if($Modules->Manufacturing == 1)
            @can('التصنيع')
            <li>
               <a href="#" title="{{trans('admin.Manufacturing')}}" data-filter-tags="{{trans('admin.Manufacturing')}}">
               <i class="fal fa-cogs"></i>
               <span class="nav-link-text" data-i18n="nav.miscellaneous"> {{trans('admin.Manufacturing')}} </span>
               <input type="hidden" id="inpu11" value="1">
               </a>
               <ul style="width:600px" id="menu11">
                  @can('صالات التصنيع')
                  <li>
                     <a href="{{url('ManufacturingHalls')}}" title="{{trans('admin.ManufacturingHalls')}}" data-filter-tags="{{trans('admin.ManufacturingHalls')}}">
                     <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.ManufacturingHalls')}} </span>
                     </a>
                  </li>
                  @endcan
                  @can('نموذج التصنيع')
                  <li>
                     <a href="{{url('ManufacturingModel')}}" title="{{trans('admin.ManufacturingModel')}}" data-filter-tags="{{trans('admin.ManufacturingModel')}}">
                     <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.ManufacturingModel')}} </span>
                     </a>
                  </li>
                  <li>
                     <a href="{{url('ManufacturingModelPrecent')}}" title="{{trans('admin.ManufacturingModelPrecent')}}" data-filter-tags="{{trans('admin.ManufacturingModelPrecent')}}">
                     <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.ManufacturingModelPrecent')}} </span>
                     </a>
                  </li>
                  @endcan
                  @can('جدول نماذج التصنيع')
                  <li>
                     <a href="{{url('ManufacturingModelSechdule')}}" title="{{trans('admin.ManufacturingModelSechdule')}}" data-filter-tags="{{trans('admin.ManufacturingModelSechdule')}}">
                     <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.ManufacturingModelSechdule')}} </span>
                     </a>
                  </li>
                  @endcan
                  @can('التنفيذ و الاستلام')
                  <li>
                     <a href="{{url('ExecutingandReceiving')}}" title="{{trans('admin.ExecutingandReceiving')}}" data-filter-tags="{{trans('admin.ExecutingandReceiving')}}">
                     <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.ExecutingandReceiving')}} </span>
                     </a>
                  </li>
                  @endcan
                  <!-- If Big Manufacturing -->
                  @if($DefManu->Manu_Type == 1)
                  @endif
               </ul>
            </li>
            @endcan
            @endif
            @if($Modules->Secretariat == 1)
            @can('الامانات')
            <li>
               <a href="#" title="{{trans('admin.Secretariat')}}" data-filter-tags="{{trans('admin.Secretariat')}}">
               <i class="fal fa-user-lock"></i>
               <span class="nav-link-text" data-i18n="nav.form_stuff">{{trans('admin.Secretariat')}}</span>
               <input type="hidden" id="inpu15" value="1">
               </a>
               <ul style="width:450px" id="menu15">
                  @can('مخازن الامانات')
                  <li>
                     <a href="{{url('Secretariat_Stores')}}" title="{{trans('admin.Secretariat_Stores')}}" data-filter-tags="{{trans('admin.Secretariat_Stores')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Secretariat_Stores')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('وارد بضاعه الامانات')
                  <li>
                     <a href="{{url('Secretariat_Import_goods')}}" title="{{trans('admin.Secretariat_Import_goods')}}" data-filter-tags="{{trans('admin.Secretariat_Import_goods')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Secretariat_Import_goods')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('جدول وارد بضاعه الامانات')
                  <li>
                     <a href="{{url('Secretariat_Import_goods_Sechdule')}}" title="{{trans('admin.Secretariat_Import_goods_Sechdule')}}" data-filter-tags="{{trans('admin.Secretariat_Import_goods_Sechdule')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Secretariat_Import_goods_Sechdule')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('صرف بضاعه امانات')
                  <li>
                     <a href="{{url('Secretariat_Export_goods')}}" title="{{trans('admin.Secretariat_Export_goods')}}" data-filter-tags="{{trans('admin.Secretariat_Export_goods')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Secretariat_Export_goods')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('جدول صرف بضاعه الامانات')
                  <li>
                     <a href="{{url('Secretariat_Export_goods_Sechdule')}}" title="{{trans('admin.Secretariat_Export_goods_Sechdule')}}" data-filter-tags="{{trans('admin.Secretariat_Export_goods_Sechdule')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Secretariat_Export_goods_Sechdule')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('نموذج تصنيع للغير')
                  <li>
                     <a href="{{url('ManufacturingModelSecretariat')}}" title="{{trans('admin.ManufacturingModelSecretariat')}}" data-filter-tags="{{trans('admin.ManufacturingModelSecretariat')}}">
                     <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.ManufacturingModelSecretariat')}} </span>
                     </a>
                  </li>
                  <li>
                     <a href="{{url('ManufacturingModelSecretariatPrecent')}}" title="{{trans('admin.ManufacturingModelSecretariatPrecent')}}" data-filter-tags="{{trans('admin.ManufacturingModelSecretariatPrecent')}}">
                     <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.ManufacturingModelSecretariatPrecent')}} </span>
                     </a>
                  </li>
                  @endcan
                  @can('جدول نماذج تصنيع للغير')
                  <li>
                     <a href="{{url('ManufacturingModelSecretariatSechdule')}}" title="{{trans('admin.ManufacturingModelSecretariatSechdule')}}" data-filter-tags="{{trans('admin.ManufacturingModelSecretariatSechdule')}}">
                     <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.ManufacturingModelSecretariatSechdule')}} </span>
                     </a>
                  </li>
                  @endcan
                  @can('تنفيذ و استلام للغير')
                  <li>
                     <a href="{{url('ExecutingReceivingSecretariat')}}" title="{{trans('admin.ExecutingReceivingSecretariat')}}" data-filter-tags="{{trans('admin.ExecutingReceivingSecretariat')}}">
                     <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.ExecutingReceivingSecretariat')}} </span>
                     </a>
                  </li>
                  @endcan
                  @can('كميات مخازن الامانات')
                  <li>
                     <a href="{{url('Secretariat_Stores_Qty')}}" title="{{trans('admin.Secretariat_Stores_Qty')}}" data-filter-tags="{{trans('admin.Secretariat_Stores_Qty')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Secretariat_Stores_Qty')}}</span>
                     </a>
                  </li>
                  @endcan
               </ul>
            </li>
            @endcan
            @endif
            @if($Modules->Real_States == 1)
            @can('العقارات')
            <li>
               <a href="#" title="{{trans('admin.RealStates')}}" data-filter-tags="{{trans('admin.RealStates')}}">
               <i class="fal fa-home"></i>
               <span class="nav-link-text" data-i18n="nav.form_stuff">{{trans('admin.RealStates')}}</span>
               <input type="hidden" id="inpu27" value="1">
               </a>
               <ul style="width:600px" id="menu27">
                  @can('حالات المشاريع')
                  <li>
                     <a href="{{url('ProjectStatus')}}" title="{{trans('admin.ProjectStatus')}}" data-filter-tags="{{trans('admin.ProjectStatus')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ProjectStatus')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('حالات العقود')
                  <li>
                     <a href="{{url('ContractStatus')}}" title="{{trans('admin.ContractStatus')}}" data-filter-tags="{{trans('admin.ContractStatus')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ContractStatus')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('اضافة مشروع')
                  <li>
                     <a href="{{url('AddRealStateProjects')}}" title="{{trans('admin.AddProject')}}" data-filter-tags="{{trans('admin.AddProject')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.AddProject')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('مشاريع عقارات')
                  <li>
                     <a href="{{url('RealStateProjects')}}" title="{{trans('admin.Projects')}}" data-filter-tags="{{trans('admin.Projects')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Projects')}}</span>
                     </a>
                  </li>
                  @endcan
                  @can('تقرير ارباح المشاريع')
                  <li>
                     <a href="{{url('ProjectProfitReport')}}" title="{{trans('admin.ProjectProfitReport')}}" data-filter-tags="{{trans('admin.ProjectProfitReport')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ProjectProfitReport')}}</span>
                     </a>
                  </li>
                  @endcan
               </ul>
            </li>
            @endcan
            @endif
            @if($Modules->Shipping == 1)
            @can('موديول الشحن')
            <li>
               <a href="#" title="{{trans('admin.Shipping')}}" data-filter-tags="{{trans('admin.Shipping')}}">
               <i class="fal fa-truck"></i>
               <span class="nav-link-text" data-i18n="nav.form_stuff">{{trans('admin.Shipping')}}</span>
               <input type="hidden" id="inpu28" value="1">
               </a>
               <ul style="width:450px" id="menu28">
                  <div class="row">
                     <div class="col-sm-6">
                       @can('طلب شحنة')
                        <li>
                           <a href="{{url('ShipmentRequest')}}" title="{{trans('admin.ShipmentRequest')}}" data-filter-tags="{{trans('admin.ShipmentRequest')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ShipmentRequest')}}</span>
                           </a>
                        </li>
                        @endcan
                      @can('جدول طلبات الشحنات')
                        <li>
                           <a href="{{url('ShipmentRequestSechdule')}}" title="{{trans('admin.ShipmentRequestSechdule')}}" data-filter-tags="{{trans('admin.ShipmentRequestSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ShipmentRequestSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                     @can('الشحنة')
                        <li>
                           <a href="{{url('Shipment')}}" title="{{trans('admin.Shipment')}}" data-filter-tags="{{trans('admin.Shipment')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Shipment')}}</span>
                           </a>
                        </li>
                        @endcan
                       @can('جدول الشحنات')
                        <li>
                           <a href="{{url('ShipmentSechdule')}}" title="{{trans('admin.ShipmentSechdule')}}" data-filter-tags="{{trans('admin.ShipmentSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ShipmentSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                       @can('توزيع الشحنات')
                        <li>
                           <a href="{{url('ShipmentsDistribution')}}" title="{{trans('admin.ShipmentsDistribution')}}" data-filter-tags="{{trans('admin.ShipmentsDistribution')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ShipmentsDistribution')}}</span>
                           </a>
                        </li>
                        @endcan
                     @can('جدول توزيع الشحنات')
                        <li>
                           <a href="{{url('ShipmentsDistributionSechdule')}}" title="{{trans('admin.ShipmentsDistributionSechdule')}}" data-filter-tags="{{trans('admin.ShipmentsDistributionSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ShipmentsDistributionSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                      @can('تفريغ الشحنات')
                        <li>
                           <a href="{{url('UnloadingShipments')}}" title="{{trans('admin.UnloadingShipments')}}" data-filter-tags="{{trans('admin.UnloadingShipments')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.UnloadingShipments')}}</span>
                           </a>
                        </li>
                        @endcan
                       @can('جدول تفريغ الشحنات')
                        <li>
                           <a href="{{url('UnloadingShipmentsSechdule')}}" title="{{trans('admin.UnloadingShipmentsSechdule')}}" data-filter-tags="{{trans('admin.UnloadingShipmentsSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.UnloadingShipmentsSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                       @can('تسليمات الشحنات')
                        <li>
                           <a href="{{url('RecivedShipments')}}" title="{{trans('admin.RecivedShipments')}}" data-filter-tags="{{trans('admin.RecivedShipments')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.RecivedShipments')}}</span>
                           </a>
                        </li>
                        @endcan
                     @can('جدول تسليمات الشحنات')
                        <li>
                           <a href="{{url('RecivedShipmentsSechdule')}}" title="{{trans('admin.RecivedShipmentsSechdule')}}" data-filter-tags="{{trans('admin.RecivedShipmentsSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.RecivedShipmentsSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                     </div>
                     <div class="col-sm-6">
{{--
                      @can('انواع الشحنات')
                        <li>
                           <a href="{{url('NewShippingTypes')}}" title="{{trans('admin.ShippingTypes')}}" data-filter-tags="{{trans('admin.ShippingTypes')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ShippingTypes')}}</span>
                           </a>
                        </li>
                        @endcan
--}}
                     @can('تصنيفات الشحنات')
                        <li>
                           <a href="{{url('NewShippingCategories')}}" title="{{trans('admin.ShippingCategories')}}" data-filter-tags="{{trans('admin.ShippingCategories')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ShippingCategories')}}</span>
                           </a>
                        </li>
                        @endcan
                       @can('انواع طلبات الشحنات')
                        <li>
                           <a href="{{url('NewShippingRqstTypes')}}" title="{{trans('admin.ShippingRqstTypes')}}" data-filter-tags="{{trans('admin.ShippingRqstTypes')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ShippingRqstTypes')}}</span>
                           </a>
                        </li>
                        @endcan
                      @can('اسعار الشحنات')
                        <li>
                           <a href="{{url('ShippingPricesSechdule')}}" title="{{trans('admin.ShippingPrices')}}" data-filter-tags="{{trans('admin.ShippingPrices')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ShippingPrices')}}</span>
                           </a>
                        </li>
                        @endcan
                      @can('سيارات الشحنات')
                        <li>
                           <a href="{{url('CarShipping')}}" title="{{trans('admin.CarShipping')}}" data-filter-tags="{{trans('admin.CarShipping')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.CarShipping')}}</span>
                           </a>
                        </li>
                        @endcan
                      @can('حركات الشحنات')
                        <li>
                           <a href="{{url('ShipmentMoves')}}" title="{{trans('admin.ShipmentMoves')}}" data-filter-tags="{{trans('admin.ShipmentMoves')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ShipmentMoves')}}</span>
                           </a>
                        </li>
                        @endcan
                         
                         
                
                                      @can('مقاولين النقل')
                        <li>
                           <a href="{{url('TransportContractors')}}" title="{{trans('admin.TransportContractors')}}" data-filter-tags="{{trans('admin.TransportContractors')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.TransportContractors')}}</span>
                           </a>
                        </li>
                        @endcan
                        
                                       @can('اسعار النقل')
                        <li>
                           <a href="{{url('TransportPrices')}}" title="{{trans('admin.TransportPrices')}}" data-filter-tags="{{trans('admin.TransportPrices')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.TransportPrices')}}</span>
                           </a>
                        </li>
                        @endcan
                        
                                       @can('مستلمين النقل')
                        <li>
                           <a href="{{url('TransportReceiver')}}" title="{{trans('admin.TransportReceiver')}}" data-filter-tags="{{trans('admin.TransportReceiver')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.TransportReceiver')}}</span>
                           </a>
                        </li>
                        @endcan
                                  
                                       @can('طلب نقل')
                        <li>
                           <a href="{{url('RqstTransport')}}" title="{{trans('admin.RqstTransport')}}" data-filter-tags="{{trans('admin.RqstTransport')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.RqstTransport')}}</span>
                           </a>
                        </li>
                        @endcan                   
                                       @can('جدول طلبات النقل')
                        <li>
                           <a href="{{url('RqstTransportSechdule')}}" title="{{trans('admin.RqstTransportSechdule')}}" data-filter-tags="{{trans('admin.RqstTransportSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.RqstTransportSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                                           
                                       @can('النقل')
                        <li>
                           <a href="{{url('Transport')}}" title="{{trans('admin.Transport')}}" data-filter-tags="{{trans('admin.Transport')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Transport')}}</span>
                           </a>
                        </li>
                        @endcan
                        
                                        
                                       @can('جدول النقل')
                        <li>
                           <a href="{{url('TransportSechdule')}}" title="{{trans('admin.TransportSechdule')}}" data-filter-tags="{{trans('admin.TransportSechdule')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.TransportSechdule')}}</span>
                           </a>
                        </li>
                        @endcan
                        
                         
                         
                         
                         
                         
                         
                         
                     </div>
                  </div>
               </ul>
            </li>
            @endcan
            @endif
            @can('طلباتي')
            @if(auth()->guard('admin')->user()->ship != 0)
            <li>
               <a href="#" title="{{trans('admin.Orders')}}" data-filter-tags="{{trans('admin.Orders')}}">
               <i class="fal fa-edit"></i>
               <span class="nav-link-text" data-i18n="nav.form_stuff">{{trans('admin.Orders')}}</span>
               <input type="hidden" id="inpu16" value="1">
               </a>
               <ul style="width:600px" id="menu16">
                  <li>
                     <a href="{{url('Orders')}}" title="{{trans('admin.Orders')}}" data-filter-tags="{{trans('admin.Orders')}}">
                     <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Orders')}}</span>
                     </a>
                  </li>
               </ul>
            </li>
            @endif
            @endcan
            @if($Modules->ECommerce == 1)
            @can('الموقع')
            <li>
               <a href="#" title="{{trans('admin.Website')}}" data-filter-tags="{{trans('admin.Website')}}">
               <i class="fal fa-globe"></i>
               <span class="nav-link-text" data-i18n="nav.form_stuff">{{trans('admin.Website')}}</span>
               <input type="hidden" id="inpu17" value="1">
               </a>
               <ul style="width:600px" id="menu17">
                  <div class="row">
                     <div class="col-sm-6">
                        @can('سلايدر الموقع')
                        <li>
                           <a href="{{url('WebSlider')}}" title="{{trans('admin.WebSlider')}}" data-filter-tags="{{trans('admin.WebSlider')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.WebSlider')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('من نحن')
                        <li>
                           <a href="{{url('About')}}" title="{{trans('admin.About')}}" data-filter-tags="{{trans('admin.About')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.About')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('التواصل الاجتماعي')
                        <li>
                           <a href="{{url('SocialMedia')}}" title="{{trans('admin.SocialMedia')}}" data-filter-tags="{{trans('admin.SocialMedia')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.SocialMedia')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('رسايل التواصل')
                        <li>
                           <a href="{{url('MsgRqst')}}" title="{{trans('admin.MsgRqst')}}" data-filter-tags="{{trans('admin.MsgRqst')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.MsgRqst')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('التواصل معنا')
                        <li>
                           <a href="{{url('ContactUS')}}" title="{{trans('admin.ContactUS')}}" data-filter-tags="{{trans('admin.ContactUS')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ContactUS')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('المقالات')
                        <li>
                           <a href="{{url('Articles')}}" title="{{trans('admin.Articles')}}" data-filter-tags="{{trans('admin.Articles')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Articles')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('السياسات')
                        <li>
                           <a href="{{url('Polices')}}" title="{{trans('admin.Polices')}}" data-filter-tags="{{trans('admin.Polices')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Polices')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('الشروط و الاحكام')
                        <li>
                           <a href="{{url('Terms')}}" title="{{trans('admin.Terms')}}" data-filter-tags="{{trans('admin.Terms')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Terms')}}</span>
                           </a>
                        </li>
                        @endcan
                     </div>
                     <div class="col-sm-6">
                        @can('كوبون كود')
                        <li>
                           <a href="{{url('CouponCode')}}" title=" {{trans('admin.CouponCode')}}" data-filter-tags="{{trans('admin.CouponCode')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.CouponCode')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('الاسئله الشائعه')
                        <li>
                           <a href="{{url('FAQ')}}" title="{{trans('admin.FAQ')}}" data-filter-tags="{{trans('admin.FAQ')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.FAQ')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('اعلانات تفاصيل االمنتج')
                        <li>
                           <a href="{{url('ProDetailsImg')}}" title="{{trans('admin.ProDetailsImg')}}" data-filter-tags="{{trans('admin.ProDetailsImg')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ProDetailsImg')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('صور سياسه المتجر')
                        <li>
                           <a href="{{url('BefroeFooter')}}" title=" {{trans('admin.BefroeFooter')}}" data-filter-tags="{{trans('admin.BefroeFooter')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.BefroeFooter')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('طلبات المتجر')
                        <li>
                           <a href="{{url('ShopOrders')}}" title="{{trans('admin.Orders')}}" data-filter-tags="{{trans('admin.Orders')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Orders')}}</span>
                           </a>
                        </li>
                        @endcan
                        @if(auth()->guard('admin')->user()->email == 'Klar@test.com')
                        <li>
                           <a href="{{url('EComDesign')}}" title="{{trans('admin.EComDesign')}}" data-filter-tags="{{trans('admin.EComDesign')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.EComDesign')}}</span>
                           </a>
                        </li>
                        @endif
                     </div>
                  </div>
               </ul>
            </li>
            @endcan
            @endif
            @can('الاعدادات')
            <li>
               <a href="#" title="{{trans('admin.Settings')}}" data-filter-tags="{{trans('admin.Settings')}}">
               <i class="fal fa-wrench"></i>
               <span class="nav-link-text" data-i18n="nav.miscellaneous"> {{trans('admin.Settings')}} </span>
               <input type="hidden" id="inpu12" value="1">
               </a>
               <ul style="width:600px" id="menu12">
                  <div class="row">
                     <div class="col-sm-6">
                        @can('صلاحيات المستخدمين')
                        <li>
                           <a href="{{url('AdminsPremations')}}" title="{{trans('admin.AdminsPremations')}}" data-filter-tags="{{trans('admin.AdminsPremations')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.AdminsPremations')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('المستخدمين')
                        <li>
                           <a href="{{url('Admins')}}" title="{{trans('admin.Admins')}}" data-filter-tags="{{trans('admin.Admins')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.Admins')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('البيانات الافتراضيه')
                        <li>
                           <a href="{{url('Default_Data')}}" title="{{trans('admin.Default_Data')}}" data-filter-tags="{{trans('admin.Default_Data')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.Default_Data')}} </span>
                           </a>
                        </li>
                        @endcan
                        @can('حركه المستخدمين')
                        <li>
                           <a href="{{url('UserLog')}}" title="{{trans('admin.User_Log')}}" data-filter-tags="{{trans('admin.User_Log')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.User_Log')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('مواقع الموظفين')
                        <li>
                           <a href="{{url('EmpLocations')}}" title="{{trans('admin.Emp_Locations')}}" data-filter-tags="{{trans('admin.Emp_Locations')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.Emp_Locations')}}</span>
                           </a>
                        </li>
                        @endcan               
                        @can('مواقع الموظفين')
                        <li>
                           <a href="{{url('EmpMovement')}}" title="{{trans('admin.EmpMovement')}}" data-filter-tags="{{trans('admin.EmpMovement')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.EmpMovement')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('استيراد ملفات اكسيل')
                        <li>
                           <a href="{{url('ExportProducts')}}" title="{{trans('admin.ExportProducts')}}" data-filter-tags="{{trans('admin.ExportProducts')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ExportProducts')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('الترجمه')
                        <li>
                           <a href="{{url('Translate')}}" title="{{trans('admin.Translate')}}" data-filter-tags="{{trans('admin.Translate')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Translate')}}</span>
                           </a>
                        </li>
                        @endcan
                        @can('حذف الحركات')
                        <li>
                           <a href="{{url('DeleteMoves')}}" title="{{trans('admin.DeleteMoves')}}" data-filter-tags="{{trans('admin.DeleteMoves')}}">
                           <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.DeleteMoves')}}</span>
                           </a>
                        </li>
                        @endcan
                         
                         
                        <li>
                            <a href="{{url('Errors')}}" title="{{trans('admin.Errors')}}" data-filter-tags="{{trans('admin.Errors')}}">
                                <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Errors')}}</span>
                            </a>

                        </li>
                     </div>
                     <div class="col-sm-6">
                        @if(auth()->guard('admin')->user()->email == 'Klar@test.com')
                        <li>
                           <a href="{{url('Modules_Settings')}}" title="{{trans('admin.Modules_Settings')}}" data-filter-tags="{{trans('admin.Modules_Settings')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.Modules_Settings')}} </span>
                           </a>
                        </li>
                        <li>
                           <a href="{{url('AddPackage')}}" title="{{trans('admin.AddPackage')}}" data-filter-tags="{{trans('admin.AddPackage')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.AddPackage')}} </span>
                           </a>
                        </li>
                        <li>
                           <a href="{{url('Packages')}}" title="{{trans('admin.Packages')}}" data-filter-tags="{{trans('admin.Packages')}}">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> {{trans('admin.Packages')}} </span>
                           </a>
                        </li>
                        @endif
                        @if(auth()->guard('admin')->user()->email == 'Klar@test.com' or auth()->guard('admin')->user()->email == 'support@rabih.com')
                        <li>
                           <a href="{{url('QR')}}" title="QR" data-filter-tags="QR">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> QR</span>
                           </a>
                        </li>
                        <li>
                           <a href="{{url('LoginSlider')}}" title="Login Slider" data-filter-tags="Login Slider">
                           <span class="nav-link-text" data-i18n="nav.miscellaneous_fullcalendar"> Login Slider</span>
                           </a>
                        </li>
                        @endif
                        @if(auth()->guard('admin')->user()->email == 'Klar@test.com' )

                        <li>
                            <a href="{{url('Domain_Regstration')}}" title="{{trans('admin.Domain_Regstration')}}" data-filter-tags="{{trans('admin.Domain_Regstration')}}">
                                <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Domain_Regstration')}}</span>
                            </a>

                        </li>

                        <li>
                            <a href="{{url('Updates')}}" title="{{trans('admin.Updates')}}" data-filter-tags="{{trans('admin.Updates')}}">
                                <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Updates')}}</span>
                            </a>

                        </li>

                        <li>
                            <a href="{{url('ServerDB')}}" title="Server Data Bases" data-filter-tags="Server Data Bases">
                                <span class="nav-link-text" data-i18n="nav.Server Data Bases"> Server Data Bases</span>
                            </a>

                        </li>

                        @endif
                        @if(auth()->guard('admin')->user()->email == 'Klar@test.com' or auth()->guard('admin')->user()->email == 'support@rabih.com')
                        @can('كميات المخازن')
                        <li>
                           <a href="{{url('StoresQty')}}" title="{{trans('admin.StoresQty')}}" data-filter-tags="{{trans('admin.StoresQty')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.StoresQty')}}</span>
                           </a>
                        </li>
                        @endcan
                        @endif
                        @if(auth()->guard('admin')->user()->email == 'Klar@test.com' or auth()->guard('admin')->user()->email == 'support@rabih.com')
                        <li>
                           <a href="{{url('AdminEditProductMoves')}}" title="{{trans('admin.EditProductMoves')}}" data-filter-tags="{{trans('admin.EditProductMoves')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.EditProductMoves')}}</span>
                           </a>
                        </li>
                        <li>
                           <a href="{{url('AdminEditGeneralDaily')}}" title="{{trans('admin.EditGeneralDaily')}}" data-filter-tags="{{trans('admin.EditGeneralDaily')}}">
                           <span class="nav-link-text" data-i18n="nav.ui_components_buttons">{{trans('admin.EditGeneralDaily')}}</span>
                           </a>
                        </li>
                        @endif
                     </div>
                  </div>
               </ul>
            </li>
            @endcan
            @endif
            <li>
            </li>
         </ul>
         <div class="filter-message js-filter-message bg-success-600"></div>
      </nav>
      <!-- END PRIMARY NAVIGATION -->
      <!-- NAV FOOTER -->
      <div class="nav-footer shadow-top">
         <a href="#" onclick="return false;" data-action="toggle" data-class="nav-function-minify" class="hidden-md-down">
         <i class="ni ni-chevron-right"></i>
         <i class="ni ni-chevron-right"></i>
         </a>
         <ul class="list-table m-auto nav-footer-buttons">
            <li>
               <a target="_blank" href="https://www.facebook.com/klarapps" data-toggle="tooltip" data-placement="top" title="Chat logs">
               <i class="fab fa-facebook-messenger"></i>
               </a>
            </li>
            <li>
               <a target="_blank" href="https://wa.me/201062201060" data-toggle="tooltip" data-placement="top" title="Whatsapp">
               <i class="fab fa-whatsapp"></i>
               </a>
            </li>
            <li>
               <a target="_blank" href="00201062201060" data-toggle="tooltip" data-placement="top" title="00201062201060">
               <i class="fal fa-phone"></i>
               </a>
            </li>
         </ul>
      </div>
      <!-- END NAV FOOTER -->
   </aside>
   <!-- END Left Aside -->
   <div class="page-content-wrapper">
   <!-- BEGIN Page Header -->
   <header class="page-header" role="banner">
      <!-- we need this logo when user switches to nav-function-top -->
      <div class="page-logo">
         <a href="#" class="page-logo-link press-scale-down d-flex align-items-center position-relative" data-toggle="modal" data-target="#modal-shortcut">
         @if(!empty($Def->Logo))
         <img src="{{URL::to($Def->Logo)}}" alt="SmartAdmin WebApp" aria-roledescription="logo">
         @else
         <img src="{{asset('Admin/img/logo.png')}}" alt="SmartAdmin WebApp" aria-roledescription="logo">
         @endif
         <span class="page-logo-text mr-1">
         {{app()->getLocale() == 'ar' ?$Def->Name :$Def->NameEn}}
         </span>
         <span class="position-absolute text-white opacity-50 small pos-top pos-right mr-2 mt-n2"></span>
         <i class="fal fa-angle-down d-inline-block ml-1 fs-lg color-primary-300"></i>
         </a>
      </div>
      <!-- DOC: nav menu layout change shortcut -->
      <div class="hidden-md-down dropdown-icon-menu position-relative">
         <a href="#" class="header-btn btn js-waves-off" data-action="toggle" data-class="nav-function-hidden" title="Hide Navigation">
         <i class="ni ni-menu"></i>
         </a>
         <ul>
            <li>
               <a href="#" class="btn js-waves-off" data-action="toggle" data-class="nav-function-minify" title="Minify Navigation">
               <i class="ni ni-minify-nav"></i>
               </a>
            </li>
            <li>
               <a href="#" class="btn js-waves-off" data-action="toggle" data-class="nav-function-fixed" title="Lock Navigation">
               <i class="ni ni-lock-nav"></i>
               </a>
            </li>
         </ul>
      </div>
      <!-- DOC: mobile button appears during mobile width -->
      <div class="hidden-lg-up">
         <a href="#" class="header-btn btn press-scale-down" data-action="toggle" data-class="mobile-nav-on">
         <i class="ni ni-menu"></i>
         </a>
      </div>
      <!--<div class="search">-->
      <!--   <form class="app-forms hidden-xs-down" role="search" action="page_search.html" autocomplete="off">-->
      <!--      <input type="text" id="search-field" placeholder="Search for anything" class="form-control" tabindex="1">-->
      <!--      <a href="#" onclick="return false;" class="btn-danger btn-search-close js-waves-off d-none" data-action="toggle" data-class="mobile-search-on">-->
      <!--      <i class="fal fa-times"></i>-->
      <!--      </a>-->
      <!--   </form>-->
      <!--</div>-->
      @if($ModulesSett->System == 1)
      @if(auth()->guard('admin')->user()->email != "Klar@test.com")
      @php
      $day7=date("Y-m-d", strtotime("-7 days", strtotime($ModulesSett->Expire_Date)));
      $day6=date("Y-m-d", strtotime("-6 days", strtotime($ModulesSett->Expire_Date)));
      $day5=date("Y-m-d", strtotime("-5 days", strtotime($ModulesSett->Expire_Date)));
      $day4=date("Y-m-d", strtotime("-4 days", strtotime($ModulesSett->Expire_Date)));
      $day3=date("Y-m-d", strtotime("-3 days", strtotime($ModulesSett->Expire_Date)));
      $day2=date("Y-m-d", strtotime("-2 days", strtotime($ModulesSett->Expire_Date)));
      $day1=date("Y-m-d", strtotime("-1 days", strtotime($ModulesSett->Expire_Date)));
      @endphp
      @if(date('Y-m-d') == $day7 or date('Y-m-d') == $day6 or date('Y-m-d') == $day5 or date('Y-m-d') == $day4 or date('Y-m-d') == $day3 or date('Y-m-d') == $day2 or date('Y-m-d') == $day1)
      <div class='line text-center ml-3 mr-3'>
         <h6 class='pop-outin'> {{trans('admin.Renew_Date_Soon')}} {{$ModulesSett->Expire_Date}}</h6>
      </div>
      @endif
      @endif
      @endif
      @php $Events=Event::where('Event_En_Name','Expired Supscribe')->get(); @endphp
      @foreach($Events as $event)
      @if(date('Y-m-d') == $event->End_Date)
      @php $pro=Products::find($event->Product); @endphp
      <div class='line text-center ml-3 mr-3'>
         <h6 class='pop-outin'>
            {{trans('admin.Expired_Subscribe')}}
            @if(!empty($pro))
            ( {{app()->getLocale() == 'ar' ?$pro->P_Ar_Name :$pro->P_En_Name}} )
            @endif
            {{$event->End_Date}}
         </h6>
      </div>
      @endif
      @endforeach
      <style>
         /* crops animations that exceeds one line area */
         .line {
         width: 100%;
         height: 4rem;
         overflow: hidden;
         padding: 5px;
         margin-bottom: 16px;
         }
         /* subtle zoom to attention and then back */
         .pop-outin {
         animation: 2s anim-popoutin ease infinite;
         padding: 17px;
         }
         @keyframes anim-popoutin {
         0% {
         color: black;
         transform: scale(0);
         opacity: 0;
         text-shadow: 0 0 0 rgba(0, 0, 0, 0);
         }
         25% {
         color: red;
         transform: scale(2);
         opacity: 1;
         text-shadow: 3px 10px 5px rgba(0, 0, 0, 0.5);
         }
         50% {
         color: black;
         transform: scale(1);
         opacity: 1;
         text-shadow: 1px 0 0 rgba(0, 0, 0, 0);
         }
         100% {
         /* animate nothing to add pause at the end of animation */
         transform: scale(1);
         opacity: 1;
         text-shadow: 1px 0 0 rgba(0, 0, 0, 0);
         }
         }
         .fromtop {
         animation: 2s anim-fromtop linear infinite;
         }
         @keyframes anim-fromtop {
         0% {
         opacity: 0;
         transform: translateY(-100%);
         }
         25% {
         opacity: 1;
         transform: translateY(0%);
         }
         50% {}
         100% {}
         }
      </style>
      <div class="top-left-nav d-flex">
         <!-- activate app search icon (mobile) -->
         <!--<div class="hidden-sm-up">-->
         <!--   <a href="#" class="header-icon" data-action="toggle" data-class="mobile-search-on" data-focus="search-field" title="Search">-->
         <!--   <i class="fal fa-search"></i>-->
         <!--   </a>-->
         <!--</div>-->
         <!-- app settings -->
         <div class="hidden-md-down">
            <a href="#" class="header-icon" data-toggle="modal" data-target=".js-modal-settings">
            <i class="fal fa-cog"></i>
            </a>
         </div>
         @if(auth()->guard('admin')->user()->vend == 0 and auth()->guard('admin')->user()->cli == 0 and auth()->guard('admin')->user()->emp == 0)
         <!-- app shortcuts -->
         <div>
            <a href="#" class="header-icon" data-toggle="dropdown" title="My Apps">
            <i class="fal fa-cube"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-animated w-auto h-auto">
               <div class="dropdown-header bg-trans-gradient d-flex justify-content-center align-items-center rounded-top">
                  <h4 class="m-0 text-center color-white">
                     {{trans('admin.Quick_Shortcut')}}
                  </h4>
               </div>
               <div class="custom-scroll h-100">
                  @if($Modules->Stores == 1)
                  <ul class="app-list">
                     @can('اضافه عملاء')
                     <li>
                        <a href="{{url('AddClients')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/013.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Add_Clients')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('اضافه مبيعات')
                     <li>
                        <a href="{{url('Sales')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/019.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Sales')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('جدول المبيعات')
                     <li>
                        <a href="{{url('SalesSechdule')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/020.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.SalesSechdule')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('اضافه سند قبض')
                     <li>
                        <a href="{{url('Receipt_Voucher')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/003.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Receipt_Voucher')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('اضافه سند صرف')
                     <li>
                        <a href="{{url('Payment_Voucher')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/004.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Payment_Voucher')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('تحويلات الخزائن')
                     <li>
                        <a href="{{url('SafesTransfer')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/005.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Safes_Transfer')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('جدول تحويلات الخزائن')
                     <li>
                        <a href="{{url('SafesTransferSechdule')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/006.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Safes_Transfer_Sechdule')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('اضافه تحويلات المخازن')
                     <li>
                        <a href="{{url('StoresTransfers')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/035.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Stores_Transfers')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('جدول تحويلات المخازن')
                     <li>
                        <a href="{{url('StoresTransfersSechdule')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/036.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Stores_Transfers_Sechdule')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('دليل الاصناف')
                     <li>
                        <a href="{{url('ItemsGuide')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/031.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Items_Guide')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('اضافه صنف')
                     <li>
                        <a href="{{url('Add_Items')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/032.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Add_Items')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('جدول الاصناف')
                     <li>
                        <a href="{{url('Products_Sechdule')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/033.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Products_Sechdule')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('العملاء')
                     <li>
                        <a href="{{url('Clients')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/014.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Clients')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('الموردين')
                     <li>
                        <a href="{{url('Vendors')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/007.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Vendors')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('اضافه امر شراء')
                     <li>
                        <a href="{{url('PurchasesOrder')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/008.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.PurchasesOrder')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('جدول آوامر الشراء')
                     <li>
                        <a href="{{url('PurchasesOrderSechdule')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/009.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.PurchasesOrderSechdule')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('اضافه مشتريات')
                     <li>
                        <a href="{{url('Purchases')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/010.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Purchases')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('جدول المشتريات')
                     <li>
                        <a href="{{url('PurchasesSechdule')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/011.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.PurchasesSechdule')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('الفواتير المعلقه مشتريات')
                     <li>
                        <a href="{{url('PurchasesHold')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/012.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.PurchasesHold')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('اضافه عرض سعر')
                     <li>
                        <a href="{{url('Quote')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/015.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Quote')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('جدول عرض سعر')
                     <li>
                        <a href="{{url('Quote_Sechdule')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/016.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Quote_Sechdule')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('اضافه امر بيع')
                     <li>
                        <a href="{{url('PurchasesOrderSechdule')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/017.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.SalesOrder')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('جدول امر البيع')
                     <li>
                        <a href="{{url('SalesOrderSechdule')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/018.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.SalesOrderSechdule')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('الفواتير المعلقه مبيعات')
                     <li>
                        <a href="{{url('SalesHoldSechdule')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/021.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.SalesHoldSechdule')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('اضافه موظف')
                     <li>
                        <a href="{{url('AddEmp')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/022.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Add_Emp')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('صرف راتب')
                     <li>
                        <a href="{{url('AddSalary')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/023.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.AddSalary')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('استعلام عن منتج')
                     <li>
                        <a href="{{url('Product_Info')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/024.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Product_Info')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('ميزان المراجعه')
                     <li>
                        <a href="{{url('Trial_Balance')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/025.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Trial_Balance')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('كشف حساب خزنه، بنك')
                     <li>
                        <a href="{{url('Safe_Bank_Statement')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/026.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Safe_Bank_Statement')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('كشف حساب موردين')
                     <li>
                        <a href="{{url('Vendor_Account_Statement')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/027.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Vendor_Account_Statement')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('كشف حساب عملاء')
                     <li>
                        <a href="{{url('Customer_Account_Statement')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/028.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Customer_Account_Statement')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('قائمه الدخل')
                     <li>
                        <a href="{{url('Incom_List')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/029.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Incom_List')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('قائمه المركز المالي')
                     <li>
                        <a href="{{url('Financial_Center')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/030.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Financial_Center')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('طباعه الباركود')
                     <li>
                        <a href="{{url('BarcodeـPrinting')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/034.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.BarcodeـPrinting')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('الدليل المحاسبي')
                     <li>
                        <a href="{{url('AccountingManual')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/001.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Accounting_Manual')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('اضافه قيد يومي')
                     <li>
                        <a href="{{url('Journalizing')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/002.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Journalizing')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('نقاط البيع')
                     @if(auth()->guard('admin')->user()->emp != 0)
                     <li>
                        <a href="{{url('POS')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/002.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.POS')}}
                        </span>
                        </a>
                     </li>
                     @endif
                     @endcan
                     @can('جرد المخازن')
                     <li>
                        <a href="{{url('StoresInventory')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/002.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.StoresInventory')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('تحصيل مناديب')
                     <li>
                        <a href="{{url('Collection_Delegates')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/002.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Collection_Delegates')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                     @can('مبيعات مناديب')
                     <li>
                        <a href="{{url('Sales_Delegates')}}" class="app-list-item hover-white">
                        <span class="icon-stack">
                        <img style="width:50px;height:50px" src='{{asset("Admin/assets/images/002.gif")}}'>
                        </span>
                        <span class="app-list-name">
                        {{trans('admin.Sales_Delegates')}}
                        </span>
                        </a>
                     </li>
                     @endcan
                  </ul>
                  @endif
               </div>
            </div>
         </div>
         @endif
         <!-- app message -->
         @can('الاشعارات')
         <!-- app notification -->
         <div>
            <a href="#" class="header-icon" data-toggle="dropdown" title="You got 11 notifications">
            <i class="fal fa-bell"></i>
            <span class="badge badge-icon">{{$NotificationsCount}}</span>
            </a>
            <div class="dropdown-menu dropdown-menu-animated dropdown-xl">
               <div class="dropdown-header bg-trans-gradient d-flex justify-content-center align-items-center rounded-top mb-2">
                  <h4 class="m-0 text-center color-white">
                     {{$NotificationsCount}}
                     <small class="mb-0 opacity-80">{{trans('admin.New_Notifications')}}</small>
                  </h4>
               </div>
               {{--
               <ul class="nav nav-tabs nav-tabs-clean" role="tablist">
                  <li class="nav-item">
                     <a class="nav-link px-4 fs-md js-waves-on fw-500" data-toggle="tab" href="#tab-messages" data-i18n="drpdwn.messages">Messages</a>
                  </li>
               </ul>
               --}}
               <div class="tab-content tab-notification">
                  <div class="tab-pane active" id="tab-messages" role="tabpanel">
                     <div class="custom-scroll h-100">
                        <ul class="notification">
                           @foreach($Notifications as $noti)
                           <li class="unread">
                              <a href="#" class="d-flex align-items-center">
                              <span class="status mr-2">
                              <span class="profile-image rounded-circle d-inline-block" style="background-image:url({{asset('Admin/img/demo/avatars/avatar-c.png')}})"></span>
                              </span>
                              <span class="d-flex flex-column flex-1 ml-1">
                              <span class="name">{{app()->getLocale() == 'ar' ?$noti->Type :$noti->TypeEn}} ({{$noti->Type_Code}})</span>
                              <span class="msg-a fs-sm">{{app()->getLocale() == 'ar' ?$noti->Noti_Ar_Name :$noti->Noti_En_Name}}</span>
                              <span class="fs-nano text-muted mt-1">{{$noti->Date}}</span>
                              </span>
                              </a>
                           </li>
                           @endforeach
                        </ul>
                     </div>
                  </div>
               </div>
               <div class="py-2 px-3 bg-faded d-block rounded-bottom text-right border-faded border-bottom-0 border-right-0 border-left-0">
                  <a href="{{url('AllNotifucations')}}" class="fs-xs fw-500 ml-auto">{{trans('admin.view_all_notifications')}} </a>
               </div>
               <div class="py-2 px-3 bg-faded d-block rounded-bottom text-left border-faded border-bottom-0 border-left-0 border-right-0">
                  <a href="{{url('ReadAllNotifucations')}}" class="fs-xs fw-500 ml-auto">{{trans('admin.ReadAllNotifucations')}} </a>
               </div>
            </div>
         </div>
         @endcan
         <!-- app user menu -->
         <div>
            <a href="#" data-toggle="dropdown" title="info@klarapps.com" class="header-icon d-flex align-items-center justify-content-center ml-2">
            @if(!empty(auth()->guard('admin')->user()->image))
            <img src="{{URL::to(auth()->guard('admin')->user()->image)}}" class="profile-image rounded-circle" alt="{{auth()->guard('admin')->user()->name}}">
            @else
            <img src="{{asset('Admin/img/default.jpeg')}}" class="profile-image rounded-circle" alt="{{asset('Admin/img/default.jpeg')}}">
            @endif
            </a>
            <div class="dropdown-menu dropdown-menu-animated dropdown-lg">
               <div class="dropdown-header bg-trans-gradient d-flex flex-row py-4 rounded-top">
                  <div class="d-flex flex-row align-items-center mt-1 mb-1 color-white">
                     <span class="mr-2">
                     <img src="{{URL::to(auth()->guard('admin')->user()->image)}}" class="rounded-circle profile-image" alt="{{auth()->guard('admin')->user()->name}}">
                     </span>
                     <div class="info-card-text">
                        <div class="fs-lg text-truncate text-truncate-lg"> {{app()->getLocale() == 'ar' ?auth()->guard('admin')->user()->name :auth()->guard('admin')->user()->nameEn}} </div>
                        <span class="text-truncate text-truncate-md opacity-80">{{auth()->guard('admin')->user()->email}}</span>
                     </div>
                  </div>
               </div>
               <div class="dropdown-divider m-0"></div>
               <a href="#" class="dropdown-item" data-action="app-reset">
               <span data-i18n="drpdwn.reset_layout">Reset Layout</span>
               </a>
               <a href="#" class="dropdown-item" data-toggle="modal" data-target=".js-modal-settings">
               <span data-i18n="drpdwn.settings">Settings</span>
               </a>
               <div class="dropdown-divider m-0"></div>
               <a href="#" class="dropdown-item" data-action="app-fullscreen">
               <span data-i18n="drpdwn.fullscreen">Fullscreen</span>
               <i class="float-right text-muted fw-n">F11</i>
               </a>
               <a href="#" class="dropdown-item" data-action="app-print">
               <span data-i18n="drpdwn.print">Print</span>
               <i class="float-right text-muted fw-n">Ctrl + P</i>
               </a>
               <a href="{{url('Profile')}}" class="dropdown-item">
               <span data-i18n="drpdwn.print"> {{trans('admin.Profile')}} </span>
               </a>
               <div class="dropdown-multilevel dropdown-multilevel-left">
                  <div class="dropdown-item">
                     {{trans('admin.Language')}}
                  </div>
                  <div class="dropdown-menu">
                     <a href="{{url('lang/ar')}}" class="dropdown-item">{{trans('admin.Arabic')}}</a>
                     <a href="{{url('lang/en')}}" class="dropdown-item">{{trans('admin.English')}}</a>
                  </div>
               </div>
               <div class="dropdown-divider m-0"></div>
               <a class="dropdown-item fw-500 pt-3 pb-3" href="{{url('Logout')}}">
               <span data-i18n="drpdwn.page-logout">{{trans('admin.Logout')}}</span>
               <span class="float-right fw-n">&commat;klarapps</span>
               </a>
            </div>
         </div>
      </div>
   </header>
   <!-- END Page Header -->