@extends('admin.index')
@section('content')
@php
use App\Models\ProductOrders;
@endphp
  <title>{{trans('admin.Orders')}}</title>

    <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Website')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('admin.Orders')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                    <div class="row">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                         <span class="fw-300"><i>{{trans('admin.Orders')}}</i></span>
                                    </h2>

                                    <div class="panel-toolbar">


                                        <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                                      @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                                   <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                        <div id="mobile-overflow">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped w-100 mobile-width">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Draw')}}</th>
                                                    <th>{{trans('admin.Payment_Method')}}</th>
                                                    <th>{{trans('admin.Status')}}</th>
                                                    <th>{{trans('admin.Client')}}</th>
                                                    <th>{{trans('admin.Account_Code')}}</th>
                                                    <th>{{trans('admin.Store')}}</th>
                                                    <th>{{trans('admin.Coin')}}</th>
                                                    <th>{{trans('admin.Address')}}</th>
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                            @foreach($items as $item)
                                            @if($item->Status == 3)
                                                <tr style="background-color: darkgreen; color: white">
                                            @else
                                                    <tr>
                                            @endif
                                                    <td>{{$item->Code}}</td>
                                                    <td>{{$item->Date}}</td>
                                                    <td>{{$item->Draw}}</td>
                                                    <td>{{$item->Payment_Method}}</td>
                                                    <td>
                                                    @if($item->Status == 0)

                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Status{{$item->id}}">   {{trans('admin.Pending')}}</button>
                                                    @elseif($item->Status == 1)

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Status{{$item->id}}">{{trans('admin.On_Processing')}}</button>
                                                    @elseif($item->Status == 3)
                                                        {{trans('admin.Recived')}}
                                                    @endif
                                                    </td>
                                                    <td>

                                             {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}
                                                        </td>
                                                    <td>{{$item->Client()->first()->Code}}</td>
                                                    <td>
                                               {{app()->getLocale() == 'ar' ?$item->Store()->first()->Name :$item->Store()->first()->NameEn}}
                                                        </td>
                                                    <td>

                                                     {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}
                                                        </td>

                                                    <td>
                       <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Address{{$item->id}}">{{trans('admin.Address')}}</button>
                                                    </td>

                                                     <td>
                       <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Details{{$item->id}}">{{trans('admin.Details')}}</button>
                                                    </td>

                                                    <td class="text-center">
                                               @if($item->Status != 3)
                        <a class="btn btn-default" href="{{url('TransOrdertoSales/'.$item->id)}}">
                                        <i class="fal fa-check"></i>
                                                        </a>


                     <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                                         @endif
                                                    </td>
                                                </tr>
                                             @endforeach


                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                 <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Draw')}}</th>
                                                    <th>{{trans('admin.Payment_Method')}}</th>
                                                    <th>{{trans('admin.Status')}}</th>
                                                    <th>{{trans('admin.Client')}}</th>
                                                    <th>{{trans('admin.Account_Code')}}</th>
                                                    <th>{{trans('admin.Store')}}</th>
                                                    <th>{{trans('admin.Coin')}}</th>
                                                    <th>{{trans('admin.Address')}}</th>
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                        </div>
                                        {{$items->Links()}}
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

         @foreach($items as $item)

                      <!-- Modal Delete -->
<div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                          {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                   <a href="{{url('DeleteOrder/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>


         <!-- Modal Address -->
   <div class="modal fade" id="Address{{$item->id}}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl">
    <div class="modal-content">
        <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">{{trans('admin.Address')}}</h5>
        <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close">
        </button>
        </div>
        <div class="modal-body">
   <table class="table table-bordered">
                            <thead class="thead-dark">
                                <tr>
                                    <th>{{trans('admin.Address_Name')}}</th>
                                    <th>{{trans('admin.Country')}}</th>
                                    <th>{{trans('admin.Governrate')}}</th>
                                    <th>{{trans('admin.City')}}</th>
                                    <th>{{trans('admin.Address')}}</th>
                                    <th>{{trans('admin.Street')}}</th>
                                    <th>{{trans('admin.Buliding_Num')}}</th>
                                    <th>{{trans('admin.Floor')}}</th>
                                    <th>{{trans('admin.Flat')}}</th>
                                    <th>{{trans('admin.Special_Mark')}}</th>
                                    <th>{{trans('admin.Other_Phone')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{$item->Address_Name}}</td>
                                    <td>{{$item->Country}}</td>
                                    <td>{{$item->Governrate}}</td>
                                    <td>{{$item->City}}</td>
                                    <td>{{$item->Address}}</td>
                                    <td>{{$item->Street}}</td>
                                    <td>{{$item->Buliding_Num}}</td>
                                    <td>{{$item->Floor}}</td>
                                    <td>{{$item->Flat}}</td>
                                    <td>{{$item->Spcial}}</td>
                                    <td>{{$item->Other_Phone}}</td>
                                </tr>
                            </tbody>
                            </table>
        </div>
        <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

        </div>
    </div>
    </div>
</div>

     <!-- Modal Details -->
   <div class="modal fade" id="Details{{$item->id}}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl">
    <div class="modal-content">
        <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">{{trans('admin.Details')}}</h5>
        <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close">
        </button>
        </div>
        <div class="modal-body">
            @php  $prods=ProductOrders::where('Order',$item->id)->get(); @endphp
   <table class="table table-bordered">
                            <thead class="thead-dark">
                                <tr>
                                    <th>{{trans('admin.Name')}}</th>
                                    <th>{{trans('admin.Image')}}</th>
                                    <th>{{trans('admin.Qty')}}</th>
                                    <th>{{trans('admin.Price')}}</th>
                                    <th>{{trans('admin.Total')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($prods as $pro)
                                <tr>
                                    <td>
                                                                         {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}

     @if(!empty($detail->V1))   ({{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}}  )  @endif
                                  @if(!empty($detail->V2))    (({{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}}  ))  @endif

                                    </td>
                                    <td>
                                        <div class="text-center">
                                        <img src="{{URL::to($pro->Product()->first()->Image)}}" class="img">
                                        </div>
                                    </td>
                                    <td>{{$pro->Qty}}</td>
                                    <td>{{$pro->Price}}</td>
                                    <td>{{$pro->Total}}</td>
                                </tr>
                            @endforeach
                                      <tr style="background-color: black; color: white">
                                    <th>{{trans('admin.Product_Numbers')}}</th>
                                    <th>{{trans('admin.Total_Qty')}}</th>
                                    <th>{{trans('admin.Sub_Total')}}</th>
                                    <th>{{trans('admin.Cupon_Code')}}</th>
                                    <th>{{trans('admin.Total_Price')}}</th>
                                    </tr>
                                   <tr>
                                <td>{{$item->Product_Numbers}}</td>
                                <td>{{$item->Total_Qty}}</td>
                                <td>{{$item->Total_Price + $item->Cupon}}</td>
                                <td>{{$item->Cupon}}</td>
                                <td>{{$item->Total_Price}}</td>
                                  </tr>
                            </tbody>
                            </table>
        </div>
        <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

        </div>
    </div>
    </div>
</div>


                              <!-- Modal Status -->
<div class="modal fade" id="Status{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">

                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                            <form action="{{url('ChangeStatus/'.$item->id)}}" method="post">
                                {!! csrf_field() !!}
                            <div class="modal-body">
                               <select class="form-control" name="Status" required>
                                <option value="">{{trans('admin.Status')}}</option>
                                <option value="0" @if($item->Status == 0) selected @endif>{{trans('admin.Pending')}}</option>
                                <option value="1" @if($item->Status == 1) selected @endif>{{trans('admin.On_Processing')}}</option>
                                </select>
                                </div>
                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                   <button type="submit"  class="btn btn-primary"> {{trans('admin.SaveChanges')}}</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>



        @endforeach
                </main>

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
   <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
@endpush

