    @extends('admin.index')
@section('content')
    @php
use App\Models\CompanyData;
use App\Models\ProductUnits;
$Def=CompanyData::orderBy('id','desc')->first();
use App\Models\StoresDefaultData;
$DefStore=StoresDefaultData::orderBy('id','desc')->first();
@endphp
<title>{{trans('admin.BarcodeـPrinting')}}</title>
<main id="js-page-content" role="main" class="page-content">
   <ol class="breadcrumb page-breadcrumb no-print">
      <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Stores')}}</a></li>
      <li class="breadcrumb-item active">{{trans('admin.BarcodeـPrinting')}}</li>
      <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
         class="js-get-date"></span></li>
   </ol>
   <!-- data entry -->
   <div class="row">
      <div class="col-lg-12">
         <div id="panel-2" class="panel">
            <div class="panel-hdr  no-print">
               <h2>
                  <span class="fw-300"><i>    {{trans('admin.BarcodeـPrinting')}} </i></span>
               </h2>
            </div>
            <div class="panel-container show">
               <div class="panel-content">
                  <form action="{{url('UpdateBarcodePrint')}}" method="post" class="form-row  no-print">
                     {!! csrf_field() !!}
                     <div class="form-group col-lg-12">
                        <div class="input-items">
                           <input type="text" id="search" class="form-control" placeholder="{{trans('admin.Search_For_Products')}}">
                           <i class="fal fa-barcode-alt"></i>
                        </div>
                     </div>
                     <table  id="dt" 
                        class="table table-bordered table-hover table-striped w-100">
                        <thead>
                           <tr>
                              <th> {{trans('admin.Name')}}</th>
                              <th> {{trans('admin.Unit')}}</th>
                              <th> {{trans('admin.Code')}}</th>
                              <th> {{trans('admin.Qty')}}</th>
                              <th> {{trans('admin.Actions')}}</th>
                           </tr>
                        </thead>
                        <tbody class="Data">
              
                        </tbody>
                     </table>
                     <!-- datatable start -->
                     <table 
                        class="table table-bordered table-hover table-striped w-100">
                        <thead>
                           <tr>
                              <th> {{trans('admin.Name')}}</th>
                              <th> {{trans('admin.Unit')}}</th>
                              <th> {{trans('admin.Code')}}</th>
                              <th> {{trans('admin.Qty')}}</th>
                              <th> {{trans('admin.Actions')}}</th>
                           </tr>
                        </thead>
                        <tbody id="data-dt">
                                 @foreach($Pros as $pro)                   
                           <tr>
                              <td>
                                 <input type='hidden' name='P_Ar_Name[]' value='{{$pro->Name}}'>
                                 {{app()->getLocale() == 'ar' ?$pro->Product()->first()->P_Ar_Name :$pro->Product()->first()->P_En_Name}}     
                                 @if(!empty($pro->V1))    
                                  ( {{app()->getLocale() == 'ar' ?$pro->V1()->first()->Name :$pro->V1()->first()->NameEn}} )
                                 @endif 
                                 @if(!empty($pro->V2))    
                             ( {{app()->getLocale() == 'ar' ?$pro->V2()->first()->Name :$pro->V2()->first()->NameEn}} )
                                 @endif            
                              </td>
                              <td><input type='hidden' name='Unit[]' value='{{$pro->Unit}}'>
                         {{app()->getLocale() == 'ar' ?$pro->Unit()->first()->Name :$pro->Unit()->first()->NameEn}}         
                               </td>
                              <td><input type='hidden' name='P_Code[]' value='{{$pro->Code}}'>{{$pro->Code}}</td>
                              <td><input type='hidden' name='Qty[]' value='{{$pro->Qty}}'>{{$pro->Qty}}</td>
                              <td>
                                 <button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input id='Product_IDInp"+r+"' type='hidden' name='Product[]' value='{{$pro->Product}}'>
                                 <input type='hidden' name='Price[]' value='{{$pro->Price}}'>
                                 <input type='hidden' name='Group[]' value='{{$pro->Group}}'>
                                 <input type='hidden' name='Vone[]' value='{{$pro->V1}}'>
                                 <input type='hidden' name='Vtwo[]' value='{{$pro->V2}}'>
                              </td>
                           </tr>
                           @endforeach           
                        </tbody>
                     </table>
                     <div class="form-group col-md-12">
                        <label class="form-label" for=""> {{trans('admin.Style')}}</label>
                        <select class="select2 form-control w-100" name="Style" required>
                           <option value="">{{trans('admin.Style')}}</option>
                           @foreach($Settings as $sett)    
                           <option value="{{$sett->id}}" @if($sett->id == $Set->id)  selected  @endif>
                         {{app()->getLocale() == 'ar' ?$sett->Name :$sett->NameEn}}              
                            </option>
                           @endforeach    
                        </select>
                     </div>
                     <div class="form-group col-md-12">
                        <label class="form-label" for="multiple-label">
                        {{trans('admin.Show_in_Print')}}
                        </label>
                        <select class="select2 form-control" multiple="multiple" id="multiple-label" name="Show[]">
                           <optgroup label="Mountain Time Zone">
                              <option value="CompanyName" @if($Show->Company_Name == 1) selected @endif> {{trans('admin.Company_Name')}} </option>
                              <option value="ProductName"  @if($Show->Product_Name == 1) selected @endif> {{trans('admin.Product_Name')}} </option>
                              <option value="ProductPrice"  @if($Show->Product_Price == 1) selected @endif> {{trans('admin.Product_Price')}} </option>
                              <option value="Coin"  @if($Show->Coin == 1) selected @endif> {{trans('admin.Coin')}} </option>
                              <option value="Unit"  @if($Show->Unit == 1) selected @endif> {{trans('admin.Unit')}} </option>
                              <option value="Group"  @if($Show->Group == 1) selected @endif> {{trans('admin.Group')}} </option>
                              <option value="Code"  @if($Show->Code == 1) selected @endif> {{trans('admin.Code')}} </option>
                              <option value="Logo"  @if($Show->Logo == 1) selected @endif> {{trans('admin.Logo')}} </option>
                           </optgroup>
                        </select>
                     </div>
                     <div class="form-group col-md-2">
                        <div class="buttons m-4">
                           <button type="submit" class="btn btn-primary show-table w-100">{{trans('admin.Update')}}  </button>
                        </div>
                     </div>
                  </form>
                  <div class="row">
                     <div class="col-md-12">
                        <div class="buttons">
                           <a class="btn btn-primary w-100" href="#" onclick="window.print()"> <i class="fal fa-print"></i> {{trans('admin.Print')}}</a>
                        </div>
                     </div>
                  </div>
                  <div  class="print only-print">
                     @foreach($Pros as $pro)  
                     @for($i=0 ; $i < $pro->Qty ; $i++)
                     <div class="print-label text-center">
                        @if($Show->Logo == 1)    

                         
                                            @if(!empty($Def->Logo))         

        <img  style="height: {{$Set->Height_Logo}}px;width: {{$Set->Width_Logo}}px;" src="{{URL::to($Def->Logo)}}"> 
                                       
                    @else  
    <img  style="height: {{$Set->Height_Logo}}px;width: {{$Set->Width_Logo}}px;" src="{{asset('Admin/img/weblogo.png')}}">
                      @endif 
                         
                         
                        @endif                
                        @if($Show->Company_Name == 1)    
                        <h3 class="site-name">
                         
                    @if(!empty($Def->Name))
                  {{app()->getLocale() == 'ar' ?$Def->Name :$Def->NameEn}}
                      @else
                       {{trans('admin.Klar')}}
                      @endif      
                         </h3>
                        @endif    
                        @if($Show->Product_Name == 1)    
                        <h4 class="product-name">
                        {{app()->getLocale() == 'ar' ?$pro->Product()->first()->P_Ar_Name :$pro->Product()->first()->P_En_Name}}     
                           @if(!empty($pro->V1))    
                              ( {{app()->getLocale() == 'ar' ?$pro->V1()->first()->Name :$pro->V1()->first()->NameEn}} )
                           @endif 
                           @if(!empty($pro->V2))    
                           ( {{app()->getLocale() == 'ar' ?$pro->V2()->first()->Name :$pro->V2()->first()->NameEn}} )
                           @endif                    
                        </h4>
                        @endif
                        @if($Show->Product_Price == 1)
                        <span class="price">
                            
                 @php  $Prooos=ProductUnits::where('Product',$pro->Product)->where('Unit',$pro->Unit)->first(); @endphp              
                            
                        {{$Prooos->Price}}
                        </span>
                        @endif
                        @if($Show->Coin == 1)
                        <span class="currencies">{{$DefStore->Coin()->first()->Symbol}}</span>
                        @endif
                        @if($Show->Unit == 1)
                        <span class="unit">
      
                {{app()->getLocale() == 'ar' ?$pro->Unit()->first()->Name :$pro->Unit()->first()->NameEn}}            
                        </span>
                        @endif
                        @if($Show->Group == 1)
                        <span class="variants">
                     {{app()->getLocale() == 'ar' ?$pro->Product()->first()->Group()->first()->Name :$pro->Product()->first()->Group()->first()->NameEn}}    
                        </span>
                        @endif
                        @php
                        $x=$pro->Code;
                        $y=DNS1D::getBarcodePNG($x, 'C39');                                       
                        @endphp                                                          
                        <img src="data:image/png;base64,{{$y}}" alt="" class="d-block img-fluid check-promotional-price">
                        @if($Show->Code == 1)    
                        <span class="variants">
                        {{$pro->Code}}      
                        </span>
                        @endif                
                     </div>
                     @endfor
                     @endforeach
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</main>
@endsection
@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
@if($Set->Type == 1)   
@if($Set->Direction == 1)   
<!-- A4 Portarit -->
<style>
   
  
   .print{
     
       overflow:auto !important;
   }
    
   
   
   @media print{
   @page {
   size: a4;
   margin: 0;
   }
   .no-print{
   display: none;
   }
   
   .print{
       page-break-after:always;
       overflow:unset !important;
   }
   
   .only-print{
   display: block!important;
   }
   }
   /* print A4 */
   .print{
   width: 20.95cm;
   height: 29.46cm;
   display: block;
   border: 1px solid #CCC; 
   margin: 0.26cm auto; 
   padding: 0.254cm 0 0 0.254cm; 
   page-break-after:always; 
   overflow:auto;
   }
   /* print A4 portrit label */
   .print-label{
   border: 1px solid #0000003d;
   border-style: dotted;  
   width: {{$Set->Width}}cm; 
   height: {{$Set->Height}}cm; 
   margin-left: {{$Set->Margin_L}}cm; 
   margin-right: {{$Set->Margin_R}}cm;
   margin-top: {{$Set->Margin_T}}cm;
   margin-bottom: {{$Set->Margin_B}}cm; 
   padding-top: {{$Set->Padding_T}}cm; 
   padding-left: {{$Set->Padding_L}}cm; 
   padding-right: {{$Set->Padding_R}}cm; 
   padding-bottom: {{$Set->Padding_B}}cm; 
   font-size: {{$Set->Font_Size}}px; 
   line-height: {{$Set->Line_Height}}px; 
   display: inline-block;
   }
   .print-label .d-block{
   height: {{$Set->Barcode_Height}}cm;
   width: {{$Set->Barcode_Width}}cm;
   margin: auto;
   margin-top: {{$Set->Margin_T}}cm;
   margin-bottom: {{$Set->Margin_B}}cm; 
   }
</style>
@else
<!-- A4 Landscape -->
<style>
   @media print{
   @page {
   size: a4;
   margin: 0;
   }
   .no-print{
   display: none;
   }
   .only-print{
   display: block!important;
   }
   }
   /* print A4 */
   .print{
   width: 20.95cm;
   height: 29.46cm;
   display: block;
   border: 1px solid #CCC; 
   margin: 0.26cm auto; 
   padding: 0.254cm 0 0 0.254cm; 
   page-break-after:always; 
   }
   /* print A4 landscape label */
   .print-label{
   border: 1px solid #0000003d;
   border-style: dotted;  
   width: {{$Set->Width}}cm; 
   height: {{$Set->Height}}cm; 
   margin-left: {{$Set->Margin_L}}cm; 
   margin-right: {{$Set->Margin_R}}cm;
   margin-top: {{$Set->Margin_T}}cm;
   margin-bottom: {{$Set->Margin_B}}cm; 
   padding-top: {{$Set->Padding_T}}cm; 
   padding-left: {{$Set->Padding_L}}cm; 
   padding-right: {{$Set->Padding_R}}cm; 
   padding-bottom: {{$Set->Padding_B}}cm; 
   font-size: {{$Set->Font_Size}}px; 
   line-height: {{$Set->Line_Height}}px; 
   transform: rotate(90deg);
   margin-top: 28px;
   display: inline-block;
   } 
   .print-label .d-block{
   height: {{$Set->Barcode_Height}}cm;
   width: {{$Set->Barcode_Width}}cm;
   margin: auto;
   margin-top: {{$Set->Margin_T}}cm;
   margin-bottom: {{$Set->Margin_B}}cm; 
   }
</style>
@endif   
@endif
@if($Set->Type == 2)      
@if($Set->Direction == 1)    
<!-- Free Portarit -->
<style>
   @media print{
   @page {
   size: a4;
   margin: 0;
   }
   .no-print{
   display: none;
   }
   .only-print{
   display: block!important;
   }
   }
   /* free-print */
   .print{
   text-align: center;
   display: block;
   page-break-after:always; 
   } 
   /* free print portrit label */
   .print-label{
   border: 1px solid #0000003d;
   border-style: dotted;  
   width: {{$Set->Width}}cm; 
   height: {{$Set->Height}}cm; 
   padding-top: {{$Set->Padding_T}}cm; 
   padding-left: {{$Set->Padding_L}}cm; 
   padding-right: {{$Set->Padding_R}}cm; 
   padding-bottom: {{$Set->Padding_B}}cm; 
   font-size: {{$Set->Font_Size}}px; 
   line-height: {{$Set->Line_Height}}px; 
   margin-left: {{$Set->Margin_L}}cm; 
   margin-right: {{$Set->Margin_R}}cm;
   margin-top: {{$Set->Margin_T}}cm;
   margin: auto;      
   } 
   .print-label .d-block{
   height: {{$Set->Barcode_Height}}cm;
   width: {{$Set->Barcode_Width}}cm;
   margin: auto;
   margin-top: {{$Set->Margin_T}}cm;
   margin-bottom: {{$Set->Margin_B}}cm; 
   }
</style>
@else
<!-- Free Landscape -->
<style>
   @media print{
   @page {
   size: a4;
   margin: 0;
   }
   /*.print-label{*/
   /*margin: 0mm;*/
   /*}*/
   .no-print{
   display: none;
   }
   .only-print{
   display: block!important;
   }
   }
   /* free-print */
   .print{
   text-align: center;
   display: block;
   page-break-after:always; 
   } 
   /* free Print landscape label */
   .print-label{
   border: 1px solid #0000003d;
   border-style: dotted;  
   width: {{$Set->Width}}cmcm; 
   height: {{$Set->Height}}cmcm; 
   margin-left: {{$Set->Margin_L}}cmcm; 
   margin-right: {{$Set->Margin_R}}cmcm;
   margin-top: {{$Set->Margin_T}}cmcm;
   margin-bottom: {{$Set->Margin_B}}cmcm; 
   padding-top: {{$Set->Padding_T}}cmcm; 
   padding-left: {{$Set->Padding_L}}cmcm; 
   padding-right: {{$Set->Padding_R}}cmcm; 
   padding-bottom: {{$Set->Padding_B}}cmcm; 
   font-size: {{$Set->Font_Size}}px; 
   line-height: {{$Set->Line_Height}}px; 
   transform: rotate(90deg);
   margin: auto;
   margin-top: {{$Set->Margin_T}}cm;
   margin-bottom: {{$Set->Margin_B}}cm;          
   } 
   .print-label .d-block{
   height: {{$Set->Barcode_Height}}cm;
   width: {{$Set->Barcode_Width}}cm;
   margin: auto;
   margin-top: {{$Set->Margin_T}}cm;
   margin-bottom: {{$Set->Margin_B}}cm; 
   }
</style>
@endif   
@endif
<!--  Filter Products -->
<script>
   $(document).ready(function(){
   
    fetch_customer_data();
   
    function fetch_customer_data(search = '')
    {
     $.ajax({
      url:'BarcodeFilter',
      method:'GET',
      data:{search:search},
      dataType:'json',
      success:function(data)
      {
       $('.Data').html(data.table_data);
      }
     })
    }
    
   $(document).on('keyup', '#search', function(){
     var search = $(this).val();     
     fetch_customer_data(search);
    });
   
       
   });
</script>
<!-- Unit Name -->
<script>
   function  UnitNameCode(x){
   
   var countryId = $('#UnitAssem'+x).val();
   var Pro = $('#Product'+x).val();
                     if(countryId) {
                         $.ajax({
                             url: 'UnitNameCodeFilterr/'+countryId+'/'+Pro,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },
   
                             success:function(data) {
                                 $.each(data, function(key, value){
                                     
                       $('#CodeAssem'+x).val(data.code); 
                   $('#UnitNameAssem'+x).val(data.name); 
                   $('#PriceAssem'+x).val(data.price); 
                                     
   
                                 });
                                 
                                 
      var Qty = $("#Qty"+x).val();
   var Price = $("#PriceAssem"+x).val();
   var UnitID = $("#UnitAssem"+x).val();
   var Code = $("#CodeAssem"+x).val();
      
      
      if(Qty == ''  || Price == ''  ||  Code == '' || UnitID == ''){
        
       document.getElementById("AddBtnPur"+x).style.display = "none";           
    }
   
    
      if(Qty != ''  && Price != ''  &&  Code != '' && UnitID != ''){
        
       document.getElementById("AddBtnPur"+x).style.display = "block";           
    }  
           
      
      
           
        
                                 
                                 
                                 
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
                     } else {
   
                         $('select[name="state"]').empty();
                     }
   
   }   
   
   
</script>  
<!-- Sure -->
<script>
   function Sure(x) { 
       
   var Qty = $("#Qty"+x).val();
   var Price = $("#PriceAssem"+x).val();
   var UnitID = $("#UnitAssem"+x).val();
   var Code = $("#CodeAssem"+x).val();
       
       
       if(Qty == ''  || Price == ''  ||  Code == '' || UnitID == ''){
         
        document.getElementById("AddBtnPur"+x).style.display = "none";           
     }
   
     
       if(Qty != ''  && Price != ''  &&  Code != '' && UnitID != ''){
         
        document.getElementById("AddBtnPur"+x).style.display = "block";           
     }  
            
       
       
       
       
   }
</script>
<!-- Add Product -->
<script>
   function Fun(r) { 
       
             var P_Ar_Name = $("#P_Ar_Name"+r).val();
             var P_En_Name= $("#P_En_Name"+r).val();
             var Product = $("#Product"+r).val();
             var UnitID = $("#UnitAssem"+r).val();
             var UnitName = $("#UnitNameAssem"+r).val();
             var Qty = $("#Qty"+r).val();
             var Barcode = $("#CodeAssem"+r).val();
             var Price = $("#PriceAssem"+r).val();
             var Group = $("#Group"+r).val();
             var V1 = $("#VOne"+r).val();
             var V2 = $("#VTwo"+r).val();
             var V_Name = $("#V_Name"+r).val();
             var VV_Name = $("#VV_Name"+r).val();
   
         var Viro = '';
             var VViro = '';
   
       if( V_Name != ''){
           
          Viro= '(' + V_Name +')';
       }
   
       if( VV_Name != ''){
           
         VViro= '(' + VV_Name +')'; 
       }
   
             document.getElementById("AddBtnPur"+r).style.display = "none";
             document.getElementById("Row"+r).style.display = "none";
       
      
             var markup = "<tr><td><input type='hidden' name='P_Ar_Name[]' value='"+P_Ar_Name+"'><input type='hidden' name='P_En_Name[]' value='"+P_En_Name+"'>" + P_Ar_Name + ""+ Viro +" "+ VViro +"</td><td><input type='hidden' name='Unit[]' value='"+UnitID+"'>" + UnitName + "</td><td><input type='hidden' name='P_Code[]' value='"+Barcode+"'>" + Barcode + "</td><td><input type='hidden' name='Qty[]' value='"+Qty+"'>" + Qty + "</td><td><button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input id='Product_IDInp"+r+"' type='hidden' name='Product[]' value='"+Product+"'><input type='hidden' name='Price[]' value='"+Price+"'><input type='hidden' name='Group[]' value='"+Group+"'><input type='hidden' name='Vone[]' value='"+V1+"'><input type='hidden' name='Vtwo[]' value='"+V2+"'></td></tr>";
   
   
             $("#data-dt").append(markup);
      
       
      
        $('#data-dt').on('click', '#DelAssem', function(e){
                $(this).closest('tr').remove(); 
                    })  
       style="overflow:hidden"
       
     }    
</script> 
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script>
   //_fnFeatureHtmlLength();
   $(document).ready(function () {
       // Setup - add a text input to each footer cell
       $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
       $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
           var title = $(this).text();
           $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');
   
           $('input', this).on('keyup change', function () {
               if (table.column(i).search() !== this.value) {
                   table
                       .column(i)
                       .search(this.value)
                       .draw();
               }
           });
       });
       var table = $('#dt-basic-example').DataTable(
           {
               responsive: true,
               orderCellsTop: true,
               fixedHeader: true,
               lengthChange: true,
   
               dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                   "<'row'<'col-sm-12'tr>>" +
                   "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
   
               buttons: [
                   {
                       extend: 'pageLength',
                       className: 'btn-outline-default'
                   },
                   {
                       extend: 'colvis',
                       text: 'Column Visibility',
                       titleAttr: 'Col visibility',
                       className: 'btn-outline-default'
                   },
                   {
                       extend: 'pdfHtml5',
                       text: 'PDF',
                       titleAttr: 'Generate PDF',
                       className: 'btn-outline-danger btn-sm mr-1'
                   },
                   {
                       extend: 'excelHtml5',
                       text: 'Excel',
                       titleAttr: 'Generate Excel',
                       className: 'btn-outline-success btn-sm mr-1'
                   },
                   {
                       extend: 'csvHtml5',
                       text: 'CSV',
                       titleAttr: 'Generate CSV',
                       className: 'btn-outline-primary btn-sm mr-1'
                   },
                   {
                       extend: 'copyHtml5',
                       text: 'Copy',
                       titleAttr: 'Copy to clipboard',
                       className: 'btn-outline-primary btn-sm mr-1'
                   },
                   {
                       extend: 'print',
                       text: 'Print',
                       titleAttr: 'Print Table',
                       className: 'btn-outline-primary btn-sm'
                   }
               ],
           });
       $('.js-thead-colors a').on('click', function () {
           var theadColor = $(this).attr("data-bg");
           console.log(theadColor);
           $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
       });
   
       $('.js-tbody-colors a').on('click', function () {
           var theadColor = $(this).attr("data-bg");
           console.log(theadColor);
           $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
       });
   
   });
   
</script>
<script>
   $(document).ready(function()
   {
       $(function()
       {
           $('.select2').select2();
   
           $(".select2-placeholder-multiple").select2(
           {
               placeholder: "Select State"
           });
           $(".js-hide-search").select2(
           {
               minimumResultsForSearch: 1 / 0
           });
           $(".js-max-length").select2(
           {
               maximumSelectionLength: 2,
               placeholder: "Select maximum 2 items"
           });
           $(".select2-placeholder").select2(
           {
               placeholder: "Select a state",
               allowClear: true
           });
   
           $(".js-select2-icons").select2(
           {
               minimumResultsForSearch: 1 / 0,
               templateResult: icon,
               templateSelection: icon,
               escapeMarkup: function(elm)
               {
                   return elm
               }
           });
   
           function icon(elm)
           {
               elm.element;
               return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
           }
   
           $(".js-data-example-ajax").select2(
           {
               ajax:
               {
                   url: "https://api.github.com/search/repositories",
                   dataType: 'json',
                   delay: 250,
                   data: function(params)
                   {
                       return {
                           q: params.term, // search term
                           page: params.page
                       };
                   },
                   processResults: function(data, params)
                   {
                       // parse the results into the format expected by Select2
                       // since we are using custom formatting functions we do not need to
                       // alter the remote JSON data, except to indicate that infinite
                       // scrolling can be used
                       params.page = params.page || 1;
   
                       return {
                           results: data.items,
                           pagination:
                           {
                               more: (params.page * 30) < data.total_count
                           }
                       };
                   },
                   cache: true
               },
               placeholder: 'Search for a repository',
               escapeMarkup: function(markup)
               {
                   return markup;
               }, // let our custom formatter work
               minimumInputLength: 1,
               templateResult: formatRepo,
               templateSelection: formatRepoSelection
           });
   
           function formatRepo(repo)
           {
               if (repo.loading)
               {
                   return repo.text;
               }
   
               var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                   "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                   "<div class='select2-result-repository__meta'>" +
                   "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";
   
               if (repo.description)
               {
                   markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
               }
   
               markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                   "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                   "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                   "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                   "</div>" +
                   "</div></div>";
   
               return markup;
           }
   
           function formatRepoSelection(repo)
           {
               return repo.full_name || repo.text;
           }
       });
   });
   
</script>
<script>
   var autoSave = $('#autoSave');
   var interval;
   var timer = function()
   {
       interval = setInterval(function()
       {
           //start slide...
           if (autoSave.prop('checked'))
               saveToLocal();
   
           clearInterval(interval);
       }, 3000);
   };
   
   //save
   var saveToLocal = function()
   {
       localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
       console.log("saved");
   }
   
   //delete 
   var removeFromLocal = function()
   {
       localStorage.removeItem("summernoteData");
       $('#saveToLocal').summernote('reset');
   }
   
   $(document).ready(function()
   {
       //init default
       $('.js-summernote').summernote(
       {
           height: 200,
           tabsize: 2,
           placeholder: "Type here...",
           dialogsFade: true,
           toolbar: [
               ['style', ['style']],
               ['font', ['strikethrough', 'superscript', 'subscript']],
               ['font', ['bold', 'italic', 'underline', 'clear']],
               ['fontsize', ['fontsize']],
               ['fontname', ['fontname']],
               ['color', ['color']],
               ['para', ['ul', 'ol', 'paragraph']],
               ['height', ['height']]
               ['table', ['table']],
               ['insert', ['link', 'picture', 'video']],
               ['view', ['fullscreen', 'codeview', 'help']]
           ],
           callbacks:
           {
               //restore from localStorage
               onInit: function(e)
               {
                   $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
               },
               onChange: function(contents, $editable)
               {
                   clearInterval(interval);
                   timer();
               }
           }
       });
   
       //load emojis
       $.ajax(
       {
           url: 'https://api.github.com/emojis',
           async: false
       }).then(function(data)
       {
           window.emojis = Object.keys(data);
           window.emojiUrls = data;
       });
   
       //init emoji example
       $(".js-hint2emoji").summernote(
       {
           height: 100,
           toolbar: false,
           placeholder: 'type starting with : and any alphabet',
           hint:
           {
               match: /:([\-+\w]+)$/,
               search: function(keyword, callback)
               {
                   callback($.grep(emojis, function(item)
                   {
                       return item.indexOf(keyword) === 0;
                   }));
               },
               template: function(item)
               {
                   var content = emojiUrls[item];
                   return '<img src="' + content + '" width="20" /> :' + item + ':';
               },
               content: function(item)
               {
                   var url = emojiUrls[item];
                   if (url)
                   {
                       return $('<img />').attr('src', url).css('width', 20)[0];
                   }
                   return '';
               }
           }
       });
   
       //init mentions example
       $(".js-hint2mention").summernote(
       {
           height: 100,
           toolbar: false,
           placeholder: "type starting with @",
           hint:
           {
               mentions: ['jayden', 'sam', 'alvin', 'david'],
               match: /\B@(\w*)$/,
               search: function(keyword, callback)
               {
                   callback($.grep(this.mentions, function(item)
                   {
                       return item.indexOf(keyword) == 0;
                   }));
               },
               content: function(item)
               {
                   return '@' + item;
               }
           }
       });
   
   });
   
</script>
<script type="text/javascript">
   $(".show-table").click(function(){
       $(".hide-table").show();
   });
   
</script>
<style>
   th{
   width:135px!important;
   }
</style>
    
<script>
       $('#data-dt').on('click', '#DelAssem', function(e){
                $(this).closest('tr').remove(); 
                    })  
    </script>    
@endpush