@extends('admin.index')
@section('content')
@php
use App\Models\ProductsStoresTransfers;
use App\Models\DefaultDataShowHide;
$show=DefaultDataShowHide::orderBy('id','desc')->first();
@endphp
  <title>{{trans('admin.Stores_Transfers_Sechdule')}}</title>


     <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Stores')}}</a></li>
                        <li class="breadcrumb-item active"> {{trans('admin.Stores_Transfers_Sechdule')}} </li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>




         <!-- Filter -->
         <div class="row">
             <div class="col-lg-12">
                 <div id="panel-2" class="panel first-color">
                     <div class="panel-hdr">
                         <h2>
                             <span class="fw-300"><i> {{trans('admin.Stores_Transfers_Sechdule')}} </i></span>
                         </h2>
                     </div>
                     <div class="panel-container show">
                         <div class="panel-content">
                             <form action="{{url('FilterStoresTransfersSechdule')}}" method="get" class="form-row">
                                 <div class="form-group col-md-2">
                                     <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label>
                                     <input type="date" name="From" value="{{date('Y-m-d')}}" class="form-control"
                                            required>
                                 </div>
                                 <div class="form-group col-md-2">
                                     <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label>
                                     <input type="date" name="To" value="{{date('Y-m-d')}}" class="form-control"
                                            required>
                                 </div>
                                 <div class="form-group col-md-2">
                                     <label class="form-label" for=""> {{trans('admin.From_Store')}} </label>
                                     <select class="select2 form-control w-100" name="From_Store">
                                         <option value=""> {{trans('admin.Store')}}</option>
                                         @foreach($Stores as $stor)
                                             <option value="{{$stor->id}}">
                                                 {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                             </option>
                                         @endforeach
                                     </select>
                                 </div>
                                 <div class="form-group col-md-2">
                                     <label class="form-label" for=""> {{trans('admin.To_Store')}} </label>
                                     <select class="select2 form-control w-100" name="To_Store">
                                         <option value=""> {{trans('admin.Store')}}</option>
                                         @foreach($Stores as $stor)
                                             <option value="{{$stor->id}}">
                                                 {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                             </option>
                                         @endforeach
                                     </select>
                                 </div>
           <div class="form-group col-md-2">
                                     <label class="form-label" for=""> {{trans('admin.Status')}} </label>
                                     <select class="select2 form-control w-100" name="Status">
                                         <option value=""> {{trans('admin.Status')}}</option>
                                         <option value="0"> {{trans('admin.Pending')}}</option>
                                         <option value="1"> {{trans('admin.Sured')}}</option>
                                         <option value="2"> {{trans('admin.Refused')}}</option>

                                     </select>
                                 </div>


                                 <div class="form-group col-md-2">
                                     <div class="buttons mt-4">
                                         <button type="submit" class="btn btn-primary show-table w-100"><i
                                                 class="fal fa-folder"></i> {{trans('admin.Show')}}</button>
                                     </div>
                                 </div>

                             </form>
                         </div>
                     </div>
                 </div>
             </div>
         </div>

                    <!-- data entry -->

                    <div class="row hide-table">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                    {{trans('admin.Stores_Transfers_Sechdule')}}
                                    </h2>

                                    <div class="panel-toolbar">
                                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                                            Style</button>
                                        @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                                                     <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">

                                        <!-- datatable start -->
                                        <div style="overflow:auto;">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped" >
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.From_Store')}}</th>
                                                    <th>{{trans('admin.To_Store')}}</th>
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($items as $item)
                                                   <tr @if($item->Edit_t == 1) class="edited" @elseif($item->Delete == 1) class="deleted" @elseif($item->Status == 1) style="background-color: #7f7fff;color: white" @elseif($item->Status == 2) style="background-color: red;color: white" @elseif($item->Edit == 1) style="background-color: orange;color: white" @endif >

                                                    <td>{{$item->Code}}</td>
                                                    <td>{{$item->Date}}</td>

                                                    <td>

                                                      {{app()->getLocale() == 'ar' ?$item->From_Store()->first()->Name :$item->From_Store()->first()->NameEn}}
                                                        </td>
                                                    <td>

                                         {{app()->getLocale() == 'ar' ?$item->To_Store()->first()->Name :$item->To_Store()->first()->NameEn}}
                                                        </td>


                                                    <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Details{{$item->id}}">
                                                            {{trans('admin.Details')}}
                                                        </button>
                                                    </td>


                                                                  <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Data{{$item->id}}">
                                                            {{trans('admin.Data')}}
                                                        </button>
                                                    </td>

                                                                              <td>


                                                                                  @if($item->Edit_t == 0 and $item->Delete == 0)

                                   <a href="{{url('StoresTransferPrint/'.$item->id)}}" class="btn btn-default" >
                                                    <i class="fal fa-print"></i>
                                                    </a>
                                                            @if($item->Status == 0)
                                                                @can('تأكيد تحويل مخازن')
                                               <a href="{{url('TransferSure/'.$item->id)}}" class="btn btn-default">
                                                            {{trans('admin.Transfer_Sure')}}
                                                        </a>
                                                                                      @endcan

                                                    @can('رفض تحويل مخازن')
                                                 <a href="{{url('RefusedStoreTransfer/'.$item->id)}}" class="btn btn-default">
                                                            <i class="fal fa-times"></i>
                                                        </a>
                                                    @endcan

                                                                                   @can('تعديل تحويل مخازن')
                                                     <a href="{{url('EditStoreTransfer/'.$item->id)}}" class="btn btn-default">
                                                          <i class="fal fa-edit"></i>
                                                        </a>
                                                                @endcan


                                                                    @can('حذف تحويل مخازن')
                                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                                                                    @endcan


                                                            @endif

                                                        @if($item->Status == 1)
                                                        @if(!empty($item->Ship))
                                                        @if($item->RecivedShip == 0)

                                               <a href="{{url('ShippingTransferRecived/'.$item->id)}}" class="btn btn-default">
                                                            {{trans('admin.ShippingTransferRecived')}}
                                                        </a>
                                                            @endif
                                                            @endif
                                                            @endif


                                                            @endif

                                                                                      @if($item->Edit_t == 1)
                                                                                          <span class="btn btn-warning">{{trans('admin.Edited_to_New_One')}} ({{$item->Edit_New_Code}})</span>
                                                                                      @elseif($item->Delete == 1)

                                                                                          <span class="btn btn-danger">{{trans('admin.Deleted')}}</span>

                                                                                      @endif



                                                    </td>

                                                </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                   <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.From_Store')}}</th>
                                                    <th>{{trans('admin.To_Store')}}</th>
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>

                                        </table>
                                     {{$items->Links()}}
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>

  @foreach($items as $item)

       <!-- Modal Details -->
        <div class="modal fade" id="Details{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                               {{trans('admin.Details')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                        <div class="mt-3">
                            <div id="mobile-overflow">
                            <table id="" class="table table-bordered table-hover table-striped w-100 mobile-width">

                            <thead>
                                <tr>
                                     <th>{{trans('admin.Name')}} </th>
                                     <th>{{trans('admin.Group')}} </th>
                                     <th>{{trans('admin.Brand')}} </th>
                                    <th>{{trans('admin.P_Code')}} </th>

                                     @if(auth()->guard('admin')->user()->emp != 0)

                                                @if(auth()->guard('admin')->user()->cost_price  == 1)
                                                      <th> {{trans('admin.Price')}}</th>
                                                @endif

                                            @else
                                        @can('السعر في تحويلات المخازن')
                                                <th> {{trans('admin.Price')}}</th>
                                            @endcan
                                            @endif
                                    <th>{{trans('admin.Trans_Qty')}} </th>
                                    <th>{{trans('admin.Unit')}} </th>


                                     @if(auth()->guard('admin')->user()->emp != 0)

                                                @if(auth()->guard('admin')->user()->cost_price  == 1)
                                                     <th>{{trans('admin.Total')}} </th>
                                                @endif

                                            @else
                                        @can('السعر في تحويلات المخازن')
                                            <th>{{trans('admin.Total')}} </th>
                                            @endcan
                                            @endif
                                </tr>
                            </thead>
                                    @php
                                $Pros=ProductsStoresTransfers::where('ST_ID',$item->id)->get();
                                    @endphp
                            <tbody id="">

                            @foreach($Pros as $pro)
                                <tr>
                                    <td>


                                   {{app()->getLocale() == 'ar' ?$pro->Product()->first()->P_Ar_Name :$pro->Product()->first()->P_En_Name}}

                                        @if(!empty($pro->V1))
                             ({{app()->getLocale() == 'ar' ?$pro->V1()->first()->Name :$pro->V1()->first()->NameEn}})
                                        @endif
                        @if(!empty($pro->V2))    ({{app()->getLocale() == 'ar' ?$pro->V2()->first()->Name :$pro->V2()->first()->NameEn}})  @endif
                                    </td>
                                    <td>
                    @if(!empty($pro->Product()->first()->Group))


                 {{app()->getLocale() == 'ar' ?$pro->Product()->first()->Group()->first()->Name :$pro->Product()->first()->Group()->first()->NameEn}}
                    @endif
                                    </td>
                                                           <td>
                    @if(!empty($pro->Product()->first()->Brand))


             {{app()->getLocale() == 'ar' ?$pro->Product()->first()->Brand()->first()->Name :$pro->Product()->first()->Brand()->first()->NameEn}}
                    @endif
                                    </td>
                                    <td>{{$pro->P_Code}}</td>


                                            @if(auth()->guard('admin')->user()->emp != 0)

                                                @if(auth()->guard('admin')->user()->cost_price  == 1)
                                                        <td>{{$pro->Price}}</td>
                                                @endif

                                            @else
                                        @can('السعر في تحويلات المخازن')
                                                         <td>{{$pro->Price}}</td>
                                            @endcan
                                            @endif

                                     <td>{{$pro->Trans_Qty}}</td>
                                       <td>
                                  {{app()->getLocale() == 'ar' ?$pro->Unit()->first()->Name :$pro->Unit()->first()->NameEn}}
                                    </td>
                                                            @if(auth()->guard('admin')->user()->emp != 0)

                                                @if(auth()->guard('admin')->user()->cost_price  == 1)
                                                       <td>{{$pro->Total}}</td>
                                                @endif

                                            @else
                                        @can('السعر في تحويلات المخازن')
                                                <td>{{$pro->Total}}</td>
                                            @endcan
                                            @endif
                                </tr>
                        @endforeach
                            </tbody>

                        </table>
                         </div>
                             <table id="" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>


                                          @if(auth()->guard('admin')->user()->emp != 0)

                                                @if(auth()->guard('admin')->user()->cost_price  == 1)
                                              <th>{{trans('admin.Total_Price_Trans_Qty')}} </th>
                                                @endif

                                            @else
                                        @can('السعر في تحويلات المخازن')
                                         <th>{{trans('admin.Total_Price_Trans_Qty')}} </th>
                                            @endcan
                                            @endif

                                    <th>{{trans('admin.Total_Trans_Qty')}} </th>

                                </tr>
                            </thead>

                            <tbody id="">
                                <tr>


                                              @if(auth()->guard('admin')->user()->emp != 0)

                                                @if(auth()->guard('admin')->user()->cost_price  == 1)
                                                  <td>{{$item->Total}}</td>
                                                @endif

                                            @else
                                             <td>{{$item->Total}}</td>
                                            @endif




                                     <td>{{$item->TotalQty}}</td>
                                </tr>
                            </tbody>

                        </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>
            </div>


<!-- Modal Delete -->
<div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h4 class="modal-title">
               {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
            </h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true"><i class="fal fa-times"></i></span>
            </button>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
            <a href="{{url('DeleteStoresTransfer/'.$item->id)}}" class="btn btn-primary">{{trans('admin.Yes')}}</a>
         </div>
      </div>
   </div>
</div>



       <!-- Modal Data -->
        <div class="modal fade" id="Data{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                               {{trans('admin.Data')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                        <div class="mt-3">
                            <div id="mobile-overflow">
                            <table id="" class="table table-bordered table-hover table-striped w-100 mobile-width">

                            <thead>
                                <tr>
                          <th>{{trans('admin.Draw')}}</th>
                                                    <th>{{trans('admin.Notes')}}</th>
         <th>{{trans('admin.Coin')}}</th>
<th>{{trans('admin.Shipping_Compaines')}}</th>
                                                    <th>{{trans('admin.User')}}</th>
                                                         <th>{{trans('admin.Delegate')}}</th>
                                                         <th>{{trans('admin.Branch')}}</th>
                                                         <th>{{trans('admin.File')}}</th>
                                </tr>
                            </thead>

                            <tbody id="">


                                <tr>

                               <td>{{$item->Draw}}</td>
                                                    <td>{{$item->Note}}</td>
  <td>
                  {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}
                                    </td>
                                                    <td>
                                                        @if(!empty($item->Ship))


        {{app()->getLocale() == 'ar' ?$item->Ship()->first()->Name :$item->Ship()->first()->NameEn}}
                                                    @endif
                                                    </td>


                                                    <td>
                                            {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                                    </td>
                                                        <td>
                                                        @if(!empty($item->Delegate))

                                               {{app()->getLocale() == 'ar' ?$item->Delegate()->first()->Name :$item->Delegate()->first()->NameEn}}
                                                      @endif
                                                    </td>
                                                                      <td>
                                                        @if(!empty($item->Branch))

                                      {{app()->getLocale() == 'ar' ?$item->Branch()->first()->Arabic_Name :$item->Branch()->first()->English_Name}}
                                                      @endif
                                                    </td>

                                                      <td>
                                @if(!empty($item->File))
                            <a href="{{URL::to($item->File)}}" class="btn btn-primary" dowmload><i class="fal fa-download"></i></a>
                                        @endif
                                    </td>

                                </tr>

                            </tbody>

                        </table>
                         </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>
            </div>


@endforeach



@endsection


@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">


    <style>
        th{
            width:135px!important;
        }
    </style>

 <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' +'" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

  <script>
    $(document).ready(function()
    {
        $(function()
        {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2(
            {
                placeholder: "Select State"
            });
            $(".js-hide-search").select2(
            {
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2(
            {
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2(
            {
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2(
            {
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm)
                {
                    return elm
                }
            });

            function icon(elm)
            {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }

            $(".js-data-example-ajax").select2(
            {
                ajax:
                {
                    url: "https://api.github.com/search/repositories",
                    dataType: 'json',
                    delay: 250,
                    data: function(params)
                    {
                        return {
                            q: params.term, // search term
                            page: params.page
                        };
                    },
                    processResults: function(data, params)
                    {
                        // parse the results into the format expected by Select2
                        // since we are using custom formatting functions we do not need to
                        // alter the remote JSON data, except to indicate that infinite
                        // scrolling can be used
                        params.page = params.page || 1;

                        return {
                            results: data.items,
                            pagination:
                            {
                                more: (params.page * 30) < data.total_count
                            }
                        };
                    },
                    cache: true
                },
                placeholder: 'Search for a repository',
                escapeMarkup: function(markup)
                {
                    return markup;
                }, // let our custom formatter work
                minimumInputLength: 1,
                templateResult: formatRepo,
                templateSelection: formatRepoSelection
            });

            function formatRepo(repo)
            {
                if (repo.loading)
                {
                    return repo.text;
                }

                var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                    "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                    "<div class='select2-result-repository__meta'>" +
                    "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

                if (repo.description)
                {
                    markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                }

                markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                    "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                    "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                    "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                    "</div>" +
                    "</div></div>";

                return markup;
            }

            function formatRepoSelection(repo)
            {
                return repo.full_name || repo.text;
            }
        });
    });

</script>
<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function()
    {
        interval = setInterval(function()
        {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function()
    {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete
    var removeFromLocal = function()
    {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function()
    {
        //init default
        $('.js-summernote').summernote(
        {
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks:
            {
                //restore from localStorage
                onInit: function(e)
                {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable)
                {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax(
        {
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data)
        {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint:
            {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(emojis, function(item)
                    {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item)
                {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item)
                {
                    var url = emojiUrls[item];
                    if (url)
                    {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint:
            {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(this.mentions, function(item)
                    {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item)
                {
                    return '@' + item;
                }
            }
        });

    });

</script>
<script type="text/javascript">


    $(".show-table").click(function(){
        $(".hide-table").show();
    });

</script>
@endpush
