@extends('admin.index')
@section('content')


<title>{{trans('admin.Edit_Items')}}</title>
<style>
/* Style for all inputs and selects */
input, select, textarea {
    border: 1px solid #ccc;
    border-radius: 10px;
    padding: 10px 15px;
    font-size: 14px;
    transition: all 0.3s ease;
    outline: none;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    width: 100%;
}

/* Focus effect */
input:focus, select:focus, textarea:focus {
    border-color: #2A7F7A; /* لون رابح */
    box-shadow: 0 4px 12px rgba(42,127,122,0.3);
    transform: translateY(-2px);
}

/* Placeholder style */
::placeholder {
    color: #999;
    opacity: 1;
}

/* Select arrow color fix */
select {
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
    background: #fff url("data:image/svg+xml;utf8,<svg fill='%23999' height='24' viewBox='0 0 24 24' width='24' xmlns='http://www.w3.org/2000/svg'><path d='M7 10l5 5 5-5z'/></svg>") no-repeat right 10px center;
    background-size: 16px;
    padding-right: 35px;
}

/* Smooth hover effect */
input:hover, select:hover, textarea:hover {
    box-shadow: 0 4px 10px rgba(42,127,122,0.15);
}
.nav-tabs {
    border-bottom: none;
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    padding: 5px;
}

.nav-tabs .nav-item {
    margin-bottom: -1px;
}

.nav-tabs .nav-link {
    color: #333;
    font-weight: 600;
    border: none;
    border-radius: 10px;
    padding: 10px 20px;
    position: relative;
    transition: all 0.3s ease;
}

/* Hover general */
.nav-tabs .nav-link:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

/* Active tab */
.nav-tabs .nav-link.active {
    color: #fff;
    box-shadow: 0 8px 20px rgba(0,0,0,0.2);
}

/* Individual colors */
.nav-link.active[data-toggle="tab"][href="#tab_borders_icons-1"] {
    background: #2A7F7A; /* Main Data */
}
.nav-link.active[data-toggle="tab"][href="#tab_borders_icons-2"] {
    background: #FF9F43; /* Sub Data */
}
.nav-link.active[data-toggle="tab"][href="#tab_borders_icons-3"] {
    background: #1E90FF; /* Additions */
}

/* Icon animation */
.nav-tabs .nav-link i {
    transition: transform 0.3s ease, color 0.3s ease;
}

.nav-tabs .nav-link:hover i {
    transform: rotate(20deg) scale(1.2);
    color: inherit;
}

/* Tab content fade animation */
.tab-content .tab-pane {
    animation: fadeIn 0.5s ease-in-out;
}

@keyframes fadeIn {
    from {opacity: 0; transform: translateY(10px);}
    to {opacity: 1; transform: translateY(0);}
}
/* Container Shadow & Rounded */
.nav-tabs {
    border-bottom: none;
    background: #ffffff;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    padding: 5px;
}

/* Tab Item Style */
.nav-tabs .nav-item {
    margin-bottom: -1px;
}

/* Tab Link Style */
.nav-tabs .nav-link {
    color: #333;
    font-weight: 600;
    border: none;
    border-radius: 10px;
    padding: 10px 20px;
    position: relative;
    transition: all 0.3s ease;
}

/* Hover Effect */
.nav-tabs .nav-link:hover {
    background: #2A7F7A33; /* لون خفيف ورابي */
    color: #2A7F7A;
    transform: translateY(-3px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

/* Active Tab */
.nav-tabs .nav-link.active {
    background: #2A7F7A;
    color: #fff;
    box-shadow: 0 8px 20px rgba(0,0,0,0.2);
}

/* Icon spacing */
.nav-tabs .nav-link i {
    transition: transform 0.3s ease;
}

/* Animate icon on hover */
.nav-tabs .nav-link:hover i {
    transform: rotate(20deg);
}

/* Tab content fade animation */
.tab-content .tab-pane {
    animation: fadeIn 0.5s ease-in-out;
}

@keyframes fadeIn {
    from {opacity: 0; transform: translateY(10px);}
    to {opacity: 1; transform: translateY(0);}
}
    #dvPreview,
    #dvPreview2 {
        filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(sizingMethod=image);
        min-height: 60px;
        min-width: 60px;
        display: none;
    }

    #dvPreview img,
    #dvPreview2 img {
        height: 100%;
        width: 100%;
    }

    .text {
        font-size: 15px;
        color: #d4a1cc;
        animation: first 2s linear 2s infinite alternate;
    }

    @keyframes first {
        from {
            font-size: 15px;
            color: #d4a1cc
        }

        to {
            font-size: 18px;
            color: orange
        }
    }

    .inputplac::placeholder {
        color: white;
    }

    .label {
        color: black !important;
    }

    .buttonPlus {
        background: white;
        color: #886ab5;
    }

    .buttonPlus:hover {
        background: #886ab5;
        color: white;
    }

    .table-color1 {
        background: #d4a1cc;
    }

    .TableColor {
        background: #1225c880;
    }

</style>
<style>
    .control-img {
        height: 110px;
        max-width: 100%;
    }

    .text {
        font-size: 15px;
        color: #d4a1cc;
        animation: first 2s linear 2s infinite alternate;
    }

    @keyframes first {
        from {
            font-size: 15px;
            color: #d4a1cc
        }

        to {
            font-size: 18px;
            color: orange
        }
    }

</style>

<main id="js-page-content" role="main" class="page-content">
    <form action="{{url('PostEditProduct/'.$item->id)}}" method="post" enctype="multipart/form-data">
        {!! csrf_field() !!}
        @honeypot
        <input type="hidden" name="Images" value="{{$item->Image}}">
        <input type="hidden" name="Images2" value="{{$item->Image2}}">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Stores')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.Edit_Items')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div class="panel">
                    <div class="panel-container show">
                        <div class="panel-content">
                            <div class="panel-container show">
                                <span id="ex"> @include('admin.layouts.messages')</span>
                                <div class="panel-content">
                                    <ul class="nav nav-tabs" role="tablist">
                                        <li class="nav-item">
                                            <a class="nav-link active" data-toggle="tab" href="#tab_borders_icons-1" role="tab"><i class="fal fa-home mr-1"></i> {{trans('admin.Main_Data')}}</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-2" role="tab"><i class="fal fa-user mr-1"></i> {{trans('admin.Sub_Data')}}</a>
                                        </li>

                                        <li class="nav-item">
                                            <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-3" role="tab"><i class="fal fa-user mr-1"></i> {{trans('admin.Additions')}}</a>
                                        </li>

                                    </ul>

                                    <div class="tab-content border border-top-0 p-3">
                                        <div class="tab-pane fade show active" id="tab_borders_icons-1" role="tabpanel">
                                            <div class="form-row">

                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="">
                                                        {{trans('admin.Product_Type')}}
                                                    </label><span class="strick">*</span>
                                                    <select class="select2 form-control w-100" id="P_Type" onchange="Assembly()" disabled>
                                                        <option value="">{{trans('admin.Product_Type')}} </option>
                                                        <option value="Completed" @if($item->P_Type == 'Completed') selected @endif>{{trans('admin.Completed')}} </option>
                                                        <option value="Raw" @if($item->P_Type == 'Raw') selected @endif>{{trans('admin.Raw')}} </option>
                                                        <option value="Service" @if($item->P_Type == 'Service') selected @endif>{{trans('admin.Service')}}</option>
                                                        <option value="Assembly" @if($item->P_Type == 'Assembly') selected @endif>{{trans('admin.Assembly')}}</option>
                                                        <option value="Industrial" @if($item->P_Type == 'Industrial') selected @endif>{{trans('admin.Industrial')}}</option>
                                                        <option value="Single_Variable" @if($item->P_Type == 'Single_Variable') selected @endif>{{trans('admin.Single_Variable')}}</option>
                                                        <option value="Duble_Variable" @if($item->P_Type == 'Duble_Variable') selected @endif>{{trans('admin.Duble_Variable')}}</option>
                                                        <option value="Serial" @if($item->P_Type == 'Serial') selected @endif>{{trans('admin.Serial')}}</option>
                                                        <option value="Subscribe" @if($item->P_Type == 'Subscribe') selected @endif>{{trans('admin.Subscribe')}}</option>
                                                        <option value="Petroll" @if($item->P_Type == 'Petroll') selected @endif>{{trans('admin.Petroll')}}</option>
                                                        <option value="Variable_Aggregate" @if($item->P_Type == 'Variable_Aggregate') selected @endif>{{trans('admin.Variable_Aggregate')}}</option>
                                                        <option value="Additions" @if($item->P_Type == 'Additions') selected @endif>{{trans('admin.Additions')}}</option>
                                                    </select>
                                                    <input type="hidden" name="P_Type" value="{{$item->P_Type}}">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Product_Ar_Name')}}
                                                    </label><span class="strick">*</span>
                                                    <input type="text" name="P_Ar_Name" value="{{$item->P_Ar_Name}}" placeholder="{{trans('admin.Product_Ar_Name')}} " class="form-control" required>
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Product_En_Name')}}</label>
                                                    <input type="text" name="P_En_Name" value="{{$item->P_En_Name}}" placeholder="{{trans('admin.Product_En_Name')}} " class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for=""> {{trans('admin.Brand')}} </label>
                                                    <select class="select2 form-control w-100" name="Brand">
                                                        <option value="">{{trans('admin.Brand')}}</option>
                                                        @foreach($Brands as $brand)
                                                        <option value="{{$brand->id}}" @if($item->Brand == $brand->id) selected @endif>

                                                            {{app()->getLocale() == 'ar' ?$brand->Name :$brand->NameEn}}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for=""> {{trans('admin.Group')}} </label><span class="strick">*</span>
                                                    <select class="select2 form-control w-100" name="Group" required>
                                                        <option value="">{{trans('admin.Group')}}</option>
                                                        @foreach($ItemsGroups as $group)
                                                        <option value="{{$group->id}}" @if($item->Group == $group->id) selected @endif>

                                                            {{app()->getLocale() == 'ar' ?$group->Name :$group->NameEn}}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                </div>



                                                              <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Cost_Pricee')}} </label>
                                                    <input type="number"  step='any' class="form-control" name="Cost_Price" value="{{$item->Cost_Price}}">
                                                </div>


                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Faveorite')}} </label>
                                                     <select class="select2 form-control w-100" name="Faveorite" >

                                                        <option value="0" @if($item->Faveorite == 0) selected @endif>{{trans('admin.No')}}</option>
                                                        <option value="1" @if($item->Faveorite == 1) selected @endif>{{trans('admin.Yes')}}</option>
                                                    </select>
                                                </div>





                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for=""> {{trans('admin.If_Offer')}} </label>
                                                    <select class="select2 form-control w-100" name="Offer">
                                                        <option value="">{{trans('admin.If_Offer')}}</option>
                                                        <option value="1" @if($item->Offer == 1) selected @endif>{{trans('admin.Yes')}}</option>
                                                        <option value="0" @if($item->Offer == 0) selected @endif>{{trans('admin.No')}}</option>
                                                    </select>
                                                </div>

                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.OfferPrice')}} </label>
                                                    <input type="number" step='any' class="form-control" name="OfferPrice" value="{{$item->OfferPrice}}">
                                                </div>



                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Offer_Start_Date')}} </label>
                                                    <input type="date" step='any' class="form-control" name="Offer_Start_Date" value="{{$item->Offer_Start_Date}}">
                                                </div>


                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Offer_End_Date')}} </label>
                                                    <input type="date" step='any' class="form-control" name="Offer_End_Date" value="{{$item->Offer_End_Date}}">
                                                </div>


                                                <div class="form-group col-md-3 mb-3">
                                                    <label class="form-label customize-input" for="imgInp"><i class="fal fa-image"></i> {{trans('admin.Image')}} </label>
                                                    <input type="file" name="Image">


                                                    @if(!empty($item->Image))
                                                    <img src="{{URL::to($item->Image)}}" class="control-img">
                                                    @endif
                                                </div>
                                                <div class="form-group col-md-3 mb-3">
                                                    <label class="form-label customize-input" for="imgInp"><i class="fal fa-image"></i> {{trans('admin.Image2')}} </label>
                                                    <input type="file" name="Image2">

                                                    @if(!empty($item->Image2))
                                                    <img src="{{URL::to($item->Image2)}}" class="control-img">
                                                    @endif
                                                </div>

                                                <div class="form-group col-md-12 mb-3" style="display: none" id="EndDate">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <label class="form-label" for="simpleinput"> {{trans('admin.Sub_Cost')}}</label>
                                                            <input type="number" step="any" name="Sub_Cost" value="{{$item->Sub_Cost}}" placeholder="{{trans('admin.Sub_Cost')}} " class="form-control">
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label class="form-label" for=""> {{trans('admin.Subscribe_Type')}} </label>
                                                            <select class="select2 form-control w-100" name="subscribe_type">
                                                                <option value="">{{trans('admin.Subscribe_Type')}}</option>
                                                                @foreach($SubscribeTypes as $sub)
                                                                <option value="{{$sub->id}}" @if($item->subscribe_type == $sub->id) selected @endif>
                                                                    {{app()->getLocale() == 'ar' ?$sub->Name :$sub->NameEn}}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                    </div>
                                                </div>

                                                <!-- Assembly -->
                                                <div id="HideAssembly" style="display: none">
                                                    <div class="form-group col-md-3 mb-3">
                                                        <div class="input-items">
                                                            <input type="text" id="search" class="form-control" placeholder="{{trans('admin.Search_For_Products')}} ">
                                                            <i class="fal fa-barcode-alt" style="margin-top: -25px;position: absolute;margin-right: 967px;"></i>
                                                        </div>
                                                    </div>


                                                    <table class="table table-bordered table-hover table-striped w-100 hide-products-table">
                                                        <thead>
                                                            <tr>
                                                                <th>{{trans('admin.Name')}}</th>
                                                                <th>{{trans('admin.Units')}}</th>
                                                                <th>{{trans('admin.Qty')}}</th>
                                                                <th>{{trans('admin.Price')}} </th>
                                                                <th>{{trans('admin.Total')}}</th>
                                                                <th>{{trans('admin.Actions')}}</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="data">


                                                        </tbody>
                                                    </table>

                                                    <table class="table table-bordered table-hover table-striped w-100 hide-products-table">
                                                        <thead>
                                                            <tr>
                                                                <th>{{trans('admin.Name')}}</th>
                                                                <th>{{trans('admin.Barcode')}}</th>
                                                                <th>{{trans('admin.Units')}}</th>
                                                                <th>{{trans('admin.Qty')}}</th>
                                                                <th>{{trans('admin.Price')}} </th>
                                                                <th>{{trans('admin.Total')}}</th>
                                                                <th>{{trans('admin.Actions')}}</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="data-dt">
                                                            @foreach($Assembls as $asi)
                                                            <tr>
                                                                <td>
                                                                    <input type='hidden' name='P_Ar_NameAssem[]' value='{{$asi->P_Ar_Name}}'>
                                                                    <input type='hidden' name='P_En_NameAssem[]' value='{{$asi->P_En_Name}}'>


                                                                    {{app()->getLocale() == 'ar' ?$asi->P_Ar_Name :$asi->P_En_Name}}
                                                                </td>
                                                                <td><input type='hidden' name='P_CodeAssem[]' value='{{$asi->P_Code}}'>{{$asi->P_Code}}</td>
                                                                <td><input type='hidden' name='UnitAssem[]' value='{{$asi->Unit}}'>
                                                                    {{app()->getLocale() == 'ar' ?$asi->Unit()->first()->Name :$asi->Unit()->first()->NameEn}}
                                                                </td>
                                                                <td><input type='hidden' name='QtyAssem[]' value='{{$asi->Qty}}'>{{$asi->Qty}}</td>
                                                                <td><input type='hidden' name='PriceAssem[]' value='{{$asi->Price}}'>{{$asi->Price}}</td>
                                                                <td><input type='hidden' name='TotalAssem[]' value='{{$asi->Total}}'>{{$asi->Total}}
                                                                    <input id='Product_IDInp{{$asi->Product}}' type='hidden' name='ProductAssem[]' value='{{$asi->Product}}'>
                                                                </td>
                                                                <td>
                                                                    <button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button>

                                                                </td>
                                                            </tr>
                                                            @endforeach


                                                        </tbody>
                                                    </table>

                                                </div>


                                            </div>

                                            <!-- Vira One -->
                                            <div id="HideViraOne" style="display: none" class="col-md-3 mb-3">
                                                <div class="form-group ">
                                                    <label class="form-label" for="">{{trans('admin.Virable')}} </label>
                                                    <select class="select2 form-control w-100" id="VOne">
                                                        <option value="">{{trans('admin.Virable')}}</option>
                                                        @foreach($Virables as $vir)


                                                        <option value="{{$vir->id}}" @foreach($ProductsVira as $pv) @if($vir->id == $pv->V1()->first()->V_ID)
                                                            selected
                                                            @endif
                                                            @endforeach
                                                            >
                                                            {{app()->getLocale() == 'ar' ?$vir->Name :$vir->NameEn}}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="padding-tables" style="display: none">
                                                    <table id="color" class="table table-bordered table-hover table-striped w-100">
                                                        <thead class="bg-highlight">
                                                            <tr>
                                                                <th>{{trans('admin.Virable')}}</th>
                                                                <th>{{trans('admin.Cost')}}</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="ViraOne">
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                            <!-- Vira Two -->
                                            <div id="HideViraTwo" style="display: none" class="col-md-6 mb-6">
                                                <div class="form-row">
                                                    <div class="form-group col-lg-6 ">
                                                        <label class="form-label" for="">{{trans('admin.Virable')}} </label>
                                                        <select class="select2 form-control w-100" id="VTwo">
                                                            <option value="">{{trans('admin.Virable')}}</option>
                                                            @foreach($Virables as $vir)
                                                            <option value="{{$vir->id}}" @foreach($ProductsVira as $pv) @if($vir->id == $pv->V1()->first()->V_ID)
                                                                selected
                                                                @endif
                                                                @endforeach
                                                                >
                                                                {{app()->getLocale() == 'ar' ?$vir->Name :$vir->NameEn}}
                                                            </option>
                                                            @endforeach
                                                        </select>
                                                    </div>

                                                    <div class="form-group col-lg-6 ">
                                                        <label class="form-label" for="">{{trans('admin.Virable')}} </label>
                                                        <select class="select2 form-control w-100" id="VTwoo">
                                                            <option value="">{{trans('admin.Virable')}}</option>
                                                            @foreach($Virables as $vir)
                                                            <option value="{{$vir->id}}" @foreach($ProductsVira as $pv) @if(!empty($pv->V2()->first()->V_ID))
                                                                @if($vir->id == $pv->V2()->first()->V_ID)
                                                                selected
                                                                @endif
                                                                @endif
                                                                @endforeach

                                                                > {{app()->getLocale() == 'ar' ?$vir->Name :$vir->NameEn}} </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="alert alert-danger" id="AlertVira" style="display: none">
                                                        {{trans('admin.Can_not_Choice_Same_Virables')}}
                                                    </div>
                                                </div>
                                                <div style="display: none">
                                                    <div class="padding-tables" id="TabV2">
                                                        <table id="variables" class="table table-bordered table-hover">
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-xl-12">
                                                    <div id="panel-1" class="panel">
                                                        <div class="panel-hdr">
                                                            <h2>
                                                                {{trans('admin.Edit_Items')}}
                                                            </h2>

                                                        </div>
                                                        <!-- Units -->
                                                        <div class="panel-container show">
                                                            <div class="panel-content">
                                                                <span class="text">{{trans('admin.ArabicCode')}}</span>
                                                                <div id="mobile-overflow">
                                                                    <table class="table table-bordered table-hover table-striped w-100 th-width mobile-width table-color1 mt-2">
                                                                        <thead>
                                                                            <tr>
                                                                                <th>{{trans('admin.Unit')}}</th>
                                                                                <th>{{trans('admin.Rate')}}</th>
                                                                                <th>{{trans('admin.Barcode')}}</th>
                                                                                <th>{{trans('admin.Price_One')}}</th>
                                                                                <th>{{trans('admin.Price_Two')}}</th>
                                                                                <th>{{trans('admin.Price_Three')}}</th>
                                                                                <th>{{trans('admin.Actions')}}</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <tr>
                                                                                <td>
                                                                                    <div class="form-group">

                                                                                        <select class="select2 form-control w-100" id="unit" onchange="PLUS()">
                                                                                            <option value="">{{trans('admin.Unit')}}</option>
                                                                                            @foreach($Units as $uni)
                                                                                            <option value="{{$uni->id}}">
                                                                                                {{app()->getLocale() == 'ar' ?$uni->Name :$uni->NameEn}}
                                                                                            </option>
                                                                                            @endforeach
                                                                                        </select>
                                                                                        <input type="hidden" id="UnitName">
                                                                                        <input type="hidden" id="UnitID">
                                                                                    </div>
                                                                                </td>
                                                                                <td>
                                                                                    <div class="form-group">
                                                                                        <input type="number" step="any" id="rate" class="form-control" onkeyup="PLUS()" onclick="PLUS()">
                                                                                    </div>
                                                                                </td>
                                                                                <td>
                                                                                    <div class="form-group" style="position:relative;">
                                                                                        <input type="text" id="code" class="form-control" onkeyup="PLUS()">
                                                                                        <i class="fal fa-barcode" onclick="Genrte()" style="position: absolute;left:3px;top:13px;"></i>
                                                                                    </div>
                                                                                </td>
                                                                                <td>
                                                                                    <div class="form-group">

                                                                                        <input type="number" step="any" id="price1" class="form-control" onkeyup="PLUS()" onclick="PLUS()">
                                                                                    </div>
                                                                                </td>
                                                                                <td>
                                                                                    <div class="form-group">

                                                                                        <input type="number" step="any" id="price2" class="form-control" onkeyup="PLUS()" onclick="PLUS()">
                                                                                    </div>
                                                                                </td>
                                                                                <td>
                                                                                    <div class="form-group">
                                                                                        <input type="number" step="any" id="price3" class="form-control" onkeyup="PLUS()" onclick="PLUS()">
                                                                                    </div>
                                                                                </td>
                                                                                <td>
                                                                                    <button type="button" onclick="InsertData()" class="btn btn-default" id="add-data" style="display: none"><i class="fal fa-plus"></i></button>
                                                                                </td>

                                                                            </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                                <!-- datatable start -->
                                                                <div id="mobile-overflow">
                                                                    <table id="samble" class="table table-bordered table-hover table-striped w-100 th-width mobile-width table-color2">
                                                                        <thead>
                                                                            <tr>
                                                                                <th>{{trans('admin.Unit')}}</th>
                                                                                <th>{{trans('admin.Rate')}}</th>
                                                                                <th>{{trans('admin.Barcode')}}</th>
                                                                                <th>{{trans('admin.Price_One')}}</th>
                                                                                <th>{{trans('admin.Price_Two')}}</th>
                                                                                <th>{{trans('admin.Price_Three')}}</th>
                                                                                <th>{{trans('admin.Default_Unit')}}</th>
                                                                                <th>{{trans('admin.Actions')}}</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody id="data-dt-first">
                                                                            @foreach($ProsUnit as $pu)
                                                                            <tr>
                                                                                <td>


                                                                                    @if(!empty($pu->Unit()->first()->Name)) {{app()->getLocale() == 'ar' ?$pu->Unit()->first()->Name :$pu->Unit()->first()->NameEn}} @endif
                                                                                    <input type="hidden" name="Rate[]" value="{{$pu->Rate}}">
                                                                                    <input type="hidden" name="Barcode[]" value="{{$pu->Barcode}}">
                                                                                    <input type="hidden" name="Price[]" value="{{$pu->Price}}">
                                                                                    <input type="hidden" name="Price_Two[]" value="{{$pu->Price_Two}}">
                                                                                    <input type="hidden" name="Price_Three[]" value="{{$pu->Price_Three}}">
                                                                                    <input type="hidden" id="U{{$pu->Unit}}" name="Unit[]" value="{{$pu->Unit}}">
                                                                                </td>
                                                                                <td>{{$pu->Rate}}</td>
                                                                                <td>{{$pu->Barcode}}</td>
                                                                                <td>{{$pu->Price}}</td>
                                                                                <td>{{$pu->Price_Two}}</td>
                                                                                <td>{{$pu->Price_Three}}</td>

                                                                                <td>
                                                                                    <input type="radio" onclick="DEFAULT({{$pu->Unit}})" name="DefaultUnit" required @if($pu->Def == 1) checked value="1" @else value="0" @endif>

                                                                                    <input type="hidden" class="default" id="def{{$pu->Unit}}" name="Def[]" @if($pu->Def == 1) value="1" @else value="0" @endif>
                                                                                </td>
                                                                                <td>
                                                                                    <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                                                                </td>
                                                                            </tr>
                                                                            @endforeach
                                                                        </tbody>

                                                                    </table>
                                                                </div>
                                                                <!-- datatable end -->


                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="tab-pane fade" id="tab_borders_icons-2" role="tabpanel">
                                            <div class="form-row">

                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Maximum_Sales_Qty')}} </label>
                                                    <input type="number" name="Maximum_Sales_Qty" value="{{$item->Maximum_Sales_Qty}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Minimum')}} </label>
                                                    <input type="number" name="Minimum" value="{{$item->Minimum}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Maximum')}} </label>
                                                    <input type="number" name="Maximum" value="{{$item->Maximum}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Length')}} </label>
                                                    <input type="number" step="any" name="Length" value="{{$item->Length}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Width')}} </label>
                                                    <input type="number" step="any" name="Width" value="{{$item->Width}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Height')}} </label>
                                                    <input type="number" step="any" name="Height" value="{{$item->Height}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Weight')}} </label>
                                                    <input type="number" step="any" name="Weight" value="{{$item->Weight}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Thickness')}} </label>
                                                    <input type="number" step="any" name="Thickness" value="{{$item->Thickness}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Saller_Point')}} </label>
                                                    <input type="number" step="any" name="Saller_Point" value="{{$item->Saller_Point}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Customer_Point')}} </label>
                                                    <input type="number" step="any" name="Customer_Point" value="{{$item->Customer_Point}}" class="form-control">
                                                </div>

                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Guess_Price')}} </label>
                                                    <input type="number" step="any" name="Guess_Price" value="{{$item->Guess_Price}}" class="form-control">
                                                </div>


                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Bonus')}} </label>
                                                    <input type="number" step="any" name="Bonus" value="{{$item->Bonus}}" class="form-control">
                                                </div>



                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">Cas No </label>
                                                    <input type="text" name="Cas_No" value="{{$item->Cas_No}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">HSN </label>
                                                    <input type="text" name="HSN" value="{{$item->HSN}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">Uni Code </label>
                                                    <input type="text" name="Uni_Code" value="{{$item->Uni_Code}}" class="form-control">
                                                </div>


                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Origin_Number')}} </label>
                                                    <input type="text" name="Origin_Number" value="{{$item->Origin_Number}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Origin_Country')}} </label>
                                                    <input type="text" name="Origin_Country" value="{{$item->Origin_Country}}" class="form-control">
                                                </div>

                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.SearchCode1')}} </label>
                                                    <input type="text" name="SearchCode1" value="{{$item->SearchCode1}}" class="form-control">
                                                </div>

                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.SearchCode2')}} </label>
                                                    <input type="text" name="SearchCode2" value="{{$item->SearchCode2}}" class="form-control">
                                                </div>


                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Space')}} </label>
                                                    <input type="text" name="Space" value="{{$item->Space}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Storage')}} </label>
                                                    <input type="text" name="Storage" value="{{$item->Storage}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Processor')}} </label>
                                                    <input type="text" name="Processor" value="{{$item->Processor}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Camera')}} </label>
                                                    <input type="text" name="Camera" value="{{$item->Camera}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Screen')}} </label>
                                                    <input type="text" name="Screen" value="{{$item->Screen}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.OS')}} </label>
                                                    <input type="text" name="OS" value="{{$item->OS}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Battery')}} </label>
                                                    <input type="text" name="Battery" value="{{$item->Battery}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Warranty')}} </label>
                                                    <input type="text" name="Warranty" value="{{$item->Warranty}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Color')}} </label>
                                                    <input type="text" name="Color" value="{{$item->Color}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Category')}} </label>
                                                    <input type="text" name="Category" value="{{$item->Category}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Model')}} </label>
                                                    <input type="text" name="Model" value="{{$item->Model}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Arrange')}} </label>
                                                    <input type="number" name="Arrange" value="{{$item->Arrange}}" class="form-control">
                                                </div>

                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Calories')}} </label>
                                                    <input type="text" name="Calories" value="{{$item->Calories}}" class="form-control">
                                                </div>



                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for=""> {{trans('admin.Tax')}} </label>
                                                    <select class="select2 form-control w-100" name="Tax">
                                                        <option value="">{{trans('admin.Tax')}}</option>
                                                        @foreach($Taxes as $tax)
                                                        <option value="{{$tax->id}}" @if($item->Tax == $tax->id) selected @endif >{{$tax->Name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for=""> {{trans('admin.Validity')}} </label>
                                                    <select class="select2 form-control w-100" name="Validity" id="Validity" onchange="ShowD()">
                                                        <option value="0" @if($item->Validity == 0) selected @endif>{{trans('admin.NO')}}</option>
                                                        <option value="1" @if($item->Validity == 1) selected @endif>{{trans('admin.Yes')}}</option>
                                                    </select>
                                                </div>


                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for=""> {{trans('admin.Code_Typeee')}} </label>
                                                    <select class="select2 form-control w-100" name="Code_Type">
                                                        <option value="">{{trans('admin.Code_Typeee')}}</option>
                                                        <option value="GS1" @if($item->Code_Type == 'GS1') selected @endif>GS1</option>
                                                        <option value="EGS" @if($item->Code_Type == 'EGS') selected @endif>EGS</option>
                                                    </select>
                                                </div>

                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.World_Code')}} </label>
                                                    <input type="text" name="World_Code" value="{{$item->World_Code}}" class="form-control">
                                                </div>

                                                <div class="form-group col-md-2" id="Days_Notify" style="display: none">
                                                    <label class="form-label" for="simpleinput">
                                                        {{trans('admin.Days_Notify')}}
                                                    </label>
                                                    <input type="number" name="Days_Notify" value="{{$item->Days_Notify}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="">{{trans('admin.Store_Show')}} </label>
                                                    <select class="select2 form-control w-100" name="Store_Show" id="Store_Show" onchange="Show()">
                                                        <option value="0" @if($item->Store_Show == 0) selected @endif >{{trans('admin.NO')}}</option>
                                                        <option value="1" @if($item->Store_Show == 1) selected @endif>{{trans('admin.Storee')}}</option>
                                                        <option value="2" @if($item->Store_Show == 2) selected @endif>{{trans('admin.Price_List')}}</option>
                                                        <option value="3" @if($item->Store_Show == 3) selected @endif>{{trans('admin.Both')}}</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-2" id="StoreType" style="display: none">
                                                    <label class="form-label" for=""> {{trans('admin.Store_Type')}} </label>
                                                    <select class="select2 form-control w-100" name="Store_Type">
                                                        <option value="">{{trans('admin.Store_Type')}}</option>
                                                        <option value="0" @if($item->Store_Type == 0) selected @endif>{{trans('admin.Recently')}}</option>
                                                        <option value="1" @if($item->Store_Type == 1) selected @endif>{{trans('admin.Offer')}}</option>
                                                        <option value="2" @if($item->Store_Type == 2) selected @endif>{{trans('admin.Most_Salling')}}</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="row">

                                                <div class="form-group col-md-3" style="display: none">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Ar_Desc')}} </label>
                                                    <textarea class="js-summernote" id="saveToLocal" name="">
                                                    {{old('Ar_Desc')}}
                                                    </textarea>
                                                </div>

                                                <div class="form-group col-md-3">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Ar_Desc')}} </label>
                                                    <textarea class="js-summernote" id="saveToLocal" name="Ar_Desc">
                                                    {{$item->Ar_Desc}}
                                                    </textarea>
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.En_Desc')}} </label>
                                                    <textarea class="js-summernote" id="saveToLocal" name="En_Desc">
                                                    {{$item->En_Desc}}
                                                    </textarea>
                                                </div>

                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="">{{trans('admin.Show_Other_Store')}} </label>
                                                    <select class="select2 form-control w-100" name="Show_Other_Store">
                                                        <option value="0" @if($item->Show_Other_Store == 0) selected @endif>{{trans('admin.NO')}}</option>
                                                        <option value="1" @if($item->Show_Other_Store == 1) selected @endif>{{trans('admin.Yes')}}</option>

                                                    </select>
                                                </div>

                                                <div class="form-group col-md-3">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Arabic_Brief_Desc')}} </label>
                                                    <textarea class="js-summernote" id="saveToLocal" name="Arabic_Brief_Desc">
                                                    {{$item->Arabic_Brief_Desc}}
                                                    </textarea>
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.English_Brief_Desc')}} </label>
                                                    <textarea class="js-summernote" id="saveToLocal" name="English_Brief_Desc">
                                                    {{$item->English_Brief_Desc}}
                                                    </textarea>
                                                </div>





                                                <div class="form-group col-md-3">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Ar_Spec')}} </label>
                                                    <textarea class="js-summernote" id="saveToLocal" name="Ar_Spec">
                                                    {{$item->Ar_Spec}}
                                                    </textarea>
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.En_Spec')}} </label>
                                                    <textarea class="js-summernote" id="saveToLocal" name="En_Spec">
                                                    {{$item->En_Spec}}
                                                    </textarea>
                                                </div>
                                            </div>



                                            <div class="row">
                                                <div class="form-group col-md-3 mb-3">
                                                    <label class="form-label" for=""> {{trans('admin.Sub_Images')}}</label>

                                                    <input type="file" name="SubImage[]" multiple>
                                                </div>


                                                @foreach($subs as $sub)
                                                <div class="col-md-10">
                                                    <img src="../{{Storage::url($sub->Image)}}" class="control-img">
                                                </div>
                                                <div class="col-md-2">
                                                    <a href="{{url('DelSubImage/'.$sub->id)}}" class="btn btn-default"><i class="fal fa-times"></i></a>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>


                                        <div class="tab-pane fade" id="tab_borders_icons-3" role="tabpanel">
                                            <div class="form-row">

                                                <div class="form-group col-md-8">
                                                    <label class="form-label" for=""> {{trans('admin.Product')}} </label>
                                                    <select class="select2 form-control w-100" id="AdditionProduct" onchange="AdditionPlus()">
                                                        <option value="">{{trans('admin.Product')}}</option>

                                                        @foreach($AdditionsProducts as $addd)

                                                        <option value="{{$addd->id}}">{{app()->getLocale() == 'ar' ?$addd->P_Ar_Name :$addd->P_En_Name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>



                                                <div class="form-group col-md-4">
                                                    <button type="button" onclick="InsertAddition()" class="btn btn-default" id="addAdditionP" style="display: none"><i class="fal fa-plus"></i></button>
                                                </div>


                                                <!-- datatable start -->
                                                <div id="mobile-overflow">
                                                    <table id="" class="table table-bordered table-hover table-striped w-100 mobile-width">
                                                        <thead>
                                                            <tr>
                                                                <th>{{trans('admin.Product')}}</th>
                                                                <th>{{trans('admin.Actions')}}</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="dataAddition">

                                                            @foreach($Additions as $de)

                                                            <tr>
                                                                <td>
                                                                    @if(!empty($de->Additional_Product))
                                                                    {{app()->getLocale() == 'ar' ?$de->Additional_Product()->first()->P_Ar_Name :$de->Additional_Product()->first()->P_En_Name}}

                                                                    <input type="hidden" name="Additional_Product[]" value="{{$de->Additional_Product}}">
                                                                    @endif


                                                                </td>
                                                                <td>
                                                                    <button id="DelDepP" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                                                </td>
                                                            </tr>
                                                            @endforeach
                                                        </tbody>

                                                    </table>
                                                </div>
                                                <!-- datatable end -->



                                            </div>
                                        </div>


                                    </div>
                                </div>
                                <div class="buttons mt-3">

                                    <button type="submit" id="SUBMIT" style="display: none" class="btn btn-primary"><i class="fal fa-save"></i> {{trans('admin.Save')}} </button>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </form>
</main>


@if(app()->getLocale() == 'ar' )
<input type="hidden" id="LANG" value="ar">
@else
<input type="hidden" id="LANG" value="en">
@endif

@endsection


@push('js')

<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/dropzone/dropzone.css')}}">

<style>
    .dt-buttons {
        display: none;

    }

    .dataTables_filter {
        display: none;

    }

</style>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/dropzone/dropzone.js')}}"></script>


<!--- Plus -->
<script>
    function PLUS() {


        $.fn.rowCount = function() {
            return $('tr', $(this).find('tbody')).length;
        };

        var rowctr = $('#samble').rowCount();
        var P_Type = $('#P_Type').val();

        if (P_Type == 'Assembly' || P_Type == 'Serial') {
            if (rowctr == 0) {

                var Unit = $('#unit').val();
                var Rate = $('#rate').val();
                var Code = $('#code').val();
                var Price = $('#price1').val();

                if (Unit == '' || Rate == '' || Code == '' || Price == '') {

                    document.getElementById("add-data").style.display = "none";
                }


                if (Unit != '' && Rate != '' && Code != '' && Price != '') {

                    document.getElementById("add-data").style.display = "block";
                }



            } else {

                document.getElementById("add-data").style.display = "none";

            }



        } else {

            var Unit = $('#unit').val();
            var Rate = $('#rate').val();
            var Code = $('#code').val();
            var Price = $('#price1').val();

            if (Unit == '' || Rate == '' || Code == '' || Price == '') {

                document.getElementById("add-data").style.display = "none";
            }


            if (Unit != '' && Rate != '' && Code != '' && Price != '') {

                document.getElementById("add-data").style.display = "block";
            }
        }
    }

</script>


<!-- Unit Name -->
<script>
    $(document).ready(function() {

        $('#unit').on('change', function() {
            var countryId = $(this).val();
            if (countryId) {
                $.ajax({
                    url: 'UnitNameFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {
                        $.each(data, function(key, value) {


                            $('#UnitID').val(key);
                            $('#UnitName').val(value);
                        });
                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="state"]').empty();
            }

        });

    });


    function UnitNameCode(x) {

        var countryId = $('#UnitAssem' + x).val();
        var Pro = $('#Product' + x).val();
        if (countryId) {
            $.ajax({
                url: 'UnitNameCodeFilterr/' + countryId + '/' + Pro,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {
                    $.each(data, function(key, value) {

                        $('#CodeAssem' + x).val(data.code);
                        $('#UnitNameAssem' + x).val(data.name);
                        $('#Price' + x).val(data.price);


                    });


                    var Qty = $("#Qty" + x).val();
                    var Price = $("#Price" + x).val();

                    var result = parseFloat(Qty) * parseFloat(Price);
                    $("#Total" + x).val(result);

                    var Total = $("#Total" + x).val();
                    var UnitID = $("#UnitAssem" + x).val();


                    if (Qty == '' || Price == '' || Total == '' || UnitID == '') {

                        document.getElementById("AddBtnPur" + x).style.display = "none";
                    }


                    if (Qty != '' && Price != '' && Total != '' && UnitID != '') {

                        document.getElementById("AddBtnPur" + x).style.display = "block";
                    }





                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="state"]').empty();
        }

    }

</script>

<!-- Store Show -->
<script>
    function Show() {
        var Store_Show = $('#Store_Show').val();

        if (Store_Show == 1) {

            document.getElementById("StoreType").style.display = "block";
        } else {
            document.getElementById("StoreType").style.display = "none";

        }

    }


    $(document).ready(function() {
        var Store_Show = $('#Store_Show').val();

        if (Store_Show == 1) {

            document.getElementById("StoreType").style.display = "block";
        } else {
            document.getElementById("StoreType").style.display = "none";

        }

    });


    $(document).ready(function() {
        document.getElementById("SUBMIT").style.display = "block";
    });

</script>

<!-- Days Notify Show -->
<script>
    function ShowD() {
        var Validity = $('#Validity').val();

        if (Validity == 1) {

            document.getElementById("Days_Notify").style.display = "block";
        } else {
            document.getElementById("Days_Notify").style.display = "none";

        }

    }

    $(document).ready(function() {
        var Validity = $('#Validity').val();

        if (Validity == 1) {

            document.getElementById("Days_Notify").style.display = "block";
        } else {
            document.getElementById("Days_Notify").style.display = "none";

        }

    });

</script>

<!-- Assembly and vIrables Show -->
<script>
    function Assembly() {
        var P_Type = $('#P_Type').val();


        if (P_Type == 'Assembly') {

            document.getElementById("HideAssembly").style.display = "block";
            document.getElementById("HideViraOne").style.display = "none";
            document.getElementById("HideViraTwo").style.display = "none";
            document.getElementById("EndDate").style.display = "none";
        } else if (P_Type == 'Single_Variable') {

            document.getElementById("HideAssembly").style.display = "none";
            document.getElementById("HideViraOne").style.display = "block";
            document.getElementById("HideViraTwo").style.display = "none";
            document.getElementById("EndDate").style.display = "none";

        } else if (P_Type == 'Duble_Variable') {
            document.getElementById("HideAssembly").style.display = "none";
            document.getElementById("HideViraOne").style.display = "none";
            document.getElementById("HideViraTwo").style.display = "block";
            document.getElementById("EndDate").style.display = "none";

        } else if (P_Type == 'Subscribe') {
            document.getElementById("HideAssembly").style.display = "none";
            document.getElementById("HideViraOne").style.display = "none";
            document.getElementById("HideViraTwo").style.display = "none";
            document.getElementById("EndDate").style.display = "block";

        } else {

            document.getElementById("HideAssembly").style.display = "none";
            document.getElementById("HideViraOne").style.display = "none";
            document.getElementById("HideViraTwo").style.display = "none";
            document.getElementById("EndDate").style.display = "none";


        }



    }

    $(document).ready(function() {

        var P_Type = $('#P_Type').val();


        if (P_Type == 'Assembly') {

            document.getElementById("HideAssembly").style.display = "block";
            document.getElementById("HideViraOne").style.display = "none";
            document.getElementById("HideViraTwo").style.display = "none";
            document.getElementById("EndDate").style.display = "none";
        } else if (P_Type == 'Single_Variable') {

            document.getElementById("HideAssembly").style.display = "none";
            document.getElementById("HideViraOne").style.display = "block";
            document.getElementById("HideViraTwo").style.display = "none";
            document.getElementById("EndDate").style.display = "none";

        } else if (P_Type == 'Duble_Variable') {
            document.getElementById("HideAssembly").style.display = "none";
            document.getElementById("HideViraOne").style.display = "none";
            document.getElementById("HideViraTwo").style.display = "block";
            document.getElementById("EndDate").style.display = "none";

        } else if (P_Type == 'Subscribe') {
            document.getElementById("HideAssembly").style.display = "none";
            document.getElementById("HideViraOne").style.display = "none";
            document.getElementById("HideViraTwo").style.display = "none";
            document.getElementById("EndDate").style.display = "block";

        } else {

            document.getElementById("HideAssembly").style.display = "none";
            document.getElementById("HideViraOne").style.display = "none";
            document.getElementById("HideViraTwo").style.display = "none";
            document.getElementById("EndDate").style.display = "none";


        }

    });

</script>

<!-- Genrte Code  -->
<script>
    function Genrte() {


        $("#code").val(Math.floor(Math.random() * 1000000));




    }

</script>

<!--  Filter Assembly -->
<script>
    $(document).ready(function() {

        fetch_customer_data();

        function fetch_customer_data(search = '') {
            $.ajax({
                url: '22/AssemblyFilter',
                method: 'GET',
                data: {
                    search: search
                },
                dataType: 'json',
                success: function(data) {
                    $('#data').html(data.table_data);
                }
            })
        }

        $(document).on('keyup', '#search', function() {
            var search = $(this).val();
            fetch_customer_data(search);
        });


    });

</script>


<!-- Add Assembly -->
<script>
    function Fun(r) {

        var P_Ar_Name = $("#P_Ar_Name" + r).val();
        var P_En_Name = $("#P_En_Name" + r).val();
        var Product = $("#Product" + r).val();
        var UnitID = $("#UnitAssem" + r).val();
        var UnitName = $("#UnitNameAssem" + r).val();
        var Qty = $("#Qty" + r).val();
        var Barcode = $("#CodeAssem" + r).val();
        var Price = $("#Price" + r).val();
        var Total = $("#Total" + r).val();

        document.getElementById("AddBtnPur" + r).style.display = "none";
        document.getElementById("Row" + r).style.display = "none";
        var LANG = $("#LANG").val();
        if (LANG == 'ar') {
            var Nemo = P_Ar_Name;
        } else {
            var Nemo = P_En_Name;
        }

        var markup = "<tr><td><input type='hidden' name='P_Ar_NameAssem[]' value='" + P_Ar_Name + "'><input type='hidden' name='P_En_NameAssem[]' value='" + P_En_Name + "'>" + Nemo + "</td><td><input type='hidden' name='P_CodeAssem[]' value='" + Barcode + "'>" + Barcode + "</td><td><input type='hidden' name='UnitAssem[]' value='" + UnitID + "'>" + UnitName + "</td><td><input type='hidden' name='QtyAssem[]' value='" + Qty + "'>" + Qty + "</td><td><input type='hidden' name='PriceAssem[]' value='" + Price + "'>" + Price + "</td><td><input type='hidden' name='TotalAssem[]' value='" + Total + "'>" + Total + "</td><td>  <button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input id='Product_IDInp" + r + "' type='hidden' name='ProductAssem[]' value='" + Product + "'></td></tr>";

        var Product_IDInp = $("#Product_IDInp" + r).val();

        if (Product != Product_IDInp) {
            $("#data-dt").append(markup);
        }


        $('#data-dt').on('click', '#DelAssem', function(e) {
            $(this).closest('tr').remove();
        })


    }

</script>

<!-- Total Assembly -->
<script>
    function AssTotal(r) {
        var Qty = $("#Qty" + r).val();
        var Price = $("#Price" + r).val();

        var result = parseFloat(Qty) * parseFloat(Price);
        $("#Total" + r).val(result);

        var Total = $("#Total" + r).val();
        var UnitID = $("#UnitAssem" + r).val();


        if (Qty == '' || Price == '' || Total == '' || UnitID == '') {

            document.getElementById("AddBtnPur" + r).style.display = "none";
        }


        if (Qty != '' && Price != '' && Total != '' && UnitID != '') {

            document.getElementById("AddBtnPur" + r).style.display = "block";
        }





    }

</script>


@if($item->P_Type == 'Single_Variable')
<!-- Filter Virable One -->
<script>
    $(document).ready(function() {

        fetch_customer_data();

        function fetch_customer_data(search = '') {
            $.ajax({
                url: '1/VOneFilter',
                method: 'GET',
                data: {
                    search: search
                },
                dataType: 'json',
                success: function(data) {
                    $('.ViraOne').html(data.table_data);
                }
            })
        }

        $(document).on('change', '#VOne', function() {
            var search = $(this).val();
            fetch_customer_data(search);
        });


    });


    $(document).ready(function() {

        fetch_customer_data();

        function fetch_customer_data(search = '') {
            $.ajax({
                url: '1/VOneFilter',
                method: 'GET',
                data: {
                    search: search
                },
                dataType: 'json',
                success: function(data) {
                    $('.ViraOne').html(data.table_data);
                }
            })
        }

        var search = $('#VOne').val();
        fetch_customer_data(search);


    });

</script>
@endif

<!-- Filter Virable Two -->
<script>
    $(document).ready(function() {

        fetch_customer_data();

        function fetch_customer_data(search = '', searchT = '') {
            $.ajax({
                url: '1/VTwoFilter',
                method: 'GET',
                data: {
                    search: search,
                    searchT: searchT
                },
                dataType: 'json',
                success: function(data) {
                    $('#variables').html(data.table_data);
                }
            })
        }

        $(document).on('change', '#VTwo', function() {
            var search = $(this).val();
            var searchT = $("#VTwoo").val();

            if (search != searchT) {
                document.getElementById("AlertVira").style.display = "none";
                document.getElementById("TabV2").style.display = "block";
                fetch_customer_data(search, searchT);
            } else {


                document.getElementById("AlertVira").style.display = "block";
                document.getElementById("TabV2").style.display = "none";

            }


        });

        $(document).on('change', '#VTwoo', function() {
            var searchT = $(this).val();
            var search = $("#VTwo").val();
            if (search != searchT) {
                document.getElementById("AlertVira").style.display = "none";
                document.getElementById("TabV2").style.display = "block";
                fetch_customer_data(search, searchT);
            } else {


                document.getElementById("AlertVira").style.display = "block";
                document.getElementById("TabV2").style.display = "none";

            }

        });



    });



    $(document).ready(function() {

        fetch_customer_data();

        function fetch_customer_data(search = '', searchT = '') {
            $.ajax({
                url: '1/VTwoFilter',
                method: 'GET',
                data: {
                    search: search,
                    searchT: searchT
                },
                dataType: 'json',
                success: function(data) {
                    $('#variables').html(data.table_data);
                }
            })
        }


        var search = $('#VTwo').val();
        var searchT = $("#VTwoo").val();

        if (search != searchT) {
            document.getElementById("AlertVira").style.display = "none";
            document.getElementById("TabV2").style.display = "block";
            fetch_customer_data(search, searchT);
        } else {


            document.getElementById("AlertVira").style.display = "block";
            document.getElementById("TabV2").style.display = "none";

        }




    });

</script>


<script>
    /* demo scripts for change table color */
    /* change background */


    $(document).ready(function() {

        $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
        $('#dt-basic-example thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

            $('input', this).on('keyup change', function() {
                if (table.column(i).search() !== this.value) {
                    table
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });

        var table = $('#dt-basic-example').dataTable({
            responsive: true,
            orderCellsTop: true,
            fixedHeader: true,
            lengthChange: false,

            dom: "<'row mb-3'<'col-sm-12 col-md-6 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-6 d-flex align-items-center justify-content-end'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            buttons: [{
                    extend: 'colvis',
                    text: 'Column Visibility',
                    titleAttr: 'Col visibility',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    titleAttr: 'Generate PDF',
                    className: 'btn-outline-danger btn-sm mr-1'
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    titleAttr: 'Generate Excel',
                    className: 'btn-outline-success btn-sm mr-1'
                },
                {
                    extend: 'csvHtml5',
                    text: 'CSV',
                    titleAttr: 'Generate CSV',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'copyHtml5',
                    text: 'Copy',
                    titleAttr: 'Copy to clipboard',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'print',
                    text: 'Print',
                    titleAttr: 'Print Table',
                    className: 'btn-outline-primary btn-sm'
                }
            ],
        });

        $('.js-thead-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
        });

        $('.js-tbody-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
        });

    });

</script>

<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function() {
        interval = setInterval(function() {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function() {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete
    var removeFromLocal = function() {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function() {
        //init default
        $('.js-summernote').summernote({
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks: {
                //restore from localStorage
                onInit: function(e) {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable) {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax({
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data) {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote({
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint: {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback) {
                    callback($.grep(emojis, function(item) {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item) {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item) {
                    var url = emojiUrls[item];
                    if (url) {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote({
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint: {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback) {
                    callback($.grep(this.mentions, function(item) {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item) {
                    return '@' + item;
                }
            }
        });

    });

</script>

<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }

            $(".js-data-example-ajax").select2({
                ajax: {
                    url: "https://api.github.com/search/repositories",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term, // search term
                            page: params.page
                        };
                    },
                    processResults: function(data, params) {
                        // parse the results into the format expected by Select2
                        // since we are using custom formatting functions we do not need to
                        // alter the remote JSON data, except to indicate that infinite
                        // scrolling can be used
                        params.page = params.page || 1;

                        return {
                            results: data.items,
                            pagination: {
                                more: (params.page * 30) < data.total_count
                            }
                        };
                    },
                    cache: true
                },
                placeholder: 'Search for a repository',
                escapeMarkup: function(markup) {
                    return markup;
                }, // let our custom formatter work
                minimumInputLength: 1,
                templateResult: formatRepo,
                templateSelection: formatRepoSelection
            });

            function formatRepo(repo) {
                if (repo.loading) {
                    return repo.text;
                }

                var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                    "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                    "<div class='select2-result-repository__meta'>" +
                    "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

                if (repo.description) {
                    markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                }

                markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                    "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                    "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                    "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                    "</div>" +
                    "</div></div>";

                return markup;
            }

            function formatRepoSelection(repo) {
                return repo.full_name || repo.text;
            }
        });
    });

</script>

<script>
    function InsertData() {
        var UnitName = document.getElementById('UnitName').value;
        var UnitID = document.getElementById('UnitID').value;
        var Rate = document.getElementById('rate').value;
        var Code = document.getElementById('code').value;
        var Price1 = document.getElementById('price1').value;
        var Price2 = document.getElementById('price2').value;
        var Price3 = document.getElementById('price3').value;
        var HIDEEE = 0;
        var table = ` <tr>
                           <td>
                     ${UnitName}
   <input type="hidden" name="Rate[]" value="${Rate}">
   <input type="hidden" name="Barcode[]" value="${Code}">
   <input type="hidden" name="Price[]" value="${Price1}">
   <input type="hidden" name="Price_Two[]" value="${Price2}">
   <input type="hidden" name="Price_Three[]" value="${Price3}">
   <input type="hidden" id="U${UnitID}" name="Unit[]" value="${UnitID}">
                       </td>
                           <td>${Rate}</td>
                           <td>${Code}</td>
                           <td>${Price1}</td>
                           <td>${Price2}</td>
                           <td>${Price3}</td>
                           <td>

           <input type="radio" onclick="DEFAULT(${UnitID})"  name="DefaultUnit"  required>
           <input type="hidden" class="default" id="def${UnitID}" name="Def[]" value="0">
                          </td>

                           <td>
              <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                           </td>
                        </tr>`;


        var u = $('#U' + UnitID).val();
        if (u != UnitID) {
            document.getElementById('data-dt-first').innerHTML += table;
        }
        $('#unit').val('');
        $('#rate').val('');
        $('#code').val('');
        $('#price1').val('');
        $('#price2').val('');
        $('#price3').val('');
        document.getElementById("add-data").style.display = "none";

        var rate = [];
        $('input[name^="Rate"]').each(function() {
            rate.push(this.value);
        });


        $('input[name^="Rate"]').each(function(key) {

            if (rate[key] == 1) {
                HIDEEE += 1;

            } else {
                HIDEEE += 0;
            }


        });

        if (parseFloat(HIDEEE) == 1) {
            document.getElementById("SUBMIT").style.display = "block";
        } else {
            document.getElementById("SUBMIT").style.display = "none";
        }




        $('#data-dt-first').on('click', '#Del', function(e) {
            $(this).closest('tr').remove();
            var HIDEEE = 0;
            $.fn.rowCount = function() {
                return $('tr', $(this).find('tbody')).length;
            };

            var rowctr = $('#samble').rowCount();

            var rate = [];
            $('input[name^="Rate"]').each(function() {
                rate.push(this.value);
            });

            if (rowctr == 0) {
                document.getElementById("SUBMIT").style.display = "none";

            } else {

                document.getElementById("SUBMIT").style.display = "block";
            }

            $('input[name^="Rate"]').each(function(key) {

                if (rate[key] == 1) {
                    HIDEEE += 1;

                } else {
                    HIDEEE += 0;
                }


            });

            if (parseFloat(HIDEEE) == 1) {
                document.getElementById("SUBMIT").style.display = "block";
            } else {
                document.getElementById("SUBMIT").style.display = "none";
            }




        })



    }

</script>
<script>
    $('#data-dt-first').on('click', '#Del', function(e) {
        $(this).closest('tr').remove();
        var HIDEEE = 0;
        $.fn.rowCount = function() {
            return $('tr', $(this).find('tbody')).length;
        };

        var rowctr = $('#samble').rowCount();

        var rate = [];
        $('input[name^="Rate"]').each(function() {
            rate.push(this.value);
        });

        if (rowctr == 0) {
            document.getElementById("SUBMIT").style.display = "none";

        } else {

            document.getElementById("SUBMIT").style.display = "block";
        }

        $('input[name^="Rate"]').each(function(key) {

            if (rate[key] == 1) {
                HIDEEE += 1;

            } else {
                HIDEEE += 0;
            }


        });

        if (parseFloat(HIDEEE) == 1) {
            document.getElementById("SUBMIT").style.display = "block";
        } else {
            document.getElementById("SUBMIT").style.display = "none";
        }




    })

</script>
<script>
    $('#data-dt').on('click', '#DelAssem', function(e) {
        $(this).closest('tr').remove();
    })

</script>


<!-- Addition Product Table -->
<script>
    function InsertAddition() {
        var AdditionProduct = $('#AdditionProduct').val();
        var AdditionProductName = $('#AdditionProduct option:selected').text();




        var table = ` <tr>
                                <td>
                            ${AdditionProductName}
          <input type="hidden" name="Additional_Product[]" value="${AdditionProduct}">
                                </td>


                                <td>
                    <button id="DelDepP" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>`;

        document.getElementById("dataAddition").innerHTML += table;
        document.getElementById("addAdditionP").style.display = "none";

        $("#dataAddition").on("click", "#DelDepP", function(e) {
            $(this).closest("tr").remove();

        });
    }

    function AdditionPlus() {
        var AdditionProduct = $('#AdditionProduct').val();

        if (AdditionProduct != "") {
            document.getElementById("addAdditionP").style.display = "block";
        }


        if (AdditionProduct == "") {
            document.getElementById("addAdditionP").style.display = "none";
        }

    }

    $("#dataAddition").on("click", "#DelDepP", function(e) {
        $(this).closest("tr").remove();

    });

</script>


<!-- Default Unit -->
<script>
    function DEFAULT(r) {

        $('.default').val(0);

        $('#def' + r).val(1);

    }

</script>
<script type="text/javascript">
    $(function() {

        $('.dz-details').click(function() {

            $('.dz-image').hide();



        });

    });

</script>

@endpush
