@extends('admin.index')
@section('content')

<title>{{trans('admin.BarcodeـPrinting_Settings')}}</title>

<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Stores')}}</a></li>
        <li class="breadcrumb-item active">{{trans('admin.BarcodeـPrinting_Settings')}}</li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>

    <div class="row">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                    <h2>
                        <span class="fw-300"><i>{{trans('admin.BarcodeـPrinting_Settings')}}</i></span>
                    </h2>

                    <div class="panel-toolbar">
                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg">{{trans('admin.AddNew')}}</button>
                        <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                        @include('admin.layouts.toolbar')
                    </div>

                </div>
                <div class="panel-container show">
                    <span id="ex"> @include('admin.layouts.messages')</span>
                    <div class="panel-content">
                        <!-- datatable start -->
                        <div style="overflow:auto">
                            <table id="dt-basic-example" class="table table-bordered table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                    <tr>
                                        <th>{{trans('admin.Code')}}</th>
                                        <th>{{trans('admin.Arabic_Name')}}</th>
                                        <th>{{trans('admin.English_Name')}}</th>

                                        <th>{{trans('admin.Data')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>

                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach($items as $item)
                                    <tr>
                                        <td>{{$item->Code}}</td>
                                        <td>{{$item->Name}}</td>
                                        <td>{{$item->NameEn}}</td>


                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#data{{$item->id}}">{{trans('admin.Data')}}</button>
                                        </td>

                                        <td class="text-center">

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>

                                        </td>
                                    </tr>
                                    @endforeach


                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>{{trans('admin.Code')}}</th>
                                        <th>{{trans('admin.Arabic_Name')}}</th>
                                        <th>{{trans('admin.English_Name')}}</th>

                                        <th>{{trans('admin.Data')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <!-- datatable end -->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Add-->
    <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{trans('admin.AddNew')}} </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{url('AddBaPriSett')}}" method="post">
                        {!! csrf_field() !!}
                        @honeypot
                        <div class="form-row">

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Code')}}</label>
                                <input type="text" value="{{$Code}}" class="form-control" disabled>
                                <input type="hidden" name="Code" value="{{$Code}}">
                            </div>


                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Arabic_Name')}}</label>
                                <input type="text" name="Name" value="{{old('Name')}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.English_Name')}}</label>
                                <input type="text" name="NameEn" value="{{old('NameEn')}}" class="form-control">
                            </div>



                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Type')}}</label>
                                <select class="select2 form-control" name="Type" required>
                                    <option value="">{{trans('admin.Type')}}</option>
                                    <option value="1">{{trans('admin.A4')}}</option>
                                    <option value="2">{{trans('admin.Pulley')}}</option>

                                </select>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Direction')}}</label>
                                <select class="select2 form-control" name="Direction" required>
                                    <option value="">{{trans('admin.Direction')}}</option>
                                    <option value="1">{{trans('admin.Portrait')}}</option>
                                    <option value="2">{{trans('admin.Landscape')}}</option>
                                </select>
                            </div>


                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput">{{trans('admin.Width')}}</label>
                                <input type="number" step="any" name="Width" value="{{old('Width')}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput">{{trans('admin.Height')}}</label>
                                <input type="number" step="any" name="Height" value="{{old('Height')}}" class="form-control" required>
                            </div>


                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Padding_L')}}</label>
                                <input type="number" step="any" name="Padding_L" value="{{old('Padding_L')}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Padding_R')}}</label>
                                <input type="number" step="any" name="Padding_R" value="{{old('Padding_R')}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Padding_T')}}</label>
                                <input type="number" step="any" name="Padding_T" value="{{old('Padding_T')}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Padding_B')}}</label>
                                <input type="number" step="any" name="Padding_B" value="{{old('Padding_B')}}" class="form-control" required>
                            </div>



                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Margin_L')}}</label>
                                <input type="number" step="any" name="Margin_L" value="{{old('Margin_L')}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Margin_R')}}</label>
                                <input type="number" step="any" name="Margin_R" value="{{old('Margin_R')}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Margin_T')}}</label>
                                <input type="number" step="any" name="Margin_T" value="{{old('Margin_T')}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Margin_B')}}</label>
                                <input type="number" step="any" name="Margin_B" value="{{old('Margin_B')}}" class="form-control" required>
                            </div>



                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Barcode_Width')}}</label>
                                <input type="number" step="any" name="Barcode_Width" value="{{old('Barcode_Width')}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Barcode_Height')}}</label>
                                <input type="number" step="any" name="Barcode_Height" value="{{old('Barcode_Height')}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Font_Size')}}</label>
                                <input type="number" step="any" name="Font_Size" value="{{old('Font_Size')}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Line_Height')}}</label>
                                <input type="number" step="any" name="Line_Height" value="{{old('Line_Height')}}" class="form-control" required>
                            </div>


                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Width_Logo')}}</label>
                                <input type="number" step="any" name="Width_Logo" value="{{old('Width_Logo')}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Height_Logo')}}</label>
                                <input type="number" step="any" name="Height_Logo" value="{{old('Height_Logo')}}" class="form-control" required>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                            <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>



    @foreach($items as $item)
    <!-- Modal Edit-->
    <div class="modal fade" id="default-example-modal-lg-edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{trans('admin.Edit')}} </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{url('EditBaPriSett/'.$item->id)}}" method="post">
                        {!! csrf_field() !!}
                        @honeypot
                        <div class="form-row">

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Code')}}</label>
                                <input type="text" value="{{$item->Code}}" class="form-control" disabled>
                                <input type="hidden" name="Code" value="{{$item->Code}}">
                            </div>


                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Arabic_Name')}}</label>
                                <input type="text" name="Name" value="{{$item->Name}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.English_Name')}}</label>
                                <input type="text" name="NameEn" value="{{$item->NameEn}}" class="form-control" required>
                            </div>



                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Type')}}</label>
                                <select class="select2 form-control" name="Type" required>
                                    <option value="">{{trans('admin.Type')}}</option>
                                    <option value="1" @if($item->Type == 1) selected @endif>{{trans('admin.A4')}}</option>
                                    <option value="2" @if($item->Type == 2) selected @endif>{{trans('admin.Pulley')}}</option>

                                </select>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Direction')}}</label>
                                <select class="select2 form-control" name="Direction" required>
                                    <option value="">{{trans('admin.Direction')}}</option>
                                    <option value="1" @if($item->Direction == 1) selected @endif>{{trans('admin.Portrait')}}</option>
                                    <option value="2" @if($item->Direction == 2) selected @endif>{{trans('admin.Landscape')}}</option>
                                </select>
                            </div>


                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput">{{trans('admin.Width')}}</label>
                                <input type="number" step="any" name="Width" value="{{$item->Width}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput">{{trans('admin.Height')}}</label>
                                <input type="number" step="any" name="Height" value="{{$item->Height}}" class="form-control" required>
                            </div>


                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Padding_L')}}</label>
                                <input type="number" step="any" name="Padding_L" value="{{$item->Padding_L}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Padding_R')}}</label>
                                <input type="number" step="any" name="Padding_R" value="{{$item->Padding_R}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Padding_T')}}</label>
                                <input type="number" step="any" name="Padding_T" value="{{$item->Padding_T}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Padding_B')}}</label>
                                <input type="number" step="any" name="Padding_B" value="{{$item->Padding_B}}" class="form-control" required>
                            </div>



                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Margin_L')}}</label>
                                <input type="number" step="any" name="Margin_L" value="{{$item->Margin_L}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Margin_R')}}</label>
                                <input type="number" step="any" name="Margin_R" value="{{$item->Margin_R}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Margin_T')}}</label>
                                <input type="number" step="any" name="Margin_T" value="{{$item->Margin_T}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Margin_B')}}</label>
                                <input type="number" step="any" name="Margin_B" value="{{$item->Margin_B}}" class="form-control" required>
                            </div>



                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Barcode_Width')}}</label>
                                <input type="number" step="any" name="Barcode_Width" value="{{$item->Barcode_Width}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Barcode_Height')}}</label>
                                <input type="number" step="any" name="Barcode_Height" value="{{$item->Barcode_Height}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Font_Size')}}</label>
                                <input type="number" step="any" name="Font_Size" value="{{$item->Font_Size}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Line_Height')}}</label>
                                <input type="number" step="any" name="Line_Height" value="{{$item->Line_Height}}" class="form-control" required>
                            </div>


                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Width_Logo')}}</label>
                                <input type="number" step="any" name="Width_Logo" value="{{$item->Width_Logo}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Height_Logo')}}</label>
                                <input type="number" step="any" name="Height_Logo" value="{{$item->Height_Logo}}" class="form-control" required>
                            </div>

                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                            <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Delete -->
    <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                    <a href="{{url('DeleteBaPriSett/'.$item->id)}}" class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Data -->
    <div class="modal fade" id="data{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Data')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <div style="overflow:auto">
                        <table id="" class="table table-bordered table-hover table-striped" style="width:180%;">
                            <thead class="bg-highlight">
                                <tr>

                                    <th>{{trans('admin.Type')}}</th>
                                    <th>{{trans('admin.Direction')}}</th>
                                    <th>{{trans('admin.Width')}}</th>
                                    <th>{{trans('admin.Height')}}</th>
                                    <th>{{trans('admin.Padding_L')}}</th>
                                    <th>{{trans('admin.Padding_R')}}</th>
                                    <th>{{trans('admin.Padding_T')}}</th>
                                    <th>{{trans('admin.Padding_B')}}</th>
                                    <th>{{trans('admin.Margin_L')}}</th>
                                    <th>{{trans('admin.Margin_R')}}</th>
                                    <th>{{trans('admin.Margin_T')}}</th>
                                    <th>{{trans('admin.Margin_B')}}</th>
                                    <th>{{trans('admin.Barcode_Width')}}</th>
                                    <th>{{trans('admin.Barcode_Height')}}</th>
                                    <th>{{trans('admin.Font_Size')}}</th>
                                    <th>{{trans('admin.Line_Height')}}</th>
                                    <th>{{trans('admin.Width_Logo')}}</th>
                                    <th>{{trans('admin.Height_Logo')}}</th>


                                </tr>
                            </thead>
                            <tbody>


                                <tr>

                                    <td>
                                        @if($item->Type == 1)
                                        {{trans('admin.A4')}}
                                        @elseif($item->Type == 2)
                                        {{trans('admin.Pulley')}}
                                        @endif
                                    </td>

                                    <td>
                                        @if($item->Direction == 1)
                                        {{trans('admin.Portrait')}}
                                        @elseif($item->Direction == 2)
                                        {{trans('admin.Landscape')}}
                                        @endif
                                    </td>

                                    <td>{{$item->Width}}</td>
                                    <td>{{$item->Height}}</td>
                                    <td>{{$item->Padding_L}}</td>
                                    <td>{{$item->Padding_R}}</td>
                                    <td>{{$item->Padding_T}}</td>
                                    <td>{{$item->Padding_B}}</td>
                                    <td>{{$item->Margin_L}}</td>
                                    <td>{{$item->Margin_R}}</td>
                                    <td>{{$item->Margin_T}}</td>
                                    <td>{{$item->Margin_B}}</td>
                                    <td>{{$item->Barcode_Width}}</td>
                                    <td>{{$item->Barcode_Height}}</td>
                                    <td>{{$item->Font_Size}}</td>
                                    <td>{{$item->Line_Height}}</td>
                                    <td>{{$item->Width_Logo}}</td>
                                    <td>{{$item->Height_Logo}}</td>

                                </tr>



                            </tbody>
                            <tfoot>
                                <tr>

                                    <th>{{trans('admin.Type')}}</th>
                                    <th>{{trans('admin.Direction')}}</th>
                                    <th>{{trans('admin.Width')}}</th>
                                    <th>{{trans('admin.Height')}}</th>
                                    <th>{{trans('admin.Padding_L')}}</th>
                                    <th>{{trans('admin.Padding_R')}}</th>
                                    <th>{{trans('admin.Padding_T')}}</th>
                                    <th>{{trans('admin.Padding_B')}}</th>
                                    <th>{{trans('admin.Margin_L')}}</th>
                                    <th>{{trans('admin.Margin_R')}}</th>
                                    <th>{{trans('admin.Margin_T')}}</th>
                                    <th>{{trans('admin.Margin_B')}}</th>
                                    <th>{{trans('admin.Barcode_Width')}}</th>
                                    <th>{{trans('admin.Barcode_Height')}}</th>
                                    <th>{{trans('admin.Font_Size')}}</th>
                                    <th>{{trans('admin.Line_Height')}}</th>
                                    <th>{{trans('admin.Width_Logo')}}</th>
                                    <th>{{trans('admin.Height_Logo')}}</th>

                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>

                </div>
            </div>
        </div>
    </div>
    @endforeach

</main>

@endsection

@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script>
    //_fnFeatureHtmlLength();
    $(document).ready(function() {
        // Setup - add a text input to each footer cell
        $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
        $('#dt-basic-example thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

            $('input', this).on('keyup change', function() {
                if (table.column(i).search() !== this.value) {
                    table
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });
        var table = $('#dt-basic-example').DataTable({
            // responsive: true,
            orderCellsTop: true,
            fixedHeader: true,
            lengthChange: true,

            dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

            buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'colvis',
                    text: 'Column Visibility',
                    titleAttr: 'Col visibility',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    titleAttr: 'Generate PDF',
                    className: 'btn-outline-danger btn-sm mr-1'
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    titleAttr: 'Generate Excel',
                    className: 'btn-outline-success btn-sm mr-1'
                },
                {
                    extend: 'csvHtml5',
                    text: 'CSV',
                    titleAttr: 'Generate CSV',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'copyHtml5',
                    text: 'Copy',
                    titleAttr: 'Copy to clipboard',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'print',
                    text: 'Print',
                    titleAttr: 'Print Table',
                    className: 'btn-outline-primary btn-sm'
                }
            ],
        });
        $('.js-thead-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
        });

        $('.js-tbody-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
        });

    });

</script>
@endpush
