@extends('admin.index')
@section('content')
@php
use App\Models\Shipping\UnloadingShipmentsGoods;
use App\Models\Shipping\UnloadingShipmentsWorkers;
@endphp
    <title>{{trans('admin.UnloadingShipments')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Shipping')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.UnloadingShipments')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>{{trans('admin.UnloadingShipments')}}</i></span>
                        </h2>

                        <div class="panel-toolbar">

                            <a href="{{url('UnloadingShipments')}}" class="btn btn-default" >{{trans('admin.AddNew')}}</a>
                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <table id="dt-basic-example"
                                   class="table table-bordered table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                <tr>

                                    <th>{{trans('admin.Code')}}</th>
                                    <th>{{trans('admin.Date')}}</th>
                                    <th>{{trans('admin.Time')}}</th>
                                    <th>{{trans('admin.FromStore')}}</th>
                                    <th>{{trans('admin.ToStore')}}</th>
                                    <th>{{trans('admin.Car')}}</th>
                                    <th>{{trans('admin.Code')}} => {{trans('admin.ShipmentsDistribution')}}</th>
                                    <th>{{trans('admin.Delegate')}}</th>
                                    <th>{{trans('admin.Driver')}}</th>
                                    <th>{{trans('admin.Workers')}}</th>
                                    <th>{{trans('admin.Shipments')}}</th>
                                    <th>{{trans('admin.Actions')}}</th>

                                </tr>
                                </thead>
                                <tbody>

                                @foreach($items as $item)
                                    <tr @if($item->Status == 3) style="background-color: darkgreen; color: white" @endif>
                                        <td>{{$item->Code}}</td>
                                        <td>{{$item->Date}}</td>
                                        <td>{{$item->Time}}</td>
     
                                        <td>

                                            @if(!empty($item->FromStore()->first()->Name))

                                                {{$item->FromStore()->first()->Name}}

                                            @endif


                                        </td>

                                              

                                        <td>

                                            @if(!empty($item->ToStore()->first()->Name))

                                                {{$item->ToStore()->first()->Name}}

                                            @endif


                                        </td>

                                              

                                        <td>

                                            @if(!empty($item->Car()->first()->Name))

                                                {{$item->Car()->first()->Name}}

                                            @endif


                                        </td>
                                        
                                             <td>{{$item->ShipmentsDistributionCode}}</td>
                 

                                        <td>

                                            @if(!empty($item->Delegate()->first()->Name))

                                                {{$item->Delegate()->first()->Name}}

                                            @endif


                                        </td>
                 

                                        <td>

                                            @if(!empty($item->Driver()->first()->Name))

                                                {{$item->Driver()->first()->Name}}

                                            @endif


                                        </td>

                                    
                                   
                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Workers{{$item->id}}">
                                                {{trans('admin.Workers')}}</button>
                                        </td>


                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Shipments{{$item->id}}">
                                                {{trans('admin.Shipments')}}</button>
                                        </td>


                                        <td class="text-center">

                                             @if($item->Status == 0)
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>


                                    
                                            <a href="{{url('EditUnloadingShipments/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-edit"></i></a>
                                            @endif
                                            
                                         <a href="{{url('PrintUnloadingShipments/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-print"></i></a>
                                            
                                            


                                  

                                        </td>
                                    </tr>
                                @endforeach




                                </tbody>
                                <tfoot>
                                <tr>
                      <th>{{trans('admin.Code')}}</th>
                                    <th>{{trans('admin.Date')}}</th>
                                    <th>{{trans('admin.Time')}}</th>
                                    <th>{{trans('admin.FromStore')}}</th>
                                    <th>{{trans('admin.ToStore')}}</th>
                                    <th>{{trans('admin.Car')}}</th>
                                    <th>{{trans('admin.Code')}} => {{trans('admin.ShipmentsDistribution')}}</th>
                                    <th>{{trans('admin.Delegate')}}</th>
                                    <th>{{trans('admin.Driver')}}</th>
                                    <th>{{trans('admin.Workers')}}</th>
                                    <th>{{trans('admin.Shipments')}}</th>
                                    <th>{{trans('admin.Actions')}}</th>
                                </tr>
                                </tfoot>
                            </table>
                            {{$items->Links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>


        @foreach($items as $item)

            <!-- Modal Delete -->
            <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.RUSWDT')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                            <a href="{{url('DeleteUnloadingShipments/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Workers -->
            <div class="modal fade" id="Workers{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Workers')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                           @php  $WORKERS=UnloadingShipmentsWorkers::where('ShipmentsUnloading',$item->id)->get(); @endphp 
                            


                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Worker')}} </th>
                               

                                    </tr>
                                    </thead>
                                    <tbody id="">
                                            @foreach($WORKERS as $work)
                                        <tr>
                                           
                                            <td>
                                                @if(!empty($work->Worker()->first()->Name))

                                                    {{$work->Worker()->first()->Name}}

                                                @endif


                                            </td>
                                          



                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Shipments -->
            <div class="modal fade" id="Shipments{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Shipments')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                           @php  $Goods=UnloadingShipmentsGoods::where('ShipmentsUnloading',$item->id)->get(); @endphp 
                            


                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Shipping_Code')}} </th>
                                        <th>{{trans('admin.Shipping_Barcode')}} </th>
                                        <th>{{trans('admin.Shipping_Piecses')}} </th>
                                        <th>{{trans('admin.Shipping_Weight')}} </th>
                                        <th>{{trans('admin.Sender_Name')}} </th>
                                        <th>{{trans('admin.Receiver_Name')}} </th>
                                        <th>{{trans('admin.Shipping_Cost')}} </th>
                               

                                    </tr>
                                    </thead>
                                    <tbody id="">
                                            @foreach($Goods as $good)
                                        <tr>
                                           <td>{{$good->Code}}</td>
                                           <td>{{$good->Barcode}}</td>
                                           <td>{{$good->Total_Pieces}}</td>
                                           <td>{{$good->Total_Weight}}</td>
                                           <td>{{$good->Shipment_ID()->first()->Sender_Name}}</td>
                                           <td>{{$good->Shipment_ID()->first()->Receiver_Name}}</td>
                                            <td>{{$good->Total_Cost}}</td>
    
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>


                            
                                <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Total_Pieces')}} </th>
                                        <th>{{trans('admin.Total_Weight')}} </th>
                                        <th>{{trans('admin.Total_Cost')}} </th>
                                        <th>{{trans('admin.Count_Shipmets')}} </th>
                                
                                    </tr>
                                    </thead>
                                    <tbody id="">
                                        
                                        <tr>
                                           <td>{{$item->Total_Pieces}}</td>
                                           <td>{{$item->Total_Weight}}</td>
                                           <td>{{$item->Total_Cost}}</td>
                                           <td>{{$item->Count_Shipmets}}</td>
                                      
                                        </tr>
                        
                                    </tbody>
                                </table>
                            </div>


                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

     
  
        @endforeach
    </main>

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
@endpush

