@extends('admin.index')
@section('content')

    <title>{{trans('admin.TransportSechdule')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Shipping')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.TransportSechdule')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        
        
        
        <div class="row">
              
                               <!-- Filter -->
        <form action="{{url('FilterTransportSechdule')}}" method="get">
        <div class="row">
            

            <div class="col-md-3">
                <label>{{trans('admin.From')}}</label>
                <input class="form-control" name="From" type="date" value="{{date('Y-m-d')}}">
            </div>
            
            <div class="col-md-3">
                <label>{{trans('admin.To')}}</label>
                <input class="form-control" name="To" type="date" value="{{date('Y-m-d')}}">
            </div>
            
            
            <div class="col-md-3">
                <label>{{trans('admin.Sender')}}</label>
            <select class="select2 form-control" name="Sender" id="Sender" >
                <option value="">{{trans('admin.Sender')}}</option>
            
                
                @foreach($Customers as $cust)
                
                      <option value="{{$cust->id}}">{{$cust->Name}}</option>
                @endforeach

                
                </select>
            </div>
                

            <div class="col-md-3">
                <label>{{trans('admin.Receiver')}}</label>
                <select class="select2 form-control" name="Receiver" id="Receiver">
                    <option value="">{{trans('admin.Receiver')}}</option>

                    
                       
                
                @foreach($TransportReceiver as $tr)
                
                      <option value="{{$tr->id}}">{{$tr->Arabic_Name}}</option>
                @endforeach


                </select>
            </div>

         
         

            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">{{trans('admin.Payment_Method')}}</label>
                <select class="select2 form-control" name="Payment_Method" id="Payment_Method" >
                    <option value="">{{trans('admin.Payment_Method')}}</option>
                    <option value="Cash">{{trans('admin.Cash')}}</option>
                    <option value="Later">{{trans('admin.Later')}}</option>
                </select>
            </div>

            
            
                   
            <div class="col-md-3">
                <label>{{trans('admin.Arrival_Date')}}</label>
                <input class="form-control" name="Arrival_Date" type="date">
            </div>
            
            
            
                     <div class="col-md-4">
                <label>{{trans('admin.Code')}}</label>
                <input class="form-control" name="Code" type="text">
            </div>

            
            
              <div class="col-md-2">
            <button type="submit" class="btn btn-primary"><i class="fal fa-search"></i></button>      
            </div>
            
            
        </div>
            </form>
        
            
            
            
            
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>{{trans('admin.TransportSechdule')}}</i></span>
                        </h2>

                        <div class="panel-toolbar">

                            <a href="{{url('Transport')}}" class="btn btn-default" >{{trans('admin.AddNew')}}</a>
                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <table 
                                   class="table table-bordered table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                <tr>

                                
                                    <th>{{trans('admin.Code')}}</th>
                                    <th>{{trans('admin.Date')}}</th>
                                    <th>{{trans('admin.Sender_Name')}}</th>
                                    <th>{{trans('admin.Receiver_Name')}}</th>
                                    <th>{{trans('admin.Payment_Method')}}</th>

                                    <th>{{trans('admin.Details')}}</th>
                                    <th>{{trans('admin.Sender')}}</th>
                                    <th>{{trans('admin.Received')}}</th>
                                    <th>{{trans('admin.Cost')}}</th>
                                    <th>{{trans('admin.Actions')}}</th>

                                </tr>
                                </thead>
                                <tbody>

                                @foreach($items as $item)
                                    <tr>
                                      
                                        <td>{{$item->Code}}</td>
                                        <td>{{$item->Date}}</td>
                                     
                                        <td>{{$item->Sender_Name}}</td>
                                        <td>{{$item->Receiver_Name}}</td>


                                    
                                        <td>

                                            @if($item->Payment_Method == 'Cash')
                                                {{trans('admin.Cash')}}
                                            @elseif($item->Payment_Method == 'Later')
                                                {{trans('admin.Later')}}
                                            @endif




                                        </td>

            

                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Details{{$item->id}}">
                                                {{trans('admin.Details')}}</button>
                                        </td>


                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Sender{{$item->id}}">
                                                {{trans('admin.Sender')}}</button>
                                        </td>


                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Received{{$item->id}}">
                                                {{trans('admin.Received')}}</button>
                                        </td>


                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Cost{{$item->id}}">
                                                {{trans('admin.Cost')}}</button>
                                        </td>

                   
                                        <td class="text-center">

                                       
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>



                                            <a href="{{url('EditTransport/'.$item->id)}}" class="btn btn-default"><i class="fal fa-edit"></i></a>


                                            <a class="dropdown-item" href="{{ url('PrintTransport/'.$item->id.'?type=A4') }}">
                                                <i class="fal fa-print"></i> A4
                                            </a>   
                                

                

                                        </td>
                                    </tr>
                                @endforeach


                                </tbody>
                                <tfoot>
                                <tr>
                   
                                    <th>{{trans('admin.Code')}}</th>
                                    <th>{{trans('admin.Date')}}</th>
                                    <th>{{trans('admin.Sender_Name')}}</th>
                                    <th>{{trans('admin.Receiver_Name')}}</th>
                                    <th>{{trans('admin.Payment_Method')}}</th>

                                    <th>{{trans('admin.Details')}}</th>
                                    <th>{{trans('admin.Sender')}}</th>
                                    <th>{{trans('admin.Received')}}</th>
                                    <th>{{trans('admin.Cost')}}</th>
                                    <th>{{trans('admin.Actions')}}</th>
                                    

                                </tr>
                                </tfoot>
                            </table>
                            {{$items->Links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>


        @foreach($items as $item)

            <!-- Modal Delete -->
            <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.RUSWDT')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                            <a href="{{url('DeleteTransport/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Details -->
            <div class="modal fade" id="Details{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Details')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                    
                                        <th>{{trans('admin.Time')}} </th>
                                        <th>{{trans('admin.Arrival_Date')}} </th>
                                        <th>{{trans('admin.Arrival_Time')}} </th>
                                        <th>{{trans('admin.Reference_Num')}} </th>
                                        <th>{{trans('admin.Weight')}} </th>
                                        <th>{{trans('admin.Note')}} </th>
                                        <th>{{trans('admin.Insurance')}} </th>
                                        <th>{{trans('admin.Safe')}} </th>
                                        <th>{{trans('admin.Coin')}} </th>
                                        <th>{{trans('admin.Draw')}} </th>
                                        <th>{{trans('admin.Cost_Center')}} </th>
                                    
                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                         
                                            <td>{{$item->Time}}</td>
                                            <td>{{$item->Arrival_Date}}</td>
                                            <td>{{$item->Arrival_Time}}</td>
                                            <td>{{$item->Reference_Num}}</td>
                                            <td>{{$item->Weight}}</td>
                                            <td>{{$item->Note}}</td>
                                       
                             
                                             <td>

                                                 @if($item->Insurance == 'Yes')
                                                    {{trans('admin.Yes')}}
                                                @elseif($item->Insurance == 'No')
                                                    {{trans('admin.No')}}
                                                @endif

                                            </td>
                                            
                                                      <td>

                                                @if(!empty($item->Safe()->first()->Name))

                                                    {{$item->Safe()->first()->Name}}

                                                @endif


                                            </td>
                                            
                                                       
                                                      <td>

                                                @if(!empty($item->Coin()->first()->Arabic_Name))

                                                    {{$item->Coin()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                                          
                                   
                                            
                                                    <td>{{$item->Draw}}</td>
                                            
                                            
                                            <td>

                                                @if(!empty($item->Cost_Center()->first()->Arabic_Name))

                                                    {{$item->Cost_Center()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            




                                        </tr>

                                    </tbody>
                                </table>
                            </div>



                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Sender -->
            <div class="modal fade" id="Sender{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Sender')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Name')}} </th>
                                        <th>{{trans('admin.Governorate')}} </th>
                                        <th>{{trans('admin.City')}} </th>
                                        <th>{{trans('admin.Place')}} </th>
                                        <th>{{trans('admin.Address')}} </th>
                                        <th>{{trans('admin.Phone1')}} </th>
                                        <th>{{trans('admin.Phone2')}} </th>
                                        <th>{{trans('admin.Location')}} </th>
                                   

                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                            <td>{{$item->Sender_Name}}</td>
                                            <td>

                                                @if(!empty($item->Sender_Governorate()->first()->Arabic_Name))

                                                    {{$item->Sender_Governorate()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            <td>

                                                @if(!empty($item->Sender_City()->first()->Arabic_Name))

                                                    {{$item->Sender_City()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            <td>

                                                @if(!empty($item->Sender_Place()->first()->Arabic_Name))

                                                    {{$item->Sender_Place()->first()->Arabic_Name}}

                                                @endif


                                            </td>

                                            <td>{{$item->Sender_Address}}</td>
                                            <td>{{$item->Sender_Phone1}}</td>
                                            <td>{{$item->Sender_Phone2}}</td>
                                            <td>{{$item->Sender_Location}}</td>





                                        </tr>

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Received -->
            <div class="modal fade" id="Received{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Received')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Name')}} </th>
                                        <th>{{trans('admin.Governorate')}} </th>
                                        <th>{{trans('admin.City')}} </th>
                                        <th>{{trans('admin.Place')}} </th>
                                        <th>{{trans('admin.Address')}} </th>
                                        <th>{{trans('admin.Phone1')}} </th>
                                        <th>{{trans('admin.Phone2')}} </th>
                                        <th>{{trans('admin.Location')}} </th>
                           


                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                            <td>{{$item->Receiver_Name}}</td>
                                            <td>

                                                @if(!empty($item->Receiver_Governorate()->first()->Arabic_Name))

                                                    {{$item->Receiver_Governorate()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            <td>

                                                @if(!empty($item->Receiver_City()->first()->Arabic_Name))

                                                    {{$item->Receiver_City()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            <td>

                                                @if(!empty($item->Receiver_Place()->first()->Arabic_Name))

                                                    {{$item->Receiver_Place()->first()->Arabic_Name}}

                                                @endif


                                            </td>

                                            <td>{{$item->Receiver_Address}}</td>
                                            <td>{{$item->Receiver_Phone1}}</td>
                                            <td>{{$item->Receiver_Phone2}}</td>
                                            <td>{{$item->Receiver_Location}}</td>

                                  





                                        </tr>

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Cost -->
            <div class="modal fade" id="Cost{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Cost')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Type')}} </th>
                                        <th>{{trans('admin.Value')}} </th>
                                        <th>{{trans('admin.Pay')}} </th>
                                        
                                        
                                        @if($item->Type == 'In')
                                        <th>{{trans('admin.Expenses_Precent')}} </th>
                                        <th>{{trans('admin.Expenses_Value')}} </th>
                                        <th>{{trans('admin.Driver')}} </th>
                                        <th>{{trans('admin.Car')}} </th>
                                        <th>{{trans('admin.Driver_Precent')}} </th>
                                        <th>{{trans('admin.Driver_Value')}} </th>
                                         @else     
                                        <th>{{trans('admin.Contractor')}} </th>
                                        <th>{{trans('admin.Contractor_Precent')}} </th>
                                        <th>{{trans('admin.Contractor_Value')}} </th>
                                          @endif

                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                            <td>
                                            
                                                       @if($item->Type == 'In')
                                                    {{trans('admin.Inside')}}
                                                @elseif($item->Type == 'Out')
                                                    {{trans('admin.Outside')}}
                                                @endif
                                            
                                            
                                            </td>
                                            <td>{{$item->Value}}</td>
                                            <td>{{$item->Pay}}</td>
                                        
                                            
                                                 @if($item->Type == 'In')
                                            
                                                  <td>{{$item->Expenses_Precent}}</td>
                                            <td>{{$item->Expenses_Value}}</td>
                                            <td>
                                            
                                            
                                            
                                                @if(!empty($item->Driver()->first()->Name))

                                                    {{$item->Driver()->first()->Name}}

                                                @endif

                                            
                                            
                                            </td>
                                                       <td>
                                            
                                            
                                            
                                                @if(!empty($item->Car()->first()->Name))

                                                    {{$item->Car()->first()->Name}}

                                                @endif

                                            
                                            
                                            </td>
                                            
                                            
                                            
                                        
                                            <td>{{$item->Driver_Precent}}</td>
                                            <td>{{$item->Driver_Value}}</td>
         @else 
                                            
                                            
                                    
                                            
                                                                   <td>
                                            
                                            
                                            
                                                @if(!empty($item->Contractor()->first()->Arabic_Name))

                                                    {{$item->Contractor()->first()->Arabic_Name}}

                                                @endif

                                            
                                            
                                            </td>
                                            
                                            <td>{{$item->Contractor_Precent}}</td>
                                            <td>{{$item->Contractor_Value}}</td>
      @endif
                                            
                                      





                                        </tr>

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>



        @endforeach
    </main>

@endsection

@push('js')
 <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


    <!-- Search Select -->
    <script>
        
           
        $(document).ready(function () {
            $(function () {
                $(".select2").select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State",
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0,
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items",
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true,
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm;
                    },
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
                }

                         
     $('#Sender').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllCli',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                
                            
     $('#Receiver').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllCli',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                
                      
                            
     $('#Delegate').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllEmps',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                
                               
     $('#Driver').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllEmps',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                  
          
         $('#FromStore').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllStores',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                 
         $('#ToStore').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllStores',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                  
                  
          

            });
        });
    </script>

@endpush

