@extends('admin.index')
@section('content')

    <title>{{trans('admin.TransportPrices')}}</title>

    <main id="js-page-content" role="main" class="page-content">

        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Shipping')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.TransportPrices')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>{{trans('admin.TransportPrices')}}</i></span>
                        </h2>

                        <div class="panel-toolbar">


                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg">{{trans('admin.AddNew')}}</button>


                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <div id="mobile-overflow">
                                <table id="dt-basic-example"
                                       class="table table-bordered table-hover table-striped w-100 mobile-width">
                                    <thead class="bg-highlight">
                                    <tr>
                                        <th>{{trans('admin.From')}}</th>
                                        <th>{{trans('admin.To')}}</th>
                                        <th>{{trans('admin.Value')}}</th>
                                
                                        <th>{{trans('admin.Actions')}}</th>

                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach($items as $item)
                                        <tr>
                              
                                 
                                            
                                            <td>
                                            
                                            @if(!empty($item->From_Place()->first()->Arabic_Name))
                                                {{$item->From_Place()->first()->Arabic_Name}}
                                            @endif
                                            
                                            </td>
                                            <td>
                                            
                                                @if(!empty($item->To_Place()->first()->Arabic_Name))
                                                {{$item->To_Place()->first()->Arabic_Name}}
                                            @endif
                                           
                                            
                                            </td>
                                              <td>{{$item->Value}}</td>
                                            
                                        
                                            
                                         
                                            <td class="text-center">


                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>



                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>

                                            </td>
                                        </tr>
                                    @endforeach


                                    </tbody>
                                    <tfoot>
                                    <tr>
                                 <th>{{trans('admin.From')}}</th>
                                        <th>{{trans('admin.To')}}</th>
                                        <th>{{trans('admin.Value')}}</th>
                                
                                        <th>{{trans('admin.Actions')}}</th>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <!-- datatable end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Add-->
        <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{trans('admin.AddNew')}}  </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form action="{{url('AddTransportPrices')}}" method="post">
                            {!! csrf_field() !!}
                            @honeypot
                            <div class="form-row">
                         
                         
                        
                                  <div class="form-group col-lg-4">
                                                    <label class="form-label" for=""> {{trans('admin.From')}}</label>
                                                    <select class="select2 form-control w-100 " name="From_Place">
                                                        <option value="">{{trans('admin.From')}}</option>
                                                        @foreach($Places as $pla)
                                                            <option value="{{$pla->id}}">

                                                                {{app()->getLocale() == 'ar' ?$pla->Arabic_Name :$pla->English_Name}}
                                                            </option>
                                                        @endforeach
                                                    </select>


                                                </div>
                                    
                        
                                  <div class="form-group col-lg-4">
                                                    <label class="form-label" for=""> {{trans('admin.To')}}</label>
                                                    <select class="select2 form-control w-100 " name="To_Place">
                                                        <option value="">{{trans('admin.To')}}</option>
                                                        @foreach($Places as $pla)
                                                            <option value="{{$pla->id}}">

                                                                {{app()->getLocale() == 'ar' ?$pla->Arabic_Name :$pla->English_Name}}
                                                            </option>
                                                        @endforeach
                                                    </select>


                                                </div>
                                
                                
                                        <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Value')}}</label>
                                    <input type="number" step="any" name="Value" value="{{old('Value')}}"  class="form-control" required>
                                </div>
                              







                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>



        @foreach($items as $item)

            <!-- Modal Edit -->
            <div class="modal fade" id="default-example-modal-lg-edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">{{trans('admin.Edit')}}  </h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form action="{{url('EditTransportPrices/'.$item->id)}}" method="post">
                                {!! csrf_field() !!}
                                @honeypot
                             <div class="form-row">
                         
                 

                                        
                                  <div class="form-group col-lg-4">
                                                    <label class="form-label" for=""> {{trans('admin.From')}}</label>
                                                    <select class="select2 form-control w-100 " name="From_Place">
                                                        <option value="">{{trans('admin.From')}}</option>
                                                        @foreach($Places as $pla)
                                                            <option value="{{$pla->id}}" @if($item->From_Place == $pla->id) selected @endif>

                                                                {{app()->getLocale() == 'ar' ?$pla->Arabic_Name :$pla->English_Name}}
                                                            </option>
                                                        @endforeach
                                                    </select>


                                                </div>
                                    
                        
                                  <div class="form-group col-lg-4">
                                                    <label class="form-label" for=""> {{trans('admin.To')}}</label>
                                                    <select class="select2 form-control w-100 " name="To_Place">
                                                        <option value="">{{trans('admin.To')}}</option>
                                                        @foreach($Places as $pla)
                                                            <option value="{{$pla->id}}" @if($item->To_Place == $pla->id) selected @endif>

                                                                {{app()->getLocale() == 'ar' ?$pla->Arabic_Name :$pla->English_Name}}
                                                            </option>
                                                        @endforeach
                                                    </select>


                                                </div>
                                
                                
                                        <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Value')}}</label>
                                    <input type="number" step="any" name="Value" value="{{$item->Value}}"  class="form-control" required>
                                </div>
                              

                            </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Delete -->
            <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.RUSWDT')}}
                              
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                            <a href="{{url('DeleteTransportPrices/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                        </div>
                    </div>
                </div>
            </div>

        @endforeach
    </main>

@endsection

@push('js')
     <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


    <!-- Search Select -->
    <script>
        $(document).ready(function () {
            $(function () {
                $(".select2").select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State",
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0,
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items",
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true,
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm;
                    },
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
                }

                $(".Delegate").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "DelegatesShippingFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {

                            $.ajax({
                                url: 'DelegatesShippingFilterJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('.Delegate').empty();
                                    $.each(data, function(key, value){

                                        $('.Delegate').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $(".Delegate").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });


                $(".Driver").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "DriversShippingFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {

                            $.ajax({
                                url: 'DriversShippingFilterJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('.Driver').empty();
                                    $.each(data, function(key, value){

                                        $('.Driver').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $(".Driver").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });


                $(".Cost_Center").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "Cost_CenterShippingFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {

                            $.ajax({
                                url: 'Cost_CenterShippingFilterJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('.Cost_Center').empty();
                                    $.each(data, function(key, value){

                                        $('.Cost_Center').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $(".Cost_Center").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });

                $("#Cost_CenterX").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "Cost_CenterShippingFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {

                            $.ajax({
                                url: 'Cost_CenterShippingFilterJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#Cost_CenterX').empty();
                                    $.each(data, function(key, value){

                                        $('#Cost_CenterX').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $("#Cost_CenterX").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });


                
                
                $("#DelegateX").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "DelegatesShippingFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {

                            $.ajax({
                                url: 'DelegatesShippingFilterJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#DelegateX').empty();
                                    $.each(data, function(key, value){

                                        $('#DelegateX').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $("#DelegateX").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });


                $("#DriverX").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "DriversShippingFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {

                            $.ajax({
                                url: 'DriversShippingFilterJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#DriverX').empty();
                                    $.each(data, function(key, value){

                                        $('#DriverX').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $("#DriverX").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });

                
                
                

            });
        });
    </script>


@endpush

