@extends('admin.index')
@section('content')
<title>{{trans('admin.Transport')}}</title>
<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Shipping')}}</a></li>
        <li class="breadcrumb-item active"> {{trans('admin.Transport')}} </li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>
    <!-- CSS -->
    <style>
        .BORDER.spark {
            height: 6px;
            border-radius: 6px;
            background: linear-gradient(90deg,
                    #fffacd,
                    /* Lemon Chiffon */
                    #fafad2,
                    /* Light Goldenrod Yellow */
                    #ffd700,
                    /* Gold */
                    #fafad2,
                    #fffacd);
            position: relative;
            overflow: hidden;
            margin: 14px 0;
        }

        .BORDER.spark::before {
            content: "";
            position: absolute;
            top: 0;
            left: -50px;
            width: 50px;
            height: 100%;
            background: linear-gradient(90deg,
                    transparent,
                    rgba(255, 255, 255, 0.9),
                    transparent);
            animation: sparkMove 1.2s linear infinite;
        }

        @keyframes sparkMove {
            0% {
                left: -50px;
            }

            100% {
                left: 100%;
            }
        }

        .boxed-section {
            border: 2px solid #ddd;
            border-radius: 8px;
            padding: 15px 20px;
            margin-bottom: 20px;
            background: #f9f9f9;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
        }

        .boxed-section .section-title {
            font-size: 16px;
            font-weight: bold;
            color: #444;
            margin-bottom: 15px;
            border-bottom: 1px solid #ccc;
            padding-bottom: 5px;
        }
    </style>
    <!-- data entry -->
    <div class="row">
        <div class="col-lg-12">
            <div id="panel-2" class="panel">
                <div class="panel-hdr">
                </div>
                <div class="panel-container show">
                    <span id="ex"> @include('admin.layouts.messages')</span>
                    <div class="panel-content">
                        <ul class="nav nav-tabs" role="tablist">
                            <!--<li class="nav-item">-->
                            <!--   <a class="nav-link active" data-toggle="tab" href="#tab_borders_icons-8" role="tab">   {{trans('admin.Shipment')}}  </a>-->
                            <!--</li>-->
                        </ul>
                        <div class="tab-content border border-top-0 p-3">
                            <div class="tab-pane fade show active" id="tab_borders_icons-8" role="tabpanel">
                                <form action="{{url('AddNewTransport')}}" method="post" enctype="multipart/form-data" class="form-row">
                                    {!! csrf_field() !!}
                                    @honeypot
                                    <div class="col-md-12">
                                        <div class="data-def">
                                            <div class="form-row">
                                                <div class="boxed-section">
                                               
                                                    <div class="row">
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                                            <input type="text" value="{{$Code}}" name="Code" class="form-control " readonly>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Reference_Num')}}</label>
                                                            <input type="text" name="Reference_Num" value="{{old('Reference_Num')}}" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                                            <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Arrival_Date')}}</label>
                                                            <input type="date" name="Arrival_Date" value="{{old('Arrival_Date')}}" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Arrival_Time')}}</label>
                                                            <input type="time" name="Arrival_Time" value="{{old('Arrival_Time')}}" class="form-control">
                                                        </div>
                                          
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Payment_Method')}}</label>
                                                            <select class="select2 form-control" name="Payment_Method" id="Payment_Method" required>
                                                                <option value="">{{trans('admin.Payment_Method')}}</option>
                                                                <option value="Cash" @if($Def->Payment_Method == 'Cash') selected @endif>{{trans('admin.Cash')}}</option>
                                                                <option value="Later" @if($Def->Payment_Method == 'Later') selected @endif>{{trans('admin.Later')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Safe')}}</label>
                                                            <select class="select2 form-control" name="Safe" id="Safe" required>


                                                                @if(!empty($Def->Safe()->first()->Name))
                                                                <option value="{{$Def->Safe}}">

                                                                    {{app()->getLocale() == 'ar' ?$Def->Safe()->first()->Name :$Def->Safe()->first()->NameEn}}

                                                                </option>

                                                                @endif

                                                            </select>
                                                        </div>
                                                                          <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Cost_Center')}}</label>
                                                            <select class="select2 form-control" name="Cost_Center" id="Cost_Center" >

                                                            </select>
                                                        </div>
                                                        
                                                        
                                                        
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Coin')}}</label>
                                                            <select class="select2 form-control" name="Coin" id="Coin" required>



                                                                @if(!empty($Def->Coin()->first()->Arabic_Name))
                                                                <option value="{{$Def->Coin}}">

                                                                    {{app()->getLocale() == 'ar' ?$Def->Coin()->first()->Arabic_Name :$Def->Coin()->first()->English_Name}}

                                                                </option>

                                                                @endif



                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                                            <input type="number" step="any" name="Draw" value="{{$Def->Draw}}" class="form-control" required>
                                                        </div>

                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Insurance')}}</label>
                                                            <select class="select2 form-control" name="Insurance" id="Insurance">
                                                                <option value="">{{trans('admin.Insurance')}}</option>
                                                                <option value="Yes" @if($Def->Insurance == 'Yes') selected @endif>{{trans('admin.Yes')}}</option>
                                                                <option value="No" @if($Def->Insurance == 'No') selected @endif>{{trans('admin.No')}}</option>
                                                            </select>
                                                        </div>
                                                    
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Weight')}}</label>
                                                            <input type="number" step="any" name="Weight" id="Weight" value="0" class="form-control">
                                                        </div>
                                                       
                                                        
                                                             <div class="form-group col-lg-6">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Note')}}</label>
                                                            <textarea name="Note" class="form-control">{{old('Note')}}</textarea>
                                                        </div>
                                      
                                                        
               
                                                    </div>
                                                </div>



                                                <!-- Sender -->
                                                <div class="boxed-section">
                                                    <h5 class="section-title">{{ trans('admin.Sender_Information') }}</h5>
                                                    <div class="row">
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Sender')}}</label>
                                                            <select class="select2 form-control" name="Sender" id="Sender" onchange="SenderData()" required>
                                                                <option value="">{{trans('admin.Sender')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-1">

                                                            <button style="margin: 22px" type="button" class="btn btn-default" data-toggle="modal" data-target="#NewClient">
                                                                <i class="fal fa-user"></i>
                                                            </button>

                                                            <!-- Modal New Client -->
                                                            <div class="modal fade" id="NewClient" tabindex="-1" role="dialog" aria-hidden="true">
                                                                
                                                                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h4 class="modal-body row">
                                                                                <div class="form-group col-md-4">
                                                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Name')}} </label><span class="strick">*</span>
                                                                                    <input type="text" id="Name" value="{{old('Name')}}" class="form-control">
                                                                                </div>
                                                                                <div class="form-group col-lg-4">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.Phone1')}}</label>
                                                                                    <input type="tel" value="{{old('Phone1')}}" id="Phone1" class="form-control">
                                                                                </div>
                                                                                <div class="form-group col-lg-4">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.Phone2')}}</label>
                                                                                    <input type="tel" value="{{old('Phone2')}}" id="Phone2" class="form-control">
                                                                                </div>
                                                                                <div class="form-group col-lg-4">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.Governrate')}}</label>
                                                                                    <select class="select2 form-control" id="Governrate">
                                                                                        <option value="">{{trans('admin.Governrate')}}</option>
                                                                                    </select>
                                                                                </div>
                                                                                <div class="form-group col-lg-4">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.City')}}</label>
                                                                                    <select class="select2 form-control" id="City">
                                                                                        <option value="">{{trans('admin.City')}}</option>
                                                                                    </select>
                                                                                </div>
                                                                                <div class="form-group col-lg-4">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.Place')}}</label>
                                                                                    <select class="select2 form-control" id="Place">
                                                                                        <option value="">{{trans('admin.Place')}}</option>
                                                                                    </select>
                                                                                </div>
                                                                                <div class="form-group col-lg-12">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.Address')}}</label>
                                                                                    <input type="text" value="{{old('Address')}}" id="Address" class="form-control">
                                                                                </div>
                                                                            </h4>
                                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                                                            </button>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                                                                            <button type="button" onclick="NewClients()" class="btn btn-primary"> {{trans('admin.AddNew')}}</button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                                        <!-- Modal New Recived -->
                                                            <div class="modal fade" id="NewRecived" tabindex="-1" role="dialog" aria-hidden="true">
                                                                
                                                                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h4 class="modal-body row">
                                                                                <div class="form-group col-md-4">
                                                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Name')}} </label><span class="strick">*</span>
                                                                                    <input type="text" id="RName" class="form-control">
                                                                                </div>
                                                                                <div class="form-group col-lg-4">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.Phone1')}}</label>
                                                                                    <input type="tel"  id="RPhone1" class="form-control">
                                                                                </div>
                                                                                <div class="form-group col-lg-4">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.Phone2')}}</label>
                                                                                    <input type="tel"  id="RPhone2" class="form-control">
                                                                                </div>
                                                                                <div class="form-group col-lg-4">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.Governrate')}}</label>
                                                                                    <select class="select2 form-control" id="RGovernrateX" >
                                                                                  <option value="">{{trans('admin.Governrate')}}</option>
                                                                                    </select>
                                                                                </div>
                                                                                <div class="form-group col-lg-4">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.City')}}</label>
                                                                                    <select class="select2 form-control" id="RCityX">
                                                                                      
                                                                                    </select>
                                                                                </div>
                                                                                <div class="form-group col-lg-4">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.Place')}}</label>
                                                                                    <select class="select2 form-control" id="RPlaceX">
                                                                          
                                                                                    </select>
                                                                                </div>
                                                                                <div class="form-group col-lg-12">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.Address')}}</label>
                                                                                    <input type="text"  id="RAddress" class="form-control">
                                                                                </div>
                                                                            </h4>
                                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                                                            </button>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                                                                            <button type="button" onclick="NewRecived()" class="btn btn-primary"> {{trans('admin.AddNew')}}</button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                            
                                                            
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Sender_Name')}}</label>
                                                            <input type="text" name="Sender_Name" value="{{old('Sender_Name')}}" id="Sender_Name" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Phone1')}}</label>
                                                            <input type="tel" name="Sender_Phone1" value="{{old('Sender_Phone1')}}" id="Sender_Phone1" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Phone2')}}</label>
                                                            <input type="tel" name="Sender_Phone2" value="{{old('Sender_Phone2')}}" id="Sender_Phone2" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Location')}}</label>
                                                            <input type="text" name="Sender_Location" value="{{old('Sender_Location')}}" id="Sender_Location" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Governrate')}}</label>
                                                            <select class="select2 form-control" name="Sender_Governorate" id="Sender_Governorate" required>
                                                                <option value="">{{trans('admin.Governrate')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.City')}}</label>
                                                            <select class="select2 form-control" name="Sender_City" id="Sender_City" required>
                                                                <option value="">{{trans('admin.City')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Place')}}</label>
                                                            <select class="select2 form-control" name="Sender_Place" id="Sender_Place" required>
                                                                <option value="">{{trans('admin.Place')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Address')}}</label>
                                                            <input type="text" name="Sender_Address" value="{{old('Sender_Address')}}" id="Sender_Address" class="form-control" required>
                                                        </div>
                                                    </div>
                                                    
                                                    
                                                   
                                                    
                                                    
                                                </div>

                                             
                                                <!-- Recived -->
                                         
                                                <div class="boxed-section">
                                                    <h5 class="section-title">{{ trans('admin.Receiver_Information') }}</h5>
                                                    <div class="row">
                                           
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Received')}}</label>
                                                            <select class="select2 form-control" name="Received" id="Received" onchange="ReciverData()" required>
                                                                <option value="">{{trans('admin.Received')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-1">
                                                            <button style="margin: 22px" type="button" class="btn btn-default" data-toggle="modal" data-target="#NewRecived">
                                                                <i class="fal fa-user"></i>
                                                            </button>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Receiver_Name')}}</label>
                                                            <input type="text" name="Receiver_Name" value="{{old('Receiver_Name')}}" id="Receiver_Name" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Phone1')}}</label>
                                                            <input type="tel" name="Receiver_Phone1" value="{{old('Receiver_Phone1')}}" id="Receiver_Phone1" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Phone2')}}</label>
                                                            <input type="tel" name="Receiver_Phone2" value="{{old('Receiver_Phone2')}}" id="Receiver_Phone2" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Location')}}</label>
                                                            <input type="text" name="Receiver_Location" value="{{old('Receiver_Location')}}" id="Receiver_Location" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Governrate')}}</label>
                                                            <select class="select2 form-control" name="Receiver_Governorate" id="Receiver_Governorate" required>
                                                                <option value="">{{trans('admin.Governrate')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.City')}}</label>
                                                            <select class="select2 form-control" name="Receiver_City" id="Receiver_City" required>
                                                                <option value="">{{trans('admin.City')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Place')}}</label>
                                                            <select class="select2 form-control" name="Receiver_Place" id="Receiver_Place" required>
                                                                <option value="">{{trans('admin.Place')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Address')}}</label>
                                                            <input type="text" name="Receiver_Address" value="{{old('Receiver_Address')}}" id="Receiver_Address" class="form-control" required>
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="boxed-section">

                                                     <!-- Total -->
                                                  <div class="row">
                                                       
                                
                                                        
                                                        
                                                        <div class="form-group col-lg-4">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Type')}}</label>
                                                            <select class="select2 form-control" name="Type" id="Type" onchange="TypeChange()" required>
                                                                <option value="">{{trans('admin.Type')}}</option>
                                                                <option value="In">{{trans('admin.Inside')}}</option>
                                                                <option value="Out">{{trans('admin.Outside')}}</option>
                                                            </select>
                                                        </div>
                                                    
                                                        
                                                   
                                                        
                                                             
                                                        <div class="form-group col-lg-4">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Value')}}</label>
                                                            <input type="number" step="any" name="Value" onclick="Fun()" onkeyup="Fun()" id="Value" value="0" class="form-control" required>
                                                        </div>
                                                       
                                                             
                                                        <div class="form-group col-lg-4">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Pay')}}</label>
                                                            <input type="number" step="any" name="Pay" id="Pay" value="0" class="form-control" required>
                                                        </div>
                                                       
                                                        
                                                        
                                                        
                                                        
                                                        
                                                        <div class="form-group col-lg-12" style="display: none" id="INSIDE">
                                                            
                                                        <div class="form-group row">
                                                      
                                                            
                                                                                            
                                                        <div class="form-group col-lg-4">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Expenses_Precent')}}</label>
                                                            <input type="number" step="any" name="Expenses_Precent" onclick="PrecentFun()" onkeyup="PrecentFun()" id="Expenses_Precent" value="0" class="form-control" >
                                                        </div>
                                                       
                                                                                 
                                                        <div class="form-group col-lg-4">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Expenses_Value')}}</label>
                                                            <input type="number" step="any" name="Expenses_Value" id="Expenses_Value" value="0" class="form-control" readonly >
                                                        </div>
                                                                                        
                                                        <div class="form-group col-lg-4">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.The_Net')}}</label>
                                                            <input type="number" step="any" name="The_Net" id="The_Net" value="0" class="form-control" readonly >
                                                        </div>
                                                       

                                                                      <div class="form-group col-lg-6">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Driver')}}</label>
                                                            <select class="select2 form-control" name="Driver" id="Driver" onchange="DriverChange()">
                                                                <option value="">{{trans('admin.Driver')}}</option>
                                                            </select>
                                                        </div>
                                                                 
                                                                      <div class="form-group col-lg-6">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Car')}}</label>
                                                            <select class="select2 form-control" name="Car" id="Car">
                                                                <option value="">{{trans('admin.Car')}}</option>
                                                            </select>
                                                        </div>
                                                        
                                                      
                                                                        
                                                        <div class="form-group col-lg-6">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Driver_Precent')}}</label>
                                                            <input type="number" step="any" name="Driver_Precent" id="Driver_Precent" value="0" class="form-control" >
                                                        </div>
                                                       
                                                                                 
                                                        <div class="form-group col-lg-6">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Driver_Value')}}</label>
                                                            <input type="number" step="any" name="Driver_Value" id="Driver_Value" value="0" class="form-control" >
                                                        </div>
                                                       
                                                        
                                                        
                                                        </div>
                                                            
                                                        </div>
                                                        
                                                               
                                                        <div class="form-group col-lg-12" style="display: none" id="OUTSIDE">
                                                            
                                                        <div class="form-group row">
                                                        
                                                            
                                                                      <div class="form-group col-lg-4">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Contractor')}}</label>
                                                            <select class="select2 form-control" name="Contractor" id="Contractor" >
                                                                <option value="">{{trans('admin.Contractor')}}</option>
                                                            </select>
                                                        </div>
                                                                 
                                                     
                                                      
                                                                        
                                                        <div class="form-group col-lg-4">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Contractor_Precent')}}</label>
                                                            <input type="number" step="any" onclick="PrecentContractorFun()" onkeyup="PrecentContractorFun()" name="Contractor_Precent"  id="Contractor_Precent" value="0" class="form-control" >
                                                        </div>
                                                       
                                                                                 
                                                        <div class="form-group col-lg-4">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Contractor_Value')}}</label>
                                                            <input type="number" step="any" name="Contractor_Value" id="Contractor_Value" value="0" class="form-control" >
                                                        </div>
                                                       
                                                        
                                                        
                                                        </div>
                                                            
                                                        </div>
                                                        
                                                            
                                                        
                                                    </div>
                                                
                                                </div>  

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#Save" onclick="ChangeStatus(1)"> <i class="fal fa-folder"></i> {{trans('admin.Save')}} </button>
                                        <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#Save" onclick="ChangeStatus(2)"> <i class="fal fa-folder"></i> {{trans('admin.SaveandPrint')}} </button>
                             
                                        <input type="hidden" id="Status" name="Status" value="1">

                                        <!-- Modal Submit -->
                                        <div class="modal fade" id="Save" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">
                                                            {{trans('admin.Submit')}}
                                                        </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                                        </button>
                                                    </div>

                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                                                        <button type="submit" class="btn btn-primary"> {{trans('admin.Yes')}}</button>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<style>
    .BORDER {
        border-bottom: 3px solid black;
        margin-bottom: 50px;
        margin-top: 50px;
    }
</style>
@endsection
@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script>
    //_fnFeatureHtmlLength();
    $(document).ready(function() {
        // Setup - add a text input to each footer cell
        $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
        $('#dt-basic-example thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

            $('input', this).on('keyup change', function() {
                if (table.column(i).search() !== this.value) {
                    table
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });
        var table = $('#dt-basic-example').DataTable({
            responsive: true,
            orderCellsTop: true,
            fixedHeader: true,
            lengthChange: true,

            dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

            buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'colvis',
                    text: 'Column Visibility',
                    titleAttr: 'Col visibility',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    titleAttr: 'Generate PDF',
                    className: 'btn-outline-danger btn-sm mr-1'
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    titleAttr: 'Generate Excel',
                    className: 'btn-outline-success btn-sm mr-1'
                },
                {
                    extend: 'csvHtml5',
                    text: 'CSV',
                    titleAttr: 'Generate CSV',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'copyHtml5',
                    text: 'Copy',
                    titleAttr: 'Copy to clipboard',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'print',
                    text: 'Print',
                    titleAttr: 'Print Table',
                    className: 'btn-outline-primary btn-sm'
                }
            ],
        });
        $('.js-thead-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
        });

        $('.js-tbody-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
        });

    });
</script>
<!-- Search Select -->
<script>
    
    $(document).ready(function() {
        $(function() {
            $(".select2").select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State",
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0,
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items",
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true,
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm;
                },
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
            }

            $("#Delegate").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "DelegatesShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'DelegatesShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Delegate').empty();
                                $.each(data, function(key, value) {

                                    $('#Delegate').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Delegate").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });


            $("#Driver").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "DriversShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'DriversShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Driver').empty();
                                $.each(data, function(key, value) {

                                    $('#Driver').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Driver").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });



            $("#Sender").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "SenderShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'SenderShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Sender').empty();
                                $.each(data, function(key, value) {

                                    $('#Sender').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Sender").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });





            $("#Sender_Governorate").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "GovShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'GovShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Sender_Governorate').empty();
                                $.each(data, function(key, value) {

                                    $('#Sender_Governorate').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Sender_Governorate").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });


            $("#Receiver_Governorate").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "GovShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'GovShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Receiver_Governorate').empty();
                                $.each(data, function(key, value) {

                                    $('#Receiver_Governorate').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Receiver_Governorate").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });




            $("#Governrate").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "GovShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'GovShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Governrate').empty();
                                $.each(data, function(key, value) {

                                    $('#Governrate').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Governrate").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });



            $("#RGovernrateX").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "GovShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'GovShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#RGovernrateX').empty();
                                $.each(data, function(key, value) {

                                    $('#RGovernrateX').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#RGovernrateX").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });




            $('#Coin').select2({
                placeholder: "Select...",
                allowClear: true,
                ajax: {
                    // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
                    url: 'NewAllCoins',
                    dataType: 'json',
                    delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
                    data: function(params) {
                        // Select2 هيبعت كلمة البحث باسم 'term'
                        return {
                            term: params.term // ده الكلمة اللي بيكتبها المستخدم
                        };
                    },
                    processResults: function(data) {
                        // هنا Select2 بيستقبل البيانات من السيرفر
                        // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
                        var results = [];
                        $.each(data, function(key, value) {
                            results.push({
                                id: key, // الـ ID بتاع الحساب
                                text: value // الاسم بتاع الحساب
                            });
                        });

                        return {
                            results: results
                        };
                    },
                    cache: true
                }
            });

            $('#Safe').select2({
                placeholder: "Select...",
                allowClear: true,
                ajax: {
                    // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
                    url: 'NewAllSafesBanks',
                    dataType: 'json',
                    delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
                    data: function(params) {
                        // Select2 هيبعت كلمة البحث باسم 'term'
                        return {
                            term: params.term // ده الكلمة اللي بيكتبها المستخدم
                        };
                    },
                    processResults: function(data) {
                        // هنا Select2 بيستقبل البيانات من السيرفر
                        // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
                        var results = [];
                        $.each(data, function(key, value) {
                            results.push({
                                id: key, // الـ ID بتاع الحساب
                                text: value // الاسم بتاع الحساب
                            });
                        });

                        return {
                            results: results
                        };
                    },
                    cache: true
                }
            });

            $('#Cost_Center').select2({
                placeholder: "Select...",
                allowClear: true,
                ajax: {
                    // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
                    url: 'NewAllCostCenter',
                    dataType: 'json',
                    delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
                    data: function(params) {
                        // Select2 هيبعت كلمة البحث باسم 'term'
                        return {
                            term: params.term // ده الكلمة اللي بيكتبها المستخدم
                        };
                    },
                    processResults: function(data) {
                        // هنا Select2 بيستقبل البيانات من السيرفر
                        // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
                        var results = [];
                        $.each(data, function(key, value) {
                            results.push({
                                id: key, // الـ ID بتاع الحساب
                                text: value // الاسم بتاع الحساب
                            });
                        });

                        return {
                            results: results
                        };
                    },
                    cache: true
                }
            });

            $('#Car').select2({
                placeholder: "Select...",
                allowClear: true,
                ajax: {
                    // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
                    url: 'NewAllCars',
                    dataType: 'json',
                    delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
                    data: function(params) {
                        // Select2 هيبعت كلمة البحث باسم 'term'
                        return {
                            term: params.term // ده الكلمة اللي بيكتبها المستخدم
                        };
                    },
                    processResults: function(data) {
                        // هنا Select2 بيستقبل البيانات من السيرفر
                        // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
                        var results = [];
                        $.each(data, function(key, value) {
                            results.push({
                                id: key, // الـ ID بتاع الحساب
                                text: value // الاسم بتاع الحساب
                            });
                        });

                        return {
                            results: results
                        };
                    },
                    cache: true
                }
            });

            $('#Contractor').select2({
                placeholder: "Select...",
                allowClear: true,
                ajax: {
                    // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
                    url: 'NewAllContractor',
                    dataType: 'json',
                    delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
                    data: function(params) {
                        // Select2 هيبعت كلمة البحث باسم 'term'
                        return {
                            term: params.term // ده الكلمة اللي بيكتبها المستخدم
                        };
                    },
                    processResults: function(data) {
                        // هنا Select2 بيستقبل البيانات من السيرفر
                        // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
                        var results = [];
                        $.each(data, function(key, value) {
                            results.push({
                                id: key, // الـ ID بتاع الحساب
                                text: value // الاسم بتاع الحساب
                            });
                        });

                        return {
                            results: results
                        };
                    },
                    cache: true
                }
            });

            


        });
    });
</script>

<!--- Sender and Reciver  Data --->
<script>
    
    function SenderData() {

        var Sender = $('#Sender').val();


        $.ajax({
            url: 'SenderDataTransportFilter',
            type: "GET",
            data: {
                Sender: Sender
            },
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {


                $('#Sender_Name').val(data.name);
                $('#Sender_Phone1').val(data.phone);
                $('#Sender_Phone2').val(data.phoneT);
                $('#Sender_Address').val(data.address);
                $('#Sender_Location').val(data.location);


                $('#Sender_Governorate').empty();
                $('#Sender_City').empty();
                $('#Sender_Place').empty();

                $('#Sender_Governorate').append('<option value="' + data.GovVal + '">' + data.GovName + '</option>');
                $('#Sender_City').append('<option value="' + data.CityVal + '">' + data.CityName + '</option>');
                $('#Sender_Place').append('<option value="' + data.PlaceVal + '">' + data.PlaceName + '</option>');
                
               
                
                
             $('#Received').empty();

                 $('#Received').append('<option value="">Select</option>');
                    $.each(data.RECIVER, function(key, value) {

                        $('#Received').append('<option value="' + key + '">' + value + '</option>');

                    });        
                
                
                
                


            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });


    }


    function ReciverData() {

        var Received = $('#Received').val();


        $.ajax({
            url: 'ReciverDataTransportFilter',
            type: "GET",
            data: {
                Received: Received
            },
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {


                $('#Receiver_Name').val(data.name);
                $('#Receiver_Phone1').val(data.phone);
                $('#Receiver_Phone2').val(data.phoneT);
                $('#Receiver_Address').val(data.address);
                $('#Receiver_Location').val(data.location);


                $('#Receiver_Governorate').empty();
                $('#Receiver_City').empty();
                $('#Receiver_Place').empty();

                $('#Receiver_Governorate').append('<option value="' + data.GovVal + '">' + data.GovName + '</option>');
                $('#Receiver_City').append('<option value="' + data.CityVal + '">' + data.CityName + '</option>');
                $('#Receiver_Place').append('<option value="' + data.PlaceVal + '">' + data.PlaceName + '</option>');

                COST();

            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });


    }
</script>

<!-- Filter Governrate and City !-->
<script>
    
    $('#Sender_Governorate').on('change', function() {
        var countryId = $(this).val();
        if (countryId) {
            $.ajax({
                url: 'GovernrateFilterr/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {

                    $('#Sender_City').empty();

                    $.each(data, function(key, value) {

                        $('#Sender_City').append('<option value="' + key + '">' + value + '</option>');

                    });

                    var CIITY = $('#Sender_City').val();
                    $.ajax({
                        url: 'CityFilterr/' + CIITY,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function() {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function(data) {

                            $('#Sender_Place').empty();

                            $.each(data, function(key, value) {

                                $('#Sender_Place').append('<option value="' + key + '">' + value + '</option>');

                            });


                            COST();
                        },
                        complete: function() {
                            $('#loader').css("visibility", "hidden");
                        }
                    });



                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="states"]').empty();
        }

    });

    $('#Sender_City').on('change', function() {
        var CIITY = $('#Sender_City').val();
        $.ajax({
            url: 'CityFilterr/' + CIITY,
            type: "GET",
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {

                $('#Sender_Place').empty();

                $.each(data, function(key, value) {

                    $('#Sender_Place').append('<option value="' + key + '">' + value + '</option>');

                });

                COST();

            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });


    });

    $('#Receiver_Governorate').on('change', function() {
        var countryId = $(this).val();
        if (countryId) {
            $.ajax({
                url: 'GovernrateFilterr/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {

                    $('#Receiver_City').empty();

                    $.each(data, function(key, value) {

                        $('#Receiver_City').append('<option value="' + key + '">' + value + '</option>');

                    });

                    var CIITY = $('#Receiver_City').val();

                    $.ajax({
                        url: 'CityFilterr/' + CIITY,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function() {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function(data) {

                            $('#Receiver_Place').empty();

                            $.each(data, function(key, value) {

                                $('#Receiver_Place').append('<option value="' + key + '">' + value + '</option>');

                            });

                            COST();

                        },
                        complete: function() {
                            $('#loader').css("visibility", "hidden");
                        }
                    });

                    COST();


                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="states"]').empty();
        }

    });

    $('#Receiver_City').on('change', function() {
        var CIITY = $('#Receiver_City').val();
        $.ajax({
            url: 'CityFilterr/' + CIITY,
            type: "GET",
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {

                $('#Receiver_Place').empty();

                $.each(data, function(key, value) {

                    $('#Receiver_Place').append('<option value="' + key + '">' + value + '</option>');

                });

                COST();


            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });

        COST();

    });


    $('#Governrate').on('change', function() {
        var countryId = $(this).val();
        if (countryId) {
            $.ajax({
                url: 'GovernrateFilterr/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {

                    $('#City').empty();

                    $.each(data, function(key, value) {

                        $('#City').append('<option value="' + key + '">' + value + '</option>');

                    });

                    var CIITY = $('#City').val();

                    $.ajax({
                        url: 'CityFilterr/' + CIITY,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function() {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function(data) {

                            $('#Place').empty();

                            $.each(data, function(key, value) {

                                $('#Place').append('<option value="' + key + '">' + value + '</option>');

                            });

                            COST();


                        },
                        complete: function() {
                            $('#loader').css("visibility", "hidden");
                        }
                    });




                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="states"]').empty();
        }

    });

    $('#City').on('change', function() {
        var CIITY = $('#City').val();
        $.ajax({
            url: 'CityFilterr/' + CIITY,
            type: "GET",
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {

                $('#Place').empty();

                $.each(data, function(key, value) {

                    $('#Place').append('<option value="' + key + '">' + value + '</option>');

                });

                COST();


            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });



    });


    $('#RGovernrateX').on('change', function() {
        var countryId = $(this).val();
        if (countryId) {
            $.ajax({
                url: 'GovernrateFilterr/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {

                    $('#RCityX').empty();

                    $.each(data, function(key, value) {

                        $('#RCityX').append('<option value="' + key + '">' + value + '</option>');

                    });

                    var CIITY = $('#RCityX').val();

                    $.ajax({
                        url: 'CityFilterr/' + CIITY,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function() {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function(data) {

                            $('#RPlaceX').empty();

                            $.each(data, function(key, value) {

                                $('#RPlaceX').append('<option value="' + key + '">' + value + '</option>');

                            });

                            COST();


                        },
                        complete: function() {
                            $('#loader').css("visibility", "hidden");
                        }
                    });




                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="states"]').empty();
        }

    });

    $('#RCityX').on('change', function() {
        var CIITY = $('#RCityX').val();
        $.ajax({
            url: 'CityFilterr/' + CIITY,
            type: "GET",
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {

                $('#RPlaceX').empty();

                $.each(data, function(key, value) {

                    $('#RPlaceX').append('<option value="' + key + '">' + value + '</option>');

                });

                COST();


            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });



    });

 
    

    function COST() {

        var CIITY = $('#Receiver_City').val();
        var Weight = $('#Weight').val();
        var Shipment_Class = $('#Shipment_Class').val();
        var Sender_City = $('#Sender_City').val();


        $.ajax({
            url: 'CityCostShipping',
            type: "GET",
            data: {

                CIITY: CIITY,
                Weight: Weight,
                Shipment_Class: Shipment_Class,
                Sender_City: Sender_City,

            },
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {


                $('#Shipment_Cost').val(data.cost);
                $('#Delivery_Cost').val(data.delivery_cost);
                TOTAL();




            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });
        
        
        if(Shipment_Class == 'Stored'){
                document.getElementById('StoresPro').style.display='block';
           
           }else{
               
               document.getElementById('StoresPro').style.display='none';
           }

        
        


    }
</script>

<!-- New client -->
<script>
    
    function NewClients() {

        var Name = $('#Name').val();
        var Phone1 = $('#Phone1').val();
        var Phone2 = $('#Phone2').val();
        var Governrate = $('#Governrate').val();
        var City = $('#City').val();
        var Place = $('#Place').val();
        var Address = $('#Address').val();
        $.ajax({
            url: 'AddNewClientShipping',
            type: "GET",
            data: {

                Name: Name,
                Phone1: Phone1,
                Phone2: Phone2,
                Governrate: Governrate,
                City: City,
                Place: Place,
                Address: Address,
            },
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {


                alert('New Client Added Successful /  تم اضافة عميل جديد بنجاح');


            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });



    }
    
        function NewRecived() {

        var Name = $('#RName').val();
        var Phone1 = $('#RPhone1').val();
        var Phone2 = $('#RPhone2').val();
        var Governrate = $('#RGovernrate').val();
        var City = $('#RCity').val();
        var Place = $('#RPlace').val();
        var Address = $('#RAddress').val();
        var Sender = $('#Sender').val();
            
   
        $.ajax({
            url: 'AddNewRecivedShipping',
            type: "GET",
            data: {

                Name: Name,
                Phone1: Phone1,
                Phone2: Phone2,
                Governrate: Governrate,
                City: City,
                Place: Place,
                Address: Address,
                Sender: Sender,
            },
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {


                alert('New Recived Added Successful /  تم اضافة مستلم جديد بنجاح');


            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });



    }
    
</script>


<!-- Status  Value and Cost  -->
<script>
    function ChangeStatus(val) {

        $("#Status").val(val);

    }   
    
    function COST() {

        var Sender_Place=$('#Sender_Place').val();
        var Receiver_Place=$('#Receiver_Place').val();
           $.ajax({
            url: 'TransportPriceFilter',
            type: "GET",
            data: {
                Sender_Place: Sender_Place,
                Receiver_Place: Receiver_Place,
            },
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {


                $('#Value').val(data.Value);
            
            

            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });




    }
</script>

<!-- Type -->
<script>
function TypeChange(){
    
    var Type=$('#Type').val();
    
    
    if(Type == 'In'){
       
        document.getElementById('INSIDE').style.display='block';
        document.getElementById('OUTSIDE').style.display='none';
       
       }
        
    if(Type == 'Out'){
       
        document.getElementById('INSIDE').style.display='none';
        document.getElementById('OUTSIDE').style.display='block';
       
       }
    
    
}






</script>

<!-- Expenses -->
<script>
function PrecentFun(){
    
    var Value=$('#Value').val();
    var Expenses_Precent=$('#Expenses_Precent').val();
    
    var precent=parseFloat(Expenses_Precent) / parseFloat(100) ;
    var value=parseFloat(Value) * parseFloat(precent) ;
    
    $('#Expenses_Value').val(parseFloat(value).toFixed(2));
    
     var Expenses_Value=$('#Expenses_Value').val();
    
    
    
    var Result=parseFloat(Value) - parseFloat(Expenses_Value) ;
        $('#The_Net').val(parseFloat(Result).toFixed(2));
    
    
    
    
    
    
    DriverChange();
  
}
    
    function PrecentContractorFun(){
    
    var Value=$('#Value').val();
    var Contractor_Precent=$('#Contractor_Precent').val();
    
    var precent=parseFloat(Contractor_Precent) / parseFloat(100) ;
    var value=parseFloat(Value) * parseFloat(precent) ;
    
    $('#Contractor_Value').val(parseFloat(value).toFixed(2));
    


  
}

 function DriverChange() {

        var Driver=$('#Driver').val();
        var Expenses_Value=$('#Expenses_Value').val();
        var The_Net=$('#The_Net').val();


           $.ajax({
            url: 'DriverPrecentFilter',
            type: "GET",
            data: {
                Driver: Driver,
                Expenses_Value: Expenses_Value,
                The_Net: The_Net,
            },
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {


                $('#Driver_Precent').val(data.precent);
                
                var x= parseFloat(data.precent) / parseFloat(100) ;
                var res= parseFloat(The_Net) * parseFloat(x) ;
            
                 $('#Driver_Value').val(parseFloat(res).toFixed(2));
                
            

            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });




    }
    
    
    function Fun(){
        
        
        PrecentFun();
        PrecentContractorFun();
        
    }
    

</script>





@endpush