@extends('admin.index')
@section('content')

    <title>{{trans('admin.ShippingPrices')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Shipping')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.ShippingPrices')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        
              <!-- Filter -->
        <form action="{{url('FilterShippingPrices')}}" method="get">
        <div class="row">
            
            <div class="col-md-5">
                <label>{{trans('admin.City')}}</label>
            <select class="select2 form-control" name="City" id="City" required>
                <option value="">{{trans('admin.City')}}</option>
                
                
                </select>
            </div>
                
            <div class="col-md-5">
                <label>{{trans('admin.Place')}}</label>
            <select class="select2 form-control" name="Place" id="Place" >
                <option value="">{{trans('admin.Place')}}</option>
                
                
                </select>
            </div>
            
              <div class="col-md-2">
            <button type="submit" class="btn btn-primary"><i class="fal fa-search"></i></button>      
            </div>
            
            
        </div>
            </form>
        
        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>{{trans('admin.ShippingPrices')}}</i></span>
                        </h2>

                        <div class="panel-toolbar">

                                <a href="{{url('ShippingPrices')}}" class="btn btn-default" >{{trans('admin.AddNew')}}</a>
                                <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <table id="dt-basic-example"
                                   class="table table-bordered table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                <tr>
                                    <th>{{trans('admin.From')}} => {{trans('admin.Weight')}}</th>
                                    <th>{{trans('admin.To')}} => {{trans('admin.Weight')}}</th>
                                    <th>{{trans('admin.Price')}}</th>
                                    <th>{{trans('admin.Place')}}</th>
                                    <th>{{trans('admin.City')}}</th>
                                    <th>{{trans('admin.Actions')}}</th>

                                </tr>
                                </thead>
                                <tbody>

                                @foreach($items as $item)
                                    <tr>
                                        <td>{{$item->From}}</td>
                                        <td>{{$item->To}}</td>
                                        <td>{{$item->Price}}</td>
                                        <td>

                                           @if(!empty($item->Place()->first()->Arabic_Name))

                                                {{$item->Place()->first()->Arabic_Name}}

                                           @endif


                                        </td>
                                        <td>

                                           @if(!empty($item->City()->first()->Arabic_Name))

                                                {{$item->City()->first()->Arabic_Name}}

                                           @endif


                                        </td>


                                        <td class="text-center">

                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>


                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>

                                        </td>
                                    </tr>
                                @endforeach


                                </tbody>
                                <tfoot>
                                <tr>
                                    <th>{{trans('admin.From')}} => {{trans('admin.Weight')}}</th>
                                    <th>{{trans('admin.To')}} => {{trans('admin.Weight')}}</th>
                                    <th>{{trans('admin.Price')}}</th>
                                    <th>{{trans('admin.Place')}}</th>
                                    <th>{{trans('admin.City')}}</th>
                                    <th>{{trans('admin.Actions')}}</th>
                                </tr>
                                </tfoot>
                            </table>
                            {{$items->Links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>


        @foreach($items as $item)

            <!-- Modal Edit-->
            <div class="modal fade" id="default-example-modal-lg-edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">{{trans('admin.Edit')}}  </h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form action="{{url('EditShippingPrices/'.$item->id)}}" method="post">
                                {!! csrf_field() !!}
                                @honeypot
                                <div class="form-row">
                                    <div class="form-group col-lg-12">
                                        <label class="form-label" for="simpleinput">{{trans('admin.From')}} => {{trans('admin.Weight')}}</label>
                                        <input type="number" step="any" name="From" value="{{$item->From}}"  class="form-control" required>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.To')}} => {{trans('admin.Weight')}}</label>
                                        <input type="number" step="any" name="To"  value="{{$item->To}}" class="form-control" required >
                                    </div>

                                    <div class="form-group col-lg-12">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Price')}} </label>
                                        <input type="number" step="any" name="Price"  value="{{$item->Price}}" class="form-control" required>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Delete -->
            <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.RUSWDT')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                            <a href="{{url('DeleteShippingPrices/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </main>

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


    <!-- Search Select -->
    <script>
        
           
        $(document).ready(function () {
            $(function () {
                $(".select2").select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State",
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0,
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items",
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true,
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm;
                    },
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
                }

                         
     $('#City').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllCity',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                
      
 $('#Place').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        url: 'NewAllPlaces',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // هنا بنجيب قيمة الـ City المختارة من الـ DOM مباشرةً
            var City = $('#City').val(); 
            
            return {
                term: params.term, // كلمة البحث اللي بيكتبها المستخدم
                City: City // بنبعت الـ ID بتاع المدينة كـ 'city_id'
            };
        },
        processResults: function(data) {
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key,
                    text: value
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
}); 
                  

            });
        });
    </script>

             
      


@endpush

