@extends('admin.index')
@section('content')

    <title>{{trans('admin.ShippingPrices')}}</title>
    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Shipping')}}</a></li>

            <li class="breadcrumb-item active"> {{trans('admin.ShippingPrices')}}   </li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

  
        <div class="row">
            <div class="col-lg-12">
                <div id="panel-2" class="panel">
                    <div class="panel-hdr">

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" data-toggle="tab" href="#tab_borders_icons-8" role="tab">   {{trans('admin.ShippingPrices')}}  </a>
                                </li>
                            </ul>
                            <div class="tab-content border border-top-0 p-3">
                                <div class="tab-pane fade show active" id="tab_borders_icons-8" role="tabpanel">

                                    <form action="{{url('AddShippingPrices')}}" method="post" enctype="multipart/form-data" class="form-row">
                                        {!! csrf_field() !!}
                                        @honeypot
                                        <div class="col-md-12">
                                            <div class="data-def">
                                                <div class="form-row">


                                                    <div id="mobile-overflow">
                                                        <table class="table table-bordered table-hover table-striped w-100 mobile-width table-color1">
                                                            <thead>
                                                            <tr>

                                                                <th> {{trans('admin.City')}}</th>
                                                                <th> {{trans('admin.Place')}}</th>
                                                                <th>{{trans('admin.From')}} => {{trans('admin.Weight')}}</th>
                                                                <th>{{trans('admin.To')}} => {{trans('admin.Weight')}}</th>
                                                                <th>{{trans('admin.Price')}}</th>
                                                                <th>{{trans('admin.Actions')}}</th>
                                                            </tr>
                                                            </thead>
                                                            <tbody>
                                                            <tr>



                                                                <td>
                                                                    <div class="form-group">
                                                                        <select onchange="PLUS()" class="select2 form-control w-100" id="city">
                                                                            <option value="">{{trans('admin.City')}}</option>
                                                                            @foreach($Cities as $cit)
                                                                                <option value="{{$cit->id}}">

                                                                                    {{app()->getLocale() == 'ar' ?$cit->Arabic_Name :$cit->English_Name}}
                                                                                </option>
                                                                            @endforeach
                                                                        </select>


                                                                    </div>
                                                                </td>

                                                                <td>
                                                                    <div class="form-group">
                                                                        <select onchange="PLUS()" class="select2 form-control w-100" id="place">
                                                                            <option value="">{{trans('admin.Place')}}</option>

                                                                        </select>


                                                                    </div>
                                                                </td>


                                                                <td>
                                                                    <div class="form-group">

                                                                        <div class="form-group">
                                                                            <input onkeyup="PLUS()" type="number" step="any" id="from" class="form-control">
                                                                        </div>
                                                                    </div>
                                                                </td>


                                                                <td>
                                                                    <div class="form-group">

                                                                        <div class="form-group">
                                                                            <input onkeyup="PLUS()" type="number" step="any" id="to" class="form-control">
                                                                        </div>
                                                                    </div>
                                                                </td>

                                                                <td>
                                                                    <div class="form-group">

                                                                        <div class="form-group">
                                                                            <input onkeyup="PLUS()" type="number" step="any" id="price" class="form-control">
                                                                        </div>
                                                                    </div>
                                                                </td>




                                                                <td>
                                                                    <button type="button" onclick="Insert()" class="btn btn-default" id="add-data" style="display: none"><i class="fal fa-plus"></i></button>
                                                                </td>

                                                            </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    <!-- datatable start -->
                                                    <div id="mobile-overflow">
                                                        <table  class="table table-bordered table-hover table-striped w-100 mobile-width table-color2">
                                                            <thead>
                                                            <tr>

                                                                <th> {{trans('admin.City')}}</th>
                                                                <th> {{trans('admin.Place')}}</th>
                                                                <th>{{trans('admin.From')}} => {{trans('admin.Weight')}}</th>
                                                                <th>{{trans('admin.To')}} => {{trans('admin.Weight')}}</th>
                                                                <th>{{trans('admin.Price')}}</th>
                                                                <th>{{trans('admin.Actions')}}</th>
                                                            </tr>
                                                            </thead>
                                                            <tbody id="data-dt">

                                                            </tbody>
                                                            <tfoot>
                                                            <tr>
                                                                <th> {{trans('admin.City')}}</th>
                                                                <th> {{trans('admin.Place')}}</th>
                                                                <th>{{trans('admin.From')}} => {{trans('admin.Weight')}}</th>
                                                                <th>{{trans('admin.To')}} => {{trans('admin.Weight')}}</th>
                                                                <th>{{trans('admin.Price')}}</th>
                                                                <th>{{trans('admin.Actions')}}</th>
                                                            </tr>
                                                            </tfoot>
                                                        </table>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <button type="submit" class="btn btn-primary mt-2">{{trans('admin.Save')}}</button>
                                        </div>
                                    </form>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </main>

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>




    <script>
        function Insert() {


            var cityName = $("#city option:selected").text();
            var city = $("#city").val();
            var placeName = $("#place option:selected").text();
            var place = $("#place").val();
            var from = $("#from").val();
            var to = $("#to").val();
            var price = $("#price").val();






            var table = ` <tr>

                                <td>${cityName}</td>
                                <td>${placeName}</td>
                                <td>${from}</td>
                                <td>${to}</td>

                                <td>
                            ${price}
                <input type="hidden" name="City[]" value="${city}">
                <input type="hidden" name="Place[]" value="${place}">
                <input type="hidden" name="From[]" value="${from}">
                <input type="hidden" name="To[]" value="${to}">
                <input type="hidden" name="Price[]" value="${price}">

                                 </td>
                                <td>
                    <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>




                             </tr>`;





            document.getElementById('data-dt').innerHTML += table;

            $('#data-dt').on('click', '#Del', function(e) {
                $(this).closest('tr').remove();

            })





        }

    </script>


    <script>
        function PLUS() {

            var city = $('#city').val();
            var from = $('#from').val();
            var to = $('#to').val();
            var price = $('#price').val();



            if (city != '' && from != '' && to != '' && price != '') {


                    document.getElementById("add-data").style.display = "block";



            } else {

                document.getElementById("add-data").style.display = "none";

            }




        }


        $('#city').on('change', function(){
            var CIITY = $('#city').val();
            $.ajax({
                url: 'CityFilterr/'+CIITY,
                type:"GET",
                dataType:"json",
                beforeSend: function(){
                    $('#loader').css("visibility", "visible");
                },

                success:function(data) {

                    $('#place').empty();

                    $('#place').append('<option value=""></option>');

                    $.each(data, function(key, value){

                        $('#place').append('<option value="'+ key +'">' + value + '</option>');

                    });


                },
                complete: function(){
                    $('#loader').css("visibility", "hidden");
                }
            });


        });

    </script>


@endpush

