@extends('admin.index')
@section('content')
@php 
use App\Models\Shipping\ShippmentProducts;
@endphp 
    <title>{{trans('admin.ShipmentSechdule')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Shipping')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.ShipmentSechdule')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        
        
        
        <div class="row">
            
                      <!-- Filter -->
        <form action="{{url('FilterShipmentSechdule')}}" method="get">
        <div class="row">
            

            <div class="col-md-3">
                <label>{{trans('admin.From')}}</label>
                <input class="form-control" name="From" type="date" value="{{date('Y-m-d')}}">
            </div>
            
            <div class="col-md-3">
                <label>{{trans('admin.To')}}</label>
                <input class="form-control" name="To" type="date" value="{{date('Y-m-d')}}">
            </div>
            
            
            <div class="col-md-3">
                <label>{{trans('admin.Sender')}}</label>
            <select class="select2 form-control" name="Sender" id="Sender" >
                <option value="">{{trans('admin.Sender')}}</option>
                
                
                </select>
            </div>
                

            <div class="col-md-3">
                <label>{{trans('admin.Receiver')}}</label>
                <select class="select2 form-control" name="Receiver" id="Receiver">
                    <option value="">{{trans('admin.Receiver')}}</option>


                </select>
            </div>

         
            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">{{trans('admin.Shipment_Class')}}</label>
                <select class="select2 form-control" name="Shipment_Class" id="Shipment_Class" >
                    <option value="">{{trans('admin.Shipment_Class')}}</option>
                    <option value="Hub">{{trans('admin.Hub_to_Hub')}}</option>
                    <option value="Door">{{trans('admin.Door_to_Door')}}</option>
                    <option value="Stored">{{trans('admin.Stored_Shipping')}}</option>
                    <option value="HubToDoor">{{trans('admin.Hub_to_Door')}}</option>
                    <option value="DoorToHub">{{trans('admin.Door_to_Hub')}}</option>
                </select>
            </div>

            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">{{trans('admin.Payment_Method')}}</label>
                <select class="select2 form-control" name="Payment_Method" id="Payment_Method" >
                    <option value="">{{trans('admin.Payment_Method')}}</option>
                    <option value="Cash">{{trans('admin.Cash')}}</option>
                    <option value="Later">{{trans('admin.Later')}}</option>
                    <option value="Visa">{{trans('admin.Visa')}}</option>
                    <option value="Electronic_Wallet">{{trans('admin.Electronic_Wallet')}}</option>
                </select>
            </div>


            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">{{trans('admin.Shipment_Type')}}</label>
                <select class="select2 form-control" name="Shipment_Type" id="Shipment_Type" >
                    <option value="">{{trans('admin.Shipment_Type')}}</option>
                    <option value="Shipping">{{trans('admin.Shipping')}}</option>
                    <option value="CollectionShippingDeposit">{{trans('admin.CollectionShippingDeposit')}}</option>
                    <option value="CollectionShipping">{{trans('admin.CollectionShipping')}}</option>
                    <option value="ReturnShipping">{{trans('admin.ReturnShipping')}}</option>
                </select>
            </div>
            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">{{trans('admin.Shipment_Category')}}</label>
                <select class="select2 form-control" name="Shipment_Category" id="Shipment_Category" >
                    <option value="">{{trans('admin.Shipment_Category')}}</option>
                    @foreach($Categories as $cat)
                    <option value="{{$cat->id}}">
                        {{app()->getLocale() == 'ar' ?$cat->Arabic_Name :$cat->English_Name}}
                    </option>
                    @endforeach
                </select>
            </div>
            
            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">{{trans('admin.Shipment_Rqst_Type')}}</label>
                <select class="select2 form-control" name="Shipment_Rqst_Type" id="Shipment_Rqst_Type">
                    <option value="">{{trans('admin.Shipment_Rqst_Type')}}</option>
                    @foreach($RqstTypes as $Rtype)
                    <option value="{{$Rtype->id}}">
                        {{app()->getLocale() == 'ar' ?$Rtype->Arabic_Name :$Rtype->English_Name}}
                    </option>
                    @endforeach
                </select>
            </div>



            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">{{trans('admin.Delegate')}}</label>
                <select class="select2 form-control" name="Delegate" id="Delegate">
                    <option value="">{{trans('admin.Delegate')}}</option>
                </select>
            </div>
            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">{{trans('admin.Driver')}}</label>
                <select class="select2 form-control" name="Driver" id="Driver">
                    <option value="">{{trans('admin.Driver')}}</option>
                </select>
            </div>


            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">{{trans('admin.FromStore')}}</label>
                <select class="select2 form-control" name="FromStore" id="FromStore">
                    <option value="">{{trans('admin.FromStore')}}</option>
                </select>
            </div>


            <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">{{trans('admin.ToStore')}}</label>
                <select class="select2 form-control" name="ToStore" id="ToStore">
                    <option value="">{{trans('admin.ToStore')}}</option>
                </select>
            </div>
            
            
             <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">{{trans('admin.Status')}}</label>
                <select class="select2 form-control" name="Status" id="Status" >
                    <option value="">{{trans('admin.Status')}}</option>
                    <option value="0">{{trans('admin.Pending')}}</option>
                    <option value="1">{{trans('admin.Distrbuted')}}</option>
                    <option value="2">{{trans('admin.Moved')}}</option>
                    <option value="3">{{trans('admin.Delivered')}}</option>
                    <option value="4">{{trans('admin.Unloading')}}</option>
                    <option value="5">{{trans('admin.CarBack')}}</option>
                    <option value="6">{{trans('admin.DelegateProcessing')}}</option>
                    <option value="7">{{trans('admin.ClientDelivered')}}</option>
                </select>
            </div>

            
            
            
                     <div class="col-md-4">
                <label>{{trans('admin.Barcode')}}</label>
                <input class="form-control" name="Barcode" type="text">
            </div>

            
            
              <div class="col-md-2">
            <button type="submit" class="btn btn-primary"><i class="fal fa-search"></i></button>      
            </div>
            
            
        </div>
            </form>
        
            
            
            
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>{{trans('admin.ShipmentSechdule')}}</i></span>
                        </h2>

                        <div class="panel-toolbar">

                            <a href="{{url('Shipment')}}" class="btn btn-default" >{{trans('admin.AddNew')}}</a>
                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <table 
                                   class="table table-bordered table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                <tr>

                                
                                    <th>{{trans('admin.Barcode')}}</th>
                                    <th>{{trans('admin.Date')}}</th>
                                    <th>{{trans('admin.Sender_Name')}}</th>
                                    <th>{{trans('admin.Receiver_Name')}}</th>
                                    <th>{{trans('admin.Payment_Method')}}</th>
                                    <th>{{trans('admin.FromStore')}}</th>
                                    <th>{{trans('admin.ToStore')}}</th>
                                    <th>{{trans('admin.Total')}}</th>
                                    <th>{{trans('admin.Status')}}</th>
                                    <th>{{trans('admin.Details')}}</th>
                                    <th>{{trans('admin.Sender')}}</th>
                                    <th>{{trans('admin.Received')}}</th>
                                    <th>{{trans('admin.Cost')}}</th>
                                    <th>{{trans('admin.Products')}}</th>
                                    <th>{{trans('admin.Actions')}}</th>

                                </tr>
                                </thead>
                                <tbody>

                                @foreach($items as $item)
                                    <tr>
                                      
                                        <td>{{$item->Barcode}}</td>
                                        <td>{{$item->Date}}</td>
                                     
                                        <td>{{$item->Sender_Name}}</td>
                                        <td>{{$item->Receiver_Name}}</td>


                                    
                                        <td>

                                            @if($item->Payment_Method == 'Cash')
                                                {{trans('admin.Cash')}}
                                            @elseif($item->Payment_Method == 'Later')
                                                {{trans('admin.Later')}}
                                            @elseif($item->Payment_Method == 'Visa')
                                                {{trans('admin.Visa')}}
                                            @elseif($item->Payment_Method == 'Electronic_Wallet')
                                                {{trans('admin.Electronic_Wallet')}}
                                            @endif




                                        </td>

            
                                        <td>

                                            @if(!empty($item->Store()->first()->Name))

                                                {{$item->Store()->first()->Name}}

                                            @endif


                                        </td>
                                        
                                        
                                        <td>

                                            @if(!empty($item->ToStore()->first()->Name))

                                                {{$item->ToStore()->first()->Name}}

                                            @endif


                                        </td>



                                        <td>{{$item->Total}}</td>
                                        <td>


                                          
                                         {{$item->Status->desc()}}
                                            

                                        </td>

                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Details{{$item->id}}">
                                                {{trans('admin.Details')}}</button>
                                        </td>


                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Sender{{$item->id}}">
                                                {{trans('admin.Sender')}}</button>
                                        </td>


                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Received{{$item->id}}">
                                                {{trans('admin.Received')}}</button>
                                        </td>


                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Cost{{$item->id}}">
                                                {{trans('admin.Cost')}}</button>
                                        </td>

                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Products{{$item->id}}">
                                                {{trans('admin.Products')}}</button>
                                        </td>


                                        <td class="text-center">

                                             @if($item->Status == 0)
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>


                                    
                                            <a href="{{url('EditShipment/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-edit"></i></a>
                                            @endif
                                            
          <div class="dropdown d-inline-block">

    <button class="btn btn-outline-secondary dropdown-toggle" type="button" id="printMenuButton{{$item->id}}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        <i class="fal fa-print"></i>
    </button>
    
    <div class="dropdown-menu" aria-labelledby="printMenuButton{{$item->id}}">
        <a class="dropdown-item" href="{{ url('PrintShipment/'.$item->id.'?type=A4') }}">
            <i class="fal fa-print"></i> A4
        </a>
        <a class="dropdown-item" href="{{ url('PrintShipment/'.$item->id.'?type=A5') }}">
            <i class="fal fa-print"></i> A5
        </a>
        <a class="dropdown-item" href="{{ url('PrintShipment8/'.$item->id) }}">
            <i class="fal fa-print"></i> 8CM
        </a>
        <a class="dropdown-item" href="{{ url('PrintShipment/'.$item->id.'?type=Barcode') }}">
            <i class="fal fa-print"></i> Barcode
        </a>
    </div>
</div>                                        
                                                

                                        </td>
                                    </tr>
                                @endforeach


                                </tbody>
                                <tfoot>
                                <tr>
                                       <th>{{trans('admin.Barcode')}}</th>
                                    <th>{{trans('admin.Date')}}</th>
                                    <th>{{trans('admin.Sender_Name')}}</th>
                                    <th>{{trans('admin.Receiver_Name')}}</th>
                                    <th>{{trans('admin.Payment_Method')}}</th>
                                    <th>{{trans('admin.FromStore')}}</th>
                                    <th>{{trans('admin.ToStore')}}</th>
                                    <th>{{trans('admin.Total')}}</th>
                                    <th>{{trans('admin.Status')}}</th>
                                    <th>{{trans('admin.Details')}}</th>
                                    <th>{{trans('admin.Sender')}}</th>
                                    <th>{{trans('admin.Received')}}</th>
                                    <th>{{trans('admin.Cost')}}</th>
                                    <th>{{trans('admin.Products')}}</th>
                                    <th>{{trans('admin.Actions')}}</th>

                                </tr>
                                </tfoot>
                            </table>
                            {{$items->Links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>


        @foreach($items as $item)

            <!-- Modal Delete -->
            <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.RUSWDT')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                            <a href="{{url('DeleteShipment/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Details -->
            <div class="modal fade" id="Details{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Details')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                    
                                        <th>{{trans('admin.Desc')}} </th>
                                        <th>{{trans('admin.Delegate')}} </th>
                                        <th>{{trans('admin.Driver')}} </th>
                                        <th>{{trans('admin.Note')}} </th>
                                        <th>{{trans('admin.Breakable')}} </th>
                                        <th>{{trans('admin.Delivery_To_Others')}} </th>
                                        <th>{{trans('admin.Shipping_Costs_Included')}} </th>
                                        <th>{{trans('admin.Opening_Package')}} </th>
                                        <th>{{trans('admin.Insurance')}} </th>
                                        <th>{{trans('admin.Safe')}} </th>
                                        <th>{{trans('admin.Coin')}} </th>
                                        <th>{{trans('admin.Draw')}} </th>
                                        <th>{{trans('admin.User')}} </th>

                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                         
                                            <td>{{$item->Desc}}</td>
                                       
                             

                                            <td>
                                                @if(!empty($item->Delegate()->first()->Name))

                                                    {{$item->Delegate()->first()->Name}}

                                                @endif


                                            </td>
                                            <td>

                                                @if(!empty($item->Driver()->first()->Name))

                                                    {{$item->Driver()->first()->Name}}

                                                @endif


                                            </td>

                                            <td>{{$item->Note}}</td>

                                            <td>

                                                @if($item->Breakable == 'Yes')
                                                    {{trans('admin.Yes')}}
                                                @elseif($item->Breakable == 'No')
                                                    {{trans('admin.No')}}
                                                @endif



                                            </td>
                                            <td>

                                                 @if($item->Delivery_To_Others == 'Yes')
                                                    {{trans('admin.Yes')}}
                                                @elseif($item->Delivery_To_Others == 'No')
                                                    {{trans('admin.No')}}
                                                @endif

                                            </td>
                                            <td>

                                                 @if($item->Shipping_Costs_Included == 'Yes')
                                                    {{trans('admin.Yes')}}
                                                @elseif($item->Shipping_Costs_Included == 'No')
                                                    {{trans('admin.No')}}
                                                @endif

                                            </td>
                                            <td>

                                                 @if($item->Opening_Package == 'Yes')
                                                    {{trans('admin.Yes')}}
                                                @elseif($item->Opening_Package == 'No')
                                                    {{trans('admin.No')}}
                                                @endif

                                            </td>
                                             <td>

                                                 @if($item->Insurance == 'Yes')
                                                    {{trans('admin.Yes')}}
                                                @elseif($item->Insurance == 'No')
                                                    {{trans('admin.No')}}
                                                @endif

                                            </td>
                                            
                                                      <td>

                                                @if(!empty($item->Safe()->first()->Name))

                                                    {{$item->Safe()->first()->Name}}

                                                @endif


                                            </td>
                                            
                                                       
                                                      <td>

                                                @if(!empty($item->Coin()->first()->Arabic_Name))

                                                    {{$item->Coin()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            
                                            
                                                    <td>{{$item->Draw}}</td>
                                            
                                            




                                            <td>

                                                @if(!empty($item->User()->first()->name))

                                                    {{$item->User()->first()->name}}

                                                @endif


                                            </td>



                                        </tr>

                                    </tbody>
                                </table>
                            </div>


                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                    <th>{{trans('admin.Code')}}</th>
                                    <th>{{trans('admin.Time')}}</th>
                                    <th>{{trans('admin.Shipment_Class')}}</th>
                                    <th>{{trans('admin.Shipment_Type')}}</th>
                                    <th>{{trans('admin.Shipment_Rqst_Type')}}</th>
                                    <th>{{trans('admin.Shipment_Category')}}</th>
                                        
                                        <th>{{trans('admin.Pieces_Num')}} </th>
                                        <th>{{trans('admin.Reference_Num')}} </th>
                                        <th>{{trans('admin.Weight')}} </th>
                                        <th>{{trans('admin.Length')}} </th>
                                        <th>{{trans('admin.Width')}} </th>
                                        <th>{{trans('admin.Height')}} </th>
                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>


                                            <td>{{$item->Code}}</td>
                                            <td>{{$item->Time}}</td>
                                            <td>

                                                @if($item->Shipment_Class == 'Hub')
                                                {{trans('admin.Hub_to_Hub')}}
                                                @elseif($item->Shipment_Class == 'Door')
                                                {{trans('admin.Door_to_Door')}}
                                                @elseif($item->Shipment_Class == 'Stored')
                                                {{trans('admin.Stored_Shipping')}}
                                                @elseif($item->Shipment_Class == 'HubToDoor')
                                                {{trans('admin.Hub_to_Door')}}
                                                @elseif($item->Shipment_Class == 'DoorToHub')
                                                {{trans('admin.Door_to_Hub')}}
                                                @endif


                                            </td>
                                            <td>

                                                @if($item->Shipment_Type == 'Shipping')
                                                {{trans('admin.Shipping')}}
                                                @elseif($item->Shipment_Type == 'CollectionShippingDeposit')
                                                {{trans('admin.CollectionShippingDeposit')}}
                                                @elseif($item->Shipment_Type == 'CollectionShipping')
                                                {{trans('admin.CollectionShipping')}}
                                                @elseif($item->Shipment_Type == 'ReturnShipping')
                                                {{trans('admin.ReturnShipping')}}

                                                @endif

                                            </td>
                                            <td>

                                                @if(!empty($item->Shipment_Rqst_Type()->first()->Arabic_Name))

                                                {{$item->Shipment_Rqst_Type()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            <td>

                                                @if(!empty($item->Shipment_Category()->first()->Arabic_Name))

                                                {{$item->Shipment_Category()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            
                                               <td>{{$item->Pieces_Num}}</td>
                                               <td>{{$item->Reference_Num}}</td>
                                               <td>{{$item->Weight}}</td>
                                               <td>{{$item->Length}}</td>
                                               <td>{{$item->Width}}</td>
                                               <td>{{$item->Height}}</td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Sender -->
            <div class="modal fade" id="Sender{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Sender')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Name')}} </th>
                                        <th>{{trans('admin.Governorate')}} </th>
                                        <th>{{trans('admin.City')}} </th>
                                        <th>{{trans('admin.Place')}} </th>
                                        <th>{{trans('admin.Address')}} </th>
                                        <th>{{trans('admin.Phone1')}} </th>
                                        <th>{{trans('admin.Phone2')}} </th>
                                        <th>{{trans('admin.Location')}} </th>
                                        <th>{{trans('admin.Sender')}} </th>

                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                            <td>{{$item->Sender_Name}}</td>
                                            <td>

                                                @if(!empty($item->Sender_Governorate()->first()->Arabic_Name))

                                                    {{$item->Sender_Governorate()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            <td>

                                                @if(!empty($item->Sender_City()->first()->Arabic_Name))

                                                    {{$item->Sender_City()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            <td>

                                                @if(!empty($item->Sender_Place()->first()->Arabic_Name))

                                                    {{$item->Sender_Place()->first()->Arabic_Name}}

                                                @endif


                                            </td>

                                            <td>{{$item->Sender_Address}}</td>
                                            <td>{{$item->Sender_Phone1}}</td>
                                            <td>{{$item->Sender_Phone2}}</td>
                                            <td>{{$item->Sender_Location}}</td>

                                            <td>

                                                @if(!empty($item->Sender()->first()->Name))

                                                    {{$item->Sender()->first()->Name}}

                                                @endif


                                            </td>






                                        </tr>

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Received -->
            <div class="modal fade" id="Received{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Received')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Name')}} </th>
                                        <th>{{trans('admin.Governorate')}} </th>
                                        <th>{{trans('admin.City')}} </th>
                                        <th>{{trans('admin.Place')}} </th>
                                        <th>{{trans('admin.Address')}} </th>
                                        <th>{{trans('admin.Phone1')}} </th>
                                        <th>{{trans('admin.Phone2')}} </th>
                                        <th>{{trans('admin.Location')}} </th>
                                        <th>{{trans('admin.Received')}} </th>


                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                            <td>{{$item->Receiver_Name}}</td>
                                            <td>

                                                @if(!empty($item->Receiver_Governorate()->first()->Arabic_Name))

                                                    {{$item->Receiver_Governorate()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            <td>

                                                @if(!empty($item->Receiver_City()->first()->Arabic_Name))

                                                    {{$item->Receiver_City()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            <td>

                                                @if(!empty($item->Receiver_Place()->first()->Arabic_Name))

                                                    {{$item->Receiver_Place()->first()->Arabic_Name}}

                                                @endif


                                            </td>

                                            <td>{{$item->Receiver_Address}}</td>
                                            <td>{{$item->Receiver_Phone1}}</td>
                                            <td>{{$item->Receiver_Phone2}}</td>
                                            <td>{{$item->Receiver_Location}}</td>

                                            <td>

                                                @if(!empty($item->Received()->first()->Name))

                                                    {{$item->Received()->first()->Name}}

                                                @endif


                                            </td>






                                        </tr>

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Cost -->
            <div class="modal fade" id="Cost{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Cost')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Shipment_Cost')}} </th>
                                        <th>{{trans('admin.Goods_Cost')}} </th>
                                        <th>{{trans('admin.Delivery_Cost')}} </th>
                                        <th>{{trans('admin.Overload_Weight_Cost')}} </th>
                                        <th>{{trans('admin.Collection_Commission')}} </th>
                                        <th>{{trans('admin.Delivery_Commission')}} </th>
                                        <th>{{trans('admin.Return_Cost')}} </th>
                                        <th>{{trans('admin.Total')}} </th>
                                        <th>{{trans('admin.Pay')}} </th>



                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                            <td>{{$item->Shipment_Cost}}</td>
                                            <td>{{$item->Goods_Cost}}</td>
                                            <td>{{$item->Delivery_Cost}}</td>
                                            <td>{{$item->Overload_Weight_Cost}}</td>
                                            <td>{{$item->Collection_Commission}}</td>
                                            <td>{{$item->Delivery_Commission}}</td>
                                            <td>{{$item->Return_Cost}}</td>
                                            <td>{{$item->Total}}</td>
                                            <td>{{$item->Pay}}</td>





                                        </tr>

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Products -->
            <div class="modal fade" id="Products{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Cost')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
  @php $details=ShippmentProducts::where('Shipment',$item->id)->get(); @endphp 
                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Name')}} </th>
                                        <th>{{trans('admin.P_Code')}} </th>
                                        <th>{{trans('admin.Unit')}} </th>
                                        <th>{{trans('admin.AvQty')}} </th>
                                        <th>{{trans('admin.Qty')}} </th>
                                        <th>{{trans('admin.Price')}} </th>
                                        <th>{{trans('admin.Total')}} </th>
                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        @foreach($details as $det)
                                        <tr>
                                            <td>{{$det->P_Ar_Name}} ({{$det->V_Name}}) ({{$det->VV_Name}})</td>
                                            <td>{{$det->P_Code}}</td>
                                            <td>
                                                
                                            @if(!empty($det->Unit()->first()->Name))    
                                                {{$det->Unit()->first()->Name}}
                                            @endif
                                            
                                            </td>
                                            <td>{{$det->AvQty}}</td>
                                            <td>{{$det->Qty}}</td>
                                            <td>{{$det->Price}}</td>
                                            <td>{{$det->Total}}</td>
                            
                                        </tr>
                                        @endforeach

                                        
                                        



                                        
                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>


        @endforeach
    </main>

@endsection

@push('js')
 <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


    <!-- Search Select -->
    <script>
        
           
        $(document).ready(function () {
            $(function () {
                $(".select2").select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State",
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0,
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items",
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true,
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm;
                    },
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
                }

                         
     $('#Sender').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllCli',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                
                            
     $('#Receiver').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllCli',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                
                      
                            
     $('#Delegate').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllEmps',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                
                               
     $('#Driver').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllEmps',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                  
          
         $('#FromStore').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllStores',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                 
         $('#ToStore').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllStores',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
                
             
                
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                  
                  
          

            });
        });
    </script>

           








@endpush

