@extends('admin.index')
@section('content')

    <title>{{trans('admin.ShipmentRequestSechdule')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Shipping')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.ShipmentRequestSechdule')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>{{trans('admin.ShipmentRequestSechdule')}}</i></span>
                        </h2>


                        <div class="panel-toolbar">

                            <a href="{{url('AddNewShipmentRequest')}}" class="btn btn-default" >{{trans('admin.AddNew')}}</a>
                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <table id="dt-basic-example"
                                   class="table table-bordered table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                <tr>

                                    <th>{{trans('admin.Code')}}</th>
                                    <th>{{trans('admin.Date')}}</th>
                                    <th>{{trans('admin.Time')}}</th>
                                    <th>{{trans('admin.Sender_Name')}}</th>
                                    <th>{{trans('admin.Receiver_Name')}}</th>
                                    <th>{{trans('admin.Payment_Method')}}</th>
                                    <th>{{trans('admin.Total')}}</th>
                                    <th>{{trans('admin.Details')}}</th>
                                    <th>{{trans('admin.Sender')}}</th>
                                    <th>{{trans('admin.Received')}}</th>
                                    <th>{{trans('admin.Cost')}}</th>
                                    <th>{{trans('admin.Actions')}}</th>

                                </tr>
                                </thead>
                                <tbody>

                                @foreach($items as $item)
                                    <tr>
                                        <td>{{$item->Code}}</td>
                                        <td>{{$item->Date}}</td>
                                        <td>{{$item->Time}}</td>
                                        <td>{{$item->Sender_Name}}</td>
                                        <td>{{$item->Receiver_Name}}</td>

                                        <td>

                                            @if($item->Payment_Method == 'Cash')
                                                {{trans('admin.Cash')}}
                                            @elseif($item->Payment_Method == 'Later')
                                                {{trans('admin.Later')}}
                                            @elseif($item->Payment_Method == 'Visa')
                                                {{trans('admin.Visa')}}
                                            @elseif($item->Payment_Method == 'Electronic_Wallet')
                                                {{trans('admin.Electronic_Wallet')}}
                                            @endif

                                        </td>

        
                                        <td>{{$item->Total}}</td>

                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Details{{$item->id}}">
                                                {{trans('admin.Details')}}</button>
                                        </td>


                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Sender{{$item->id}}">
                                                {{trans('admin.Sender')}}</button>
                                        </td>


                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Received{{$item->id}}">
                                                {{trans('admin.Received')}}</button>
                                        </td>


                                        <td>

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Cost{{$item->id}}">
                                                {{trans('admin.Cost')}}</button>
                                        </td>


                                        <td class="text-center">

                                             @if($item->Transfer == 0)
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>

                                            <a href="{{url('EditShipmentRequest/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-edit"></i></a>
                                            
                                            <a href="{{url('TransferShipmentRequest/'.$item->id)}}" title="{{trans('admin.Transfer')}}" class="btn btn-default" ><i class="fal fa-arrow-right"></i></a>
                                            @endif
                                            
                                          <a href="{{url('PrintShipmentRequest/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-print"></i></a>

                                        </td>
                                    </tr>
                                @endforeach




                                </tbody>
                                <tfoot>
                                <tr>
                                    <th>{{trans('admin.Code')}}</th>
                                    <th>{{trans('admin.Date')}}</th>
                                    <th>{{trans('admin.Time')}}</th>
                                    <th>{{trans('admin.Sender_Name')}}</th>
                                    <th>{{trans('admin.Receiver_Name')}}</th>
                                    <th>{{trans('admin.Payment_Method')}}</th>
                                    <th>{{trans('admin.Total')}}</th>
                                    <th>{{trans('admin.Details')}}</th>
                                    <th>{{trans('admin.Sender')}}</th>
                                    <th>{{trans('admin.Received')}}</th>
                                    <th>{{trans('admin.Cost')}}</th>
                                    <th>{{trans('admin.Actions')}}</th>

                                </tr>
                                </tfoot>
                            </table>
                            {{$items->Links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>


        @foreach($items as $item)

            <!-- Modal Delete -->
            <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.RUSWDT')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                            <a href="{{url('DeleteShipmentRequest/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Details -->
            <div class="modal fade" id="Details{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Details')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Pieces_Num')}} </th>
                                        <th>{{trans('admin.Desc')}} </th>
                                        <th>{{trans('admin.Weight')}} </th>
                                        <th>{{trans('admin.Length')}} </th>
                                        <th>{{trans('admin.Width')}} </th>
                                        <th>{{trans('admin.Height')}} </th>
                                        <th>{{trans('admin.Delegate')}} </th>
                                        <th>{{trans('admin.Note')}} </th>
                                        <th>{{trans('admin.Breakable')}} </th>
                                        <th>{{trans('admin.Delivery_To_Others')}} </th>
                                        <th>{{trans('admin.Opening_Package')}} </th>
                                        <th>{{trans('admin.Safe')}} </th>
                                        <th>{{trans('admin.Coin')}} </th>
                                        <th>{{trans('admin.Draw')}} </th>
                                        <th>{{trans('admin.User')}} </th>
                                        <th>{{trans('admin.Shipment_Type')}}</th>
        
                                        <th>{{trans('admin.Receipt_Date')}} </th>
                                        <th>{{trans('admin.Receipt_Time')}} </th>
                                        <th>{{trans('admin.Arrival_Date')}} </th>
                                        <th>{{trans('admin.Arrival_Time')}} </th>

                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                            <td>{{$item->Pieces_Num}}</td>
                                            <td>{{$item->Desc}}</td>
                                            <td>{{$item->Weight}}</td>
                                            <td>{{$item->Length}}</td>
                                            <td>{{$item->Width}}</td>
                                            <td>{{$item->Height}}</td>

                                            <td>
                                                @if(!empty($item->Delegate()->first()->Name))

                                                    {{$item->Delegate()->first()->Name}}

                                                @endif


                                            </td>


                                            <td>{{$item->Note}}</td>

                                            <td>

                                                @if($item->Breakable == 'Yes')
                                                    {{trans('admin.Yes')}}
                                                @elseif($item->Breakable == 'No')
                                                    {{trans('admin.No')}}
                                                @endif



                                            </td>
                                            <td>

                                                 @if($item->Delivery_To_Others == 'Yes')
                                                    {{trans('admin.Yes')}}
                                                @elseif($item->Delivery_To_Others == 'No')
                                                    {{trans('admin.No')}}
                                                @endif

                                            </td>

                                            <td>

                                                 @if($item->Opening_Package == 'Yes')
                                                    {{trans('admin.Yes')}}
                                                @elseif($item->Opening_Package == 'No')
                                                    {{trans('admin.No')}}
                                                @endif

                                            </td>

                                                      <td>

                                                @if(!empty($item->Safe()->first()->Name))

                                                    {{$item->Safe()->first()->Name}}

                                                @endif


                                            </td>
                                            
                                                       
                                                      <td>

                                                @if(!empty($item->Coin()->first()->Arabic_Name))

                                                    {{$item->Coin()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            
                                            
                                                    <td>{{$item->Draw}}</td>
                                       
                                            




                                            <td>

                                                @if(!empty($item->User()->first()->name))

                                                    {{$item->User()->first()->name}}

                                                @endif


                                            </td>

                                                                 <td>

                                                @if($item->Shipment_Type == 'Shipping')
                                                {{trans('admin.Shipping')}}
                                                @elseif($item->Shipment_Type == 'CollectionShippingDeposit')
                                                {{trans('admin.CollectionShippingDeposit')}}
                                                @elseif($item->Shipment_Type == 'CollectionShipping')
                                                {{trans('admin.CollectionShipping')}}
                                                @elseif($item->Shipment_Type == 'ReturnShipping')
                                                {{trans('admin.ReturnShipping')}}

                                                @endif

                                            </td>

                                                         <td>{{$item->Receipt_Date}}</td>
                                                    <td>{{$item->Receipt_Time}}</td>
                                                    <td>{{$item->Arrival_Date}}</td>
                                                    <td>{{$item->Arrival_Time}}</td>
                                            

                                        </tr>

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Sender -->
            <div class="modal fade" id="Sender{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Sender')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Name')}} </th>
                                        <th>{{trans('admin.Governorate')}} </th>
                                        <th>{{trans('admin.City')}} </th>
                                        <th>{{trans('admin.Place')}} </th>
                                        <th>{{trans('admin.Address')}} </th>
                                        <th>{{trans('admin.Phone1')}} </th>
                                        <th>{{trans('admin.Phone2')}} </th>
                                        <th>{{trans('admin.Location')}} </th>
                                        <th>{{trans('admin.Sender')}} </th>

                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                            <td>{{$item->Sender_Name}}</td>
                                            <td>

                                                @if(!empty($item->Sender_Governorate()->first()->Arabic_Name))

                                                    {{$item->Sender_Governorate()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            <td>

                                                @if(!empty($item->Sender_City()->first()->Arabic_Name))

                                                    {{$item->Sender_City()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            <td>

                                                @if(!empty($item->Sender_Place()->first()->Arabic_Name))

                                                    {{$item->Sender_Place()->first()->Arabic_Name}}

                                                @endif


                                            </td>

                                            <td>{{$item->Sender_Address}}</td>
                                            <td>{{$item->Sender_Phone1}}</td>
                                            <td>{{$item->Sender_Phone2}}</td>
                                            <td>{{$item->Sender_Location}}</td>

                                            <td>

                                                @if(!empty($item->Sender()->first()->Name))

                                                    {{$item->Sender()->first()->Name}}

                                                @endif


                                            </td>






                                        </tr>

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Received -->
            <div class="modal fade" id="Received{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Received')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Name')}} </th>
                                        <th>{{trans('admin.Governorate')}} </th>
                                        <th>{{trans('admin.City')}} </th>
                                        <th>{{trans('admin.Place')}} </th>
                                        <th>{{trans('admin.Address')}} </th>
                                        <th>{{trans('admin.Phone1')}} </th>
                                        <th>{{trans('admin.Phone2')}} </th>
                                        <th>{{trans('admin.Location')}} </th>
                                        <th>{{trans('admin.Received')}} </th>


                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                            <td>{{$item->Receiver_Name}}</td>
                                            <td>

                                                @if(!empty($item->Receiver_Governorate()->first()->Arabic_Name))

                                                    {{$item->Receiver_Governorate()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            <td>

                                                @if(!empty($item->Receiver_City()->first()->Arabic_Name))

                                                    {{$item->Receiver_City()->first()->Arabic_Name}}

                                                @endif


                                            </td>
                                            <td>

                                                @if(!empty($item->Receiver_Place()->first()->Arabic_Name))

                                                    {{$item->Receiver_Place()->first()->Arabic_Name}}

                                                @endif


                                            </td>

                                            <td>{{$item->Receiver_Address}}</td>
                                            <td>{{$item->Receiver_Phone1}}</td>
                                            <td>{{$item->Receiver_Phone2}}</td>
                                            <td>{{$item->Receiver_Location}}</td>

                                            <td>

                                                @if(!empty($item->Received()->first()->Name))

                                                    {{$item->Received()->first()->Name}}

                                                @endif


                                            </td>






                                        </tr>

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Cost -->
            <div class="modal fade" id="Cost{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Cost')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Shipment_Cost')}} </th>
                                        <th>{{trans('admin.Total')}} </th>
                                        <th>{{trans('admin.Pay')}} </th>



                                    </tr>
                                    </thead>
                                    <tbody id="">

                                        <tr>
                                            <td>{{$item->Shipment_Cost}}</td>
                                            <td>{{$item->Total}}</td>
                                            <td>{{$item->Pay}}</td>





                                        </tr>

                                    </tbody>
                                </table>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>


        @endforeach
    </main>

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
@endpush

