@extends('admin.index')
@section('content')

    <title>{{trans('admin.ShipmentMoves')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Shipping')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.ShipmentMoves')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        
           <!-- Filter -->
        <form action="{{url('FilterShipmentMoves')}}" method="get">
        <div class="row">
            
            <div class="col-md-4">
            <label>{{trans('admin.From')}}</label>
            <input type="date" name="From" class="form-control" value="{{date('Y-01-01')}}" required>
            </div>
                
            <div class="col-md-4">
            <label>{{trans('admin.To')}}</label>
            <input type="date" name="To" class="form-control" value="{{date('Y-m-d')}}" required>
            </div>
                     
            <div class="col-md-4">
            <label>{{trans('admin.Barcode')}}</label>
            <input type="text" name="Barcode" class="form-control" >
            </div>
      
                            
            <div class="col-md-4">
             <label class="form-label" for="simpleinput">{{trans('admin.Sender')}}</label>
             <select class="select2 form-control" name="Sender" id="Sender">
                 <option value="">{{trans('admin.Sender')}}</option>
             </select>
            </div>      
                            
            <div class="col-md-4">
             <label class="form-label" for="simpleinput">{{trans('admin.Received')}}</label>
             <select class="select2 form-control" name="Received" id="Received">
                 <option value="">{{trans('admin.Received')}}</option>
             </select>
            </div>
                           
            <div class="col-md-4">
             <label class="form-label" for="simpleinput">{{trans('admin.Delegate')}}</label>
             <select class="select2 form-control" name="Delegate" id="Delegate">
                 <option value="">{{trans('admin.Delegate')}}</option>
             </select>
            </div>
                           
            <div class="col-md-4">
             <label class="form-label" for="simpleinput">{{trans('admin.Driver')}}</label>
             <select class="select2 form-control" name="Driver" id="Driver">
                 <option value="">{{trans('admin.Driver')}}</option>
             </select>
            </div>

                                    
            <div class="col-md-4">
             <label class="form-label" for="simpleinput">{{trans('admin.Status')}}</label>
             <select class="select2 form-control" name="Status" id="Status">
                 <option value="">{{trans('admin.Status')}}</option>
                 <option value="0">{{trans('admin.Pending')}}</option>
                 <option value="1">{{trans('admin.Distrbuted')}}</option>
                 <option value="2">{{trans('admin.Moved')}}</option>
                 <option value="3">{{trans('admin.Delivered')}}</option>
                 <option value="4">{{trans('admin.Unloading')}}</option>
                 <option value="5">{{trans('admin.CarBack')}}</option>
                 <option value="6">{{trans('admin.DelegateProcessing')}}</option>
                 <option value="7">{{trans('admin.ClientDelivered')}}</option>
             </select>
            </div>

            


        
            
              <div class="col-md-2">
            <button type="submit" class="btn btn-primary"><i class="fal fa-search"></i></button>      
            </div>
            
            
        </div>
            </form>
        
        
        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>{{trans('admin.ShipmentMoves')}}</i></span>
                        </h2>

                        <div class="panel-toolbar">


                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <table
                                   class="table table-bordered table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                <tr>


                                    <th>{{trans('admin.Code')}}</th>
                                    <th>{{trans('admin.Barcode')}}</th>
                                    <th>{{trans('admin.Date')}}</th>
                                    <th>{{trans('admin.Time')}}</th>
                                    <th>{{trans('admin.Sender_Name')}}</th>
                                    <th>{{trans('admin.Reciver_Name')}}</th>
                                    <th>{{trans('admin.Status')}}</th>
                                    <th>{{trans('admin.Status_Code')}}</th>
                                    <th>{{trans('admin.Delegate')}}</th>
                                    <th>{{trans('admin.Driver')}}</th>
                                    <th>{{trans('admin.Note')}}</th>
                                    <th>{{trans('admin.FromStore')}}</th>
                                    <th>{{trans('admin.ToStore')}}</th>
                                    <th>{{trans('admin.User')}}</th>


                                </tr>
                                </thead>
                                <tbody>

                                @foreach($items as $item)
                                    <tr>
                                        <td>{{$item->Code}}</td>
                                        <td>{{$item->Barcode}}</td>
                                        <td>{{$item->Date}}</td>
                                        <td>{{$item->Time}}</td>
                                        <td>{{$item->Sender_Name}}</td>
                                        <td>{{$item->Reciver_Name}}</td>
                                        <td>

                                            {{$item->Status->desc()}}
                                           

                                        </td>
                                        <td>{{$item->Status_Code}}</td>


                                        <td>

                                            @if(!empty($item->Delegate()->first()->Name))

                                                {{$item->Delegate()->first()->Name}}

                                            @endif


                                        </td>


                                        <td>

                                            @if(!empty($item->Driver()->first()->Name))

                                                {{$item->Driver()->first()->Name}}

                                            @endif


                                        </td>

                                        <td>{{$item->Note}}</td>
                                        
                                        
                                        
                                               <td>

                                            @if(!empty($item->Shipment_ID()->first()->Store()->first()->Name))

                                                {{$item->Shipment_ID()->first()->Store()->first()->Name}}

                                            @endif


                                        </td>
                                        
                                        
                                           
                                               <td>

                                            @if(!empty($item->Shipment_ID()->first()->ToStore()->first()->Name))

                                                {{$item->Shipment_ID()->first()->ToStore()->first()->Name}}

                                            @endif


                                        </td>

                                        

                                        
                                        

                                        <td>

                                            @if(!empty($item->User()->first()->name))

                                                {{$item->User()->first()->name}}

                                            @endif


                                        </td>




                                    </tr>
                                @endforeach


                                </tbody>
                                <tfoot>
                                <tr>

                                    <th>{{trans('admin.Code')}}</th>
                                    <th>{{trans('admin.Barcode')}}</th>
                                    <th>{{trans('admin.Date')}}</th>
                                    <th>{{trans('admin.Time')}}</th>
                                    <th>{{trans('admin.Sender_Name')}}</th>
                                    <th>{{trans('admin.Reciver_Name')}}</th>
                                    <th>{{trans('admin.Status')}}</th>
                                    <th>{{trans('admin.Status_Code')}}</th>
                                    <th>{{trans('admin.Delegate')}}</th>
                                    <th>{{trans('admin.Driver')}}</th>
                                    <th>{{trans('admin.Note')}}</th>
                                    <th>{{trans('admin.FromStore')}}</th>
                                    <th>{{trans('admin.ToStore')}}</th>
                                    <th>{{trans('admin.User')}}</th>

                                </tr>
                                </tfoot>
                            </table>
                            {{$items->Links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </main>

@endsection

@push('js')


<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script>
    //_fnFeatureHtmlLength();
    $(document).ready(function() {
        // Setup - add a text input to each footer cell
        $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
        $('#dt-basic-example thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

            $('input', this).on('keyup change', function() {
                if (table.column(i).search() !== this.value) {
                    table
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });
        var table = $('#dt-basic-example').DataTable({
            responsive: true,
            orderCellsTop: true,
            fixedHeader: true,
            lengthChange: true,

            dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

            buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'colvis',
                    text: 'Column Visibility',
                    titleAttr: 'Col visibility',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    titleAttr: 'Generate PDF',
                    className: 'btn-outline-danger btn-sm mr-1'
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    titleAttr: 'Generate Excel',
                    className: 'btn-outline-success btn-sm mr-1'
                },
                {
                    extend: 'csvHtml5',
                    text: 'CSV',
                    titleAttr: 'Generate CSV',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'copyHtml5',
                    text: 'Copy',
                    titleAttr: 'Copy to clipboard',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'print',
                    text: 'Print',
                    titleAttr: 'Print Table',
                    className: 'btn-outline-primary btn-sm'
                }
            ],
        });
        $('.js-thead-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
        });

        $('.js-tbody-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
        });

    });
</script>
<!-- Search Select -->
<script>
    $(document).ready(function() {
        $(function() {
            $(".select2").select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State",
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0,
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items",
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true,
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm;
                },
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
            }

            $("#Delegate").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "DelegatesShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'DelegatesShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Delegate').empty();
                                $.each(data, function(key, value) {

                                    $('#Delegate').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Delegate").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });


            $("#Driver").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "DriversShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'DriversShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Driver').empty();
                                $.each(data, function(key, value) {

                                    $('#Driver').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Driver").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });



            $("#Sender").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "SenderShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'SenderShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Sender').empty();
                                $.each(data, function(key, value) {

                                    $('#Sender').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Sender").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });


            $("#Received").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "RecivedShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'RecivedShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Received').empty();
                                $.each(data, function(key, value) {

                                    $('#Received').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Received").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });



            $("#Sender_Governorate").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "GovShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'GovShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Sender_Governorate').empty();
                                $.each(data, function(key, value) {

                                    $('#Sender_Governorate').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Sender_Governorate").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });


            $("#Receiver_Governorate").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "GovShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'GovShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Receiver_Governorate').empty();
                                $.each(data, function(key, value) {

                                    $('#Receiver_Governorate').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Receiver_Governorate").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });




            $("#Governrate").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "GovShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'GovShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Governrate').empty();
                                $.each(data, function(key, value) {

                                    $('#Governrate').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Governrate").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });




            $('#Coin').select2({
                placeholder: "Select...",
                allowClear: true,
                ajax: {
                    // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
                    url: 'NewAllCoins',
                    dataType: 'json',
                    delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
                    data: function(params) {
                        // Select2 هيبعت كلمة البحث باسم 'term'
                        return {
                            term: params.term // ده الكلمة اللي بيكتبها المستخدم
                        };
                    },
                    processResults: function(data) {
                        // هنا Select2 بيستقبل البيانات من السيرفر
                        // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
                        var results = [];
                        $.each(data, function(key, value) {
                            results.push({
                                id: key, // الـ ID بتاع الحساب
                                text: value // الاسم بتاع الحساب
                            });
                        });

                        return {
                            results: results
                        };
                    },
                    cache: true
                }
            });

            $('#Safe').select2({
                placeholder: "Select...",
                allowClear: true,
                ajax: {
                    // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
                    url: 'NewAllSafesBanks',
                    dataType: 'json',
                    delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
                    data: function(params) {
                        // Select2 هيبعت كلمة البحث باسم 'term'
                        return {
                            term: params.term // ده الكلمة اللي بيكتبها المستخدم
                        };
                    },
                    processResults: function(data) {
                        // هنا Select2 بيستقبل البيانات من السيرفر
                        // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
                        var results = [];
                        $.each(data, function(key, value) {
                            results.push({
                                id: key, // الـ ID بتاع الحساب
                                text: value // الاسم بتاع الحساب
                            });
                        });

                        return {
                            results: results
                        };
                    },
                    cache: true
                }
            });


            $('#Store').select2({
                placeholder: "Select...",
                allowClear: true,
                ajax: {
                    // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
                    url: 'NewAllStores',
                    dataType: 'json',
                    delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
                    data: function(params) {
                        // Select2 هيبعت كلمة البحث باسم 'term'
                        return {
                            term: params.term // ده الكلمة اللي بيكتبها المستخدم
                        };
                    },
                    processResults: function(data) {
                        // هنا Select2 بيستقبل البيانات من السيرفر
                        // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
                        var results = [];
                        $.each(data, function(key, value) {
                            results.push({
                                id: key, // الـ ID بتاع الحساب
                                text: value // الاسم بتاع الحساب
                            });
                        });

                        return {
                            results: results
                        };
                    },
                    cache: true
                }
            });



        });
    });
</script>

@endpush

