@extends('admin.index')
@section('content')
<title>{{trans('admin.Shipment')}}</title>
<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Shipping')}}</a></li>
        <li class="breadcrumb-item active"> {{trans('admin.Shipment')}} </li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>
    <!-- CSS -->
    <style>
        .BORDER.spark {
            height: 6px;
            border-radius: 6px;
            background: linear-gradient(90deg,
                    #fffacd,
                    /* Lemon Chiffon */
                    #fafad2,
                    /* Light Goldenrod Yellow */
                    #ffd700,
                    /* Gold */
                    #fafad2,
                    #fffacd);
            position: relative;
            overflow: hidden;
            margin: 14px 0;
        }

        .BORDER.spark::before {
            content: "";
            position: absolute;
            top: 0;
            left: -50px;
            width: 50px;
            height: 100%;
            background: linear-gradient(90deg,
                    transparent,
                    rgba(255, 255, 255, 0.9),
                    transparent);
            animation: sparkMove 1.2s linear infinite;
        }

        @keyframes sparkMove {
            0% {
                left: -50px;
            }

            100% {
                left: 100%;
            }
        }

        .boxed-section {
            border: 2px solid #ddd;
            border-radius: 8px;
            padding: 15px 20px;
            margin-bottom: 20px;
            background: #f9f9f9;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
        }

        .boxed-section .section-title {
            font-size: 16px;
            font-weight: bold;
            color: #444;
            margin-bottom: 15px;
            border-bottom: 1px solid #ccc;
            padding-bottom: 5px;
        }
    </style>
    <!-- data entry -->
    <div class="row">
        <div class="col-lg-12">
            <div id="panel-2" class="panel">
                <div class="panel-hdr">
                </div>
                <div class="panel-container show">
                    <span id="ex"> @include('admin.layouts.messages')</span>
                    <div class="panel-content">
                        <ul class="nav nav-tabs" role="tablist">
                            <!--<li class="nav-item">-->
                            <!--   <a class="nav-link active" data-toggle="tab" href="#tab_borders_icons-8" role="tab">   {{trans('admin.Shipment')}}  </a>-->
                            <!--</li>-->
                        </ul>
                        <div class="tab-content border border-top-0 p-3">
                            <div class="tab-pane fade show active" id="tab_borders_icons-8" role="tabpanel">
                                <form action="{{url('AddNewShipment')}}" method="post" enctype="multipart/form-data" class="form-row">
                                    {!! csrf_field() !!}
                                    @honeypot
                                    <div class="col-md-12">
                                        <div class="data-def">
                                            <div class="form-row">
                                                <div class="boxed-section">
                                                    <h5 class="section-title">{{ trans('admin.Shipment_Details') }}</h5>
                                                    <div class="row">
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                                            <input type="text" value="{{$Code}}" name="Code" class="form-control " readonly>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Reference_Num')}}</label>
                                                            <input type="text" name="Reference_Num" value="{{old('Reference_Num')}}" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                                            <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Arrival_Date')}}</label>
                                                            <input type="date" name="Arrival_Date" value="{{old('Arrival_Date')}}" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Arrival_Time')}}</label>
                                                            <input type="time" name="Arrival_Time" value="{{old('Arrival_Time')}}" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Store')}}</label>
                                                            <select class="select2 form-control" name="Store" id="Store" required>


                                                                @if(!empty($Def->Store()->first()->Name))
                                                                <option value="{{$Def->Store}}">

                                                                    {{app()->getLocale() == 'ar' ?$Def->Store()->first()->Name :$Def->Store()->first()->NameEn}}

                                                                </option>

                                                                @endif


                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Shipment_Class')}}</label>
                                                            <select class="select2 form-control" name="Shipment_Class" id="Shipment_Class" onchange="COST()" required>
                                                                <option value="">{{trans('admin.Shipment_Class')}}</option>
                                                                <option value="Hub" @if($Def->Shipment_Class == 'Hub') selected @endif>{{trans('admin.Hub_to_Hub')}}</option>
                                                                <option value="Door" @if($Def->Shipment_Class == 'Door') selected @endif>{{trans('admin.Door_to_Door')}}</option>
                                                                <option value="Stored" @if($Def->Shipment_Class == 'Stored') selected @endif>{{trans('admin.Stored_Shipping')}}</option>
                                                                <option value="HubToDoor" @if($Def->Shipment_Class == 'HubToDoor') selected @endif>{{trans('admin.Hub_to_Door')}}</option>
                                                                <option value="DoorToHub" @if($Def->Shipment_Class == 'DoorToHub') selected @endif>{{trans('admin.Door_to_Hub')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Payment_Method')}}</label>
                                                            <select class="select2 form-control" name="Payment_Method" id="Payment_Method" required>
                                                                <option value="">{{trans('admin.Payment_Method')}}</option>
                                                                <option value="Cash" @if($Def->Payment_Method == 'Cash') selected @endif>{{trans('admin.Cash')}}</option>
                                                                <option value="Later" @if($Def->Payment_Method == 'Later') selected @endif>{{trans('admin.Later')}}</option>
                                                                <option value="Visa" @if($Def->Payment_Method == 'Visa') selected @endif>{{trans('admin.Visa')}}</option>
                                                                <option value="Electronic_Wallet" @if($Def->Payment_Method == 'Electronic_Wallet') selected @endif>{{trans('admin.Electronic_Wallet')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Safe')}}</label>
                                                            <select class="select2 form-control" name="Safe" id="Safe" required>


                                                                @if(!empty($Def->Safe()->first()->Name))
                                                                <option value="{{$Def->Safe}}">

                                                                    {{app()->getLocale() == 'ar' ?$Def->Safe()->first()->Name :$Def->Safe()->first()->NameEn}}

                                                                </option>

                                                                @endif

                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Coin')}}</label>
                                                            <select class="select2 form-control" name="Coin" id="Coin" required>



                                                                @if(!empty($Def->Coin()->first()->Arabic_Name))
                                                                <option value="{{$Def->Coin}}">

                                                                    {{app()->getLocale() == 'ar' ?$Def->Coin()->first()->Arabic_Name :$Def->Coin()->first()->English_Name}}

                                                                </option>

                                                                @endif



                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                                            <input type="number" step="any" name="Draw" value="{{$Def->Draw}}" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Breakable')}}</label>
                                                            <select class="select2 form-control" name="Breakable" id="Breakable" required>
                                                                <option value="">{{trans('admin.Breakable')}}</option>
                                                                <option value="Yes" @if($Def->Breakable == 'Yes') selected @endif>{{trans('admin.Yes')}}</option>
                                                                <option value="No" @if($Def->Breakable == 'No') selected @endif>{{trans('admin.No')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Opening_Package')}}</label>
                                                            <select class="select2 form-control" name="Opening_Package" id="Opening_Package">
                                                                <option value="">{{trans('admin.Opening_Package')}}</option>
                                                                <option value="Yes" @if($Def->Opening_Package == 'Yes') selected @endif>{{trans('admin.Yes')}}</option>
                                                                <option value="No" @if($Def->Opening_Package == 'No') selected @endif>{{trans('admin.No')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Shipment_Type')}}</label>
                                                            <select class="select2 form-control" name="Shipment_Type" id="Shipment_Type" required>
                                                                <option value="">{{trans('admin.Shipment_Type')}}</option>
                                                                <option value="Shipping" @if($Def->Shipment_Type == 'Shipping') selected @endif>{{trans('admin.Shipping')}}</option>
                                                                <option value="CollectionShippingDeposit" @if($Def->Shipment_Type == 'CollectionShippingDeposit') selected @endif>{{trans('admin.CollectionShippingDeposit')}}</option>
                                                                <option value="CollectionShipping" @if($Def->Shipment_Type == 'CollectionShipping') selected @endif>{{trans('admin.CollectionShipping')}}</option>
                                                                <option value="ReturnShipping" @if($Def->Shipment_Type == 'ReturnShipping') selected @endif>{{trans('admin.ReturnShipping')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Shipment_Category')}}</label>
                                                            <select class="select2 form-control" name="Shipment_Category" id="Shipment_Category" required>
                                                                <option value="">{{trans('admin.Shipment_Category')}}</option>
                                                                @foreach($Categories as $cat)
                                                                <option value="{{$cat->id}}" @if($cat->id == $Def->Shipment_Category) selected @endif>
                                                                    {{app()->getLocale() == 'ar' ?$cat->Arabic_Name :$cat->English_Name}}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Shipment_Rqst_Type')}}</label>
                                                            <select class="select2 form-control" name="Shipment_Rqst_Type" id="Shipment_Rqst_Type" required>
                                                                <option value="">{{trans('admin.Shipment_Rqst_Type')}}</option>
                                                                @foreach($RqstTypes as $Rtype)
                                                                <option value="{{$Rtype->id}}">
                                                                    {{app()->getLocale() == 'ar' ?$Rtype->Arabic_Name :$Rtype->English_Name}}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Delivery_To_Others')}}</label>
                                                            <select class="select2 form-control" name="Delivery_To_Others" id="Delivery_To_Others">
                                                                <option value="">{{trans('admin.Delivery_To_Others')}}</option>
                                                                <option value="Yes" @if($Def->Delivery_To_Others == 'Yes') selected @endif>{{trans('admin.Yes')}}</option>
                                                                <option value="No" @if($Def->Delivery_To_Others == 'No') selected @endif>{{trans('admin.No')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Shipping_Costs_Included')}}</label>
                                                            <select class="select2 form-control" name="Shipping_Costs_Included" id="Shipping_Costs_Included">
                                                                <option value="">{{trans('admin.Shipping_Costs_Included')}}</option>
                                                                <option value="Yes" @if($Def->Shipping_Costs_Included == 'Yes') selected @endif>{{trans('admin.Yes')}}</option>
                                                                <option value="No" @if($Def->Shipping_Costs_Included == 'No') selected @endif>{{trans('admin.No')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Insurance')}}</label>
                                                            <select class="select2 form-control" name="Insurance" id="Insurance">
                                                                <option value="">{{trans('admin.Insurance')}}</option>
                                                                <option value="Yes" @if($Def->Insurance == 'Yes') selected @endif>{{trans('admin.Yes')}}</option>
                                                                <option value="No" @if($Def->Insurance == 'No') selected @endif>{{trans('admin.No')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Pieces_Num')}}</label>
                                                            <input type="number" step="any" name="Pieces_Num" value="1" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Weight')}}</label>
                                                            <input type="number" step="any" name="Weight" id="Weight" value="0" onclick="COST()" onkeyup="COST()" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Length')}}</label>
                                                            <input type="number" step="any" name="Length" value="{{old('Length')}}" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Width')}}</label>
                                                            <input type="number" step="any" name="Width" value="{{old('Width')}}" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Height')}}</label>
                                                            <input type="number" step="any" name="Height" value="{{old('Height')}}" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-6">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Desc')}}</label>
                                                            <textarea name="Desc" class="form-control">{{old('Desc')}}</textarea>
                                                        </div>
                                                        <div class="form-group col-lg-6">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Note')}}</label>
                                                            <textarea name="Note" class="form-control">{{old('Note')}}</textarea>
                                                        </div>
                                                        <div class="form-group col-lg-6" style="display: none">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Delegate')}}</label>
                                                            <select class="select2 form-control" name="Delegate" id="Delegate">
                                                                <option value="">{{trans('admin.Delegate')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-6" style="display: none">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Driver')}}</label>
                                                            <select class="select2 form-control" name="Driver" id="Driver">
                                                                <option value="">{{trans('admin.Driver')}}</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>



                                                <!-- Sender -->
                                                <div class="boxed-section">
                                                    <h5 class="section-title">{{ trans('admin.Sender_Information') }}</h5>
                                                    <div class="row">
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Sender')}}</label>
                                                            <select class="select2 form-control" name="Sender" id="Sender" onchange="SenderData()" required>
                                                                <option value="">{{trans('admin.Sender')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-1">
                                                            <button style="margin: 22px" type="button" class="btn btn-default" data-toggle="modal" data-target="#NewClient">
                                                                <i class="fal fa-user"></i>
                                                            </button>
                                                            <!-- Modal New Client -->
                                                            <div class="modal fade" id="NewClient" tabindex="-1" role="dialog" aria-hidden="true">
                                                                
                                                                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h4 class="modal-body row">
                                                                                <div class="form-group col-md-4">
                                                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Name')}} </label><span class="strick">*</span>
                                                                                    <input type="text" id="Name" value="{{old('Name')}}" class="form-control">
                                                                                </div>
                                                                                <div class="form-group col-lg-4">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.Phone1')}}</label>
                                                                                    <input type="tel" value="{{old('Phone1')}}" id="Phone1" class="form-control">
                                                                                </div>
                                                                                <div class="form-group col-lg-4">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.Phone2')}}</label>
                                                                                    <input type="tel" value="{{old('Phone2')}}" id="Phone2" class="form-control">
                                                                                </div>
                                                                                <div class="form-group col-lg-4">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.Governrate')}}</label>
                                                                                    <select class="select2 form-control" id="Governrate">
                                                                                        <option value="">{{trans('admin.Governrate')}}</option>
                                                                                    </select>
                                                                                </div>
                                                                                <div class="form-group col-lg-4">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.City')}}</label>
                                                                                    <select class="select2 form-control" id="City">
                                                                                        <option value="">{{trans('admin.City')}}</option>
                                                                                    </select>
                                                                                </div>
                                                                                <div class="form-group col-lg-4">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.Place')}}</label>
                                                                                    <select class="select2 form-control" id="Place">
                                                                                        <option value="">{{trans('admin.Place')}}</option>
                                                                                    </select>
                                                                                </div>
                                                                                <div class="form-group col-lg-12">
                                                                                    <label class="form-label" for="simpleinput">{{trans('admin.Address')}}</label>
                                                                                    <input type="text" value="{{old('Address')}}" id="Address" class="form-control">
                                                                                </div>
                                                                            </h4>
                                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                                                            </button>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                                                                            <button type="button" onclick="NewClients()" class="btn btn-primary"> {{trans('admin.AddNew')}}</button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Sender_Name')}}</label>
                                                            <input type="text" name="Sender_Name" value="{{old('Sender_Name')}}" id="Sender_Name" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Phone1')}}</label>
                                                            <input type="tel" name="Sender_Phone1" value="{{old('Sender_Phone1')}}" id="Sender_Phone1" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Phone2')}}</label>
                                                            <input type="tel" name="Sender_Phone2" value="{{old('Sender_Phone2')}}" id="Sender_Phone2" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Location')}}</label>
                                                            <input type="text" name="Sender_Location" value="{{old('Sender_Location')}}" id="Sender_Location" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Governrate')}}</label>
                                                            <select class="select2 form-control" name="Sender_Governorate" id="Sender_Governorate" required>
                                                                <option value="">{{trans('admin.Governrate')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.City')}}</label>
                                                            <select class="select2 form-control" name="Sender_City" id="Sender_City" required>
                                                                <option value="">{{trans('admin.City')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Place')}}</label>
                                                            <select class="select2 form-control" name="Sender_Place" id="Sender_Place" required>
                                                                <option value="">{{trans('admin.Place')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Address')}}</label>
                                                            <input type="text" name="Sender_Address" value="{{old('Sender_Address')}}" id="Sender_Address" class="form-control" required>
                                                        </div>
                                                    </div>
                                                    
                                                    
                                                    
                                                      <div class="form-group col-lg-12" style="display: none" id="StoresPro">
                                                      <div class="row">
                                                          
                                  <div class="form-group col-lg-12">
                                    <label class="form-label" for="simpleinput"> </label>
                                    <div class="input-items" style="position:relative;">
                                        <input type="text" id="search" class="form-control" placeholder="{{trans('admin.Search_For_Products')}}">
                                        @if(app()->getLocale() == 'ar' )
                                        <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;left:3px;"></i>
                                        @else
                                        <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;right: 0;left:auto;"></i>
                                        @endif
                                    </div>
                                </div>
                                                          
            <div id="mobile-overflow col-lg-12">
                                <table class="table table-bordered table-hover table-striped w-100 mobile-width-more table-color1 mt-2">
                                    <thead>
                                        <tr>
                                            <th>{{trans('admin.Name')}}</th>
                                            <th>{{trans('admin.Unit')}}</th>
                                            <th>{{trans('admin.Code')}}</th>
                                            <th>{{trans('admin.AvQty')}}</th>
                                            <th>{{trans('admin.Qty')}}</th>
                                            <th>{{trans('admin.Price')}}</th>
                                            <th>{{trans('admin.Total')}}</th>
                                            <th>{{trans('admin.Actions')}}</th>
                                        </tr>
                                    </thead>
                                    <tbody class="Data" id="Data">
                                    </tbody>
                                </table>
                            </div>
                                                          
                            <!-- datatable start -->
                            <div id="mobile-overflow col-lg-12">
                                <table id="dt" class="table table-bordered table-hover table-striped w-100 mobile-width table-color2">
                                    <thead>
                                        <tr>
                                            <th>{{trans('admin.Name')}}</th>
                                            <th>{{trans('admin.Unit')}}</th>
                                            <th>{{trans('admin.Code')}}</th>
                                            <th>{{trans('admin.AvQty')}}</th>
                                            <th>{{trans('admin.Qty')}}</th>
                                            <th>{{trans('admin.Price')}}</th>
                                            <th>{{trans('admin.Total')}}</th>
                                            <th>{{trans('admin.Actions')}}</th>
                                        </tr>
                                    </thead>
                                    <tbody id="data-dt">
                                    </tbody>
                                </table>

                              
                            </div>  
                                                          
                                                          
                                                          
                                                    </div>
                                                    </div>
                                                   
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                </div>

                                                <!--<div class="col-md-12 BORDER spark"></div>-->
                                                <!-- Recived -->
                                                <!-- غلف الكود الحالي داخل ديف للإطار -->
                                                <div class="boxed-section">
                                                    <h5 class="section-title">{{ trans('admin.Receiver_Information') }}</h5>
                                                    <div class="row">
                                                        <!-- نفس الأكواد الداخلية اللي انت حاططها -->
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Received')}}</label>
                                                            <select class="select2 form-control" name="Received" id="Received" onchange="ReciverData()" required>
                                                                <option value="">{{trans('admin.Received')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-1">
                                                            <button style="margin: 22px" type="button" class="btn btn-default" data-toggle="modal" data-target="#NewClient">
                                                                <i class="fal fa-user"></i>
                                                            </button>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Receiver_Name')}}</label>
                                                            <input type="text" name="Receiver_Name" value="{{old('Receiver_Name')}}" id="Receiver_Name" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Phone1')}}</label>
                                                            <input type="tel" name="Receiver_Phone1" value="{{old('Receiver_Phone1')}}" id="Receiver_Phone1" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Phone2')}}</label>
                                                            <input type="tel" name="Receiver_Phone2" value="{{old('Receiver_Phone2')}}" id="Receiver_Phone2" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Location')}}</label>
                                                            <input type="text" name="Receiver_Location" value="{{old('Receiver_Location')}}" id="Receiver_Location" class="form-control">
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Governrate')}}</label>
                                                            <select class="select2 form-control" name="Receiver_Governorate" id="Receiver_Governorate" required>
                                                                <option value="">{{trans('admin.Governrate')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.City')}}</label>
                                                            <select class="select2 form-control" name="Receiver_City" id="Receiver_City" required>
                                                                <option value="">{{trans('admin.City')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Place')}}</label>
                                                            <select class="select2 form-control" name="Receiver_Place" id="Receiver_Place" required>
                                                                <option value="">{{trans('admin.Place')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-3">
                                                            <label class="form-label" for="simpleinput">{{trans('admin.Address')}}</label>
                                                            <input type="text" name="Receiver_Address" value="{{old('Receiver_Address')}}" id="Receiver_Address" class="form-control" required>
                                                        </div>
                                                    </div>
                                                </div>





                                                <!-- Totals -->
                                                <div class="boxed-section">
                                                    <h5 class="section-title">{{ trans('admin.Cost_Details') }}</h5>
                                                    <div class="row">
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="Shipment_Cost">{{trans('admin.Shipment_Cost')}}</label>
                                                            <input type="number" step="any" name="Shipment_Cost" value="0" onclick="TOTAL()" onkeyup="TOTAL()" id="Shipment_Cost" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="Goods_Cost">{{trans('admin.Goods_Cost')}}</label>
                                                            <input type="number" step="any" name="Goods_Cost" value="0" onclick="TOTAL()" onkeyup="TOTAL()" id="Goods_Cost" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="Delivery_Cost">{{trans('admin.Delivery_Cost')}}</label>
                                                            <input type="number" step="any" name="Delivery_Cost" value="0" onclick="TOTAL()" onkeyup="TOTAL()" id="Delivery_Cost" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="Overload_Weight_Cost">{{trans('admin.Overload_Weight_Cost')}}</label>
                                                            <input type="number" step="any" name="Overload_Weight_Cost" value="0" onclick="TOTAL()" onkeyup="TOTAL()" id="Overload_Weight_Cost" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="Collection_Commission">{{trans('admin.Collection_Commission')}}</label>
                                                            <input type="number" step="any" name="Collection_Commission" value="0" onclick="TOTAL()" onkeyup="TOTAL()" id="Collection_Commission" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="Delivery_Commission">{{trans('admin.Delivery_Commission')}}</label>
                                                            <input type="number" step="any" name="Delivery_Commission" value="0" onclick="TOTAL()" onkeyup="TOTAL()" id="Delivery_Commission" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="Return_Cost">{{trans('admin.Return_Cost')}}</label>
                                                            <input type="number" step="any" name="Return_Cost" value="0" onclick="TOTAL()" onkeyup="TOTAL()" id="Return_Cost" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="Total">{{trans('admin.Total')}}</label>
                                                            <input type="number" step="any" name="Total" value="0" id="Total" class="form-control" readonly>
                                                        </div>
                                                        <div class="form-group col-lg-2">
                                                            <label class="form-label" for="Pay">{{trans('admin.Pay')}}</label>
                                                            <input type="number" step="any" name="Pay" id="Pay" class="form-control" required>
                                                            <input type="hidden" step="any" name="Product_Numbers" id="Product_Numbers" class="form-control" value="0">
                                                            <input type="hidden" step="any" name="Total_Qty" id="Total_Qty" class="form-control" value="0">
                                                            <input type="hidden" step="any" name="Total_Price" id="Total_Price" class="form-control" value="0">
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#Save" onclick="ChangeStatus(1)"> <i class="fal fa-folder"></i> {{trans('admin.Save')}} </button>
                                        <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#Save" onclick="ChangeStatus(2)"> <i class="fal fa-folder"></i> {{trans('admin.SaveandPrint')}} </button>
                                        <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#Save" onclick="ChangeStatus(3)"> <i class="fal fa-folder"></i> {{trans('admin.SaveandPrint8')}} </button>

                                        <input type="hidden" id="Status" name="Status" value="1">

                                        <!-- Modal Submit -->
                                        <div class="modal fade" id="Save" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">
                                                            {{trans('admin.Submit')}}
                                                        </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                                        </button>
                                                    </div>

                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                                                        <button type="submit" class="btn btn-primary"> {{trans('admin.Yes')}}</button>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<style>
    .BORDER {
        border-bottom: 3px solid black;
        margin-bottom: 50px;
        margin-top: 50px;
    }
</style>
@endsection
@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script>
    //_fnFeatureHtmlLength();
    $(document).ready(function() {
        // Setup - add a text input to each footer cell
        $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
        $('#dt-basic-example thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

            $('input', this).on('keyup change', function() {
                if (table.column(i).search() !== this.value) {
                    table
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });
        var table = $('#dt-basic-example').DataTable({
            responsive: true,
            orderCellsTop: true,
            fixedHeader: true,
            lengthChange: true,

            dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

            buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'colvis',
                    text: 'Column Visibility',
                    titleAttr: 'Col visibility',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    titleAttr: 'Generate PDF',
                    className: 'btn-outline-danger btn-sm mr-1'
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    titleAttr: 'Generate Excel',
                    className: 'btn-outline-success btn-sm mr-1'
                },
                {
                    extend: 'csvHtml5',
                    text: 'CSV',
                    titleAttr: 'Generate CSV',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'copyHtml5',
                    text: 'Copy',
                    titleAttr: 'Copy to clipboard',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'print',
                    text: 'Print',
                    titleAttr: 'Print Table',
                    className: 'btn-outline-primary btn-sm'
                }
            ],
        });
        $('.js-thead-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
        });

        $('.js-tbody-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
        });

    });
</script>
<!-- Search Select -->
<script>
    
    $(document).ready(function() {
        $(function() {
            $(".select2").select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State",
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0,
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items",
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true,
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm;
                },
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
            }

            $("#Delegate").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "DelegatesShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'DelegatesShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Delegate').empty();
                                $.each(data, function(key, value) {

                                    $('#Delegate').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Delegate").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });


            $("#Driver").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "DriversShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'DriversShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Driver').empty();
                                $.each(data, function(key, value) {

                                    $('#Driver').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Driver").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });



            $("#Sender").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "SenderShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'SenderShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Sender').empty();
                                $.each(data, function(key, value) {

                                    $('#Sender').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Sender").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });


            $("#Received").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "RecivedShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'RecivedShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Received').empty();
                                $.each(data, function(key, value) {

                                    $('#Received').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Received").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });



            $("#Sender_Governorate").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "GovShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'GovShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Sender_Governorate').empty();
                                $.each(data, function(key, value) {

                                    $('#Sender_Governorate').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Sender_Governorate").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });


            $("#Receiver_Governorate").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "GovShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'GovShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Receiver_Governorate').empty();
                                $.each(data, function(key, value) {

                                    $('#Receiver_Governorate').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Receiver_Governorate").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });




            $("#Governrate").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "GovShippingFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {

                        $.ajax({
                            url: 'GovShippingFilterJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Governrate').empty();
                                $.each(data, function(key, value) {

                                    $('#Governrate').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Governrate").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });




            $('#Coin').select2({
                placeholder: "Select...",
                allowClear: true,
                ajax: {
                    // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
                    url: 'NewAllCoins',
                    dataType: 'json',
                    delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
                    data: function(params) {
                        // Select2 هيبعت كلمة البحث باسم 'term'
                        return {
                            term: params.term // ده الكلمة اللي بيكتبها المستخدم
                        };
                    },
                    processResults: function(data) {
                        // هنا Select2 بيستقبل البيانات من السيرفر
                        // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
                        var results = [];
                        $.each(data, function(key, value) {
                            results.push({
                                id: key, // الـ ID بتاع الحساب
                                text: value // الاسم بتاع الحساب
                            });
                        });

                        return {
                            results: results
                        };
                    },
                    cache: true
                }
            });

            $('#Safe').select2({
                placeholder: "Select...",
                allowClear: true,
                ajax: {
                    // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
                    url: 'NewAllSafesBanks',
                    dataType: 'json',
                    delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
                    data: function(params) {
                        // Select2 هيبعت كلمة البحث باسم 'term'
                        return {
                            term: params.term // ده الكلمة اللي بيكتبها المستخدم
                        };
                    },
                    processResults: function(data) {
                        // هنا Select2 بيستقبل البيانات من السيرفر
                        // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
                        var results = [];
                        $.each(data, function(key, value) {
                            results.push({
                                id: key, // الـ ID بتاع الحساب
                                text: value // الاسم بتاع الحساب
                            });
                        });

                        return {
                            results: results
                        };
                    },
                    cache: true
                }
            });


            $('#Store').select2({
                placeholder: "Select...",
                allowClear: true,
                ajax: {
                    // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
                    url: 'NewAllStores',
                    dataType: 'json',
                    delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
                    data: function(params) {
                        // Select2 هيبعت كلمة البحث باسم 'term'
                        return {
                            term: params.term // ده الكلمة اللي بيكتبها المستخدم
                        };
                    },
                    processResults: function(data) {
                        // هنا Select2 بيستقبل البيانات من السيرفر
                        // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
                        var results = [];
                        $.each(data, function(key, value) {
                            results.push({
                                id: key, // الـ ID بتاع الحساب
                                text: value // الاسم بتاع الحساب
                            });
                        });

                        return {
                            results: results
                        };
                    },
                    cache: true
                }
            });



        });
    });
</script>
<!--- Sender and Reciver  Data --->
<script>
    
    function SenderData() {

        var Sender = $('#Sender').val();


        $.ajax({
            url: 'SenderDataFilter',
            type: "GET",
            data: {
                Sender: Sender
            },
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {


                $('#Sender_Name').val(data.name);
                $('#Sender_Phone1').val(data.phone);
                $('#Sender_Phone2').val(data.phoneT);
                $('#Sender_Address').val(data.address);
                $('#Sender_Location').val(data.location);


                $('#Sender_Governorate').empty();
                $('#Sender_City').empty();
                $('#Sender_Place').empty();

                $('#Sender_Governorate').append('<option value="' + data.GovVal + '">' + data.GovName + '</option>');
                $('#Sender_City').append('<option value="' + data.CityVal + '">' + data.CityName + '</option>');
                $('#Sender_Place').append('<option value="' + data.PlaceVal + '">' + data.PlaceName + '</option>');


            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });


    }


    function ReciverData() {

        var Received = $('#Received').val();


        $.ajax({
            url: 'ReciverDataFilter',
            type: "GET",
            data: {
                Received: Received
            },
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {


                $('#Receiver_Name').val(data.name);
                $('#Receiver_Phone1').val(data.phone);
                $('#Receiver_Phone2').val(data.phoneT);
                $('#Receiver_Address').val(data.address);
                $('#Receiver_Location').val(data.location);


                $('#Receiver_Governorate').empty();
                $('#Receiver_City').empty();
                $('#Receiver_Place').empty();

                $('#Receiver_Governorate').append('<option value="' + data.GovVal + '">' + data.GovName + '</option>');
                $('#Receiver_City').append('<option value="' + data.CityVal + '">' + data.CityName + '</option>');
                $('#Receiver_Place').append('<option value="' + data.PlaceVal + '">' + data.PlaceName + '</option>');

                COST();

            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });


    }
</script>
<!-- Filter Governrate and City !-->
<script>
    
    $('#Sender_Governorate').on('change', function() {
        var countryId = $(this).val();
        if (countryId) {
            $.ajax({
                url: 'GovernrateFilterr/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {

                    $('#Sender_City').empty();

                    $.each(data, function(key, value) {

                        $('#Sender_City').append('<option value="' + key + '">' + value + '</option>');

                    });

                    var CIITY = $('#Sender_City').val();
                    $.ajax({
                        url: 'CityFilterr/' + CIITY,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function() {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function(data) {

                            $('#Sender_Place').empty();

                            $.each(data, function(key, value) {

                                $('#Sender_Place').append('<option value="' + key + '">' + value + '</option>');

                            });


                            COST();
                        },
                        complete: function() {
                            $('#loader').css("visibility", "hidden");
                        }
                    });



                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="states"]').empty();
        }

    });

    $('#Sender_City').on('change', function() {
        var CIITY = $('#Sender_City').val();
        $.ajax({
            url: 'CityFilterr/' + CIITY,
            type: "GET",
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {

                $('#Sender_Place').empty();

                $.each(data, function(key, value) {

                    $('#Sender_Place').append('<option value="' + key + '">' + value + '</option>');

                });

                COST();

            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });


    });

    $('#Receiver_Governorate').on('change', function() {
        var countryId = $(this).val();
        if (countryId) {
            $.ajax({
                url: 'GovernrateFilterr/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {

                    $('#Receiver_City').empty();

                    $.each(data, function(key, value) {

                        $('#Receiver_City').append('<option value="' + key + '">' + value + '</option>');

                    });

                    var CIITY = $('#Receiver_City').val();

                    $.ajax({
                        url: 'CityFilterr/' + CIITY,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function() {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function(data) {

                            $('#Receiver_Place').empty();

                            $.each(data, function(key, value) {

                                $('#Receiver_Place').append('<option value="' + key + '">' + value + '</option>');

                            });

                            COST();

                        },
                        complete: function() {
                            $('#loader').css("visibility", "hidden");
                        }
                    });

                    COST();


                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="states"]').empty();
        }

    });

    $('#Receiver_City').on('change', function() {
        var CIITY = $('#Receiver_City').val();
        $.ajax({
            url: 'CityFilterr/' + CIITY,
            type: "GET",
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {

                $('#Receiver_Place').empty();

                $.each(data, function(key, value) {

                    $('#Receiver_Place').append('<option value="' + key + '">' + value + '</option>');

                });

                COST();


            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });

        COST();

    });


    $('#Governrate').on('change', function() {
        var countryId = $(this).val();
        if (countryId) {
            $.ajax({
                url: 'GovernrateFilterr/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {

                    $('#City').empty();

                    $.each(data, function(key, value) {

                        $('#City').append('<option value="' + key + '">' + value + '</option>');

                    });

                    var CIITY = $('#City').val();

                    $.ajax({
                        url: 'CityFilterr/' + CIITY,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function() {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function(data) {

                            $('#Place').empty();

                            $.each(data, function(key, value) {

                                $('#Place').append('<option value="' + key + '">' + value + '</option>');

                            });

                            COST();


                        },
                        complete: function() {
                            $('#loader').css("visibility", "hidden");
                        }
                    });




                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="states"]').empty();
        }

    });

    $('#City').on('change', function() {
        var CIITY = $('#City').val();
        $.ajax({
            url: 'CityFilterr/' + CIITY,
            type: "GET",
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {

                $('#Place').empty();

                $.each(data, function(key, value) {

                    $('#Place').append('<option value="' + key + '">' + value + '</option>');

                });

                COST();


            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });



    });



    function COST() {

        var CIITY = $('#Receiver_City').val();
        var Weight = $('#Weight').val();
        var Shipment_Class = $('#Shipment_Class').val();
        var Sender_City = $('#Sender_City').val();


        $.ajax({
            url: 'CityCostShipping',
            type: "GET",
            data: {

                CIITY: CIITY,
                Weight: Weight,
                Shipment_Class: Shipment_Class,
                Sender_City: Sender_City,

            },
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {


                $('#Shipment_Cost').val(data.cost);
                $('#Delivery_Cost').val(data.delivery_cost);
                TOTAL();




            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });
        
        
        if(Shipment_Class == 'Stored'){
                document.getElementById('StoresPro').style.display='block';
           
           }else{
               
               document.getElementById('StoresPro').style.display='none';
           }

        
        


    }
</script>
<!-- Total -->
<script>
    
    function TOTAL() {

        var Shipment_Cost = $('#Shipment_Cost').val();
        var Goods_Cost = $('#Goods_Cost').val();
        var Delivery_Cost = $('#Delivery_Cost').val();
        var Overload_Weight_Cost = $('#Overload_Weight_Cost').val();
        var Collection_Commission = $('#Collection_Commission').val();
        var Delivery_Commission = $('#Delivery_Commission').val();
        var Return_Cost = $('#Return_Cost').val();
        var Payment_Method = $('#Payment_Method').val();
        var Total_Price = $('#Total_Price').val();

        


        var res = parseFloat(Shipment_Cost) + parseFloat(Goods_Cost) + parseFloat(Delivery_Cost) + parseFloat(Overload_Weight_Cost) + parseFloat(Delivery_Commission) + parseFloat(Return_Cost);

        $('#Total').val(parseInt(res).toFixed(2));


        if (Payment_Method == 'Later') {

            $('#Pay').val(0);

        }

        if (Payment_Method != 'Later') {

            $('#Pay').val(parseInt(res).toFixed(2));

        }


    }
</script>
<!-- New client -->
<script>
    
    function NewClients() {

        var Name = $('#Name').val();
        var Phone1 = $('#Phone1').val();
        var Phone2 = $('#Phone2').val();
        var Governrate = $('#Governrate').val();
        var City = $('#City').val();
        var Place = $('#Place').val();
        var Address = $('#Address').val();
        $.ajax({
            url: 'AddNewClientShipping',
            type: "GET",
            data: {

                Name: Name,
                Phone1: Phone1,
                Phone2: Phone2,
                Governrate: Governrate,
                City: City,
                Place: Place,
                Address: Address,
            },
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {


                alert('New Client Added Successful /  تم اضافة عميل جديد بنجاح');


            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });



    }
</script>


<!-- Status  Value  -->
<script>
    function ChangeStatus(val) {

        $("#Status").val(val);



    }
</script>


<!-- Search   -->



<!--  Filter Products -->
<script>
   $(document).ready(function(){
   
    fetch_customer_data();
   
    function fetch_customer_data(search = '',Sender='')
    {  
     $.ajax({
      url:'ShipmentProductsFilter',
      method:'GET',
      data:{search:search,Sender:Sender},
      dataType:'json',
      success:function(data)
      {
       $('.Data').html(data.table_data);
                  $("#Data").show();
      }
     })
    }
    
   $(document).on('keyup', '#search', function(){
     var search = $(this).val();     
     var Sender = $('#Sender').val();     
     fetch_customer_data(search,Sender);
    });
       
       
    $(document).on('change', '#Sender', function(){
     var Sender = $(this).val();     
     var search = $('#search').val();     
     fetch_customer_data(search,Sender);
    });
       
               
   });
</script>




<!-- Add Products -->
<script>
    
     function TotalFun(r) { 
     
     
      var AvQty = $("#AvQty"+r).val(); 
      var Qty = $("#Qty"+r).val(); 
      var Price = $("#Price"+r).val(); 
     
     
var res=parseFloat(Qty) * parseFloat(Price) ;
$("#Total"+r).val(parseFloat(res).toFixed(2)); 
        
         
    if(Qty != '' || Qty > 0 || Price != '' || Price > 0 ){         
       
        if(parseFloat(Qty) <= parseFloat(AvQty)){
   
      document.getElementById("AddBtnPur"+r).style.display = "block";           

           }else{
               
        document.getElementById("AddBtnPur"+r).style.display = "none";               
           } 
         
     }else{
         
       document.getElementById("AddBtnPur"+r).style.display = "none";      
         
     }

     
     }
    
    
   function Fun(r) { 
       
             var P_Ar_Name = $("#P_Ar_Name"+r).val();
             var P_En_Name= $("#P_En_Name"+r).val();
             var Product = $("#Product"+r).val();
             var UnitID = $("#UnitPurch"+r).val();
             var UnitName = $("#UnitPurchName"+r).val();
             var Qty = $("#Qty"+r).val();
             var Barcode = $("#CodePurch"+r).val();
             var StorePurch = $("#StorePurch"+r).val();
             var StorePurchName = $("#StorePurchName"+r).val();
             var AvQty = $("#AvQty"+r).val();
             var Qty = $("#Qty"+r).val();
             var Price = $("#Price"+r).val();
             var Total = $("#Total"+r).val();
             var VOne = $("#VOne"+r).val();
             var VTwo = $("#VTwo"+r).val();
             var V_Name = $("#V_Name"+r).val();
             var VV_Name = $("#VV_Name"+r).val();
       
           
             document.getElementById("AddBtnPur"+r).style.display = "none";
             document.getElementById("Row"+r).style.display = "none";
       
           var LANG = $("#LANG").val();
   if(LANG == 'ar' ){ 
          var Nemo = P_Ar_Name ;
          }else{
             var Nemo = P_En_Name ;   
          } 
       
             var markup = "<tr><td><input type='hidden' name='P_Ar_Name[]' value='"+P_Ar_Name+"'><input type='hidden' name='P_En_Name[]' value='"+P_En_Name+"'>" + Nemo + +V_Name+  +VV_Name+ "</td><td><input type='hidden' name='Unit[]' value='"+UnitID+"'>" + UnitName + "</td><td><input type='hidden' name='P_Code[]' value='"+Barcode+"'>" + Barcode + "</td><td><input  type='hidden' name='AvQty[]' value='"+AvQty+"'>" + AvQty + "</td><td><input class='Qun' type='hidden' name='Qty[]' value='"+Qty+"'>" + Qty + "</td><td><input  type='hidden'  name='Price[]' value='"+Price+"'>" + Price + "</td><td><input  type='hidden' name='Total[]' class='Tot' value='"+Total+"'>" + Total + "</td><td><button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input type='hidden' name='Product[]' value='"+Product+"'><input type='hidden' name='VOne[]' value='"+VOne+"'><input type='hidden' name='VTwo[]' value='"+VTwo+"'></td><input type='hidden' name='V_Name[]' value='"+V_Name+"'><input type='hidden' name='VV_Name[]' value='"+VV_Name+"'><input  type='hidden' name='StorePurch[]' value='"+StorePurch+"'></tr>";
   
            
             $("#data-dt").append(markup);
       $("#Data").hide();
      $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };
   
   var rowctr = $('#dt').rowCount();     
                
    var sumQ = 0;        
   $('.Qun').each(function(){
   sumQ += parseFloat($(this).val());
   });   
                   
    var sumTot = 0;        
   $('.Tot').each(function(){
   sumTot += parseFloat($(this).val());
   });   
            

   
   $('#Product_Numbers').val(parseFloat(rowctr));       
   $('#Total_Qty').val(parseFloat(sumQ));
   $('#Total_Price').val(parseFloat(sumTot));

       
       
       
  var Goods_Cost = $('#Goods_Cost').val();
  var Total_Price = $('#Total_Price').val();       
    var New = parseFloat(Goods_Cost) + parseFloat(Total_Price) ;
        $('#Goods_Cost').val(New);
           
       
  
    TOTAL();

        $('#data-dt').on('click', '#DelAssem', function(e){
                $(this).closest('tr').remove(); 
            
   
      $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };
   
   var rowctr = $('#dt').rowCount();     
                
    var sumQ = 0;        
   $('.Qun').each(function(){
   sumQ += parseFloat($(this).val());
   });   
                   
    var sumTot = 0;        
   $('.Tot').each(function(){
   sumTot += parseFloat($(this).val());
   });   
            

   
   $('#Product_Numbers').val(parseFloat(rowctr));       
   $('#Total_Qty').val(parseFloat(sumQ));
   $('#Total_Price').val(parseFloat(sumTot));
            
              
  var Goods_Cost = $('#Goods_Cost').val();
  var Total_Price = $('#Total_Price').val();       
    var New = parseFloat(Goods_Cost) + parseFloat(Total_Price) ;
        $('#Goods_Cost').val(New);
           
       
  
    TOTAL();


                    })  
       
       
     }    
</script> 



@endpush