<!doctype html>
@php
use App\Models\Shipping\ShipmentsDistributionWorkers;
use App\Models\Shipping\ShipmentsDistributionGoods;
@endphp
<html>
   <head>
      <meta charset="utf-8">
      <title>{{trans('admin.Shipment')}}</title>
      <meta http-equiv="cache-control" content="max-age=0"/>
      <meta http-equiv="cache-control" content="no-cache"/>
      <meta http-equiv="expires" content="0"/>
      <meta http-equiv="pragma" content="no-cache"/>
      <link rel="stylesheet" media="screen, print" href="{{asset('Admin/styles.css')}}">
      <style type="text/css" media="all">
         body {
         color: #000;
         text-align:right;
         direction:rtl!important;
          
         }
         .well{
         background-color:white;
         }
         td ,th{
         background: white!important;
              font-size: 9px;  
         }
         .table{
         margin-bottom:7px;
              font-size: 9px;  
         }
         .th-td-width th,.th-td-width td{
         padding:0!important;
              font-size: 9px;  
         }
         .alert{
         padding-bottom:0;
         margin-bottom:0;
         padding-top:0;
         margin-top:0;
         }
         .alert h1{
         margin:0;
         }
         #wrapper { max-width: 600px; margin: 0 auto; padding-top: 20px; }
         .btn { margin-bottom: 5px; }
         .table { border-radius: 3px; font-size: 9px;   }
         .table th { background: #f5f5f5; font-size: 9px;   }
         .table th, .table td { vertical-align: middle !important; font-size: 9px;   }
         h3 { margin: 5px 0; }
         .table-bordered{
         border: 1px solid #746f6f;
         }
         .table-bordered>thead>tr>th ,.table-bordered>tbody>tr>td {
         border: 1px solid #746f6f;
         }
         .col-lg-6,.col-lg-12, .col-xs-6{
         float:right;
         }
         @media print {
         .no-print { display: none; }
         #buttons { display: none; }
         #wrapper { max-width: 480px; width: 100%; min-width: 250px; margin: 0 auto; }
         }
         .text-right { text-align: left; }
         .text-left { text-align: right; }
         tfoot tr th:first-child { text-align: left; }
      </style>
   </head>

   <body>


      <div>
         <div id="receiptData" style="width: auto; max-width: 600px; min-width: 250px; margin: 0 auto;overflow: hidden;">
            <div class="no-print" >
               <div style="text-align:center;" class="alert">
                  <button data-dismiss="alert" class="close" type="button"></button>
                  @if(!empty($Def->Name_Sales_Bill))
                  <h1 style="font-weight: 900;color: black">    {{app()->getLocale() == 'ar' ?$Def->Name_Sales_Bill :$Def->Name_Sales_Bill_En}}     </h1>
                  @else
                  <h1>{{trans('admin.Shipment')}}</h1>
                  @endif
               </div>
            </div>
            <div id="receipt-data">
               <div>
                  <div style="text-align:center;margin-bottom:10px;">
                     @if(!empty($Def->Logo))
                     <img style="text-align:center;  height: 60px;"  src="{{URL::to($Def->Logo)}}" alt="Logo" />
                     @else
                     <img style="text-align:center; height: 60px;"  src="{{asset('Admin/img/theme/logo.png')}}" alt="Logo" />
                     @endif
                  </div>
                   <table style="border-style: solid;" class="table table-bordered table-striped table-condensed text-center">
                       <tr>
                           <td style="padding: 0;">{{$Def->Phone1}}</td>
                           <td style="padding: 0;">{{$Def->Phone2}}</td>
                       </tr>
                       <tr>
                           <td style="padding: 0;">{{$Def->Phone3}}</td>
                           <td style="padding: 0;">{{$Def->Phone4}}</td>
                       </tr>
                       </table>
                  <div class="row">
              <div style="font-weight: 500;color: black;font-size: 11px;" class="col-lg-2 col-xs-3 text-center">
                        <!--{{trans('admin.Code')}}  :- {{$item->Code}}   -->
                       <span style="border: 1px solid black;border-radius: 4px;padding:3px;"> {{$item->Code}} </span>
                     </div>
 
       <div style="font-weight: 500;color: black;font-size: 11px;" class="col-lg-2 col-xs-3 text-center">
                        <!--{{trans('admin.Code')}}  :- {{$item->Code}}   -->
                       <span style="border: 1px solid black;border-radius: 4px;padding:3px;"> 
           
           
                @if(!empty($item->FromStore()->first()->Name))

                                                {{$item->FromStore()->first()->Name}}

                                            @endif

           
           </span>
                     </div>
 
       <div style="font-weight: 500;color: black;font-size: 11px;" class="col-lg-2 col-xs-3 text-center">
                        <!--{{trans('admin.Code')}}  :- {{$item->Code}}   -->
                       <span style="border: 1px solid black;border-radius: 4px;padding:3px;"> 
           
           
               =>       @if(!empty($item->ToStore()->first()->Name))

                                                {{$item->ToStore()->first()->Name}}

                                            @endif


           
           </span>
                     </div>
 

                     <div style="font-weight: 500;color: black;font-size: 11px;" class="col-lg-4 col-xs-4">
                         {{$item->Date}}
                     </div>
                     <div style="font-weight: 500;color: black;font-size: 11px;" class="col-lg-4 col-xs-4">
                         {{$item->Time}}
                     </div>
                  </div>
            
           
                  <div style="clear:both;margin-top:8px;"></div>
    
                  
      @php  $WORKERS=ShipmentsDistributionWorkers::where('ShipmentsDistribution',$item->id)->get(); @endphp 
    @php  $Goods=ShipmentsDistributionGoods::where('ShipmentsDistribution',$item->id)->get(); @endphp 
                   
                  <table style="border-style: double;font-size: 20px;font-weight: bold;"class="table table-bordered table-striped table-condensed">
                     <tbody>
                    

                         
                               <tr>

                           <td class="text-center"> {{trans('admin.Car')}} </td>
                           <td class="text-center">  
                                   
               @if(!empty($item->Car()->first()->Name))

                                                {{$item->Car()->first()->Name}}

                                            @endif


                         </td>
                                   
                                   
                                   
                                          <td class="text-center"> {{trans('admin.Delegate')}} </td>
                           <td class="text-center"> 
                     @if(!empty($item->Delegate()->first()->Name))

                                                {{$item->Delegate()->first()->Name}}

                                            @endif


                         </td>
                                        
                                   
                                          <td class="text-center"> {{trans('admin.Driver')}} </td>
                           <td class="text-center"> 
                          @if(!empty($item->Driver()->first()->Name))

                                                {{$item->Driver()->first()->Name}}

                                            @endif
   
                         </td>
                                     
                         </tr>
                      
                         

                         
                         
 
              
      

                                
     
          
                         
                      

                          
                           </tbody>
                  </table>
                    
                  
                   
                                <div class="col-md-12 col-12">
                                    <h5> {{trans('admin.Workers')}} </h5>
                                </div>


                  <table style="border-style: double;font-size: 20px;font-weight: bold;"class="table table-bordered table-striped table-condensed">
                    
                              <thead>
                                                            <tr>
                                                                <th   class="border-top-0 table-scale-border-bottom fw-700 no-print"> {{trans('admin.Worker')}}</th>
                                                     
                                                            </tr>
                                                        </thead>
                
   <tbody>
                                          
                                                            
                            @foreach($WORKERS as $work)
                                        <tr>
                                           
                                            <td>
                                                @if(!empty($work->Worker()->first()->Name))

                                                    {{$work->Worker()->first()->Name}}

                                                @endif


                                            </td>
                                          



                                        </tr>
                                        @endforeach          
                                                            
                                                            
                                                        </tbody>
                      
                  </table>
                   
                   
                          
                   
                            

                  <table style="border-style: double;font-size: 20px;font-weight: bold;"class="table table-bordered table-striped table-condensed">
                  
                              <thead>
                                                            <tr>
                                                                <th> {{trans('admin.Shipping_Code')}}</th>
                                                                <th> {{trans('admin.Shipping_Barcode')}}</th>
                                                                <th> {{trans('admin.Shipping_Piecses')}}</th>
                                                                <th> {{trans('admin.Shipping_Weight')}}</th>
                                                                <th> {{trans('admin.Sender_Name')}}</th>
                                                                <th> {{trans('admin.Receiver_Name')}}</th>
                                                                <th> {{trans('admin.Shipping_Cost')}}</th>
                                                     
                                                            </tr>
                                                        </thead>
                
             <tbody>
                                          
                                         @foreach($Goods as $good)
                                        <tr>
                                           <td>{{$good->Code}}</td>
                                           <td>{{$good->Barcode}}</td>
                                           <td>{{$good->Total_Pieces}}</td>
                                           <td>{{$good->Total_Weight}}</td>
                                           <td>{{$good->Shipment_ID()->first()->Sender_Name}}</td>
                                           <td>{{$good->Shipment_ID()->first()->Receiver_Name}}</td>
                                            <td>{{$good->Total_Cost}}</td>
    
                                        </tr>
                                        @endforeach
             
                                                            
                                                        </tbody>
                      
                      
                  </table>
                   
                   
                   
                   
                   
                   
                   
                  <table style="border-style: double;font-size: 20px;font-weight: bold;"class="table table-bordered  table-striped table-condensed">
                     <tbody>
                         
                               <tr>
                          <td class="text-center"> {{trans('admin.Total_Pieces')}} </td>
                          <td class="text-center">{{number_format((float)$item->Total_Pieces, 2, '.', '')}}  </td>
                                   
                                   
                          <td class="text-center"> {{trans('admin.Total_Weight')}} </td>
                          <td class="text-center">{{number_format((float)$item->Total_Weight, 2, '.', '')}}  </td>
                                        
                      

                         </tr>
                    
                               <tr>
                          <td class="text-center"> {{trans('admin.Total_Cost')}} </td>
                          <td class="text-center">{{number_format((float)$item->Total_Cost, 2, '.', '')}}  </td>
                                   
                                   
                          <td class="text-center"> {{trans('admin.Count_Shipmets')}} </td>
                          <td class="text-center">{{number_format((float)$item->Count_Shipmets, 2, '.', '')}}  </td>
                                        
                      

                         </tr>

                     </tbody>
                  </table>
                   
                   
                  
  
               
                  <div >
                      
               
                      
                     <div style="text-align: center;">
                         <h5>{{$item->Barcode}}</h5>
                        @php
                        $x=$item->Barcode;
                        $y=DNS1D::getBarcodePNG($x, 'C39');
                        @endphp
                        <img src="data:image/png;base64,{{$y}}" id="barcode"  class="height-3 mt-1" />
                     </div>
                  </div>
               </div>
               <div style="clear:both;"></div>
            </div>
      
                <div class="well well-sm"  style="margin:7px 0;">
                     <div style="text-align: center;font-weight: 900;font-size: 12px;">  
                         @if(!empty($Def->Print_Text))
                        {{$Def->Print_Text}}
                        @endif
                     </div>
                  </div>
 

            <!-- start -->
            <div  class="no-print row">
             
        <a href="{{ url()->previous() }}" class="btn btn-block btn-default">{{trans('admin.Back')}}</a>
              
          <button onclick="window.print();" class="btn btn-block btn-primary">{{trans('admin.Print')}}</button>
           


      
            </div>
            <!-- end -->
         </div>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.5.3/jspdf.debug.js" integrity="sha384-NaWTHo/8YCBYJ59830LTz/P4aQZK1sS0SneOgAvhsIl3zBu8r9RevNg5lHCHAuQ/" crossorigin="anonymous"></script>

<script src="https://unpkg.com/jspdf@latest/dist/jspdf.min.js"></script>


              <script>

             function x(){
             var doc = new jsPDF();
var elementhtml = document.querySelector("#wrapper").innerHTML;

var specialElementHandlers = {
    '#editor': function (element, renderer) {
        return true;
    }
};

    doc.fromHTML(
        elementhtml,
            15,
            15,
            {
            'width':170,
            'elementHandlers':specialElementHandlers
        }
               );


    doc.save('Bill.pdf');


             }
          </script>

           <script>
 function PRINTT(r){
window.POST_ID.postMessage(r);

 }
  </script>
          

                   <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
        <script src="{{asset('Admin/js/vendors.bundle.js')}}"></script>
        <script src="{{asset('Admin/js/app.bundle.js')}}"></script>
        <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>

      <script type="text/javascript">
        function disableBack() { window.history.forward(); }
        setTimeout("disableBack()", 0);
        window.onunload = function () { null };
    </script>

      </div>
      <!-- start -->
      <!-- end -->
       </div>
   </body>
</html>
