@extends('admin.index')
@section('content')

    <title>{{trans('admin.UnloadingShipments')}}</title>
    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Shipping')}}</a></li>

            <li class="breadcrumb-item active"> {{trans('admin.UnloadingShipments')}}   </li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <!-- data entry -->
        <div class="row">
            <div class="col-lg-12">
                <div id="panel-2" class="panel">
                    <div class="panel-hdr">

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" data-toggle="tab" href="#tab_borders_icons-8" role="tab">   {{trans('admin.UnloadingShipments')}}  </a>
                                </li>
                            </ul>
                            <div class="tab-content border border-top-0 p-3">
                                <div class="tab-pane fade show active" id="tab_borders_icons-8" role="tabpanel">

                                    <form action="{{url('PostEditUnloadingShipments')}}" method="post" enctype="multipart/form-data" class="form-row">
                                        {!! csrf_field() !!}
                                        @honeypot
                                        
                                                   <input type="hidden" name="ID" value="{{$item->id}}">
                                        <div class="col-md-12">
                                            <div class="data-def">
                                                <div class="form-row">




                                                      <div class="form-group col-lg-3">
                                                          <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                                          <input type="text" value="{{$item->Code}}"  name="CodeX"  class="form-control " readonly>
                                                      </div>

                                                          <div class="form-group col-lg-3">
                                                              <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                                              <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                                                          </div>



                                                           <div class="form-group col-lg-3" >
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Car')}}</label>
                                                        <select class="select2 form-control" name="Car" id="Car" required >
                                                                                                
                                                            @if(!empty($item->Car()->first()->Name))


                                                                <option value="{{$item->Car}}" selected>
                                                                        {{$item->Car()->first()->Name}}

                                                                </option>

                                                            @endif
                                  
                                                        </select>
                                                    </div>

                                              

                                                                        <div class="form-group col-lg-3">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Code')}}=>{{trans('admin.ShipmentsDistribution')}}</label>
                                    <select class="select2 form-control" name="ShipmentsDistributionCode" id="ShipmentsDistributionCode" required>
                                                              <option value="{{$item->ShipmentsDistributionCode}}">{{$item->ShipmentsDistributionCode}}</option>        
                                                                   
                                                                   </select>
                                                    </div>

                                                        
                                                    
                                                    <div class="form-group col-lg-3">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.FromStore')}}</label>
                                                      <select class="select2 form-control"  id="store" disabled>
                                                                           @if(!empty($item->FromStore()->first()->Name))


                                                                <option value="{{$item->FromStore}}">
                                                                        {{$item->FromStore()->first()->Name}}

                                                                </option>

                                                            @endif
                                  
                                                      </select>
                                                        <input type="hidden" name="FromStore" id="FromStore" value="{{$item->FromStore}}">
                                                    </div>

                                                    
                                                    <div class="form-group col-lg-3">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.ToStore')}}</label>
                                                      <select class="select2 form-control" name="ToStore" id="ToStore" required>
                                                              @if(!empty($item->ToStore()->first()->Name))


                                                                <option value="{{$item->ToStore}}">
                                                                        {{$item->ToStore()->first()->Name}}

                                                                </option>

                                                            @endif
                                  
                                  
                                                      </select>
                                                    </div>



                                                    
                                                    <div class="form-group col-lg-4" style="display: none" >
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Safe')}}</label>
                                                        <select class="select2 form-control" name="Safe" id="Safe"  >
                                                                
                                                                      
                                                            @if(!empty($item->Safe()->first()->Name))


                                                                <option value="{{$item->Safe}}" selected>
                                                                        {{$item->Safe()->first()->Name}}

                                                                </option>

                                                            @endif
                                  
                                                          
                                                        </select>
                                                    </div>
           
                                                    
                                                    <div class="form-group col-lg-4" style="display: none" >
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Coin')}}</label>
                                                        <select class="select2 form-control" name="Coin" id="Coin"  >
                                                                
                                                                  @if(!empty($item->Coin()->first()->Arabic_Name))


                                                                <option value="{{$item->Coin}}" selected>
                                                                        {{$item->Coin()->first()->Arabic_Name}}

                                                                </option>

                                                            @endif
                                  
                                                        </select>
                                                    </div>
                                                    
                                                            <div class="form-group col-lg-4" style="display: none">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                                        <input type="number" step="any"  name="Draw" value="{{$item->Draw}}" class="form-control" >
                                                    </div>

                                                    
                                             
      
                                                    <div class="form-group col-lg-3" >
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Delegate')}}</label>
                                                        <select class="select2 form-control"  id="Delegate" disabled >
                                                                   @if(!empty($item->Delegate()->first()->Name))


                                                                <option value="{{$item->Delegate}}" selected>
                                                                        {{$item->Delegate()->first()->Name}}

                                                                </option>

                                                            @endif
                                  
                                                        </select>
                                                             <input type="hidden" name="Delegate" id="DelegateHide" value="{{$item->Delegate}}">
                                                    </div>


                                                    <div class="form-group col-lg-3">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Driver')}}</label>
                                                        <select class="select2 form-control"  id="Driver" disabled >
                                                                                 @if(!empty($item->Driver()->first()->Name))


                                                                <option value="{{$item->Driver}}" selected>
                                                                        {{$item->Driver()->first()->Name}}

                                                                </option>

                                                            @endif
                                  


                                                        </select>
                                                             <input type="hidden" name="Driver" id="DriverHide" value="{{$item->Driver}}">
                                                    </div>



                                                    <div class="form-group col-lg-12">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Workers')}}</label>
                                                        <select class="select2 form-control" name="Workers[]" id="Workers" multiple  >
                                                          
                                                    @foreach($WORKERS as $work)
                                                                    @if(!empty($work->Worker()->first()->Name))

                                       
                                                                  <option value="{{$work->Worker}}" selected>
                                                                        {{$work->Worker()->first()->Name}}

                                                                </option>
                                                            
                                                            @endif


                                                    @endforeach



                                                        </select>
                                                    </div>


             <div class="col-md-12" style="border: 1px solid black; padding: 5px; background-color: white;margin-bottom: 10px">
                    <div class="row"> 
                            <div class="form-group col-lg-12">
                                <label class="form-label" for="simpleinput">  </label>
                                <div class="input-items" style="position:relative;">
                 <input type="text" id="search" class="form-control" placeholder="{{trans('admin.Search')}}">
                     @if(app()->getLocale() == 'ar' )
                     <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;left:3px;"></i>
                      @else
                            <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;right: 0;left:auto;"></i>
                      @endif
                                </div>
                             </div>
                            </div>
                                                    <div class="panel-container show">
                                <div class="panel-content">
                                      <div id="mobile-overflow">
                                    <table 
                                    class="table table-bordered table-hover table-striped table-color1 w-100 mobile-width-more">
                                    <thead>
                                        <tr>
                                            <th>{{trans('admin.Shipping_Code')}}</th>
                                            <th>{{trans('admin.Shipping_Barcode')}}</th>
                                            <th>{{trans('admin.Shipping_Piecses')}}</th>
                                            <th>{{trans('admin.Shipping_Weight')}}</th>
                                            <th>{{trans('admin.Sender_Name')}}</th>
                                            <th>{{trans('admin.Receiver_Name')}}</th>
                                            <th>{{trans('admin.Shipping_Cost')}}</th>
                                            <th>{{trans('admin.Actions')}}</th>
                                        </tr>
                                    </thead>
                                    <tbody class="Data" id="Data">

                                    </tbody>
                                    </table>
                                    </div>
                                    <!-- datatable start -->
                                      <div id="mobile-overflow">
                                    <table id="dt"
                                        class="table table-bordered table-hover table-striped table-color2 w-100 mobile-width-more">
                                        <thead>
                                            <tr>
                                            <th>{{trans('admin.Shipping_Code')}}</th>
                                            <th>{{trans('admin.Shipping_Barcode')}}</th>
                                            <th>{{trans('admin.Shipping_Piecses')}}</th>
                                            <th>{{trans('admin.Shipping_Weight')}}</th>
                                            <th>{{trans('admin.Sender_Name')}}</th>
                                            <th>{{trans('admin.Receiver_Name')}}</th>
                                            <th>{{trans('admin.Shipping_Cost')}}</th>
                                            <th>{{trans('admin.Actions')}}</th>
                                            </tr>
                                        </thead>
                                        <tbody id="data-dt">
                                            
                                            
                                                          @foreach($Goods as $good)
   
    
                                            <tr>
                                                <td>
                                                    <input type='hidden' name='Code[]' id='Coded{{$good->Shipment_ID}}' value='{{$good->Code}}'>{{$good->Code}}
                                                </td>
                                                <td><input type='hidden' name='Barcode[]' value='{{$good->Barcode}}'>{{$good->Barcode}}</td>
                                                <td><input type='hidden' class='Pie' name='Total_Pieces[]' value='{{$good->Total_Pieces}}'>{{$good->Total_Pieces}}</td>
                                                <td><input class='Wei' type='hidden' name='Total_Weight[]' value='{{$good->Total_Weight}}'>{{$good->Total_Weight}}</td>
                                                <td><input  type='hidden' name='Sender_Name[]' value='{{$good->Shipment_ID()->first()->Sender_Name}}'>
                                                    {{$good->Shipment_ID()->first()->Sender_Name}}
                                                </td>
                                                <td><input  type='hidden' name='Receiver_Name[]' value='{{$good->Shipment_ID()->first()->Receiver_Name}}'>
                                                
                                                {{$good->Shipment_ID()->first()->Receiver_Name}}
                                                </td>
                                                <td><input  type='hidden' class='Tot' name='Total_Cost[]' value='{{$good->Total_Cost}}'>{{$good->Total_Cost}}</td>
                                                <td>
                                                    <button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button>
                                                    <input  type='hidden' name='Shipment_ID[]' value='{{$good->Shipment_ID}}'>
                                                    <input  type='hidden' name='Dist_Goods_ID[]' value='{{$good->Dist_Goods_ID}}'>
                                                </td>
                                            </tr>
                                            
                                            @endforeach
                                         
                                            
                                         
                                           
                                        </tbody>

                                    </table>
                                    </div>
                                    <!-- datatable end -->
                      
                
                                </div>
                            </div>
                                                    
                                                    </div>
                                                    
                                              

                                                    <!-- Totals -->


                                                    <div class="form-group col-lg-3">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Count_Shipmets')}}</label>
                                                        <input type="number" step="any"  name="Count_Shipmets" value="0" id="Count_Shipmets" class="form-control" readonly>
                                                    </div>



                                                    <div class="form-group col-lg-3">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Total_Pieces')}}</label>
                                                        <input type="number" step="any"  name="Total_PiecesX" value="0" id="Total_PiecesX" class="form-control" readonly>
                                                    </div>



                                                    <div class="form-group col-lg-3">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Total_Weight')}}</label>
                                                        <input type="number" step="any"  name="Total_WeightX" value="0" id="Total_WeightX" class="form-control" readonly>
                                                    </div>



                                                    <div class="form-group col-lg-3">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Total_Cost')}}</label>
                                                        <input type="number" step="any"  name="Total_CostX" value="0"  id="Total_CostX" class="form-control" readonly>
                                                    </div>

                                                


                                                </div>
                                            </div>
                                        </div>
                                         <div class="buttons mt-3" id="Submit" style="display: none">
                          <input type="hidden" id="Status" name="Status" value="0">                 
            <button type="button"  class="btn btn-primary" data-toggle="modal" data-target="#Save" onclick="ChangeStatus(1)" > <i class="fal fa-folder"></i> {{trans('admin.Save')}} </button>
   
                                        
          <!-- Modal Submit -->
            <div class="modal fade" id="Save" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Submit')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                            <button type="submit" class="btn btn-primary" > {{trans('admin.Yes')}}</button>
                         
                        </div>
                    </div>
                </div>
            </div>

                                      </div>
                                        
                      
                                    </form>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </main>

    <style>
        .BORDER{

            border-bottom: 3px solid black;
            margin-bottom: 50px;
            margin-top: 50px;

        }



    </style>

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


    <!-- Search Select -->
    <script>
        $(document).ready(function () {
            $(function () {
                $(".select2").select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State",
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0,
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items",
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true,
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm;
                    },
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
                }

                $("#Delegate").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "DelegatesShippingFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {

                            $.ajax({
                                url: 'DelegatesShippingFilterJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#Delegate').empty();
                                    $.each(data, function(key, value){

                                        $('#Delegate').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $("#Delegate").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });


                $("#Driver").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "DriversShippingFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {

                            $.ajax({
                                url: 'DriversShippingFilterJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#Driver').empty();
                                    $.each(data, function(key, value){

                                        $('#Driver').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $("#Driver").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });


                
         $('#Car').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllShippingCars',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                 
     
     $('#Workers').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllWorkersEmployees',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
 
           $('#Coin').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllCoins',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});
                
     $('#Safe').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllSafesBanks',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});

                
     $('#store').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllStores',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});

                 
     $('#ToStore').select2({
    placeholder: "Select...",
    allowClear: true,
    ajax: {
        // هنا بيتم تحديد الـ URL اللي بيستقبل طلبات البحث
        url: 'NewAllStores',
        dataType: 'json',
        delay: 250, // تأخير بسيط لتقليل عدد الطلبات للسيرفر
        data: function(params) {
            // Select2 هيبعت كلمة البحث باسم 'term'
            return {
                term: params.term // ده الكلمة اللي بيكتبها المستخدم
            };
        },
        processResults: function(data) {
            // هنا Select2 بيستقبل البيانات من السيرفر
            // وبيحولها للصيغة المطلوبة منه وهي مصفوفة من الكائنات
            var results = [];
            $.each(data, function(key, value) {
                results.push({
                    id: key, // الـ ID بتاع الحساب
                    text: value // الاسم بتاع الحساب
                });
            });

            return {
                results: results
            };
        },
        cache: true
    }
});

 

            });
        });
    </script>




<!--  Filter Shipments -->
<script>
   $(document).ready(function(){
   
    fetch_customer_data();
   
    function fetch_customer_data(search = '',Car='',ShipmentsDistributionCode='')
    {  
     $.ajax({
      url:'UnloadingShipmentsFilter',
      method:'GET',
      data:{search:search,Car:Car,ShipmentsDistributionCode:ShipmentsDistributionCode},
      dataType:'json',
      success:function(data)
      {
       $('.Data').html(data.table_data);
                  $("#Data").show();
          

             $('#store').empty();
$('#store').append('<option value="'+ data.FromStoreID +'">' + data.FromStoreValue + '</option>');
   
             $('#ToStore').empty();
$('#ToStore').append('<option value="'+ data.ToStoreID +'">' + data.ToStoreValue + '</option>');
          
             $('#Driver').empty();
$('#Driver').append('<option value="'+ data.DriverID +'">' + data.DriverValue + '</option>');
             
             $('#Delegate').empty();
$('#Delegate').append('<option value="'+ data.DelegateID +'">' + data.DelegateValue + '</option>');
      
         
          
            $("#FromStore").val(data.FromStoreID);      
            $("#DelegateHide").val(data.DelegateID);      
            $("#DriverHide").val(data.DriverID);      
          
     
          
      }
     })
    }
    
   $(document).on('keyup', '#search', function(){
     var search = $(this).val();     
     var Car = $('#Car').val();     
     var ShipmentsDistributionCode = $('#ShipmentsDistributionCode').val();     
     fetch_customer_data(search,Car,ShipmentsDistributionCode);
    });
       
       
    $(document).on('change', '#Car', function(){
     var Car = $(this).val();     
     var search = $('#search').val();     
    $.ajax({
      url:'ShipmentsDistributionCodeFilter',
      method:'GET',
      data:{Car:Car},
      dataType:'json',
      success:function(data)
      {

          
                 $('#ShipmentsDistributionCode').empty();

                    $('#ShipmentsDistributionCode').append('<option value="">Choice Code</option>');  
                $.each(data, function(key, value) {

                    $('#ShipmentsDistributionCode').append('<option value="' + key + '">' + value + '</option>');

                });

  
     
          
      }
     })    
    var ShipmentsDistributionCode = $('#ShipmentsDistributionCode').val();    
        
     fetch_customer_data(search,Car,ShipmentsDistributionCode);
    });
         
    $(document).on('change', '#ShipmentsDistributionCode', function(){
     var ShipmentsDistributionCode = $(this).val();     
     var search = $('#search').val();     
     var Car = $('#Car').val();     
     fetch_customer_data(search,Car,ShipmentsDistributionCode);
    });
       
               
 
               
   });
</script>



<!-- Add Shipment -->
<script>
   function Fun(r) { 
       
             var Code = $("#Code"+r).val();
             var Barcode= $("#Barcode"+r).val();
             var Pieces_Num = $("#Pieces_Num"+r).val();
             var Weight = $("#Weight"+r).val();
             var Sender_Name = $("#Sender_Name"+r).val();
             var Receiver_Name = $("#Receiver_Name"+r).val();
             var Total = $("#Total"+r).val();
             var Shipment_ID = $("#Shipment_ID"+r).val();
             var Dist_Goods_ID = $("#Dist_Goods_ID"+r).val();
         
       

             var markup = "<tr><td><input type='hidden' name='Code[]' id='Coded"+r+"' value='"+Code+"'>" + Code + "</td><td><input type='hidden' name='Barcode[]' value='"+Barcode+"'>" + Barcode + "</td><td><input type='hidden' class='Pie' name='Total_Pieces[]' value='"+Pieces_Num+"'>" + Pieces_Num + "</td><td><input class='Wei' type='hidden' name='Total_Weight[]' value='"+Weight+"'>" + Weight + "</td><td><input  type='hidden' name='Sender_Name[]' value='"+Sender_Name+"'>" + Sender_Name + "</td><td><input  type='hidden' name='Receiver_Name[]' value='"+Receiver_Name+"'>" + Receiver_Name + "</td><td><input  type='hidden' class='Tot' name='Total_Cost[]' value='"+Total+"'>" + Total + "</td><td><button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input  type='hidden' name='Shipment_ID[]' value='"+Shipment_ID+"'><input  type='hidden' name='Dist_Goods_ID[]' value='"+Dist_Goods_ID+"'></tr>";
   

       
      var Coded = $("#Coded"+r).val();
       
       if(Coded != Code){
       $("#data-dt").append(markup);
   }
       
             $("#Row"+r).hide();

      $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };
   
   var rowctr = $('#dt').rowCount();     
                
    var SumPie = 0;        
   $('.Pie').each(function(){
   SumPie += parseFloat($(this).val());
   });   
                     
    var SumWei = 0;        
   $('.Wei').each(function(){
   SumWei += parseFloat($(this).val());
   });   
                     
    var SumTot = 0;        
   $('.Tot').each(function(){
   SumTot += parseFloat($(this).val());
   });   
            

   $('#Count_Shipmets').val(parseFloat(rowctr));
   $('#Total_PiecesX').val(parseFloat(SumPie));
   $('#Total_WeightX').val(parseFloat(SumWei));
   $('#Total_CostX').val(parseFloat(SumTot));

       

       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }


       
        $('#data-dt').on('click', '#DelAssem', function(e){
                $(this).closest('tr').remove(); 
            
   
                   $("#Data").hide();
      $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };
   
   var rowctr = $('#dt').rowCount();     
                
    var SumPie = 0;        
   $('.Pie').each(function(){
   SumPie += parseFloat($(this).val());
   });   
                     
    var SumWei = 0;        
   $('.Wei').each(function(){
   SumWei += parseFloat($(this).val());
   });   
                     
    var SumTot = 0;        
   $('.Tot').each(function(){
   SumTot += parseFloat($(this).val());
   });   
            

   $('#Count_Shipmets').val(parseFloat(rowctr));
   $('#Total_PiecesX').val(parseFloat(SumPie));
   $('#Total_WeightX').val(parseFloat(SumWei));
   $('#Total_CostX').val(parseFloat(SumTot));

            
                   

       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }

   

                    })  
       
       
     }    
</script> 





<!-- Status  Value  -->
<script>

function ChangeStatus(val){
    
   $("#Status").val(val); 
    
    
    
}
</script>


<script>
     $(document).ready(function () {
         
            $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };
   
   var rowctr = $('#dt').rowCount();     
                
    var SumPie = 0;        
   $('.Pie').each(function(){
   SumPie += parseFloat($(this).val());
   });   
                     
    var SumWei = 0;        
   $('.Wei').each(function(){
   SumWei += parseFloat($(this).val());
   });   
                     
    var SumTot = 0;        
   $('.Tot').each(function(){
   SumTot += parseFloat($(this).val());
   });   
            

   $('#Count_Shipmets').val(parseFloat(rowctr));
   $('#Total_PiecesX').val(parseFloat(SumPie));
   $('#Total_WeightX').val(parseFloat(SumWei));
   $('#Total_CostX').val(parseFloat(SumTot));
 
      if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }

       
       
         
         
     });

</script>

@endpush

