@extends('admin.index')
@section('content')

    <title>{{trans('admin.CarShipping')}}</title>

    <main id="js-page-content" role="main" class="page-content">

        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Shipping')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.CarShipping')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>{{trans('admin.CarShipping')}}</i></span>
                        </h2>

                        <div class="panel-toolbar">


                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg">{{trans('admin.AddNew')}}</button>


                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <div id="mobile-overflow">
                                <table id="dt-basic-example"
                                       class="table table-bordered table-hover table-striped w-100 mobile-width">
                                    <thead class="bg-highlight">
                                    <tr>
                                        <th>{{trans('admin.Name')}}</th>
                                        <th>{{trans('admin.Max_Load')}}</th>
                                                <th>{{trans('admin.Minimum')}}</th>
                                        <th>{{trans('admin.Delegate')}}</th>
                                        <th>{{trans('admin.Driver')}}</th>
                                        <th>{{trans('admin.Car_Number')}}</th>
                                        <th>{{trans('admin.Color')}}</th>
                                        <th>{{trans('admin.Lisence_Expire_Date')}}</th>
                                        <th>{{trans('admin.GPS_Num')}}</th>
                                        <th>{{trans('admin.Car_Type')}}</th>
                                        <th>{{trans('admin.Car_Statue')}}</th>
                                        <th>{{trans('admin.Insurance')}}</th>
                                        <th>{{trans('admin.Ownership')}}</th>
                                
                                        <th>{{trans('admin.Actions')}}</th>

                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach($items as $item)
                                        <tr>
                                            <td>{{$item->Name}}</td>
                                            <td>{{$item->Max_Load}}</td>
                                            <td>{{$item->Minimum}}</td>
                                            
                                            <td>
                                            
                                            @if(!empty($item->Delegate()->first()->Name))
                                                {{$item->Delegate()->first()->Name}}
                                            @endif
                                            
                                            </td>
                                            <td>
                                            
                                                @if(!empty($item->Driver()->first()->Name))
                                                {{$item->Driver()->first()->Name}}
                                            @endif
                                           
                                            
                                            </td>
                                            
                                            
                                            <td>{{$item->Car_Number}}</td>
                                            <td>
                                            <input type="color" class="form-control" value="{{$item->Color}}" readonly>
                                            </td>
                                            <td>{{$item->Lisence_Expire_Date}}</td>
                                            <td>{{$item->GPS_Num}}</td>
                                            
                                            <td>
                                                
                                            @if($item->Car_Type == 'LightPickupTruck')
                                            {{trans('admin.LightPickupTruck')}}
                                            @elseif($item->Car_Type == 'SmallCargoVan')
                                            {{trans('admin.SmallCargoVan')}}
                                            @elseif($item->Car_Type == 'Lorry')
                                            {{trans('admin.Lorry')}}
                                            @elseif($item->Car_Type == 'BoxTruck')
                                            {{trans('admin.BoxTruck')}}
                                            @elseif($item->Car_Type == 'ReeferTruck')
                                            {{trans('admin.ReeferTruck')}}
                                            @elseif($item->Car_Type == 'DumpTruck')
                                            {{trans('admin.DumpTruck')}}
                                            @elseif($item->Car_Type == 'TankLorry')
                                            {{trans('admin.TankLorry')}}
                                            @elseif($item->Car_Type == 'FlatbedTruck')
                                            {{trans('admin.FlatbedTruck')}}
                                            @elseif($item->Car_Type == 'CurtainsideTruck')
                                            {{trans('admin.CurtainsideTruck')}}
                                            @elseif($item->Car_Type == 'CarCarrier')
                                            {{trans('admin.CarCarrier')}}
                                            @endif   
               
                                            </td>
                                            <td>
                                                
                                                
                                         @if($item->Car_Statue == 'Good')
                                            {{trans('admin.Good')}}
                                            @elseif($item->Car_Statue == 'New')
                                            {{trans('admin.New')}}
                                            @elseif($item->Car_Statue == 'HalfGood')
                                            {{trans('admin.HalfGood')}}
                                               @elseif($item->Car_Statue == 'Bad')
                                            {{trans('admin.Bad')}}
                                       
                                            @endif   
                                                
                
                                            
                                            </td>
                                            <td>
                                                
                                                          @if($item->Insurance == 'Yes')
                                            {{trans('admin.Yes')}}
                                            @elseif($item->Insurance == 'No')
                                            {{trans('admin.No')}}
                                      
                                         @endif
                                            
                                            </td>
                                            <td>
                                                
                                            @if($item->Ownership == 'ToCompany')
                                            {{trans('admin.ToCompany')}} <br>
                                                
                                                
                                                  {{trans('admin.Cost_Center')}}<br>
                                                @if(!empty($item->Cost_Center()->first()->Arabic_Name))
                                                {{$item->Cost_Center()->first()->Arabic_Name}}
                                            @endif
                                           
                                                
                                                
                                            @elseif($item->Ownership == 'Rented')
                                            {{trans('admin.Rented')}}<br>
                                                
                                                   {{trans('admin.Rent_Amount')}}<br>
                                                ({{$item->Rent_Amount}})
                                                
                                            @elseif($item->Ownership == 'DriverOwne')
                                            {{trans('admin.DriverOwne')}} <br>
                                                
                                                  {{trans('admin.Deal_Type')}}<br>
                                                
                                                                  @if($item->Deal_Type == 'Precent')
                                            {{trans('admin.Precent')}}
                                            @elseif($item->Deal_Type == 'ConstantValue')
                                            {{trans('admin.ConstantValue')}}
                                      
                                         @endif
                                                
                                                
                                                       {{trans('admin.Deal_Amount')}}<br>
                                                
                                                ({{$item->Deal_Amount}})
                                          
                                                
                                     
                                            @endif   
                                         
                                                
                                                



                                            
                                            </td>
                                            <td class="text-center">


                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>



                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>

                                            </td>
                                        </tr>
                                    @endforeach


                                    </tbody>
                                    <tfoot>
                                    <tr>
                                       <th>{{trans('admin.Name')}}</th>
                                        <th>{{trans('admin.Max_Load')}}</th>
                                                <th>{{trans('admin.Minimum')}}</th>
                                        <th>{{trans('admin.Delegate')}}</th>
                                        <th>{{trans('admin.Driver')}}</th>
                                        <th>{{trans('admin.Car_Number')}}</th>
                                        <th>{{trans('admin.Color')}}</th>
                                        <th>{{trans('admin.Lisence_Expire_Date')}}</th>
                                        <th>{{trans('admin.GPS_Num')}}</th>
                                        <th>{{trans('admin.Car_Type')}}</th>
                                        <th>{{trans('admin.Car_Statue')}}</th>
                                        <th>{{trans('admin.Insurance')}}</th>
                                        <th>{{trans('admin.Ownership')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>

                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <!-- datatable end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Add-->
        <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{trans('admin.AddNew')}}  </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form action="{{url('AddCarShipping')}}" method="post">
                            {!! csrf_field() !!}
                            @honeypot
                            <div class="form-row">
                         
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Name')}}</label>
                                    <input type="text" name="Name" value="{{old('Name')}}"  class="form-control" required>
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Max_Load')}}</label>
                                    <input type="number" step="any" name="Max_Load"  value="{{old('Max_Load')}}" class="form-control" required >
                                </div>                            
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Minimum')}}</label>
                                    <input type="number" step="any" name="Minimum"  value="{{old('Minimum')}}" class="form-control" required >
                                </div>
                                    <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Car_Number')}}</label>
                                    <input type="text" step="any" name="Car_Number"  value="{{old('Car_Number')}}" class="form-control" required >
                                </div>
                                  <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Color')}}</label>
                                    <input type="color" step="any" name="Color"  value="{{old('Color')}}" class="form-control" >
                                </div>
                                
                                                 <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.GPS_Num')}}</label>
                                    <input type="text" step="any" name="GPS_Num"  value="{{old('GPS_Num')}}" class="form-control" >
                                </div>
                                            
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Lisence_Expire_Date')}}</label>
                                    <input type="date" step="any" name="Lisence_Expire_Date"  value="{{old('Lisence_Expire_Date')}}" class="form-control" >
                                </div>
                                
                                        
                                                 <div class="form-group col-lg-6">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Delegate')}}</label>
                                               <select class="select2 form-control Delegate" name="Delegate" id="DelegateX" >
                                                            <option value="">{{trans('admin.Delegate')}}</option>
                                                        </select>
                                </div>
                                            
                                <div class="form-group col-lg-6">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Driver')}}</label>
                                     <select class="select2 form-control Driver" name="Driver" id="DriverX" >
                                                            <option value="">{{trans('admin.Driver')}}</option>

                                                        </select>
                                </div>
                                
                                
                                     <div class="form-group col-lg-4">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Car_Type')}}</label>
                                                      <select class="select2 form-control" name="Car_Type" id="Car_Type" required>
                                 <option value="">{{trans('admin.Car_Type')}}</option>
                                <option value="LightPickupTruck" @if(old('Car_Type')=='LightPickupTruck' ) selected @endif>{{trans('admin.LightPickupTruck')}}</option>
                                <option value="SmallCargoVan" @if(old('Car_Type')=='SmallCargoVan' ) selected @endif>{{trans('admin.SmallCargoVan')}}</option>
                               <option value="Lorry" @if(old('Car_Type')=='Lorry' ) selected @endif>{{trans('admin.Lorry')}}</option>
                                <option value="BoxTruck" @if(old('Car_Type')=='BoxTruck' ) selected @endif>{{trans('admin.BoxTruck')}}</option>
                                 <option value="ReeferTruck" @if(old('Car_Type')=='ReeferTruck' ) selected @endif>{{trans('admin.ReeferTruck')}}</option>
                                 <option value="DumpTruck" @if(old('Car_Type')=='DumpTruck' ) selected @endif>{{trans('admin.DumpTruck')}}</option>
                                   <option value="TankLorry" @if(old('Car_Type')=='TankLorry' ) selected @endif>{{trans('admin.TankLorry')}}</option>
                                    <option value="FlatbedTruck" @if(old('Car_Type')=='FlatbedTruck' ) selected @endif>{{trans('admin.FlatbedTruck')}}</option>
                                    <option value="CurtainsideTruck" @if(old('Car_Type')=='CurtainsideTruck' ) selected @endif>{{trans('admin.CurtainsideTruck')}}</option>
                                    <option value="CarCarrier" @if(old('Car_Type')=='CarCarrier' ) selected @endif>{{trans('admin.CarCarrier')}}</option>
                                    
                                                      </select>
                                                    </div>
            
                                     <div class="form-group col-lg-4">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Car_Statue')}}</label>
                                                      <select class="select2 form-control" name="Car_Statue" id="Car_Statue" required>
                                 <option value="">{{trans('admin.Car_Statue')}}</option>
                                <option value="Good" @if(old('Car_Statue')=='Good' ) selected @endif>{{trans('admin.Good')}}</option>
                                <option value="New" @if(old('Car_Statue')=='New' ) selected @endif>{{trans('admin.New')}}</option>
                               <option value="HalfGood" @if(old('Car_Statue')=='HalfGood' ) selected @endif>{{trans('admin.HalfGood')}}</option>
                                <option value="Bad" @if(old('Car_Statue')=='Bad' ) selected @endif>{{trans('admin.Bad')}}</option>
                      
                                                      </select>
                                                    </div>

                                
                                     <div class="form-group col-lg-4">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Car_Statue')}}</label>
                                                      <select class="select2 form-control" name="Insurance" id="Insurance" required>
                                 <option value="">{{trans('admin.Insurance')}}</option>
                                <option value="Yes" @if(old('Insurance')=='Yes' ) selected @endif>{{trans('admin.Yes')}}</option>
                                <option value="No" @if(old('Insurance')=='No' ) selected @endif>{{trans('admin.No')}}</option>
                                           </select>
                                                    </div>

                                
                                     <div class="form-group col-lg-4">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Ownership')}}</label>
                                                      <select class="select2 form-control" onchange="OwnershipChange()" name="Ownership" id="Ownership" required>
                                 <option value="">{{trans('admin.Ownership')}}</option>
                                <option value="ToCompany" @if(old('Ownership')=='ToCompany' ) selected @endif>{{trans('admin.ToCompany')}}</option>
                                <option value="Rented" @if(old('Ownership')=='Rented' ) selected @endif>{{trans('admin.Rented')}}</option>
                               <option value="DriverOwne" @if(old('Ownership')=='DriverOwne' ) selected @endif>{{trans('admin.DriverOwne')}}</option>
                      
                      
                                                      </select>
                                                    </div>

                                
                             <div class="form-group col-lg-12" id="Cost_Center" style="display: none">
                                               <label class="form-label" for="simpleinput"> {{trans('admin.Cost_Center')}}</label>        
                                                     <select class="select2 form-control Cost_Center" name="Cost_Center" id="Cost_CenterX" >
                                                            <option value="">{{trans('admin.Cost_Center')}}</option>
                                                        </select>    
                                 
                                </div>
                              
                                
                             <div class="form-group col-lg-12" id="Rent_Amount" style="display: none">
                                               <label class="form-label" for="simpleinput"> {{trans('admin.Rent_Amount')}}</label>        
                                     <input type="number" step="any" name="Rent_Amount"  value="{{old('Rent_Amount')}}" class="form-control"  > 
                                </div>
                                


                                         <div class="form-group col-lg-6" id="Deal_Type" style="display: none">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Ownership')}}</label>
                                                      <select class="select2 form-control"  name="Deal_Type"  >
                                 <option value="">{{trans('admin.Deal_Type')}}</option>
                                <option value="Precent" @if(old('Deal_Type')=='Precent' ) selected @endif>{{trans('admin.Precent')}}</option>
                                <option value="ConstantValue" @if(old('Deal_Type')=='ConstantValue' ) selected @endif>{{trans('admin.ConstantValue')}}</option>
                   
                                                      </select>
                                                    </div>

                     
                             <div class="form-group col-lg-6" id="Deal_Amount" style="display: none">
                                               <label class="form-label" for="simpleinput"> {{trans('admin.Deal_Amount')}}</label>        
                                     <input type="number" step="any" name="Deal_Amount"  value="{{old('Deal_Amount')}}" class="form-control"  > 
                                </div>
                                


                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>



        @foreach($items as $item)

            <!-- Modal Edit -->
            <div class="modal fade" id="default-example-modal-lg-edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">{{trans('admin.Edit')}}  </h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form action="{{url('EditCarShipping/'.$item->id)}}" method="post">
                                {!! csrf_field() !!}
                                @honeypot
                             <div class="form-row">
                         
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Name')}}</label>
                                    <input type="text" name="Name" value="{{$item->Name}}"  class="form-control" required>
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Max_Load')}}</label>
                                    <input type="number" step="any" name="Max_Load"  value="{{$item->Max_Load}}" class="form-control" required >
                                </div>      
                                 <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Minimum')}}</label>
                                    <input type="number" step="any" name="Minimum"  value="{{$item->Minimum}}" class="form-control" required >
                                </div>
                                    <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Car_Number')}}</label>
                                    <input type="text" step="any" name="Car_Number"  value="{{$item->Car_Number}}" class="form-control" required >
                                </div>
                                  <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Color')}}</label>
                                    <input type="color" step="any" name="Color"  value="{{$item->Color}}" class="form-control" >
                                </div>
                                
                                                 <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.GPS_Num')}}</label>
                                    <input type="text" step="any" name="GPS_Num"  value="{{$item->GPS_Num}}" class="form-control" >
                                </div>
                                            
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Lisence_Expire_Date')}}</label>
                                    <input type="date" step="any" name="Lisence_Expire_Date"  value="{{$item->Lisence_Expire_Date}}" class="form-control" >
                                </div>
                                
                                        
                                                 <div class="form-group col-lg-6">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Delegate')}}</label>
                                               <select class="select2 form-control Delegate" name="Delegate" id="Delegate" >
                                            
                                                   
                                                
                                                                        @if(!empty($item->Delegate()->first()->Name))


                                                                <option value="{{$item->Delegate}}">
                                                                        {{$item->Delegate()->first()->Name}}

                                                                </option>

                                                            @endif
                                                          
                                                   
                                                        </select>
                                </div>
                                            
                                <div class="form-group col-lg-6">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Driver')}}</label>
                                     <select class="select2 form-control Driver" name="Driver" id="Driver" >
                                                        

                                         
                                         
                                             
                                                                        @if(!empty($item->Driver()->first()->Name))


                                                                <option value="{{$item->Driver}}">
                                                                        {{$item->Driver()->first()->Name}}

                                                                </option>

                                                            @endif
                                                          
                                                        </select>
                                </div>
                                
                                
                                     <div class="form-group col-lg-4">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Car_Type')}}</label>
                                                      <select class="select2 form-control" name="Car_Type" id="Car_Type" required>
                                 <option value="">{{trans('admin.Car_Type')}}</option>
                                <option value="LightPickupTruck" @if( $item->Car_Type == 'LightPickupTruck' ) selected @endif>{{trans('admin.LightPickupTruck')}}</option>
                                <option value="SmallCargoVan" @if($item->Car_Type == 'SmallCargoVan' ) selected @endif>{{trans('admin.SmallCargoVan')}}</option>
                               <option value="Lorry" @if($item->Car_Type =='Lorry' ) selected @endif>{{trans('admin.Lorry')}}</option>
                                <option value="BoxTruck" @if($item->Car_Type =='BoxTruck' ) selected @endif>{{trans('admin.BoxTruck')}}</option>
                                 <option value="ReeferTruck" @if($item->Car_Type =='ReeferTruck' ) selected @endif>{{trans('admin.ReeferTruck')}}</option>
                                 <option value="DumpTruck" @if($item->Car_Type =='DumpTruck' ) selected @endif>{{trans('admin.DumpTruck')}}</option>
                                   <option value="TankLorry" @if($item->Car_Type =='TankLorry' ) selected @endif>{{trans('admin.TankLorry')}}</option>
                                    <option value="FlatbedTruck" @if($item->Car_Type =='FlatbedTruck' ) selected @endif>{{trans('admin.FlatbedTruck')}}</option>
                                    <option value="CurtainsideTruck" @if($item->Car_Type == 'CurtainsideTruck' ) selected @endif>{{trans('admin.CurtainsideTruck')}}</option>
                                    <option value="CarCarrier" @if($item->Car_Type == 'CarCarrier' ) selected @endif>{{trans('admin.CarCarrier')}}</option>
                                    
                                                      </select>
                                                    </div>
            
                                     <div class="form-group col-lg-4">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Car_Statue')}}</label>
                                                      <select class="select2 form-control" name="Car_Statue" id="Car_Statue" required>
                                 <option value="">{{trans('admin.Car_Statue')}}</option>
                                <option value="Good" @if($item->Car_Statue =='Good' ) selected @endif>{{trans('admin.Good')}}</option>
                                <option value="New" @if($item->Car_Statue =='New' ) selected @endif>{{trans('admin.New')}}</option>
                               <option value="HalfGood" @if($item->Car_Statue =='HalfGood' ) selected @endif>{{trans('admin.HalfGood')}}</option>
                                <option value="Bad" @if($item->Car_Statue =='Bad' ) selected @endif>{{trans('admin.Bad')}}</option>
                      
                                                      </select>
                                                    </div>

                                
                                     <div class="form-group col-lg-4">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Car_Statue')}}</label>
                                                      <select class="select2 form-control" name="Insurance" id="Insurance" required>
                                 <option value="">{{trans('admin.Insurance')}}</option>
                                <option value="Yes" @if($item->Insurance =='Yes' ) selected @endif>{{trans('admin.Yes')}}</option>
                                <option value="No" @if($item->Insurance =='No' ) selected @endif>{{trans('admin.No')}}</option>
                                           </select>
                                                    </div>

                                
                                     <div class="form-group col-lg-4">
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Ownership')}}</label>
                                                      <select class="select2 form-control" onchange="OwnershipChangeEdit({{$item->id}})" name="Ownership" id="Ownership{{$item->id}}" required>
                                 <option value="">{{trans('admin.Ownership')}}</option>
                                <option value="ToCompany" @if($item->Ownership =='ToCompany' ) selected @endif>{{trans('admin.ToCompany')}}</option>
                                <option value="Rented" @if($item->Ownership =='Rented' ) selected @endif>{{trans('admin.Rented')}}</option>
                               <option value="DriverOwne" @if($item->Ownership =='DriverOwne' ) selected @endif>{{trans('admin.DriverOwne')}}</option>
                      
                      
                                                      </select>
                                                    </div>

                                
                             <div class="form-group col-lg-12" id="Cost_Center{{$item->id}}" @if($item->Ownership =='ToCompany' ) style="display: block" @else style="display: none" @endif>
                                               <label class="form-label" for="simpleinput"> {{trans('admin.Cost_Center')}}</label>        
                                                     <select class="select2 form-control Cost_Center" name="Cost_Center" >
                                                      
                                                         
                                                         
                                                                        @if(!empty($item->Cost_Center()->first()->Arabic_Name))


                                                                <option value="{{$item->Cost_Center}}">
                                                                        {{$item->Cost_Center()->first()->Arabic_Name}}

                                                                </option>

                                                            @endif
                                                          
                                                         
                                                         
                                                        </select>    
                                 
                                </div>
                              
                                
                             <div class="form-group col-lg-12" id="Rent_Amount{{$item->id}}" @if($item->Ownership =='Rented' ) style="display: block" @else style="display: none" @endif>
                                               <label class="form-label" for="simpleinput"> {{trans('admin.Rent_Amount')}}</label>        
                                     <input type="number" step="any" name="Rent_Amount"  value="{{old('Rent_Amount')}}" class="form-control"  > 
                                </div>
                                


                                         <div class="form-group col-lg-6" id="Deal_Type{{$item->id}}" @if($item->Ownership =='DriverOwne' ) style="display: block" @else style="display: none" @endif>
                                                        <label class="form-label" for="simpleinput">{{trans('admin.Ownership')}}</label>
                                                      <select class="select2 form-control"  name="Deal_Type"  >
                                 <option value="">{{trans('admin.Deal_Type')}}</option>
                                <option value="Precent" @if(old('Deal_Type')=='Precent' ) selected @endif>{{trans('admin.Precent')}}</option>
                                <option value="ConstantValue" @if(old('Deal_Type')=='ConstantValue' ) selected @endif>{{trans('admin.ConstantValue')}}</option>
                   
                                                      </select>
                                                    </div>

                     
                             <div class="form-group col-lg-6" id="Deal_Amount{{$item->id}}" @if($item->Ownership =='DriverOwne' ) style="display: block" @else style="display: none" @endif>
                                               <label class="form-label" for="simpleinput"> {{trans('admin.Deal_Amount')}}</label>        
                                     <input type="number" step="any" name="Deal_Amount"  value="{{old('Deal_Amount')}}" class="form-control"  > 
                                </div>
                                


                            </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Delete -->
            <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.RUSWDT')}}
                              
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                            <a href="{{url('DeleteCarShipping/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                        </div>
                    </div>
                </div>
            </div>

        @endforeach
    </main>

@endsection

@push('js')
     <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


    <!-- Search Select -->
    <script>
        $(document).ready(function () {
            $(function () {
                $(".select2").select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State",
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0,
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items",
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true,
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm;
                    },
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
                }

                $(".Delegate").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "DelegatesShippingFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {

                            $.ajax({
                                url: 'DelegatesShippingFilterJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('.Delegate').empty();
                                    $.each(data, function(key, value){

                                        $('.Delegate').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $(".Delegate").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });


                $(".Driver").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "DriversShippingFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {

                            $.ajax({
                                url: 'DriversShippingFilterJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('.Driver').empty();
                                    $.each(data, function(key, value){

                                        $('.Driver').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $(".Driver").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });


                $(".Cost_Center").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "Cost_CenterShippingFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {

                            $.ajax({
                                url: 'Cost_CenterShippingFilterJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('.Cost_Center').empty();
                                    $.each(data, function(key, value){

                                        $('.Cost_Center').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $(".Cost_Center").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });

                $("#Cost_CenterX").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "Cost_CenterShippingFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {

                            $.ajax({
                                url: 'Cost_CenterShippingFilterJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#Cost_CenterX').empty();
                                    $.each(data, function(key, value){

                                        $('#Cost_CenterX').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $("#Cost_CenterX").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });


                
                
                $("#DelegateX").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "DelegatesShippingFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {

                            $.ajax({
                                url: 'DelegatesShippingFilterJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#DelegateX').empty();
                                    $.each(data, function(key, value){

                                        $('#DelegateX').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $("#DelegateX").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });


                $("#DriverX").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "DriversShippingFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {

                            $.ajax({
                                url: 'DriversShippingFilterJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#DriverX').empty();
                                    $.each(data, function(key, value){

                                        $('#DriverX').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $("#DriverX").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });

                
                
                

            });
        });
    </script>




<script>

function OwnershipChange(){
    
    var Ownership=$('#Ownership').val();
    
    
    if(Ownership == 'ToCompany'){
       
       document.getElementById('Cost_Center').style.display="block";
       document.getElementById('Rent_Amount').style.display="none";
       document.getElementById('Deal_Type').style.display="none";
       document.getElementById('Deal_Amount').style.display="none";
       
       }
    
    if(Ownership == 'Rented'){
       
       document.getElementById('Cost_Center').style.display="none";
       document.getElementById('Rent_Amount').style.display="block";
       document.getElementById('Deal_Type').style.display="none";
       document.getElementById('Deal_Amount').style.display="none";
       
       }
    
    if(Ownership == 'DriverOwne'){
       
       document.getElementById('Cost_Center').style.display="none";
       document.getElementById('Rent_Amount').style.display="none";
       document.getElementById('Deal_Type').style.display="block";
       document.getElementById('Deal_Amount').style.display="block";
       
       }
    
       


    
}

function OwnershipChangeEdit(id){
    
    var Ownership=$('#Ownership'+id).val();
    
    
    if(Ownership == 'ToCompany'){
       
       document.getElementById('Cost_Center'+id).style.display="block";
       document.getElementById('Rent_Amount'+id).style.display="none";
       document.getElementById('Deal_Type'+id).style.display="none";
       document.getElementById('Deal_Amount'+id).style.display="none";
       
       }
    
    if(Ownership == 'Rented'){
       
       document.getElementById('Cost_Center'+id).style.display="none";
       document.getElementById('Rent_Amount'+id).style.display="block";
       document.getElementById('Deal_Type'+id).style.display="none";
       document.getElementById('Deal_Amount'+id).style.display="none";
       
       }
    
    if(Ownership == 'DriverOwne'){
       
       document.getElementById('Cost_Center'+id).style.display="none";
       document.getElementById('Rent_Amount'+id).style.display="none";
       document.getElementById('Deal_Type'+id).style.display="block";
       document.getElementById('Deal_Amount'+id).style.display="block";
       
       }
    
       


    
}

</script>

@endpush

