@extends('admin.index')
@section('content')
<title>{{trans('admin.Errors')}}</title>

  <main id="js-page-content" role="main" class="page-content">
                        <ol class="breadcrumb page-breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Settings')}}</a></li>
                            <li class="breadcrumb-item active">{{trans('admin.Errors')}}</li>
                            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
                        </ol>
                        <div class="subheader">
                            <h1 class="subheader-title"> {{trans('admin.Errors')}} </h1>
                        </div>
                        <div class="row">
                            <div class="col-lg-12 col-xl-12 order-lg-1 order-xl-1">
                            <span id="ex"> @include('admin.layouts.messages')</span>     
                         
                     
                                <div class="card mb-g rounded-top">
                                    
                           
        
        @if (empty($parsedLogs) || (count($parsedLogs) == 1 && $parsedLogs[0]['message'] == 'Log file not found.'))
            <p class="text-gray-600">No error logs found or log file is empty.</p>
        @else
            <div class="overflow-x-auto">
                <table class="table table-bordered table-hover table-striped w-100 mobile-width">
                    <thead>
                        <tr class="text-gray-600 uppercase text-sm leading-normal">
                            <th class="text-center" style="width: 10% !important">Date & Time</th>
                            <th class="text-center" style="width: 10% !important">Level</th>
                            <th class="text-center" style="width:  80% !important">Message</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-600 text-sm font-light">
                        @foreach ($parsedLogs as $log)
                            <tr class="border-b border-gray-200 hover:bg-gray-100">
                                <td class="text-center whitespace-nowrap">{{ $log['datetime'] }}</td>
                                <td class="text-center">
                                    <span class="
                                        @if ($log['level'] == 'ERROR') bg-red-200 text-red-600
                                        @elseif ($log['level'] == 'WARNING') bg-yellow-200 text-yellow-600
                                        @elseif ($log['level'] == 'INFO') bg-blue-200 text-blue-600
                                        @else bg-gray-200 text-gray-600 @endif
                                        py-1 px-3 rounded-full text-xs"
                                    >
                                        {{ $log['level'] }}
                                    </span>
                                </td>
                                <td class="text-center">
                                    <pre class="whitespace-pre-wrap font-sans text-sm">{{ $log['message'] }}</pre>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif

                                        
                                      
                   
                                      
                                </div>
                   
                            </div>
                            
                            
                  
                         
                        </div>

                    </main>

@endsection

@push('js')
     <!-- Optional: page related CSS-->
        <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/fa-brands.css')}}">
        <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/fa-solid.css')}}">
@endpush