@extends('admin.index')
@section('content')

  <title>{{trans('admin.TicketsClient')}}</title>

    <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Sales')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('admin.TicketsClient')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                    <div class="row">
                            <div class="col-xl-12 text-center">
               <h1 class="text-center" style="font-size: 20px">{{$NAME}}</h1>
        </div>
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                         <span class="fw-300"><i>{{trans('admin.TicketsClient')}}</i></span>
                                    </h2>

                                    <div class="panel-toolbar">
                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg">{{trans('admin.AddNew')}}</button>
                                        <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                                        @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                                   <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                        <div id="mobile-overflow">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped w-100 mobile-width">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Arabic_Problem')}}</th>
                                                    <th>{{trans('admin.English_Problem')}}</th>
                                                    <th>{{trans('admin.Bill_Number')}}</th>
                                                    <th>{{trans('admin.Responsible')}}</th>
                                                    <th>{{trans('admin.TicektIssues')}}</th>
                                                    <th>{{trans('admin.User')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>

                                                </tr>
                                            </thead>
                                            <tbody>

                                            @foreach($items as $item)
                                                <tr>
                                                    <td>{{$item->Code}}</td>
                                                    <td>{{$item->Date}}</td>
                                                    <td>

                                    <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Problem{{$item->id}}">
                                            {{trans('admin.Arabic_Problem')}}
                                                        </button>
                                                    </td>

                                                             <td>

                                    <button type="button" class="btn btn-default" data-toggle="modal" data-target="#ProblemEn{{$item->id}}">
                                            {{trans('admin.English_Problem')}}
                                                        </button>
                                                    </td>
                                                    <td>{{$item->Bill_Number}}</td>
                                                    <td>

                                     {{app()->getLocale() == 'ar' ?$item->Responsible()->first()->Name :$item->Responsible()->first()->NameEn}}
                                                    </td>        
                                                    
                                                    <td>
                                                                  @if(!empty($item->TicketIssues()->first()->Arabic_Name))
                                    {{app()->getLocale() == 'ar' ? $item->TicketIssues()->first()->Arabic_Name : $item->TicketIssues()->first()->English_Name}}
                                @endif

                                                    </td>
                                                    <td>

                                 {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                                                    </td>
                                                    <td class="text-center">
            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
           <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>

                                                @if($item->Status == 1)
                        <a href="{{url('SolveTicketsClient/'.$item->id)}}" class="btn btn-danger">{{trans('admin.UnSolve')}}</a>
                                                @elseif($item->Status == 2)
                     <a href="{{url('UnSolveTicketsClient/'.$item->id)}}" class="btn btn-default">{{trans('admin.Solved')}}</a>
                                                @endif

                                                    </td>
                                                </tr>
                                             @endforeach


                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                 <th>{{trans('admin.Code')}}</th>
                                                 <th>{{trans('admin.Date')}}</th>
                                                        <th>{{trans('admin.Arabic_Problem')}}</th>
                                                    <th>{{trans('admin.English_Problem')}}</th>
                                                    <th>{{trans('admin.Bill_Number')}}</th>
                                                    <th>{{trans('admin.Responsible')}}</th>
                                                    <th>{{trans('admin.TicektIssues')}}</th>
                                                    <th>{{trans('admin.User')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                        </div>
                                        <!-- datatable end -->
                                        {{$items->Links()}}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal Add-->
          <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.AddNew')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{url('AddTicketsClient')}}" method="post">
                                        {!! csrf_field() !!}
                                              @honeypot
                            <input type="hidden" name="Customer" value="{{$customer}}">
                                        <div class="form-row">
                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Code')}}</label>
                   <input type="text"  value="{{$Code}}"  class="form-control" disabled>
                   <input type="hidden" name="Code"  value="{{$Code}}"  class="form-control">
                                        </div>

                                        <div class="form-group col-md-4">
                                        <label class="form-label" for="">  {{trans('admin.Responsible')}}</label>
                                            <select class="select2 form-control w-100" name="Responsible" required>
                                                 <option value="">{{trans('admin.Responsible')}}</option>
                                              @foreach($Employess as $emp)
                                                    <option value="{{$emp->id}}">
                                        {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>

                                        <div class="form-group col-md-4">
                                        <label class="form-label" for="">  {{trans('admin.TicektIssues')}}</label>
                                            <select class="select2 form-control w-100" name="TicketIssues" required>
                                                 <option value="">{{trans('admin.TicektIssues')}}</option>
                                              @foreach($TicektIssues as $tick)
                                                    <option value="{{$tick->id}}">
                                        {{app()->getLocale() == 'ar' ?$tick->Arabic_Name :$tick->English_Name}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>

                                                     <div class="form-group col-md-6">
                                        <label class="form-label" for="">  {{trans('admin.Bill_Number')}}</label>
                                <select class="select2 form-control w-100" name="Bill_Number" id="Bill_Number" required>
                                                 <option value="">{{trans('admin.Bill_Number')}}</option>
                                                     @foreach($BillNumbers as $bill)
                                                    <option value="{{$bill->Code}}">
                                        {{app()->getLocale() == 'ar' ?$bill->Code :$bill->Code}}
                                              </option>
                                              @endforeach
                                                                        </select>   
                                                                    </div>

                                        <div class="form-group col-lg-12">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Problem')}}</label>
                         <textarea type="text" name="Problem"  class="form-control" required>
                             {{old('Problem')}}
                                            </textarea>
                                        </div>

                                            <div class="form-group col-lg-12">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.English_Problem')}}</label>
                         <textarea type="text" name="ProblemEn"  class="form-control" >
                             {{old('ProblemEn')}}
                                            </textarea>
                                        </div>

                                        </div>


                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>



         @foreach($items as $item)
        <!-- Modal Edit-->
                    <div class="modal fade" id="default-example-modal-lg-edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.Edit')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{url('EditTicketsClient/'.$item->id)}}" method="post">
                                        {!! csrf_field() !!}
                                           @honeypot
                                             <input type="hidden" name="Customer" value="{{$customer}}">
                                        <div class="form-row">
                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Code')}}</label>
                   <input type="text"  value="{{$item->Code}}"  class="form-control" disabled>
                   <input type="hidden" name="Code"  value="{{$item->Code}}"  class="form-control">
                                        </div>

                                        <div class="form-group col-md-4">
                                        <label class="form-label" for="">  {{trans('admin.Responsible')}}</label>
                                            <select class="select2 form-control w-100" name="Responsible" required>
                                                 <option value="">{{trans('admin.Responsible')}}</option>
                                              @foreach($Employess as $emp)
                    <option value="{{$emp->id}}" @if($item->Responsible == $emp->id) selected  @endif>

                     {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>
                                            
                                            
                                            
                                                       <div class="form-group col-md-4">
                                        <label class="form-label" for="">  {{trans('admin.TicektIssues')}}</label>
                                            <select class="select2 form-control w-100" name="TicketIssues" required>
                                                 <option value="">{{trans('admin.TicektIssues')}}</option>
                                              @foreach($TicektIssues as $tick)
                                                    <option value="{{$tick->id}}" @if($item->TicektIssues == $tick->id) selected  @endif>
                                        {{app()->getLocale() == 'ar' ?$tick->Arabic_Name :$tick->English_Name}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>
                   <div class="form-group col-md-6">
                                        <label class="form-label" for="">  {{trans('admin.Bill_Number')}}</label>
                                <select class="select2 form-control w-100" name="Bill_Number" id="Bill_Number" required>
                                                 <option value="">{{trans('admin.Bill_Number')}}</option>
                                                     @foreach($BillNumbers as $bill)
                                                    <option value="{{$bill->Code}}"  @if($item->Bill_Number == $bill->Code) selected  @endif>
                                        {{app()->getLocale() == 'ar' ?$bill->Code :$bill->Code}}
                                              </option>
                                              @endforeach
                                                                        </select>   
                                                                    </div>

                                        <div class="form-group col-lg-12">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Problem')}}</label>
                         <textarea type="text" name="Problem"  class="form-control" required>
                             {{$item->Problem}}
                                            </textarea>
                                        </div>

                                            <div class="form-group col-lg-12">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.English_Problem')}}</label>
                         <textarea type="text" name="ProblemEn"  class="form-control" required>
                             {{$item->ProblemEn}}
                                            </textarea>
                                        </div>

                                        </div>


                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                      <!-- Modal Delete -->
                      <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                          {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                   <a href="{{url('DeleteTicketsClient/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>

            <!-- Modal Problem -->
               <div class="modal fade" id="Problem{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                        <strong>{{$item->Problem}}


                                        </strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Cancel')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>


                <!-- Modal Problem English -->
               <div class="modal fade" id="ProblemEn{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                        <strong>{{$item->ProblemEn}}


                                        </strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Cancel')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>



        @endforeach
                </main>

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
   <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
@endpush

