@extends('admin.index')
@section('content')

<title>{{$title}}</title>
<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Sales')}} </a></li>
        <li class="breadcrumb-item active">{{$title}} </li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>
    <form id="form" action="{{$urll}}" method="post" enctype="multipart/form-data">
        {!! csrf_field() !!}
        @honeypot
        <input type="hidden" name="Sale_Type" value="Sales">
        <div class="row">
            <div class="col-lg-12">
                <div id="panel-2" class="panel" >
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i> {{$title}} </i></span>
                        </h2>
                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <div class="form-row">
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                    <input type="text" value="{{$Code}}" class="form-control " disabled>
                                    <input type="hidden" name="Code" value="{{$Code}}" class="form-control">
                                </div>
                                @if(auth()->guard('admin')->user()->emp == 0)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required>
                                </div>
                                @else

                                @if(auth()->guard('admin')->user()->Date == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required>
                                </div>
                                @else
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required readonly>
                                </div>
                                @endif

                                @endif


                                @if($Place != 'Sales')

                                    <div class="form-group col-lg-2">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Sale_Date')}}</label>
                                        <input type="date" name="Sale_Date"  class="form-control">
                                    </div>

                                @endif

                                @if($show->TaxBill == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.TaxBill')}}</label>
                                    <select class="select2 form-control w-100" name="TaxBill" required>
                                        <option value="0" @if($Def->TaxType == 0) selected @endif>{{trans('admin.No_Tax')}}</option>
                                        <option value="1" @if($Def->TaxType == 1) selected @endif>{{trans('admin.Yes_Tax')}}</option>
                                    </select>
                                </div>
                                @else
                                <input type="hidden" name="TaxBill" value="{{$Def->TaxType}}">
                                @endif
                                
                                
                         
                                
                                
                                

                                @if($Def->DiscountTaxShow == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.DiscountTax')}}</label>
                                    <select class="select2 form-control w-100" name="DiscountTaxShow" required>
                                        <option value="0">{{trans('admin.No')}}</option>
                                        <option value="1">{{trans('admin.Yes')}}</option>
                                    </select>
                                </div>
                                @else
                                <input type="hidden" name="DiscountTaxShow" value="0">
                                @endif

                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Store')}}</label>
                                    <select class="select2 form-control w-100" id="store" name="Store" required>
                                        @foreach($Stores as $stor)
                                        <option value="{{$stor->id}}" @if($Def->Store == $stor->id) selected @endif>

                                            {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}

                                        </option>
                                        @endforeach
                                    </select>
                                </div>


                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                                    <select class="select2 form-control w-100" id="SSAFE" name="Safe" required>
                                        @foreach($Safes as $safe)
                                        <option value="{{$safe->id}}" @if($Def->Safe == $safe->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @if($show->Coin == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Coin')}}</label>
                                    <select class="select2 form-control w-100" name="Coin" required>
                                        <option value=""> {{trans('admin.Coin')}}</option>
                                        @foreach($Coins as $coin)
                                        <option value="{{$coin->id}}" @if($Def->Coin == $coin->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for="">{{trans('admin.Coin')}}</label>
                                    <select class="select2 form-control w-100" name="Coin" required>
                                        <option value=""> {{trans('admin.Coin')}}</option>
                                        @foreach($Coins as $coin)
                                        <option value="{{$coin->id}}" @if($Def->Coin == $coin->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @endif
                                @if($show->Draw == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                    <input type="text" name="Draw" value="1" class="form-control" required>
                                </div>
                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                    <input type="text" name="Draw" value="1" class="form-control" required>
                                </div>
                                @endif

                                @if(auth()->guard('admin')->user()->emp != 0)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for=""> {{trans('admin.Payment_Method')}}</label>
                                    <select class="select2 form-control w-100" name="Payment_Method" id="Payment_Method" onchange="Statuss()" required>


                                        @if(auth()->guard('admin')->user()->Cash == 1)
                                        <option value="Cash" @if($Def->Payment_Method == 'Cash') selected @endif>{{trans('admin.Cash')}} </option>
                                        @endif

                                        @if(auth()->guard('admin')->user()->Later == 1)
                                        <option value="Later" @if($Def->Payment_Method == 'Later') selected @endif>{{trans('admin.Later')}}</option>
                                        @endif

                                        @if(auth()->guard('admin')->user()->Installment == 1)
                                        <option value="Installment" @if($Def->Payment_Method == 'Installment') selected @endif>{{trans('admin.Installment')}}</option>
                                        @endif

                                        @if(auth()->guard('admin')->user()->Check == 1)
                                        <option value="Check" @if($Def->Payment_Method == 'Check') selected @endif>{{trans('admin.Check')}}</option>
                                        @endif

                                        @if(auth()->guard('admin')->user()->InstallmentCompanies == 1)
                                        <option value="InstallmentCompanies">{{trans('admin.InstallmentCompanies')}}</option>
                                        @endif

                                    </select>
                                </div>
                                @else
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for=""> {{trans('admin.Payment_Method')}}</label>
                                    <select class="select2 form-control w-100" name="Payment_Method" id="Payment_Method" onchange="Statuss()" required>

                                        <option value="Cash" @if($Def->Payment_Method == 'Cash') selected @endif>{{trans('admin.Cash')}} </option>
                                        <option value="Later" @if($Def->Payment_Method == 'Later') selected @endif>{{trans('admin.Later')}}</option>
                                        <option value="Installment" @if($Def->Payment_Method == 'Installment') selected @endif>{{trans('admin.Installment')}}</option>
                                        <option value="Check" @if($Def->Payment_Method == 'Check') selected @endif>{{trans('admin.Check')}}</option>
                                        <option value="InstallmentCompanies">{{trans('admin.InstallmentCompanies')}}</option>

                                    </select>
                                </div>

                                @endif
                                <div class="form-group col-lg-2" style="display: none" id="Later_Due">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Later_Due')}}</label>
                                    <input type="date" name="Later_Due" class="form-control">
                                </div>
                                @if($show->Status == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Status')}}</label>
                                    <select class="select2 form-control w-100" name="Status" onchange="Statuss()" id="Status" required>
                                        <option value="1" @if($Def->Status == 1) selected @endif>{{trans('admin.Recived')}} </option>
                                        <option value="0" @if($Def->Status == 0) selected @endif>{{trans('admin.Pending')}}</option>
                                    </select>
                                </div>
                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for="">{{trans('admin.Status')}}</label>
                                    <select class="select2 form-control w-100" name="Status" onchange="Statuss()" id="Status" required>
                                        <option value="1" @if($Def->Status == 1) selected @endif>{{trans('admin.Recived')}} </option>
                                        <option value="0" @if($Def->Status == 0) selected @endif>{{trans('admin.Pending')}}</option>
                                    </select>
                                </div>
                                @endif
                                @if($show->Cost_Center == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for=""> {{trans('admin.Cost_Center')}} </label>
                                    <select class="select2 form-control w-100" name="Cost_Center">
                                        <option value=""> {{trans('admin.Cost_Center')}}</option>
                                        @foreach($CostCenters as $cost)
                                        <option value="{{$cost->id}}">
                                            {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for=""> {{trans('admin.Cost_Center')}} </label>
                                    <select class="select2 form-control w-100" name="Cost_Center">
                                        <option value=""> {{trans('admin.Cost_Center')}}</option>
                                        @foreach($CostCenters as $cost)
                                        <option value="{{$cost->id}}">
                                            {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @endif


                                @if($show->Delegate_Sale == 1)
                                @if(auth()->guard('admin')->user()->emp == 0)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Delegate')}}</label>
                                    <select class="select2 form-control w-100 EmpDele" name="Delegate">
                                        <option value=""> {{trans('admin.Delegate')}}</option>
                                        @foreach($Employess as $emp)
                                        <option value="{{$emp->id}}" @if($Def->Delegate == $emp->id) selected @endif>

                                            {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @else

                                @if($Def->DelegateEmp == 0)
                                <input type="hidden" name="Delegate" value="{{auth()->guard('admin')->user()->emp}}">
                                @else
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Delegate')}}</label>
                                    <select class="select2 form-control w-100 EmpDele" name="Delegate">
                                        <option value=""> {{trans('admin.Delegate')}}</option>
                                        @foreach($Employess as $emp)
                                        <option value="{{$emp->id}}" @if(auth()->guard('admin')->user()->emp == $emp->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>

                                @endif


                                @endif


                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for="">{{trans('admin.Delegate')}}</label>
                                    <select class="select2 form-control w-100 EmpDele" name="Delegate">
                                        <option value=""> {{trans('admin.Delegate')}}</option>
                                        @foreach($Employess as $emp)
                                        <option value="{{$emp->id}}" @if($Def->Delegate == $emp->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @endif


                                @if(auth()->guard()->user()->emp == 0)
                                @if($show->Executor_Sale == 1)

                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Executor')}}</label>
                                    <select class="js-data-example-ajax form-control w-100" id="Emp" name="Executor">
                                    </select>
                                </div>
                                @else

                                <input type="hidden" name="Executor">
                                @endif

                                @else

                                @if($Def->ExecuteEmp == 0)

                                <input type="hidden" name="Executor" value="{{auth()->guard()->user()->executor}}">

                                @else


                                @if($show->Executor_Sale == 1)

                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Executor')}}</label>
                                    <select class="js-data-example-ajax form-control w-100" id="Emp" name="Executor">
                                    </select>
                                </div>
                                @else

                                <input type="hidden" name="Executor">
                                @endif




                                @endif


                                @endif
                                @if($show->Refrence_Number == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Refrence_Number')}}</label>
                                    <input type="text" name="Refernce_Number" value="{{old('Refernce_Number')}}" class="form-control">
                                </div>
                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Refrence_Number')}}</label>
                                    <input type="text" name="Refernce_Number" value="{{old('Refernce_Number')}}" class="form-control">
                                </div>
                                @endif

                                @if($crm->Client_Delegate == 1)
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="">{{trans('admin.Account')}} ({{trans('admin.Client')}})</label>
                                    <select class="select2 form-control w-100" id="client" name="Client" required>
                                        @if(auth()->guard('admin')->user()->emp == 0)
                                        <option value="{{$Def->Client}}">

                                            {{app()->getLocale() == 'ar' ?$Def->Client()->first()->Name :$Def->Client()->first()->NameEn}}
                                        </option>
                                        @endif
                                    </select>
                                </div>
                                @else
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="">{{trans('admin.Account')}} ({{trans('admin.Client')}})</label>
                                    <select class="select2 form-control w-100" id="client" name="Client" required>

                                        <option value="{{$Def->Client}}"> {{app()->getLocale() == 'ar' ?$Def->Client()->first()->Name :$Def->Client()->first()->NameEn}}

                                        </option>

                                    </select>
                                </div>
                                @endif


                                @can('ايقونه اضافه عميل')
                                <div class="form-group col-lg-1">
                                    <button style="margin: 22px" type="button" class="btn btn-default" data-toggle="modal" data-target="#NewClient">
                                        <i class="fal fa-user"></i>
                                    </button>
                                    <!-- Modal New Client -->
                                    <div class="modal fade" id="NewClient" tabindex="-1" role="dialog" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-body row">
                                                        <div class="form-group col-md-2">
                                                            <label class="form-label" for="simpleinput"> {{trans('admin.Code')}}</label>
                                                            <input type="text" id="CODE" value="{{$CodeUser}}" disabled class="form-control">
                                                        </div>
                                                        <div class="form-group col-md-2">
                                                            <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Name')}} </label><span class="strick">*</span>
                                                            <input type="text" id="Name" value="{{old('Name')}}" class="form-control">
                                                        </div>
                                                        <div class="form-group col-md-2">
                                                            <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}} </label><span class="strick">*</span>
                                                            <input type="text" id="NameEn" value="{{old('NameEn')}}" class="form-control">
                                                        </div>
                                                        <div class="form-group col-md-3">
                                                            <label class="form-label" for="simpleinput"> {{trans('admin.Phone')}} </label><span class="strick">*</span>
                                                            <input type="number" id="Phone" value="{{old('Phone')}}" class="form-control">
                                                        </div>
                                                        <div class="form-group col-md-3">
                                                            <label class="form-label" for=""> {{trans('admin.Price_Level')}} </label><span class="strick">*</span>
                                                            <select class="select2 form-control w-100" id="PriceLevel">
                                                                <option value="1"> {{trans('admin.Level1')}} </option>
                                                                <option value="2"> {{trans('admin.Level2')}} </option>
                                                                <option value="3"> {{trans('admin.Level3')}} </option>
                                                            </select>
                                                        </div>
                                                    </h4>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                                    </button>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                                                    <button type="button" onclick="NewClients()" class="btn btn-primary"> {{trans('admin.AddNew')}}</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endcan

                                @can('خانه رصيد حساب العميل') @php $credStyle="block"; @endphp @endcan
                                <div class="form-group col-lg-2" style="display: {{$credStyle}}">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Account_Credit')}} </label>
                                    <input type="text" id="AccountCredit" name="Current_Credit" value="0" class="form-control " readonly>
                                </div>

                                <div class="form-group col-lg-2" style="display: {{$credStyle}}">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Credit_Limit')}} </label>
                                    <input type="text" id="Credit_Limit"  value="0" class="form-control " readonly>
                                </div>
                                
                                
                                       @if($Def->Warranty_Expire_Date == 1)
                                  <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Warranty_Expire_Date')}}</label>
                                    <input type="date" name="Warranty_Expire_Date" value="{{old('Warranty_Expire_Date')}}" class="form-control">
                                </div>
                                @endif
                                
                                

                                @if($show->Shipping_Company == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Shipping_Compaines')}}</label>
                                    <select class="select2 form-control w-100" name="Ship">
                                        <option value=""> {{trans('admin.Shipping_Compaines')}}</option>
                                        @foreach($Shippings as $ship)
                                        <option value="{{$ship->id}}">

                                            {{app()->getLocale() == 'ar' ?$ship->Name :$ship->NameEn}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for="">{{trans('admin.Shipping_Compaines')}}</label>
                                    <select class="select2 form-control w-100" name="Ship">
                                        <option value=""> {{trans('admin.Shipping_Compaines')}}</option>
                                        @foreach($Shippings as $ship)
                                        <option value="{{$ship->id}}">
                                            {{app()->getLocale() == 'ar' ?$ship->Name :$ship->NameEn}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @endif
                                @if($show->Note == 1)
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Notes')}} </label>
                                    <input type="text" name="Note" value="{{old('Note')}}" class="form-control">
                                </div>
                                @else
                                <div class="form-group col-lg-4" style="display: none">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Notes')}} </label>
                                    <input type="text" name="Note" value="{{old('Note')}}" class="form-control">
                                </div>
                                @endif



                                @if($show->Show_File_Sales == 1)
                                <div class="form-group col-lg-12">
                                    <label class="form-label" for="simpleinput">{{trans('admin.File')}}</label>
                                    <input type="file" name="File" class="form-control">
                                </div>
                                @endif
                                
                                  @if($show->Shipping_Price == 1)
                                
                                          <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Shipping_Price')}}</label>
                                    <input type="number" step="any" name="Shipping_Price" value="{{old('Shipping_Price')}}" class="form-control">
                                </div> 
                                @endif
                                
                                
                             
                                

                                
                                
                         @if($Place == 'Quote')     
                                
                        

                                    @if($Def->Quote_Email == 1) 
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Email')}}</label>
                                    <input type="email" name="Email" value="{{old('Email')}}" class="form-control">
                                </div>
                                @endif
                                    
                               @if($Def->Quote_Phone == 1)     
                                             <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Phone')}}</label>
                                    <input type="tel" name="Phone" value="{{old('Phone')}}" class="form-control">
                                </div>
                                @endif
                                      
                                
                              @if($Def->Quote_Expire_Date == 1)       
                                             <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Expire_Date')}}</label>
                                    <input type="date" name="Expire_Date" value="{{old('Expire_Date')}}" class="form-control">
                                </div>
                                @endif
                                             
                            @if($Def->Quote_Care == 1)         
                                             <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Care')}}</label>
                                    <input type="text" name="Care" value="{{old('Care')}}" class="form-control">
                                </div>
                                @endif
                                             
                                
                              @if($Def->Quote_Location == 1)      
                                             <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Location')}}</label>
                                    <input type="text" name="Location" value="{{old('Location')}}" class="form-control">
                                </div>
                                @endif
                                
                                  @if($Def->Quote_Desc == 1) 
                                             <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Desc')}}</label>
                                    <input type="text" name="Desc" value="{{old('Desc')}}" class="form-control">
                                </div>
                                @endif
                                
                              @endif  
                                





                                
                                
                                

                            </div>
                            <div class="form-row">

                            </div>


                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-container show">
                        <div class="panel-content" style="background: #fad2f796;">
                            <div class="row">
                                @if($show->SearchCode == 1)
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> </label>
                                    <div class="input-items" style="position:relative;">
                                        <input type="text" id="search" class="form-control" placeholder="{{trans('admin.Search_For_Products')}}">
                                        @if(app()->getLocale() == 'ar' )
                                        <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;left:3px;"></i>
                                        @else
                                        <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;right: 0;left:auto;"></i>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> </label>
                                    <div class="input-items" style="position:relative;">
                                        <input type="text" id="SearchCode" class="form-control" placeholder="{{trans('admin.SearchCode')}}">
                                        @if(app()->getLocale() == 'ar' )
                                        <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;left:3px;"></i>
                                        @else
                                        <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;right: 0;left:auto;"></i>
                                        @endif
                                    </div>
                                </div>
                                @else
                                <div class="form-group col-lg-6">
                                    <label class="form-label" for="simpleinput"> </label>
                                    <div class="input-items" style="position:relative;">
                                        <input type="text" id="search" class="form-control" placeholder="{{trans('admin.Search_For_Products')}}">
                                        @if(app()->getLocale() == 'ar' )
                                        <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;left:3px;"></i>
                                        @else
                                        <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;right: 0;left:auto;"></i>
                                        @endif
                                    </div>
                                </div>
                                @endif

                                @if($show->Group_Brand == 1)
                                <div class="form-group col-lg-2 mt-3">
                                    <select class="select2 form-control w-100" id="Brandd">
                                        <option value="">{{trans('admin.Brand')}}</option>
                                        @foreach($Brands as $brand)
                                        <option value="{{$brand->id}}"> {{app()->getLocale() == 'ar' ?$brand->Name :$brand->NameEn}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-lg-2 mt-3">
                                    <select class="select2 form-control w-100" id="Groupp">
                                        <option value="">{{trans('admin.Group')}}</option>
                                        @foreach($ItemsGroups as $group)
                                        <option value="{{$group->id}}">
                                            {{app()->getLocale() == 'ar' ?$group->Name :$group->NameEn}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @endif
                                @if($show->Icon_Payment_Recipt == 1)
                                @can('اضافه سند قبض')
                                <div class="form-group col-lg-1 col-2">
                                    <button type="button" class="btn btn-default pos-icon" data-toggle="modal" data-target="#Recipt">
                                        <a data-toggle="tooltip" data-placement="top" title="{{trans('admin.Recipt_Voucher')}}">
                                            <img src="{{asset('Admin/img/37-approve-checked-simple-outline.gif')}}" alt="">
                                        </a>
                                    </button>
                                </div>
                                @endcan
                                @can('اضافه سند صرف')
                                <div class="form-group col-lg-1 col-2">
                                    <button type="button" class="btn btn-default pos-icon" data-toggle="modal" data-target="#PayVouch">
                                        <a data-toggle="tooltip" data-placement="top" title="{{trans('admin.Payment_Voucher')}}">
                                            <img src="{{asset('Admin/img/290-coin-outline (1).gif')}}" alt="">
                                        </a>
                                    </button>
                                </div>
                                @endcan
                                @endif
                            </div>
                            <div id="mobile-overflow">
                                <table class="table table-bordered table-hover table-striped w-100 mobile-width-more table-color1 mt-2">
                                    <thead>
                                        <tr>
                                            <th>{{trans('admin.Name')}}</th>
                                            @if($show->Show_Unit == 1)
                                                <th>{{trans('admin.Unit')}}</th>
                                            @endif

                                            @if($show->Show_Barcode == 1)
                                                <th>{{trans('admin.Code')}}</th>
                                            @endif

                                        @if($show->Patch_Number == 1)
                                            <th>{{trans('admin.Patch_Number')}}</th>
                                            @endif
                                            @if($show->AvQty == 1)
                                            <th>{{trans('admin.AvQty')}}</th>
                                            @endif
                                            <th>{{trans('admin.Qty')}}</th>
                                            <th>{{trans('admin.Price')}}</th>
                                            @if($show->Disc == 1)
                                            <th>{{trans('admin.Discount')}}</th>
                                            @endif
                                            @if($show->Tax == 1)
                                            <th>{{trans('admin.Tax')}}</th>
                                            @endif
                                            @if($show->Store == 1)
                                            <th style="padding:12px 20px;">{{trans('admin.Store')}}</th>
                                            @endif
                                            @if($show->Expire_Date == 1)
                                            <th>{{trans('admin.Exp_Date')}}</th>
                                            @endif

                                            @if($show->Sales_Pro_Desc == 1)
                                            <th>{{trans('admin.Desc')}}</th>
                                            @endif
                                            <th>{{trans('admin.Actions')}}</th>
                                        </tr>
                                    </thead>
                                    <tbody class="Data" id="Data">
                                    </tbody>
                                </table>
                            </div>
                            <!-- datatable start -->
                            <div id="mobile-overflow">
                                <table id="dt" class="table table-bordered table-hover table-striped w-100 mobile-width-more table-color2">
                                    <thead>
                                        <tr>
                                            <th>{{trans('admin.Name')}}</th>
                                            @if($show->Show_Unit == 1)
                                                <th>{{trans('admin.Unit')}}</th>
                                            @endif

                                            @if($show->Show_Barcode == 1)
                                                <th>{{trans('admin.Code')}}</th>
                                            @endif

                                            @if($show->Patch_Number == 1)
                                            <th>{{trans('admin.Patch_Number')}}</th>
                                            @endif
                                            @if($show->AvQty == 1)
                                            <th>{{trans('admin.AvQty')}}</th>
                                            @endif
                                            <th>{{trans('admin.Qty')}}</th>
                                            <th>{{trans('admin.Price')}}</th>
                                            @if($show->Disc == 1)
                                            <th>{{trans('admin.Discount')}}</th>
                                            @endif
                                            @if($show->TotalBfTax == 1)
                                            <th>{{trans('admin.Total_Bf_Taxes')}}</th>
                                            @endif
                                            @if($show->Tax == 1)
                                            <th>{{trans('admin.Tax')}}</th>
                                            @endif
                                            @if($show->Show_Total == 1)
                                                <th>{{trans('admin.Total')}}</th>
                                            @endif

                                            @if($show->Show_Net == 1)
                                                <th>{{trans('admin.The_Net')}}</th>
                                            @endif


                                        @if($show->Store == 1)
                                            <th>{{trans('admin.Store')}}</th>
                                            @endif
                                            @if($show->Expire_Date == 1)
                                            <th>{{trans('admin.Exp_Date')}}</th>
                                            @endif
                                            @if($show->Sales_Pro_Desc == 1)
                                            <th>{{trans('admin.Desc')}}</th>
                                            @endif
                                            <th>{{trans('admin.Actions')}}</th>
                                        </tr>
                                    </thead>
                                    <tbody id="data-dt">
                                    </tbody>
                                </table>
                            </div>
                            <!-- datatable end -->

                            <div id="Install" style="display: none">
                                <div class="row">
                                    <div class="form-group col-lg-3">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Presenter')}}</label>
                                        <input type="number" onclick="Install()" onkeyup="Install()" step="any" id="presenter" name="presenter" value="{{old('presenter')}}" class="form-control">
                                    </div>
                                    <div class="form-group col-lg-3">
                                        <label class="form-label" for="simpleinput">{{trans('admin.annual_interest')}}</label>
                                        <input type="number" step="any" onclick="Install()" onkeyup="Install()" id="annual_interest" name="annual_interest" value="{{old('annual_interest')}}" class="form-control" @if($Def->InstallmentSystem == 1) readonly @endif>
                                    </div>
                                    <div class="form-group col-lg-3">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Years_Number')}}</label>
                                        <input type="number" step="any" onclick="Install()" onkeyup="Install()" id="Years_Number" name="Years_Number" value="{{old('Years_Number')}}" class="form-control" @if($Def->InstallmentSystem == 1) readonly @endif>
                                    </div>
                                    <div class="form-group col-lg-3">
                                        <label class="form-label" for="simpleinput">{{trans('admin.total')}}</label>
                                        <input type="number" onclick="Install()" onkeyup="Install()" step="any" id="total" name="total" value="{{old('total')}}" class="form-control" readonly>
                                    </div>
                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Date_First_installment')}}</label>
                                        <input type="date" onchange="Install()" name="Date_First_installment" id="Date_First_installment" value="{{old('Date_First_installment')}}" class="form-control">
                                    </div>
                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="simpleinput">{{trans('admin.monthly_installment')}}</label>
                                        <input type="number" step="any" onclick="Install()" onkeyup="Install()" id="monthly_installment"  name="monthly_installment" value="{{old('monthly_installment')}}" class="form-control" @if($Def->InstallmentSystem == 0) readonly @endif >

                                    </div>
                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="simpleinput">{{trans('admin.installment_Num')}}</label>
                                        <input type="number" step="any" onclick="Install()" onkeyup="Install()" name="installment_Num" id="installment_Num" value="{{old('installment_Num')}}" class="form-control" @if($Def->InstallmentSystem == 0) readonly @endif >

                                    </div>
                                </div>
                            </div>
                            <div id="CHECK" style="display: none">
                                <div class="row">
                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="">{{trans('admin.Check_Type')}}</label>
                                        <select class="select2 form-control w-100" id="Check_Type" name="Check_Type">
                                            <option value=""> {{trans('admin.Check_Type')}}</option>
                                            @foreach($ChecksTypes as $type)
                                            <option value="{{$type->id}}">
                                                {{app()->getLocale() == 'ar' ?$type->Arabic_Name :$type->English_Name}}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Due_Date')}} </label>
                                        <input type="date" id="Due_Date" value="{{old('Due_Date')}}" class="form-control" name="Due_Date">
                                    </div>
                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Check_Number')}} </label>
                                        <input type="number" id="Check_Number" step="any" value="{{old('Check_Number')}}" class="form-control" name="Check_Number">
                                    </div>
                                </div>
                            </div>
                            <div id="CompInstall" style="display: none">
                                <div class="row">

                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="">{{trans('admin.InstallCompany')}}</label>
                                        <select class="select2 form-control w-100" name="InstallCompany" id="InstallCompany" onchange="InstaallComp()">
                                            <option value=""> {{trans('admin.InstallCompany')}}</option>
                                            @foreach($InstallmentCompanies as $inst)
                                            <option value="{{$inst->id}}">
                                                {{app()->getLocale() == 'ar' ?$inst->Arabic_Name :$inst->English_Name}}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="simpleinput">{{trans('admin.ContractNumber')}} </label>
                                        <input type="text" name="ContractNumber" id="ContractNumber" value="{{old('ContractNumber')}}" class="form-control">
                                    </div>



                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="">{{trans('admin.PayFees')}}</label>
                                        <select class="select2 form-control w-100" id="PayFees" name="PayFees">
                                            <option value="No"> {{trans('admin.No')}}</option>
                                            <option value="Yes"> {{trans('admin.Yes')}}</option>
                                        </select>
                                    </div>


                                    @can('رسوم خدمات شركات التقسيط') @php $Style='block'; @endphp @endcan

                                    <div class="form-group col-lg-4" style="display: {{$Style}}">
                                        <label class="form-label" for="simpleinput">{{trans('admin.ServiceFee')}} </label>
                                        <input type="text" name="ServiceFee" id="ServiceFee" value="{{old('ServiceFee')}}" class="form-control" readonly>
                                    </div>


                                    <div class="form-group col-lg-4" style="display: {{$Style}}">
                                        <label class="form-label" for="simpleinput">{{trans('admin.CompanyPrecent')}} </label>
                                        <input type="text" name="CompanyPrecent" id="CompanyPrecent" value="{{old('CompanyPrecent')}}" class="form-control" readonly>
                                    </div>

                                    <div class="form-group col-lg-4" style="display: {{$Style}}">
                                        <label class="form-label" for="simpleinput">{{trans('admin.TotalServiceFee')}} </label>
                                        <input type="text" id="TotalServiceFee" class="form-control" readonly>
                                    </div>



                                </div>
                            </div>



                            <div class="form-row">
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Product_Numbers')}} </label>
                                    <input type="text" id="Product_Numbers" disabled class="form-control">
                                    <input type="hidden" id="Product_NumbersHide" name="Product_Numbers">
                                </div>
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_Qty')}} </label>
                                    <input type="text" id="Total_Qty" disabled class="form-control">
                                    <input type="hidden" id="Total_QtyHide" name="Total_Qty">
                                </div>
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_Price')}}</label>
                                    <input type="text" id="Total_Price" disabled class="form-control">
                                    <input type="hidden" id="Total_PriceHide" name="Total_Price">
                                    <input type="hidden" id="Total_Bf_Taxes" disabled class="form-control">
                                    <input type="hidden" id="Total_Bf_TaxesHide" name="Total_BF_Taxes">
                                    <input type="hidden" id="Total_Discount" disabled class="form-control">
                                    <input type="hidden" id="Total_DiscountHide" name="Total_Discount">
                                    <input type="hidden" id="TotalCost" name="Total_Cost">
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_Taxes')}}</label>
                                    <input type="text" id="Total_Taxes" disabled class="form-control">
                                    <input type="hidden" id="Total_TaxesHide" name="Total_Taxes">
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_After_Taxes')}}</label>
                                    <input type="text" id="Total_After_Taxes" disabled class="form-control">
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_Discount')}} </label>
                                    <input type="text" id="Total_DiscountTT" disabled class="form-control">
                                    <input type="hidden" id="Total_DiscountHideTT" name="Total_Discount">
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_af_Discount')}} </label>
                                    <input type="text" class="form-control" id="TAFterD" disabled>
                                </div>

                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_Bill')}} </label>
                                    <input type="text" id="Total_Bill" disabled class="form-control">
                                </div>


                    @if(auth()->guard('admin')->user()->emp == 0)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Discount_Bill')}} </label>
                                    <input type="text" class="form-control" id="resdiual" name="DiscountBill" value="0" onkeyup="Statuss()">
                                </div>
                                @else

                                    <div class="form-group col-lg-2" @if(auth()->guard('admin')->user()->bill_discount == 0) style="display: none" @endif >
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Discount_Bill')}} </label>
                                        <input type="text" class="form-control" id="resdiual" name="DiscountBill" value="0" onkeyup="Statuss()">
                                    </div>

                                @endif
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_Net')}} </label>
                                    <input type="text" class="form-control" id="Total_PriceW" disabled>
                                </div>
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Paid')}} </label>
                                    <input type="number" step="any" name="Pay" id="paid" onkeyup="PayInstall()" onclick="PayInstall()" class="form-control">

                                </div>


                                @php $d='none'; @endphp
                                @can('نسبه الربح') @php $d='block'; @endphp    @endcan
                                <div class="form-group col-lg-2" style="display: {{$d}}">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Profit')}} </label>
                                    <input type="number" step="any" name="ProfitPrecent" id="ProfitPrecent" class="form-control" value="0" readonly>

                                </div>
                                    <div class="form-group col-lg-2" style="display: {{$d}}">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.ProfitPrecent')}} %</label>
                                        <input type="number" step="any"  id="proPrecent" class="form-control" value="0" readonly>
                                    </div>



                                @if($show->TaxOnTotal == 1)
                                    <div class="form-group col-lg-3">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.TaxOnTotal')}} </label>
                                        <select class="select2 form-control" name="TaxOnTotal" id="TaxOnTotal" onchange="TaxOnChange()">
                                            <option value="No">{{trans('admin.No')}}</option>
                                            <option value="Yes">{{trans('admin.Yes')}}</option>
                                        </select>
                                    </div>

                                    <div class="form-group col-lg-3" id="TaxTypeOnTotal" style="display: none">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.TaxOnTotalType')}} </label>
                                        <select class="select2 form-control" name="TaxOnTotalType" id="TaxOnTotalType" onchange="TaxOn()">
                                            <option value="">{{trans('admin.TaxOnTotalType')}}</option>
                                            @foreach($Taxes as $tax)
                                                <option value="{{$tax->id}}"> {{app()->getLocale() == 'ar' ?$tax->Name :$tax->NameEn}}</option>
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="form-group col-lg-3" id="TaxProfitOnTotal" style="display: none">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.ProfitTax')}} </label>
                                        <input type="text" class="form-control" id="ProfitTax" name="ProfitTax" value="0" readonly>
                                    </div>
                                @endcan


                                @if($Def->Total_Wight_Bill == 1)
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_Wight_Bill')}} </label>
                                    <input type="number" step="any" name="Total_Wight_Bill" id="Total_Wight_Bill" class="form-control" value="0" readonly>

                                </div>
                                @endif
                            </div>
                            <div class="buttons mt-3" id="Submit" style="display: none">
                                <input type="hidden" id="sp" name="SP">
                                <button type="button" class="btn btn-primary" onclick="SPS()"> <i class="fal fa-folder"></i> {{trans('admin.Save')}} </button>
                                @if($show->A4 == 1)
                                <button type="button" class="btn btn-primary" onclick="SPP()"><i class="fal fa-save"></i> {{trans('admin.SaveandPrint')}} </button>
                                @endif
                                @if($show->CM8 == 1)
                                <button type="button" class="btn btn-primary" onclick="SPP8()"><i class="fal fa-save"></i> {{trans('admin.SaveandPrint8')}} </button>
                                @endif
                                @if($show->A5 == 1)
                                <button type="button" class="btn btn-primary" onclick="SPP5()"><i class="fal fa-save"></i> {{trans('admin.SaveandPrintA5')}} </button>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <input type="hidden" id="ED" value="{{$show->Expire_Date}}">
    <input type="hidden" id="DISCSHOW" value="{{$show->Disc}}">
    <input type="hidden" id="TOTBFSHOW" value="{{$show->TotalBfTax}}">
    <input type="hidden" id="TAXSHOW" value="{{$show->Tax}}">
    <input type="hidden" id="STORESHOW" value="{{$show->Store}}">
    <input type="hidden" id="AVQTYSHOW" value="{{$show->AvQty}}">
    <input type="hidden" id="Sales_Pro_Desc" value="{{$show->Sales_Pro_Desc}}">
    <input type="hidden" id="InstallmentSystem" value="{{$Def->InstallmentSystem}}">

    <input type="hidden" id="Show_Unit" value="{{$show->Show_Unit}}">
    <input type="hidden" id="Show_Barcode" value="{{$show->Show_Barcode}}">
    <input type="hidden" id="Show_Total" value="{{$show->Show_Total}}">
    <input type="hidden" id="Show_Net" value="{{$show->Show_Net}}">
    <input type="hidden" id="SHW" value="0">
    @if($Def->Price_Sale == 0)
    @if(auth()->guard('admin')->user()->emp != 0)
    @if(auth()->guard('admin')->user()->price_sale == 1)
    <input type="hidden" id="PRICEOPEN" value="1">
    @else
    <input type="hidden" id="PRICEOPEN" value="0">
    @endif
    @else
    <input type="hidden" id="PRICEOPEN" value="0">
    @endif
    @else
    @if(auth()->guard('admin')->user()->emp != 0)
    @if(auth()->guard('admin')->user()->price_sale == 1)
    <input type="hidden" id="PRICEOPEN" value="1">
    @else
    <input type="hidden" id="PRICEOPEN" value="0">
    @endif
    @else
    <input type="hidden" id="PRICEOPEN" value="1">
    @endif
    @endif
    @if(auth()->guard('admin')->user()->emp != 0)
    @if(auth()->guard('admin')->user()->discount == 1)
    <input type="hidden" id="DISCOPEN" value="1">
    @else
    <input type="hidden" id="DISCOPEN" value="0">
    @endif
    @else
    <input type="hidden" id="DISCOPEN" value="1">
    @endif
    @if($show->Patch_Number == 1)
    <input type="hidden" id="Patch" value="1">
    @else
    <input type="hidden" id="Patch" value="0">
    @endif
    @if($Def->Discount == 0)
    <input type="hidden" id="DIS" value="0"> <!-- Number -->
    @else
    <input type="hidden" id="DIS" value="1"> <!-- Precent -->
    @endif
    <!--         Recipt Voucher modal -->
    <div class="modal fade" id="Recipt" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Receipt_Voucher')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-3">
                            <label>{{trans('admin.Creditor')}}</label>
                            <input type="number" step="any" class="form-control" id="Creditor">
                        </div>
                        <div class="col-md-3">
                            <label>{{trans('admin.Account')}}</label>
                            <select class="select2 form-control w-100" id="AccountCodeF">
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Store')}}</label>
                            <select class="select2 form-control w-100" id="STOREF">
                                @foreach($Stores as $stor)
                                <option value="{{$stor->id}}" @if($Def->Store == $stor->id) selected @endif>

                                    {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                            <select class="select2 form-control w-100" id="SafeF">
                                @foreach($Safes as $safe)
                                <option value="{{$safe->id}}" @if($Def->Safe == $safe->id) selected @endif>
                                    {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                </option>
                                @endforeach
                            </select>
                        </div>

                        @if(auth()->guard('admin')->user()->emp == 0)
                            <div class="form-group col-lg-4">
                                <label class="form-label" for="">{{trans('admin.Collector')}}</label>
                                <select class="select2 form-control w-100" id="Collector">
                                    <option value="">{{trans('admin.Collector')}}</option>
                                    @foreach($Employess as $emp)
                                        <option value="{{$emp->id}}">

                                            {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        @else
                            <input type="hidden"  id="Collector" value="{{auth()->guard('admin')->user()->emp}}" class="form-control" />
                        @endif



                        <input type="hidden" id="CoinF" value="{{$Def->Coin}}">
                        <input type="hidden" id="DrawF" value="{{$Def->Draw}}">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                    <button type="button" class="btn btn-secondary" id="ReciptVoucher"> {{trans('admin.Save')}}</button>
                </div>
            </div>
        </div>
    </div>
    <!--         Payment Voucher modal -->
    <div class="modal fade" id="PayVouch" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Payment_Voucher')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-3">
                            <label>{{trans('admin.Debitor')}}</label>
                            <input type="number" step="any" class="form-control" id="Debitor">
                        </div>
                        <div class="col-md-3">
                            <label>{{trans('admin.Account')}}</label>
                            <select class="select2 form-control w-100" id="AccountCodee">
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Store')}}</label>
                            <select class="select2 form-control w-100" id="STOREP">
                                @foreach($Stores as $stor)
                                <option value="{{$stor->id}}" @if($Def->Store == $stor->id) selected @endif>
                                    {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                            <select class="select2 form-control w-100" id="SafeP">
                                @foreach($Safes as $safe)
                                <option value="{{$safe->id}}" @if($Def->Safe == $safe->id) selected @endif>
                                    {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <input type="hidden" id="CoinP" value="{{$Def->Coin}}">
                        <input type="hidden" id="DrawP" value="{{$Def->Draw}}">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                    <button type="button" class="btn btn-secondary" id="PaymentVoucher"> {{trans('admin.Save')}}</button>
                </div>
            </div>
        </div>
    </div>
</main>


@if(app()->getLocale() == 'ar' )
<input type="hidden" id="LANG" value="ar">
@else
<input type="hidden" id="LANG" value="en">
@endif


<input type="hidden" id="LOWCOSTPRICE" value="{{$Def->SalesLowCostPrice}}">
<input type="hidden" id="LimitSalesQty" value="{{$Def->LimitSalesQty}}">
<input type="hidden" id="Duplicate_Items" value="{{$Def->Duplicate_Items}}">
<input type="hidden" id="RATOO" value="0">
<input type="hidden" id="DEFAULTCOSTPRICE" value="{{$FCOST->Cost_Price}}">
<input type="hidden" id="SHOWHIDEPRO" value="{{$Def->Hide_Product}}">


@endsection
@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script src="{{asset('Admin/js/ERP/Sales.js')}}"></script>

<script>
    function TaxOnChange(){
        
        var TaxOnTotal=$('#TaxOnTotal').val();
        
        
        if(TaxOnTotal == 'Yes'){
           
           document.getElementById('TaxTypeOnTotal').style.display='block';
           document.getElementById('TaxProfitOnTotal').style.display='block';
           
           }else{
               
           document.getElementById('TaxTypeOnTotal').style.display='none';
           document.getElementById('TaxProfitOnTotal').style.display='none';      
               
           }
        
        
    }






</script>
@endpush
