<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title> {{$title}}</title>
  <link rel="stylesheet" href="style.css">
</head>
<style>

@import url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap');

body {
  font-family: 'Cairo', sans-serif;
  direction: rtl;
  background: #fff;
  margin: 0;
  padding: 30px;
  color: #333;
  line-height: 1.3;
}

.container {
  border: 1px solid #ddd;
  padding: 20px;
  max-width: 900px;
  margin: auto;
  background: #fff;
}

/* ===== Grid الرأس ===== */
.header-grid {
  display: grid;
  grid-template-columns: repeat(12, 1fr);
  align-items: start;
  margin-bottom: 0;
  gap: 10px;
}

.logo {
  grid-column: span 4;
  display: flex;
  justify-content: center;
  align-items: center;
  text-align: center;
}

.logo img {
  width: 120px;
  height: 120px;
  object-fit: contain;
}

/* القسم الأيسر (العنوان + التفاصيل) */
.title-section {
  grid-column: span 8;
}

/* ===== العنوان ===== */
.title-box {
  background: #d9edf7;
  text-align: center;
  padding: 6px 0;
  border-radius: 3px;
  margin-bottom: 6px;
  display: inline-block;
  width: 100%;
}

.title-box h1 {
  margin: 0;
  font-size: 22px;
  font-weight: 700;
  color: #000;
}

/* ===== بيانات عرض السعر ===== */
.quote-info {
  display: flex;
  flex-wrap: wrap;
  gap: 3px 15px;
  border-bottom: 2px solid #bcd;
  padding-bottom: 8px;
  font-size: 13px;
}

.quote-info p {
  width: calc(50% - 8px);
  margin: 0;
  text-align: right;
  line-height: 1.2; /* تقليل المسافة بين السطور */
}

/* ===== بيانات الأطراف بتقسيم Grid ===== */
.parties-grid {
  display: grid;
  grid-template-columns: repeat(12, 1fr);
  gap: 10px;
  border-bottom: 1px solid #eee;
  padding-bottom: 10px;
  margin-top: 5px;
}

/* العناوين */
.from-title { grid-column: span 2; }
.to-title { grid-column: span 2; }

/* بيانات الأطراف */
.from-data { grid-column: span 4; }
.to-data { grid-column: span 4; }

/* ستايل العناوين */
.from-title h3,
.to-title h3 {
  background: #e6f0fa;
  padding: 3px 8px;
  font-size: 14px;
  border-radius: 3px;
  margin: 0 0 4px 0; /* مسافة صغيرة تحت العنوان */
}

/* ستايل البيانات */
.from-data p,
.to-data p {
  margin: 2px 0;
  font-size: 13px;
  line-height: 1.2; /* تقليل المسافة بين السطور */
}

/* ===== إعدادات الطباعة ===== */
@media print {
  body { background: #fff; }
  .container { border: none; margin: 0; padding: 0; }
  .title-box { background: #d9edf7 !important; -webkit-print-color-adjust: exact; print-color-adjust: exact; }
  .from-title h3, .to-title h3 { background: #e6f0fa !important; -webkit-print-color-adjust: exact; print-color-adjust: exact; }
}

.items-table {
  margin-top: 20px;
  overflow-x: auto;
}

.items-table table {
  width: 100%;
  border-collapse: collapse;
  font-size: 13px;
}

.items-table th,
.items-table td {
  border: 1px solid #ddd;
  padding: 8px;
  text-align: right; /* لأن الصفحة RTL */
}

.items-table th {
  background: #e6f0fa;
  font-weight: 700;
}

.items-table tr:nth-child(even) {
  background: #f9f9f9;
}

/* إعدادات الطباعة */
@media print {
  .items-table th {
    background: #e6f0fa !important;
    -webkit-print-color-adjust: exact;
    print-color-adjust: exact;
  }
}

.summary-table table {
  width: 100%;
  border-collapse: collapse;
  font-size: 13px;
  text-align: right; /* RTL */
}

.summary-table td {
  border: 1px solid #ddd;
  padding: 8px;
}

.summary-table tr:nth-child(even) {
  background: #f9f9f9;
}
.notes-section p {
  margin: 5px 0 0 0;
  font-size: 13px;
  line-height: 1.3;
}

</style>
<body>

<div class="container">

  <!-- ====== الرأس (اللوجو + عنوان عرض السعر + بياناته) ====== -->
  <div class="header-grid">

    <!-- اللوجو -->
    <div class="logo">
      <img src="{{URL::to($Def->Logo)}}" alt="شعار المؤسسة">
    </div>

    <!-- العنوان + بيانات عرض السعر -->
    <div class="title-section">
      <div class="title-box">
        <h1> {{$title}}</h1>
      </div>

      <div class="quote-info">
        <p><strong>{{trans('admin.Code')}}:</strong> {{$item->Code}}</p>
        <p><strong>{{trans('admin.Desc')}} :</strong>  {{$item->Desc}}</p>
        <p><strong>{{trans('admin.Date')}}:</strong> {{$item->Date}}</p>
        <p><strong> {{trans('admin.Expire_Date')}}:</strong> {{$item->Expire_Date}}</p>
        <p><strong>{{trans('admin.Location')}}:</strong>  {{$item->Location}}</p> 
        <p><strong>{{trans('admin.Care')}} :</strong>   {{$item->Care}}</p> 
        <p><strong> {{trans('admin.Phone')}} :</strong> {{$item->Phone}} </p> 
        <p><strong>{{trans('admin.Email')}}  :</strong> {{$item->Email}} </p> 
      </div>
    </div>

  </div>

  <!-- ====== بيانات المصدر والوجهة بتقسيم Grid ====== -->
  <div class="parties-grid">
    <div class="from-title">
      <h3> {{trans('admin.Export_From')}}:</h3>
    </div>
    <div class="from-data">
      <p><strong>
               @if(!empty($Def->Name))
                                                    {{app()->getLocale() == 'ar' ?$Def->Name :$Def->NameEn}}
                                                @else
                                                    {{trans('admin.Klar')}}
                                                @endif
          
          </strong></p>
        
      <p>{{$Def->Organaziation_Tax_ID}}</p>
      <p>{{app()->getLocale() == 'ar' ?$Def->Address :$Def->AddressEn}} </p>
      <p>{{$Def->Phone}}</p>
      <p>{{$Def->Email}}</p>
    </div>

      

  
    <div class="to-title">
      <h3> {{trans('admin.Export_To')}}:</h3>
    </div>
    <div class="to-data">
      <p><strong> {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}</strong></p>
        
          @if(!empty($cust))
      <p>{{$cust->Tax_Card_No}}</p>
      <p>{{$cust->Address}}</p>
      <p>{{$cust->Phone}}</p>
      <p>{{$cust->Email}}</p>
        @endif
      



    </div>
  </div>
<!-- ====== جدول الأصناف ====== -->
<div class="items-table">
  <table>
    <thead>
      <tr>
        <th>#</th>
        <th>{{trans('admin.Name')}}</th>
        <th>{{trans('admin.Desc')}}</th>
        <th>{{trans('admin.Unit')}}</th>
        <th>{{trans('admin.Qty')}}</th>
        <th>{{trans('admin.Price')}}</th>
        <th>{{trans('admin.Total')}}</th>
      </tr>
    </thead>
    <tbody>
        
           @php $i=1; @endphp
         @foreach($details as $detail)    
      <tr>
        <td>{{$i}}</td>
        <td> 
                    {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}

                   @if(!empty($detail->V1))
                   ({{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}})
                   @endif
                   @if(!empty($detail->V2))
            (({{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}}))
                   @endif  
          
          </td>
        <td>{{$detail->Desc}}</td>
        <td>  {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}</td>
        <td> {{$detail->Qty}}</td>
        <td>  {{$detail->Price}}</td>
        <td> {{$detail->Total_Net}}</td>
      </tr>
        @php $i++; @endphp
        @endforeach

    </tbody>
  </table>
</div>
<!-- ====== جدول الملخص المالي ====== -->
<!-- ====== الملخص والملاحظات ====== -->
<div class="footer-grid" style="display: grid; grid-template-columns: repeat(12, 1fr); gap: 10px; margin-top: 20px;">


  <!-- قسم الملاحظات (8 أعمدة) -->
  <div class="notes-section" style="grid-column: span 8; border: 1px solid #ddd; padding: 10px; min-height: 80px;">
    <strong>{{trans('admin.Notes')}}:</strong>
    <p>{{$item->Note}}</p>
  </div>

    <!-- جدول الملخص المالي (4 أعمدة) -->
  <div class="summary-table" style="grid-column: span 4; overflow-x: auto;">
    <table>
      <tbody>
        <tr>
          <td><strong> {{trans('admin.Total_Price')}}</strong></td>
          <td><span>{{$item->Total_Price}}</span>
        @if(!empty($item->Coin()->first()->Image))    
    <img src="{{URL::to($item->Coin()->first()->Image)}}" alt="رمز" style="width: 18px; height: 18px; object-fit: contain; margin-right: 10px;">
              @endif 
      
            
            </td>
        </tr>
        <tr>
          <td><strong> {{trans('admin.Total_Tax')}}</strong></td>
          <td><span>{{$item->Total_Tax}}</span>
         @if(!empty($item->Coin()->first()->Image))    
    <img src="{{URL::to($item->Coin()->first()->Image)}}" alt="رمز" style="width: 18px; height: 18px; object-fit: contain; margin-right: 10px;">
              @endif 
        
            
            </td>
        </tr>
        <tr>
          <td><strong> {{trans('admin.Total_Net')}}</strong></td>
          <td><span>{{$item->Total_Net}}</span>
       @if(!empty($item->Coin()->first()->Image))    
    <img src="{{URL::to($item->Coin()->first()->Image)}}" alt="رمز" style="width: 18px; height: 18px; object-fit: contain; margin-right: 10px;">
              @endif 
        
            
            </td>
        </tr>
      </tbody>
    </table>
  </div>

   <div class="notes-section" style="grid-column: span 6; border: 1px solid #ddd; padding: 10px; min-height: 80px; position: relative; display: flex; justify-content: center; align-items: center;"> 

  <!-- الشعار في منتصف الصندوق -->
  <img src="{{URL::to($Def->Seal)}}" alt="ختم المؤسسة" style="width: 80px; height: 80px; object-fit: contain;"> 

  <!-- جملة ختم وتوقيع فوق يمين البوكس -->
  <strong style="position: absolute; top: 5px; right: 10px;"> {{trans('admin.PresentQuote')}} </strong> 

</div>

   <div class="notes-section" style="grid-column: span 6; border: 1px solid #ddd; padding: 10px; min-height: 80px;">
     <strong>   {{trans('admin.ApprovalQuote')}} </strong>
   
  </div>
    
    
    
    
    
       <div class="notes">
 
        
        
                 @if(!empty($Def->Print_Text_Footer_Quote))             
                {!! app()->getLocale() == 'ar' ?$Def->Print_Text_Footer_Quote :$Def->Print_Text_Footer_Quote !!}
                 @endif
        
        
    </div>
      
      
      
            <div class="btn-group btn-group-justified row" role="group" aria-label="...">
                  <div class="btn-group col-md-6" role="group">
                     <button onclick="window.print();" class="btn btn-block btn-primary">{{trans('admin.Print')}}</button>
                  </div>
                  <div class="btn-group col-md-6" role="group">
                     <a href="{{ url()->previous() }}" class="btn btn-default" data-dismiss="modal">{{trans('admin.Back')}}</a>
                  </div>
       
               </div>
    
    
</div>

    
    
    
    
    

</div>



</body>
</html>
