@extends('admin.index')
@section('content')

    <title>{{trans('admin.ClientRequests')}}</title>
    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Sales')}} </a></li>
            <li class="breadcrumb-item active">{{trans('admin.ClientRequests')}} </li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
        </ol>
        <form id="form" action="{{url('PostEditClientRequests/'.$item->id)}}" method="post" enctype="multipart/form-data">
            @csrf
            @honeypot
            <input type="hidden" name="Sale_Type" value="Sales">
            <div class="row">
                <div class="col-lg-12">
                    <div id="panel-2" class="panel" >
                        <div class="panel-hdr">
                            <h2>
                                <span class="fw-300"><i> {{trans('admin.ClientRequests')}} </i></span>
                            </h2>
                        </div>
                        <div class="panel-container show">
                            <span id="ex"> @include('admin.layouts.messages')</span>
                            <div class="panel-content">
                                <div class="form-row">
                                    <div class="form-group col-lg-2">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                        <input type="text" value="{{$item->Code}}" class="form-control " disabled>
                                        <input type="hidden" name="Code" value="{{$item->Code}}" class="form-control">
                                      
                                    </div>
                              
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                            <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                                  
                                    </div>
                        
                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="">{{trans('admin.Account')}} ({{trans('admin.Client')}})</label>
                                            <select class="select2 form-control w-100" id="client" name="Client" required>
                                 
                                                @if(!empty($item->Client))
                                                <option value="{{$item->Client}}">   
                                        {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}            
                                                </option>
                                                @endif
                                            </select>
                                        </div>
                         

                       
                                    @can('خانه رصيد حساب العميل') @php $credStyle="block"; @endphp @endcan
                                    <div class="form-group col-lg-2" style="display: {{$credStyle}}">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Account_Credit')}} </label>
                                        <input type="text" id="AccountCredit" name="Current_Credit" value="0" class="form-control " readonly>
                                    </div>

                                    <div class="form-group col-lg-2" style="display: {{$credStyle}}">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Credit_Limit')}} </label>
                                        <input type="text" id="Credit_Limit"  value="0" class="form-control " readonly>
                                    </div>


                             
                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Notes')}} </label>
                                            <input type="text" name="Note" value="{{$item->Note}}" class="form-control">
                                        </div>
                                                            
                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.File')}} </label>
                                            <input type="file" name="File" value="{{old('File')}}" class="form-control">
                                            <input type="hidden" name="Files" value="{{$item->File}}" class="form-control">
                                        </div>
                               

                                </div>
                         
                                    

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-12">
                    <div id="panel-1" class="panel">
                        <div class="panel-container show">
                            <div class="panel-content" style="background: #fad2f796;">
                                <div class="row">
                        
                                        <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput"> </label>
                                            <div class="input-items" style="position:relative;">
                                                <input type="text" id="search" class="form-control" placeholder="{{trans('admin.Search_For_Products')}}">
                                                @if(app()->getLocale() == 'ar' )
                                                    <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;left:3px;"></i>
                                                @else
                                                    <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;right: 0;left:auto;"></i>
                                                @endif
                                            </div>
                                        </div>
                            
                                </div>
                                <div id="mobile-overflow">
                                    <table class="table table-bordered table-hover table-striped w-100 mobile-width-more table-color1 mt-2">
                                        <thead>
                                        <tr>
                                        
                                            <th>{{trans('admin.Name')}}</th>
                                                <th>{{trans('admin.Unit')}}</th>
                                               <th>{{trans('admin.Code')}}</th>
                                            <th>{{trans('admin.Qty')}}</th>
                                            <th>{{trans('admin.Desc')}}</th>
                                      

                                            <th>{{trans('admin.Actions')}}</th>
                                        </tr>
                                        </thead>
                                        <tbody class="Data" id="Data">
                                        </tbody>
                                    </table>
                                </div>
                                <!-- datatable start -->
                                <div id="mobile-overflow">
                                    <table id="dt" class="table table-bordered table-hover table-striped w-100 mobile-width-more table-color2">
                                        <thead>
                                        <tr>
                                        
                                            <th>{{trans('admin.Name')}}</th>
                                                <th>{{trans('admin.Unit')}}</th>
                                               <th>{{trans('admin.Code')}}</th>
                                            <th>{{trans('admin.Qty')}}</th>
                                            <th>{{trans('admin.Desc')}}</th>
                                            <th>{{trans('admin.Actions')}}</th>
                                        </tr>
                                        </thead>
                                        <tbody id="data-dt">
                                            
                                            
                                        @foreach($details as $pro)    
                                            
                                                <tr>
         <td>

                                                    {{app()->getLocale() == 'ar' ?$pro->Product()->first()->P_Ar_Name :$pro->Product()->first()->P_En_Name}}
                                                    <input type='hidden' name='P_Ar_Name[]' value='{{$pro->Product()->first()->P_Ar_Name}}'>
                                                    <input type='hidden' name='P_En_Name[]' value='{{$pro->Product()->first()->P_En_Name}}'>

                                                    @if(!empty($pro->V1))
                                                        ( {{app()->getLocale() == 'ar' ?$pro->V1()->first()->Name :$pro->V1()->first()->NameEn}} )

                                                        <input type='hidden' name='VOne[]' value='{{$pro->V1}}'>
                                                        <input type='hidden' name='V_Name[]' value='{{$pro->V_Name}}'>

                                                    @else
                                                        <input type='hidden' name='VOne[]' value=''>
                                                        <input type='hidden' name='V_Name[]' value=''>
                                                    @endif

                                                    @if(!empty($pro->V2))
                                                        ( {{app()->getLocale() == 'ar' ?$pro->V2()->first()->Name :$pro->V2()->first()->NameEn}} )
                                                        <input type='hidden' name='VTwo[]' value='{{$pro->V2}}'>
                                                        <input type='hidden' name='VV_Name[]' value='{{$pro->VV_Name}}'>
                                                    @else
                                                        <input type='hidden' name='VTwo[]' value=''>
                                                        <input type='hidden' name='VV_Name[]' value=''>
                                                    @endif

                                                </td>

      <td><input type='hidden' name='Unit[]' value='{{$pro->Unit}}'>{{app()->getLocale() == 'ar' ?$pro->Unit()->first()->Name :$pro->Unit()->first()->NameEn}}</td>

                <td><input type='hidden' name='P_Code[]' value='{{$pro->Product_Code}}'>
                                                        <input type='hidden' name='Patch_Number[]' value='{{$pro->Patch_Number}}'>
                                                        {{$pro->Product_Code}}
                                                    </td>
         <td><input class='Qun form-control' id="QuntD{{$pro->id}}" onclick="TotD({{$pro->id}})" onkeyup="TotD({{$pro->id}})" type='number' step="any"  name='Qty[]' value='{{$pro->Qty}}'></td>     
                                                  
                                                    

                    <td><input class='form-control'  type='text' step="any"  name='Desc[]' value='{{$pro->Desc}}'></td>

                                                <td>
                                                    <button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button> 
                                                    <input type='hidden' name='Product[]' value='{{$pro->Product}}'>
       
                                                </td>
                                            </tr>
                                            
                                            
                                        @endforeach    
                                            
                                            
                                        </tbody>
                                    </table>
                                </div>
                                <!-- datatable end -->


                                <div class="form-row">
                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Product_Numbers')}} </label>
                                        <input type="text" id="Product_Numbers" disabled class="form-control">
                                        <input type="hidden" id="Product_NumbersHide" name="Product_Numbers">
                                    </div>
                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Total_Qty')}} </label>
                                        <input type="text" id="Total_Qty" disabled class="form-control">
                                        <input type="hidden" id="Total_QtyHide" name="Total_Qty">
                                    </div>
                 

                                </div>
                                <div class="buttons mt-3" id="Submit" style="display: block">
                               
                                    <button type="submit" class="btn btn-primary" onclick="SPS()"> <i class="fal fa-folder"></i> {{trans('admin.SaveChanges')}} </button>
                               
                            

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        </form>
        
     
     
    </main>


    @if(app()->getLocale() == 'ar' )
        <input type="hidden" id="LANG" value="ar">
    @else
        <input type="hidden" id="LANG" value="en">
    @endif



@endsection
@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
 <script>
var autoSave = $('#autoSave');
var interval;
var timer = function () {
    interval = setInterval(function () {
        //start slide...
        if (autoSave.prop('checked'))
            saveToLocal();

        clearInterval(interval);
    }, 3000);
};

//save
var saveToLocal = function () {
    localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
    console.log("saved");
}

//delete
var removeFromLocal = function () {
    localStorage.removeItem("summernoteData");
    $('#saveToLocal').summernote('reset');
}

$(document).ready(function () {
    
    

  
    //init default
    $('.js-summernote').summernote({
        height: 200,
        tabsize: 2,
        placeholder: "Type here...",
        dialogsFade: true,
        toolbar: [
               ['style', ['style']],
               ['font', ['strikethrough', 'superscript', 'subscript']],
               ['font', ['bold', 'italic', 'underline', 'clear']],
               ['fontsize', ['fontsize']],
               ['fontname', ['fontname']],
               ['color', ['color']],
               ['para', ['ul', 'ol', 'paragraph']],
               ['height', ['height']]
               ['table', ['table']],
               ['insert', ['link', 'picture', 'video']],
               ['view', ['fullscreen', 'codeview', 'help']]
           ],
        callbacks: {
            //restore from localStorage
            onInit: function (e) {
                $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
            },
            onChange: function (contents, $editable) {
                clearInterval(interval);
                timer();
            }
        }
    });

    //load emojis
    $.ajax({
        url: 'https://api.github.com/emojis',
        async: false
    }).then(function (data) {
        window.emojis = Object.keys(data);
        window.emojiUrls = data;
    });

    //init emoji example
    $(".js-hint2emoji").summernote({
        height: 100,
        toolbar: false,
        placeholder: 'type starting with : and any alphabet',
        hint: {
            match: /:([\-+\w]+)$/,
            search: function (keyword, callback) {
                callback($.grep(emojis, function (item) {
                    return item.indexOf(keyword) === 0;
                }));
            },
            template: function (item) {
                var content = emojiUrls[item];
                return '<img src="' + content + '" width="20" /> :' + item + ':';
            },
            content: function (item) {
                var url = emojiUrls[item];
                if (url) {
                    return $('<img />').attr('src', url).css('width', 20)[0];
                }
                return '';
            }
        }
    });

    //init mentions example
    $(".js-hint2mention").summernote({
        height: 100,
        toolbar: false,
        placeholder: "type starting with @",
        hint: {
            mentions: ['jayden', 'sam', 'alvin', 'david'],
            match: /\B@(\w*)$/,
            search: function (keyword, callback) {
                callback($.grep(this.mentions, function (item) {
                    return item.indexOf(keyword) == 0;
                }));
            },
            content: function (item) {
                return '@' + item;
            }
        }
    });

});


</script>

<!-- Search Selecet -->
<script>
   $(document).ready(function() {
        $(function() {
            $(".select2").select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State",
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0,
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items",
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true,
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm;
                },
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
            }

            $("#Emp").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllEmps",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllEmpsJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Emp').empty();
                                $.each(data, function(key, value) {

                                    $('#Emp').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#Emp").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });

            $("#client").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllClientsFilter",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {

                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllClientsFilterJS/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#client').empty();
                                $.each(data, function(key, value) {

                                    $('#client').append('<option value="' + key + '">' + value + '</option>');

                                });

                                var countryId = $('#client').val();
                                if (countryId) {
                                    $.ajax({
                                        url: 'NewAccountBalanceSOFilter/' + countryId,
                                        type: "GET",
                                        dataType: "json",
                                        beforeSend: function() {
                                            $('#loader').css("visibility", "visible");
                                        },

                                        success: function(data) {

                                                $('#AccountCredit').val(data.credit);
                                                $('#Credit_Limit').val(data.limit);

                                        },
                                        complete: function() {
                                            $('#loader').css("visibility", "hidden");
                                        }
                                    });
                                } else {

                                    $('select[name="state"]').empty();
                                }



                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $("#client").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });


            $('#AccountCodeF').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllClientsFilter',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllClientsFilterJS/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#AccountCodeF').empty();
                                $.each(data, function(key, value) {

                                    $('#AccountCodeF').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#AccountCodeF').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });




            $('#AccountCodee').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllClientsFilter',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllClientsFilterJS/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#AccountCodee').empty();
                                $.each(data, function(key, value) {

                                    $('#AccountCodee').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#AccountCodee').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });

            $(".EmpDele").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllEmps",
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            }),
                        };

                        console.log(data);
                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllEmpsJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('.EmpDele').empty();
                                $.each(data, function(key, value) {

                                    $('.EmpDele').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                },
            });

            $(".EmpDele").on("select2:select", function(e) {
                console.log("select done", e.params.data);
            });






        });
    });


</script>

<!--Account Balance -->
<script>
$(document).ready(function () {

    $('#vendor').on('change', function () {
        var countryId = $(this).val();
        if (countryId) {
            $.ajax({
                url: 'AccountBalanceFilter/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function () {
                    $('#loader').css("visibility", "visible");
                },

                success: function (data) {
                    $.each(data, function (key, value) {


                        $('#AccountCredit').val(parseFloat(key).toFixed(2));
                        $('#AccountCredit').val(parseFloat(value).toFixed(2));
                    });
                },
                complete: function () {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="state"]').empty();
        }

    });

});

$(document).ready(function () {

    var countryId = $('#vendor').val();
    if (countryId) {
        $.ajax({
            url: 'AccountBalanceFilter/' + countryId,
            type: "GET",
            dataType: "json",
            beforeSend: function () {
                $('#loader').css("visibility", "visible");
            },

            success: function (data) {
                $.each(data, function (key, value) {



                    $('#AccountCredit').val(parseFloat(key).toFixed(2));
                    $('#AccountCredit').val(parseFloat(value).toFixed(2));
                });
            },
            complete: function () {
                $('#loader').css("visibility", "hidden");
            }
        });
    } else {

        $('select[name="state"]').empty();
    }

});


</script>


<!-- Filter Products -->
<script>
$(document).ready(function () {

    fetch_customer_data();

    function fetch_customer_data(search = '',client = '') {
        $.ajax({
            url: 'ClientRequestsProductsFilter',
            method: 'GET',
            data: {
                search: search,
                client: client,

            },
            dataType: 'json',
            success: function (data) {
                $('.Data').html(data.table_data);
                $("#Data").show();
            }
        })
    }

   $(document).on('keyup', '#search', function () {
        var search = $(this).val();
        var client = $('#client').val();

        if (search == '') {
            $("#Data").hide();
        }
        fetch_customer_data(search, client);
    });




    $(document).on('change', '#client', function () {
        var client = $(this).val();
        var search = $('#search').val();
        fetch_customer_data(search, client);
    });



});


</script>

<script>
    function Fun(r){
        
         var P_Ar_Name = $("#P_Ar_Name" + r).val();
    var P_En_Name = $("#P_En_Name" + r).val();
    var Product = $("#Product" + r).val();
    var UnitID = $("#UnitPurch" + r).val();
    var UnitName = $("#UnitPurchName" + r).val();
    var Qty = $("#Qty" + r).val();
    var Barcode = $("#CodePurch" + r).val();
    var Desc = $("#Desc" + r).val();
  

    document.getElementById("AddBtnPur" + r).style.display = "none";
    document.getElementById("Row" + r).style.display = "none";


    var LANG = $("#LANG").val();
    if (LANG == 'ar') {
        var Nemo = P_Ar_Name;
    } else {
        var Nemo = P_En_Name;
    }

        
        var markup = "<tr><td><input type='hidden' name='P_Ar_Name[]' value='" + P_Ar_Name + "'><input type='hidden' name='P_En_Name[]' value='" + P_En_Name + "'>" + Nemo + "</td><td><input type='hidden' name='Unit[]' value='" + UnitID + "'>" + UnitName + "</td><td><input type='hidden' id='BAR" + r + "' name='P_Code[]' value='" + Barcode + "'>" + Barcode + "</td><td><input class='Qun form-control' id='QuntD" + r + "' type='number' step='any' name='Qty[]' value='" + Qty + "' onkeyup='TotD(" + r + ")' onclick='TotD(" + r + ")'></td><td><input type='hidden' name='Desc[]' value='" + Desc + "'>" + Desc + "</td><td><button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input type='hidden'  id='PRO" + r + "' name='Product[]' value='" + Product + "'><input type='hidden' name='VOne[]' value=''><input type='hidden' name='VTwo[]' value=''></td><input type='hidden' name='V_Name[]' value=''><input type='hidden' name='VV_Name[]' value=''></tr>";


  

        $("#data-dt").append(markup);
 
        var P = $("#PRO" + r).val();
        var Bar = $("#Bar" + r).val();
        if (Product != P && Barcode != Bar) {
            $("#data-dt").append(markup);
        }
    

        $("#Data").hide();
    
        
         $.fn.rowCount = function () {
        return $('tr', $(this).find('tbody')).length;
    };

    var rowctr = $('#dt').rowCount();

    var sumQ = 0;
    $('.Qun').each(function () {
        sumQ += parseFloat($(this).val());
    });

  


    $('#Product_Numbers').val(parseFloat(rowctr));
    $('#Product_NumbersHide').val(parseFloat(rowctr));

    $('#Total_Qty').val(parseFloat(sumQ));
    $('#Total_QtyHide').val(parseFloat(sumQ));

  

    $('#data-dt').on('click', '#DelAssem', function (e) {
        $(this).closest('tr').remove();


        $.fn.rowCount = function () {
            return $('tr', $(this).find('tbody')).length;
        };

        var rowctr = $('#dt').rowCount();

        var sumQ = 0;
        $('.Qun').each(function () {
            sumQ += parseFloat($(this).val());
        });

     

        $('#Product_Numbers').val(parseFloat(rowctr));
        $('#Product_NumbersHide').val(parseFloat(rowctr));

        $('#Total_Qty').val(parseFloat(sumQ));
        $('#Total_QtyHide').val(parseFloat(sumQ));

      

    })


        
        
        
    }
</script>    

<!-- Add Products -->
<script>


//Add Vira One -->

function FunV(r) {

    $.ajax({
        url: 'ViraFilterPurchases/' + r,
        type: "GET",
        dataType: "json",
        beforeSend: function () {
            $('#loader').css("visibility", "visible");
        },

        success: function (data) {
            $.each(data, function (key, value) {

                var P_Ar_Name = $("#P_Ar_Name" + r).val();
                var P_En_Name = $("#P_En_Name" + r).val();
                var Product = $("#Product" + r).val();
                var UnitID = $("#UnitPurch" + r).val();
                var UnitName = $("#UnitPurchName" + r).val();
                var Qty = $("#Qty" + r).val();
                var Barcode = Math.floor(Math.random() * 10000);
               
                var Desc = $("#Desc" + r).val();

        
                document.getElementById("AddBtnPur" + r).style.display = "none";
                document.getElementById("Row" + r).style.display = "none";


                var LANG = $("#LANG").val();
                if (LANG == 'ar') {
                    var Nemo = P_Ar_Name;
           
                } else {
                    var Nemo = P_En_Name;
        
                }


                var markup = "<tr><td><input type='hidden' name='P_Ar_Name[]' value='" + P_Ar_Name + "'><input type='hidden' name='P_En_Name[]' value='" + P_En_Name + "'>" + Nemo + " (" + value + ") </td><td><input type='hidden' name='Unit[]' value='" + UnitID + "'>" + UnitName + "</td><td><input type='text' id='BAR" + key + "' name='P_Code[]' value='" + Barcode + "' class='form-control'></td><td><input class='Qun  form-control' type='number' id='QuntityV" + key + "' value='" + Qty + "' step='any' name='Qty[]' onkeyup='TotV(" + key + ")' onclick='TotV(" + key + ")'></td><td><input type='hidden' name='Desc[]' value='" + Desc + "'>" + Desc + "</td><td><button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input type='hidden' id='PRO" + key + "' name='Product[]' value='" + Product + "'><input type='hidden' name='VOne[]' value='" + key + "'><input type='hidden' name='VTwo[]' value=''></td><input type='hidden' name='V_Name[]' value='" + value + "'><input type='hidden' name='VV_Name[]' value=''></tr>";

                $("#data-dt").append(markup);
             
                    $("#Data").hide();
             
                $.fn.rowCount = function () {
                    return $('tr', $(this).find('tbody')).length;
                };

                var rowctr = $('#dt').rowCount();

                var sumQ = 0;
                $('.Qun').each(function () {
                    sumQ += parseFloat($(this).val());
                });

               

                $('#Product_Numbers').val(parseFloat(rowctr));
                $('#Product_NumbersHide').val(parseFloat(rowctr));

                $('#Total_Qty').val(parseFloat(sumQ));
                $('#Total_QtyHide').val(parseFloat(sumQ));
                })
        },
        complete: function () {
            $('#loader').css("visibility", "hidden");
        }

           });

    $('#data-dt').on('click', '#DelAssem', function (e) {
        $(this).closest('tr').remove();


        $.fn.rowCount = function () {
            return $('tr', $(this).find('tbody')).length;
        };

        var rowctr = $('#dt').rowCount();

        var sumQ = 0;
        $('.Qun').each(function () {
            sumQ += parseFloat($(this).val());
        });

      
        $('#Product_Numbers').val(parseFloat(rowctr));
        $('#Product_NumbersHide').val(parseFloat(rowctr));

        $('#Total_Qty').val(parseFloat(sumQ));
        $('#Total_QtyHide').val(parseFloat(sumQ));

     
    })


}

</script>

<script>
    //Add Vira Two -->

function FunVV(r) {
    $.ajax({
        url: 'ViraNamePurchases/' + r,
        type: "GET",
        dataType: "json",
        beforeSend: function () {
            $('#loader').css("visibility", "visible");
        },

        success: function (data) {
            $.each(data, function (key, value) {


                var P_Ar_Name = $("#P_Ar_Name" + r).val();
                var P_En_Name = $("#P_En_Name" + r).val();
                var Product = $("#Product" + r).val();
                var UnitID = $("#UnitPurch" + r).val();
                var UnitName = $("#UnitPurchName" + r).val();
                var Qty = $("#Qty" + r).val();
                var Barcode = Math.floor(Math.random() * 10000);
              
                  var Desc = $("#Desc" + r).val();


                document.getElementById("AddBtnPur" + r).style.display = "none";
                document.getElementById("Row" + r).style.display = "none";

                var LANG = $("#LANG").val();
                if (LANG == 'ar') {
                    var Nemo = P_Ar_Name;
        
                } else {
                    var Nemo = P_En_Name;
                 
                }



                var markup = "<tr><td><input type='hidden' name='P_Ar_Name[]' value='" + P_Ar_Name + "'><input type='hidden' name='P_En_Name[]' value='" + P_En_Name + "'>" + Nemo + " (" + value + ") </td><td><input type='hidden' name='Unit[]' value='" + UnitID + "'>" + UnitName + "</td><td><input type='text' id='BAR" + key + "' name='P_Code[]' value='" + Barcode + "' class='form-control'></td><td><input class='Qun  form-control' type='number' id='QuntityVV" + key + "' value='" + Qty + "' step='any' name='Qty[]' onkeyup='TotVV(" + key + ")' onclick='TotVV(" + key + ")'></td><td><input type='hidden' name='Desc[]' value='" + Desc + "'>" + Desc + "</td><td><button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input type='hidden' id='PRO" + key + "' name='Product[]' value='" + Product + "'><input type='hidden' name='VOne[]' value=''><input type='hidden' name='VTwo[]' value=''></td><input type='hidden' name='V_Name[]' value='" + value + "'><input type='hidden' name='VV_Name[]' value='" + value + "'></tr>";

                $("#data-dt").append(markup);

     
                    $("#Data").hide();
         

            $.fn.rowCount = function () {
                return $('tr', $(this).find('tbody')).length;
            };

            var rowctr = $('#dt').rowCount();

            var sumQ = 0;
            $('.Qun').each(function () {
                sumQ += parseFloat($(this).val());
            });

    

            $('#Product_Numbers').val(parseFloat(rowctr));
            $('#Product_NumbersHide').val(parseFloat(rowctr));

            $('#Total_Qty').val(parseFloat(sumQ));
            $('#Total_QtyHide').val(parseFloat(sumQ));

        }),
                   },
                   
                   
        complete: function () {
            $('#loader').css("visibility", "hidden");
        }
            
            
        });





    $('#data-dt').on('click', '#DelAssem', function (e) {
        $(this).closest('tr').remove();

        $.fn.rowCount = function () {
            return $('tr', $(this).find('tbody')).length;
        };

        var rowctr = $('#dt').rowCount();

        var sumQ = 0;
        $('.Qun').each(function () {
            sumQ += parseFloat($(this).val());
        });

        $('#Product_Numbers').val(parseFloat(rowctr));
        $('#Product_NumbersHide').val(parseFloat(rowctr));

        $('#Total_Qty').val(parseFloat(sumQ));
        $('#Total_QtyHide').val(parseFloat(sumQ));

    

    })


}

</script>

<script>

function FunSerial(r) {

    var P_Ar_Name = $("#P_Ar_Name" + r).val();
    var P_En_Name = $("#P_En_Name" + r).val();
    var Product = $("#Product" + r).val();
    var UnitID = $("#UnitPurch" + r).val();
    var UnitName = $("#UnitPurchName" + r).val();
    var Qty = $("#Qty" + r).val();
    var Barcode = $("#CodePurch" + r).val();
    var i = 0;
    var Desc = $("#Desc" + r).val();




    document.getElementById("AddBtnPur" + r).style.display = "none";
    document.getElementById("Row" + r).style.display = "none";

    var LANG = $("#LANG").val();
    if (LANG == 'ar') {
        var Nemo = P_Ar_Name;

    } else {
        var Nemo = P_En_Name;

    }

    var markup = "<tr><td>" + Nemo + " (" + Qty + ")</td><td>" + UnitName + "</td><td><div class='row'>";

    for (i; i < Qty; i++) {
        markup += "<div class='col-md-12'><input type='text' onkeyup='SERIAL(" + Qty + ")' onclick='SERIAL(" + Qty + "," + Product + ")' onkeypress='SERIAL(" + Qty + "," + Product + ")' id='SRCODE" + i + Product + "' id='BAR" + r + "' name='P_Code[]'  class='form-control inputs'><input type='hidden' name='P_Ar_Name[]' value='" + P_Ar_Name + "'><input type='hidden' name='P_En_Name[]' value='" + P_En_Name + "'><input type='hidden' name='Unit[]' value='" + UnitID + "'><input class='Qun' type='hidden' name='Qty[]' value='1'><input type='hidden' id='PRO" + r + "' name='Product[]' value='" + Product + "'><input type='hidden' name='VOne[]' value=''><input type='hidden' name='VTwo[]' value=''><input type='hidden' name='V_Name[]' value=''><input type='hidden' name='VV_Name[]' value=''><input type='hidden' name='Desc[]' value='" + Desc + "'></div>";
    }

    markup += "</div></td><td>1</td><td>"+Desc+"</td><td><button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button></td></tr>";



    $("#data-dt").append(markup);


        $("#Data").hide();


    $.fn.rowCount = function () {
        return $('tr', $(this).find('tbody')).length;
    };

    var rowctr = $('#dt').rowCount();

    var sumQ = 0;
    $('.Qun').each(function () {
        sumQ += parseFloat($(this).val());
    });

   
    $('#Product_Numbers').val(parseFloat(rowctr));
    $('#Product_NumbersHide').val(parseFloat(rowctr));

    $('#Total_Qty').val(parseFloat(sumQ));
    $('#Total_QtyHide').val(parseFloat(sumQ));

  

 
    $('#data-dt').on('click', '#DelAssem', function (e) {
        $(this).closest('tr').remove();

        $.fn.rowCount = function () {
            return $('tr', $(this).find('tbody')).length;
        };

        var rowctr = $('#dt').rowCount();

        var sumQ = 0;
        $('.Qun').each(function () {
            sumQ += parseFloat($(this).val());
        });

     
        $('#Product_Numbers').val(parseFloat(rowctr));
        $('#Product_NumbersHide').val(parseFloat(rowctr));

        $('#Total_Qty').val(parseFloat(sumQ));
        $('#Total_QtyHide').val(parseFloat(sumQ));

      

    })


}
     
</script>

<!--Total Products -->
<script>
    
function PurchTotal(r) {

    var Qty = $("#Qty" + r).val();
   
    if ( Qty == '') {

        document.getElementById("AddBtnPur" + r).style.display = "none";
    }


    if ( Qty != '' && Qty != 0) {

   
            document.getElementById("AddBtnPur" + r).style.display = "inline-block";
     
    }





}

function TotD(r) {

    var Qty = $("#QuntD" + r).val();
  


    var rowctr = $('#dt').rowCount();

    var sumQ = 0;
    $('.Qun').each(function () {
        sumQ += parseFloat($(this).val());
    });

 

    $('#Product_Numbers').val(parseFloat(rowctr));
    $('#Product_NumbersHide').val(parseFloat(rowctr));

    $('#Total_Qty').val(parseFloat(sumQ));
    $('#Total_QtyHide').val(parseFloat(sumQ));

  
}

//
//Total Products Serial -->
//
function PurchTotalSerial(r) {

    var Qty = 1;
 


        if ( Qty == '') {

        document.getElementById("AddBtnPur" + r).style.display = "none";
    }


    if ( Qty != '' && Qty != 0) {

   
            document.getElementById("AddBtnPur" + r).style.display = "inline-block";
     
    }






}
//
//Total Products V -->
//
function PurchTotalV(r) {
      var Qty = $("#Qty" + r).val();
   
    if ( Qty == '') {

        document.getElementById("AddBtnPur" + r).style.display = "none";
    }


    if ( Qty != '' && Qty != 0) {

   
            document.getElementById("AddBtnPur" + r).style.display = "inline-block";
     
    }




}

function TotV(r) {

    var Qty = $("#QuntityV" + r).val();
  


    $.fn.rowCount = function () {
        return $('tr', $(this).find('tbody')).length;
    };

    var rowctr = $('#dt').rowCount();

    var sumQ = 0;
    $('.Qun').each(function () {
        sumQ += parseFloat($(this).val());
    });

   
}


//
//Total Products VV -->
//
function PurchTotalVV(r) {
      var Qty = $("#Qty" + r).val();
   
    if ( Qty == '') {

        document.getElementById("AddBtnPur" + r).style.display = "none";
    }


    if ( Qty != '' && Qty != 0) {

   
            document.getElementById("AddBtnPur" + r).style.display = "inline-block";
     
    }




}

function TotVV(r) {
  
    var Qty = $("#QuntityVV" + r).val();
  


    $.fn.rowCount = function () {
        return $('tr', $(this).find('tbody')).length;
    };

    var rowctr = $('#dt').rowCount();

    var sumQ = 0;
    $('.Qun').each(function () {
        sumQ += parseFloat($(this).val());
    });

   
}
    
       

</script>

<!--Enter Next Input -->
<script>
$(function () {
    $(document).on('keyup', '.inputs', function (e) {
        if (e.which == 13) {
            var $this = $(this);
            var $td = $this.closest('.col-md-12'); // Current TD
            var $row = $td.closest('.row'); // Current TR
            var $rows = $row.parent(); // Current TABLE or TBODY - parent of all rows
            var column = $td.index(); // Current column of TD

            // Search on a row basis in current column, then try next column
            // repeat until we run out of cells
            while ($td.length) {
                // get next row
                $row = $row.next('.row');
                // If we were on last row
                if ($row.length == 0) {
                    // Go back to first row
                    $row = $rows.children().first();
                    // And use next column
                    column++;
                }
                // get the position in the row column - if it exists
                $td = $row.children().eq(column);
                var $input = $td.find('.inputs');
                if ($input.length) {
                    $input.focus();
                    break;
                }
            }
        }
    });
});

</script>

<!--Scanner  problem -->
<script>
$(".form-control").keypress(function (event) {
    if (event.which == '10' || event.which == '13') {
        event.preventDefault();
    }
});

</script>



<!-- Submit Script -->
<script>
    
        function SPP() {
        $('#sp').val(1);
        var x = $('#sp').val();

                if (x == 1) {
                    document.getElementById("Submit").style.display = "none";
                    document.getElementById('form').submit();
                }

 

    }

    
            function SPS() {
        $('#sp').val(0);
        var x = $('#sp').val();

                if (x == 0) {
                    document.getElementById("Submit").style.display = "none";
                    document.getElementById('form').submit();
                }

 

    }


 
  

</script>

<script>


//Add New Product -->
//
function NewProducts() {


    var Name = $('#P_Ar_Name').val();
    var EnName = $('#P_En_Name').val();
    var P_Type = $('#P_Type').val();
    var Brand = $('#Brand').val();
    var Group = $('#Group').val();
    var unit = $('#unit').val();
    var Rate = $('#Rate').val();
    var Barcode = $('#Barcode').val();
    var Price = $('#Price').val();
    var Price_Two = $('#Price_Two').val();
    var Price_Three = $('#Price_Three').val();

    if (Name) {
        $.ajax({
            url: 'AddNewProduct',
            type: "GET",
            data: {
                Name: Name,
                EnName: EnName,
                P_Type: P_Type,
                Brand: Brand,
                Group: Group,
                unit: unit,
                Rate: Rate,
                Barcode: Barcode,
                Price: Price,
                Price_Two: Price_Two,
                Price_Three: Price_Three
            },
            dataType: "json",
            beforeSend: function () {
                $('#loader').css("visibility", "visible");
            },

            success: function (data) {
                $.each(data, function (key, value) {

                    var LANG = $('#LANG').val();
                    if (LANG == 'ar') {
                        alert('تم الاضافه بنجاح');
                    } else {
                        alert('Added Successfully');
                    }

                    $('#P_Ar_Name').val('');
                    $('#P_En_Name').val('');
                    $('#Rate').val(1);
                    $('#Barcode').val('');
                    $('#Price').val(0);
                    $('#Price_Two').val(0);
                    $('#Price_Three').val(0);


                });
            },
            complete: function () {
                $('#loader').css("visibility", "hidden");
            }
        });
    } else {

        var LANG = $('#LANG').val();
        if (LANG == 'ar') {
            alert('حقل الاسم مطلوب');
        } else {
            alert('Name Input is Required');
        }



    }



}
//
//Add New Vendor -->
//
function NewVendor() {

    var co = $('#CODE').val();
    var Name = $('#Name').val();
    var NameEn = $('#NameEn').val();
    var PriceLevel = $('#PriceLevel').val();
    var LANG = $('#LANG').val();

    if (NameEn == '') {

        NameEn = Name;
    }

    if (Name) {
        $.ajax({
            url: 'AddNewVendor',
            type: "GET",
            data: {
                co: co,
                Name: Name,
                PriceLevel: PriceLevel,
                NameEn: NameEn
            },
            dataType: "json",
            beforeSend: function () {
                $('#loader').css("visibility", "visible");
            },

            success: function (data) {
                $.each(data, function (key, value) {

                    if (LANG == 'ar') {
                        alert('تم الاضافه بنجاح');
                    } else {
                        alert('Added Successfully');
                    }

                    $('#Name').val('');
                });
            },
            complete: function () {
                $('#loader').css("visibility", "hidden");
            }
        });
    } else {

        if (LANG == 'ar') {
            alert('حقل الاسم مطلوب');
        } else {

            alert('Name Input is Required');
        }

    }



}
//
//Add Serial -->
//

//
//Duplicate Serial -->
//
function SERIAL(r, p) {

    var i = 0;
    var arr = [];

    for (i; i < r; i++) {
        var val = $('#SRCODE' + i + p).val();
        arr.push(val);
    }

    var encounteredIndices = {};
    for (var i = 0; i < arr.length; i++)
        if (encounteredIndices[arr[i]]) {
            console.log(i);
            document.getElementById('SRCODE' + i + p).style.border = "3px solid darkred";
            document.getElementById("Submit").style.display = "none";
        } else {
            encounteredIndices[arr[i]] = 1;
            document.getElementById('SRCODE' + i + p).style.border = "none";
            document.getElementById("Submit").style.display = "block";
        }

}
//



//
// Account Balance -->
//
    $(document).ready(function() {

        $('#client').on('change', function() {
            var countryId = $(this).val();
            if (countryId) {
                $.ajax({
                    url: 'NewAccountBalanceSOFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {

                        $('#AccountCredit').val(data.credit);
                        $('#Credit_Limit').val(data.limit);

                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="state"]').empty();
            }

        });

    });

    $(document).ready(function() {

        var countryId = $('#client').val();
        if (countryId) {
            $.ajax({
                url: 'AccountBalanceSFilter/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {
                    $.each(data, function(key, value) {


                        $('#AccountCredit').val(key);
                        $('#AccountCredit').val(value);
                    });
                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="state"]').empty();
        }

    });


//
// Add New Client -->
//
    function NewClients() {

        var co = $('#CODE').val();
        var Name = $('#Name').val();
        var PriceLevel = $('#PriceLevel').val();
        var Phone = $('#Phone').val();
        var NameEn = $('#NameEn').val();
        var LANG = $('#LANG').val();
        if (NameEn == '') {

            NameEn = Name;
        }
        if (Name) {
            $.ajax({
                url: 'AddNewClient',
                type: "GET",
                data: {
                    co: co,
                    Name: Name,
                    PriceLevel: PriceLevel,
                    Phone: Phone,
                    NameEn: NameEn
                },
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {
                    $.each(data, function(key, value) {

                        if (LANG == 'ar') {
                            alert('تم الاضافه بنجاح');
                        } else {
                            alert('Added Successfully');
                        }

                        $('#Name').val('');
                        $('#Phone').val('');


                    });
                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            if (LANG == 'ar') {
                alert('حقل الاسم مطلوب');
            } else {

                alert('Name Input is Required');
            }

        }



    }





</script>


<script>

   $(document).ready(function() {
       
           $.fn.rowCount = function () {
                    return $('tr', $(this).find('tbody')).length;
                };
   
       
          var rowctr = $('#dt').rowCount();

    var sumQ = 0;
    $('.Qun').each(function () {
        sumQ += parseFloat($(this).val());
    });

 

    $('#Product_Numbers').val(parseFloat(rowctr));
    $('#Product_NumbersHide').val(parseFloat(rowctr));

    $('#Total_Qty').val(parseFloat(sumQ));
    $('#Total_QtyHide').val(parseFloat(sumQ));
   });
    
</script>

@endpush

