@extends('admin.index')
@section('content')
@php
use App\Models\InstallCompaniesSalesBillsColumns;
$colum=InstallCompaniesSalesBillsColumns::orderBy('id','desc')->first();
@endphp
<title>{{trans('admin.InstallmentCompaniesSales')}}</title>
<style>
   .box{
   position: relative;
   padding:20px 10px;
   border: 1px solid #ccc;
   border-radius: 5px;
   margin-top:25px;
   }
   .box h3{
   position: absolute;
   background: white;
   top: -25px;
   padding: 5px;
   }
   .nav-item{
   width:50%;
   }
   .select-border , .select2-selection--single ,.select2-selection--multiple, input[type="checkbox"]{
   border: 2px solid #584576!important;
   font-size:15px;
   }
   /* The container */
   .container {
   display: block;
   position: relative;
   padding-right: 35px;
   margin-bottom: 12px;
   cursor: pointer;
   font-size: 13px;
   -webkit-user-select: none;
   -moz-user-select: none;
   -ms-user-select: none;
   user-select: none;
   }
   /* Hide the browser's default checkbox */
   .container input {
   position: absolute;
   opacity: 0;
   cursor: pointer;
   height: 0;
   width: 0;
   }
   /* Create a custom checkbox */
   .checkmark {
   position: absolute;
   top: 0;
   right: 0;
   height: 20px;
   width: 20px;
   border-radius: 3px;
   border: 2px solid #584576;
   transition:.5s;
   }
   /* On mouse-over, add a grey background color */
   .container:hover input ~ .checkmark {
   background-color: #ccc;
   transition:.5s;
   }
   /* When the checkbox is checked, add a blue background */
   .container input:checked ~ .checkmark {
   background-color: #584576;
   }
   /* Create the checkmark/indicator (hidden when not checked) */
   .checkmark:after {
   content: "";
   position: absolute;
   display: none;
   }
   /* Show the checkmark when checked */
   .container input:checked ~ .checkmark:after {
   display: block;
   }
   /* Style the checkmark/indicator */
   .container .checkmark:after {
   left: 5px;
   top: 1px;
   width: 7px;
   height: 12px;
   border: solid white;
   border-width: 0 3px 3px 0;
   -webkit-transform: rotate(45deg);
   -ms-transform: rotate(45deg);
   transform: rotate(45deg);
   }
</style>
<main id="js-page-content" role="main" class="page-content">
   <ol class="breadcrumb page-breadcrumb">
      <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Reports')}}</a></li>
      <li class="breadcrumb-item active">{{trans('admin.InstallmentCompaniesSales')}}</li>
      <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
         class="js-get-date"></span></li>
   </ol>
   <form action="{{url('InstallmentCompaniesSalesFilter')}}" method="post" enctype="multipart/form-data">
       @csrf
      @honeypot
      <div class="row">
         <div class="col-xl-12">
            <div  class="panel">
               <div class="panel-container show">
                  <div class="panel-content">
                     <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                           <ul class="nav nav-tabs" role="tablist">
                              <li class="nav-item" >
                                 <a class="nav-link active" data-toggle="tab" href="#tab_borders_icons-1" role="tab" style="background: #add8e680;"><i class="fal fa-home mr-1"></i>{{trans('admin.Filter')}}</a>
                              </li>
                              <li class="nav-item">
                                 <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-2" role="tab" style="background: #ffe4e1a6;"><i class="fal fa-user mr-1" ></i> {{trans('admin.Columns')}}</a>
                              </li>
                           </ul>
                           <div class="tab-content border border-top-0 p-3">
                              <div class="tab-pane fade show active" id="tab_borders_icons-1" role="tabpanel">
                                 <div class="row">
                                    <div class="col-lg-12">
                                       <div class="row">
                                          <div class="form-group col-md-4 col-12">
                                             <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label><span class="strick">*</span>
                                             <input  type="date" value="{{date('Y-m-d')}}" id="From" name="From" class="form-control  select-border" required>
                                          </div>
                                          <div class="form-group col-md-4 col-12">
                                             <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label><span class="strick">*</span>
                                             <input  type="date" value="{{date('Y-m-d')}}" id="To" name="To" class="form-control  select-border" required>
                                          </div>
                                          <div class="form-group col-md-4 col-12">
                                             <label class="form-label" for="">  {{trans('admin.Branch')}} </label>
                                             <select  class="select2 form-control w-100 select-border" id="Branch"   name="Branch">
                                                <option value=""> {{trans('admin.Branch')}}</option>
                                               @foreach($Branches as $branch)
                                                  <option value="{{$branch->id}}"> 
                                                    {{app()->getLocale() == 'ar' ?$branch->Arabic_Name :$branch->English_Name}} 
                                                 </option>
                                                @endforeach 
                                             </select>
                                          </div>
                                          <div class="form-group col-md-4 col-12 no-print">
                                             <label class="form-label" for="">  {{trans('admin.Stores')}}  </label>
                                              
                                              <span style="color: red" id="select_all_stores"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_stores"><i class="fal fa-trash"></i></span>
                                             <select  class="select2 form-control w-100 select-border" multiple id="Store" name="Store[]">
                                 
                                                   @foreach($Stores as $store)
                                                  <option value="{{$store->id}}"> 
                                                 
                                             {{app()->getLocale() == 'ar' ?$store->Name :$store->NameEn}}     
                                                 </option>
                                                @endforeach 
                                             </select>
                                          </div>
                                          <div class="form-group col-md-4 col-12 no-print">
                                             <label class="form-label" for="">  {{trans('admin.Safe')}} </label>
                                                <span style="color: red" id="select_all_safes"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_safes"><i class="fal fa-trash"></i></span>
                                             <select  class="select2 form-control w-100 select-border" multiple id="Safe" name="Safe[]">
                                          
                                                     @foreach($Safes as $safe)
                                                  <option value="{{$safe->id}}"> 
                                                 
                                                         {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}     
                                                 </option>
                                                @endforeach 
                                             </select>
                                          </div>
                                          <div class="form-group col-md-4 col-12 no-print">
                                             <label class="form-label" for="">  {{trans('admin.Clients_Group')}} </label>
                                             <select  class="select2 form-control w-100 select-border"   id="Clients_Group" name="Clients_Group">
                                                <option value=""> {{trans('admin.Clients_Group')}}</option>
                                                         @foreach($CustomersGroup as $cg)
                                                  <option value="{{$cg->id}}">
                                                 
                                             {{app()->getLocale() == 'ar' ?$cg->Arabic_Name :$cg->English_Name}}      
                                                 </option>
                                                @endforeach 
                                             </select>
                                          </div>
                                          <div class="form-group col-md-4 col-12">
                                             <label class="form-label" for="">  {{trans('admin.Account')}} ({{trans('admin.Client')}}) </label>
                                                <span style="color: red" id="select_all_clients"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_clients"><i class="fal fa-trash"></i></span>
                                             <select class="select2 form-control w-100 ; select-border" multiple id="Client" name="Client[]">
                                      
                                                   @foreach($Clients as $client)
                                                  <option value="{{$client->id}}"> 
                                                 
                                     {{app()->getLocale() == 'ar' ?$client->Name :$client->NameEn}}             
                                                 </option>
                                                @endforeach 
                                             </select>
                                          </div>
                                           
                                                  <div class="form-group col-md-4 col-12 no-print">
                                             <label class="form-label" for=""> {{trans('admin.InstallmentCompanies')}}  </label>
                                                <span style="color: red" id="select_all_company"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_company"><i class="fal fa-trash"></i></span>
                                             <select class="select2 form-control w-100 ; select-border" multiple id="InstallCompany" name="InstallCompany[]" required>
                                         
                                                 @foreach($Compaines as $comp)
                                                 <option value="{{$comp->id}}">
                                                 
                                                  {{app()->getLocale() == 'ar' ?$comp->Arabic_Name :$comp->English_Name}}   
                                                 </option>
                                                 @endforeach
                                           
                                             </select>
                                          </div>
                                           



                                          <div class="form-group col-md-4 col-12 no-print" style="display: none">
                                             <label class="form-label" for=""> {{trans('admin.Payment_Method')}}  </label>
                                                <span style="color: red" id="select_all_paymethod"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_paymethod"><i class="fal fa-trash"></i></span>
                                             <select class="select2 form-control w-100 ; select-border" multiple id="Payment_Method" name="Payment_Method[]">
                                         
                                                <option value="InstallmentCompanies" selected> {{trans('admin.InstallmentCompanies')}}</option>
                                           
                                             </select>
                                          </div>
                                          <div class="form-group col-md-4 col-12 no-print" style="display: none">
                                             <label class="form-label" for="">  {{trans('admin.Type')}}    <span style="color: red" >*</span> </label>
                                                <span style="color: red" id="select_all_type"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_type"><i class="fal fa-trash"></i></span>
                                             <select class="select2 form-control w-100 ; select-border" multiple id="Type" name="Type[]" required>
                                                <option value="1" selected> {{trans('admin.Recived')}}</option>
                                                <option value="0"> {{trans('admin.Pending')}}</option>
                                                <option value="3"> {{trans('admin.Return')}}</option>
                                             </select>
                                          </div>
                                          <div class="form-group col-md-4 col-12 no-print">
                                             <label class="form-label" for="">  {{trans('admin.Delegate')}}  </label>
                                                <span style="color: red" id="select_all_dele"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_dele"><i class="fal fa-trash"></i></span>
                                             <select class="select2 form-control w-100 ; select-border" multiple id="Delegate" name="Delegate[]">
                                                @foreach($Employess as $emp)
                                                  <option value="{{$emp->id}}"> 
                                                 
                                                  {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}   
                                                 </option>
                                                @endforeach 
                                             </select>
                                          </div>
                                          <div class="form-group col-md-4 col-12 no-print">
                                             <label class="form-label" for="">  {{trans('admin.Executor')}}  </label>
                                                <span style="color: red" id="select_all_exe"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_exe"><i class="fal fa-trash"></i></span>
                                             <select class="select2 form-control w-100 ; select-border" multiple id="Executor" name="Executor[]">
                                                    @foreach($Executors as $ex)
                                                  <option value="{{$ex->id}}"> 
                                                 {{app()->getLocale() == 'ar' ?$ex->Name :$ex->NameEn}}       
                                                 </option>
                                                @endforeach 
                                             </select>
                                          </div>
                                          <div class="form-group col-md-4 col-12 no-print">
                                             <label class="form-label" for="">  {{trans('admin.User')}}  </label>
                                                <span style="color: red" id="select_all_user"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_user"><i class="fal fa-trash"></i></span>
                                             <select class="select2 form-control w-100; select-border" multiple id="User" name="User[]">
                                               @foreach($Users as $user)
                                                  <option value="{{$user->id}}">
                                                      {{app()->getLocale() == 'ar' ?$user->name :$user->nameEn}}  
                                                 </option>
                                                @endforeach 
                                             </select>
                                          </div>
                                          <div class="form-group col-md-4 col-12 no-print">
                                             <label class="form-label" for="">   {{trans('admin.Shipping_Company')}} </label>
                                                   <span style="color: red" id="select_all_ship"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_ship"><i class="fal fa-trash"></i></span>
                                             <select class="select2 form-control w-100; select-border" multiple id="Shipping_Company" name="Shipping_Company[]">
                                                 @foreach($Shippings as $ship)
                                                  <option value="{{$ship->id}}"> 
                                                 
                                              {{app()->getLocale() == 'ar' ?$ship->Name :$ship->NameEn}}        
                                                 </option>
                                                @endforeach 
                                             </select>
                                          </div>
                                          <div class="form-group col-md-4 col-12 no-print">
                                             <label class="form-label" for="">   {{trans('admin.Cost_Center')}} </label>
                                             <select class="select2 form-control w-100; select-border" id="Cost_Center" name="Cost_Center">
                                                <option value=""> {{trans('admin.Cost_Center')}}</option>
                                           @foreach($CostCenters as $cost)
                                                  <option value="{{$cost->id}}">
                                                 
                                              {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}           
                                                 </option>
                                                @endforeach 
                                             </select>
                                          </div>
                                          <div class="form-group col-md-4 col-12 no-print">
                                             <label class="form-label" for="">  {{trans('admin.Coin')}} </label>
                                             <select class="select2 form-control w-100; select-border" id="Coin" name="Coin">
                                                <option value=""> {{trans('admin.Coin')}}</option>
                                                    @foreach($Coins as $coin)
                                                  <option value="{{$coin->id}}"> 
                                                 
                                              {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}         
                                                 </option>
                                                @endforeach 
                                             </select>
                                          </div>
                                          <div class="form-group col-md-4 col-12  no-print">
                                             <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                             <input type="text" id="Code" class="form-control select-border" name='Code'>
                                          </div>
                                          <div class="form-group col-md-4 col-12  no-print">
                                             <label class="form-label" for="simpleinput">{{trans('admin.Shift_Code')}} </label>
                                             <input type="text" id="Shift_Code" class="form-control select-border" name='Shift_Code'>
                                          </div>
                                          <div class="form-group col-md-4 col-12  no-print">
                                             <label class="form-label" for="simpleinput">{{trans('admin.Refrence_Number')}} </label>
                                             <input type="text" id="Refrence_Number" class="form-control select-border" name='Refrence_Number'>
                                          </div>
                                                <div class="form-group col-md-4 col-12  no-print">
                                             <label class="form-label" for="simpleinput">{{trans('admin.ContractNumber')}} </label>
                                             <input type="text" id="ContractNumber" class="form-control select-border" name='ContractNumber'>
                                          </div>
                                           
                                           <div class="form-group col-md-4 col-12 no-print">
                                             <label class="form-label" for="">  {{trans('admin.PayFees')}} </label>
                                             <select class="select2 form-control w-100; select-border" id="PayFees" name="PayFees">
                                                <option value=""> {{trans('admin.PayFees')}}</option>
                                                <option value="Yes"> {{trans('admin.Yes')}}</option>
                                                <option value="No"> {{trans('admin.No')}}</option>
                                             </select>
                                          </div>    
                                           

                                           
                                       </div>
                                    </div>
                                   
                                 </div>
                              </div>
                              <div class="tab-pane fade" id="tab_borders_icons-2" role="tabpanel">
                                 <div class="row">
                                    <div class="col-md-6">
                                       <div class="box" style="background: #8000803b;">
                                          <h3> {{trans('admin.ChoiceColumn')}}  </h3>
                                          <div class="row">
                                             <div class="col-md-4 demo">
                                                <label class="container">{{trans('admin.Date')}}
                                                <input  type="checkbox" id="Date" name="DateDet" value="1" @if($colum->Date == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span>
                                                </label>
                                                <label class="container">
                                               {{trans('admin.Bill_Num')}}
                                                <input  type="checkbox" name="CodeDet" id="CodeBill" value="1" @if($colum->Code == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">  
                                               {{trans('admin.Refrence_Number')}}
                                                <input  type="checkbox" name="Refrence_NumberDet" value="1" id="Refrence_NumberBill" @if($colum->Refrence_Number == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                 
                                                        <label class="container">  
                                               {{trans('admin.Client')}}
                                             <input  type="checkbox" name="ClientDet" value="1" id="ClientBill" @if($colum->Client == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                 
                                                <label class="container">
                                                    {{trans('admin.Branch')}}
                                                <input type="checkbox" name="BranchDet" id="BranchBill" value="1" @if($colum->Branch == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                                  {{trans('admin.Store')}}
                                                <input  type="checkbox" name="StoreDet" id="StoreBill" value="1" @if($colum->Store == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container"> 
                                                 {{trans('admin.Payment_Method')}}
                                                <input  type="checkbox" name="Payment_MethodDet" value="1" id="Payment_MethodBill" @if($colum->Payment_Method == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                                {{trans('admin.Safe')}}
                                                <input  type="checkbox" name="SafeDet" id="SafeBill" value="1" @if($colum->Safe == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                              {{trans('admin.Type')}}
                                                <input  type="checkbox" name="TypeDet" id="TypeBill" value="1" @if($colum->Type == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                                  {{trans('admin.Shipping')}}
                                                <input  type="checkbox" name="ShippingDet" id="Shipping" value="1" @if($colum->Shipping == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                             </div>
                                             <div class="col-md-4 demo">
                                                <label class="container"> 
                                                 {{trans('admin.Cost_Center')}}
                                                <input type="checkbox" name="Cost_CenterDet" id="Cost_CenterBill" value="1" @if($colum->Cost_Center == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container"> 
                                               {{trans('admin.ShiftCode')}}
                                                <input  type="checkbox" name="ShiftCodeDet" id="ShiftCode" value="1" @if($colum->ShiftCode == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                                 {{trans('admin.Executor')}}
                                                <input  type="checkbox" name="ExecutorDet" id="ExecutorBill" value="1" @if($colum->Executor == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                             {{trans('admin.User')}}
                                                <input type="checkbox" name="UserDet" id="UserBill" value="1" @if($colum->User == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                           {{trans('admin.Coin')}}
                                                <input  type="checkbox" name="CoinDet" id="CoinBill" value="1" @if($colum->Coin == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                              {{trans('admin.Due_Date')}}
                                                <input  type="checkbox" name="Due_DateDet" id="Due_Date" value="1" @if($colum->Due_Date == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container"> 
                                               {{trans('admin.Delegate')}}
                                                <input  type="checkbox" name="DelegateDet" id="DelegateBill" value="1" @if($colum->Delegate == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                              {{trans('admin.Note')}}
                                                <input  type="checkbox" name="NoteDet" id="Note" value="1" @if($colum->Note == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                              {{trans('admin.Total_Return')}}
                                                <input  type="checkbox" name="Total_ReturnDet" id="Total_Return" value="1" @if($colum->Total_Return == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                             </div>
                                             <div class="col-md-4 demo">
                                                <label class="container">
                                                {{trans('admin.Total_Price')}}
                                                <input  type="checkbox" name="Total_PriceDet" id="Total_Price" value="1" @if($colum->Total_Price == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                                {{trans('admin.Total_Discount')}}
                                                <input  type="checkbox" name="Total_DiscountDet" id="Total_Discount" value="1" @if($colum->Total_Discount == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                               {{trans('admin.Total_Tax')}}
                                                <input  type="checkbox" name="Total_TaxDet" id="Total_Tax" value="1" @if($colum->Total_Tax == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container"> 
                                          {{trans('admin.Total_Net')}}
                                                <input  type="checkbox" name="Total_NetDet" id="Total_Net" value="1" @if($colum->Total_Net == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container"> 
                                               {{trans('admin.Paid')}}
                                                <input  type="checkbox" name="PaidDet" id="Paid" value="1" @if($colum->Paid == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">  
                                                {{trans('admin.Residual')}}
                                                <input  type="checkbox" name="ResidualDet" id="Residual" value="1" @if($colum->Residual == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">  
                                              {{trans('admin.Time')}}
                                                <input  type="checkbox" name="TimeDet" id="Time" value="1" @if($colum->Time == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                        <label class="container"> 
                                              {{trans('admin.InstallCompany')}}
                                                <input  type="checkbox" value="1" name="InstallCompanyDet" id="InstallCompanyBill" @if($colum->InstallCompany == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                       <label class="container"> 
                                              {{trans('admin.ContractNumber')}}
                                                <input  type="checkbox" value="1" name="ContractNumberDet" id="ContractNumberBill" @if($colum->ContractNumber == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                       <label class="container"> 
                                              {{trans('admin.PayFees')}}
                                                <input  type="checkbox" value="1" name="PayFeesDet" id="PayFeesBill" @if($colum->PayFees == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                       <label class="container"> 
                                              {{trans('admin.ServiceFee')}}
                                                <input  type="checkbox" value="1" name="ServiceFeeDet" id="ServiceFeeBill" @if($colum->ServiceFee == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                       <label class="container"> 
                                              {{trans('admin.CompanyPrecent')}}
                                                <input  type="checkbox" value="1" name="CompanyPrecentDet" id="CompanyPrecentBill" @if($colum->CompanyPrecent == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                             </div>
                                          </div>
                                       </div>
                                    </div>
                                    <div class="col-md-4">
                                       <div class="box" style="background: antiquewhite;">
                                          <h3>  {{trans('admin.ChoiceColumnDetails')}}</h3>
                                          <div class="row">
                                             <div class="col-md-6 demo">
                                                <label class="container"> 
                                               {{trans('admin.Product_Code')}}
                                                <input  type="checkbox" name="Product_CodeDet" id="Product_Code" value="1" @if($colum->Product_Code == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container"> 
                                               {{trans('admin.Product_Name')}}
                                                <input type="checkbox" name="Product_NameDet" id="Product_Name" value="1" @if($colum->Product_Name == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                       {{trans('admin.Unit')}}
                                                <input  type="checkbox" name="UnitDet" id="Unit" value="1" @if($colum->Unit == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                             {{trans('admin.Av_Qty')}}
                                                <input  type="checkbox" name="Av_QtyDet" id="Av_Qty" value="1" @if($colum->Av_Qty == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                            {{trans('admin.Qty')}}
                                                <input  type="checkbox" name="QtyDet" id="Qty" value="1" @if($colum->Qty == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                                {{trans('admin.Price')}}
                                                <input  type="checkbox" name="PriceDet" id="Price" value="1" @if($colum->Price == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                            {{trans('admin.Discount')}}
                                                <input  type="checkbox" name="DiscountDet" id="Discount" value="1" @if($colum->Discount == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                              {{trans('admin.Total_BF_Tax')}}
                                                <input  type="checkbox" name="Total_BF_TaxDet" value="1" id="Total_BF_Tax" @if($colum->Total_BF_Tax == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                           {{trans('admin.Tax')}}
                                                <input  type="checkbox" name="TaxDet" id="Tax" value="1" @if($colum->Tax == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                             </div>
                                             <div class="col-md-6 demo">
                                                <label class="container">
                                               {{trans('admin.Total')}}
                                                <input c type="checkbox" name="TotalDet" value="1" id="Total" @if($colum->Total == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label> 
                                                <label class="container">
                                           {{trans('admin.Group')}}
                                                <input  type="checkbox" name="GroupDet" value="1" id="Group" @if($colum->Group == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                                {{trans('admin.Brand')}}
                                                <input  type="checkbox" name="BrandDet" value="1" id="Brand" @if($colum->Brand == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                                {{trans('admin.Exp_Date')}}
                                                <input  type="checkbox" name="Exp_DateDet" value="1" id="Exp_Date" @if($colum->Exp_Date == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container"> 
                                              {{trans('admin.Store')}}
                                                <input  type="checkbox" value="1" name="Product_StoreDet" id="Product_Store" @if($colum->Product_Store == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                
    
                                             </div>
                                          </div>
                                       </div>
                                    </div>
                                    <div class="col-md-2">
                                       <div class="box" style="background: #ffffff;">
                                          <div class="row">
                                             <div class="col-md-12 demo">
                                                <div class="custom-control custom-checkbox">
                                                   <button type="button" id="ChoicedAll"  class="btn btn-warning"><i class="fal fa-check-square"></i> 
                                                  {{trans('admin.ChoicedAll')}}     
                                                   </button>
                                                </div>
                                                <div class="custom-control custom-checkbox">
                                                   <button type="button" id="CancelChoicedAll" class="btn btn-info"><i class="fal fa-square"></i> 
                                                  {{trans('admin.CancelChoicedAll')}}       
                                                   </button>
                                                </div>
                                                <div class="custom-control custom-checkbox">
                                                   <button type="button" id="OppositeChoiced" class="btn btn-danger"><i class="fal fa-square"></i> 
                                                 {{trans('admin.OppositeChoiced')}}       
                                                   </button>
                                                </div>
                                                <div class="custom-control custom-checkbox">
                                                   <button type="button" id="DefaultChoiced" class="btn btn-secondary"><i class="fal fa-check"></i> 
                                                      {{trans('admin.DefaultChoiced')}}       
                                                   </button>
                                                </div>
                                                <div class="custom-control custom-checkbox">
                                                   <button type="button" id="SaveasDefault" class="btn btn-success"><i class="fal fa-check-circle"></i> 
                                                   {{trans('admin.SaveasDefault')}}         
                                                   </button>
                                                </div>
                                             </div>
                                          </div>
                                       </div>
                                    </div>
                                 </div>
                              </div>
                           </div>
                           <div class="form-row">
                              <div class="buttons mt-3">
                                 <button type="submit" class="btn btn-primary"><i class="fal fa-save"></i> 
                                 {{trans('admin.ShowReport')}}         
                                 </button>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </form>
</main>
@endsection
@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script>
   //_fnFeatureHtmlLength();
   $(document).ready(function () {
       // Setup - add a text input to each footer cell
       $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
       $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
           var title = $(this).text();
           $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');
   
           $('input', this).on('keyup change', function () {
               if (table.column(i).search() !== this.value) {
                   table
                       .column(i)
                       .search(this.value)
                       .draw();
               }
           });
       });
       var table = $('#dt-basic-example').DataTable(
           {
               responsive: true,
               orderCellsTop: true,
               fixedHeader: true,
               lengthChange: true,
   
               dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                   "<'row'<'col-sm-12'tr>>" +
                   "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
   
               buttons: [
                   {
                       extend: 'pageLength',
                       className: 'btn-outline-default'
                   },
                   {
                       extend: 'colvis',
                       text: 'Column Visibility',
                       titleAttr: 'Col visibility',
                       className: 'btn-outline-default'
                   },
                   {
                       extend: 'pdfHtml5',
                       text: 'PDF',
                       titleAttr: 'Generate PDF',
                       className: 'btn-outline-danger btn-sm mr-1'
                   },
                   {
                       extend: 'excelHtml5',
                       text: 'Excel',
                       titleAttr: 'Generate Excel',
                       className: 'btn-outline-success btn-sm mr-1'
                   },
                   {
                       extend: 'csvHtml5',
                       text: 'CSV',
                       titleAttr: 'Generate CSV',
                       className: 'btn-outline-primary btn-sm mr-1'
                   },
                   {
                       extend: 'copyHtml5',
                       text: 'Copy',
                       titleAttr: 'Copy to clipboard',
                       className: 'btn-outline-primary btn-sm mr-1'
                   },
                   {
                       extend: 'print',
                       text: 'Print',
                       titleAttr: 'Print Table',
                       className: 'btn-outline-primary btn-sm'
                   }
               ],
           });
       $('.js-thead-colors a').on('click', function () {
           var theadColor = $(this).attr("data-bg");
           console.log(theadColor);
           $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
       });
   
       $('.js-tbody-colors a').on('click', function () {
           var theadColor = $(this).attr("data-bg");
           console.log(theadColor);
           $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
       });
   
   });
   
</script>
<!-- Search Selecet -->
<script>
   $(document).ready(function()
   {
       $(function()
       {
           $('.select2').select2();
   
           $(".select2-placeholder-multiple").select2(
           {
               placeholder: "Select State"
           });
           $(".js-hide-search").select2(
           {
               minimumResultsForSearch: 1 / 0
           });
           $(".js-max-length").select2(
           {
               maximumSelectionLength: 2,
               placeholder: "Select maximum 2 items"
           });
           $(".select2-placeholder").select2(
           {
               placeholder: "Select a state",
               allowClear: true
           });
   
           $(".js-select2-icons").select2(
           {
               minimumResultsForSearch: 1 / 0,
               templateResult: icon,
               templateSelection: icon,
               escapeMarkup: function(elm)
               {
                   return elm
               }
           });
   
           function icon(elm)
           {
               elm.element;
               return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
           }
   
   
   $('#AccountDificit').select2({
   placeholder: "select...",
   ajax: {
   type: "GET",
   dataType: 'json',
   url: 'AllSubAccounts',
   processResults: function (data) {
     return {
       results: $.map(data, function(obj, index) {
         return { id: index, text: obj };
       })
     };
       
       	console.log(data);
       
   },
   data: function (params) {  
     var query = {
       search: params.term
     };
     if (params.term == "*") query.items = [];
     return { json: JSON.stringify( query ) }
   }
   }
   });
   
   
   $('#AccountDificit').on('select2:select', function (e) {
   console.log("select done", e.params.data);
   });
      
           
   $('#AccountExcess').select2({
   placeholder: "select...",
   ajax: {
   type: "GET",
   dataType: 'json',
   url: 'AllSubAccounts',
   processResults: function (data) {
     return {
       results: $.map(data, function(obj, index) {
         return { id: index, text: obj };
       })
     };
       
       	console.log(data);
       
   },
   data: function (params) {  
     var query = {
       search: params.term
     };
     if (params.term == "*") query.items = [];
     return { json: JSON.stringify( query ) }
   }
   }
   });
   
   
   $('#AccountExcess').on('select2:select', function (e) {
   console.log("select done", e.params.data);
   });
                      
   
           
         $("#client").select2({
           placeholder: "select...",
           ajax: {
               type: "GET",
               dataType: "json",
               url: "AllClientsFilter",
               processResults: function (data) {
                   return {
                       results: $.map(data, function (obj, index) {
   
                           return { id: index, text: obj };
                       }),
                   };
   
                   console.log(data);
               },
             data: function (params) {  
   
       
              var query = {
                       search: params.term,
                   };
                           
       
         $.ajax({
                         url: 'AllClientsFilterJS/'+params.term,
                         type:"GET",
                         dataType:"json",
                         beforeSend: function(){
                             $('#loader').css("visibility", "visible");
                         },
   
                         success:function(data) {
                                     $('#client').empty();  
                             $.each(data, function(key, value){
   
                    $('#client').append('<option value="'+ key +'">' + value + '</option>');
              
                             });
                         },
                         complete: function(){
                             $('#loader').css("visibility", "hidden");
                         }
                     });
       
       
       
   }
           },
       });
   
       $("#client").on("select2:select", function (e) {
           console.log("select done", e.params.data);
       });
       
                   
           
       });
   });
</script>

<!-- Filter Branch and client group -->
<script>
    
     $('#Branch').on('change', function(){
      var Branch = $('#Branch').val();  
                         $.ajax({
                   url: 'BranchReportStoresFilter',
                   type:"GET",
                   data:{
                   Branch:Branch
                   },
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },
   
                   success:function(data) {
   
                       $('#Store').empty();
   
                       $.each(data, function(key, value){
   
             $('#Store').append('<option value="'+ key +'">' + value + '</option>');
                           
                       });
                      
                       
                        $.ajax({
                   url: 'BranchReportSafesFilter',
                   type:"GET",
                   data:{
                   Branch:Branch
                   },
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },
   
                   success:function(data) {
   
                       $('#Safe').empty();
   
                       $.each(data, function(key, value){
   
             $('#Safe').append('<option value="'+ key +'">' + value + '</option>');
                           
                       });
                      
                       
                       
                       
       
                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
                       
       
                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
                       
     
 });
    

  $('#Clients_Group').on('change', function(){
      var Clients_Group = $('#Clients_Group').val();  
                         $.ajax({
                   url: 'ClientGroupsFilter',
                   type:"GET",
                   data:{
                   Clients_Group:Clients_Group
                   },
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },
   
                   success:function(data) {
   
                       $('#Client').empty();
   
                       $.each(data, function(key, value){
   
             $('#Client').append('<option value="'+ key +'">' + value + '</option>');
                           
                       });
                      
         
       
                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
                       
     
 });
    

</script>

<!-- ~Multi Select Choiced and removed  -->
<script>
$('#select_all_stores').click(function() {

  $("#Store").select2("destroy");
$("#Store").find('option').attr('selected',true);
$("#Store").select2();
  
});
    
    
$('#remove_all_stores').click(function() {
 $("#Store").select2("destroy");
$("#Store").find('option').attr('selected',false);
$("#Store").select2();
});
    
$('#select_all_safes').click(function() {
     $("#Safe").select2("destroy");
$("#Safe").find('option').attr('selected',true);
$("#Safe").select2();
  
});
    
$('#remove_all_safes').click(function() {
    $("#Safe").select2("destroy");
$("#Safe").find('option').attr('selected',false);
$("#Safe").select2();
});
      

$('#select_all_clients').click(function() {
   
         $("#Client").select2("destroy");
$("#Client").find('option').attr('selected',true);
$("#Client").select2();
  
});
    
$('#remove_all_clients').click(function() {

        $("#Client").select2("destroy");
$("#Client").find('option').attr('selected',false);
$("#Client").select2();
});
      

$('#select_all_paymethod').click(function() {

             $("#Payment_Method").select2("destroy");
$("#Payment_Method").find('option').attr('selected',true);
$("#Payment_Method").select2();
  
});
    
$('#remove_all_paymethod').click(function() {

            $("#Payment_Method").select2("destroy");
$("#Payment_Method").find('option').attr('selected',false);
$("#Payment_Method").select2();
});
    

$('#select_all_type').click(function() {

             $("#Type").select2("destroy");
$("#Type").find('option').attr('selected',true);
$("#Type").select2();
  
});
    
$('#remove_all_type').click(function() {

            $("#Type").select2("destroy");
$("#Type").find('option').attr('selected',false);
$("#Type").select2();
});
    
$('#select_all_dele').click(function() {
  
             $("#Delegate").select2("destroy");
$("#Delegate").find('option').attr('selected',true);
$("#Delegate").select2();
  
});
    
$('#remove_all_dele').click(function() {
  
            $("#Delegate").select2("destroy");
$("#Delegate").find('option').attr('selected',false);
$("#Delegate").select2();
});
  

$('#select_all_exe').click(function() {

             $("#Executor").select2("destroy");
$("#Executor").find('option').attr('selected',true);
$("#Executor").select2();
  
});
    
$('#remove_all_exe').click(function() {
  
            $("#Executor").select2("destroy");
$("#Executor").find('option').attr('selected',false);
$("#Executor").select2();
});
  

$('#select_all_user').click(function() {
  
             $("#User").select2("destroy");
$("#User").find('option').attr('selected',true);
$("#User").select2();
  
});
    
$('#remove_all_user').click(function() {
 
            $("#User").select2("destroy");
$("#User").find('option').attr('selected',false);
$("#User").select2();
});
  
$('#select_all_ship').click(function() {
   
             $("#Shipping_Company").select2("destroy");
$("#Shipping_Company").find('option').attr('selected',true);
$("#Shipping_Company").select2();
  
});
    
$('#remove_all_ship').click(function() {
 
            $("#Shipping_Company").select2("destroy");
$("#Shipping_Company").find('option').attr('selected',false);
$("#Shipping_Company").select2();
});

    $('#select_all_company').click(function() {
   
             $("#InstallCompany").select2("destroy");
$("#InstallCompany").find('option').attr('selected',true);
$("#InstallCompany").select2();
  
});
    
$('#remove_all_company').click(function() {
 
            $("#InstallCompany").select2("destroy");
$("#InstallCompany").find('option').attr('selected',false);
$("#InstallCompany").select2();
});

    
    

</script>

<!-- Choiced Checkbox -->
<script>
    
    $('.FF').on('click' , function(){
    var $a1Check  = $(this).is(':checked');

   
    if($a1Check){
       $(this).val(1);
    }
    else{
         $(this).val(0);
    }    
    
        
    
    
});
    
    
    $('#ChoicedAll').click(function() {
    $('.FF').prop('checked', true);
    $('.FF').val(1);
  
});
    
    
$('#CancelChoicedAll').click(function() {
    $('.FF').prop('checked', false);
  $('.FF').val(0);
});

    
$('#OppositeChoiced').click(function() {
    
    $('.FF').each(function () {
  $(this).prop('checked', !$(this).is(':checked'));
        
        
         var $a1Check  = $(this).is(':checked');

   
    if($a1Check){
       $(this).val(1);
    }
    else{
         $(this).val(0);
    }    
        
});

    
});
    
    
    $('#DefaultChoiced').click(function() {
    
    $('.Unche').prop('checked', false);
     $('.che').prop('checked', true);

       $('.che').val(1);
       $('.Unche').val(0);
});

     $('#SaveasDefault').click(function() {
    
    var Date = $('#Date').val();  
    var Code = $('#CodeBill').val();  
    var Refrence_Number = $('#Refrence_NumberBill').val();  
    var Branch = $('#BranchBill').val();  
    var Store = $('#StoreBill').val();  
    var Payment_Method = $('#Payment_MethodBill').val();  
    var Safe = $('#SafeBill').val();  
    var Type = $('#TypeBill').val();  
    var Shipping = $('#Shipping').val();  
    var Cost_Center = $('#Cost_CenterBill').val();  
    var ShiftCode = $('#ShiftCode').val();  
    var Executor = $('#ExecutorBill').val();  
    var User = $('#UserBill').val();  
    var Coin = $('#CoinBill').val();  
    var Due_Date = $('#Due_Date').val();  
    var Delegate = $('#DelegateBill').val();  
    var Note = $('#Note').val();  
    var Total_Return = $('#Total_Return').val();  
    var Total_Price = $('#Total_Price').val();  
    var Total_Discount = $('#Total_Discount').val();  
    var Total_Tax = $('#Total_Tax').val();  
    var Total_Net = $('#Total_Net').val();  
    var Paid = $('#Paid').val();  
    var Residual = $('#Residual').val();  
    var Time = $('#Time').val();  
    var Product_Code = $('#Product_Code').val();  
    var Product_Name = $('#Product_Name').val();  
    var Unit = $('#Unit').val();  
    var Av_Qty = $('#Av_Qty').val();  
    var Qty = $('#Qty').val();  
    var Price = $('#Price').val();  
    var Discount = $('#Discount').val();  
    var Total_BF_Tax = $('#Total_BF_Tax').val();  
    var Tax = $('#Tax').val();  
    var Total = $('#Total').val();  
    var Group = $('#Group').val();  
    var Brand = $('#Brand').val();  
    var Exp_Date = $('#Exp_Date').val();  
    var Product_Store = $('#Product_Store').val();  
    var ClientBill = $('#ClientBill').val();  
    var InstallCompanyBill = $('#InstallCompanyBill').val();  
    var ContractNumberBill = $('#ContractNumberBill').val();  
    var PayFeesBill = $('#PayFeesBill').val();  
    var ServiceFeeBill = $('#ServiceFeeBill').val();  
    var CompanyPrecentBill = $('#CompanyPrecentBill').val();  

                         $.ajax({
                   url: 'SaveDefaultColumnsInstallmentCompaniesSales',
                   type:"GET",
                   data:{
                   Date:Date,
                   Code:Code,
                   Refrence_Number:Refrence_Number,
                   Branch:Branch,
                   Store:Store,
                   Payment_Method:Payment_Method,
                   Safe:Safe,
                   Type:Type,
                   Shipping:Shipping,
                   Cost_Center:Cost_Center,
                   ShiftCode:ShiftCode,
                   Executor:Executor,
                   User:User,
                   Coin:Coin,
                   Due_Date:Due_Date,
                   Delegate:Delegate,
                   Note:Note,
                   Total_Return:Total_Return,
                   Total_Price:Total_Price,
                   Total_Discount:Total_Discount,
                   Total_Tax:Total_Tax,
                   Total_Net:Total_Net,
                   Paid:Paid,
                   Residual:Residual,
                   Time:Time,
                   Product_Code:Product_Code,
                   Product_Name:Product_Name,
                   Unit:Unit,
                   Av_Qty:Av_Qty,
                   Qty:Qty,
                   Price:Price,
                   Discount:Discount,
                   Total_BF_Tax:Total_BF_Tax,
                   Tax:Tax,
                   Total:Total,
                   Group:Group,
                   Brand:Brand,
                   Exp_Date:Exp_Date,
                   ClientBill:ClientBill,
                   Product_Store:Product_Store,
                   InstallCompanyBill:InstallCompanyBill,
                   ContractNumberBill:ContractNumberBill,
                   PayFeesBill:PayFeesBill,
                   ServiceFeeBill:ServiceFeeBill,
                   CompanyPrecentBill:CompanyPrecentBill

                   },
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },
   
                   success:function(data) {
   
                
                alert('تم الحفظ كافتراضي');      
         
       
                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
    
});

</script>

@endpush