@extends('admin.index')
@section('content')

    <title>{{trans('admin.EditProject')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.RealStates')}} </a></li>
            <li class="breadcrumb-item active">{{trans('admin.EditProject')}}  </li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <form action="{{url('PostEditRealProjects/'.$item->id)}}" method="post" enctype="multipart/form-data">
            {!! csrf_field() !!}
            @honeypot
            <div class="row">
                <div class="col-xl-12">
                    <div  class="panel">
                        <div class="panel-container show">
                            <span id="ex"> @include('admin.layouts.messages')</span>
                            <div class="panel-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.EditProject')}}  </h5>
                                </div>
                                <div class="panel-container show">
                                    <div class="panel-content">
                                        <div class="form-row">
                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                                <input type="text" value="{{$item->Code}}" class="form-control " name="Code" readonly>
                                            </div>
                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput">{{trans('admin.Name')}}</label>
                                                <input type="text" name="Name" value="{{$item->Name}}" class="form-control" required>
                                            </div>

                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput">{{trans('admin.Start_Date')}}</label>
                                                <input type="date" name="Start_Date" value="{{$item->Start_Date}}" class="form-control" id="Start_Date" onchange="PeriodFun()">
                                            </div>


                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput">{{trans('admin.End_Date')}}</label>
                                                <input type="date" name="End_Date" value="{{$item->End_Date}}" class="form-control" id="End_Date" onchange="PeriodFun()">
                                            </div>

                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput">{{trans('admin.Period')}} ({{trans('admin.Days')}})</label>
                                                <input type="text" name="Period" value="{{$item->Period}}" id="Period" class="form-control"  readonly>
                                            </div>


                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput">{{trans('admin.Value')}}</label>
                                                <input type="number" step="any" name="Value" value="{{$item->Value}}" class="form-control" required >
                                            </div>


                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput">{{trans('admin.Expect_Cost')}}</label>
                                                <input type="number" step="any" name="Expect_Cost" value="{{$item->Expect_Cost}}" class="form-control"  >
                                            </div>


                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput">{{trans('admin.Expect_Profit')}}</label>
                                                <input type="number" step="any" name="Expect_Profit" value="{{$item->Expect_Profit}}" class="form-control"  >
                                            </div>



                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="">{{trans('admin.Contract_Type')}}</label>
                                                <select class="select2 form-control w-100" name="Contract_Type" >
                                                    <option value=""> {{trans('admin.Contract_Type')}}</option>
                                                    <option value="Client" @if($item->Contract_Type == 'Client') selected @endif> {{trans('admin.Client')}}</option>
                                                    <option value="Vendor" @if($item->Contract_Type == 'Vendor') selected @endif> {{trans('admin.Vendor')}}</option>
                                                    <option value="Contractor" @if($item->Contract_Type == 'Contractor') selected @endif> {{trans('admin.Contractor')}}</option>
                                                    <option value="Worker" @if($item->Contract_Type == 'Worker') selected @endif> {{trans('admin.Worker')}}</option>
                                                </select>
                                            </div>


                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="">{{trans('admin.Client')}}</label>
                                                <select class="select2 form-control w-100" name="Client" id="Client" required>
                                                    <option value="{{$item->Client}}"> {{$item->Client()->first()->Name}}</option>

                                                </select>
                                            </div>


                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="">{{trans('admin.Manager')}}</label>
                                                <select class="select2 form-control w-100" name="Manager" required>
                                                    <option value=""> {{trans('admin.Manager')}}</option>
                                                    @foreach($Manager as $mang)
                                                        <option value="{{$mang->id}}" @if($item->Manager == $mang->id) selected @endif>
                                                            {{app()->getLocale() == 'ar' ?$mang->Name :$mang->NameEn}}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>



                                            <div class="form-group col-lg-2">
                                                <label class="form-label" for="">{{trans('admin.Reponsible')}}</label>
                                                <select class="select2 form-control w-100" name="Reponsible" required>
                                                    <option value=""> {{trans('admin.Reponsible')}}</option>
                                                    @foreach($Reponsible as $res)
                                                        <option value="{{$res->id}}" @if($item->Reponsible == $res->id) selected @endif>
                                                            {{app()->getLocale() == 'ar' ?$res->Name :$res->NameEn}}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>

                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="">{{trans('admin.Store')}}</label>
                                                <select class="select2 form-control w-100" name="Store" required>
                                                    <option value=""> {{trans('admin.Store')}}</option>
                                                    @foreach($Store as $stor)
                                                        <option value="{{$stor->id}}" @if($item->Store == $stor->id) selected @endif>
                                                            {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>


                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="">{{trans('admin.Contract_Status')}}</label>
                                                <select class="select2 form-control w-100" name="Contract_Status" >
                                                    <option value=""> {{trans('admin.Contract_Status')}}</option>
                                                    @foreach($Contract_Status as $CS)
                                                        <option value="{{$CS->id}}"  @if($item->Contract_Status == $CS->id) selected @endif>

                                                            {{app()->getLocale() == 'ar' ?$CS->Arabic_Name :$CS->English_Name}}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>

                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="">{{trans('admin.Project_Status')}}</label>
                                                <select class="select2 form-control w-100" name="Project_Status" >
                                                    <option value=""> {{trans('admin.Project_Status')}}</option>
                                                    @foreach($Project_Status as $PS)
                                                        <option value="{{$PS->id}}" @if($item->Project_Status == $PS->id) selected @endif>

                                                            {{app()->getLocale() == 'ar' ?$PS->Arabic_Name :$PS->English_Name}}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>

                                                                                      <div class="form-group col-lg-4">
                                                                        <label class="form-label" for="">{{trans('admin.Coin')}}</label>
                                                                                   <select class="select2 form-control w-100" name="Coin" >
                                                                                           <option value=""> {{trans('admin.Coin')}}</option>
                                                                                        @foreach($Coins as $coin)
                                                                                          <option value="{{$coin->id}}">

                                                                                            {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                                                                        </option>
                                                                                 @endforeach
                                                                             </select>
                                                                            </div>
                                                                            <div class="form-group col-lg-4">
                                                                           <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                                                                <input type="text" name="Draw" value="1" class="form-control" >
                                                                                     </div>
                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for=""> {{trans('admin.Cost_Center')}} </label>
                                                <select class="select2 form-control w-100" name="Cost_Center" required>
                                                    <option value=""> {{trans('admin.Cost_Center')}}</option>
                                                    @foreach($Cost_Center as $cost)
                                                        <option value="{{$cost->id}}" @if($item->Cost_Center == $cost->id) selected @endif>

                                                            {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>


                                            <div class="form-group col-lg-4">
                                                <label class="form-label" for=""> {{trans('admin.Governrate')}}</label>
                                                <select class="select2 form-control w-100 Governrate" name="Governrate">
                                                    <option value="">{{trans('admin.Governrate')}}</option>
                                                    @foreach($Governrates as $gov)
                                                        <option value="{{$gov->id}}" @if($item->Governrate == $gov->id) selected @endif>

                                                            {{app()->getLocale() == 'ar' ?$gov->Arabic_Name :$gov->English_Name}}
                                                        </option>
                                                    @endforeach
                                                </select>


                                            </div>


                                            <div class="form-group col-lg-4">
                                                <label class="form-label" for=""> {{trans('admin.City')}}</label>
                                                <select class="select2 form-control w-100 City" name="City">

                                                    @if(!empty($item->City()->first()->Arabic_Name))

                                                        <option value="{{$item->City}}"> {{$item->City()->first()->Arabic_Name}}</option>

                                                    @endif


                                                </select>

                                            </div>


                                            <div class="form-group col-lg-4">
                                                <label class="form-label" for=""> {{trans('admin.Place')}}</label>
                                                <select class="select2 form-control w-100 Place" name="Place">


                                                    @if(!empty($item->Place()->first()->Arabic_Name))

                                                        <option value="{{$item->Place}}"> {{$item->Place()->first()->Arabic_Name}}</option>

                                                    @endif

                                                </select>

                                            </div>


                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput">{{trans('admin.Location')}}</label>
                                                <input type="text" name="Location" value="{{$item->Location}}" class="form-control" >
                                            </div>
                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput">{{trans('admin.Address_Details')}}</label>
                                                <input type="text" name="Address_Details" value="{{$item->Address_Details}}" class="form-control" >
                                            </div>

                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput">   {{trans('admin.Project_File')}}    </label>
                                                <input type="file" name="Project_File"   class="form-control">
                                                <input type="hidden" name="Project_Files"   class="form-control" value="{{$item->Project_File}}">
                                            </div>

                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput">   {{trans('admin.Contract_File')}}    </label>
                                                <input type="file" name="Contract_File"   class="form-control">
                                                <input type="hidden" name="Contract_Files"   class="form-control" value="{{$item->Contract_File}}">
                                            </div>




                                            <div class="form-group col-lg-12 p-3" style="border: 1px solid darkgreen">

                                                <h3 class="text-center text-danger">{{trans('admin.Payments_Sechdule')}}</h3>
                                                <div class="row">


                                                    <div class="form-group col-lg-4">
                                                        <label class="form-label" for="simpleinput">   {{trans('admin.Date')}}    </label>
                                                        <input type="date" id="Date" class="form-control">
                                                    </div>

                                                    <div class="form-group col-lg-4">
                                                        <label class="form-label" for="simpleinput">   {{trans('admin.Value_Payment')}}    </label>
                                                        <input type="number" step="any" id="Value_Payment" class="form-control">
                                                    </div>

                                                    <div class="form-group col-lg-2">
                                                        <button  style="margin: 22px" class="btn btn-primary" type="button" id="AddTo" onclick="AddToTable()"><i class="fal fa-plus"></i></button>
                                                    </div>


                                                    <div class="form-group col-lg-12">
                                                        <div id="mobile-overflow">
                                                            <table id="" class="table table-bordered table-hover table-striped w-100 mobile-width">
                                                                <thead>
                                                                <tr>
                                                                    <th>{{trans('admin.Date')}}</th>
                                                                    <th>{{trans('admin.Value_Payment')}}</th>
                                                                    <th>{{trans('admin.Action')}}</th>
                                                                </tr>
                                                                </thead>
                                                                <tbody id="data-dt">
                                                                @foreach($payments as $pay)

                                                                    <tr>
                                                                        <td>
                                                                            {{$pay->Date}}
                                                                        </td>

                                                                        <td>
                                                                            {{$pay->Value}}

                                                                            <input type="hidden" name="Date[]" value="{{$pay->Date}}">
                                                                            <input type="hidden" name="Value_Payment[]" value="{{$pay->Value}}">

                                                                        </td>

                                                                        <td>
                                                                            <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                                                        </td>

                                                                    </tr>


                                                                @endforeach



                                                                </tbody>

                                                            </table>
                                                        </div>
                                                    </div>




                                                </div>
                                            </div>





                                            <div class="form-row">
                                                <button type="submit" class="btn btn-primary">
                                                    {{trans('admin.SaveChanges')}}
                                                </button>
                                            </div>

                                        </div>



                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </main>
    <input type="hidden" id="TakeSalary" value="0">
@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>

    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


    <!-- Period -->
    <script>


        function PeriodFun(){

            var Start_Date=$('#Start_Date').val();
            var End_Date=$('#End_Date').val();


            let date1 = new Date(Start_Date);
            let date2 = new Date(End_Date);


// Calculating the time difference
// of two dates
            let Difference_In_Time =
                date2.getTime() - date1.getTime();

// Calculating the no. of days between
// two dates
            let Difference_In_Days =Math.round(Difference_In_Time / (1000 * 3600 * 24));

            $('#Period').val(Difference_In_Days);

        }

    </script>


    <!-- Search Selecet -->
    <script>
        $(document).ready(function () {
            $(function () {
                $(".select2").select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State",
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0,
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items",
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true,
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm;
                    },
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
                }

                $("#Client").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllCli",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return { id: index, text: obj };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {


                            $.ajax({
                                url: 'AllClientsJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#Client').empty();
                                    $.each(data, function(key, value){

                                        $('#Client').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $("#Emp").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });
            });
        });
    </script>

    <!-- Filter Governrate and City !-->
    <script>
        $(document).ready(function() {

            $('#Governrate').on('change', function() {
                var countryId = $(this).val();

                if (countryId) {
                    $.ajax({
                        url: 'GovernrateFilter/' + countryId,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function() {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function(data) {

                            $('#City').empty();

                            $.each(data, function(key, value) {

                                $('#City').append('<option value="' + key + '">' + value + '</option>');

                            });

                            var CIITY = $('#City').val();
                            $.ajax({
                                url: 'CityFilter/' + CIITY,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function() {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function(data) {

                                    $('#Place').empty();

                                    $.each(data, function(key, value) {

                                        $('#Place').append('<option value="' + key + '">' + value + '</option>');

                                    });


                                },
                                complete: function() {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        },
                        complete: function() {
                            $('#loader').css("visibility", "hidden");
                        }
                    });
                } else {

                    $('select[name="states"]').empty();
                }

            });

        });

        $(document).ready(function() {


            var countryId = $('#Governrate').val();
            if (countryId) {
                $.ajax({
                    url: 'GovernrateFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {

                        $('#City').empty();

                        $.each(data, function(key, value) {

                            $('#City').append('<option value="' + key + '">' + value + '</option>');

                        });

                        var CIITY = $('#City').val();
                        $.ajax({
                            url: 'CityFilter/' + CIITY,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {

                                $('#Place').empty();

                                $.each(data, function(key, value) {

                                    $('#Place').append('<option value="' + key + '">' + value + '</option>');

                                });


                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });




                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="states"]').empty();
            }


        });


        $('#City').on('change', function() {
            var CIITY = $('#City').val();
            $.ajax({
                url: 'CityFilter/' + CIITY,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {

                    $('#Place').empty();

                    $.each(data, function(key, value) {

                        $('#Place').append('<option value="' + key + '">' + value + '</option>');

                    });


                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });


        });



        $(document).ready(function() {

            $('.Governrate').on('change', function() {
                var countryId = $(this).val();

                if (countryId) {
                    $.ajax({
                        url: 'GovernrateFilter/' + countryId,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function() {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function(data) {

                            $('.City').empty();

                            $.each(data, function(key, value) {

                                $('.City').append('<option value="' + key + '">' + value + '</option>');

                            });

                            var CIITY = $('.City').val();
                            $.ajax({
                                url: 'CityFilter/' + CIITY,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function() {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function(data) {

                                    $('.Place').empty();

                                    $.each(data, function(key, value) {

                                        $('.Place').append('<option value="' + key + '">' + value + '</option>');

                                    });


                                },
                                complete: function() {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        },
                        complete: function() {
                            $('#loader').css("visibility", "hidden");
                        }
                    });
                } else {

                    $('select[name="states"]').empty();
                }

            });

        });

        $(document).ready(function() {


            var countryId = $('.Governrate').val();
            if (countryId) {
                $.ajax({
                    url: 'GovernrateFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {

                        $('.City').empty();

                        $.each(data, function(key, value) {

                            $('.City').append('<option value="' + key + '">' + value + '</option>');

                        });

                        var CIITY = $('.City').val();
                        $.ajax({
                            url: 'CityFilter/' + CIITY,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {

                                $('.Place').empty();

                                $.each(data, function(key, value) {

                                    $('.Place').append('<option value="' + key + '">' + value + '</option>');

                                });


                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });




                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="states"]').empty();
            }


        });


        $('.City').on('change', function() {
            var CIITY = $('.City').val();
            $.ajax({
                url: 'CityFilter/' + CIITY,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {

                    $('.Place').empty();

                    $.each(data, function(key, value) {

                        $('.Place').append('<option value="' + key + '">' + value + '</option>');

                    });


                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });


        });

    </script>


    <!-- Insert To Table -->
    <script>
        function AddToTable() {



            var Date = document.getElementById("Date").value;
            var Value_Payment = document.getElementById("Value_Payment").value;

            var table = ` <tr>
                            <td>
                            ${Date}
                                </td>

                                <td>
                                ${Value_Payment}

 <input type="hidden" name="Date[]" value="${Date}">
 <input type="hidden" name="Value_Payment[]" value="${Value_Payment}">

                               </td>

                                <td>
                    <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>`;

            document.getElementById("data-dt").innerHTML += table;



            $("#data-dt").on("click", "#Del", function(e) {
                $(this).closest("tr").remove();

            });
        }

        $("#data-dt").on("click", "#Del", function(e) {
            $(this).closest("tr").remove();

        });

    </script>



@endpush
