@extends('admin.index')
@section('content')
@php
use App\Models\ProductsPurchases;
@endphp
    <title>{{$title}}</title>


    @if($Print->Purch_Print_Type == 1)
        <style>
            .page-content {
                color: black !important;
                font-weight:bold;

            }
            @media print {
                @page {
                    size: A4 landscape !important;
                    margin:unset !important;
                    page-break-after:always ;
                    overflow: visible;

                }
                .table-bordered {
                    border: 2px solid black!important;
                }
                .table-bordered th, .table-bordered td {
                    border: 2px solid black !important;
                }
                .table-bordered th, .table-bordered td {
                    border: 2px solid black !important;
                }
            }
            .table-bordered {
                border: 2px solid black!important;
            }
            .table-bordered th, .table-bordered td {
                border: 2px solid black !important;
            }
            .table-bordered th, .table-bordered td {
                border: 2px solid black !important;
            }
        </style>
    @else

        <style>
            .page-content {
                color: black !important;
                font-weight:bold;
            }
            @media print {
                @page {
                    font-size:15px;
                    size: A4 portrait !important;
                    margin:unset !important;
                    page-break-after:always ;
                    overflow: visible;

                }
                .PrintCenter{
                    text-align:center;
                    display: flex;
                    flex-wrap: wrap;
                    justify-content: center;
                    align-items: center;
                    align-content: center;
                }
                .table-bordered {
                    border: 2px solid black!important;
                }
                .table-bordered th, .table-bordered td {
                    border: 2px solid black !important;
                }
                .table-bordered th, .table-bordered td {
                    border: 2px solid black !important;
                }
            }
            .table-bordered {
                border: 2px solid black!important;
            }
            .table-bordered th, .table-bordered td {
                border: 2px solid black !important;
            }
            .table-bordered th, .table-bordered td {
                border: 2px solid black !important;
            }
        </style>
    @endif

    <main id="js-page-content" role="main" class="page-content">


        <!-- data entry -->

        <div class="row hide-table">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="modal-body">
                        <div data-size="A4">
                            <div class="row invoive-info">
                                <div style="text-align: center;" class="col-md-4 col-sm-4 col-4 invoice-client-info">
                                    <div class="style-info">
                                        <h1 style="text-align: center;" class="m-0">
                                            @if(!empty($Def->Name))
                                                {{app()->getLocale() == 'ar' ?$Def->Name :$Def->NameEn}}
                                            @else
                                                {{trans('admin.Klar')}}
                                            @endif
                                        </h1>
                                        <h3 style="text-align: center;" class="m-10">
                                            @if(!empty($Def->Print_Text))
                                                {{app()->getLocale() == 'ar' ?$Def->Print_Text :$Def->Print_Text_En}}
                                            @endif
                                        </h3>
                                    </div>
                                </div>
                                <div style="text-align: center;" class="col-md-4 col-sm-4 col-4 invoice-client-info">
                                    <h1>{{$title}}</h1>
                                </div>
                                <div style="text-align: center;" class="col-md-4 col-sm-4 col-4 invoice-client-info">
                                    <div class="style-info">
                                        @if(!empty($Def->Logo))
                                            <img style="height: 50px; " class="img-fluid" src="{{URL::to($Def->Logo)}}" alt="Logo" />

                                        @else
                                            <img style="height: 50px; " class="img-fluid" src="https://klarerp.com/site/img/theme/logo.png" alt="Logo" />
                                        @endif

                                    </div>
                                </div>
                            </div>
                            <hr />
                            <div class="row"></div>

                            <div class="row">


                              
                                    <div class="col-md-3 col-3">
                                        <h5> {{trans('admin.Code')}} : <span class="style-data">
                                            {{$item->Code}}
                                                </span></h5>
                                    </div>
                          


                                    <div class="col-md-3 col-3">
                                        <h5> {{trans('admin.Date')}}  : <span  class="style-data">{{$item->Date}}</span></h5>
                                    </div>
                       

                                    <div class="col-md-3 col-3">
                                        <h5> {{trans('admin.Coin')}}  : <span  class="style-data">
                                                @if(!empty($item->Coin()->first()->Arabic_Name))
                                           {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}
                                                @endif
                                                    </span></h5>
                                    </div>
                            


                                    <div class="col-md-3 col-3 no-print">
                                        <h5> {{trans('admin.Draw')}}   : <span  class="style-data"> {{$item->Draw}}    </span></h5>
                                    </div>
                           

                              
                                    <div class="col-md-3 col-3">
                                        <h5> {{trans('admin.Payment_Method')}}   : <span  class="style-data">       @if($item->Payment_Method == 'Cash')
                                                    {{trans('admin.Cash')}}
                                                @elseif($item->Payment_Method == 'Later')
                                                    {{trans('admin.Later')}}
                                                @endif      </span></h5>
                                    </div>
                          


                             
                                    <div class="col-md-3 col-3">
                                        <h5> {{trans('admin.Status')}}   : <span  class="style-data">          @if($item->Status == 1)
                                                    {{trans('admin.Recived')}}
                                                @elseif($item->Status == 0)
                                                    {{trans('admin.Pending')}}
                                                @endif     </span></h5>
                                    </div>
                        

                 
                                    <div class="col-md-3 col-3 no-print">
                                        <h5> {{trans('admin.Vendor_Bill_Date')}}   : <span  class="style-data"> {{$item->Vendor_Bill_Date}}    </span></h5>
                                    </div>
                        

                               
                                    <div class="col-md-3 col-3 no-print">
                                        <h5> {{trans('admin.Refernce_Number')}}   : <span  class="style-data"> {{$item->Refernce_Number}}    </span></h5>
                                    </div>
                                

                           
                                    <div class="col-md-3 col-3 no-print">
                                        <h5> {{trans('admin.Safe')}}   : <span  class="style-data">

                                                   @if(!empty($item->Safe()->first()->Name))
                                                    {{app()->getLocale() == 'ar' ?$item->Safe()->first()->Name :$item->Safe()->first()->NameEn}}
                                                @endif
                                                    </span></h5>
                                    </div>
                        

                            

                                    <div class="col-md-3 col-3">
                                        <h5> {{trans('admin.Vendor')}}   : <span  class="style-data">
  @if(!empty($item->Vendor()->first()->Name))
                                                          {{app()->getLocale() == 'ar' ?$item->Vendor()->first()->Name :$item->Vendor()->first()->NameEn}}
                                                @endif
                                                    </span></h5>
                                    </div>
                             

                              
                                    <div class="col-md-3 col-3 no-print">
                                        <h5> {{trans('admin.Delegate')}}   : <span  class="style-data">
                                                     @if(!empty($item->Delegate()->first()->Name))
                                                    {{app()->getLocale() == 'ar' ?$item->Delegate()->first()->Name :$item->Delegate()->first()->NameEn}}
                                                @endif
                                                    </span></h5>
                                    </div>
                         

                           
                                    <div class="col-md-3 col-3 no-print">
                                        <h5> {{trans('admin.Store')}}   : <span  class="style-data">

                                               @if(!empty($item->Store()->first()->Name))
                                                {{app()->getLocale() == 'ar' ?$item->Store()->first()->Name :$item->Store()->first()->NameEn}}
                                                @endif

                                            </span></h5>
                                    </div>
                             


                               
                                    <div class="col-md-3 col-3 no-print">
                                        <h5> {{trans('admin.User')}}   : <span  class="style-data">

                                                @if(!empty($item->User()->first()->name ))
                                                {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                                                @endif

                                            </span></h5>
                                    </div>
                         

                            </div>
                            <div class="row">
                         
                                    <div class="col-md-3 col-3 no-print">
                                        <h5> {{trans('admin.Cost_Center')}} : <span class="style-data">
                                         @if(!empty($item->Cost_Center))

                                                    @if(!empty($item->Cost_Center()->first()->Arabic_Name ))

                                                    {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}

                                                    @endif
                                                @endif
                                         </span></h5>
                                    </div>
                              

                             
                                    <div class="col-md-6 col-6">
                                        <h5> {{trans('admin.Notes')}}   : <span  class="style-data">
                                                {{$item->Note}}
                                                    </span></h5>
                                    </div>
                            
                            </div>
                            <div class="row">
                                <div class="col-sm-4"></div>
                                <div class="col-sm-12 PrintCenter">
                                    <div class="table-responsive-lg">
                                        <table class="table table-bordered mt-5 print only-print" id="X">
                                            <thead>
                                            <tr>
                                               
                                                    <th   class="border-top-0 table-scale-border-bottom fw-700"> {{trans('admin.Code')}}</th>
                                       
                                                    <th   class="border-top-0 table-scale-border-bottom fw-700" style="width: 400px"> {{trans('admin.Name')}}</th>
                              
                                                    <th class="border-top-0 table-scale-border-bottom fw-700">  {{trans('admin.Unit')}} ({{trans('admin.Rate')}})</th>
                
                        
                                                    <th class="border-top-0 table-scale-border-bottom fw-700">  {{trans('admin.Qty')}}</th>
                                        
                                                    <th class="border-top-0 table-scale-border-bottom fw-700"> {{trans('admin.Price')}}</th>
                                       
                                                    <th   class="border-top-0 table-scale-border-bottom fw-700"> {{trans('admin.Discount')}}</th>
                                     
                                                    <th  class="border-top-0 table-scale-border-bottom fw-700"> {{trans('admin.Total_Bf_Tax')}}</th>
                              
                                                    <th class="border-top-0 table-scale-border-bottom fw-700">  {{trans('admin.Total_Tax')}}</th>
                                        
                                                    <th class="border-top-0 table-scale-border-bottom fw-700">  {{trans('admin.Total')}}</th>
                                        
                                                    <th class="border-top-0 table-scale-border-bottom fw-700">  {{trans('admin.The_Net')}}</th>
                                      
                                                    <th class="border-top-0 table-scale-border-bottom fw-700"> {{trans('admin.Store')}}</th>
                                    
                                                    <th class="border-top-0 table-scale-border-bottom fw-700"> {{trans('admin.Exp_Date')}}</th>
                                

                                            </tr>
                                            </thead>



                                            <tbody>
                                            @foreach($details as $detail)
                                                @if($detail->Product()->first()->P_Type != 'Serial')
                                                    <tr>
                                                      
                                                            <td>{{$detail->Product_Code}}</td>
                                                  

                                                    
                                                            <td  style="width: 400px;">

                                                                @if(!empty($detail->Product()->first()->P_Ar_Name))
                                                                {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}
                                                                @endif

                                                                @if(!empty($detail->V1()->first()->Name))   ({{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}}  )  @endif
                                                                @if(!empty($detail->V2()->first()->Name))    (({{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}}  ))  @endif
                                                            </td>
                                                    



                                              

                                                            
                                                            <td>
                                                                    @if(!empty($detail->Unit()->first()->Name))
                                                                
                                                                {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}
                                                        
                                                                    @endif
                                                        </td>
                                                    

                                             
                                                            <td>{{$detail->Qty}}</td>
                                      
                                                            <td>{{$detail->Price}}</td>
                                     
                                                            <td>{{$detail->Discount}}</td>
                                     
                                                            <td>{{$detail->Total_Bf_Tax}}</td>
                                   
                                                            <td>{{$detail->Total_Tax}}</td>
                                                 
                                                            <td>{{$detail->Total}}</td>
                                         
                                                            <td>{{$detail->Total_Net}}</td>
                                     
                                                            <td>

                                                                @if(!empty($detail->Store()->first()->Name))
                                                                    {{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}}
                                                                @endif

                                                            </td>
                                            
                                                            <td>{{$detail->Exp_Date}}</td>
                                                       

                                                    </tr>
                                                @endif
                                            @endforeach




<!-- Serial -->
                                            @foreach($detailsTwo as $detail)
                                                @if($detail->Product()->first()->P_Type == 'Serial')
                                                    @php
                                                        $d=ProductsPurchases::where('Purchase',$item->id)->where('Product',$detail->Product)->orderBy('id','desc')->first();

                                                                    $details=ProductsPurchases::where('Purchase',$item->id)->where('Product',$detail->Product)->get();
                                                                                     $qqqty=0;
                                                                            $Disscc=0;
                                                                            $BFTAX=0;
                                                                            $TOTTAX=0;
                                                                            $TOTAAAAL=0;
                                                                            $TOTAAAALNET=0;
                                                    @endphp


                                                    <tr>

                                                    
                                                            <td>

                                                                <div class="row">
                                                                    @foreach($detailsTwo as $detail)
                                                                        @if($detail->Product()->first()->P_Type == 'Serial')
                                                                            <div class="col-md-12">
                                                                                {{$detail->Product_Code}}
                                                                                @if(!empty($detail->ChassisNumber))     (  {{$detail->ChassisNumber}} )@endif
                                                                                @if(!empty($detail->MotorNumber))     (  {{$detail->MotorNumber}} )@endif



                                                                            </div>
                                                                            @php
                                                                                $qqqty +=$detail->Qty;
                                                                            $Disscc +=$detail->Discount;
                                                                            $BFTAX +=$detail->Total_Bf_Tax;
                                                                            $TOTTAX +=$detail->Total_Tax;
                                                                            $TOTAAAAL +=$detail->Total;
                                                                            $TOTAAAALNET +=$detail->Total_Net;
                                                                            @endphp




                                                                        @endif
                                                                    @endforeach
                                                                </div>

                                                            </td>

                                            


                                                        @if(!empty($d))

                                                        
                                                                <td  style="width: 400px;">

                                                                    @if(!empty($d->Product()->first()->P_Ar_Name))
                                                                    {{app()->getLocale() == 'ar' ?$d->Product()->first()->P_Ar_Name :$d->Product()->first()->P_En_Name}}
                                                                    @endif

                                                                    @if(!empty($d->V1()->first()->Name))   ({{app()->getLocale() == 'ar' ?$d->V1()->first()->Name :$d->V1()->first()->NameEn}}  )  @endif
                                                                    @if(!empty($d->V2()->first()->Name ))    (({{app()->getLocale() == 'ar' ?$d->V2()->first()->Name :$d->V2()->first()->NameEn}}  ))  @endif
                                                                </td>
                                                   



                                                                <td>
                                                                    @if(!empty($d->Unit()->first()->Name))
                                                                    {{app()->getLocale() == 'ar' ?$d->Unit()->first()->Name :$d->Unit()->first()->NameEn}}
                                                                    @endif
                                                                </td>

                                                
                                                                <td>
                                                                    <div class="row">
                                                                        @foreach($details as $detail)
                                                                            @if($detail->Product()->first()->P_Type == 'Serial')
                                                                                <div class="col-md-12">
                                                                                    {{$detail->Qty}}
                                                                                </div>
                                                                            @endif
                                                                        @endforeach
                                                                    </div>
                                                                </td>
                                                         

                                                                <td>
                                                                    <div class="row">
                                                                        @foreach($details as $detail)
                                                                            @if($detail->Product()->first()->P_Type == 'Serial')
                                                                                <div class="col-md-12">
                                                                                    {{$detail->Price}}
                                                                                </div>
                                                                            @endif
                                                                        @endforeach
                                                                    </div>
                                                                </td>
                                                 
                                                                <td>
                                                                    <div class="row">
                                                                        @foreach($details as $detail)
                                                                            @if($detail->Product()->first()->P_Type == 'Serial')
                                                                                <div class="col-md-12">
                                                                                    {{$detail->Discount}}
                                                                                </div>
                                                                            @endif
                                                                        @endforeach
                                                                    </div>

                                                                </td>

                                                                <td>
                                                                    <div class="row">
                                                                        @foreach($details as $detail)
                                                                            @if($detail->Product()->first()->P_Type == 'Serial')
                                                                                <div class="col-md-12">
                                                                                    {{$detail->Total_Bf_Tax}}
                                                                                </div>
                                                                            @endif
                                                                        @endforeach
                                                                    </div>
                                                                </td>

                                                        

                                                                <td>
                                                                    <div class="row">
                                                                        @foreach($details as $detail)
                                                                            @if($detail->Product()->first()->P_Type == 'Serial')
                                                                                <div class="col-md-12">
                                                                                    {{$detail->Total_Tax}}
                                                                                </div>
                                                                            @endif
                                                                        @endforeach
                                                                    </div>
                                                                </td>

                                                      
                                                                <td>

                                                                    <div class="row">
                                                                        @foreach($details as $detail)
                                                                            @if($detail->Product()->first()->P_Type == 'Serial')
                                                                                <div class="col-md-12">
                                                                                    {{$detail->Total}}
                                                                                </div>
                                                                            @endif
                                                                        @endforeach
                                                                    </div>
                                                                </td>
                                             
                                                                    <td>

                                                                        <div class="row">
                                                                            @foreach($details as $detail)
                                                                                @if($detail->Product()->first()->P_Type == 'Serial')
                                                                                    <div class="col-md-12">
                                                                                        {{$detail->Total_Net}}
                                                                                    </div>
                                                                                @endif
                                                                            @endforeach
                                                                        </div>
                                                                    </td>
                                                   
                                                                <td>

                                                                    @if(!empty($d->Store()->first()->Name))
                                                                    {{app()->getLocale() == 'ar' ?$d->Store()->first()->Name :$d->Store()->first()->NameEn}}
                                                                    @endif
                                                                </td>
                                             
                                                                <td>{{$d->Exp_Date}}</td>
                                                     
                                                            @endif

                                                    </tr>



                                              
                                                @endif
                                            @endforeach

                                            </tbody>
                                        </table>
                                        <table class="table table-bordered mt-5">

                                            <tbody>
                                            <tr>

                                                
                                                    <td>{{trans('admin.Product_Numbers')}}</td>
                                                    <td>{{$item->Product_Numbers}}</td>
                               
                                                    <td>{{trans('admin.Total_Qty')}}</td>
                                                    <td>{{$item->Total_Qty}}</td>
                                  
                                                    <td>{{trans('admin.Total_Discount')}}</td>
                                                    <td>{{$item->Total_Discount}}</td>
                                       
                                                    <td>{{trans('admin.Total_Bf_Taxes')}}</td>
                                                    <td>{{$item->Total_BF_Taxes}}</td>
                           
                                                    <td>{{trans('admin.Total_Taxes')}}</td>
                                                    <td>{{$item->Total_Taxes}}</td>
                        
                                                    <td>{{trans('admin.Total_Net')}}</td>
                                                    <td>{{($item->Total_Price +  $item->Total_Taxes)  - $item->Total_Discount}}</td>
                          
                                                    <td>{{trans('admin.Paid')}}</td>
                                                    <td>{{$item->Pay}}</td>
                         
                                                    <td>{{trans('admin.Residual')}}</td>
                                                    <td>{{round($item->Total_Price) - $item->Pay}}</td>
                                            


                                            </tr>
                                            </tbody>
                                        </table>




                                    </div>
                                </div>
                                <div class="col-sm-4"></div>
                            </div>
                        
                                <div class="row">

                                    @if(app()->getLocale() == 'ar' )
                                        @php
                                            $xx=($item->Total_Price + $item->Total_Taxes) - $item->Total_Discount;
                                          $f = new NumberFormatter("ar", NumberFormatter::SPELLOUT);
                               echo $f->format(round($xx));
                                        @endphp
                                    @else
                                        @php
                                            $xx=($item->Total_Price + $item->Total_Taxes) - $item->Total_Discount;
                                          $f = new NumberFormatter("en", NumberFormatter::SPELLOUT);
                               echo $f->format(round($xx));
                                        @endphp
                                    @endif


                                </div>
                         
                            <div class="row" style="display:none;">

                          
                                    <div  class="col-md-6 col-sm-6 col-6 invoice-client-info text-center">
                                        <p class="mt-2 text-muted mb-0">
                                            {{trans('admin.Credit')}} :  <span id="AccountCredit"></span>
                                            <input type="hidden" id="Credit" value="{{$item->Vendor}}">
                                        </p>
                                    </div>
                               

                           
                                    <div class="col-md-6 col-sm-6 col-6 invoice-client-info text-center" >

                                        @php
                                            $x=$item->Code;
                                            $y=DNS1D::getBarcodePNG($x, 'C39');
                                        @endphp
                                        <img src="data:image/png;base64,{{$y}}" id="barcode"  class="height-3 mt-1 " />

                                    </div>
                      


                            </div>
                        </div>
                    </div>

                        <div class="row">

                            @if(!empty($Def->Print_Text_Footer))

                                {!! app()->getLocale() == 'ar' ?$Def->Print_Text_Footer :$Def->Print_Text_Footer_En !!}
                            @endif


                        </div>
         

                        <div class="row">

                            @if(!empty($Def->Seal))

                                <img src="{{URL::to($Def->Seal)}}" class="img-fluid"  />
                            @endif


                        </div>
               


                    <div class="modal-footer">
                        <div class="row">
                            <div class="col-md-9">
                                <a href="{{url('KlarAdmin')}}" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Back')}}</a>
                                <button type="button" class="btn btn-default" onclick="window.print()"><i class="fal fa-print"></i></button>
                            </div>
                            <div class="col-md-3">
                                @if(!empty($item->Edit))
                                    @if($item->Edit == 1)

                                        <img src="{{asset('Admin/Edit.png')}}" class="img-fluid" style="width: 50%" />
                                    @endif
                                @endif
                                @if(!empty($item->Delete))
                                    @if($item->Delete == 1)

                                        <img src="{{asset('Admin/Cancel.png')}}" class="img-fluid" style="width: 50%" />
                                    @endif
                                @endif
                                @if(!empty($item->Transfer))
                                    @if($item->Transfer == 1)

                                        <img src="{{asset('Admin/Tarnsfer.png')}}" class="img-fluid" style="width: 50%" />
                                    @endif
                                @endif
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </main>


@endsection
@push('js')
    <script>window.print()</script>
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">


    <style>
        th{
            width:135px!important;
        }
    </style>

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

    <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                    {
                        placeholder: "Select State"
                    });
                $(".js-hide-search").select2(
                    {
                        minimumResultsForSearch: 1 / 0
                    });
                $(".js-max-length").select2(
                    {
                        maximumSelectionLength: 2,
                        placeholder: "Select maximum 2 items"
                    });
                $(".select2-placeholder").select2(
                    {
                        placeholder: "Select a state",
                        allowClear: true
                    });

                $(".js-select2-icons").select2(
                    {
                        minimumResultsForSearch: 1 / 0,
                        templateResult: icon,
                        templateSelection: icon,
                        escapeMarkup: function(elm)
                        {
                            return elm
                        }
                    });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }

                $(".js-data-example-ajax").select2(
                    {
                        ajax:
                            {
                                url: "https://api.github.com/search/repositories",
                                dataType: 'json',
                                delay: 250,
                                data: function(params)
                                {
                                    return {
                                        q: params.term, // search term
                                        page: params.page
                                    };
                                },
                                processResults: function(data, params)
                                {
                                    // parse the results into the format expected by Select2
                                    // since we are using custom formatting functions we do not need to
                                    // alter the remote JSON data, except to indicate that infinite
                                    // scrolling can be used
                                    params.page = params.page || 1;

                                    return {
                                        results: data.items,
                                        pagination:
                                            {
                                                more: (params.page * 30) < data.total_count
                                            }
                                    };
                                },
                                cache: true
                            },
                        placeholder: 'Search for a repository',
                        escapeMarkup: function(markup)
                        {
                            return markup;
                        }, // let our custom formatter work
                        minimumInputLength: 1,
                        templateResult: formatRepo,
                        templateSelection: formatRepoSelection
                    });

                function formatRepo(repo)
                {
                    if (repo.loading)
                    {
                        return repo.text;
                    }

                    var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                        "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                        "<div class='select2-result-repository__meta'>" +
                        "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

                    if (repo.description)
                    {
                        markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                    }

                    markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                        "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                        "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                        "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                        "</div>" +
                        "</div></div>";

                    return markup;
                }

                function formatRepoSelection(repo)
                {
                    return repo.full_name || repo.text;
                }
            });
        });

    </script>
    <script>
        var autoSave = $('#autoSave');
        var interval;
        var timer = function()
        {
            interval = setInterval(function()
            {
                //start slide...
                if (autoSave.prop('checked'))
                    saveToLocal();

                clearInterval(interval);
            }, 3000);
        };

        //save
        var saveToLocal = function()
        {
            localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
            console.log("saved");
        }

        //delete
        var removeFromLocal = function()
        {
            localStorage.removeItem("summernoteData");
            $('#saveToLocal').summernote('reset');
        }

        $(document).ready(function()
        {
            //init default
            $('.js-summernote').summernote(
                {
                    height: 200,
                    tabsize: 2,
                    placeholder: "Type here...",
                    dialogsFade: true,
                    toolbar: [
                        ['style', ['style']],
                        ['font', ['strikethrough', 'superscript', 'subscript']],
                        ['font', ['bold', 'italic', 'underline', 'clear']],
                        ['fontsize', ['fontsize']],
                        ['fontname', ['fontname']],
                        ['color', ['color']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['height', ['height']]
                            ['table', ['table']],
                        ['insert', ['link', 'picture', 'video']],
                        ['view', ['fullscreen', 'codeview', 'help']]
                    ],
                    callbacks:
                        {
                            //restore from localStorage
                            onInit: function(e)
                            {
                                $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                            },
                            onChange: function(contents, $editable)
                            {
                                clearInterval(interval);
                                timer();
                            }
                        }
                });

            //load emojis
            $.ajax(
                {
                    url: 'https://api.github.com/emojis',
                    async: false
                }).then(function(data)
            {
                window.emojis = Object.keys(data);
                window.emojiUrls = data;
            });

            //init emoji example
            $(".js-hint2emoji").summernote(
                {
                    height: 100,
                    toolbar: false,
                    placeholder: 'type starting with : and any alphabet',
                    hint:
                        {
                            match: /:([\-+\w]+)$/,
                            search: function(keyword, callback)
                            {
                                callback($.grep(emojis, function(item)
                                {
                                    return item.indexOf(keyword) === 0;
                                }));
                            },
                            template: function(item)
                            {
                                var content = emojiUrls[item];
                                return '<img src="' + content + '" width="20" /> :' + item + ':';
                            },
                            content: function(item)
                            {
                                var url = emojiUrls[item];
                                if (url)
                                {
                                    return $('<img />').attr('src', url).css('width', 20)[0];
                                }
                                return '';
                            }
                        }
                });

            //init mentions example
            $(".js-hint2mention").summernote(
                {
                    height: 100,
                    toolbar: false,
                    placeholder: "type starting with @",
                    hint:
                        {
                            mentions: ['jayden', 'sam', 'alvin', 'david'],
                            match: /\B@(\w*)$/,
                            search: function(keyword, callback)
                            {
                                callback($.grep(this.mentions, function(item)
                                {
                                    return item.indexOf(keyword) == 0;
                                }));
                            },
                            content: function(item)
                            {
                                return '@' + item;
                            }
                        }
                });

        });

    </script>
    <script type="text/javascript">


        $(".show-table").click(function(){
            $(".hide-table").show();
        });

    </script>




    <!-- Account Balance -->
    <script>
        $(document).ready(function() {

            var countryId = $('#Credit').val();
            if(countryId) {
                $.ajax({
                    url: 'AccountBalanceFilter/'+countryId,
                    type:"GET",
                    dataType:"json",
                    beforeSend: function(){
                        $('#loader').css("visibility", "visible");
                    },

                    success:function(data) {
                        $.each(data, function(key, value){

                            $('#AccountCredit').text(parseFloat(key).toFixed(2));
                            $('#AccountCredit').text(parseFloat(value).toFixed(2));



                        });
                    },
                    complete: function(){
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="state"]').empty();
            }


        });
    </script>


@endpush


