@extends('admin.index')
@section('content')

<title>{{$title}}</title>

<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Purchases')}} </a></li>
        <li class="breadcrumb-item active">{{$title}} </li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>

    <form id="form" action="{{$urll}}" method="post" enctype="multipart/form-data">
        {!! csrf_field() !!}
        @honeypot

        <input type="hidden" name="ID" value="{{$item->id}}">
        <input type="hidden" name="User" value="{{$item->User}}">
        <div class="row">
            <div class="col-lg-12">
                <div id="panel-2" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i> {{$title}} </i></span>
                        </h2>
                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <div class="form-row">
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                    <input type="text" value="{{$item->Code}}" name="Old_Code" class="form-control " readonly>
                                    <input type="hidden" name="Code" value="{{$Code}}" class="form-control">
                                </div>
                                @if(auth()->guard('admin')->user()->emp == 0)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                                </div>
                                @else

                                @if(auth()->guard('admin')->user()->Date == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                                </div>
                                @else
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required readonly>
                                </div>
                                @endif

                                @endif

                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Store')}}</label>
                                    <select class="select2 form-control w-100" id="store" name="Store" required>

                                        @foreach($Stores as $stor)
                                        <option value="{{$stor->id}}" @if($item->Store == $stor->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                                    <select class="select2 form-control w-100" name="Safe" required>

                                        @foreach($Safes as $safe)
                                        <option value="{{$safe->id}}" @if($item->Safe == $safe->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>

                                @if($show->Coin == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Coin')}}</label>
                                    <select class="select2 form-control w-100" name="Coin" required>
                                        <option value=""> {{trans('admin.Coin')}}</option>
                                        @foreach($Coins as $coin)
                                        <option value="{{$coin->id}}" @if($item->Coin == $coin->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for="">{{trans('admin.Coin')}}</label>
                                    <select class="select2 form-control w-100" name="Coin" required>
                                        <option value=""> {{trans('admin.Coin')}}</option>
                                        @foreach($Coins as $coin)
                                        <option value="{{$coin->id}}" @if($item->Coin == $coin->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @endif

                                @if($show->Draw == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                    <input type="text" name="Draw" value="{{$item->Draw}}" class="form-control" required>
                                </div>
                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                    <input type="text" name="Draw" value="{{$item->Draw}}" class="form-control" required>
                                </div>
                                @endif


                                @if(auth()->guard('admin')->user()->emp != 0)



                                <div class="form-group col-lg-2">
                                    <label class="form-label" for=""> {{trans('admin.Payment_Method')}}</label>
                                    <select class="select2 form-control w-100" name="Payment_Method" id="Payment_Method" onchange="Statuss()" required>
                                        @if(auth()->guard('admin')->user()->Cash == 1)
                                        <option value="Cash" @if($item->Payment_Method == 'Cash') selected @endif>{{trans('admin.Cash')}} </option>
                                        @endif
                                        @if(auth()->guard('admin')->user()->Later == 1)
                                        <option value="Later" @if($item->Payment_Method == 'Later') selected @endif>{{trans('admin.Later')}}</option>
                                        @endif
                                        @if(auth()->guard('admin')->user()->Check == 1)
                                        <option value="Check" @if($item->Payment_Method == 'Check') selected @endif>{{trans('admin.Check')}}</option>
                                        @endif
                                    </select>
                                </div>

                                @else
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for=""> {{trans('admin.Payment_Method')}}</label>
                                    <select class="select2 form-control w-100" name="Payment_Method" id="Payment_Method" onchange="Statuss()" required>
                                        <option value="Cash" @if($item->Payment_Method == 'Cash') selected @endif>{{trans('admin.Cash')}} </option>
                                        <option value="Later" @if($item->Payment_Method == 'Later') selected @endif>{{trans('admin.Later')}}</option>
                                        <option value="Check" @if($item->Payment_Method == 'Check') selected @endif>{{trans('admin.Check')}}</option>
                                    </select>
                                </div>

                                @endif

                                <div class="form-group col-lg-2" id="LaterDate">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Later_Due')}}</label>
                                    <input type="date" name="Later_Due" value="{{$item->Later_Due}}" class="form-control">
                                </div>

                                @if($show->Status == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Status')}}</label>
                                    <select class="select2 form-control w-100" name="Status" onchange="Statuss()" id="Status" required>
                                        <option value="1" @if($item->Status == 1) selected @endif>{{trans('admin.Recived')}} </option>
                                        <option value="0" @if($item->Status == 0) selected @endif>{{trans('admin.Pending')}}</option>
                                    </select>
                                </div>
                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for="">{{trans('admin.Status')}}</label>
                                    <select class="select2 form-control w-100" name="Status" onchange="Statuss()" id="Status" required>
                                        <option value="1" @if($item->Status == 1) selected @endif>{{trans('admin.Recived')}} </option>
                                        <option value="0" @if($item->Status == 0) selected @endif>{{trans('admin.Pending')}}</option>
                                    </select>
                                </div>
                                @endif

                                @if($show->Cost_Center == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for=""> {{trans('admin.Cost_Center')}} </label>
                                    <select class="select2 form-control w-100" name="Cost_Center">
                                        <option value=""> {{trans('admin.Cost_Center')}}</option>
                                        @foreach($CostCenters as $cost)
                                        <option value="{{$cost->id}}" @if($item->Cost_Center == $cost->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for=""> {{trans('admin.Cost_Center')}} </label>
                                    <select class="select2 form-control w-100" name="Cost_Center">
                                        <option value=""> {{trans('admin.Cost_Center')}}</option>
                                        @foreach($CostCenters as $cost)
                                        <option value="{{$cost->id}}" @if($item->Cost_Center == $cost->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @endif

                                @if($show->Delegate_Purchase == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Delegate')}}</label>
                                    <select class="select2 form-control w-100" name="Delegate">
                                        <option value=""> {{trans('admin.Delegate')}}</option>
                                        @foreach($Employess as $emp)
                                        <option value="{{$emp->id}}" @if($item->Delegate == $emp->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for="">{{trans('admin.Delegate')}}</label>
                                    <select class="select2 form-control w-100" name="Delegate">
                                        <option value=""> {{trans('admin.Delegate')}}</option>
                                        @foreach($Employess as $emp)
                                        <option value="{{$emp->id}}" @if($item->Delegate == $emp->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @endif

                                @if($show->Vendor_Date == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Vendor_Bill_Date')}}</label>
                                    <input type="date" name="Vendor_Bill_Date" value="{{$item->Vendor_Bill_Date}}" class="form-control">
                                </div>
                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Vendor_Bill_Date')}}</label>
                                    <input type="date" name="Vendor_Bill_Date" value="{{$item->Vendor_Bill_Date}}" class="form-control">
                                </div>
                                @endif


                                @if($show->Refrence_Number == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Refrence_Number')}}</label>
                                    <input type="text" name="Refernce_Number" value="{{$item->Refernce_Number}}" class="form-control">
                                </div>
                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Refrence_Number')}}</label>
                                    <input type="text" name="Refernce_Number" value="{{$item->Refernce_Number}}" class="form-control">
                                </div>
                                @endif


                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="">{{trans('admin.Account')}} ({{trans('admin.Vendor')}})</label>
                                    <select class="select2 form-control w-100" id="vendor" name="Vendor" required>
                                        <option value="{{$item->Vendor}}">

                                            {{app()->getLocale() == 'ar' ?$item->Vendor()->first()->Name :$item->Vendor()->first()->NameEn}}
                                        </option>
                                    </select>
                                </div>


                                @can('خانه رصيد حساب مورد') @php $credStyle="block"; @endphp @endcan

                                <div class="form-group col-lg-2" style="display: {{$credStyle}}">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Account_Credit')}} </label>
                                    <input type="hidden" id="AccountCredit" value="0" class="form-control " disabled>
                                    <input type="text" value="{{$item->Current_Credit}}" class="form-control " name="Current_Credit" readonly>
                                </div>

                                <div class="form-group col-lg-2" style="display: {{$credStyle}}">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Credit_Limit')}} </label>
                                    <input type="text" id="Credit_Limit"  value="0" class="form-control " readonly>
                                </div>

                                @if($show->Shipping_Company == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Shipping_Compaines')}}</label>
                                    <select class="select2 form-control w-100" name="Ship">
                                        <option value=""> {{trans('admin.Shipping_Compaines')}}</option>
                                        @foreach($Shippings as $ship)
                                        <option value="{{$ship->id}}" @if($item->Ship == $ship->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$ship->Name :$ship->NameEn}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for="">{{trans('admin.Shipping_Compaines')}}</label>
                                    <select class="select2 form-control w-100" name="Ship">
                                        <option value=""> {{trans('admin.Shipping_Compaines')}}</option>
                                        @foreach($Shippings as $ship)
                                        <option value="{{$ship->id}}" @if($item->Ship == $ship->id) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$ship->Name :$ship->NameEn}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>

                                @endif

                                @can('ايقونه اضافه صنف')
                                <div class="form-group col-lg-1 col-3">
                                    <button style="margin: 22px" type="button" class="btn btn-default" data-toggle="modal" data-target="#NewClient">
                                        <i class="fal fa-pen"></i>
                                    </button>

                                    <!-- Modal New Product -->
                                    <div class="modal fade" id="NewClient" tabindex="-1" role="dialog" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">

                                                    <h4 class="modal-body row">


                                                        <div class="form-group col-md-6">
                                                            <label class="form-label" for="">
                                                                {{trans('admin.Product_Type')}}
                                                            </label><span class="strick">*</span>
                                                            <select class="select2 form-control w-100" id="P_Type">
                                                                <option value="Completed">{{trans('admin.Completed')}} </option>
                                                                <option value="Raw">{{trans('admin.Raw')}} </option>
                                                                <option value="Service">{{trans('admin.Service')}}</option>
                                                                <option value="Subscribe">{{trans('admin.Subscribe')}}</option>
                                                                <option value="Industrial">{{trans('admin.Industrial')}}</option>
                                                                <option value="Serial">{{trans('admin.Serial')}}</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label class="form-label" for=""> {{trans('admin.Brand')}} </label>
                                                            <select class="select2 form-control w-100" id="Brand">
                                                                @foreach($Brands as $brand)
                                                                <option value="{{$brand->id}}">

                                                                    {{app()->getLocale() == 'ar' ?$brand->Name :$brand->NameEn}}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-md-4">
                                                            <label class="form-label" for="simpleinput"> {{trans('admin.Product_Ar_Name')}}
                                                            </label><span class="strick">*</span>
                                                            <input type="text" id="P_Ar_Name" placeholder="{{trans('admin.Product_Ar_Name')}} " class="form-control">
                                                        </div>
                                                        <div class="form-group col-md-4">
                                                            <label class="form-label" for="simpleinput"> {{trans('admin.Product_En_Name')}}</label>
                                                            <input type="text" id="P_En_Name" placeholder="{{trans('admin.Product_En_Name')}} " class="form-control">
                                                        </div>
                                                        <div class="form-group col-md-4">
                                                            <label class="form-label" for=""> {{trans('admin.Group')}} </label><span class="strick">*</span>
                                                            <select class="select2 form-control w-100" id="Group">
                                                                @foreach($ItemsGroups as $group)
                                                                <option value="{{$group->id}}">
                                                                    {{app()->getLocale() == 'ar' ?$group->Name :$group->NameEn}}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                            <label class="form-label" for=""> {{trans('admin.Unit')}} </label><span class="strick">*</span>
                                                            <select class="select2 form-control w-100" id="unit">
                                                                @foreach($Units as $uni)
                                                                <option value="{{$uni->id}}">

                                                                    {{app()->getLocale() == 'ar' ?$uni->Name :$uni->NameEn}}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                            <label class="form-label" for="">
                                                                {{trans('admin.Rate')}}
                                                            </label><span class="strick">*</span>
                                                            <input type="number" step="any" id="Rate" class="form-control" value="1" placeholder="{{trans('admin.Rate')}}">
                                                        </div>

                                                        <div class="form-group col-md-4" style="position:relative;">
                                                            <label class="form-label" for="">
                                                                {{trans('admin.Barcode')}}
                                                            </label><span class="strick">*</span>
                                                            <input type="text" id="Barcode" class="form-control" placeholder="{{trans('admin.Barcode')}}">

                                                        </div>
                                                        <div class="form-group col-md-4">
                                                            <label class="form-label" for="">
                                                                {{trans('admin.Price_One')}}
                                                            </label><span class="strick">*</span>
                                                            <input type="number" step="any" id="Price" class="form-control" placeholder=" {{trans('admin.Price_One')}}" value="0">
                                                        </div>
                                                        <div class="form-group col-md-4">
                                                            <label class="form-label" for="">
                                                                {{trans('admin.Price_Two')}}
                                                            </label><span class="strick">*</span>
                                                            <input type="number" step="any" id="Price_Two" class="form-control" placeholder=" {{trans('admin.Price_Two')}}" value="0">
                                                        </div>
                                                        <div class="form-group col-md-4">
                                                            <label class="form-label" for="">
                                                                {{trans('admin.Price_Three')}}
                                                            </label><span class="strick">*</span>
                                                            <input type="number" step="any" id="Price_Three" class="form-control" placeholder=" {{trans('admin.Price_Three')}}" value="0">
                                                        </div>


                                                    </h4>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                                    </button>
                                                </div>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                                                    <button type="button" onclick="NewProducts()" class="btn btn-primary"> {{trans('admin.AddNew')}}</button>
                                                </div>

                                            </div>
                                        </div>
                                    </div>



                                </div>
                                @endcan
                                @can('ايقونه اضافه مورد')
                                <div class="form-group col-lg-1 col-3">
                                    <button style="margin: 22px" type="button" class="btn btn-default" data-toggle="modal" data-target="#NewVend">
                                        <i class="fal fa-user"></i>
                                    </button>

                                    <!-- Modal New Vendor -->
                                    <div class="modal fade" id="NewVend" tabindex="-1" role="dialog" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">

                                                    <h4 class="modal-body row">


                                                        <div class="form-group col-md-2">
                                                            <label class="form-label" for="simpleinput"> {{trans('admin.Code')}}</label>
                                                            <input type="text" id="CODE" value="{{$CodeUser}}" disabled class="form-control">

                                                        </div>
                                                        <div class="form-group col-md-3">
                                                            <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Name')}} </label><span class="strick">*</span>
                                                            <input type="text" id="Name" value="{{old('Name')}}" class="form-control">
                                                        </div>

                                                        <div class="form-group col-md-3">
                                                            <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}} </label><span class="strick">*</span>
                                                            <input type="text" id="NameEn" value="{{old('NameEn')}}" class="form-control">
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                            <label class="form-label" for=""> {{trans('admin.Price_Level')}} </label><span class="strick">*</span>
                                                            <select class="select2 form-control w-100" id="PriceLevel">
                                                                <option value="1"> {{trans('admin.Level1')}} </option>
                                                                <option value="2"> {{trans('admin.Level2')}} </option>
                                                                <option value="3"> {{trans('admin.Level3')}} </option>

                                                            </select>
                                                        </div>

                                                    </h4>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                                    </button>
                                                </div>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                                                    <button type="button" onclick="NewVendor()" class="btn btn-primary"> {{trans('admin.AddNew')}}</button>
                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                </div>
                                @endcan

                                @if($show->Note == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Notes')}} </label>
                                    <input type="text" name="Note" value="{{$item->Note}}" class="form-control">
                                </div>
                                @else
                                <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Notes')}} </label>
                                    <input type="text" name="Note" value="{{$item->Note}}" class="form-control">
                                </div>
                                @endif


                                <input type="hidden" name="Files" value="{{$item->File}}">
                                @if($show->Show_File_Purchases == 1)
                                <div class="form-group col-lg-12">
                                    <label class="form-label" for="simpleinput">{{trans('admin.File')}}</label>
                                    <input type="file" name="File" class="form-control">
                                </div>
                                @endif

                            </div>

                            <div id="CHECK" style="display: none">
                                <div class="row">
                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="">{{trans('admin.Check_Type')}}</label>
                                        <select class="select2 form-control w-100" name="Check_Type" id="Check_Type">
                                            <option value=""> {{trans('admin.Check_Type')}}</option>
                                            @foreach($ChecksTypes as $type)
                                            <option value="{{$type->id}}" @if($type->id == $item->Check_Type) selected @endif>
                                                {{app()->getLocale() == 'ar' ?$type->Arabic_Name :$type->English_Name}}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Due_Date')}} </label>
                                        <input type="date" value="{{$item->Due_Date}}" class="form-control" name="Due_Date" id="Due_Date">
                                    </div>


                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Check_Number')}} </label>
                                        <input type="number" step="any" value="{{$item->Check_Number}}" class="form-control" name="Check_Number" id="Check_Number">
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="form-row">
                        @if($Place == 'Shortcomings')
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Purch_Reason')}}  </label>
                                    <input type="text" name="Purch_Reason" value="{{$item->Purch_Reason}}" class="form-control">
                                </div>

                                @if($show->Manufacturing_Model_Shortcomings == 1)
                                    <div class="form-group col-lg-12" >
                                        <label class="form-label" for="">{{trans('admin.Manufacturing_Model')}}</label>
                                        <select class="select2 form-control w-100" id="Manufacturing" onchange="ModelProd()">
                                            <option value=""> {{trans('admin.Manufacturing_Model')}}</option>
                                            @foreach($Models as $mod)
                                                <option value="{{$mod->id}}">
                                                    {{app()->getLocale() == 'ar' ?$mod->Name :$mod->NameEn}}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                @endif

                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-12">
                <div id="panel-1" class="panel">

                    <div class="panel-container show">
                        <div class="panel-content">
                            <div class="row">
                                @if($show->SearchCode == 1)
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> </label>
                                    <div class="input-items" style="position:relative;">
                                        <input type="text" id="search" class="form-control" placeholder="{{trans('admin.Search_For_Products')}}">
                                        @if(app()->getLocale() == 'ar' )
                                        <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;left:3px;"></i>
                                        @else
                                        <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;right: 0;left:auto;"></i>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> </label>
                                    <div class="input-items" style="position:relative;">
                                        <input type="text" id="SearchCode" class="form-control" placeholder="{{trans('admin.SearchCode')}}">
                                        @if(app()->getLocale() == 'ar' )
                                        <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;left:3px;"></i>
                                        @else
                                        <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;right: 0;left:auto;"></i>
                                        @endif
                                    </div>
                                </div>
                                @else
                                <div class="form-group col-lg-6">
                                    <label class="form-label" for="simpleinput"> </label>
                                    <div class="input-items" style="position:relative;">
                                        <input type="text" id="search" class="form-control" placeholder="{{trans('admin.Search_For_Products')}}">
                                        @if(app()->getLocale() == 'ar' )
                                        <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;left:3px;"></i>
                                        @else
                                        <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;right: 0;left:auto;"></i>
                                        @endif
                                    </div>
                                </div>
                                @endif
                                @if($show->Group_Brand == 1)
                                <div class="form-group col-lg-2 mt-3">
                                    <select class="select2 form-control w-100" id="Brandd">
                                        <option value="">{{trans('admin.Brand')}}</option>
                                        @foreach($Brands as $brand)
                                        <option value="{{$brand->id}}"> {{app()->getLocale() == 'ar' ?$brand->Name :$brand->NameEn}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-lg-2 mt-3">
                                    <select class="select2 form-control w-100" id="Groupp">
                                        <option value="">{{trans('admin.Group')}}</option>
                                        @foreach($ItemsGroups as $group)
                                        <option value="{{$group->id}}">{{app()->getLocale() == 'ar' ?$group->Name :$group->NameEn}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                @endif


                                @if($show->Icon_Payment_Recipt == 1)
                                @can('اضافه سند قبض')
                                <div class="form-group col-lg-1 col-2">
                                    <button type="button" class="btn btn-default pos-icon" data-toggle="modal" data-target="#Recipt">
                                        <a data-toggle="tooltip" data-placement="top" title="{{trans('admin.Recipt_Voucher')}}">
                                            <img src="{{asset('Admin/img/37-approve-checked-simple-outline.gif')}}" alt="">
                                        </a>
                                    </button>
                                </div>
                                @endcan
                                @can('اضافه سند صرف')
                                <div class="form-group col-lg-1 col-2">
                                    <button type="button" class="btn btn-default pos-icon" data-toggle="modal" data-target="#PayVouch">
                                        <a data-toggle="tooltip" data-placement="top" title="{{trans('admin.Payment_Voucher')}}">
                                            <img src="{{asset('Admin/img/290-coin-outline (1).gif')}}" alt="">
                                        </a>
                                    </button>
                                </div>
                                @endcan
                                @endif

                            </div>
                            <div id="mobile-overflow">
                                <table class="table table-bordered table-hover table-striped w-100 mobile-width-more table-color1">
                                    <thead>
                                        <tr>
                                            <th>{{trans('admin.Name')}}</th>
                                            @if($show->Show_Unit == 1)
                                                <th>{{trans('admin.Unit')}}</th>
                                            @endif

                                            @if($show->Show_Barcode == 1)
                                                <th>{{trans('admin.Code')}}</th>
                                            @endif

                                        @if($Place == 'Shortcomings')
                                                <th>{{trans('admin.AvQty')}}</th>
                                            @endif
                                            <th>{{trans('admin.Qty')}}</th>
                                            <th>{{trans('admin.Price')}}</th>
                                            @if($show->Disc == 1)
                                            <th>{{trans('admin.Discount')}}</th>
                                            @endif
                                            @if($show->Tax == 1)
                                            <th>{{trans('admin.Tax')}}</th>
                                            @endif
                                            @if($show->Store == 1)
                                            <th style="padding:12px 20px;">{{trans('admin.Store')}}</th>
                                            @endif
                                            @if($show->Expire_Date == 1)
                                            <th>{{trans('admin.Exp_Date')}}</th>
                                            @endif
                                            <th>{{trans('admin.Actions')}}</th>
                                        </tr>
                                    </thead>
                                    <tbody class="Data" id="Data">

                                    </tbody>
                                </table>
                            </div>
                            <!-- datatable start -->
                            <div id="mobile-overflow">
                                <table id="dt" class="table table-bordered table-hover table-striped w-100 mobile-width table-color2">
                                    <thead>
                                        <tr>
                                            <th>{{trans('admin.Name')}}</th>
                                            @if($show->Show_Unit == 1)
                                                <th>{{trans('admin.Unit')}}</th>
                                            @endif

                                            @if($show->Show_Barcode == 1)
                                                <th>{{trans('admin.Code')}}</th>
                                            @endif

                                        @if($Place == 'Shortcomings')
                                                <th>{{trans('admin.AvQty')}}</th>
                                            @endif
                                            <th>{{trans('admin.Qty')}}</th>
                                            <th>{{trans('admin.Price')}}</th>
                                            @if($show->Disc == 1)
                                            <th>{{trans('admin.Discount')}}</th>
                                            @endif
                                            @if($show->TotalBfTax == 1)
                                            <th>{{trans('admin.Total_Bf_Taxes')}}</th>
                                            @endif
                                            @if($show->Tax == 1)
                                            <th>{{trans('admin.Tax')}}</th>
                                            @endif
                                            @if($show->Show_Total == 1)
                                                <th>{{trans('admin.Total')}}</th>
                                            @endif

                                            @if($show->Show_Net == 1)
                                                <th>{{trans('admin.The_Net')}}</th>
                                            @endif


                                        @if($show->Store == 1)
                                            <th>{{trans('admin.Store')}}</th>
                                            @endif
                                            @if($show->Expire_Date == 1)
                                            <th>{{trans('admin.Exp_Date')}}</th>
                                            @endif
                                            <th>{{trans('admin.Actions')}}</th>
                                        </tr>
                                    </thead>
                                    <tbody id="data-dt">

                                        @if($show->Disc == 1)
                                        @php $disshow=''; @endphp
                                        @else
                                        @php $disshow='none'; @endphp
                                        @endif


                                        @if($show->TotalBfTax == 1)
                                        @php $totbfhow=''; @endphp
                                        @else
                                        @php $totbfhow='none'; @endphp
                                        @endif


                                        @if($show->Tax == 1)
                                        @php $taxshow=''; @endphp
                                        @else
                                        @php $taxshow='none'; @endphp
                                        @endif


                                        @if($show->Store == 1)
                                        @php $storeshow=''; @endphp
                                        @else
                                        @php $storeshow='none'; @endphp
                                        @endif


                                        @foreach($details as $pro)
                                        <tr>
                                            <td>

                                                {{app()->getLocale() == 'ar' ?$pro->Product()->first()->P_Ar_Name :$pro->Product()->first()->P_En_Name}}
                                                <input type='hidden' name='P_Ar_Name[]' value='{{$pro->Product()->first()->P_Ar_Name}}'>
                                                <input type='hidden' name='P_En_Name[]' value='{{$pro->Product()->first()->P_En_Name}}'>

                                                @if(!empty($pro->V1))
                                                ( {{app()->getLocale() == 'ar' ?$pro->V1()->first()->Name :$pro->V1()->first()->NameEn}} )

                                                <input type='hidden' name='VOne[]' value='{{$pro->V1}}'>
                                                <input type='hidden' name='V_Name[]' value='{{$pro->V_Name}}'>

                                                @else
                                                <input type='hidden' name='VOne[]' value=''>
                                                <input type='hidden' name='V_Name[]' value=''>
                                                @endif

                                                @if(!empty($pro->V2))
                                                ( {{app()->getLocale() == 'ar' ?$pro->V2()->first()->Name :$pro->V2()->first()->NameEn}} )
                                                <input type='hidden' name='VTwo[]' value='{{$pro->V2}}'>
                                                <input type='hidden' name='VV_Name[]' value='{{$pro->VV_Name}}'>
                                                @else
                                                <input type='hidden' name='VTwo[]' value=''>
                                                <input type='hidden' name='VV_Name[]' value=''>
                                                @endif

                                            </td>



                                            @if($show->Show_Unit == 1)

                                                <td><input type='hidden' name='Unit[]' value='{{$pro->Unit}}'>{{app()->getLocale() == 'ar' ?$pro->Unit()->first()->Name :$pro->Unit()->first()->NameEn}}</td>

                                            @else
                                                <input type='hidden' name='Unit[]' value='{{$pro->Unit}}'>
                                            @endif

                                            @if($show->Show_Barcode == 1)
                                                <td><input type='hidden' name='P_Code[]' value='{{$pro->Product_Code}}'>

                                                    {{$pro->Product_Code}}
                                                </td>
                                            @else
                                                <input type='hidden' name='P_Code[]' value='{{$pro->Product_Code}}'>

                                            @endif

                                            <input type='hidden' name='ChassisNumber[]' value='{{$pro->ChassisNumber}}'>
                                            <input type='hidden' name='MotorNumber[]' value='{{$pro->MotorNumber}}'>

                                        @if($Place == 'Shortcomings')
                                                <td><input  type='hidden' name='AvQty[]' value='{{$pro->Av_Qty}}'>{{$pro->Av_Qty}}</td>
                                            @endif

                                            <td><input class='Qun' type='hidden' name='Qty[]' value='{{$pro->Qty}}'>{{$pro->Qty}}</td>
                                            <td><input type='hidden' name='Price[]' value='{{$pro->Price}}'>{{$pro->Price}}
                                                <input type='hidden' name='Price_Sale[]' value='{{$pro->Price_Sale}}'>

                                            </td>
                                            <td style="display: {{$disshow}}"><input class='Disc' type='hidden' name='Discount[]' value='{{$pro->Discount}}'><input type='hidden' class='TDISCOOO' name='TDiscPro[]' value='{{$pro->TDiscount}}'>{{$pro->Discount}}</td>
                                            <td style="display: {{$totbfhow}}"><input class='TotalBFTax' type='hidden' name='TotalBFTax[]' value='{{$pro->Total_Bf_Tax}}'>{{$pro->Total_Bf_Tax}}</td>
                                            <td style="display: {{$taxshow}}"><input class='TotalTax' type='hidden' name='TotalTax[]' value='{{$pro->Total_Tax}}'>{{$pro->Total_Tax}}</td>

                                            @if($show->Show_Total == 1)
                                            <td><input class='Tot' type='hidden' name='Total[]' value='{{$pro->Total}}'>{{$pro->Total}}</td>
                                            @else
                                                <input class='Tot' type='hidden' name='Total[]' value='{{$pro->Total}}'>
                                            @endif

                                            @if($show->Show_Net == 1)
                                            <td><input type='hidden' name='Total_Net[]' value='{{$pro->Total_Net}}'>{{$pro->Total_Net}}</td>
                                            @else
                                                <input type='hidden' name='Total_Net[]' value='{{$pro->Total_Net}}'>
                                            @endif

                                            <td style="display: {{$storeshow}}"><input type='hidden' name='StorePurch[]' value='{{$pro->Store}}'> {{app()->getLocale() == 'ar' ?$pro->Store()->first()->Name :$pro->Store()->first()->NameEn}} </td>

                                            @if($show->Expire_Date == 1)

                                            <td>
                                                <input type='date' name='Exp_Date[]' class="form-control" value='{{$pro->Exp_Date}}'>
                                            </td>

                                            @else

                                            <input type='hidden' name='Exp_Date[]' value='{{$pro->Exp_Date}}'>
                                            @endif
                                            <td>
                                                <button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button>
                                                <input type='hidden' name='Product[]' value='{{$pro->Product}}'>

                                                <input type='hidden' name='PurchTax[]' value='{{$pro->Tax}}'>
                                            </td>
                                        </tr>
                                        @endforeach


                                    </tbody>
                                </table>

                                <div class="DataDD"></div>
                            </div>
                            
                            
                                                      
                                    @if($Def->Import_Invoice == 1)
            <div class="col-xl-12" style="display: none">
                <div id="panel-1" class="panel">
                    <div class="panel-container show">
                        <div class="panel-content" style="background: #fad2f796;">
                            
                            
                            <div class="row"> 
                                
             
                          <div class="form-group col-lg-12">        
                                            
                               <h2 class="text-center">
                              
                              {{trans('admin.ImportCosts')}}
                              </h2>             
                                </div>  
                                            
                                            <div class="form-group col-lg-4">
                                    <label class="form-label" for="">{{trans('admin.ImportExpensesTypes')}}</label>
                                    <select class="select2 form-control w-100" id="ImportExpensesTypes">
                                        <option value="">{{trans('admin.ImportExpensesTypes')}}</option>
                                        
                                        @foreach($ImportExpensesTypes as $imp)
                                        <option value="{{$imp->id}}">{{app()->getLocale() == 'ar' ?$imp->Arabic_Name :$imp->English_Name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                        <div class="form-group col-lg-4">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Cost')}}</label>
                                    <input type="number" step="any" id="ImportCost" class="form-control">
                               
                                </div>
                                       
                                        <div class="form-group col-lg-4" style="padding: 18px;">
                            <button type="button" class="btn btn-danger m-1" id="AddCostImport" onclick="Insert()"><i class="fal fa-plus"></i></button>
                               
                                </div>
 
                            </div>
                            <div class="row">
                                
                                  <div id="mobile-overflow">
                                <table id="IMPORTDATA" class="table table-bordered table-hover table-striped w-100 mobile-width table-color2">
                                    <thead>
                                        <tr>
                                            <th>{{trans('admin.Type')}}</th>
                                            <th>{{trans('admin.Cost')}}</th>
                                            <th>{{trans('admin.Actions')}}</th>
                                        </tr>
                                    </thead>
                                    <tbody id="data-import">
                                   
                                @foreach($Importss as $impo)        
                                    <tr> 
                                <td>
                            @if(!empty($impo->Type()->first()->Arabic_Name))        
                        {{app()->getLocale() == 'ar' ?$impo->Type()->first()->Arabic_Name :$impo->Type()->first()->English_Name}}
                            @endif        
                                </td>
                                <td>
                               {{$impo->Cost}}
    
                <input type="hidden" name="ImportExpensesTypes[]" value="{{$impo->Type}}">
    <input type="hidden" name="ImportCost[]" class="IMPORTTOTCOST" value="{{$impo->Cost}}">

                                 </td>
                                <td>
                    <button id="DelImport" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>




                             </tr>   
                            @endforeach            
                                        
                                        
                                        
                                    </tbody>
                                    <tfoot>
                                    <th>{{trans('admin.Total_Cost')}}</th>
                                    <th><input type="text" class="form-control" id="ImportTotalCost" name="ImportTotalCost" value="{{$item->ImportTotalCost}}" readonly></th>
                                    <th></th>
                                    </tfoot>
                                </table>

                      <button type="button" class="btn btn-primary" id="EXBTN" onclick="ExpensesImport()"><i class="fal fa-save"></i>  {{trans('admin.CalculateExpensesPros')}} </button>
                            </div>            
                                
                            </div>
                            
                            
                            
                        </div>
                    </div>
                </div>
            </div>
            @endif
                
                            
                    
                            
                            
                            
                            
                            <!-- datatable end -->
                            <div class="form-row">
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Product_Numbers')}} </label>
                                    <input type="text" id="Product_Numbers" disabled class="form-control">
                                    <input type="hidden" id="Product_NumbersHide" name="Product_Numbers">
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_Qty')}} </label>
                                    <input type="text" id="Total_Qty" disabled class="form-control">
                                    <input type="hidden" id="Total_QtyHide" name="Total_Qty">
                                    <input type="hidden" id="Total_Discount" disabled class="form-control">
                                    <input type="hidden" id="Total_DiscountHide" name="Total_Discount">
                                    <input type="hidden" id="Total_Bf_Taxes" disabled class="form-control">
                                    <input type="hidden" id="Total_Bf_TaxesHide" name="Total_BF_Taxes">
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_Price')}}</label>
                                    <input type="text" id="Total_Price" disabled class="form-control">
                                    <input type="hidden" id="Total_PriceHide" name="Total_Price">
                                </div>

                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_Taxes')}}</label>
                                    <input type="text" id="Total_Taxes" disabled class="form-control">
                                    <input type="hidden" id="Total_TaxesHide" name="Total_Taxes">
                                </div>

                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_After_Taxes')}}</label>
                                    <input type="text" id="Total_After_Taxes" disabled class="form-control">
                                </div>



                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_Discount')}} </label>
                                    <input type="text" id="Total_DiscountTT" disabled class="form-control">
                                    <input type="hidden" id="Total_DiscountHideTT" name="Total_Discount">
                                </div>




                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_af_Discount')}} </label>
                                    <input type="text" class="form-control" id="TAFterD" disabled>

                                </div>




                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_Bill')}} </label>

                                    <input type="text" id="Total_Bill" disabled class="form-control">
                                </div>

                                @if(auth()->guard('admin')->user()->emp == 0)
                                    <div class="form-group col-lg-2">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Discount_Bill')}} </label>
                                        <input type="text" class="form-control" id="resdiual" name="DiscountBill" value="{{$item->DiscountBill}}" onkeyup="Statuss()">
                                    </div>
                                @else

                                    <div class="form-group col-lg-2" @if(auth()->guard('admin')->user()->bill_discount == 0) style="display: none" @endif >
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Discount_Bill')}} </label>
                                        <input type="text" class="form-control" id="resdiual" name="DiscountBill" value="{{$item->DiscountBill}}" onkeyup="Statuss()">
                                    </div>

                                @endif


                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Total_Net')}} </label>

                                    <input type="text" id="Total_PriceW" disabled class="form-control">
                                </div>


                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Paid')}} </label>
                                    <input type="text" name="Pay" id="paid" onchange="PaidCheck()" onkeyup="PaidCheck()" class="form-control">

                                </div>

                            </div>
                            <div class="buttons mt-3" id="Submit" style="display: none">
                                <input type="hidden" id="sp" name="SP">
                                <button type="button" class="btn btn-primary" onclick="SPS()"> <i class="fal fa-folder"></i> {{trans('admin.SaveChanges')}} </button>


                            </div>
                        </div>
                    </div>
                </div>
            </div>



        </div>

    </form>
    @if($Def->Discount == 0)
    <input type="hidden" id="DIS" value="0"> <!-- Number -->
    @else
    <input type="hidden" id="DIS" value="1"> <!-- Precent -->
    @endif
    <input type="hidden" id="ED" value="{{$show->Expire_Date}}">
    <input type="hidden" id="DISCSHOW" value="{{$show->Disc}}">
    <input type="hidden" id="TOTBFSHOW" value="{{$show->TotalBfTax}}">
    <input type="hidden" id="TAXSHOW" value="{{$show->Tax}}">
    <input type="hidden" id="STORESHOW" value="{{$show->Store}}">
    <input type="hidden" id="ALLOFDISC" value="{{$item->Total_Discount}}">

    <input type="hidden" id="Show_Unit" value="{{$show->Show_Unit}}">
    <input type="hidden" id="Show_Barcode" value="{{$show->Show_Barcode}}">
    <input type="hidden" id="Show_Total" value="{{$show->Show_Total}}">
    <input type="hidden" id="Show_Net" value="{{$show->Show_Net}}">
    <input type="hidden" id="Show_Net" value="{{$show->Show_Net}}">
    <input type="hidden" id="Show_Net" value="{{$show->Show_Net}}">
    <input type="hidden" id="ChassisNumber" value="{{$show->ChassisNumber}}">
    <input type="hidden" id="MotorNumber" value="{{$show->MotorNumber}}">
    <input type="hidden" id="Duplicate_Items" value="{{$Def->Duplicate_Items}}">

    <!--         Recipt Voucher modal -->
    <div class="modal fade" id="Recipt" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Receipt_Voucher')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-3">
                            <label>{{trans('admin.Creditor')}}</label>
                            <input type="number" step="any" class="form-control" id="Creditor">
                        </div>
                        <div class="col-md-3">
                            <label>{{trans('admin.Account')}}</label>
                            <select class="select2 form-control w-100" id="AccountCodeF">
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Store')}}</label>
                            <select class="select2 form-control w-100" id="STOREF">
                                @foreach($Stores as $stor)
                                <option value="{{$stor->id}}" @if($Def->Store == $stor->id) selected @endif>
                                    {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                            <select class="select2 form-control w-100" id="SafeF">
                                @foreach($Safes as $safe)
                                <option value="{{$safe->id}}" @if($Def->Safe == $safe->id) selected @endif>
                                    {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <input type="hidden" id="CoinF" value="{{$Def->Coin}}">
                        <input type="hidden" id="DrawF" value="{{$Def->Draw}}">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                    <button type="button" class="btn btn-secondary" id="ReciptVoucher"> {{trans('admin.Save')}}</button>
                </div>
            </div>
        </div>
    </div>
    <!--         Payment Voucher modal -->
    <div class="modal fade" id="PayVouch" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Payment_Voucher')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-3">
                            <label>{{trans('admin.Debitor')}}</label>
                            <input type="number" step="any" class="form-control" id="Debitor">
                        </div>
                        <div class="col-md-3">
                            <label>{{trans('admin.Account')}}</label>
                            <select class="select2 form-control w-100" id="AccountCodee">
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Store')}}</label>
                            <select class="select2 form-control w-100" id="STOREP">
                                @foreach($Stores as $stor)
                                <option value="{{$stor->id}}" @if($Def->Store == $stor->id) selected @endif>
                                    {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                            <select class="select2 form-control w-100" id="SafeP">
                                @foreach($Safes as $safe)
                                <option value="{{$safe->id}}" @if($Def->Safe == $safe->id) selected @endif>
                                    {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <input type="hidden" id="CoinP" value="{{$Def->Coin}}">
                        <input type="hidden" id="DrawP" value="{{$Def->Draw}}">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                    <button type="button" class="btn btn-secondary" id="PaymentVoucher"> {{trans('admin.Save')}}</button>
                </div>
            </div>
        </div>
    </div>


</main>
@if(app()->getLocale() == 'ar' )
<input type="hidden" id="LANG" value="ar">
@else
<input type="hidden" id="LANG" value="en">
@endif


<input type="hidden" id="SHOWHIDEPRO" value="{{$Def->Hide_Product}}">



@endsection

@push('js')

<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>



@if($Place == 'Shortcomings')
    <script src="{{asset('Admin/js/ERP/EditPurchasesShort.js')}}"></script>
@else
    <script src="{{asset('Admin/js/ERP/EditPurchases.js')}}"></script>
@endif




<!-- Import Expenses Function --->
<script>
    function Insert() {
        var Types = document.getElementById("ImportExpensesTypes").value;
        var Cost = document.getElementById("ImportCost").value;
var TypesName = $('#ImportExpensesTypes option:selected').text();

        var table = ` <tr> 
                                <td>
                            ${TypesName}

                                </td>
                                <td>
                                ${Cost}
    
                <input type="hidden" name="ImportExpensesTypes[]" value="${Types}">
    <input type="hidden" name="ImportCost[]" class="IMPORTTOTCOST" value="${Cost}">

                                 </td>
                                <td>
                    <button id="DelImport" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>




                             </tr>`;
        
 
        document.getElementById("data-import").innerHTML += table;

        $("#Types").val("");
        $("#Cost").val("");


        
    

        var sum = 0;
        $(".IMPORTTOTCOST").each(function () {
            sum += parseFloat($(this).val());
        });


        $("#ImportTotalCost").val(sum);



        $("#IMPORTDATA #data-import").on("click", "#DelImport", function (e) {
            $(this).closest("tr").remove();

        
        var sum = 0;
        $(".IMPORTTOTCOST").each(function () {
            sum += parseFloat($(this).val());
        });


        $("#ImportTotalCost").val(sum);

            
        });
        
        
    }
    
 function ExpensesImport(){
 
    var ImportTotalCost = parseFloat($("#ImportTotalCost").val()) || 0;
    var Total_PriceHide = parseFloat($("#Total_PriceHide").val()) || 1;

    var $rows = $("#data-dt tr");
    
    $rows.each(function(index, row) {
        var $row = $(row);

  
        var fullId = $row.find("input[id^='TaxRateD']").attr('id');
        

        var rowId = fullId ? fullId.replace('TaxRateD', '') : null;
        
        if (!rowId) return true; 

        
        var Qty = parseFloat($row.find("input[name='Qty[]']").val()) || 0; 
        var Price = parseFloat($row.find("input[name='Price[]']").val()) || 0; 
        var Total = parseFloat($row.find("input[name='Total[]']").val()) || 0; 
        
   
        if (Qty === 0 || Total_PriceHide === 0) {
            return true;
        }

        var ProPrecent = (Total / Total_PriceHide) * 100;
        var TotalImportExpPro = (ProPrecent / 100) * ImportTotalCost;
        var CostProOne = TotalImportExpPro / Qty;
        var NewPrice = Price + CostProOne;
        
    
        $row.find("input[name='Price[]']").val(parseFloat(NewPrice).toFixed(2));
        
         TotD(rowId);
        
    });
         
         
document.getElementById('EXBTN').style.display='none';
         
}
</script>


@endpush
