@extends('admin.index')
@section('content')
@php
use App\Models\IncomManufacturingModel;
use App\Models\OutcomManufacturingModel;
@endphp
  <title>{{trans('admin.ManufacturingModelSechdule')}}</title>

    <main id="js-page-content" role="main" class="page-content">

                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Manufacturing')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('admin.ManufacturingModelSechdule')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                    <div class="row">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                         <span class="fw-300"><i>{{trans('admin.ManufacturingModelSechdule')}}</i></span>
                                    </h2>

                                    <div class="panel-toolbar">


                     <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                                        @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                                   <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                        <div style="overflow:auto;">
                                        <table
                                            class="table table-bordered table-hover table-striped " >
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Arabic_Name')}}</th>
                                                    <th>{{trans('admin.English_Name')}}</th>
                                                    <th>{{trans('admin.Time')}}</th>
                                                    <th>{{trans('admin.Draw')}}</th>
                                                    <th>{{trans('admin.Notes')}}</th>
                                                    <th>{{trans('admin.Hall')}}</th>
                                                    <th>{{trans('admin.Coin')}}</th>
                                                    <th>{{trans('admin.Workmanship_Price')}}</th>
                                                    <th>{{trans('admin.Cost_Center')}}</th>
                                                    <th>{{trans('admin.User')}}</th>
                                                    <th>{{trans('admin.Income')}}</th>
                                                    <th>{{trans('admin.Outcome')}}</th>
                                                    <th style="width: 200px !important;">{{trans('admin.Actions')}}</th>

                                                </tr>
                                            </thead>
                                            <tbody>

                                            @foreach($items as $item)
                                                <tr>
                                                    <td>{{$item->Code}}</td>
                                                    <td>{{$item->Date}}</td>
                                                    <td>{{$item->Name}}</td>
                                                    <td>{{$item->NameEn}}</td>
                                                    <td>{{$item->Time}}</td>
                                                    <td>{{$item->Draw}}</td>
                                                    <td>{{$item->Note}}</td>


                                                    <td>
                                                    @if(!empty($item->Hall()->first()->Arabic_Name))

                                                 {{app()->getLocale() == 'ar' ?$item->Hall()->first()->Arabic_Name :$item->Hall()->first()->English_Name}}
                                                    @endif
                                                    </td>
                                                    <td>
                                                        @if(!empty($item->Coin()->first()->Arabic_Name))
                                        {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}
                                                        @endif
                                                    </td>

                                                    <td>{{$item->Workmanship_Price}}</td>
                                                    <td>
                                                       @if(!empty($item->Cost_Center()->first()->Arabic_Name))


                                         {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}
                                                    @endif
                                                    </td>


                                                    <td>
                                                        @if(!empty($item->User()->first()->name))
                                        {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                                                        @endif
                                                    </td>

                                                    <td>
                                   <button type="button" class="btn btn-default" data-toggle="modal" data-target="#incom{{$item->id}}"> {{trans('admin.Income')}}</button>
                                                    </td>

                                                    <td>
                                   <button type="button" class="btn btn-default" data-toggle="modal" data-target="#outcom{{$item->id}}"> {{trans('admin.Outcome')}}</button>
                                                    </td>

                                                    <td class="text-center">

                                   <a href="{{url('PrintManufacturingModel/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-print"></i></a>
                                                        @can('حذف نموذج تصنيع')
             <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                                                        @endcan



                                  @can('تعديل نموذج تصنيع')

                                        @if($item->Type == 1)
       <a href="{{url('EditManufacturingModel/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-edit"></i></a>
                                        @else
             <a href="{{url('EditManufacturingModelPrecent/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-edit"></i></a>

                                        @endif
                                                        @endcan


                                                        @if($item->Type == 1)
                                                            <a href="{{url('CopyManufacturingModel/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-copy"></i>  {{trans('admin.Copy')}}</a>
                                                        @else

                                                            <a href="{{url('CopyManufacturingModelPrecent/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-copy"></i>  {{trans('admin.Copy')}}</a>
                                                        @endif





                                                    </td>
                                                </tr>
                                             @endforeach


                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Arabic_Name')}}</th>
                                                    <th>{{trans('admin.English_Name')}}</th>
                                                    <th>{{trans('admin.Time')}}</th>
                                                    <th>{{trans('admin.Draw')}}</th>
                                                    <th>{{trans('admin.Notes')}}</th>
                                                    <th>{{trans('admin.Hall')}}</th>
                                                    <th>{{trans('admin.Coin')}}</th>
                                                    <th>{{trans('admin.Workmanship_Price')}}</th>
                                                    <th>{{trans('admin.Cost_Center')}}</th>
                                                    <th>{{trans('admin.User')}}</th>
                                                    <th>{{trans('admin.Income')}}</th>
                                                    <th>{{trans('admin.Outcome')}}</th>
                                                    <th style="width: 200px !important;">{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                        </div>
                                        {{$items->Links()}}
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


         @foreach($items as $item)



                                <!-- Modal Incom -->
    <div class="modal fade" id="incom{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                               {{trans('admin.Details')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">


                @php
                $details=IncomManufacturingModel::where('Model',$item->id)->get();
                @endphp
                        <div class="mt-3">
                            <table id=""
                            class="table table-bordered table-hover table-striped">
                            <thead>
                                <tr>
                                     <th>{{trans('admin.Name')}}</th>
                                                            <th>{{trans('admin.Unit')}}</th>
                                                            <th>{{trans('admin.Code')}}</th>
                                                            <th>{{trans('admin.Qty')}}</th>
                                                            @if($item->Type == 2)
                                                        <th>{{trans('admin.Precent')}}</th>
                                                            @endif
                                    @can('سعر التكلفة في التصنيع')
                                    <th>{{trans('admin.Price')}}</th>
                                                            <th>{{trans('admin.Discount')}}</th>
                                                            <th>{{trans('admin.Total_Bf_Taxes')}}</th>
                                                            <th>{{trans('admin.Tax')}}</th>
                                                            <th>{{trans('admin.Total')}}</th>
                                   @endcan
                                                            <th>{{trans('admin.Store')}}</th>
                                                            <th>{{trans('admin.Depreciation_Precent')}}%</th>
                                                            <th>{{trans('admin.Depreciation')}}</th>
                                </tr>
                            </thead>
                            <tbody id="">
                                @foreach($details as $detail)
                                <tr>
                                     <td>{{app()->getLocale() == 'ar' ?$detail->P_Ar_Name :$detail->P_En_Name}}</td>
                                    <td>{{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}</td>
                                    <td>{{$detail->Product_Code}}</td>
                                    <td>{{$detail->Qty}}</td>
                                              @if($item->Type == 2)
                                    <td>{{$detail->Precent}}</td>
                                    @endif
                                    @can('سعر التكلفة في التصنيع')
                                    <td>{{$detail->Cost}}</td>
                                    <td>{{$detail->Discount}}</td>
                                    <td> {{round($detail->Total_Bf_Tax)}}</td>
                                    <td>{{app()->getLocale() == 'ar' ?$detail->Tax()->first()->Name :$detail->Tax()->first()->NameEn}}</td>
                                    <td> {{round($detail->Total)}}</td>
                                    @endcan
                                    <td>
                        {{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}}
                                    </td>
                                    <td>{{round($detail->Depreciation)}}</td>
                                    <td>{{round($detail->Depreciation_Qty)}}</td>

                                </tr>
                                 @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                             <th>{{trans('admin.Name')}}</th>
                                                            <th>{{trans('admin.Unit')}}</th>
                                                            <th>{{trans('admin.Code')}}</th>
                                                            <th>{{trans('admin.Qty')}}</th>
                                                            @if($item->Type == 2)
                                                        <th>{{trans('admin.Precent')}}</th>
                                                            @endif

                                    @can('سعر التكلفة في التصنيع')
                                    <th>{{trans('admin.Price')}}</th>
                                                            <th>{{trans('admin.Discount')}}</th>
                                                            <th>{{trans('admin.Total_Bf_Taxes')}}</th>
                                                            <th>{{trans('admin.Tax')}}</th>
                                                            <th>{{trans('admin.Total')}}</th>
                                    @endcan
                                                            <th>{{trans('admin.Store')}}</th>
                                                            <th>{{trans('admin.Depreciation_Precent')}}%</th>
                                                            <th>{{trans('admin.Depreciation')}}</th>
                                </tr>
                            </tfoot>
                        </table>
                        <table class="table table-bordered table-hover table-striped w-100 mt-4">
                            <tbody>
                                <tr>
                                    <td>{{trans('admin.Product_Numbers')}}</td>
                                    <td>{{$item->Product_Numbers}}</td>

                                    @can('سعر التكلفة في التصنيع')
                                    <td>{{trans('admin.Total_Discount')}}</td>
                                    <td>{{$item->Total_Discount}}</td>

                                     <td>{{trans('admin.Total_Bf_Taxes')}}</td>
                                    <td>{{ROUND($item->Total_BF_Taxes)}}</td>

                                    <td>{{trans('admin.Total_Taxes')}}</td>
                                    <td>{{$item->Total_Taxes}}</td>

                                    <td>{{trans('admin.Total_Price')}}</td>
                                    <td>{{round($item->Total_Price)}}</td>
                                        @endcan

                                </tr>
                            </tbody>
                        </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

            </div>

                 <!-- Modal Outcom -->
            <div class="modal fade" id="outcom{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                               {{trans('admin.Details')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">


                @php
                $details=OutcomManufacturingModel::where('Model',$item->id)->get();
                @endphp
                        <div class="mt-3">
                            <table id=""
                            class="table table-bordered table-hover table-striped">
                            <thead>
                                <tr>
                                                            <th>{{trans('admin.Name')}}</th>
                                                            <th>{{trans('admin.Unit')}}</th>
                                                            <th>{{trans('admin.Code')}}</th>
                                                            <th>{{trans('admin.Qty')}}</th>
                                    @can('سعر التكلفة في التصنيع')
                                    <th>{{trans('admin.Cost')}}</th>
                                    @endcan
                                                            <th>{{trans('admin.Store')}}</th>
                                </tr>
                            </thead>
                            <tbody id="">
                                @foreach($details as $detail)
                                <tr>
                                     <td>{{app()->getLocale() == 'ar' ?$detail->P_Ar_Name :$detail->P_En_Name}}</td>
                                    <td>{{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}</td>
                                    <td>{{$detail->Product_Code}}</td>
                                    <td>{{$detail->Qty}}</td>
                                    @can('سعر التكلفة في التصنيع')
                                    <td>{{$detail->Cost}}</td>
                                    @endcan
                                    <td>     {{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}}     </td>

                                </tr>
                                 @endforeach
                            </tbody>

                        </table>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

            </div>

                      <!-- Modal Delete -->
     <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                          {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                   <a href="{{url('DeleteManufacturingModel/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>

        @endforeach
                </main>

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
   <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
@endpush

